# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from fastfuels_sdk.client_library.models.tree_inventory_modification_cr_condition import TreeInventoryModificationCRCondition
from fastfuels_sdk.client_library.models.tree_inventory_modification_dia_condition import TreeInventoryModificationDIACondition
from fastfuels_sdk.client_library.models.tree_inventory_modification_expression_condition import TreeInventoryModificationExpressionCondition
from fastfuels_sdk.client_library.models.tree_inventory_modification_ht_condition import TreeInventoryModificationHTCondition
from fastfuels_sdk.client_library.models.tree_inventory_modification_spcd_condition import TreeInventoryModificationSPCDCondition
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

TREEINVENTORYMODIFICATIONCONDITION_ONE_OF_SCHEMAS = ["TreeInventoryModificationCRCondition", "TreeInventoryModificationDIACondition", "TreeInventoryModificationExpressionCondition", "TreeInventoryModificationHTCondition", "TreeInventoryModificationSPCDCondition"]

class TreeInventoryModificationCondition(BaseModel):
    """
    Conditions for filtering trees. Supports single fields (HT, DIA, CR, SPCD) or arithmetic expressions.
    """
    # data type: TreeInventoryModificationSPCDCondition
    oneof_schema_1_validator: Optional[TreeInventoryModificationSPCDCondition] = None
    # data type: TreeInventoryModificationHTCondition
    oneof_schema_2_validator: Optional[TreeInventoryModificationHTCondition] = None
    # data type: TreeInventoryModificationDIACondition
    oneof_schema_3_validator: Optional[TreeInventoryModificationDIACondition] = None
    # data type: TreeInventoryModificationCRCondition
    oneof_schema_4_validator: Optional[TreeInventoryModificationCRCondition] = None
    # data type: TreeInventoryModificationExpressionCondition
    oneof_schema_5_validator: Optional[TreeInventoryModificationExpressionCondition] = None
    actual_instance: Optional[Union[TreeInventoryModificationCRCondition, TreeInventoryModificationDIACondition, TreeInventoryModificationExpressionCondition, TreeInventoryModificationHTCondition, TreeInventoryModificationSPCDCondition]] = None
    one_of_schemas: Set[str] = { "TreeInventoryModificationCRCondition", "TreeInventoryModificationDIACondition", "TreeInventoryModificationExpressionCondition", "TreeInventoryModificationHTCondition", "TreeInventoryModificationSPCDCondition" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = TreeInventoryModificationCondition.model_construct()
        error_messages = []
        match = 0
        # validate data type: TreeInventoryModificationSPCDCondition
        if not isinstance(v, TreeInventoryModificationSPCDCondition):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationSPCDCondition`")
        else:
            match += 1
        # validate data type: TreeInventoryModificationHTCondition
        if not isinstance(v, TreeInventoryModificationHTCondition):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationHTCondition`")
        else:
            match += 1
        # validate data type: TreeInventoryModificationDIACondition
        if not isinstance(v, TreeInventoryModificationDIACondition):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationDIACondition`")
        else:
            match += 1
        # validate data type: TreeInventoryModificationCRCondition
        if not isinstance(v, TreeInventoryModificationCRCondition):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationCRCondition`")
        else:
            match += 1
        # validate data type: TreeInventoryModificationExpressionCondition
        if not isinstance(v, TreeInventoryModificationExpressionCondition):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationExpressionCondition`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in TreeInventoryModificationCondition with oneOf schemas: TreeInventoryModificationCRCondition, TreeInventoryModificationDIACondition, TreeInventoryModificationExpressionCondition, TreeInventoryModificationHTCondition, TreeInventoryModificationSPCDCondition. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in TreeInventoryModificationCondition with oneOf schemas: TreeInventoryModificationCRCondition, TreeInventoryModificationDIACondition, TreeInventoryModificationExpressionCondition, TreeInventoryModificationHTCondition, TreeInventoryModificationSPCDCondition. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into TreeInventoryModificationSPCDCondition
        try:
            instance.actual_instance = TreeInventoryModificationSPCDCondition.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TreeInventoryModificationHTCondition
        try:
            instance.actual_instance = TreeInventoryModificationHTCondition.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TreeInventoryModificationDIACondition
        try:
            instance.actual_instance = TreeInventoryModificationDIACondition.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TreeInventoryModificationCRCondition
        try:
            instance.actual_instance = TreeInventoryModificationCRCondition.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TreeInventoryModificationExpressionCondition
        try:
            instance.actual_instance = TreeInventoryModificationExpressionCondition.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into TreeInventoryModificationCondition with oneOf schemas: TreeInventoryModificationCRCondition, TreeInventoryModificationDIACondition, TreeInventoryModificationExpressionCondition, TreeInventoryModificationHTCondition, TreeInventoryModificationSPCDCondition. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TreeInventoryModificationCondition with oneOf schemas: TreeInventoryModificationCRCondition, TreeInventoryModificationDIACondition, TreeInventoryModificationExpressionCondition, TreeInventoryModificationHTCondition, TreeInventoryModificationSPCDCondition. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], TreeInventoryModificationCRCondition, TreeInventoryModificationDIACondition, TreeInventoryModificationExpressionCondition, TreeInventoryModificationHTCondition, TreeInventoryModificationSPCDCondition]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


