# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from fastfuels_sdk.client_library.models.tree_inventory_modification_cr_action import TreeInventoryModificationCRAction
from fastfuels_sdk.client_library.models.tree_inventory_modification_dia_action import TreeInventoryModificationDIAAction
from fastfuels_sdk.client_library.models.tree_inventory_modification_ht_action import TreeInventoryModificationHTAction
from fastfuels_sdk.client_library.models.tree_inventory_modification_remove_action import TreeInventoryModificationRemoveAction
from fastfuels_sdk.client_library.models.tree_inventory_modification_spcd_action import TreeInventoryModificationSPCDAction
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

TREEINVENTORYMODIFICATIONACTION_ANY_OF_SCHEMAS = ["TreeInventoryModificationCRAction", "TreeInventoryModificationDIAAction", "TreeInventoryModificationHTAction", "TreeInventoryModificationRemoveAction", "TreeInventoryModificationSPCDAction"]

class TreeInventoryModificationAction(BaseModel):
    """
    Actions to apply to trees. Use modifier='remove' to remove trees.
    """

    # data type: TreeInventoryModificationSPCDAction
    anyof_schema_1_validator: Optional[TreeInventoryModificationSPCDAction] = None
    # data type: TreeInventoryModificationHTAction
    anyof_schema_2_validator: Optional[TreeInventoryModificationHTAction] = None
    # data type: TreeInventoryModificationDIAAction
    anyof_schema_3_validator: Optional[TreeInventoryModificationDIAAction] = None
    # data type: TreeInventoryModificationCRAction
    anyof_schema_4_validator: Optional[TreeInventoryModificationCRAction] = None
    # data type: TreeInventoryModificationRemoveAction
    anyof_schema_5_validator: Optional[TreeInventoryModificationRemoveAction] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[TreeInventoryModificationCRAction, TreeInventoryModificationDIAAction, TreeInventoryModificationHTAction, TreeInventoryModificationRemoveAction, TreeInventoryModificationSPCDAction]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "TreeInventoryModificationCRAction", "TreeInventoryModificationDIAAction", "TreeInventoryModificationHTAction", "TreeInventoryModificationRemoveAction", "TreeInventoryModificationSPCDAction" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = TreeInventoryModificationAction.model_construct()
        error_messages = []
        # validate data type: TreeInventoryModificationSPCDAction
        if not isinstance(v, TreeInventoryModificationSPCDAction):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationSPCDAction`")
        else:
            return v

        # validate data type: TreeInventoryModificationHTAction
        if not isinstance(v, TreeInventoryModificationHTAction):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationHTAction`")
        else:
            return v

        # validate data type: TreeInventoryModificationDIAAction
        if not isinstance(v, TreeInventoryModificationDIAAction):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationDIAAction`")
        else:
            return v

        # validate data type: TreeInventoryModificationCRAction
        if not isinstance(v, TreeInventoryModificationCRAction):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationCRAction`")
        else:
            return v

        # validate data type: TreeInventoryModificationRemoveAction
        if not isinstance(v, TreeInventoryModificationRemoveAction):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TreeInventoryModificationRemoveAction`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in TreeInventoryModificationAction with anyOf schemas: TreeInventoryModificationCRAction, TreeInventoryModificationDIAAction, TreeInventoryModificationHTAction, TreeInventoryModificationRemoveAction, TreeInventoryModificationSPCDAction. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[TreeInventoryModificationSPCDAction] = None
        try:
            instance.actual_instance = TreeInventoryModificationSPCDAction.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[TreeInventoryModificationHTAction] = None
        try:
            instance.actual_instance = TreeInventoryModificationHTAction.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[TreeInventoryModificationDIAAction] = None
        try:
            instance.actual_instance = TreeInventoryModificationDIAAction.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[TreeInventoryModificationCRAction] = None
        try:
            instance.actual_instance = TreeInventoryModificationCRAction.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[TreeInventoryModificationRemoveAction] = None
        try:
            instance.actual_instance = TreeInventoryModificationRemoveAction.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TreeInventoryModificationAction with anyOf schemas: TreeInventoryModificationCRAction, TreeInventoryModificationDIAAction, TreeInventoryModificationHTAction, TreeInventoryModificationRemoveAction, TreeInventoryModificationSPCDAction. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], TreeInventoryModificationCRAction, TreeInventoryModificationDIAAction, TreeInventoryModificationHTAction, TreeInventoryModificationRemoveAction, TreeInventoryModificationSPCDAction]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


