# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from fastfuels_sdk.client_library.models.domain import Domain
from typing import Optional, Set
from typing_extensions import Self

class ListDomainResponse(BaseModel):
    """
    Paginated response for listing domain resources.
    """ # noqa: E501
    current_page: StrictInt = Field(description="The current page number.", alias="currentPage")
    page_size: StrictInt = Field(description="The number of resources per page.", alias="pageSize")
    total_items: StrictInt = Field(description="The total number of resources.", alias="totalItems")
    domains: List[Domain] = Field(description="A list of domain resources.")
    __properties: ClassVar[List[str]] = ["currentPage", "pageSize", "totalItems", "domains"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListDomainResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in domains (list)
        _items = []
        if self.domains:
            for _item_domains in self.domains:
                if _item_domains:
                    _items.append(_item_domains.to_dict())
            _dict['domains'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListDomainResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currentPage": obj.get("currentPage"),
            "pageSize": obj.get("pageSize"),
            "totalItems": obj.get("totalItems"),
            "domains": [Domain.from_dict(_item) for _item in obj["domains"]] if obj.get("domains") is not None else None
        })
        return _obj


