# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from fastfuels_sdk.client_library.models.feature_grid import FeatureGrid
from fastfuels_sdk.client_library.models.surface_grid import SurfaceGrid
from fastfuels_sdk.client_library.models.topography_grid import TopographyGrid
from fastfuels_sdk.client_library.models.tree_grid import TreeGrid
from typing import Optional, Set
from typing_extensions import Self

class Grids(BaseModel):
    """
    Grids
    """ # noqa: E501
    tree: Optional[TreeGrid] = None
    surface: Optional[SurfaceGrid] = None
    topography: Optional[TopographyGrid] = None
    feature: Optional[FeatureGrid] = None
    __properties: ClassVar[List[str]] = ["tree", "surface", "topography", "feature"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Grids from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tree
        if self.tree:
            _dict['tree'] = self.tree.to_dict()
        # override the default output from pydantic by calling `to_dict()` of surface
        if self.surface:
            _dict['surface'] = self.surface.to_dict()
        # override the default output from pydantic by calling `to_dict()` of topography
        if self.topography:
            _dict['topography'] = self.topography.to_dict()
        # override the default output from pydantic by calling `to_dict()` of feature
        if self.feature:
            _dict['feature'] = self.feature.to_dict()
        # set to None if tree (nullable) is None
        # and model_fields_set contains the field
        if self.tree is None and "tree" in self.model_fields_set:
            _dict['tree'] = None

        # set to None if surface (nullable) is None
        # and model_fields_set contains the field
        if self.surface is None and "surface" in self.model_fields_set:
            _dict['surface'] = None

        # set to None if topography (nullable) is None
        # and model_fields_set contains the field
        if self.topography is None and "topography" in self.model_fields_set:
            _dict['topography'] = None

        # set to None if feature (nullable) is None
        # and model_fields_set contains the field
        if self.feature is None and "feature" in self.model_fields_set:
            _dict['feature'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Grids from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tree": TreeGrid.from_dict(obj["tree"]) if obj.get("tree") is not None else None,
            "surface": SurfaceGrid.from_dict(obj["surface"]) if obj.get("surface") is not None else None,
            "topography": TopographyGrid.from_dict(obj["topography"]) if obj.get("topography") is not None else None,
            "feature": FeatureGrid.from_dict(obj["feature"]) if obj.get("feature") is not None else None
        })
        return _obj


