# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from fastfuels_sdk.client_library.models.road_feature import RoadFeature
from fastfuels_sdk.client_library.models.water_feature import WaterFeature
from typing import Optional, Set
from typing_extensions import Self

class Features(BaseModel):
    """
    Features
    """ # noqa: E501
    road: Optional[RoadFeature] = None
    water: Optional[WaterFeature] = None
    __properties: ClassVar[List[str]] = ["road", "water"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Features from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of road
        if self.road:
            _dict['road'] = self.road.to_dict()
        # override the default output from pydantic by calling `to_dict()` of water
        if self.water:
            _dict['water'] = self.water.to_dict()
        # set to None if road (nullable) is None
        # and model_fields_set contains the field
        if self.road is None and "road" in self.model_fields_set:
            _dict['road'] = None

        # set to None if water (nullable) is None
        # and model_fields_set contains the field
        if self.water is None and "water" in self.model_fields_set:
            _dict['water'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Features from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "road": RoadFeature.from_dict(obj["road"]) if obj.get("road") is not None else None,
            "water": WaterFeature.from_dict(obj["water"]) if obj.get("water") is not None else None
        })
        return _obj


