# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from fastfuels_sdk.client_library.models.geo_json_crs import GeoJsonCRS
from fastfuels_sdk.client_library.models.geo_json_feature import GeoJSONFeature
from typing import Optional, Set
from typing_extensions import Self

class Domain(BaseModel):
    """
    Represents a domain resource.
    """ # noqa: E501
    type: Optional[StrictStr] = 'FeatureCollection'
    features: Annotated[List[GeoJSONFeature], Field(min_length=1)]
    name: Optional[StrictStr] = Field(default='', description="The name of the domain.")
    description: Optional[StrictStr] = Field(default='', description="A brief description of the domain.")
    horizontal_resolution: Optional[Union[StrictFloat, StrictInt]] = Field(default=2.0, description="The horizontal resolution in meters of a regular grid representation of the domain.", alias="horizontalResolution")
    vertical_resolution: Optional[Union[StrictFloat, StrictInt]] = Field(default=1.0, description="The vertical resolution in meters of a regular grid representation of the domain.", alias="verticalResolution")
    crs: Optional[GeoJsonCRS] = Field(default=None, description="The GeoJSON specification formatted coordinate reference system (CRS) of the domain.")
    tags: Optional[List[StrictStr]] = None
    id: Optional[StrictStr] = Field(default=None, description="A unique identifier for the domain.")
    created_on: datetime = Field(description="The date and time the domain was created.", alias="createdOn")
    modified_on: datetime = Field(description="The date and time the domain was last modified.", alias="modifiedOn")
    __properties: ClassVar[List[str]] = ["type", "features", "name", "description", "horizontalResolution", "verticalResolution", "crs", "tags", "id", "createdOn", "modifiedOn"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FeatureCollection']):
            raise ValueError("must be one of enum values ('FeatureCollection')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Domain from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            mode='json',
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in features (list)
        _items = []
        if self.features:
            for _item_features in self.features:
                if _item_features:
                    _items.append(_item_features.to_dict())
            _dict['features'] = _items
        # override the default output from pydantic by calling `to_dict()` of crs
        if self.crs:
            _dict['crs'] = self.crs.to_dict()
        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Domain from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'FeatureCollection',
            "features": [GeoJSONFeature.from_dict(_item) for _item in obj["features"]] if obj.get("features") is not None else None,
            "name": obj.get("name") if obj.get("name") is not None else '',
            "description": obj.get("description") if obj.get("description") is not None else '',
            "horizontalResolution": obj.get("horizontalResolution") if obj.get("horizontalResolution") is not None else 2.0,
            "verticalResolution": obj.get("verticalResolution") if obj.get("verticalResolution") is not None else 1.0,
            "crs": GeoJsonCRS.from_dict(obj["crs"]) if obj.get("crs") is not None else None,
            "tags": obj.get("tags"),
            "id": obj.get("id"),
            "createdOn": obj.get("createdOn"),
            "modifiedOn": obj.get("modifiedOn")
        })
        return _obj


