# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from fastfuels_sdk.client_library.models.feature_type import FeatureType
from fastfuels_sdk.client_library.models.tree_inventory_modification import TreeInventoryModification
from fastfuels_sdk.client_library.models.tree_inventory_source import TreeInventorySource
from fastfuels_sdk.client_library.models.tree_inventory_treatment import TreeInventoryTreatment
from fastfuels_sdk.client_library.models.tree_map_source import TreeMapSource
from typing import Optional, Set
from typing_extensions import Self

class CreateTreeInventoryRequest(BaseModel):
    """
    CreateTreeInventoryRequest
    """ # noqa: E501
    sources: Annotated[List[TreeInventorySource], Field(min_length=1, max_length=1)] = Field(description="The data sources used to build the tree inventory. Currently, only one data source at a time is supported.")
    tree_map: Optional[TreeMapSource] = Field(default=None, alias="TreeMap")
    modifications: Optional[Annotated[List[TreeInventoryModification], Field(max_length=1000)]] = Field(default=None, description="List of modifications to apply to the tree inventory data")
    treatments: Optional[Annotated[List[TreeInventoryTreatment], Field(max_length=1000)]] = Field(default=None, description="List of silvicultural treatments to apply.")
    feature_masks: Optional[List[FeatureType]] = Field(default=None, description="List of Features to mask tree inventory data. This has the effect of removing trees that intersect with the feature.", alias="featureMasks")
    __properties: ClassVar[List[str]] = ["sources", "TreeMap", "modifications", "treatments", "featureMasks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateTreeInventoryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tree_map
        if self.tree_map:
            _dict['TreeMap'] = self.tree_map.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in modifications (list)
        _items = []
        if self.modifications:
            for _item_modifications in self.modifications:
                if _item_modifications:
                    _items.append(_item_modifications.to_dict())
            _dict['modifications'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in treatments (list)
        _items = []
        if self.treatments:
            for _item_treatments in self.treatments:
                if _item_treatments:
                    _items.append(_item_treatments.to_dict())
            _dict['treatments'] = _items
        # set to None if tree_map (nullable) is None
        # and model_fields_set contains the field
        if self.tree_map is None and "tree_map" in self.model_fields_set:
            _dict['TreeMap'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateTreeInventoryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sources": obj.get("sources"),
            "TreeMap": TreeMapSource.from_dict(obj["TreeMap"]) if obj.get("TreeMap") is not None else None,
            "modifications": [TreeInventoryModification.from_dict(_item) for _item in obj["modifications"]] if obj.get("modifications") is not None else None,
            "treatments": [TreeInventoryTreatment.from_dict(_item) for _item in obj["treatments"]] if obj.get("treatments") is not None else None,
            "featureMasks": obj.get("featureMasks")
        })
        return _obj


