# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from fastfuels_sdk.client_library.models.tree_grid_attribute import TreeGridAttribute
from fastfuels_sdk.client_library.models.tree_grid_bulk_density_source import TreeGridBulkDensitySource
from fastfuels_sdk.client_library.models.tree_grid_savr_source import TreeGridSAVRSource
from fastfuels_sdk.client_library.models.tree_grid_spcd_source import TreeGridSPCDSource
from fastfuels_sdk.client_library.models.tree_grid_uniform_value import TreeGridUniformValue
from typing import Optional, Set
from typing_extensions import Self

class CreateTreeGridRequest(BaseModel):
    """
    The request used to create a tree grid.
    """ # noqa: E501
    attributes: Optional[List[TreeGridAttribute]] = Field(default=None, description="List of attributes to include in the tree grid. Each attribute is a separate layer in the grid. Attributes present in the list will be assigned default values unless an additional field is provided.")
    bulk_density: Optional[TreeGridBulkDensitySource] = Field(default=None, alias="bulkDensity")
    fuel_moisture: Optional[TreeGridUniformValue] = Field(default=None, alias="fuelMoisture")
    spcd: Optional[TreeGridSPCDSource] = Field(default=None, alias="SPCD")
    savr: Optional[TreeGridSAVRSource] = Field(default=None, alias="SAVR")
    __properties: ClassVar[List[str]] = ["attributes", "bulkDensity", "fuelMoisture", "SPCD", "SAVR"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateTreeGridRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bulk_density
        if self.bulk_density:
            _dict['bulkDensity'] = self.bulk_density.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fuel_moisture
        if self.fuel_moisture:
            _dict['fuelMoisture'] = self.fuel_moisture.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spcd
        if self.spcd:
            _dict['SPCD'] = self.spcd.to_dict()
        # override the default output from pydantic by calling `to_dict()` of savr
        if self.savr:
            _dict['SAVR'] = self.savr.to_dict()
        # set to None if bulk_density (nullable) is None
        # and model_fields_set contains the field
        if self.bulk_density is None and "bulk_density" in self.model_fields_set:
            _dict['bulkDensity'] = None

        # set to None if fuel_moisture (nullable) is None
        # and model_fields_set contains the field
        if self.fuel_moisture is None and "fuel_moisture" in self.model_fields_set:
            _dict['fuelMoisture'] = None

        # set to None if spcd (nullable) is None
        # and model_fields_set contains the field
        if self.spcd is None and "spcd" in self.model_fields_set:
            _dict['SPCD'] = None

        # set to None if savr (nullable) is None
        # and model_fields_set contains the field
        if self.savr is None and "savr" in self.model_fields_set:
            _dict['SAVR'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateTreeGridRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attributes": obj.get("attributes"),
            "bulkDensity": TreeGridBulkDensitySource.from_dict(obj["bulkDensity"]) if obj.get("bulkDensity") is not None else None,
            "fuelMoisture": TreeGridUniformValue.from_dict(obj["fuelMoisture"]) if obj.get("fuelMoisture") is not None else None,
            "SPCD": TreeGridSPCDSource.from_dict(obj["SPCD"]) if obj.get("SPCD") is not None else None,
            "SAVR": TreeGridSAVRSource.from_dict(obj["SAVR"]) if obj.get("SAVR") is not None else None
        })
        return _obj


