# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from fastfuels_sdk.client_library.models.topography_grid_aspect_source import TopographyGridAspectSource
from fastfuels_sdk.client_library.models.topography_grid_attribute import TopographyGridAttribute
from fastfuels_sdk.client_library.models.topography_grid_elevation_source import TopographyGridElevationSource
from fastfuels_sdk.client_library.models.topography_grid_slope_source import TopographyGridSlopeSource
from typing import Optional, Set
from typing_extensions import Self

class CreateTopographyGridRequest(BaseModel):
    """
    CreateTopographyGridRequest
    """ # noqa: E501
    attributes: List[TopographyGridAttribute] = Field(description="List of attributes to include in the surface grid")
    elevation: Optional[TopographyGridElevationSource] = None
    aspect: Optional[TopographyGridAspectSource] = None
    slope: Optional[TopographyGridSlopeSource] = None
    __properties: ClassVar[List[str]] = ["attributes", "elevation", "aspect", "slope"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateTopographyGridRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of elevation
        if self.elevation:
            _dict['elevation'] = self.elevation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aspect
        if self.aspect:
            _dict['aspect'] = self.aspect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of slope
        if self.slope:
            _dict['slope'] = self.slope.to_dict()
        # set to None if elevation (nullable) is None
        # and model_fields_set contains the field
        if self.elevation is None and "elevation" in self.model_fields_set:
            _dict['elevation'] = None

        # set to None if aspect (nullable) is None
        # and model_fields_set contains the field
        if self.aspect is None and "aspect" in self.model_fields_set:
            _dict['aspect'] = None

        # set to None if slope (nullable) is None
        # and model_fields_set contains the field
        if self.slope is None and "slope" in self.model_fields_set:
            _dict['slope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateTopographyGridRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attributes": obj.get("attributes"),
            "elevation": TopographyGridElevationSource.from_dict(obj["elevation"]) if obj.get("elevation") is not None else None,
            "aspect": TopographyGridAspectSource.from_dict(obj["aspect"]) if obj.get("aspect") is not None else None,
            "slope": TopographyGridSlopeSource.from_dict(obj["slope"]) if obj.get("slope") is not None else None
        })
        return _obj


