# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fastfuels_sdk.client_library.models.access import Access
from fastfuels_sdk.client_library.models.scope import Scope
from typing import Optional, Set
from typing_extensions import Self

class CreateKeyRequest(BaseModel):
    """
    Request body for creating an API key resource
    """ # noqa: E501
    name: StrictStr = Field(description="A name to semantically identify the key.")
    description: Optional[StrictStr] = None
    valid_days: Optional[StrictInt] = Field(default=30, description="Number of days for which this key will be valid.", alias="validDays")
    scopes: Optional[List[Scope]] = Field(default=None, description="A list of scopes available to the key.")
    access: Optional[Access] = Field(default=None, description="Access type for the API key")
    application_id: Optional[StrictStr] = Field(default=None, alias="applicationId")
    __properties: ClassVar[List[str]] = ["name", "description", "validDays", "scopes", "access", "applicationId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateKeyRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if application_id (nullable) is None
        # and model_fields_set contains the field
        if self.application_id is None and "application_id" in self.model_fields_set:
            _dict['applicationId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateKeyRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "validDays": obj.get("validDays") if obj.get("validDays") is not None else 30,
            "scopes": obj.get("scopes"),
            "access": obj.get("access"),
            "applicationId": obj.get("applicationId")
        })
        return _obj


