# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr, field_validator
from fastfuels_sdk.client_library.models.create_tree_grid_request import CreateTreeGridRequest
from fastfuels_sdk.client_library.models.export import Export
from fastfuels_sdk.client_library.models.grid_attribute_metadata_response import GridAttributeMetadataResponse
from fastfuels_sdk.client_library.models.tree_grid import TreeGrid

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class TreeGridApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_tree_grid(
        self,
        domain_id: StrictStr,
        create_tree_grid_request: CreateTreeGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TreeGrid:
        """Create Tree Grid

        # Create Tree Grid  This endpoint creates a new tree grid resource for a specific domain. Tree grid data represents various 3D gridded tree attribute (e.g., bulk density, fuel moisture, SPCD) data that exists within the spatial context of a domain. Tree grid data is typically generated to create inputs to 3D fire behavior models such as QUIC-Fire or FDS.  On resource creation, the tree grid data is set to a status of \"pending\". The tree grid data is generated in the background using the specified method and data sources. Once the tree grid data is generated and available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the tree grid.  ## Request Body  The request body should be a JSON object containing the following fields:  - `attributes` (array of strings, required): List of attributes to include in the tree grid data. Attributes represent the an additional dimension in the 3D gridded data. Possible values are:   - `\"bulkDensity\"`   - `\"fuelMoisture\"`   - `\"SPCD\"`  ### Attribute Descriptions and Sources  - `bulkDensity` (kg/m³): The mass of the tree fuel per unit volume of the occupied cell. - `foliarMoisture` (%): Live foliar moisture content of the occupied cell. - `SPCD` (unitless): The FIA species code of the occupied cell. - `SAVR` (m²/m³): The surface area to volume ratio of fuel particles in the occupied cell.  Each attribute can be sourced from different data sources. By default, the system will use pre-defined data sources to acquire data for the specified attributes. However, if you want to specify additional information for how to acquire an attribute, you can provide detailed instructions in the request body.  To specify additional information for an attribute, add a field with the attribute name to the request body. For example:  ```json {     \"attributes\": [\"bulkDensity\", \"fuelMoisture\"],     \"bulkDensity\": {         \"source\": \"TreeInventory\",         \"biomassModel\": \"NSVB\"     },     \"fuelMoisture\": {\"source\": \"uniform\", \"value\": 175} } ```  In this example, the `bulkDensity` attribute is sourced from the Tree Inventory using the NSVB biomass model, and the `fuelMoisture` attribute is set to a uniform value of 175%.  The general form of this construction is as follows:  - `bulkDensity`, `fuelMoisture`, `SPCD`, `SAVR` (object, optional): The data source for the respective attribute. The structure of these objects depends on the source specified.  #### Uniform Source  If the source is `\"uniform\"`, the object should have the following fields:  - `value` (float, required): The uniform value for the attribute.  #### Tree Inventory Source  If the source is `\"TreeInventory\"`, data will be sourced from the Tree Inventory resource.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created tree grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the tree grid. Will be set to `\"pending\"` initially. - `createdOn` (string): The timestamp when the tree grid was created. - `modifiedOn` (string): The timestamp when the tree grid was last modified. - `checksum` (string): A unique checksum for the tree grid resource. - `attributes` (array of strings): The list of attributes included in the tree grid. - `bulkDensity`, `fuelMoisture`, `SPCD` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree inventory for the specified domain does not exist. - `400 Bad Request`: The tree inventory status is not \"completed\". - `422 Unprocessable Entity`: The request body is invalid or required fields are missing.

        :param domain_id: (required)
        :type domain_id: str
        :param create_tree_grid_request: (required)
        :type create_tree_grid_request: CreateTreeGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tree_grid_serialize(
            domain_id=domain_id,
            create_tree_grid_request=create_tree_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TreeGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_tree_grid_with_http_info(
        self,
        domain_id: StrictStr,
        create_tree_grid_request: CreateTreeGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TreeGrid]:
        """Create Tree Grid

        # Create Tree Grid  This endpoint creates a new tree grid resource for a specific domain. Tree grid data represents various 3D gridded tree attribute (e.g., bulk density, fuel moisture, SPCD) data that exists within the spatial context of a domain. Tree grid data is typically generated to create inputs to 3D fire behavior models such as QUIC-Fire or FDS.  On resource creation, the tree grid data is set to a status of \"pending\". The tree grid data is generated in the background using the specified method and data sources. Once the tree grid data is generated and available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the tree grid.  ## Request Body  The request body should be a JSON object containing the following fields:  - `attributes` (array of strings, required): List of attributes to include in the tree grid data. Attributes represent the an additional dimension in the 3D gridded data. Possible values are:   - `\"bulkDensity\"`   - `\"fuelMoisture\"`   - `\"SPCD\"`  ### Attribute Descriptions and Sources  - `bulkDensity` (kg/m³): The mass of the tree fuel per unit volume of the occupied cell. - `foliarMoisture` (%): Live foliar moisture content of the occupied cell. - `SPCD` (unitless): The FIA species code of the occupied cell. - `SAVR` (m²/m³): The surface area to volume ratio of fuel particles in the occupied cell.  Each attribute can be sourced from different data sources. By default, the system will use pre-defined data sources to acquire data for the specified attributes. However, if you want to specify additional information for how to acquire an attribute, you can provide detailed instructions in the request body.  To specify additional information for an attribute, add a field with the attribute name to the request body. For example:  ```json {     \"attributes\": [\"bulkDensity\", \"fuelMoisture\"],     \"bulkDensity\": {         \"source\": \"TreeInventory\",         \"biomassModel\": \"NSVB\"     },     \"fuelMoisture\": {\"source\": \"uniform\", \"value\": 175} } ```  In this example, the `bulkDensity` attribute is sourced from the Tree Inventory using the NSVB biomass model, and the `fuelMoisture` attribute is set to a uniform value of 175%.  The general form of this construction is as follows:  - `bulkDensity`, `fuelMoisture`, `SPCD`, `SAVR` (object, optional): The data source for the respective attribute. The structure of these objects depends on the source specified.  #### Uniform Source  If the source is `\"uniform\"`, the object should have the following fields:  - `value` (float, required): The uniform value for the attribute.  #### Tree Inventory Source  If the source is `\"TreeInventory\"`, data will be sourced from the Tree Inventory resource.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created tree grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the tree grid. Will be set to `\"pending\"` initially. - `createdOn` (string): The timestamp when the tree grid was created. - `modifiedOn` (string): The timestamp when the tree grid was last modified. - `checksum` (string): A unique checksum for the tree grid resource. - `attributes` (array of strings): The list of attributes included in the tree grid. - `bulkDensity`, `fuelMoisture`, `SPCD` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree inventory for the specified domain does not exist. - `400 Bad Request`: The tree inventory status is not \"completed\". - `422 Unprocessable Entity`: The request body is invalid or required fields are missing.

        :param domain_id: (required)
        :type domain_id: str
        :param create_tree_grid_request: (required)
        :type create_tree_grid_request: CreateTreeGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tree_grid_serialize(
            domain_id=domain_id,
            create_tree_grid_request=create_tree_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TreeGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_tree_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        create_tree_grid_request: CreateTreeGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Tree Grid

        # Create Tree Grid  This endpoint creates a new tree grid resource for a specific domain. Tree grid data represents various 3D gridded tree attribute (e.g., bulk density, fuel moisture, SPCD) data that exists within the spatial context of a domain. Tree grid data is typically generated to create inputs to 3D fire behavior models such as QUIC-Fire or FDS.  On resource creation, the tree grid data is set to a status of \"pending\". The tree grid data is generated in the background using the specified method and data sources. Once the tree grid data is generated and available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the tree grid.  ## Request Body  The request body should be a JSON object containing the following fields:  - `attributes` (array of strings, required): List of attributes to include in the tree grid data. Attributes represent the an additional dimension in the 3D gridded data. Possible values are:   - `\"bulkDensity\"`   - `\"fuelMoisture\"`   - `\"SPCD\"`  ### Attribute Descriptions and Sources  - `bulkDensity` (kg/m³): The mass of the tree fuel per unit volume of the occupied cell. - `foliarMoisture` (%): Live foliar moisture content of the occupied cell. - `SPCD` (unitless): The FIA species code of the occupied cell. - `SAVR` (m²/m³): The surface area to volume ratio of fuel particles in the occupied cell.  Each attribute can be sourced from different data sources. By default, the system will use pre-defined data sources to acquire data for the specified attributes. However, if you want to specify additional information for how to acquire an attribute, you can provide detailed instructions in the request body.  To specify additional information for an attribute, add a field with the attribute name to the request body. For example:  ```json {     \"attributes\": [\"bulkDensity\", \"fuelMoisture\"],     \"bulkDensity\": {         \"source\": \"TreeInventory\",         \"biomassModel\": \"NSVB\"     },     \"fuelMoisture\": {\"source\": \"uniform\", \"value\": 175} } ```  In this example, the `bulkDensity` attribute is sourced from the Tree Inventory using the NSVB biomass model, and the `fuelMoisture` attribute is set to a uniform value of 175%.  The general form of this construction is as follows:  - `bulkDensity`, `fuelMoisture`, `SPCD`, `SAVR` (object, optional): The data source for the respective attribute. The structure of these objects depends on the source specified.  #### Uniform Source  If the source is `\"uniform\"`, the object should have the following fields:  - `value` (float, required): The uniform value for the attribute.  #### Tree Inventory Source  If the source is `\"TreeInventory\"`, data will be sourced from the Tree Inventory resource.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created tree grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the tree grid. Will be set to `\"pending\"` initially. - `createdOn` (string): The timestamp when the tree grid was created. - `modifiedOn` (string): The timestamp when the tree grid was last modified. - `checksum` (string): A unique checksum for the tree grid resource. - `attributes` (array of strings): The list of attributes included in the tree grid. - `bulkDensity`, `fuelMoisture`, `SPCD` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree inventory for the specified domain does not exist. - `400 Bad Request`: The tree inventory status is not \"completed\". - `422 Unprocessable Entity`: The request body is invalid or required fields are missing.

        :param domain_id: (required)
        :type domain_id: str
        :param create_tree_grid_request: (required)
        :type create_tree_grid_request: CreateTreeGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tree_grid_serialize(
            domain_id=domain_id,
            create_tree_grid_request=create_tree_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TreeGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_tree_grid_serialize(
        self,
        domain_id,
        create_tree_grid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_tree_grid_request is not None:
            _body_params = create_tree_grid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/tree',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_tree_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Create Tree Grid Export

        # Create Tree Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/tree/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the tree grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the tree grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tree_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_tree_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Create Tree Grid Export

        # Create Tree Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/tree/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the tree grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the tree grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tree_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_tree_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Tree Grid Export

        # Create Tree Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/tree/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the tree grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the tree grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tree_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_tree_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/tree/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_tree_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Tree Grid

        # Delete Tree Grid  This endpoint deletes an existing tree grid resource for a specific domain. This action removes the tree grid data from the database and cancels any ongoing job execution related to the tree grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the tree grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the tree grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree grid for the specified domain does not exist.  ## Usage Notes  - Deleting a tree grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the tree grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tree_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_tree_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Tree Grid

        # Delete Tree Grid  This endpoint deletes an existing tree grid resource for a specific domain. This action removes the tree grid data from the database and cancels any ongoing job execution related to the tree grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the tree grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the tree grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree grid for the specified domain does not exist.  ## Usage Notes  - Deleting a tree grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the tree grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tree_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_tree_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Tree Grid

        # Delete Tree Grid  This endpoint deletes an existing tree grid resource for a specific domain. This action removes the tree grid data from the database and cancels any ongoing job execution related to the tree grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the tree grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the tree grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree grid for the specified domain does not exist.  ## Usage Notes  - Deleting a tree grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the tree grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tree_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_tree_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/domains/{domainId}/grids/tree',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_tree_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TreeGrid:
        """Get Tree Grid

        # Get Tree Grid  This endpoint retrieves the details of an existing tree grid resource for a specific domain. Users can access the status and metadata of the tree grid that has been created.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the tree grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the tree grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the tree grid. - `createdOn` (string): The timestamp when the tree grid was created. - `modifiedOn` (string): The timestamp when the tree grid was last modified. - `checksum` (string): A unique checksum for the tree grid resource. - `attributes` (array of strings): The list of attributes included in the tree grid. - `bulkDensity`, `fuelMoisture`, `SPCD` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree grid for the specified domain does not exist.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TreeGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_tree_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TreeGrid]:
        """Get Tree Grid

        # Get Tree Grid  This endpoint retrieves the details of an existing tree grid resource for a specific domain. Users can access the status and metadata of the tree grid that has been created.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the tree grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the tree grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the tree grid. - `createdOn` (string): The timestamp when the tree grid was created. - `modifiedOn` (string): The timestamp when the tree grid was last modified. - `checksum` (string): A unique checksum for the tree grid resource. - `attributes` (array of strings): The list of attributes included in the tree grid. - `bulkDensity`, `fuelMoisture`, `SPCD` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree grid for the specified domain does not exist.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TreeGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_tree_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Tree Grid

        # Get Tree Grid  This endpoint retrieves the details of an existing tree grid resource for a specific domain. Users can access the status and metadata of the tree grid that has been created.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the tree grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the tree grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the tree grid. - `createdOn` (string): The timestamp when the tree grid was created. - `modifiedOn` (string): The timestamp when the tree grid was last modified. - `checksum` (string): A unique checksum for the tree grid resource. - `attributes` (array of strings): The list of attributes included in the tree grid. - `bulkDensity`, `fuelMoisture`, `SPCD` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The tree grid for the specified domain does not exist.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TreeGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_tree_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/tree',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_tree_grid_attribute_metadata(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GridAttributeMetadataResponse:
        """Get Tree Grid Attribute Metadata

        # Get Tree Grid Attribute Metadata  Retrieves metadata about the structure of the tree grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Tree grid not found or not accessible. - 422 Unprocessable Entity: Tree grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_tree_grid_attribute_metadata_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GridAttributeMetadataResponse]:
        """Get Tree Grid Attribute Metadata

        # Get Tree Grid Attribute Metadata  Retrieves metadata about the structure of the tree grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Tree grid not found or not accessible. - 422 Unprocessable Entity: Tree grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_tree_grid_attribute_metadata_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Tree Grid Attribute Metadata

        # Get Tree Grid Attribute Metadata  Retrieves metadata about the structure of the tree grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Tree grid not found or not accessible. - 422 Unprocessable Entity: Tree grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_tree_grid_attribute_metadata_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/tree/attributes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_tree_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Get Tree Grid Export

        # Get Tree Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a tree grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_tree_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Get Tree Grid Export

        # Get Tree Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a tree grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_tree_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Tree Grid Export

        # Get Tree Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/tree/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a tree grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tree_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_tree_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/tree/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


