# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr
from fastfuels_sdk.client_library.models.inventories import Inventories

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class InventoriesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_inventories(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Inventories:
        """Get Inventories

        # Get Inventories Endpoint  This endpoint retrieves the inventories resource associated with a domain belonging to the user based on the provided domain ID.  An inventories resource is a container for the various types of inventory data that can exist with the spatial context of the domain. Currently, only tree inventories are supported, though other forms of inventory will be added soon.  ## Endpoint: `GET /v1/domains/{domainId}/inventories`  ### Path Parameters  To retrieve the inventories of a domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain belonging to the user whose inventories are to be retrieved.  ### Response  The response returns the members of the specified inventories resource following the Inventories schema.  - **tree**: (TreeInventory)   ### Example Request  ```http GET /v1/domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1/inventories ```  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Domain not found.\" - **500 Internal Server Error**: An error occurred while retrieving the inventory resources.   - **Detail**: \"An error occurred while getting the inventory resources.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_inventories_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Inventories",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_inventories_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Inventories]:
        """Get Inventories

        # Get Inventories Endpoint  This endpoint retrieves the inventories resource associated with a domain belonging to the user based on the provided domain ID.  An inventories resource is a container for the various types of inventory data that can exist with the spatial context of the domain. Currently, only tree inventories are supported, though other forms of inventory will be added soon.  ## Endpoint: `GET /v1/domains/{domainId}/inventories`  ### Path Parameters  To retrieve the inventories of a domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain belonging to the user whose inventories are to be retrieved.  ### Response  The response returns the members of the specified inventories resource following the Inventories schema.  - **tree**: (TreeInventory)   ### Example Request  ```http GET /v1/domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1/inventories ```  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Domain not found.\" - **500 Internal Server Error**: An error occurred while retrieving the inventory resources.   - **Detail**: \"An error occurred while getting the inventory resources.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_inventories_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Inventories",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_inventories_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Inventories

        # Get Inventories Endpoint  This endpoint retrieves the inventories resource associated with a domain belonging to the user based on the provided domain ID.  An inventories resource is a container for the various types of inventory data that can exist with the spatial context of the domain. Currently, only tree inventories are supported, though other forms of inventory will be added soon.  ## Endpoint: `GET /v1/domains/{domainId}/inventories`  ### Path Parameters  To retrieve the inventories of a domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain belonging to the user whose inventories are to be retrieved.  ### Response  The response returns the members of the specified inventories resource following the Inventories schema.  - **tree**: (TreeInventory)   ### Example Request  ```http GET /v1/domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1/inventories ```  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Domain not found.\" - **500 Internal Server Error**: An error occurred while retrieving the inventory resources.   - **Detail**: \"An error occurred while getting the inventory resources.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_inventories_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Inventories",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_inventories_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/inventories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


