# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr, field_validator
from fastfuels_sdk.client_library.models.export import Export
from fastfuels_sdk.client_library.models.features import Features

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class FeaturesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_feature_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Create Feature Export

        # Create Feature Export  ## Endpoint  ``` POST /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the feature data (road and water) of a specific domain, in the specified format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format in which to export the feature data. Possible value:   - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of the export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation). - `signedUrl` (string, optional): Initially `null`, populated when export is completed.  ## Error Responses  - `404 Not Found`: If the domain is not found, or there are no water or road features created. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure that the road and water feature data for the domain have been created before initiating an export. If neither feature exists, the request will result in a `404 Not Found` error. - The export will be processed as a background job, and the status will initially be set to `\"pending\"`. - Check the export status using a separate endpoint to monitor progress. - Once the export is complete, use the `signedUrl` to download the GeoJSON file.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_feature_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Create Feature Export

        # Create Feature Export  ## Endpoint  ``` POST /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the feature data (road and water) of a specific domain, in the specified format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format in which to export the feature data. Possible value:   - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of the export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation). - `signedUrl` (string, optional): Initially `null`, populated when export is completed.  ## Error Responses  - `404 Not Found`: If the domain is not found, or there are no water or road features created. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure that the road and water feature data for the domain have been created before initiating an export. If neither feature exists, the request will result in a `404 Not Found` error. - The export will be processed as a background job, and the status will initially be set to `\"pending\"`. - Check the export status using a separate endpoint to monitor progress. - Once the export is complete, use the `signedUrl` to download the GeoJSON file.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_feature_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Feature Export

        # Create Feature Export  ## Endpoint  ``` POST /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the feature data (road and water) of a specific domain, in the specified format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format in which to export the feature data. Possible value:   - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of the export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation). - `signedUrl` (string, optional): Initially `null`, populated when export is completed.  ## Error Responses  - `404 Not Found`: If the domain is not found, or there are no water or road features created. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure that the road and water feature data for the domain have been created before initiating an export. If neither feature exists, the request will result in a `404 Not Found` error. - The export will be processed as a background job, and the status will initially be set to `\"pending\"`. - Check the export status using a separate endpoint to monitor progress. - Once the export is complete, use the `signedUrl` to download the GeoJSON file.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_feature_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/features/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_feature_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Feature Export

        # Delete Feature Export  ## Endpoint  ``` DELETE /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint deletes a feature export request and its associated files for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export to delete. Possible values are:     - `\"geojson\"`: Delete the export in the geojson format.  ## Response  If successful, returns a `204 No Content` status code.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to delete an existing feature export request and its related data. - The export request is removed from Firestore, and the associated files are deleted from Google Cloud Storage asynchronously.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_feature_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Feature Export

        # Delete Feature Export  ## Endpoint  ``` DELETE /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint deletes a feature export request and its associated files for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export to delete. Possible values are:     - `\"geojson\"`: Delete the export in the geojson format.  ## Response  If successful, returns a `204 No Content` status code.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to delete an existing feature export request and its related data. - The export request is removed from Firestore, and the associated files are deleted from Google Cloud Storage asynchronously.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_feature_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Feature Export

        # Delete Feature Export  ## Endpoint  ``` DELETE /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint deletes a feature export request and its associated files for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export to delete. Possible values are:     - `\"geojson\"`: Delete the export in the geojson format.  ## Response  If successful, returns a `204 No Content` status code.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to delete an existing feature export request and its related data. - The export request is removed from Firestore, and the associated files are deleted from Google Cloud Storage asynchronously.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_feature_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/domains/{domainId}/features/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_feature_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Get Feature Export

        # Get Feature Export  ## Endpoint  ``` GET /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature export request (for road and water features) for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Possible value:     - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Export not found or no feature data exists for the specified export format.  ## Usage Notes  - Use this endpoint to check the status of a feature export request. - Once the status is `\"completed\"`, you can use the `signedUrl` to download the exported GeoJSON file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_feature_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Get Feature Export

        # Get Feature Export  ## Endpoint  ``` GET /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature export request (for road and water features) for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Possible value:     - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Export not found or no feature data exists for the specified export format.  ## Usage Notes  - Use this endpoint to check the status of a feature export request. - Once the status is `\"completed\"`, you can use the `signedUrl` to download the exported GeoJSON file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_feature_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Feature Export

        # Get Feature Export  ## Endpoint  ``` GET /v1/domains/{domainId}/features/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature export request (for road and water features) for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Possible value:     - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Export not found or no feature data exists for the specified export format.  ## Usage Notes  - Use this endpoint to check the status of a feature export request. - Once the status is `\"completed\"`, you can use the `signedUrl` to download the exported GeoJSON file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_feature_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/features/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_features(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Features:
        """Get Features

        # Get Features Endpoint  This endpoint retrieves the features resource associated with a domain belonging to the user based on the provided domain ID.  A features resource is a container for the various types of feature data that can exist with the spatial context of the domain. Currently, only road and water features are supported, though other forms of feature will be added soon.  ## Endpoint: `GET /v1/domains/{domainId}/features`  ### Path Parameters  To retrieve the features of a domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain belonging to the user whose features are to be retrieved.  ### Response  The response returns the members of the specified features resource following the Features schema.  - **road**: (RoadFeature) - **water**: (WaterFeature)  ### Example Request  ```http GET /v1/domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1/features ```  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Domain not found.\" - **500 Internal Server Error**: An error occurred while retrieving the feature resources.   - **Detail**: \"An error occurred while getting the feature resources.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_features_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Features",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_features_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Features]:
        """Get Features

        # Get Features Endpoint  This endpoint retrieves the features resource associated with a domain belonging to the user based on the provided domain ID.  A features resource is a container for the various types of feature data that can exist with the spatial context of the domain. Currently, only road and water features are supported, though other forms of feature will be added soon.  ## Endpoint: `GET /v1/domains/{domainId}/features`  ### Path Parameters  To retrieve the features of a domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain belonging to the user whose features are to be retrieved.  ### Response  The response returns the members of the specified features resource following the Features schema.  - **road**: (RoadFeature) - **water**: (WaterFeature)  ### Example Request  ```http GET /v1/domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1/features ```  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Domain not found.\" - **500 Internal Server Error**: An error occurred while retrieving the feature resources.   - **Detail**: \"An error occurred while getting the feature resources.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_features_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Features",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_features_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Features

        # Get Features Endpoint  This endpoint retrieves the features resource associated with a domain belonging to the user based on the provided domain ID.  A features resource is a container for the various types of feature data that can exist with the spatial context of the domain. Currently, only road and water features are supported, though other forms of feature will be added soon.  ## Endpoint: `GET /v1/domains/{domainId}/features`  ### Path Parameters  To retrieve the features of a domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain belonging to the user whose features are to be retrieved.  ### Response  The response returns the members of the specified features resource following the Features schema.  - **road**: (RoadFeature) - **water**: (WaterFeature)  ### Example Request  ```http GET /v1/domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1/features ```  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Domain not found.\" - **500 Internal Server Error**: An error occurred while retrieving the feature resources.   - **Detail**: \"An error occurred while getting the feature resources.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_features_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Features",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_features_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/features',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


