# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr, field_validator
from fastfuels_sdk.client_library.models.create_feature_grid_request import CreateFeatureGridRequest
from fastfuels_sdk.client_library.models.export import Export
from fastfuels_sdk.client_library.models.feature_grid import FeatureGrid
from fastfuels_sdk.client_library.models.grid_attribute_metadata_response import GridAttributeMetadataResponse

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class FeatureGridApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_feature_grid(
        self,
        domain_id: StrictStr,
        create_feature_grid_request: CreateFeatureGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FeatureGrid:
        """Create Feature Grid

        # Create Feature Grid  This endpoint creates a new feature grid resource for a specific domain. Feature grids are used to represent spatial data related to various features within the domain. This operation generates a feature grid based on the provided configuration and data sources.  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to create the feature grid.  ## Request Body  The request body should be a JSON object adhering to the `CreateFeatureGridRequest` model, containing the necessary configuration and data source information for generating the feature grid.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created feature grid resource in the response body. The response body will include the following fields:  - `createdOn` (string): The timestamp when the feature grid was created. - `modifiedOn` (string): The timestamp when the feature grid was last modified. - `status` (string): The status of the feature grid, initially set to `\"PENDING\"`. - `checksum` (string): A unique checksum for the feature grid resource.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `429 Too Many Requests`: The system is currently overloaded, and the job could not be submitted.  ## Usage Notes  - If an existing feature grid already exists for the domain, its associated job execution will be canceled before creating the new grid. - The feature grid generation is handled as a background job. The status will initially be `\"PENDING\"` and will be updated once the job completes. - The system will attempt to remove any cached data related to the previous feature grid.

        :param domain_id: (required)
        :type domain_id: str
        :param create_feature_grid_request: (required)
        :type create_feature_grid_request: CreateFeatureGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_grid_serialize(
            domain_id=domain_id,
            create_feature_grid_request=create_feature_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FeatureGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_feature_grid_with_http_info(
        self,
        domain_id: StrictStr,
        create_feature_grid_request: CreateFeatureGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FeatureGrid]:
        """Create Feature Grid

        # Create Feature Grid  This endpoint creates a new feature grid resource for a specific domain. Feature grids are used to represent spatial data related to various features within the domain. This operation generates a feature grid based on the provided configuration and data sources.  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to create the feature grid.  ## Request Body  The request body should be a JSON object adhering to the `CreateFeatureGridRequest` model, containing the necessary configuration and data source information for generating the feature grid.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created feature grid resource in the response body. The response body will include the following fields:  - `createdOn` (string): The timestamp when the feature grid was created. - `modifiedOn` (string): The timestamp when the feature grid was last modified. - `status` (string): The status of the feature grid, initially set to `\"PENDING\"`. - `checksum` (string): A unique checksum for the feature grid resource.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `429 Too Many Requests`: The system is currently overloaded, and the job could not be submitted.  ## Usage Notes  - If an existing feature grid already exists for the domain, its associated job execution will be canceled before creating the new grid. - The feature grid generation is handled as a background job. The status will initially be `\"PENDING\"` and will be updated once the job completes. - The system will attempt to remove any cached data related to the previous feature grid.

        :param domain_id: (required)
        :type domain_id: str
        :param create_feature_grid_request: (required)
        :type create_feature_grid_request: CreateFeatureGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_grid_serialize(
            domain_id=domain_id,
            create_feature_grid_request=create_feature_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FeatureGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_feature_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        create_feature_grid_request: CreateFeatureGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Feature Grid

        # Create Feature Grid  This endpoint creates a new feature grid resource for a specific domain. Feature grids are used to represent spatial data related to various features within the domain. This operation generates a feature grid based on the provided configuration and data sources.  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to create the feature grid.  ## Request Body  The request body should be a JSON object adhering to the `CreateFeatureGridRequest` model, containing the necessary configuration and data source information for generating the feature grid.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created feature grid resource in the response body. The response body will include the following fields:  - `createdOn` (string): The timestamp when the feature grid was created. - `modifiedOn` (string): The timestamp when the feature grid was last modified. - `status` (string): The status of the feature grid, initially set to `\"PENDING\"`. - `checksum` (string): A unique checksum for the feature grid resource.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `429 Too Many Requests`: The system is currently overloaded, and the job could not be submitted.  ## Usage Notes  - If an existing feature grid already exists for the domain, its associated job execution will be canceled before creating the new grid. - The feature grid generation is handled as a background job. The status will initially be `\"PENDING\"` and will be updated once the job completes. - The system will attempt to remove any cached data related to the previous feature grid.

        :param domain_id: (required)
        :type domain_id: str
        :param create_feature_grid_request: (required)
        :type create_feature_grid_request: CreateFeatureGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_grid_serialize(
            domain_id=domain_id,
            create_feature_grid_request=create_feature_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FeatureGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_feature_grid_serialize(
        self,
        domain_id,
        create_feature_grid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_feature_grid_request is not None:
            _body_params = create_feature_grid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/feature',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_feature_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Create Feature Grid Export

        # Create Feature Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/feature/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the feature grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, the supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the feature grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_feature_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Create Feature Grid Export

        # Create Feature Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/feature/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the feature grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, the supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the feature grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_feature_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Feature Grid Export

        # Create Feature Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/feature/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the feature grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, the supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the feature grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_feature_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_feature_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/feature/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_feature_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Feature Grid

        # Delete Feature Grid  This endpoint deletes the feature grid data for a specific domain. If the feature grid exists, it will be removed from the database, and any associated resources, such as files in the GCS bucket, will be deleted asynchronously.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the feature grid.  ## Response  - `204 No Content`: The feature grid was successfully deleted. The response body will be empty.  ## Error Responses  - `404 Not Found`: The specified domain or feature grid does not exist or the user does not have access to it.  ## Usage Notes  - Ensure that the `domainId` provided is correct and that the user has the appropriate permissions to delete the domain's data. - The feature grid data is removed from the database, and any running jobs related to the feature grid are canceled in the background. - The associated Zarr group in the GCS bucket is deleted asynchronously.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_feature_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_feature_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Feature Grid

        # Delete Feature Grid  This endpoint deletes the feature grid data for a specific domain. If the feature grid exists, it will be removed from the database, and any associated resources, such as files in the GCS bucket, will be deleted asynchronously.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the feature grid.  ## Response  - `204 No Content`: The feature grid was successfully deleted. The response body will be empty.  ## Error Responses  - `404 Not Found`: The specified domain or feature grid does not exist or the user does not have access to it.  ## Usage Notes  - Ensure that the `domainId` provided is correct and that the user has the appropriate permissions to delete the domain's data. - The feature grid data is removed from the database, and any running jobs related to the feature grid are canceled in the background. - The associated Zarr group in the GCS bucket is deleted asynchronously.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_feature_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_feature_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Feature Grid

        # Delete Feature Grid  This endpoint deletes the feature grid data for a specific domain. If the feature grid exists, it will be removed from the database, and any associated resources, such as files in the GCS bucket, will be deleted asynchronously.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the feature grid.  ## Response  - `204 No Content`: The feature grid was successfully deleted. The response body will be empty.  ## Error Responses  - `404 Not Found`: The specified domain or feature grid does not exist or the user does not have access to it.  ## Usage Notes  - Ensure that the `domainId` provided is correct and that the user has the appropriate permissions to delete the domain's data. - The feature grid data is removed from the database, and any running jobs related to the feature grid are canceled in the background. - The associated Zarr group in the GCS bucket is deleted asynchronously.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_feature_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_feature_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/domains/{domainId}/grids/feature',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_feature_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FeatureGrid:
        """Get Feature Grid

        # Get Feature Grid  This endpoint retrieves the feature grid data for a specific domain. Feature grids represent spatial data related to various features within the domain. If the feature grid data has been generated and stored, it will be returned in the response.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to retrieve the feature grid.  ## Response  If the feature grid data exists, the endpoint will return a `200 OK` status code and the feature grid resource in the response body. The response will be a JSON object adhering to the `FeatureGrid` model, which includes:  - `createdOn` (string): The timestamp when the feature grid was created. - `modifiedOn` (string): The timestamp when the feature grid was last modified. - `status` (string): The current status of the feature grid. - `checksum` (string): A unique checksum for the feature grid resource.  ## Error Responses  - `404 Not Found`: The feature grid data has not been created for the specified domain, or it cannot be retrieved.  ## Usage Notes  - Ensure that the `domainId` provided is correct and that the user has the appropriate permissions to access the domain's data. - The feature grid data is retrieved from the database, and if it does not exist, a `404 Not Found` error will be returned.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FeatureGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_feature_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FeatureGrid]:
        """Get Feature Grid

        # Get Feature Grid  This endpoint retrieves the feature grid data for a specific domain. Feature grids represent spatial data related to various features within the domain. If the feature grid data has been generated and stored, it will be returned in the response.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to retrieve the feature grid.  ## Response  If the feature grid data exists, the endpoint will return a `200 OK` status code and the feature grid resource in the response body. The response will be a JSON object adhering to the `FeatureGrid` model, which includes:  - `createdOn` (string): The timestamp when the feature grid was created. - `modifiedOn` (string): The timestamp when the feature grid was last modified. - `status` (string): The current status of the feature grid. - `checksum` (string): A unique checksum for the feature grid resource.  ## Error Responses  - `404 Not Found`: The feature grid data has not been created for the specified domain, or it cannot be retrieved.  ## Usage Notes  - Ensure that the `domainId` provided is correct and that the user has the appropriate permissions to access the domain's data. - The feature grid data is retrieved from the database, and if it does not exist, a `404 Not Found` error will be returned.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FeatureGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_feature_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Feature Grid

        # Get Feature Grid  This endpoint retrieves the feature grid data for a specific domain. Feature grids represent spatial data related to various features within the domain. If the feature grid data has been generated and stored, it will be returned in the response.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to retrieve the feature grid.  ## Response  If the feature grid data exists, the endpoint will return a `200 OK` status code and the feature grid resource in the response body. The response will be a JSON object adhering to the `FeatureGrid` model, which includes:  - `createdOn` (string): The timestamp when the feature grid was created. - `modifiedOn` (string): The timestamp when the feature grid was last modified. - `status` (string): The current status of the feature grid. - `checksum` (string): A unique checksum for the feature grid resource.  ## Error Responses  - `404 Not Found`: The feature grid data has not been created for the specified domain, or it cannot be retrieved.  ## Usage Notes  - Ensure that the `domainId` provided is correct and that the user has the appropriate permissions to access the domain's data. - The feature grid data is retrieved from the database, and if it does not exist, a `404 Not Found` error will be returned.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FeatureGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_feature_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/feature',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_feature_grid_attribute_metadata(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GridAttributeMetadataResponse:
        """Get Feature Grid Attribute Metadata

        # Get Feature Grid Attribute Metadata  Retrieves metadata about the structure of the feature grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Feature grid not found or not accessible. - 422 Unprocessable Entity: Feature grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_feature_grid_attribute_metadata_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GridAttributeMetadataResponse]:
        """Get Feature Grid Attribute Metadata

        # Get Feature Grid Attribute Metadata  Retrieves metadata about the structure of the feature grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Feature grid not found or not accessible. - 422 Unprocessable Entity: Feature grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_feature_grid_attribute_metadata_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Feature Grid Attribute Metadata

        # Get Feature Grid Attribute Metadata  Retrieves metadata about the structure of the feature grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Feature grid not found or not accessible. - 422 Unprocessable Entity: Feature grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_feature_grid_attribute_metadata_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/feature/attributes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_feature_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Get Feature Grid Export

        # Get Feature Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_feature_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Get Feature Grid Export

        # Get Feature Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_feature_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Feature Grid Export

        # Get Feature Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/feature/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_feature_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_feature_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/feature/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


