# Python SDK for the FastFuels API

## Quick-Links

[Documentation](https://silvxlabs.github.io/fastfuels-sdk-python/) - [PyPi Package](https://pypi.org/project/fastfuels-sdk/) - [Project Description](https://www.firelab.org/project/fastfuels-3d-fuels-next-generation-fire-models)

## What is FastFuels?

FastFuels is an innovative solution that propels the use of advanced 3D fire
models into the future of fire and fuels management. It acts as a "3D fuels
superhighway," seamlessly merging existing data sources with cutting-edge
modeling to produce the detailed 3D fuel data required by these models. With
its unique ability to generate and manage comprehensive fuels data for large
areas, FastFuels enhances the precision and context of fire behavior insights
and management strategies. Moreover, it encourages the incorporation of new
data sources and techniques in the field, ensuring its relevance and
adaptability in the dynamic landscape of remote sensing and wildland fuels
science. Stay tuned as we continue to develop and refine FastFuels, paving the
way for next-generation fire models.

Read more here: https://www.firelab.org/project/fastfuels-3d-fuels-next-generation-fire-models

## What is the FastFuels API?

The FastFuels API is a RESTful web service that allows users to access
FastFuels data products and services.

## How do I use the FastFuels API?

The API can be accessed using any HTTP client, such as curl, wget, or a
web browser at this address: https://fastfuels.silvx.io

## What is the FastFuels Python SDK?

The FastFuels Python SDK is a Python package that provides a convenient
interface to the FastFuels API. It allows users to access FastFuels data
products in a familiar Python environment.

### Installation

The FastFuels Python SDK can be installed using pip:

```bash
pip install fastfuels-sdk
```

### Documentation

Documentation for the FastFuels Python SDK can be found here: https://silvxlabs.github.io/fastfuels-sdk-python/

Additional examples can be found in the following repository: https://github.com/silvxlabs/demos
