# **wix3msi**
이 파이썬 패키지는 Wix Toolset v3의 MSI 파일 생성 기능을 보조하는 윈도우 전용 라이브러리 패키지 입니다.   


## **MSI가 무엇인가?**
MSI는 Microsoft Installer의 약자로서 Windows OS에 개발의 결과물을 설치 형태로 배포하고 싶을 때 사용하는 윈도우 전용 파일 포맷입니다.   
사실 공식 Windows SDK를 받으면 그 안에 Microsoft Windows Installer SDK 구성요소가 존재하며, 이를 통해 설치 파일을 만드는 것이 정석적인 개발 방법입니다.   
다만, 해당 SDK는 파이썬을 공식적으로 지원해주지 않기 때문에 Basic, C++, C# 중 하나의 언어를 사용해서 개발해야 합니다.   


## **파이썬 자체적으로는 MSI를 만들 수 없을까??**
원래는 파이썬에서도 별다른 설정없이도 MSI를 만들 수 있도록 msilib 패키지를 배포판에 내장하고 있습니다.   
그러나 msilib는 현재 deprecated 된 상태이며, 파이썬 3.13 이후부터는 아예 배포에서 제거되었습니다.   


## ** MSI를 만들어주는 별도의 파이썬 패키지는 없나??**
확인을 해봤는데 cx_Freeze, pywin32 패키지를 설치해도 MSI 파일을 생성 할 수 있습니다.
다만, 두 패키지 모두 실제 MSI에 대한 활용면에서 아쉬움을 느꼈습니다.
cx_Freeze는 실행가능한 바이너리 파일을 패키징하는 라이브러리로 MSI는 패키징한 라이브러리를 설치버전으로 제공 할 수 있게 한다는 정도의 기능이라 MSI 자체를 활용하는데 있어서 필요 기능을 제공하지 않습니다.   
pywin32는 WindowsAPI의 사용에 목적을 두고 있는 라이브러리로 MSI 자체를 지원한다기보다는 COM 객체 기능을 통해 우회하여 MSI 제작 기능에 접근해서 작업하는지라 배보다 배꼽이 더 큰 경우입니다.   
따라서 사용해볼만한 무료 솔루션을 알아보던 중 현재 Wix Toolset v3 이 오픈소스로서 존재함을 알게 되었습니다.   
> 공식홈페이지: https://wixtoolset.org   
> 문서: https://wixtoolset.org/docs/v3/   
> 다운로드: https://github.com/wixtoolset/wix3/releases   


## **Wix Toolset v3 바로 쓰면 되지않나? 왜 파이썬 라이브러리로 만들고 배포하는거지?**
처음엔 저도 그렇게 생각했는데 생각보다 사용이 까다롭고 학습 곡선이 있는 편이며, 내부 규칙에 의한 수작업이 필요한 경우가 좀 있습니다.   
또한 기본적으로는 MSI 생성을 하려면 Wix는 자체적인 설정파일인 WXS 파일(XML기반)을 다룰 수 있어야 합니다.   
툴셋에서 이와 관련된 자동화 도구들을 제공하긴 하나 일부 대체가 되는 것 뿐이지 이걸 편하게 사용하려면 각각의 프로젝트마다, 버전이 달라질 때마다 일부 설정에 대한 번거로운 관리비용이 있습니다.   
저는 그러한 작업을 매번 반복하는 것으로 제 시간을 낭비하고 싶지 않기 때문에 제가 쓸 생각으로 도구를 만들고 만드는 김에 이를 배포하려고 하는 것입니다.   
당연한 이야기지만, MSI 생성에 대한 핵심 기능을 자체적으로 개발 할 생각은 전혀 없기 때문에 현재 프로젝트는 이미 존재하는 솔루션인 Wix Toolset v3의 사용을 전제로 하려고 합니다.   

## **라이선스 문제?**
저는 Wix Toolset v3 의 소스코드를 수정하거나 제 패키지에 포함시켜 재배포 하지 않습니다.   
어디까지나 해당 솔루션의 설정파일인 WXS를 만들어내는 것에 지나지 않습니다.   
따라서 라이선스 문제가 따로 일어날 일이 없습니다.   


# **설치방법**
1. https://github.com/wixtoolset/wix3/releases 에 있는 압축파일 혹은 실행파일 (설치파일)을 받아주세요.   
2. 압축해제 혹은 설치를 통해 나온 툴셋의 경로를 시스템 환경변수의 PATH에 등록해주세요.   
3. pypi에 올라간 현재 wix3msi 패키지를 설치 해주세요.   
```python
python -m pip install wix3msi
```

4. 파이썬 코드에서는 다음과 같이 사용합니다. (현재 작성 예정입니다.)   
```python
from wix3msi import ...
```

5. 터미널 명령어는 다음과 같이 사용합니다. (현재 개발 예정입니다.)   
```cmd
D:\Github\Project\> wix3msi ...
```