"use strict";
const nodeunit_1 = require("nodeunit");
const lambda = require("../lib");
module.exports = nodeunit_1.testCase({
    'runtimes are equal for different instances'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'runtimes are equal for same instance'(test) {
        // GIVEN
        const runtime = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime.runtimeEquals(runtime);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'unequal when name changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.6', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when name changes');
        test.done();
    },
    'unequal when family changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.JAVA, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when family changes');
        test.done();
    },
    'unequal when supportsInlineCode changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lambda.RuntimeFamily.PYTHON, { supportsInlineCode: false });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when supportsInlineCode changes');
        test.done();
    },
    'bundlingDockerImage points to AWS SAM build image'(test) {
        // GIVEN
        const runtime = new lambda.Runtime('my-runtime-name');
        // THEN
        test.equal(runtime.bundlingDockerImage.image, 'amazon/aws-sam-cli-build-image-my-runtime-name');
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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