import * as codebuild from '@aws-cdk/aws-codebuild';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for CodeBuildStartBuild.
 */
export interface CodeBuildStartBuildProps extends sfn.TaskStateBaseProps {
    /**
     * CodeBuild project to start.
     */
    readonly project: codebuild.IProject;
    /**
     * A set of environment variables to be used for this build only.
     *
     * @default - the latest environment variables already defined in the build project.
     */
    readonly environmentVariablesOverride?: {
        [name: string]: codebuild.BuildEnvironmentVariable;
    };
}
/**
 * Start a CodeBuild Build as a task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-codebuild.html
 */
export declare class CodeBuildStartBuild extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     *
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     *
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     *
     */
    constructor(scope: Construct, id: string, props: CodeBuildStartBuildProps);
    private configurePolicyStatements;
    private serializeEnvVariables;
}
