from requests import get
from .utils import *

class defaults:
    """
    Compiles a list of entries and categories from the API. 
    Primarily used for developing locally.
    If the class is initialized without `with_url`, no request is made
    and the default compendium data is returned (very quick, no requests
    and loops). 
    Else, the lists are compiled through a single request with 
    for loops.
    """
    def __init__(self, entries: list=None, categories: list=None):
        self.entries = [('horse', 1), ('giant horse', 2), ('white horse', 3), ('lord of the mountain', 4), ('stalhorse', 5), ('donkey', 6), ('sand seal', 7), ('patricia', 8), ('bushy-tailed squirrel', 9), ('woodland boar', 10), ('red-tusked boar', 11), ('mountain goat', 12), ('white goat', 13), ('mountain buck', 14), ('mountain doe', 15), ('water buffalo', 16), ('hateno cow', 17), ('highland sheep', 18), ('grassland fox', 19), ('snowcoat fox', 20), ('maraudo wolf', 21), ('wasteland coyote', 22), ('cold-footed wolf', 23), ('tabantha moose', 24), ('great-horned rhinoceros', 25), ('honeyvore bear', 26), ('grizzlemaw bear', 27), ('hylian retriever', 28), ('blupee', 29), ('common sparrow', 30), ('red sparrow', 31), ('blue sparrow', 32), ('rainbow sparrow', 33), ('sand sparrow', 34), ('golden sparrow', 35), ('wood pigeon', 36), ('rainbow pigeon', 37), ('hotfeather pigeon', 38), ('white pigeon', 39), ('mountain crow', 40), ('bright-chested duck', 41), ('blue-winged heron', 42), ('pink heron', 43), ('islander hawk', 44), ('seagull', 45), ('eldin ostrich', 46), ('cucco', 47), ('hyrule bass', 48), ('hearty bass', 49), ('staminoka bass', 50), ('hearty salmon', 51), ('chillfin trout', 52), ('sizzlefin trout', 53), ('voltfin trout', 54), ('stealthfin trout', 55), ('mighty carp', 56), ('armored carp', 57), ('sanke carp', 58), ('mighty porgy', 59), ('armored porgy', 60), ('sneaky river snail', 61), ('hearty blueshell snail', 62), ('razorclaw crab', 63), ('ironshell crab', 64), ('bright-eyed crab', 65), ('fairy', 66), ('winterwing butterfly', 67), ('summerwing butterfly', 68), ('thunderwing butterfly', 69), ('smotherwing butterfly', 70), ('cold darner', 71), ('warm darner', 72), ('electric darner', 73), ('restless cricket', 74), ('bladed rhino beetle', 75), ('rugged rhino beetle', 76), ('energetic rhino beetle', 77), ('sunset firefly', 78), ('hot-footed frog', 79), ('tireless frog', 80), ('hightail lizard', 81), ('hearty lizard', 82), ('fireproof lizard', 83), ('master sword', 201), ('tree branch', 202), ('torch', 203), ('soup ladle', 204), ('boomerang', 205), ('spring-loaded hammer', 206), ("traveler's sword", 207), ("soldier's broadsword", 208), ("knight's broadsword", 209), ('royal broadsword', 210), ("forest dweller's sword", 211), ('zora sword', 212), ('feathered edge', 213), ('gerudo scimitar', 214), ('moonlight scimitar', 215), ('scimitar of the seven', 216), ('eightfold blade', 217), ('ancient short sword', 218), ('rusty broadsword', 219), ("royal guard's sword", 220), ('flameblade', 221), ('frostblade', 222), ('thunderblade', 223), ('boko club', 224), ('spiked boko club', 225), ('dragonbone boko club', 226), ('lizal boomerang', 227), ('lizal forked boomerang', 228), ('lizal tri-boomerang', 229), ('guardian sword', 230), ('guardian sword+', 231), ('guardian sword++', 232), ('lynel sword', 233), ('mighty lynel sword', 234), ('savage lynel sword', 235), ('fire rod', 236), ('meteor rod', 237), ('ice rod', 238), ('blizzard rod', 239), ('lightning rod', 240), ('thunderstorm rod', 241), ('vicious sickle', 242), ('demon carver', 243), ('one-hit obliterator', 244), ('bokoblin arm', 245), ('lizalfos arm', 246), ('korok leaf', 247), ('farming hoe', 248), ('boat oar', 249), ("woodcutter's axe", 250), ('double axe', 251), ('iron sledgehammer', 252), ('giant boomerang', 253), ("traveler's claymore", 254), ("soldier's claymore", 255), ("knight's claymore", 256), ('royal claymore', 257), ('silver longsword', 258), ('cobble crusher', 259), ('stone smasher', 260), ('boulder breaker', 261), ('golden claymore', 262), ('eightfold longblade', 263), ('edge of duality', 264), ('ancient bladesaw', 265), ('rusty claymore', 266), ("royal guard's claymore", 267), ('great flameblade', 268), ('great frostblade', 269), ('great thunderblade', 270), ('boko bat', 271), ('spiked boko bat', 272), ('dragonbone boko bat', 273), ('moblin club', 274), ('spiked moblin club', 275), ('dragonbone moblin club', 276), ('ancient battle axe', 277), ('ancient battle axe+', 278), ('ancient battle axe++', 279), ('lynel crusher', 280), ('mighty lynel crusher', 281), ('savage lynel crusher', 282), ('windcleaver', 283), ('moblin arm', 284), ('wooden mop', 285), ("farmer's pitchfork", 286), ('fishing harpoon', 287), ('throwing spear', 288), ("traveler's spear", 289), ("soldier's spear", 290), ("knight's halberd", 291), ('royal halberd', 292), ("forest dweller's spear", 293), ('zora spear', 294), ('silverscale spear', 295), ('ceremonial trident', 296), ('lightscale trident', 297), ('drillshaft', 298), ('feathered spear', 299), ('gerudo spear', 300), ('serpentine spear', 301), ('ancient spear', 302), ('rusty halberd', 303), ("royal guard's spear", 304), ('flamespear', 305), ('frostspear', 306), ('thunderspear', 307), ('boko spear', 308), ('spiked boko spear', 309), ('dragonbone boko spear', 310), ('moblin spear', 311), ('spiked moblin spear', 312), ('dragonbone moblin spear', 313), ('lizal spear', 314), ('enhanced lizal spear', 315), ('forked lizal spear', 316), ('guardian spear', 317), ('guardian spear+', 318), ('guardian spear++', 319), ('lynel spear', 320), ('mighty lynel spear', 321), ('savage lynel spear', 322), ('bow of light', 323), ('wooden bow', 324), ("traveler's bow", 325), ("soldier's bow", 326), ("knight's bow", 327), ('royal bow', 328), ("forest dweller's bow", 329), ('silver bow', 330), ('swallow bow', 331), ('falcon bow', 332), ('great eagle bow', 333), ('golden bow', 334), ('phrenic bow', 335), ('ancient bow', 336), ("royal guard's bow", 337), ('boko bow', 338), ('spiked boko bow', 339), ('dragon bone boko bow', 340), ('lizal bow', 341), ('strengthened lizal bow', 342), ('steel lizal bow', 343), ('lynel bow', 344), ('mighty lynel bow', 345), ('savage lynel bow', 346), ('duplex bow', 347), ('arrow', 348), ('fire arrow', 349), ('ice arrow', 350), ('shock arrow', 351), ('bomb arrow', 352), ('ancient arrow', 353), ('hylian shield', 354), ('pot lid', 355), ('wooden shield', 356), ('emblazoned shield', 357), ("hunter's shield", 358), ("fisherman's shield", 359), ("traveler's shield", 360), ("soldier's shield", 361), ("knight's shield", 362), ('royal shield', 363), ("forest dweller's shield", 364), ('silver shield', 365), ('kite shield', 366), ('gerudo shield', 367), ('radiant shield', 368), ('daybreaker', 369), ("shield of the mind's eye", 370), ('ancient shield', 371), ('rusty shield', 372), ("royal guard's shield", 373), ('boko shield', 374), ('spiked boko shield', 375), ('dragonbone boko shield', 376), ('lizal shield', 377), ('reinforced lizal shield', 378), ('steel lizal shield', 379), ('guardian shield', 380), ('guardian shield+', 381), ('guardian shield++', 382), ('lynel shield', 383), ('mighty lynel shield', 384), ('savage lynel shield', 385), ('apple', 165), ('palm fruit', 166), ('wildberry', 167), ('hearty durian', 168), ('hydromelon', 169), ('spicy pepper', 170), ('voltfruit', 171), ('fleet-lotus seeds', 172), ('mighty bananas', 173), ('hylian shroom', 174), ('endura shroom', 175), ('stamella shroom', 176), ('hearty truffle', 177), ('big hearty truffle', 178), ('chillshroom', 179), ('sunshroom', 180), ('zapshroom', 181), ('rushroom', 182), ('razorshroom', 183), ('ironshroom', 184), ('silent shroom', 185), ('hyrule herb', 186), ('hearty radish', 187), ('big hearty radish', 188), ('cool safflina', 189), ('warm safflina', 190), ('electric safflina', 191), ('swift carrot', 192), ('endura carrot', 193), ('fortified pumpkin', 194), ('swift violet', 195), ('mighty thistle', 196), ('armoranth', 197), ('blue nightshade', 198), ('silent princess', 199), ('courser bee honey', 200), ('chuchu', 84), ('fire chuchu', 85), ('ice chuchu', 86), ('electric chuchu', 87), ('keese', 88), ('fire keese', 89), ('ice keese', 90), ('electric keese', 91), ('water octorok', 92), ('forest octorok', 93), ('rock octorok', 94), ('snow octorok', 95), ('treasure octorok', 96), ('fire wizzrobe', 97), ('ice wizzrobe', 98), ('electric wizzrobe', 99), ('meteo wizzrobe', 100), ('blizzrobe', 101), ('thunder wizzrobe', 102), ('bokoblin', 103), ('blue bokoblin', 104), ('black bokoblin', 105), ('stalkoblin', 106), ('silver bokoblin', 107), ('moblin', 108), ('blue moblin', 109), ('black moblin', 110), ('stalmoblin', 111), ('silver moblin', 112), ('lizalfos', 113), ('blue lizalfos', 114), ('black lizalfos', 115), ('stalizalfos', 116), ('fire-breath lizalfos', 117), ('ice-breath lizalfos', 118), ('electric lizalfos', 119), ('silver lizalfos', 120), ('lynel', 121), ('blue-maned lynel', 122), ('white-maned lynel', 123), ('silver lynel', 124), ('guardian stalker', 125), ('guardian skywatcher', 126), ('guardian turret', 127), ('sentry', 128), ('decayed guardian', 129), ('guardian scout i', 130), ('guardian scout ii', 131), ('guardian scout iii', 132), ('guardian scout iv', 133), ('yiga footsoldier', 134), ('yiga blademaster', 135), ('master kohga', 136), ('monk maz koshia', 137), ('stone talus', 138), ('stone talus (luminous)', 139), ('stone talus (rare)', 140), ('igneo talus', 141), ('frost talus', 142), ('stone pebblit', 143), ('igneo pebblit', 144), ('frost pebblit', 145), ('igneo talus titan', 146), ('hinox', 147), ('blue hinox', 148), ('black hinox', 149), ('stalnox', 150), ('molduga', 151), ('molduking', 152), ('dinraal', 153), ('naydra', 154), ('farosh', 155), ('cursed bokoblin', 156), ('cursed moblin', 157), ('cursed lizalfos', 158), ('thunderblight ganon', 159), ('fireblight ganon', 160), ('waterblight ganon', 161), ('windblight ganon', 162), ('calamity ganon', 163), ('dark beast ganon', 164), ('treasure chest', 386), ('ore deposit', 387), ('rare ore deposit', 388), ('luminous ore deposit', 389)] if not entries else entries
        self.categories = ["creatures", "equipment", "materials", "monsters", "treasure"] if not categories else categories

    @classmethod
    def with_url(cls, url: str):
        if url == "https://botw-compendium.herokuapp.com/api/v2": return cls()

        _api = api(url)
        base = api_req(_api.base_url)
        categories = list(base.keys()) # type: ignore

        entries = []
        for category in base:
            if category == "creatures": 
                for sub_category in base[category]: 
                    for entry in base[category][sub_category]: entries.append((entry["name"], entry["id"]))
            else:
                for entry in base[category]: entries.append((entry["name"], entry["id"]))

        return cls(entries, categories)

    def get_entries(self) -> list: return self.entries
    def get_categories(self) -> list: return self.categories