from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.1'
DESCRIPTION = 'easyIntelligence is the next, easy-to-use and learn machine learning framework.'
LONG_DESCRIPTION = 'easyIntelligence is a lightweight machine learning framework that is easy to use and simple to understand.'

# Setting up
setup(
    name="easyIntelligence",
    version=VERSION,
    author="Password-Classified",
    author_email="user@example.com",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=LONG_DESCRIPTION,
    packages=find_packages(),
    keywords=['python', 'neural', 'networks', 'AI', 'ML', 'machine learning', 'easy', 'neuron', 'easyneuron', 'easyNeuron', 'easyIntelligence', 'easyintelligence'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)