/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.io.Reader;
import no.priv.garshol.duke.DukeException;

public class CSVReader {
    private Reader in;
    private char[] buf;
    private int pos;
    private int len;
    private String[] tmp;
    private char separator;
    private String file;

    public CSVReader(Reader in) throws IOException {
        this(in, 65386, null);
    }

    public CSVReader(Reader in, int buflen, String file) throws IOException {
        this.buf = new char[buflen];
        this.pos = 0;
        this.len = in.read(this.buf, 0, this.buf.length);
        this.tmp = new String[1000];
        this.in = in;
        this.separator = (char)44;
        this.file = file;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public String[] next() throws IOException {
        if (this.len == -1 || this.pos >= this.len) {
            return null;
        }
        int colno = 0;
        int rowstart = this.pos;
        int prev = this.pos - 1;
        boolean escaped_quote = false;
        boolean startquote = false;
        while (this.pos < this.len) {
            startquote = false;
            if (this.buf[this.pos] == '\"') {
                startquote = true;
                ++prev;
                ++this.pos;
            }
            while (true) {
                if (!(this.pos >= this.len || !startquote && this.buf[this.pos] == this.separator || !startquote && (this.buf[this.pos] == '\n' || this.buf[this.pos] == '\r') || startquote && this.buf[this.pos] == '\"')) {
                    ++this.pos;
                    continue;
                }
                if (this.pos + 1 >= this.len || this.buf[this.pos] != '\"' || this.buf[this.pos + 1] != '\"') break;
                escaped_quote = true;
                this.pos += 2;
            }
            this.tmp[colno++] = escaped_quote ? this.unescape(new String(this.buf, prev + 1, this.pos - prev - 1)) : new String(this.buf, prev + 1, this.pos - prev - 1);
            if (startquote) {
                // empty if block
            }
            prev = ++this.pos;
            if (this.pos >= this.len) break;
            if (this.buf[this.pos] == '\r' || this.buf[this.pos] == '\n') {
                ++this.pos;
                if (this.pos >= this.len || this.buf[this.pos] != '\n') break;
                ++this.pos;
                break;
            }
            ++this.pos;
        }
        if (this.pos >= this.len) {
            if (rowstart == 0 && this.len == this.buf.length) {
                throw new DukeException("Row length bigger than buffer size (" + this.buf.length + "); unbalanced quotes? in " + this.file);
            }
            System.arraycopy(this.buf, rowstart, this.buf, 0, this.len - rowstart);
            this.len -= rowstart;
            int read = this.in.read(this.buf, this.len, this.buf.length - this.len);
            if (read != -1) {
                this.len += read;
                this.pos = 0;
                return this.next();
            }
            this.len = -1;
            if (startquote && this.buf[this.pos - 1] != '\"' && this.buf[this.pos - 1] != '\n' && this.buf[this.pos - 2] != '\"') {
                throw new DukeException("Unbalanced quote in CSV file: " + this.file);
            }
        }
        String[] row = new String[colno];
        for (int ix = 0; ix < colno; ++ix) {
            row[ix] = this.tmp[ix];
        }
        return row;
    }

    public void close() throws IOException {
        this.in.close();
    }

    private String unescape(String val) {
        return val.replace("\"\"", "\"");
    }
}

