/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import no.priv.garshol.duke.AbstractCmdlineTool;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordImpl;
import no.priv.garshol.duke.matchers.PrintMatchListener;
import no.priv.garshol.duke.utils.CommandLineParser;
import org.xml.sax.SAXException;

public class RecordSearch
extends AbstractCmdlineTool {
    public static void main(String[] argv) throws IOException, SAXException {
        new RecordSearch().run(argv);
    }

    public void run(String[] argv) throws IOException, SAXException {
        Set<CommandLineParser.Option> options = Collections.singleton(new CommandLineParser.StringOption("maxhits", 'H'));
        argv = this.init(argv, 3, 3, options);
        int max_hits = 10000;
        if (this.parser.getOptionValue("maxhits") != null) {
            max_hits = Integer.parseInt(this.parser.getOptionValue("maxhits"));
        }
        RecordImpl prototype = new RecordImpl();
        prototype.addValue(argv[1], argv[2]);
        Collection<Record> records = this.database.findCandidateMatches(prototype);
        int hitno = 1;
        for (Record record : records) {
            PrintMatchListener.prettyPrint(record, this.config.getProperties());
            System.out.println();
            if (hitno++ != max_hits) continue;
            break;
        }
    }

    @Override
    protected void usage() {
        System.out.println("");
        System.out.println("java no.priv.garshol.duke.RecordSearch <cfgfile> <property> <query>");
        System.out.println("");
        System.out.println("  --reindex: Reindex all records before comparing");
        System.out.println("  --maxhits: Don't return more than this number of records");
    }
}

