/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import junit.framework.Assert;
import no.priv.garshol.duke.utils.NTriplesParserTest;
import no.priv.garshol.duke.utils.NTriplesWriter;
import org.junit.Before;
import org.junit.Test;

public class NTriplesWriterTest {
    private ByteArrayOutputStream out;
    private NTriplesWriter writer;
    private List<NTriplesParserTest.Statement> model;

    @Before
    public void setup() {
        this.out = new ByteArrayOutputStream();
        this.writer = new NTriplesWriter((OutputStream)this.out);
    }

    @Test
    public void testEmpty() throws IOException {
        this.writer.done();
        this.model = this.getModel();
        Assert.assertTrue((String)"empty data didn't produce empty model", (boolean)this.model.isEmpty());
    }

    @Test
    public void testOneStatement() throws IOException {
        this.writer.statement("http://a", "http://b", "foo", true);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"http://a", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"foo", (String)stmt.object);
        Assert.assertEquals((boolean)true, (boolean)stmt.literal);
    }

    @Test
    public void testOneStatementURI() throws IOException {
        this.writer.statement("http://a", "http://b", "http://c", false);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"http://a", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"http://c", (String)stmt.object);
        Assert.assertEquals((boolean)false, (boolean)stmt.literal);
    }

    @Test
    public void testBlankNode() throws IOException {
        this.writer.statement("_:foo", "http://b", "foo", true);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"_:foo", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"foo", (String)stmt.object);
        Assert.assertEquals((boolean)true, (boolean)stmt.literal);
    }

    @Test
    public void testNonAscii() throws IOException {
        this.writer.statement("http://a", "http://b", "f\u00d8\u00d8", true);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"http://a", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"f\u00d8\u00d8", (String)stmt.object);
        Assert.assertEquals((boolean)true, (boolean)stmt.literal);
    }

    @Test
    public void testReallyNonAscii() throws IOException {
        this.writer.statement("http://a", "http://b", "yi syllable tuox: \ua126", true);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"http://a", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"yi syllable tuox: \ua126", (String)stmt.object);
        Assert.assertEquals((boolean)true, (boolean)stmt.literal);
    }

    @Test
    public void testEscapingQuote() throws IOException {
        this.writer.statement("http://a", "http://b", "oida\"", true);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"http://a", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"oida\"", (String)stmt.object);
        Assert.assertEquals((boolean)true, (boolean)stmt.literal);
    }

    @Test
    public void testEscapingNewline() throws IOException {
        this.writer.statement("http://a", "http://b", "oida\nhuff", true);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"http://a", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"oida\nhuff", (String)stmt.object);
        Assert.assertEquals((boolean)true, (boolean)stmt.literal);
    }

    @Test
    public void testEscapingBackslash() throws IOException {
        this.writer.statement("http://a", "http://b", "oida\\huff", true);
        this.writer.done();
        this.model = this.getModel();
        Assert.assertEquals((int)1, (int)this.model.size());
        NTriplesParserTest.Statement stmt = this.model.get(0);
        Assert.assertEquals((String)"http://a", (String)stmt.subject);
        Assert.assertEquals((String)"http://b", (String)stmt.property);
        Assert.assertEquals((String)"oida\\huff", (String)stmt.object);
        Assert.assertEquals((boolean)true, (boolean)stmt.literal);
    }

    private List<NTriplesParserTest.Statement> getModel() throws IOException {
        return NTriplesParserTest.parse(this.out.toString());
    }
}

