/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.PersonNameComparator;
import org.junit.Before;
import org.junit.Test;

public class PersonNameComparatorTest {
    private PersonNameComparator comp;

    @Before
    public void setUp() {
        this.comp = new PersonNameComparator();
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("", ""));
    }

    @Test
    public void testEqual() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("lars marius garshol", "lars marius garshol"));
    }

    @Test
    public void testNotAtAllEqual() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("abcde fghij", "lars marius"));
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("lars marius", "abcde fghij"));
    }

    @Test
    public void testInitial() {
        Assert.assertEquals((Object)0.9, (Object)this.comp.compare("lars marius garshol", "lars m. garshol"));
        Assert.assertEquals((Object)0.9, (Object)this.comp.compare("lars m. garshol", "lars marius garshol"));
    }

    @Test
    public void testInitialWithoutPeriod() {
        Assert.assertEquals((Object)0.9, (Object)this.comp.compare("lars marius garshol", "lars m garshol"));
        Assert.assertEquals((Object)0.9, (Object)this.comp.compare("lars m garshol", "lars marius garshol"));
    }

    @Test
    public void testMissingMiddleName() {
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("lars marius garshol", "lars garshol"));
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("lars garshol", "lars marius garshol"));
    }

    @Test
    public void testMissingInitial() {
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("lars garshol", "lars m. garshol"));
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("lars m. garshol", "lars garshol"));
    }

    @Test
    public void testMissingLeadingInitial() {
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("j. william murdoch", "william murdoch"));
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("william murdoch", "j. william murdoch"));
    }

    @Test
    public void testEditDistance() {
        Assert.assertEquals((Object)0.95, (Object)this.comp.compare("lars marius garshol", "lars marus garshol"));
        Assert.assertEquals((Object)0.95, (Object)this.comp.compare("lars marus garshol", "lars marius garshol"));
    }

    @Test
    public void testSingleWordDiff() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("abcde", "lars"));
    }

    @Test
    public void testReversedOrder() {
        Assert.assertEquals((Object)0.9, (Object)this.comp.compare("zhu bin", "bin zhu"));
    }

    @Test
    public void testOneCharDifference() {
        Assert.assertEquals((Object)0.95, (Object)this.comp.compare("bernardo cuencagrau", "bernardo cuenca grau"));
    }

    @Test
    public void testOneCharDifference2() {
        Assert.assertEquals((Object)0.6, (Object)this.comp.compare("liang du", "liang xu"));
    }

    @Test
    public void testOneCharDifference3() {
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("liang gang", "liang wang"));
    }

    @Test
    public void testShortenedGivenName() {
        Assert.assertEquals((Object)0.9, (Object)this.comp.compare("chris welty", "christopher welty"));
    }
}

