/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import junit.framework.Assert;
import no.priv.garshol.duke.cleaners.PhoneNumberCleaner;
import org.junit.Before;
import org.junit.Test;

public class PhoneNumberCleanerTest {
    private PhoneNumberCleaner cleaner;

    @Before
    public void setup() {
        this.cleaner = new PhoneNumberCleaner();
    }

    @Test
    public void testEmpty() {
        Assert.assertTrue((this.cleaner.clean("") == null ? 1 : 0) != 0);
    }

    @Test
    public void testPathological() {
        this.test("123", "123");
    }

    @Test
    public void testUKInitialZero() {
        this.test("+44 020 77921414", "+44 2077921414");
    }

    @Test
    public void testNorwaySpace() {
        this.test("+47 23 155100", "+47 23155100");
    }

    @Test
    public void testNorwayWithoutCode() {
        this.test("23 21 20 00", "23212000");
    }

    @Test
    public void testZeroZeroSweden() {
        this.test("00 46 8 506 16100", "+46 850616100");
    }

    @Test
    public void testZeroZeroGermany() {
        this.test("00 49 30 881 3001", "+49 308813001");
    }

    @Test
    public void testUSNumber() {
        this.test("+ 1 212 554 6120", "+1 2125546120");
    }

    @Test
    public void testSwedenInitialZero() {
        this.test("+46 (0)31 751 5300 ", "+46 317515300");
    }

    @Test
    public void testFinland() {
        this.test("+358 40 7600231", "+358 407600231");
    }

    @Test
    public void testParenthesis() {
        this.test("0047 (0)55551000", "+47 55551000");
    }

    private void test(String value, String result) {
        Assert.assertEquals((String)result, (String)this.cleaner.clean(value));
    }
}

