"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class VortexMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ANY_FIELD_NUMBER: builtins.int
    VORTEX_EVENT_CREATED_AT_FIELD_NUMBER: builtins.int
    VORTEX_CLIENT_SENT_AT_FIELD_NUMBER: builtins.int
    VORTEX_BACKEND_RECEIVED_AT_FIELD_NUMBER: builtins.int
    VORTEX_BACKEND_PROCESSED_AT_FIELD_NUMBER: builtins.int
    @property
    def any(self) -> google.protobuf.any_pb2.Any:
        """this can encapsulate any known protobuf message type.

        https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/any.proto
        """

    @property
    def vortex_event_created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time that the event was created by the client. this could
        be different than the time that the event was sent to vortex,
        since the client may buffer events before sending them.
        """

    @property
    def vortex_client_sent_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time that the client sent the message to vortex (recorded
        by the vortex client library automatically).
        """

    @property
    def vortex_backend_received_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time that the vortex api received the message."""

    @property
    def vortex_backend_processed_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time that the vortex backend fully processed the message."""

    def __init__(
        self,
        *,
        any: google.protobuf.any_pb2.Any | None = ...,
        vortex_event_created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        vortex_client_sent_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        vortex_backend_received_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        vortex_backend_processed_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["any", b"any", "vortex_backend_processed_at", b"vortex_backend_processed_at", "vortex_backend_received_at", b"vortex_backend_received_at", "vortex_client_sent_at", b"vortex_client_sent_at", "vortex_event_created_at", b"vortex_event_created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["any", b"any", "vortex_backend_processed_at", b"vortex_backend_processed_at", "vortex_backend_received_at", b"vortex_backend_received_at", "vortex_client_sent_at", b"vortex_client_sent_at", "vortex_event_created_at", b"vortex_event_created_at"]) -> None: ...

global___VortexMessage = VortexMessage

@typing.final
class VortexMessageBatch(google.protobuf.message.Message):
    """internal canonical message for vortex events. this is what
    you receive when you integrate a streaming consumer with vortex.
    it is also what vortex uses internally on its queue.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """a UUID which is a unique identifier for the event, it can be
    provided by the client or autogenerated by the vortex  client
    library.
    """
    @property
    def payload(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VortexMessage]:
        """the data that was sent to vortex originally. it is retained
        here so that consumers can re-construct the original message
        exactly as they sent it. clients will construct this from
        a valid protobuf message.

        each batch can contain many different message types. this
        will be hidden away from streaming consumers, who will instead
        see the exact protobufs requested come through in their
        subscription.
        """

    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        payload: collections.abc.Iterable[global___VortexMessage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["payload", b"payload", "request_id", b"request_id"]) -> None: ...

global___VortexMessageBatch = VortexMessageBatch

@typing.final
class VortexDeadLetterMessage(google.protobuf.message.Message):
    """a message that is sent to the dead letter queue when a message
    is rejected by vortex.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_URL_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    VALUE_BYTES_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    type_url: builtins.str
    """type url of failed message"""
    value: builtins.str
    """a best effort attempt at serializing the rejected message."""
    value_bytes: builtins.bytes
    """original bytes of failed message (for reconstructing or replaying events)."""
    reason: builtins.str
    """the reason that the message was rejected."""
    def __init__(
        self,
        *,
        type_url: builtins.str = ...,
        value: builtins.str = ...,
        value_bytes: builtins.bytes = ...,
        reason: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["reason", b"reason", "type_url", b"type_url", "value", b"value", "value_bytes", b"value_bytes"]) -> None: ...

global___VortexDeadLetterMessage = VortexDeadLetterMessage

@typing.final
class VortexMessageEnrichment(google.protobuf.message.Message):
    """Base enriched event data that all telemetry events inherit from
    Should be explicitly defined as a field "enrichment"
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLIENT_IP_FIELD_NUMBER: builtins.int
    CLIENT_PLATFORM_FIELD_NUMBER: builtins.int
    USER_AGENT_FIELD_NUMBER: builtins.int
    @property
    def client_ip(self) -> global___VortexClientIp:
        """IP address and proxy information of the client"""

    @property
    def client_platform(self) -> global___VortexClientPlatform:
        """Information about the client platform, including service, client, and library versions"""

    @property
    def user_agent(self) -> global___VortexUserAgent:
        """User agent information for web-based events"""

    def __init__(
        self,
        *,
        client_ip: global___VortexClientIp | None = ...,
        client_platform: global___VortexClientPlatform | None = ...,
        user_agent: global___VortexUserAgent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_ip", b"client_ip", "client_platform", b"client_platform", "user_agent", b"user_agent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_ip", b"client_ip", "client_platform", b"client_platform", "user_agent", b"user_agent"]) -> None: ...

global___VortexMessageEnrichment = VortexMessageEnrichment

@typing.final
class VortexClientIp(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_FIELD_NUMBER: builtins.int
    PROXY_FIELD_NUMBER: builtins.int
    GEO_FIELD_NUMBER: builtins.int
    ip: builtins.str
    """The IP address of the client"""
    proxy: builtins.bool
    """Whether the IP address is from a proxy service"""
    @property
    def geo(self) -> global___VortexGeolocation:
        """Geographic location information for this IP address"""

    def __init__(
        self,
        *,
        ip: builtins.str = ...,
        proxy: builtins.bool = ...,
        geo: global___VortexGeolocation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["geo", b"geo"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["geo", b"geo", "ip", b"ip", "proxy", b"proxy"]) -> None: ...

global___VortexClientIp = VortexClientIp

@typing.final
class VortexGeolocation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNTRY_FIELD_NUMBER: builtins.int
    CITY_FIELD_NUMBER: builtins.int
    LATITUDE_FIELD_NUMBER: builtins.int
    LONGITUDE_FIELD_NUMBER: builtins.int
    TIMEZONE_FIELD_NUMBER: builtins.int
    CONTINENT_FIELD_NUMBER: builtins.int
    country: builtins.str
    """Two-letter country code (ISO 3166-1 alpha-2)"""
    city: builtins.str
    """Name of the city"""
    latitude: builtins.float
    """Latitude coordinate"""
    longitude: builtins.float
    """Longitude coordinate"""
    timezone: builtins.str
    """Timezone identifier (e.g., "America/New_York")"""
    continent: builtins.str
    """Name of the continent"""
    def __init__(
        self,
        *,
        country: builtins.str = ...,
        city: builtins.str = ...,
        latitude: builtins.float = ...,
        longitude: builtins.float = ...,
        timezone: builtins.str = ...,
        continent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["city", b"city", "continent", b"continent", "country", b"country", "latitude", b"latitude", "longitude", b"longitude", "timezone", b"timezone"]) -> None: ...

global___VortexGeolocation = VortexGeolocation

@typing.final
class VortexClientPlatform(google.protobuf.message.Message):
    """Client platform info that every vortex client will set via X-Vortex-Client-Platform
    Expected format is "dbt-core/1.7.0 dbt-vortex-python/1.0.0 dbtlabs-proto/4.25.1"
    See https://github.com/dbt-labs/vortex/pull/101 for more context
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_FIELD_NUMBER: builtins.int
    SERVICE_FIELD_NUMBER: builtins.int
    SERVICE_VERSION_FIELD_NUMBER: builtins.int
    CLIENT_FIELD_NUMBER: builtins.int
    CLIENT_VERSION_FIELD_NUMBER: builtins.int
    DBT_PROTO_LIBRARY_FIELD_NUMBER: builtins.int
    DBT_PROTO_LIBRARY_VERSION_FIELD_NUMBER: builtins.int
    raw: builtins.str
    """Full header value as received"""
    service: builtins.str
    """Source service of the vortex client (i.e. dbt-core)"""
    service_version: builtins.str
    """Version of the source service"""
    client: builtins.str
    """Vortex client used (i.e. vortex-client-rust)"""
    client_version: builtins.str
    """Version of the vortex client"""
    dbt_proto_library: builtins.str
    """Name of the dbt proto library used"""
    dbt_proto_library_version: builtins.str
    """Version of the dbt proto library"""
    def __init__(
        self,
        *,
        raw: builtins.str = ...,
        service: builtins.str = ...,
        service_version: builtins.str = ...,
        client: builtins.str = ...,
        client_version: builtins.str = ...,
        dbt_proto_library: builtins.str = ...,
        dbt_proto_library_version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client", b"client", "client_version", b"client_version", "dbt_proto_library", b"dbt_proto_library", "dbt_proto_library_version", b"dbt_proto_library_version", "raw", b"raw", "service", b"service", "service_version", b"service_version"]) -> None: ...

global___VortexClientPlatform = VortexClientPlatform

@typing.final
class VortexUserAgent(google.protobuf.message.Message):
    """For web based events that send the User-Agent header"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_FIELD_NUMBER: builtins.int
    BROWSER_FIELD_NUMBER: builtins.int
    BROWSER_VERSION_FIELD_NUMBER: builtins.int
    OS_FIELD_NUMBER: builtins.int
    OS_VERSION_FIELD_NUMBER: builtins.int
    DEVICE_FIELD_NUMBER: builtins.int
    DEVICE_TYPE_FIELD_NUMBER: builtins.int
    raw: builtins.str
    """Raw User-Agent string as received from the client"""
    browser: builtins.str
    """Name of the browser (e.g., "Chrome", "Firefox")"""
    browser_version: builtins.str
    """Version of the browser"""
    os: builtins.str
    """Operating system name (e.g., "Windows", "macOS")"""
    os_version: builtins.str
    """Operating system version"""
    device: builtins.str
    """Device model or identifier"""
    device_type: builtins.str
    """Type of device (e.g., "mobile", "desktop", "tablet")"""
    def __init__(
        self,
        *,
        raw: builtins.str = ...,
        browser: builtins.str = ...,
        browser_version: builtins.str = ...,
        os: builtins.str = ...,
        os_version: builtins.str = ...,
        device: builtins.str = ...,
        device_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["browser", b"browser", "browser_version", b"browser_version", "device", b"device", "device_type", b"device_type", "os", b"os", "os_version", b"os_version", "raw", b"raw"]) -> None: ...

global___VortexUserAgent = VortexUserAgent
