import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `CfnConnector`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export interface CfnConnectorProps {
    /**
     * `AWS::KafkaConnect::Connector.Capacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-capacity
     */
    readonly capacity: CfnConnector.CapacityProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorconfiguration
     */
    readonly connectorConfiguration: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorname
     */
    readonly connectorName: string;
    /**
     * `AWS::KafkaConnect::Connector.KafkaCluster`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkacluster
     */
    readonly kafkaCluster: CfnConnector.KafkaClusterProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterClientAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication
     */
    readonly kafkaClusterClientAuthentication: CfnConnector.KafkaClusterClientAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterEncryptionInTransit`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit
     */
    readonly kafkaClusterEncryptionInTransit: CfnConnector.KafkaClusterEncryptionInTransitProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaConnectVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaconnectversion
     */
    readonly kafkaConnectVersion: string;
    /**
     * `AWS::KafkaConnect::Connector.Plugins`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-plugins
     */
    readonly plugins: Array<CfnConnector.PluginProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ServiceExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-serviceexecutionrolearn
     */
    readonly serviceExecutionRoleArn: string;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectordescription
     */
    readonly connectorDescription?: string;
    /**
     * `AWS::KafkaConnect::Connector.LogDelivery`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-logdelivery
     */
    readonly logDelivery?: CfnConnector.LogDeliveryProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.WorkerConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-workerconfiguration
     */
    readonly workerConfiguration?: CfnConnector.WorkerConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare class CfnConnector extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KafkaConnect::Connector";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConnector;
    /**
     * @external
     * @cloudformationAttribute ConnectorArn
     */
    readonly attrConnectorArn: string;
    /**
     * `AWS::KafkaConnect::Connector.Capacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-capacity
     */
    capacity: CfnConnector.CapacityProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorconfiguration
     */
    connectorConfiguration: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorname
     */
    connectorName: string;
    /**
     * `AWS::KafkaConnect::Connector.KafkaCluster`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkacluster
     */
    kafkaCluster: CfnConnector.KafkaClusterProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterClientAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication
     */
    kafkaClusterClientAuthentication: CfnConnector.KafkaClusterClientAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterEncryptionInTransit`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit
     */
    kafkaClusterEncryptionInTransit: CfnConnector.KafkaClusterEncryptionInTransitProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaConnectVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaconnectversion
     */
    kafkaConnectVersion: string;
    /**
     * `AWS::KafkaConnect::Connector.Plugins`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-plugins
     */
    plugins: Array<CfnConnector.PluginProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ServiceExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-serviceexecutionrolearn
     */
    serviceExecutionRoleArn: string;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectordescription
     */
    connectorDescription: string | undefined;
    /**
     * `AWS::KafkaConnect::Connector.LogDelivery`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-logdelivery
     */
    logDelivery: CfnConnector.LogDeliveryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KafkaConnect::Connector.WorkerConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-workerconfiguration
     */
    workerConfiguration: CfnConnector.WorkerConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::KafkaConnect::Connector`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-apachekafkacluster.html
     */
    interface ApacheKafkaClusterProperty {
        /**
         * `CfnConnector.ApacheKafkaClusterProperty.BootstrapServers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-apachekafkacluster.html#cfn-kafkaconnect-connector-apachekafkacluster-bootstrapservers
         */
        readonly bootstrapServers: string;
        /**
         * `CfnConnector.ApacheKafkaClusterProperty.Vpc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-apachekafkacluster.html#cfn-kafkaconnect-connector-apachekafkacluster-vpc
         */
        readonly vpc: CfnConnector.VpcProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html
     */
    interface AutoScalingProperty {
        /**
         * `CfnConnector.AutoScalingProperty.MaxWorkerCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-maxworkercount
         */
        readonly maxWorkerCount: number;
        /**
         * `CfnConnector.AutoScalingProperty.McuCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-mcucount
         */
        readonly mcuCount: number;
        /**
         * `CfnConnector.AutoScalingProperty.MinWorkerCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-minworkercount
         */
        readonly minWorkerCount: number;
        /**
         * `CfnConnector.AutoScalingProperty.ScaleInPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-scaleinpolicy
         */
        readonly scaleInPolicy: CfnConnector.ScaleInPolicyProperty | cdk.IResolvable;
        /**
         * `CfnConnector.AutoScalingProperty.ScaleOutPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-scaleoutpolicy
         */
        readonly scaleOutPolicy: CfnConnector.ScaleOutPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-capacity.html
     */
    interface CapacityProperty {
        /**
         * `CfnConnector.CapacityProperty.AutoScaling`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-capacity.html#cfn-kafkaconnect-connector-capacity-autoscaling
         */
        readonly autoScaling?: CfnConnector.AutoScalingProperty | cdk.IResolvable;
        /**
         * `CfnConnector.CapacityProperty.ProvisionedCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-capacity.html#cfn-kafkaconnect-connector-capacity-provisionedcapacity
         */
        readonly provisionedCapacity?: CfnConnector.ProvisionedCapacityProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-cloudwatchlogslogdelivery.html
     */
    interface CloudWatchLogsLogDeliveryProperty {
        /**
         * `CfnConnector.CloudWatchLogsLogDeliveryProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-cloudwatchlogslogdelivery.html#cfn-kafkaconnect-connector-cloudwatchlogslogdelivery-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnConnector.CloudWatchLogsLogDeliveryProperty.LogGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-cloudwatchlogslogdelivery.html#cfn-kafkaconnect-connector-cloudwatchlogslogdelivery-loggroup
         */
        readonly logGroup?: string;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-customplugin.html
     */
    interface CustomPluginProperty {
        /**
         * `CfnConnector.CustomPluginProperty.CustomPluginArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-customplugin.html#cfn-kafkaconnect-connector-customplugin-custompluginarn
         */
        readonly customPluginArn: string;
        /**
         * `CfnConnector.CustomPluginProperty.Revision`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-customplugin.html#cfn-kafkaconnect-connector-customplugin-revision
         */
        readonly revision: number;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-firehoselogdelivery.html
     */
    interface FirehoseLogDeliveryProperty {
        /**
         * `CfnConnector.FirehoseLogDeliveryProperty.DeliveryStream`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-firehoselogdelivery.html#cfn-kafkaconnect-connector-firehoselogdelivery-deliverystream
         */
        readonly deliveryStream?: string;
        /**
         * `CfnConnector.FirehoseLogDeliveryProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-firehoselogdelivery.html#cfn-kafkaconnect-connector-firehoselogdelivery-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkacluster.html
     */
    interface KafkaClusterProperty {
        /**
         * `CfnConnector.KafkaClusterProperty.ApacheKafkaCluster`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkacluster.html#cfn-kafkaconnect-connector-kafkacluster-apachekafkacluster
         */
        readonly apacheKafkaCluster: CfnConnector.ApacheKafkaClusterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterclientauthentication.html
     */
    interface KafkaClusterClientAuthenticationProperty {
        /**
         * `CfnConnector.KafkaClusterClientAuthenticationProperty.AuthenticationType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterclientauthentication.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication-authenticationtype
         */
        readonly authenticationType: string;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterencryptionintransit.html
     */
    interface KafkaClusterEncryptionInTransitProperty {
        /**
         * `CfnConnector.KafkaClusterEncryptionInTransitProperty.EncryptionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterencryptionintransit.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit-encryptiontype
         */
        readonly encryptionType: string;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-logdelivery.html
     */
    interface LogDeliveryProperty {
        /**
         * `CfnConnector.LogDeliveryProperty.WorkerLogDelivery`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-logdelivery.html#cfn-kafkaconnect-connector-logdelivery-workerlogdelivery
         */
        readonly workerLogDelivery: CfnConnector.WorkerLogDeliveryProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-plugin.html
     */
    interface PluginProperty {
        /**
         * `CfnConnector.PluginProperty.CustomPlugin`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-plugin.html#cfn-kafkaconnect-connector-plugin-customplugin
         */
        readonly customPlugin: CfnConnector.CustomPluginProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-provisionedcapacity.html
     */
    interface ProvisionedCapacityProperty {
        /**
         * `CfnConnector.ProvisionedCapacityProperty.McuCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-provisionedcapacity.html#cfn-kafkaconnect-connector-provisionedcapacity-mcucount
         */
        readonly mcuCount?: number;
        /**
         * `CfnConnector.ProvisionedCapacityProperty.WorkerCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-provisionedcapacity.html#cfn-kafkaconnect-connector-provisionedcapacity-workercount
         */
        readonly workerCount: number;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html
     */
    interface S3LogDeliveryProperty {
        /**
         * `CfnConnector.S3LogDeliveryProperty.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html#cfn-kafkaconnect-connector-s3logdelivery-bucket
         */
        readonly bucket?: string;
        /**
         * `CfnConnector.S3LogDeliveryProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html#cfn-kafkaconnect-connector-s3logdelivery-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnConnector.S3LogDeliveryProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html#cfn-kafkaconnect-connector-s3logdelivery-prefix
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleinpolicy.html
     */
    interface ScaleInPolicyProperty {
        /**
         * `CfnConnector.ScaleInPolicyProperty.CpuUtilizationPercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleinpolicy.html#cfn-kafkaconnect-connector-scaleinpolicy-cpuutilizationpercentage
         */
        readonly cpuUtilizationPercentage: number;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleoutpolicy.html
     */
    interface ScaleOutPolicyProperty {
        /**
         * `CfnConnector.ScaleOutPolicyProperty.CpuUtilizationPercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleoutpolicy.html#cfn-kafkaconnect-connector-scaleoutpolicy-cpuutilizationpercentage
         */
        readonly cpuUtilizationPercentage: number;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-vpc.html
     */
    interface VpcProperty {
        /**
         * `CfnConnector.VpcProperty.SecurityGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-vpc.html#cfn-kafkaconnect-connector-vpc-securitygroups
         */
        readonly securityGroups: string[];
        /**
         * `CfnConnector.VpcProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-vpc.html#cfn-kafkaconnect-connector-vpc-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerconfiguration.html
     */
    interface WorkerConfigurationProperty {
        /**
         * `CfnConnector.WorkerConfigurationProperty.Revision`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerconfiguration.html#cfn-kafkaconnect-connector-workerconfiguration-revision
         */
        readonly revision: number;
        /**
         * `CfnConnector.WorkerConfigurationProperty.WorkerConfigurationArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerconfiguration.html#cfn-kafkaconnect-connector-workerconfiguration-workerconfigurationarn
         */
        readonly workerConfigurationArn: string;
    }
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`.
 *
 * @external
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare namespace CfnConnector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html
     */
    interface WorkerLogDeliveryProperty {
        /**
         * `CfnConnector.WorkerLogDeliveryProperty.CloudWatchLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html#cfn-kafkaconnect-connector-workerlogdelivery-cloudwatchlogs
         */
        readonly cloudWatchLogs?: CfnConnector.CloudWatchLogsLogDeliveryProperty | cdk.IResolvable;
        /**
         * `CfnConnector.WorkerLogDeliveryProperty.Firehose`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html#cfn-kafkaconnect-connector-workerlogdelivery-firehose
         */
        readonly firehose?: CfnConnector.FirehoseLogDeliveryProperty | cdk.IResolvable;
        /**
         * `CfnConnector.WorkerLogDeliveryProperty.S3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html#cfn-kafkaconnect-connector-workerlogdelivery-s3
         */
        readonly s3?: CfnConnector.S3LogDeliveryProperty | cdk.IResolvable;
    }
}
