import { Signal } from "./signaling";
import { Keys } from "./dom";
import { PlotView } from "../models/plots/plot";
import { Toolbar } from "../models/tools/toolbar";
import { ToolView } from "../models/tools/tool";
import { RendererView } from "../models/renderers/renderer";
export declare type ScreenCoord = {
    sx: number;
    sy: number;
};
export declare type PanEvent = {
    type: "pan" | "panstart" | "panend";
    sx: number;
    sy: number;
    deltaX: number;
    deltaY: number;
    shiftKey: boolean;
    ctrlKey: boolean;
};
export declare type PinchEvent = {
    type: "pinch" | "pinchstart" | "pinchend";
    sx: number;
    sy: number;
    scale: number;
    shiftKey: boolean;
    ctrlKey: boolean;
};
export declare type RotateEvent = {
    type: "rotate" | "rotatestart" | "rotateend";
    sx: number;
    sy: number;
    rotation: number;
    shiftKey: boolean;
    ctrlKey: boolean;
};
export declare type GestureEvent = PanEvent | PinchEvent | RotateEvent;
export declare type TapEvent = {
    type: "tap" | "doubletap" | "press" | "pressup" | "contextmenu";
    sx: number;
    sy: number;
    shiftKey: boolean;
    ctrlKey: boolean;
};
export declare type MoveEvent = {
    type: "mousemove" | "mouseenter" | "mouseleave";
    sx: number;
    sy: number;
    shiftKey: boolean;
    ctrlKey: boolean;
};
export declare type ScrollEvent = {
    type: "wheel";
    sx: number;
    sy: number;
    delta: number;
    shiftKey: boolean;
    ctrlKey: boolean;
};
export declare type UIEvent = GestureEvent | TapEvent | MoveEvent | ScrollEvent;
export declare type KeyEvent = {
    type: "keyup" | "keydown";
    keyCode: Keys;
};
export declare type EventType = "pan" | "pinch" | "rotate" | "move" | "tap" | "press" | "pressup" | "scroll";
export declare type UISignal<E> = Signal<{
    id: string | null;
    e: E;
}, UIEvents>;
export declare class UIEvents implements EventListenerObject {
    readonly plot_view: PlotView;
    readonly toolbar: Toolbar;
    readonly hit_area: HTMLElement;
    readonly pan_start: UISignal<PanEvent>;
    readonly pan: UISignal<PanEvent>;
    readonly pan_end: UISignal<PanEvent>;
    readonly pinch_start: UISignal<PinchEvent>;
    readonly pinch: UISignal<PinchEvent>;
    readonly pinch_end: UISignal<PinchEvent>;
    readonly rotate_start: UISignal<RotateEvent>;
    readonly rotate: UISignal<RotateEvent>;
    readonly rotate_end: UISignal<RotateEvent>;
    readonly tap: UISignal<TapEvent>;
    readonly doubletap: UISignal<TapEvent>;
    readonly press: UISignal<TapEvent>;
    readonly pressup: UISignal<TapEvent>;
    readonly move_enter: UISignal<MoveEvent>;
    readonly move: UISignal<MoveEvent>;
    readonly move_exit: UISignal<MoveEvent>;
    readonly scroll: UISignal<ScrollEvent>;
    readonly keydown: UISignal<KeyEvent>;
    readonly keyup: UISignal<KeyEvent>;
    private readonly hammer;
    private menu;
    constructor(plot_view: PlotView, toolbar: Toolbar, hit_area: HTMLElement);
    destroy(): void;
    handleEvent(e: KeyboardEvent): void;
    protected _configure_hammerjs(): void;
    register_tool(tool_view: ToolView): void;
    private _register_tool;
    protected _hit_test_renderers(sx: number, sy: number): RendererView | null;
    protected _hit_test_frame(sx: number, sy: number): boolean;
    protected _hit_test_canvas(sx: number, sy: number): boolean;
    _trigger<E extends UIEvent>(signal: UISignal<E>, e: E, srcEvent: Event): void;
    trigger<E>(signal: UISignal<E>, e: E, id?: string | null): void;
    protected _trigger_bokeh_event(e: UIEvent): void;
    private _get_sxy;
    private _pan_event;
    private _pinch_event;
    private _rotate_event;
    private _tap_event;
    private _move_event;
    private _scroll_event;
    private _key_event;
    private _pan_start;
    private _pan;
    private _pan_end;
    private _pinch_start;
    private _pinch;
    private _pinch_end;
    private _rotate_start;
    private _rotate;
    private _rotate_end;
    private _tap;
    private _doubletap;
    private _press;
    private _pressup;
    private _mouse_enter;
    private _mouse_move;
    private _mouse_exit;
    private _mouse_wheel;
    private _context_menu;
    private _key_down;
    private _key_up;
}
