/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;
          modules[id].call(mod.exports, require, mod, mod.exports);
        } else
          cache[name] = mod;
      }

      return mod.exports;
    }
    require.resolve = function(name) {
      return ""
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);e(2),_.__exportStar(e(116),t)},
function _(t,e,n){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation.
    
    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.
    
    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
Object.defineProperty(n,"__esModule",{value:!0});var r=function(t,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)};function o(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],r=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&r>=t.length&&(t=void 0),{value:t&&t[r++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function a(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)i.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return i}function i(t){return this instanceof i?(this.v=t,this):new i(t)}n.__extends=function(t,e){function n(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)},n.__assign=function(){return n.__assign=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},n.__assign.apply(this,arguments)},n.__rest=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},n.__decorate=function(t,e,n,r){var o,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,n,r);else for(var u=t.length-1;u>=0;u--)(o=t[u])&&(i=(a<3?o(i):a>3?o(e,n,i):o(e,n))||i);return a>3&&i&&Object.defineProperty(e,n,i),i},n.__param=function(t,e){return function(n,r){e(n,r,t)}},n.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},n.__awaiter=function(t,e,n,r){return new(n||(n=Promise))((function(o,a){function i(t){try{c(r.next(t))}catch(t){a(t)}}function u(t){try{c(r.throw(t))}catch(t){a(t)}}function c(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n((function(t){t(e)}))).then(i,u)}c((r=r.apply(t,e||[])).next())}))},n.__generator=function(t,e){var n,r,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:u(0),throw:u(1),return:u(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function u(a){return function(u){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,r=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,u])}}},n.__createBinding=function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]},n.__exportStar=function(t,e){for(var n in t)"default"===n||e.hasOwnProperty(n)||(e[n]=t[n])},n.__values=o,n.__read=a,n.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(a(arguments[e]));return t},n.__spreadArrays=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],i=0,u=a.length;i<u;i++,o++)r[o]=a[i];return r},n.__await=i,n.__asyncGenerator=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},u("next"),u("throw"),u("return"),r[Symbol.asyncIterator]=function(){return this},r;function u(t){o[t]&&(r[t]=function(e){return new Promise((function(n,r){a.push([t,e,n,r])>1||c(t,e)}))})}function c(t,e){try{(n=o[t](e)).value instanceof i?Promise.resolve(n.value.v).then(f,l):s(a[0][2],n)}catch(t){s(a[0][3],t)}var n}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},n.__asyncDelegator=function(t){var e,n;return e={},r("next"),r("throw",(function(t){throw t})),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:i(t[r](e)),done:"return"===r}:o?o(e):e}:o}},n.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=o(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise((function(r,o){(function(t,e,n,r){Promise.resolve(r).then((function(e){t({value:e,done:n})}),e)})(r,o,(e=t[n](e)).done,e.value)}))}}},n.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},n.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)Object.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e.default=t,e},n.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},n.__classPrivateFieldGet=function(t,e){if(!e.has(t))throw new TypeError("attempted to get private field on non-instance");return e.get(t)},n.__classPrivateFieldSet=function(t,e,n){if(!e.has(t))throw new TypeError("attempted to set private field on non-instance");return e.set(t,n),n}},
function _(r,t,o){if(Object.defineProperty(o,"__esModule",{value:!0}),r(3),r(12),r(15),r(18),r(25),r(55),r(58),r(61),r(64),r(100),r(107),r(113),r(114),void 0===Object.is&&(Object.is=function(r,t){return r===t?0!==r||1/r==1/t:r!=r&&t!=t}),void 0===Object.values&&(Object.values=function(r){return Object.keys(r).map((function(t){return r[t]}))}),void 0===Uint8Array.prototype.fill&&(Uint8Array.prototype.fill=Array.prototype.fill,Int8Array.prototype.fill=Array.prototype.fill,Uint16Array.prototype.fill=Array.prototype.fill,Int16Array.prototype.fill=Array.prototype.fill,Uint32Array.prototype.fill=Array.prototype.fill,Int32Array.prototype.fill=Array.prototype.fill,Float32Array.prototype.fill=Array.prototype.fill,Float64Array.prototype.fill=Array.prototype.fill),void 0===Array.prototype[Symbol.iterator]){function y(){var r=0,t=this;return{next:function(){var o=t.length<=r;return{value:o?void 0:t[r++],done:o}}}}!function(){arguments.constructor.prototype[Symbol.iterator]=y,Array.prototype[Symbol.iterator]=y,Uint8Array.prototype[Symbol.iterator]=y,Int8Array.prototype[Symbol.iterator]=y,Uint16Array.prototype[Symbol.iterator]=y,Int16Array.prototype[Symbol.iterator]=y,Uint32Array.prototype[Symbol.iterator]=y,Int32Array.prototype[Symbol.iterator]=y,Float32Array.prototype[Symbol.iterator]=y,Float64Array.prototype[Symbol.iterator]=y}()}"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(r){for(var t=0;t<this.length;t++)this[t]=r[t]})},
function _(e,n,a){e(4)()||Object.defineProperty(Object,"assign",{value:e(5),configurable:!0,enumerable:!1,writable:!0})},
function _(r,t,o){t.exports=function(){var r,t=Object.assign;return"function"==typeof t&&(t(r={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),r.foo+r.bar+r.trzy==="razdwatrzy")}},
function _(t,r,n){var o=t(6),c=t(11),a=Math.max;r.exports=function(t,r){var n,f,h,i=a(arguments.length,2);for(t=Object(c(t)),h=function(o){try{t[o]=r[o]}catch(t){n||(n=t)}},f=1;f<i;++f)o(r=arguments[f]).forEach(h);if(void 0!==n)throw n;return t}},
function _(e,t,c){t.exports=e(7)()?Object.keys:e(8)},
function _(t,r,e){r.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},
function _(t,e,n){var c=t(9),r=Object.keys;e.exports=function(t){return r(c(t)?Object(t):t)}},
function _(n,r,t){var u=n(10)();r.exports=function(n){return n!==u&&null!==n}},
function _(n,o,t){o.exports=function(){}},
function _(n,r,e){var o=n(9);r.exports=function(n){if(!o(n))throw new TypeError("Cannot use null or undefined");return n}},
function _(e,n,r){e(13)()||Object.defineProperty(Object,"entries",{value:e(14),configurable:!0,enumerable:!1,writable:!0})},
function _(t,n,o){n.exports=function(){try{return"foo"===Object.entries({foo:12})[0][0]}catch(t){return!1}}},
function _(r,n,e){var t=r(11);n.exports=function(r){t(r);var n=[];for(var e in r=Object(r))propertyIsEnumerable.call(r,e)&&n.push([e,r[e]]);return n}},
function _(e,r,n){e(16)()||Object.defineProperty(Number,"isInteger",{value:e(17),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,e){t.exports=function(){var n=Number.isInteger;return"function"==typeof n&&(!n("23")&&n(34)&&!n(32.34))}},
function _(n,t,e){t.exports=function(n){return"number"==typeof n&&n%1==0}},
function _(e,r,t){e(19)()||Object.defineProperty(String.prototype,"repeat",{value:e(20),configurable:!0,enumerable:!1,writable:!0})},
function _(o,f,t){f.exports=function(){return"function"==typeof"foo".repeat&&"foofoo"==="foo".repeat(2)}},
function _(r,n,t){var o=r(11),e=r(21);n.exports=function(r){var n,t=String(o(this));if((r=e(r))<0)throw new RangeError("Count must be >= 0");if(!isFinite(r))throw new RangeError("Count must be < ∞");for(n="";r;)r%2&&(n+=t),r>1&&(t+=t),r>>=1;return n}},
function _(t,i,n){var r=t(22),a=Math.abs,o=Math.floor;i.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?r(t)*o(a(t)):t}},
function _(n,t,i){t.exports=n(23)()?Math.sign:n(24)},
function _(n,t,o){t.exports=function(){var n=Math.sign;return"function"==typeof n&&(1===n(10)&&-1===n(-20))}},
function _(n,r,t){r.exports=function(n){return n=Number(n),isNaN(n)||0===n?n:n>0?1:-1}},
function _(e,r,a){e(26)()||Object.defineProperty(Array,"from",{value:e(27),configurable:!0,enumerable:!1,writable:!0})},
function _(n,o,r){o.exports=function(){var n,o,r=Array.from;return"function"==typeof r&&(o=r(n=["raz","dwa"]),Boolean(o&&o!==n&&"dwa"===o[1]))}},
function _(e,l,r){var n=e(28).iterator,t=e(50),a=e(51),i=e(52),u=e(53),o=e(11),f=e(9),c=e(54),v=Array.isArray,h=Function.prototype.call,y={configurable:!0,enumerable:!0,writable:!0,value:null},s=Object.defineProperty;l.exports=function(e){var l,r,A,g,p,w,b,d,x,j,O=arguments[1],m=arguments[2];if(e=Object(o(e)),f(O)&&u(O),this&&this!==Array&&a(this))l=this;else{if(!O){if(t(e))return 1!==(p=e.length)?Array.apply(null,e):((g=new Array(1))[0]=e[0],g);if(v(e)){for(g=new Array(p=e.length),r=0;r<p;++r)g[r]=e[r];return g}}g=[]}if(!v(e))if(void 0!==(x=e[n])){for(b=u(x).call(e),l&&(g=new l),d=b.next(),r=0;!d.done;)j=O?h.call(O,m,d.value,r):d.value,l?(y.value=j,s(g,r,y)):g[r]=j,d=b.next(),++r;p=r}else if(c(e)){for(p=e.length,l&&(g=new l),r=0,A=0;r<p;++r)j=e[r],r+1<p&&(w=j.charCodeAt(0))>=55296&&w<=56319&&(j+=e[++r]),j=O?h.call(O,m,j,A):j,l?(y.value=j,s(g,A,y)):g[A]=j,++A;p=A}if(void 0===p)for(p=i(e.length),l&&(g=new l(p)),r=0;r<p;++r)j=O?h.call(O,m,e[r],r):e[r],l?(y.value=j,s(g,r,y)):g[r]=j;return l&&(y.value=null,g.length=p),g}},
function _(o,n,t){n.exports=o(29)()?o(30).Symbol:o(33)},
function _(t,o,r){var e=t(30),n={object:!0,symbol:!0};o.exports=function(){var t,o=e.Symbol;if("function"!=typeof o)return!1;t=o("test symbol");try{String(t)}catch(t){return!1}return!!n[typeof o.iterator]&&(!!n[typeof o.toPrimitive]&&!!n[typeof o.toStringTag])}},
function _(o,i,l){i.exports=o(31)()?globalThis:o(32)},
function _(o,r,l){r.exports=function(){return"object"==typeof globalThis&&(!!globalThis&&globalThis.Array===Array)}},
function _(t,e,o){var r=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return r()}try{return __global__||r()}finally{delete Object.prototype.__global__}}()},
function _(t,o,r){var n,e,i,c=t(34),p=t(45),y=t(30).Symbol,s=t(47),u=t(48),f=t(49),_=Object.create,a=Object.defineProperties,S=Object.defineProperty;if("function"==typeof y)try{String(y()),i=!0}catch(t){}else y=null;e=function(t){if(this instanceof e)throw new TypeError("Symbol is not a constructor");return n(t)},o.exports=n=function t(o){var r;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return i?y(o):(r=_(e.prototype),o=void 0===o?"":String(o),a(r,{__description__:c("",o),__name__:c("",s(o))}))},u(n),f(n),a(e.prototype,{constructor:c(n),toString:c("",(function(){return this.__name__}))}),a(n.prototype,{toString:c((function(){return"Symbol ("+p(this).__description__+")"})),valueOf:c((function(){return p(this)}))}),S(n.prototype,n.toPrimitive,c("",(function(){var t=p(this);return"symbol"==typeof t?t:t.toString()}))),S(n.prototype,n.toStringTag,c("c","Symbol")),S(e.prototype,n.toStringTag,c("c",n.prototype[n.toStringTag])),S(e.prototype,n.toPrimitive,c("c",n.prototype[n.toPrimitive]))},
function _(l,e,n){var r=l(35),a=l(36),t=l(40),c=l(41),i=l(42);(e.exports=function(l,e){var n,a,o,u,v;return arguments.length<2||"string"!=typeof l?(u=e,e=l,l=null):u=arguments[2],r(l)?(n=i.call(l,"c"),a=i.call(l,"e"),o=i.call(l,"w")):(n=o=!0,a=!1),v={value:e,configurable:n,enumerable:a,writable:o},u?t(c(u),v):v}).gs=function(l,e,n){var o,u,v,f;return"string"!=typeof l?(v=n,n=e,e=l,l=null):v=arguments[3],r(e)?a(e)?r(n)?a(n)||(v=n,n=void 0):n=void 0:(v=e,e=n=void 0):e=void 0,r(l)?(o=i.call(l,"c"),u=i.call(l,"e")):(o=!0,u=!1),f={get:e,set:n,configurable:o,enumerable:u},v?t(c(v),f):f}},
function _(n,t,u){t.exports=function(n){return null!=n}},
function _(t,n,o){var r=t(37),s=/^\s*class[\s{/}]/,c=Function.prototype.toString;n.exports=function(t){return!!r(t)&&!s.test(c.call(t))}},
function _(t,n,r){var e=t(38);n.exports=function(t){if("function"!=typeof t)return!1;if(!hasOwnProperty.call(t,"length"))return!1;try{if("number"!=typeof t.length)return!1;if("function"!=typeof t.call)return!1;if("function"!=typeof t.apply)return!1}catch(t){return!1}return!e(t)}},
function _(r,t,n){var o=r(39);t.exports=function(r){if(!o(r))return!1;try{return!!r.constructor&&r.constructor.prototype===r}catch(r){return!1}}},
function _(n,t,e){var o=n(35),r={object:!0,function:!0,undefined:!0};t.exports=function(n){return!!o(n)&&hasOwnProperty.call(r,typeof n)}},
function _(n,s,t){s.exports=n(4)()?Object.assign:n(5)},
function _(r,n,t){var c=r(9),o=Array.prototype.forEach,a=Object.create,e=function(r,n){var t;for(t in r)n[t]=r[t]};n.exports=function(r){var n=a(null);return o.call(arguments,(function(r){c(r)&&e(Object(r),n)})),n}},
function _(t,n,o){n.exports=t(43)()?String.prototype.contains:t(44)},
function _(n,o,t){var a="razdwatrzy";o.exports=function(){return"function"==typeof a.contains&&(!0===a.contains("dwa")&&!1===a.contains("foo"))}},
function _(t,n,r){var i=String.prototype.indexOf;n.exports=function(t){return i.call(this,t,arguments[1])>-1}},
function _(r,n,o){var t=r(46);n.exports=function(r){if(!t(r))throw new TypeError(r+" is not a symbol");return r}},
function _(o,t,n){t.exports=function(o){return!!o&&("symbol"==typeof o||!!o.constructor&&("Symbol"===o.constructor.name&&"Symbol"===o[o.constructor.toStringTag]))}},
function _(t,e,n){var r=t(34),o=Object.create,c=Object.defineProperty,u=Object.prototype,f=o(null);e.exports=function(t){for(var e,n,o=0;f[t+(o||"")];)++o;return f[t+=o||""]=!0,c(u,e="@@"+t,r.gs(null,(function(t){n||(n=!0,c(this,e,r(t)),n=!1)}))),e}},
function _(e,t,a){var s=e(34),i=e(30).Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:s("",i&&i.hasInstance||e("hasInstance")),isConcatSpreadable:s("",i&&i.isConcatSpreadable||e("isConcatSpreadable")),iterator:s("",i&&i.iterator||e("iterator")),match:s("",i&&i.match||e("match")),replace:s("",i&&i.replace||e("replace")),search:s("",i&&i.search||e("search")),species:s("",i&&i.species||e("species")),split:s("",i&&i.split||e("split")),toPrimitive:s("",i&&i.toPrimitive||e("toPrimitive")),toStringTag:s("",i&&i.toStringTag||e("toStringTag")),unscopables:s("",i&&i.unscopables||e("unscopables"))})}},
function _(r,n,e){var t=r(34),i=r(45),o=Object.create(null);n.exports=function(r){return Object.defineProperties(r,{for:t((function(n){return o[n]?o[n]:o[n]=r(String(n))})),keyFor:t((function(r){var n;for(n in i(r),o)if(o[n]===r)return n}))})}},
function _(t,n,r){var o=Object.prototype.toString,c=o.call(function(){return arguments}());n.exports=function(t){return o.call(t)===c}},
function _(t,o,n){var e=Object.prototype.toString,c=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);o.exports=function(t){return"function"==typeof t&&c(e.call(t))}},
function _(n,t,r){var a=n(21),o=Math.max;t.exports=function(n){return o(0,a(n))}},
function _(n,o,t){o.exports=function(n){if("function"!=typeof n)throw new TypeError(n+" is not a function");return n}},
function _(t,n,o){var e=Object.prototype.toString,r=e.call("");n.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||e.call(t)===r)||!1}},
function _(e,r,l){e(56)()||Object.defineProperty(Array.prototype,"fill",{value:e(57),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,f){t.exports=function(){var n=[1,2,3,4,5,6];return"function"==typeof n.fill&&"1,2,3,-1,-1,-1"===String(n.fill(-1,-3))}},
function _(t,n,i){var o=t(21),r=t(52),a=t(11),h=Math.max,v=Math.min;n.exports=function(t){var n,i=a(this),e=arguments[1],f=arguments[2],u=r(i.length);for(e=void 0===e?0:o(e),f=void 0===f?u:o(f),n=e<0?h(u+e,0):v(e,u);n<u&&n<f;++n)i[n]=t;return i}},
function _(e,a,l){e(59)()||Object.defineProperty(Math,"log10",{value:e(60),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o){t.exports=function(){var n=Math.log10;return"function"==typeof n&&.3010299956639812===n(2)}},
function _(t,a,n){var r=Math.log,N=Math.LOG10E;a.exports=function(t){return isNaN(t)||(t=Number(t))<0?NaN:0===t?-1/0:1===t?0:t===1/0?1/0:r(t)*N}},
function _(e,a,l){e(62)()||Object.defineProperty(Math,"log1p",{value:e(63),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o){t.exports=function(){var n=Math.log1p;return"function"==typeof n&&.6931471805599453===n(1)}},
function _(e,n,r){var t=Math.log;n.exports=function(e){return isNaN(e)||(e=Number(e))<-1?NaN:-1===e?-1/0:0===e?e:e===1/0?1/0:e>-1e-8&&e<1e-8?e-e*e/2:t(1+e)}},
function _(e,n,r){e(65)()||Object.defineProperty(e(66),"Set",{value:e(67),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n){e.exports=function(){var t,e;return"function"==typeof Set&&(t=new Set(["raz","dwa","trzy"]),"[object Set]"===String(t)&&(3===t.size&&("function"==typeof t.add&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.values&&(!1===(e=t.values().next()).done&&"raz"===e.value)))))))))))}},
function _(t,e,o){var r=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;if("object"==typeof globalThis&&globalThis)return globalThis;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return r()}try{return __global__||r()}finally{delete Object.prototype.__global__}}()},
function _(t,e,n){var r,i,s,o=t(68),a=t(69),_=t(73),c=t(53),u=t(34),h=t(78),l=t(28),f=t(79),p=t(81),y=t(98),v=t(99),d=Function.prototype.call,D=Object.defineProperty,g=Object.getPrototypeOf;v&&(s=Set),e.exports=r=function(){var t,e=arguments[0];if(!(this instanceof r))throw new TypeError("Constructor requires 'new'");return t=v&&_?_(new s,g(this)):this,null!=e&&f(e),D(t,"__setData__",u("c",[])),e?(p(e,(function(t){-1===a.call(this,t)&&this.push(t)}),t.__setData__),t):t},v&&(_&&_(r,s),r.prototype=Object.create(s.prototype,{constructor:u(r)})),h(Object.defineProperties(r.prototype,{add:u((function(t){return this.has(t)||this.emit("_add",this.__setData__.push(t)-1,t),this})),clear:u((function(){this.__setData__.length&&(o.call(this.__setData__),this.emit("_clear"))})),delete:u((function(t){var e=a.call(this.__setData__,t);return-1!==e&&(this.__setData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:u((function(){return new y(this,"key+value")})),forEach:u((function(t){var e,n,r,i=arguments[1];for(c(t),n=(e=this.values())._next();void 0!==n;)r=e._resolve(n),d.call(t,i,r,r,this),n=e._next()})),has:u((function(t){return-1!==a.call(this.__setData__,t)})),keys:u(i=function(){return this.values()}),size:u.gs((function(){return this.__setData__.length})),values:u((function(){return new y(this)})),toString:u((function(){return"[object Set]"}))})),D(r.prototype,l.iterator,u(i)),D(r.prototype,l.toStringTag,u("c","Set"))},
function _(t,n,i){var r=t(11);n.exports=function(){return r(this).length=0,this}},
function _(t,r,e){var i=t(70),n=t(52),o=t(11),a=Array.prototype.indexOf,h=Object.prototype.hasOwnProperty,s=Math.abs,p=Math.floor;r.exports=function(t){var r,e,f,l;if(!i(t))return a.apply(this,arguments);for(e=n(o(this).length),f=arguments[1],r=f=isNaN(f)?0:f>=0?p(f):n(this.length)-p(s(f));r<e;++r)if(h.call(this,r)&&(l=this[r],i(l)))return r;return-1}},
function _(N,e,i){e.exports=N(71)()?Number.isNaN:N(72)},
function _(n,t,o){t.exports=function(){var n=Number.isNaN;return"function"==typeof n&&(!n({})&&n(NaN)&&!n(34))}},
function _(n,t,o){t.exports=function(n){return n!=n}},
function _(t,e,o){e.exports=t(74)()?Object.setPrototypeOf:t(75)},
function _(t,e,o){var n=Object.create,r=Object.getPrototypeOf,c={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||n;return"function"==typeof t&&r(t(e(null),c))===c}},
function _(e,t,l){var r,o=e(76),n=e(11),u=Object.prototype.isPrototypeOf,_=Object.defineProperty,c={configurable:!0,enumerable:!1,writable:!0,value:void 0};r=function(e,t){if(n(e),null===t||o(t))return e;throw new TypeError("Prototype must be null or an object")},t.exports=function(e){var t,l;return e?(2===e.level?e.set?(l=e.set,t=function(e,t){return l.call(r(e,t),t),e}):t=function(e,t){return r(e,t).__proto__=t,e}:t=function e(t,l){var o;return r(t,l),(o=u.call(e.nullPolyfill,t))&&delete e.nullPolyfill.__proto__,null===l&&(l=e.nullPolyfill),t.__proto__=l,o&&_(e.nullPolyfill,"__proto__",c),t},Object.defineProperty(t,"level",{configurable:!1,enumerable:!1,writable:!1,value:e.level})):null}(function(){var e,t=Object.create(null),l={},r=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(r){try{(e=r.set).call(t,l)}catch(e){}if(Object.getPrototypeOf(t)===l)return{set:e,level:2}}return t.__proto__=l,Object.getPrototypeOf(t)===l?{level:2}:((t={}).__proto__=l,Object.getPrototypeOf(t)===l&&{level:1})}()),e(77)},
function _(n,t,o){var c=n(9),e={function:!0,object:!0};t.exports=function(n){return c(n)&&e[typeof n]||!1}},
function _(e,r,l){var t,n,o,a,i=Object.create;e(74)()||(t=e(75)),r.exports=t?1!==t.level?i:(n={},o={},a={configurable:!1,enumerable:!1,writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach((function(e){o[e]="__proto__"!==e?a:{configurable:!0,enumerable:!1,writable:!0,value:void 0}})),Object.defineProperties(n,o),Object.defineProperty(t,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:n}),function(e,r){return i(null===e?n:e,r)}):i},
function _(e,t,n){var i,l,r,c,_,o,s,a=e(34),h=e(53),f=Function.prototype.apply,u=Function.prototype.call,p=Object.create,b=Object.defineProperty,y=Object.defineProperties,O=Object.prototype.hasOwnProperty,j={configurable:!0,enumerable:!1,writable:!0};l=function(e,t){var n,l;return h(t),l=this,i.call(this,e,n=function(){r.call(l,e,n),f.call(t,this,arguments)}),n.__eeOnceListener__=t,this},_={on:i=function(e,t){var n;return h(t),O.call(this,"__ee__")?n=this.__ee__:(n=j.value=p(null),b(this,"__ee__",j),j.value=null),n[e]?"object"==typeof n[e]?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},once:l,off:r=function(e,t){var n,i,l,r;if(h(t),!O.call(this,"__ee__"))return this;if(!(n=this.__ee__)[e])return this;if("object"==typeof(i=n[e]))for(r=0;l=i[r];++r)l!==t&&l.__eeOnceListener__!==t||(2===i.length?n[e]=i[r?0:1]:i.splice(r,1));else i!==t&&i.__eeOnceListener__!==t||delete n[e];return this},emit:c=function(e){var t,n,i,l,r;if(O.call(this,"__ee__")&&(l=this.__ee__[e]))if("object"==typeof l){for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];for(l=l.slice(),t=0;i=l[t];++t)f.call(i,this,r)}else switch(arguments.length){case 1:u.call(l,this);break;case 2:u.call(l,this,arguments[1]);break;case 3:u.call(l,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];f.call(l,this,r)}}},o={on:a(i),once:a(l),off:a(r),emit:a(c)},s=y({},o),t.exports=n=function(e){return null==e?p(s):y(Object(e),o)},n.methods=_},
function _(r,n,t){var e=r(80);n.exports=function(r){if(!e(r))throw new TypeError(r+" is not iterable");return r}},
function _(r,t,n){var o=r(50),i=r(9),a=r(54),e=r(28).iterator,f=Array.isArray;t.exports=function(r){return!!i(r)&&(!!f(r)||(!!a(r)||(!!o(r)||"function"==typeof r[e])))}},
function _(r,n,t){var a=r(50),e=r(53),o=r(54),l=r(82),c=Array.isArray,i=Function.prototype.call,f=Array.prototype.some;n.exports=function(r,n){var t,u,s,y,p,A,g,v,x=arguments[2];if(c(r)||a(r)?t="array":o(r)?t="string":r=l(r),e(n),s=function(){y=!0},"array"!==t)if("string"!==t)for(u=r.next();!u.done;){if(i.call(n,x,u.value,s),y)return;u=r.next()}else for(A=r.length,p=0;p<A&&(g=r[p],p+1<A&&(v=g.charCodeAt(0))>=55296&&v<=56319&&(g+=r[++p]),i.call(n,x,g,s),!y);++p);else f.call(r,(function(r){return i.call(n,x,r,s),y}))}},
function _(n,t,e){var o=n(50),r=n(54),f=n(83),i=n(97),u=n(79),c=n(28).iterator;t.exports=function(n){return"function"==typeof u(n)[c]?n[c]():o(n)?new f(n):r(n)?new i(n):new f(n)}},
function _(t,e,r){var o,_=t(73),i=t(42),n=t(34),l=t(28),a=t(84),s=Object.defineProperty;o=e.exports=function(t,e){if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");a.call(this,t),e=e?i.call(e,"key+value")?"key+value":i.call(e,"key")?"key":"value":"value",s(this,"__kind__",n("",e))},_&&_(o,a),delete o.prototype.constructor,o.prototype=Object.create(a.prototype,{_resolve:n((function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t}))}),s(o.prototype,l.toStringTag,n("c","Array Iterator"))},
function _(_,t,e){var n,i=_(68),o=_(40),s=_(53),r=_(11),h=_(34),d=_(85),c=_(28),u=Object.defineProperty,l=Object.defineProperties;t.exports=n=function(_,t){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");l(this,{__list__:h("w",r(_)),__context__:h("w",t),__nextIndex__:h("w",0)}),t&&(s(t.on),t.on("_add",this._onAdd),t.on("_delete",this._onDelete),t.on("_clear",this._onClear))},delete n.prototype.constructor,l(n.prototype,o({_next:h((function(){var _;if(this.__list__)return this.__redo__&&void 0!==(_=this.__redo__.shift())?_:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()})),next:h((function(){return this._createResult(this._next())})),_createResult:h((function(_){return void 0===_?{done:!0,value:void 0}:{done:!1,value:this._resolve(_)}})),_resolve:h((function(_){return this.__list__[_]})),_unBind:h((function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)})),toString:h((function(){return"[object "+(this[c.toStringTag]||"Object")+"]"}))},d({_onAdd:h((function(_){_>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach((function(t,e){t>=_&&(this.__redo__[e]=++t)}),this),this.__redo__.push(_)):u(this,"__redo__",h("c",[_])))})),_onDelete:h((function(_){var t;_>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(t=this.__redo__.indexOf(_))&&this.__redo__.splice(t,1),this.__redo__.forEach((function(t,e){t>_&&(this.__redo__[e]=--t)}),this)))})),_onClear:h((function(){this.__redo__&&i.call(this.__redo__),this.__nextIndex__=0}))}))),u(n.prototype,c.iterator,h((function(){return this})))},
function _(e,t,n){var r,o=e(35),i=e(86),l=e(91),u=e(92),s=e(41),v=e(94),a=Function.prototype.bind,c=Object.defineProperty,f=Object.prototype.hasOwnProperty;r=function(e,t,n){var r,o=i(t)&&l(t.value);return delete(r=u(t)).writable,delete r.value,r.get=function(){return!n.overwriteDefinition&&f.call(this,e)?o:(t.value=a.call(o,n.resolveContext?n.resolveContext(this):this),c(this,e,t),this[e])},r},t.exports=function(e){var t=s(arguments[1]);return o(t.resolveContext)&&l(t.resolveContext),v(e,(function(e,n){return r(n,e,t)}))}},
function _(n,t,o){var r=n(87),u=n(35);t.exports=function(n){return u(n)?n:r(n,"Cannot use %v",arguments[1])}},
function _(r,e,n){var t=r(35),i=r(39),o=r(88),f=r(89),u=function(r,e){return r.replace("%v",f(e))};e.exports=function(r,e,n){if(!i(n))throw new TypeError(u(e,r));if(!t(r)){if("default"in n)return n.default;if(n.isOptional)return null}var f=o(n.errorMessage);throw t(f)||(f=e),new TypeError(u(f,r))}},
function _(t,n,r){var u=t(35),e=t(39),i=Object.prototype.toString;n.exports=function(t){if(!u(t))return null;if(e(t)){var n=t.toString;if("function"!=typeof n)return null;if(n===i)return null}try{return""+t}catch(t){return null}}},
function _(r,e,n){var t=r(90),u=/[\n\r\u2028\u2029]/g;e.exports=function(r){var e=t(r);return null===e?"<Non-coercible to string value>":(e.length>100&&(e=e.slice(0,99)+"…"),e=e.replace(u,(function(r){switch(r){case"\n":return"\\n";case"\r":return"\\r";case"\u2028":return"\\u2028";case"\u2029":return"\\u2029";default:throw new Error("Unexpected character")}})))}},
function _(t,r,n){r.exports=function(t){try{return t.toString()}catch(r){try{return String(t)}catch(t){return null}}}},
function _(n,t,i){var o=n(87),r=n(36);t.exports=function(n){return r(n)?n:o(n,"%v is not a plain function",arguments[1])}},
function _(n,r,t){var e=n(93),u=n(40),c=n(11);r.exports=function(n){var r=Object(c(n)),t=arguments[1],i=Object(arguments[2]);if(r!==n&&!t)return r;var f={};return t?e(t,(function(r){(i.ensure||r in n)&&(f[r]=n[r])})):u(f,n),f}},
function _(r,o,f){o.exports=r(26)()?Array.from:r(27)},
function _(n,t,o){var c=n(53),r=n(95),u=Function.prototype.call;t.exports=function(n,t){var o={},a=arguments[2];return c(t),r(n,(function(n,c,r,i){o[c]=u.call(t,a,n,c,r,i)})),o}},
function _(o,c,f){c.exports=o(96)("forEach")},
function _(t,n,o){var c=t(53),e=t(11),r=Function.prototype.bind,u=Function.prototype.call,l=Object.keys,p=Object.prototype.propertyIsEnumerable;n.exports=function(t,n){return function(o,i){var a,f=arguments[2],y=arguments[3];return o=Object(e(o)),c(i),a=l(o),y&&a.sort("function"==typeof y?r.call(y,o):void 0),"function"!=typeof t&&(t=a[t]),u.call(t,a,(function(t,c){return p.call(o,t)?u.call(i,f,o[t],t,o,c):n}))}}},
function _(t,_,e){var n,r=t(73),i=t(34),o=t(28),s=t(84),h=Object.defineProperty;n=_.exports=function(t){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");t=String(t),s.call(this,t),h(this,"__length__",i("",t.length))},r&&r(n,s),delete n.prototype.constructor,n.prototype=Object.create(s.prototype,{_next:i((function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()})),_resolve:i((function(t){var _,e=this.__list__[t];return this.__nextIndex__===this.__length__?e:(_=e.charCodeAt(0))>=55296&&_<=56319?e+this.__list__[this.__nextIndex__++]:e}))}),h(n.prototype,o.toStringTag,i("c","String Iterator"))},
function _(t,e,_){var r,i=t(73),o=t(42),n=t(34),s=t(84),a=t(28).toStringTag,c=Object.defineProperty;r=e.exports=function(t,e){if(!(this instanceof r))return new r(t,e);s.call(this,t.__setData__,t),e=e&&o.call(e,"key+value")?"key+value":"value",c(this,"__kind__",n("",e))},i&&i(r,s),r.prototype=Object.create(s.prototype,{constructor:n(r),_resolve:n((function(t){return"value"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__list__[t]]})),toString:n((function(){return"[object Set Iterator]"}))}),c(r.prototype,a,n("c","Set Iterator"))},
function _(t,e,o){e.exports="undefined"!=typeof Set&&"[object Set]"===Object.prototype.toString.call(Set.prototype)},
function _(e,a,n){e(101)()||Object.defineProperty(e(66),"Map",{value:e(102),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n){e.exports=function(){var t,e;if("function"!=typeof Map)return!1;try{t=new Map([["raz","one"],["dwa","two"],["trzy","three"]])}catch(t){return!1}return"[object Map]"===String(t)&&(3===t.size&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.get&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.set&&("function"==typeof t.values&&(!1===(e=t.entries().next()).done&&(!!e.value&&("raz"===e.value[0]&&"one"===e.value[1])))))))))))))}},
function _(t,e,a){var _,n=t(68),i=t(69),r=t(73),s=t(53),o=t(11),p=t(34),c=t(78),u=t(28),l=t(79),h=t(81),f=t(103),y=t(106),m=Function.prototype.call,D=Object.defineProperties,v=Object.getPrototypeOf;e.exports=_=function(){var t,e,a,n=arguments[0];if(!(this instanceof _))throw new TypeError("Constructor requires 'new'");return a=y&&r&&Map!==_?r(new Map,v(this)):this,null!=n&&l(n),D(a,{__mapKeysData__:p("c",t=[]),__mapValuesData__:p("c",e=[])}),n?(h(n,(function(a){var _=o(a)[0];a=a[1],-1===i.call(t,_)&&(t.push(_),e.push(a))}),a),a):a},y&&(r&&r(_,Map),_.prototype=Object.create(Map.prototype,{constructor:p(_)})),c(D(_.prototype,{clear:p((function(){this.__mapKeysData__.length&&(n.call(this.__mapKeysData__),n.call(this.__mapValuesData__),this.emit("_clear"))})),delete:p((function(t){var e=i.call(this.__mapKeysData__,t);return-1!==e&&(this.__mapKeysData__.splice(e,1),this.__mapValuesData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:p((function(){return new f(this,"key+value")})),forEach:p((function(t){var e,a,_=arguments[1];for(s(t),a=(e=this.entries())._next();void 0!==a;)m.call(t,_,this.__mapValuesData__[a],this.__mapKeysData__[a],this),a=e._next()})),get:p((function(t){var e=i.call(this.__mapKeysData__,t);if(-1!==e)return this.__mapValuesData__[e]})),has:p((function(t){return-1!==i.call(this.__mapKeysData__,t)})),keys:p((function(){return new f(this,"key")})),set:p((function(t,e){var a,_=i.call(this.__mapKeysData__,t);return-1===_&&(_=this.__mapKeysData__.push(t)-1,a=!0),this.__mapValuesData__[_]=e,a&&this.emit("_add",_,t),this})),size:p.gs((function(){return this.__mapKeysData__.length})),values:p((function(){return new f(this,"value")})),toString:p((function(){return"[object Map]"}))})),Object.defineProperty(_.prototype,u.iterator,p((function(){return this.entries()}))),Object.defineProperty(_.prototype,u.toStringTag,p("c","Map"))},
function _(t,_,e){var i,n=t(73),r=t(34),o=t(84),s=t(28).toStringTag,a=t(104),u=Object.defineProperties,c=o.prototype._unBind;i=_.exports=function(t,_){if(!(this instanceof i))return new i(t,_);o.call(this,t.__mapKeysData__,t),_&&a[_]||(_="key+value"),u(this,{__kind__:r("",_),__values__:r("w",t.__mapValuesData__)})},n&&n(i,o),i.prototype=Object.create(o.prototype,{constructor:r(i),_resolve:r((function(t){return"value"===this.__kind__?this.__values__[t]:"key"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__values__[t]]})),_unBind:r((function(){this.__values__=null,c.call(this)})),toString:r((function(){return"[object Map Iterator]"}))}),Object.defineProperty(i.prototype,s,r("c","Map Iterator"))},
function _(e,u,a){u.exports=e(105)("key","value","key+value")},
function _(r,t,n){var c=Array.prototype.forEach,o=Object.create;t.exports=function(r){var t=o(null);return c.call(arguments,(function(r){t[r]=!0})),t}},
function _(t,e,o){e.exports="undefined"!=typeof Map&&"[object Map]"===Object.prototype.toString.call(new Map)},
function _(e,a,n){e(108)()||Object.defineProperty(e(66),"WeakMap",{value:e(109),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&("function"==typeof t.set&&(t.set({},1)===t&&("function"==typeof t.delete&&("function"==typeof t.has&&"one"===t.get(e)))))}},
function _(t,e,a){var r,n=t(9),o=t(73),p=t(110),_=t(11),i=t(111),c=t(34),s=t(82),u=t(81),f=t(28).toStringTag,k=t(112),M=Array.isArray,h=Object.defineProperty,w=Object.prototype.hasOwnProperty,y=Object.getPrototypeOf;e.exports=r=function(){var t,e=arguments[0];if(!(this instanceof r))throw new TypeError("Constructor requires 'new'");return t=k&&o&&WeakMap!==r?o(new WeakMap,y(this)):this,n(e)&&(M(e)||(e=s(e))),h(t,"__weakMapData__",c("c","$weakMap$"+i())),e?(u(e,(function(e){_(e),t.set(e[0],e[1])})),t):t},k&&(o&&o(r,WeakMap),r.prototype=Object.create(WeakMap.prototype,{constructor:c(r)})),Object.defineProperties(r.prototype,{delete:c((function(t){return!!w.call(p(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)})),get:c((function(t){if(w.call(p(t),this.__weakMapData__))return t[this.__weakMapData__]})),has:c((function(t){return w.call(p(t),this.__weakMapData__)})),set:c((function(t,e){return h(p(t),this.__weakMapData__,c("c",e)),this})),toString:c((function(){return"[object WeakMap]"}))}),h(r.prototype,f,c("c","WeakMap"))},
function _(n,r,t){var o=n(76);r.exports=function(n){if(!o(n))throw new TypeError(n+" is not an Object");return n}},
function _(t,n,r){var e=Object.create(null),o=Math.random;n.exports=function(){var t;do{t=o().toString(36).slice(2)}while(e[t]);return t}},
function _(t,e,o){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},
function _(e,b,l){e(29)()||Object.defineProperty(e(30),"Symbol",{value:e(33),configurable:!0,enumerable:!1,writable:!0})},
function _(l,o,f){o.exports=l(115).polyfill()},
function _(t,e,n){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.8+1e68dce6
     */
!function(t,r){"object"==typeof n&&void 0!==e?e.exports=r():"function"==typeof define&&define.amd?define(r):t.ES6Promise=r()}(this,(function(){"use strict";function e(t){return"function"==typeof t}var n=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},r=0,o=void 0,i=void 0,s=function(t,e){v[r]=t,v[r+1]=e,2===(r+=2)&&(i?i(p):b())};var u="undefined"!=typeof window?window:void 0,c=u||{},a=c.MutationObserver||c.WebKitMutationObserver,f="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),l="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function h(){var t=setTimeout;return function(){return t(p,1)}}var v=new Array(1e3);function p(){for(var t=0;t<r;t+=2){(0,v[t])(v[t+1]),v[t]=void 0,v[t+1]=void 0}r=0}var d,_,y,m,b=void 0;function w(t,e){var n=this,r=new this.constructor(j);void 0===r[A]&&Y(r);var o=n._state;if(o){var i=arguments[o-1];s((function(){return x(o,r,i,n._result)}))}else C(n,r,t,e);return r}function g(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(j);return E(e,t),e}f?b=function(){return process.nextTick(p)}:a?(_=0,y=new a(p),m=document.createTextNode(""),y.observe(m,{characterData:!0}),b=function(){m.data=_=++_%2}):l?((d=new MessageChannel).port1.onmessage=p,b=function(){return d.port2.postMessage(0)}):b=void 0===u&&"function"==typeof t?function(){try{var t=Function("return this")().require("vertx");return void 0!==(o=t.runOnLoop||t.runOnContext)?function(){o(p)}:h()}catch(t){return h()}}():h();var A=Math.random().toString(36).substring(2);function j(){}function S(t,n,r){n.constructor===t.constructor&&r===w&&n.constructor.resolve===g?function(t,e){1===e._state?M(t,e._result):2===e._state?P(t,e._result):C(e,void 0,(function(e){return E(t,e)}),(function(e){return P(t,e)}))}(t,n):void 0===r?M(t,n):e(r)?function(t,e,n){s((function(t){var r=!1,o=function(t,e,n,r){try{t.call(e,n,r)}catch(t){return t}}(n,e,(function(n){r||(r=!0,e!==n?E(t,n):M(t,n))}),(function(e){r||(r=!0,P(t,e))}),t._label);!r&&o&&(r=!0,P(t,o))}),t)}(t,n,r):M(t,n)}function E(t,e){if(t===e)P(t,new TypeError("You cannot resolve a promise with itself"));else if(o=typeof(r=e),null===r||"object"!==o&&"function"!==o)M(t,e);else{var n=void 0;try{n=e.then}catch(e){return void P(t,e)}S(t,e,n)}var r,o}function T(t){t._onerror&&t._onerror(t._result),O(t)}function M(t,e){void 0===t._state&&(t._result=e,t._state=1,0!==t._subscribers.length&&s(O,t))}function P(t,e){void 0===t._state&&(t._state=2,t._result=e,s(T,t))}function C(t,e,n,r){var o=t._subscribers,i=o.length;t._onerror=null,o[i]=e,o[i+1]=n,o[i+2]=r,0===i&&t._state&&s(O,t)}function O(t){var e=t._subscribers,n=t._state;if(0!==e.length){for(var r=void 0,o=void 0,i=t._result,s=0;s<e.length;s+=3)r=e[s],o=e[s+n],r?x(n,r,o,i):o(i);t._subscribers.length=0}}function x(t,n,r,o){var i=e(r),s=void 0,u=void 0,c=!0;if(i){try{s=r(o)}catch(t){c=!1,u=t}if(n===s)return void P(n,new TypeError("A promises callback cannot return that same promise."))}else s=o;void 0!==n._state||(i&&c?E(n,s):!1===c?P(n,u):1===t?M(n,s):2===t&&P(n,s))}var F=0;function Y(t){t[A]=F++,t._state=void 0,t._result=void 0,t._subscribers=[]}var k=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(j),this.promise[A]||Y(this.promise),n(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?M(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&M(this.promise,this._result))):P(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;void 0===this._state&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var n=this._instanceConstructor,r=n.resolve;if(r===g){var o=void 0,i=void 0,s=!1;try{o=t.then}catch(t){s=!0,i=t}if(o===w&&void 0!==t._state)this._settledAt(t._state,e,t._result);else if("function"!=typeof o)this._remaining--,this._result[e]=t;else if(n===q){var u=new n(j);s?P(u,i):S(u,t,o),this._willSettleAt(u,e)}else this._willSettleAt(new n((function(e){return e(t)})),e)}else this._willSettleAt(r(t),e)},t.prototype._settledAt=function(t,e,n){var r=this.promise;void 0===r._state&&(this._remaining--,2===t?P(r,n):this._result[e]=n),0===this._remaining&&M(r,this._result)},t.prototype._willSettleAt=function(t,e){var n=this;C(t,void 0,(function(t){return n._settledAt(1,e,t)}),(function(t){return n._settledAt(2,e,t)}))},t}();var q=function(){function t(e){this[A]=F++,this._result=this._state=void 0,this._subscribers=[],j!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(t,e){try{e((function(e){E(t,e)}),(function(e){P(t,e)}))}catch(e){P(t,e)}}(this,e):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(t){return this.then(null,t)},t.prototype.finally=function(t){var n=this.constructor;return e(t)?this.then((function(e){return n.resolve(t()).then((function(){return e}))}),(function(e){return n.resolve(t()).then((function(){throw e}))})):this.then(t,t)},t}();return q.prototype.then=w,q.all=function(t){return new k(this,t).promise},q.race=function(t){var e=this;return n(t)?new e((function(n,r){for(var o=t.length,i=0;i<o;i++)e.resolve(t[i]).then(n,r)})):new e((function(t,e){return e(new TypeError("You must pass an array to race."))}))},q.resolve=g,q.reject=function(t){var e=new this(j);return P(e,t),e},q._setScheduler=function(t){i=t},q._setAsap=function(t){s=t},q._asap=s,q.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var n=null;try{n=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===n&&!e.cast)return}t.Promise=q},q.Promise=q,q}))},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0}),e(1).__exportStar(e(117),_)},
function _(e,r,t){var l=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var r={};if(null!=e)for(var t in e)Object.hasOwnProperty.call(e,t)&&(r[t]=e[t]);return r.default=e,r};Object.defineProperty(t,"__esModule",{value:!0});var o=e(118);t.version=o.version;var s=e(119);t.index=s.index,t.embed=l(e(119)),t.protocol=l(e(505)),t._testing=l(e(506));var n=e(134);t.logger=n.logger,t.set_log_level=n.set_log_level;var a=e(142);t.settings=a.settings;var i=e(122);t.Models=i.Models;var v=e(120);t.documents=v.documents;var _=e(507);t.safely=_.safely},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0}),o.version="2.2.1"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(1),o=e(120),s=e(134),a=e(144),u=e(128),d=e(123),i=e(131),_=e(496),l=e(498),c=e(497),f=e(496);t.add_document_standalone=f.add_document_standalone,t.index=f.index;var m=e(498);t.add_document_from_session=m.add_document_from_session;var h=e(503);t.embed_items_notebook=h.embed_items_notebook,t.kernels=h.kernels;var v=e(497);function b(e,r,t,i){return n.__awaiter(this,void 0,void 0,(function(){var f,m,h,v,b,p,g,w,y,O,k,x,B,E,H,K,R,T,j,S,D,I,J;return n.__generator(this,(function(L){switch(L.label){case 0:d.isString(e)&&(e=JSON.parse(a.unescape(e))),f={};try{for(m=n.__values(u.entries(e)),h=m.next();!h.done;h=m.next())v=n.__read(h.value,2),b=v[0],p=v[1],f[b]=o.Document.from_json(p)}catch(e){S={error:e}}finally{try{h&&!h.done&&(D=m.return)&&D.call(m)}finally{if(S)throw S.error}}g=[],L.label=1;case 1:L.trys.push([1,12,13,14]),w=n.__values(r),y=w.next(),L.label=2;case 2:return y.done?[3,11]:(O=y.value,k=c._resolve_element(O),x=c._resolve_root_elements(O),null==O.docid?[3,4]:(E=(B=g).push,[4,_.add_document_standalone(f[O.docid],k,x,O.use_for_title)]));case 3:return E.apply(B,[L.sent()]),[3,10];case 4:if(null==O.token)return[3,9];H=l._get_ws_url(t,i),s.logger.debug("embed: computed ws url: "+H),L.label=5;case 5:return L.trys.push([5,7,,8]),R=(K=g).push,[4,l.add_document_from_session(H,O.token,k,x,O.use_for_title)];case 6:return R.apply(K,[L.sent()]),console.log("Bokeh items were rendered successfully"),[3,8];case 7:return T=L.sent(),console.log("Error rendering Bokeh items:",T),[3,8];case 8:return[3,10];case 9:throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");case 10:return y=w.next(),[3,2];case 11:return[3,14];case 12:return j=L.sent(),I={error:j},[3,14];case 13:try{y&&!y.done&&(J=w.return)&&J.call(w)}finally{if(I)throw I.error}return[7];case 14:return[2,g]}}))}))}t.BOKEH_ROOT=v.BOKEH_ROOT,t.embed_item=function(e,r){return n.__awaiter(this,void 0,void 0,(function(){var t,o,s,u,d,_;return n.__generator(this,(function(l){switch(l.label){case 0:return t={},o=a.uuid4(),t[o]=e.doc,null==r&&(r=e.target_id),null!=(s=document.getElementById(r))&&s.classList.add(c.BOKEH_ROOT),(_={})[e.root_id]=r,u={roots:_,root_ids:[e.root_id],docid:o},[4,i.defer((function(){return b(t,[u])}))];case 1:return d=n.__read.apply(void 0,[l.sent(),1]),[2,d[0]]}}))}))},t.embed_items=function(e,r,t,o){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(n){switch(n.label){case 0:return[4,i.defer((function(){return b(e,r,t,o)}))];case 1:return[2,n.sent()]}}))}))}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);_.__exportStar(e(121),t),_.__exportStar(e(236),t)},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),o=e(122),a=e(118),l=e(134),i=e(428),s=e(129),_=e(130),c=e(132),u=e(146),f=e(124),d=e(128),h=n.__importStar(e(235)),v=e(140),y=e(123),p=e(387),m=e(200),w=e(196),g=e(236),x=function(){function e(e){this.document=e,this.session=null,this.subscribed_models=new Set}return e.prototype.send_event=function(e){var t=new g.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)},e.prototype.trigger=function(e){var t,r;try{for(var o=n.__values(this.subscribed_models),a=o.next();!a.done;a=o.next()){var l=a.value;null!=e.origin&&e.origin!=l||l._process_event(e)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}},e}();r.EventManager=x,x.__name__="EventManager",r.documents=[],r.DEFAULT_TITLE="Bokeh Application";var b=function(){function e(){r.documents.push(this),this._init_timestamp=Date.now(),this._title=r.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new x(this),this.idle=new _.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(e.prototype,"layoutables",{get:function(){return this._roots.filter((function(e){return e instanceof p.LayoutDOM}))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_idle",{get:function(){var e,t;try{for(var r=n.__values(this.layoutables),o=r.next();!o.done;o=r.next()){var a=o.value;if(!this._idle_roots.has(a))return!1}}catch(t){e={error:t}}finally{try{o&&!o.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return!0},enumerable:!0,configurable:!0}),e.prototype.notify_idle=function(e){this._idle_roots.set(e,!0),this.is_idle&&(l.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.event_manager.send_event(new i.DocumentReady),this.idle.emit())},e.prototype.clear=function(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},e.prototype.interactive_start=function(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new i.LODStart)),this._interactive_timestamp=Date.now()},e.prototype.interactive_stop=function(){null!=this._interactive_plot&&this._interactive_plot.trigger_event(new i.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null},e.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},e.prototype.destructively_move=function(e){var t,r,o,a;if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();var l=f.copy(this._roots);this.clear();try{for(var i=n.__values(l),s=i.next();!s.done;s=i.next()){if(null!=(u=s.value).document)throw new Error("Somehow we didn't detach "+u)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}if(0!=this._all_models.size)throw new Error("this._all_models still had stuff in it: "+this._all_models);try{for(var _=n.__values(l),c=_.next();!c.done;c=_.next()){var u=c.value;e.add_root(u)}}catch(e){o={error:e}}finally{try{c&&!c.done&&(a=_.return)&&a.call(_)}finally{if(o)throw o.error}}e.set_title(this._title)},e.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},e.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._invalidate_all_models=function(){l.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._recompute_all_models=function(){var e,t,r,o,a,l,i,s,_=new Set;try{for(var c=n.__values(this._roots),u=c.next();!u.done;u=c.next()){var f=u.value;_=h.union(_,f.references())}}catch(t){e={error:t}}finally{try{u&&!u.done&&(t=c.return)&&t.call(c)}finally{if(e)throw e.error}}var d=new Set(this._all_models.values()),v=h.difference(d,_),y=h.difference(_,d),p=new Map;try{for(var m=n.__values(_),w=m.next();!w.done;w=m.next()){var g=w.value;p.set(g.id,g)}}catch(e){r={error:e}}finally{try{w&&!w.done&&(o=m.return)&&o.call(m)}finally{if(r)throw r.error}}try{for(var x=n.__values(v),b=x.next();!b.done;b=x.next()){b.value.detach_document()}}catch(e){a={error:e}}finally{try{b&&!b.done&&(l=x.return)&&l.call(x)}finally{if(a)throw a.error}}try{for(var j=n.__values(y),k=j.next();!k.done;k=j.next()){k.value.attach_document(this)}}catch(e){i={error:e}}finally{try{k&&!k.done&&(s=j.return)&&s.call(j)}finally{if(i)throw i.error}}this._all_models=p},e.prototype.roots=function(){return this._roots},e.prototype.add_root=function(e,t){if(l.logger.debug("Adding root: "+e),!f.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new g.RootAddedEvent(this,e,t))}},e.prototype.remove_root=function(e,t){var r=this._roots.indexOf(e);if(!(r<0)){this._push_all_models_freeze();try{this._roots.splice(r,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new g.RootRemovedEvent(this,e,t))}},e.prototype.title=function(){return this._title},e.prototype.set_title=function(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new g.TitleChangedEvent(this,e,t)))},e.prototype.get_model_by_id=function(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null},e.prototype.get_model_by_name=function(e){var t,r,o=[];try{for(var a=n.__values(this._all_models.values()),l=a.next();!l.done;l=a.next()){var i=l.value;i instanceof w.Model&&i.name==e&&o.push(i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=a.return)&&r.call(a)}finally{if(t)throw t.error}}switch(o.length){case 0:return null;case 1:return o[0];default:throw new Error("Multiple models are named '"+e+"'")}},e.prototype.on_message=function(e,t){var r=this._message_callbacks.get(e);null==r?this._message_callbacks.set(e,new Set([t])):r.add(t)},e.prototype.remove_on_message=function(e,t){var r;null===(r=this._message_callbacks.get(e))||void 0===r||r.delete(t)},e.prototype._trigger_on_message=function(e,t){var r,o,a=this._message_callbacks.get(e);if(null!=a)try{for(var l=n.__values(a),i=l.next();!i.done;i=l.next()){(0,i.value)(t)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(o=l.return)&&o.call(l)}finally{if(r)throw r.error}}},e.prototype.on_change=function(e,t){void 0===t&&(t=!1),this._callbacks.has(e)||this._callbacks.set(e,t)},e.prototype.remove_on_change=function(e){this._callbacks.delete(e)},e.prototype._trigger_on_change=function(e){var t,r,o,a;try{for(var l=n.__values(this._callbacks),i=l.next();!i.done;i=l.next()){var s=n.__read(i.value,2),_=s[0];if(!s[1]&&e instanceof g.DocumentEventBatch)try{for(var c=(o=void 0,n.__values(e.events)),u=c.next();!u.done;u=c.next()){_(u.value)}}catch(e){o={error:e}}finally{try{u&&!u.done&&(a=c.return)&&a.call(c)}finally{if(o)throw o.error}}else _(e)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}},e.prototype._notify_change=function(e,t,r,n,o){this._trigger_on_change(new g.ModelChangedEvent(this,e,t,r,n,null==o?void 0:o.setter_id,null==o?void 0:o.hint))},e._references_json=function(e,t){var r,o;void 0===t&&(t=!0);var a=[];try{for(var l=n.__values(e),i=l.next();!i.done;i=l.next()){var s=i.value,_=s.struct();_.attributes=s.attributes_as_json(t),delete _.attributes.id,a.push(_)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(o=l.return)&&o.call(l)}finally{if(r)throw r.error}}return a},e._instantiate_object=function(e,t,r){var n=Object.assign(Object.assign({},r),{id:e,__deferred__:!0});return new(o.Models(t))(n)},e._instantiate_references_json=function(t,r){var o,a,l=new Map;try{for(var i=n.__values(t),s=i.next();!s.done;s=i.next()){var _=s.value,c=_.id,u=_.type,f=_.attributes||{},d=r.get(c);null==d&&(d=e._instantiate_object(c,u,f),null!=_.subtype&&d.set_subtype(_.subtype)),l.set(d.id,d)}}catch(e){o={error:e}}finally{try{s&&!s.done&&(a=i.return)&&a.call(i)}finally{if(o)throw o.error}}return l},e._resolve_refs=function(e,t,r,o){function a(e){if(c.is_ref(e)){if(t.has(e.id))return t.get(e.id);if(r.has(e.id))return r.get(e.id);throw new Error("reference "+JSON.stringify(e)+" isn't known (not in Document?)")}return u.is_NDArray_ref(e)?u.decode_NDArray(e,o):y.isArray(e)?function(e){var t,r,o=[];try{for(var l=n.__values(e),i=l.next();!i.done;i=l.next()){var s=i.value;o.push(a(s))}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return o}(e):y.isPlainObject(e)?function(e){var t,r,o={};try{for(var l=n.__values(d.entries(e)),i=l.next();!i.done;i=l.next()){var s=n.__read(i.value,2),_=s[0],c=s[1];o[_]=a(c)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return o}(e):e}return a(e)},e._initialize_references_json=function(t,r,o,a){var l,i,_,c,u,f,h=new Map;try{for(var v=n.__values(t),p=v.next();!p.done;p=v.next()){var m=p.value,w=m.id,g=m.attributes,x=!r.has(w),b=x?o.get(w):r.get(w),j=e._resolve_refs(g,r,o,a);b.setv(j,{silent:!0}),h.set(w,{instance:b,is_new:x})}}catch(e){l={error:e}}finally{try{p&&!p.done&&(i=v.return)&&i.call(v)}finally{if(l)throw l.error}}var k=[],M=new Set;function E(e){var t,r,o,a,l,i;if(e instanceof s.HasProps){if(h.has(e.id)&&!M.has(e.id)){M.add(e.id);var _=h.get(e.id),c=_.instance,u=_.is_new,f=c.attributes;try{for(var v=n.__values(d.values(f)),p=v.next();!p.done;p=v.next()){E(p.value)}}catch(e){t={error:e}}finally{try{p&&!p.done&&(r=v.return)&&r.call(v)}finally{if(t)throw t.error}}u&&(c.finalize(),k.push(c))}}else if(y.isArray(e))try{for(var m=n.__values(e),w=m.next();!w.done;w=m.next()){E(w.value)}}catch(e){o={error:e}}finally{try{w&&!w.done&&(a=m.return)&&a.call(m)}finally{if(o)throw o.error}}else if(y.isPlainObject(e))try{for(var g=n.__values(d.values(e)),x=g.next();!x.done;x=g.next()){E(x.value)}}catch(e){l={error:e}}finally{try{x&&!x.done&&(i=g.return)&&i.call(g)}finally{if(l)throw l.error}}}try{for(var S=n.__values(h.values()),C=S.next();!C.done;C=S.next()){E(C.value.instance)}}catch(e){_={error:e}}finally{try{C&&!C.done&&(c=S.return)&&c.call(S)}finally{if(_)throw _.error}}try{for(var D=n.__values(k),O=D.next();!O.done;O=D.next()){(b=O.value).connect_signals()}}catch(e){u={error:e}}finally{try{O&&!O.done&&(f=D.return)&&f.call(D)}finally{if(u)throw u.error}}},e._event_for_attribute_change=function(e,t,r,n,o){if(n.get_model_by_id(e.id).property(t).syncable){var a={kind:"ModelChanged",model:{id:e.id},attr:t,new:r};return s.HasProps._json_record_references(n,r,o,{recursive:!0}),a}return null},e._events_to_sync_objects=function(t,r,o,a){var i,s,_,c,u,d,h=Object.keys(t.attributes),y=Object.keys(r.attributes),p=f.difference(h,y),m=f.difference(y,h),w=f.intersection(h,y),g=[];try{for(var x=n.__values(p),b=x.next();!b.done;b=x.next()){var j=b.value;l.logger.warn("Server sent key "+j+" but we don't seem to have it in our JSON")}}catch(e){i={error:e}}finally{try{b&&!b.done&&(s=x.return)&&s.call(x)}finally{if(i)throw i.error}}try{for(var k=n.__values(m),M=k.next();!M.done;M=k.next()){j=M.value;var E=r.attributes[j];g.push(e._event_for_attribute_change(t,j,E,o,a))}}catch(e){_={error:e}}finally{try{M&&!M.done&&(c=k.return)&&c.call(k)}finally{if(_)throw _.error}}try{for(var S=n.__values(w),C=S.next();!C.done;C=S.next()){j=C.value;var D=t.attributes[j];E=r.attributes[j];null==D&&null==E||(null==D||null==E?g.push(e._event_for_attribute_change(t,j,E,o,a)):v.isEqual(D,E)||g.push(e._event_for_attribute_change(t,j,E,o,a)))}}catch(e){u={error:e}}finally{try{C&&!C.done&&(d=S.return)&&d.call(S)}finally{if(u)throw u.error}}return g.filter((function(e){return null!=e}))},e._compute_patch_since_json=function(t,r){var o,a,l,i,s,_,c=r.to_json(!1);function u(e){var t,r,o=new Map;try{for(var a=n.__values(e.roots.references),l=a.next();!l.done;l=a.next()){var i=l.value;o.set(i.id,i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=a.return)&&r.call(a)}finally{if(t)throw t.error}}return o}var d=u(t),h=new Map,v=[];try{for(var y=n.__values(t.roots.root_ids),p=y.next();!p.done;p=y.next()){var m=p.value;h.set(m,d.get(m)),v.push(m)}}catch(e){o={error:e}}finally{try{p&&!p.done&&(a=y.return)&&a.call(y)}finally{if(o)throw o.error}}var w=u(c),g=new Map,x=[];try{for(var b=n.__values(c.roots.root_ids),j=b.next();!j.done;j=b.next()){m=j.value;g.set(m,w.get(m)),x.push(m)}}catch(e){l={error:e}}finally{try{j&&!j.done&&(i=b.return)&&i.call(b)}finally{if(l)throw l.error}}if(v.sort(),x.sort(),f.difference(v,x).length>0||f.difference(x,v).length>0)throw new Error("Not implemented: computing add/remove of document roots");var k=new Set,M=[];try{for(var E=n.__values(r._all_models.keys()),S=E.next();!S.done;S=E.next()){var C=S.value;if(d.has(C)){var D=e._events_to_sync_objects(d.get(C),w.get(C),r,k);M=M.concat(D)}}}catch(e){s={error:e}}finally{try{S&&!S.done&&(_=E.return)&&_.call(E)}finally{if(s)throw s.error}}return{references:e._references_json(k,!1),events:M}},e.prototype.to_json_string=function(e){return void 0===e&&(e=!0),JSON.stringify(this.to_json(e))},e.prototype.to_json=function(t){void 0===t&&(t=!0);var r=this._roots.map((function(e){return e.id})),n=this._all_models.values();return{version:a.version,title:this._title,roots:{root_ids:r,references:e._references_json(n,t)}}},e.from_json_string=function(t){var r=JSON.parse(t);return e.from_json(r)},e.from_json=function(t){var r,o;l.logger.debug("Creating Document from JSON");var i=t.version,s=-1!==i.indexOf("+")||-1!==i.indexOf("-"),_="Library versions: JS ("+a.version+") / Python ("+i+")";s||a.version.replace(/-(dev|rc)\./,"$1")==i?l.logger.debug(_):(l.logger.warn("JS/Python version mismatch"),l.logger.warn(_));var c=t.roots,u=c.root_ids,f=c.references,d=e._instantiate_references_json(f,new Map);e._initialize_references_json(f,new Map,d,new Map);var h=new e;try{for(var v=n.__values(u),y=v.next();!y.done;y=v.next()){var p=y.value,m=d.get(p);null!=m&&h.add_root(m)}}catch(e){r={error:e}}finally{try{y&&!y.done&&(o=v.return)&&o.call(v)}finally{if(r)throw r.error}}return h.set_title(t.title),h},e.prototype.replace_with_json=function(t){e.from_json(t).destructively_move(this)},e.prototype.create_json_patch_string=function(e){return JSON.stringify(this.create_json_patch(e))},e.prototype.create_json_patch=function(t){var r,o,a=new Set,i=[];try{for(var s=n.__values(t),_=s.next();!_.done;_=s.next()){var c=_.value;if(c.document!==this)throw l.logger.warn("Cannot create a patch using events from a different document, event had ",c.document," we are ",this),new Error("Cannot create a patch using events from a different document");i.push(c.json(a))}}catch(e){r={error:e}}finally{try{_&&!_.done&&(o=s.return)&&o.call(s)}finally{if(r)throw r.error}}return{events:i,references:e._references_json(a)}},e.prototype.apply_json_patch=function(t,r,o){var a,i,s,_,c,u,f;void 0===r&&(r=new Map);var d=t.references,h=t.events,v=e._instantiate_references_json(d,this._all_models);r instanceof Map||(r=new Map(r));try{for(var y=n.__values(h),p=y.next();!p.done;p=y.next()){switch((O=p.value).kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var w=O.model.id,g=this._all_models.get(w);if(null!=g)v.set(w,g);else if(!v.has(w))throw l.logger.warn("Got an event for unknown model "+O.model+'"'),new Error("event model wasn't known")}}}catch(e){a={error:e}}finally{try{p&&!p.done&&(i=y.return)&&i.call(y)}finally{if(a)throw a.error}}var x=new Map,b=new Map;try{for(var j=n.__values(v),k=j.next();!k.done;k=j.next()){var M=n.__read(k.value,2),E=M[0],S=M[1];this._all_models.has(E)?x.set(E,S):b.set(E,S)}}catch(e){s={error:e}}finally{try{k&&!k.done&&(_=j.return)&&_.call(j)}finally{if(s)throw s.error}}e._initialize_references_json(d,x,b,r);try{for(var C=n.__values(h),D=C.next();!D.done;D=C.next()){var O;switch((O=D.value).kind){case"MessageSent":var z=O.msg_type,A=O.msg_data,N=void 0;if(void 0===A){if(1!=r.size)throw new Error("expected exactly one buffer");var P=n.__read(r,1);N=n.__read(P[0],2)[1]}else N=e._resolve_refs(A,x,b,r);this._trigger_on_message(z,N);break;case"ModelChanged":var R=O.model.id,J=this._all_models.get(R);if(null==J)throw new Error("Cannot apply patch to "+R+" which is not in the document");var L=O.attr;S=e._resolve_refs(O.new,x,b,r);J.setv(((f={})[L]=S,f),{setter_id:o});break;case"ColumnDataChanged":var T=O.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");N=e._resolve_refs(O.new,new Map,new Map,r);if(null!=O.cols)for(var U in B.data)U in N||(N[U]=B.data[U]);B.setv({data:N},{setter_id:o,check_eq:!1});break;case"ColumnsStreamed":T=O.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");if(!(B instanceof m.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");N=O.data;var q=O.rollover;B.stream(N,q,o);break;case"ColumnsPatched":var B;T=O.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot patch "+T+" which is not in the document");if(!(B instanceof m.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var F=O.patches;B.patch(F,o);break;case"RootAdded":var H=O.model.id,I=v.get(H);this.add_root(I,o);break;case"RootRemoved":H=O.model.id,I=v.get(H);this.remove_root(I,o);break;case"TitleChanged":this.set_title(O.title,o);break;default:throw new Error("Unknown patch event "+JSON.stringify(O))}}}catch(e){c={error:e}}finally{try{D&&!D.done&&(u=C.return)&&u.call(C)}finally{if(c)throw c.error}}},e}();r.Document=b,b.__name__="Document"},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(1),s=e(123),i=e(128),n=e(129);o.overrides={};var l=new Map;o.Models=function(e){var r=o.overrides[e]||l.get(e);if(null==r)throw new Error("Model '"+e+"' does not exist. This could be due to a widget or a custom model not being registered before first usage.");return r},o.Models.register=function(e,r){o.overrides[e]=r},o.Models.unregister=function(e){delete o.overrides[e]},o.Models.register_models=function(e,r,o){var d,a,u;if(void 0===r&&(r=!1),null!=e)try{for(var f=t.__values(i.values(e)),v=f.next();!v.done;v=f.next()){var _=v.value;if(u=_,s.isObject(u)&&u.prototype instanceof n.HasProps){var c=_.__qualified__;r||!l.has(c)?l.set(c,_):null!=o?o(c):console.warn("Model '"+c+"' was already registered")}}}catch(e){d={error:e}}finally{try{v&&!v.done&&(a=f.return)&&a.call(f)}finally{if(d)throw d.error}}},o.register_models=o.Models.register_models,o.Models.registered_names=function(){return Array.from(l.keys())};var d=t.__importStar(e(149));o.register_models(d)},
function _(r,n,t){Object.defineProperty(t,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var e=r(124),i=Object.prototype.toString;function o(r){return"[object Number]"===i.call(r)}function u(r){var n=typeof r;return"function"===n||"object"===n&&!!r}t.isBoolean=function(r){return!0===r||!1===r||"[object Boolean]"===i.call(r)},t.isNumber=o,t.isInteger=function(r){return o(r)&&Number.isInteger(r)},t.isString=function(r){return"[object String]"===i.call(r)},t.isFunction=function(r){return"[object Function]"===i.call(r)},t.isArray=function(r){return Array.isArray(r)},t.isArrayOf=function(r,n){return e.every(r,n)},t.isArrayableOf=function(r,n){for(var t=0,e=r.length;t<e;t++)if(!n(r[t]))return!1;return!0},t.isTypedArray=function(r){return ArrayBuffer.isView(r)&&!(r instanceof DataView)},t.isObject=u,t.isPlainObject=function(r){return u(r)&&(null==r.constructor||r.constructor===Object)},t.isIterable=function(r){return Symbol.iterator in Object(r)}},
function _(r,n,e){Object.defineProperty(e,"__esModule",{value:!0});var t=r(1),a=r(125),o=r(126),i=r(127);
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
e.map=i.map,e.reduce=i.reduce,e.min=i.min,e.min_by=i.min_by,e.max=i.max,e.max_by=i.max_by,e.sum=i.sum,e.cumsum=i.cumsum,e.every=i.every,e.some=i.some,e.find=i.find,e.find_last=i.find_last,e.find_index=i.find_index,e.find_last_index=i.find_last_index,e.sorted_index=i.sorted_index,e.is_empty=i.is_empty;var u=Array.prototype.slice;function f(r){return u.call(r)}function l(r){return[].concat.apply([],t.__spread(r))}function c(r,n){return-1!==r.indexOf(n)}function v(r,n,e){void 0===e&&(e=1),o.assert(e>0,"'step' must be a positive number"),null==n&&(n=r,r=0);for(var t=r<=n?e:-e,a=(0,Math.max)((0,Math.ceil)((0,Math.abs)(n-r)/e),0),i=new Array(a),u=0;u<a;u++,r+=t)i[u]=r;return i}e.head=function(r){return r[0]},e.tail=function(r){return r[r.length-1]},e.last=function(r){return r[r.length-1]},e.copy=f,e.concat=l,e.includes=c,e.contains=c,e.nth=function(r,n){return r[n>=0?n:r.length+n]},e.zip=function(){for(var r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];if(0==r.length)return[];for(var e=i.min(r.map((function(r){return r.length}))),t=r.length,a=new Array(e),o=0;o<e;o++){a[o]=new Array(t);for(var u=0;u<t;u++)a[o][u]=r[u][o]}return a},e.unzip=function(r){for(var n=r.length,e=i.min(r.map((function(r){return r.length}))),t=Array(e),a=0;a<e;a++)t[a]=new Array(n);for(var o=0;o<n;o++)for(a=0;a<e;a++)t[a][o]=r[o][a];return t},e.range=v,e.linspace=function(r,n,e){void 0===e&&(e=100);for(var t=(n-r)/(e-1),a=new Array(e),o=0;o<e;o++)a[o]=r+t*o;return a},e.transpose=function(r){for(var n=r.length,e=r[0].length,t=[],a=0;a<e;a++){t[a]=[];for(var o=0;o<n;o++)t[a][o]=r[o][a]}return t},e.argmin=function(r){return i.min_by(v(r.length),(function(n){return r[n]}))},e.argmax=function(r){return i.max_by(v(r.length),(function(n){return r[n]}))},e.sort_by=function(r,n){var e=r.map((function(r,e){return{value:r,index:e,key:n(r)}}));return e.sort((function(r,n){var e=r.key,t=n.key;if(e!==t){if(e>t||void 0===e)return 1;if(e<t||void 0===t)return-1}return r.index-n.index})),e.map((function(r){return r.value}))},e.uniq=function(r){var n,e,a=new Set;try{for(var o=t.__values(r),i=o.next();!i.done;i=o.next()){var u=i.value;a.add(u)}}catch(r){n={error:r}}finally{try{i&&!i.done&&(e=o.return)&&e.call(o)}finally{if(n)throw n.error}}return t.__spread(a)},e.uniq_by=function(r,n){var e,a,o=[],i=[];try{for(var u=t.__values(r),f=u.next();!f.done;f=u.next()){var l=f.value,v=n(l);c(i,v)||(i.push(v),o.push(l))}}catch(r){e={error:r}}finally{try{f&&!f.done&&(a=u.return)&&a.call(u)}finally{if(e)throw e.error}}return o},e.union=function(){for(var r,n,e,a,o=[],i=0;i<arguments.length;i++)o[i]=arguments[i];var u=new Set;try{for(var f=t.__values(o),l=f.next();!l.done;l=f.next()){var c=l.value;try{for(var v=(e=void 0,t.__values(c)),y=v.next();!y.done;y=v.next()){var d=y.value;u.add(d)}}catch(r){e={error:r}}finally{try{y&&!y.done&&(a=v.return)&&a.call(v)}finally{if(e)throw e.error}}}}catch(n){r={error:n}}finally{try{l&&!l.done&&(n=f.return)&&n.call(f)}finally{if(r)throw r.error}}return t.__spread(u)},e.intersection=function(r){for(var n,e,a,o,i=[],u=1;u<arguments.length;u++)i[u-1]=arguments[u];var f=[];try{r:for(var l=t.__values(r),v=l.next();!v.done;v=l.next()){var y=v.value;if(!c(f,y)){try{for(var d=(a=void 0,t.__values(i)),s=d.next();!s.done;s=d.next()){var _=s.value;if(!c(_,y))continue r}}catch(r){a={error:r}}finally{try{s&&!s.done&&(o=d.return)&&o.call(d)}finally{if(a)throw a.error}}f.push(y)}}}catch(r){n={error:r}}finally{try{v&&!v.done&&(e=l.return)&&e.call(l)}finally{if(n)throw n.error}}return f},e.difference=function(r){for(var n=[],e=1;e<arguments.length;e++)n[e-1]=arguments[e];var t=l(n);return r.filter((function(r){return!c(t,r)}))},e.remove_at=function(r,n){var e=f(r);return e.splice(n,1),e},e.remove_by=function(r,n){for(var e=0;e<r.length;)n(r[e])?r.splice(e,1):e++},e.shuffle=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++){var o=a.randomIn(0,t);o!==t&&(e[t]=e[o]),e[o]=r[t]}return e},e.pairwise=function(r,n){for(var e=r.length,t=new Array(e-1),a=0;a<e-1;a++)t[a]=n(r[a],r[a+1]);return t},e.reversed=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++)e[n-t-1]=r[t];return e},e.repeat=function(r,n){for(var e=new Array(n),t=0;t<n;t++)e[t]=r;return e}},
function _(n,r,t){function a(n){if(0==n)return 0;for(;n<=0;)n+=2*Math.PI;for(;n>2*Math.PI;)n-=2*Math.PI;return n}function e(n,r){return a(n-r)}function u(){return Math.random()}Object.defineProperty(t,"__esModule",{value:!0}),t.angle_norm=a,t.angle_dist=e,t.angle_between=function(n,r,t,u){var o=e(r,t);if(0==o)return!1;if(o==2*Math.PI)return!0;var f=a(n),i=e(r,f)<=o&&e(f,t)<=o;return 0==u?i:!i},t.random=u,t.randomIn=function(n,r){return null==r&&(r=n,n=0),n+Math.floor(Math.random()*(r-n+1))},t.atan2=function(n,r){return Math.atan2(r[1]-n[1],r[0]-n[0])},t.radians=function(n){return n*(Math.PI/180)},t.degrees=function(n){return n/(Math.PI/180)},t.rnorm=function(n,r){for(var t,a;t=u(),a=(2*(a=u())-1)*Math.sqrt(1/Math.E*2),!(-4*t*t*Math.log(t)>=a*a););var e=a/t;return e=n+r*e},t.clamp=function(n,r,t){return n<r?r:n>t?t:n}},
function _(r,e,n){Object.defineProperty(n,"__esModule",{value:!0});var t=r(1),o=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return t.__extends(e,r),e}(Error);n.AssertionError=o,o.__name__="AssertionError",n.assert=function(r,e){if(!(!0===r||!1!==r&&r()))throw new o(null!=e?e:"Assertion failed")},n.unreachable=function(){throw new Error("unreachable code")}},
function _(r,n,t){Object.defineProperty(t,"__esModule",{value:!0});var e=r(1),i=r(123),o=r(125);function u(r,n,t){for(var i,o,u=[],f=3;f<arguments.length;f++)u[f-3]=arguments[f];var a=r.length;n<0&&(n+=a),n<0?n=0:n>a&&(n=a),null==t||t>a-n?t=a-n:t<0&&(t=0);for(var l=a-t+u.length,c=new r.constructor(l),v=0;v<n;v++)c[v]=r[v];try{for(var h=e.__values(u),g=h.next();!g.done;g=h.next()){var s=g.value;c[v++]=s}}catch(r){i={error:r}}finally{try{g&&!g.done&&(o=h.return)&&o.call(h)}finally{if(i)throw i.error}}for(var d=n+t;d<a;d++)c[v++]=r[d];return c}function f(r,n){return u(r,n,r.length-n)}function a(r,n){for(var t=r.length,e=new r.constructor(t),i=0;i<t;i++)e[i]=n(r[i],i,r);return e}function l(r,n,t){var e,i,o=r.length;if(void 0===t&&0==o)throw new Error("can't reduce an empty array without an initial value");for(void 0===t?(e=r[0],i=1):(e=t,i=0);i<o;i++)e=n(e,r[i],i,r);return e}function c(r){return function(n,t){for(var e=n.length,i=r>0?0:e-1;i>=0&&i<e;i+=r)if(t(n[i]))return i;return-1}}function v(r,n){for(var t=0,e=r.length;t<e;){var i=Math.floor((t+e)/2);r[i]<n?t=i+1:e=i}return t}function h(r,n,t,e,i){var o=(i-t)/(e-n),u=o*(r-n)+t;return isFinite(u)||(u=o*(r-e)+i,isFinite(u)||t!=i||(u=t)),u}function g(r,n){if(r<n[0])return-1;if(r>n[n.length-1])return n.length;for(var t=0,e=n.length-1;e-t!=1;){var i=t+Math.floor((e-t)/2);r>=n[i]?t=i:e=i}return t}t.is_empty=function(r){return 0==r.length},t.copy=function(r){return i.isArray(r)?r.slice():new r.constructor(r)},t.splice=u,t.head=f,t.insert=function(r,n,t){return u(r,t,0,n)},t.append=function(r,n){return u(r,r.length,0,n)},t.prepend=function(r,n){return u(r,0,0,n)},t.indexOf=function(r,n){for(var t=0,e=r.length;t<e;t++)if(r[t]===n)return t;return-1},t.subselect=function(r,n){for(var t=n.length,e=new r.constructor(t),i=0;i<t;i++)e[i]=r[n[i]];return e},t.map=a,t.filter=function(r,n){for(var t=r.length,e=new r.constructor(t),i=0,o=0;o<t;o++){var u=r[o];n(u,o,r)&&(e[i++]=u)}return f(e,i)},t.reduce=l,t.min=function(r){for(var n,t=1/0,e=0,i=r.length;e<i;e++)n=r[e],!isNaN(n)&&n<t&&(t=n);return t},t.max=function(r){for(var n,t=-1/0,e=0,i=r.length;e<i;e++)n=r[e],!isNaN(n)&&n>t&&(t=n);return t},t.minmax=function(r){for(var n,t=1/0,e=-1/0,i=0,o=r.length;i<o;i++)n=r[i],isNaN(n)||(n<t&&(t=n),n>e&&(e=n));return[t,e]},t.min_by=function(r,n){if(0==r.length)throw new Error("min_by() called with an empty array");for(var t=r[0],e=n(t),i=1,o=r.length;i<o;i++){var u=r[i],f=n(u);f<e&&(t=u,e=f)}return t},t.max_by=function(r,n){if(0==r.length)throw new Error("max_by() called with an empty array");for(var t=r[0],e=n(t),i=1,o=r.length;i<o;i++){var u=r[i],f=n(u);f>e&&(t=u,e=f)}return t},t.sum=function(r){for(var n=0,t=0,e=r.length;t<e;t++)n+=r[t];return n},t.cumsum=function(r){var n=new r.constructor(r.length);return l(r,(function(r,t,e){return n[e]=r+t}),0),n},t.every=function(r,n){for(var t=0,e=r.length;t<e;t++)if(!n(r[t]))return!1;return!0},t.some=function(r,n){for(var t=0,e=r.length;t<e;t++)if(n(r[t]))return!0;return!1},t.index_of=function(r,n){for(var t=0,e=r.length;t<e;t++)if(r[t]===n)return t;return-1},t.find_index=c(1),t.find_last_index=c(-1),t.find=function(r,n){var e=t.find_index(r,n);return-1==e?void 0:r[e]},t.find_last=function(r,n){var e=t.find_last_index(r,n);return-1==e?void 0:r[e]},t.sorted_index=v,t.bin_counts=function(r,n){for(var t=n.length-1,e=Array(t).fill(0),i=0;i<r.length;i++){var u=v(n,r[i]);e[o.clamp(u-1,0,t-1)]+=1}return e},t.interpolate=function(r,n,t){for(var e=r.length,i=new Array(e),o=0;o<e;o++){var u=r[o];if(isNaN(u))i[o]=u;else{var f=g(u,n);if(-1==f)i[o]=t[0];else if(f==n.length)i[o]=t[t.length-1];else if(f==n.length-1||n[f]==u)i[o]=t[f];else{var a=n[f],l=t[f],c=n[f+1],v=t[f+1];i[o]=h(u,a,l,c,v)}}}return i},t.left_edge_index=g,t.norm=function(r,n,t){var e=t-n;return a(r,(function(r){return(r-n)/e}))}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(1),a=e(124);function o(e){return Object.keys(e).length}t.keys=Object.keys,t.values=Object.values,t.entries=Object.entries,t.extend=Object.assign,t.clone=function(e){return Object.assign({},e)},t.merge=function(e,r){var t,o,c=Object.create(Object.prototype),l=a.concat([Object.keys(e),Object.keys(r)]);try{for(var u=n.__values(l),i=u.next();!i.done;i=u.next()){var s=i.value,y=e.hasOwnProperty(s)?e[s]:[],f=r.hasOwnProperty(s)?r[s]:[];c[s]=a.union(y,f)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(o=u.return)&&o.call(u)}finally{if(t)throw t.error}}return c},t.size=o,t.isEmpty=function(e){return 0==o(e)},t.to_object=function(e){var r,t,a={};try{for(var o=n.__values(e),c=o.next();!c.done;c=o.next()){var l=n.__read(c.value,2),u=l[0],i=l[1];a[u]=i}}catch(e){r={error:e}}finally{try{c&&!c.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}return a}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(1),a=e(130),o=e(132),i=n.__importStar(e(133)),l=n.__importStar(e(136)),s=n.__importStar(e(143)),u=e(144),c=e(124),_=e(128),f=e(123),v=e(140),y=e(120),d=e(145),p=e(146),h=e(140),g=e(148),x=n.__importStar(e(136)),w=function(e){function r(r){var t,o;void 0===r&&(r={});var s,u=this;(u=e.call(this)||this)._subtype=void 0,u.document=null,u.destroyed=new a.Signal0(u,"destroyed"),u.change=new a.Signal0(u,"change"),u.transformchange=new a.Signal0(u,"transformchange"),u.properties={},u._pending=!1,u._changing=!1;var c=r instanceof Map?r.get:function(e){return r[e]};try{for(var f=n.__values(_.entries(u._props)),v=f.next();!v.done;v=f.next()){var y=n.__read(v.value,2),d=y[0],p=y[1],h=p.type,g=p.default_value,x=p.options,w=void 0;w=h instanceof l.Kind?new i.PrimitiveProperty(u,d,h,g,c(d),x):new h(u,d,l.Any,g,c(d),x),u.properties[d]=w}}catch(e){t={error:e}}finally{try{v&&!v.done&&(o=f.return)&&o.call(f)}finally{if(t)throw t.error}}return null!==(s=c("__deferred__"))&&void 0!==s&&s||(u.finalize(),u.connect_signals()),u}return n.__extends(r,e),Object.defineProperty(r.prototype,"type",{get:function(){return this.constructor.__qualified__},set:function(e){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=e},enumerable:!0,configurable:!0}),Object.defineProperty(r,"__qualified__",{get:function(){var e=this.__module__,r=this.__name__;return null!=e?e+"."+r:r},enumerable:!0,configurable:!0}),Object.defineProperty(r,Symbol.toStringTag,{get:function(){return this.__name__},enumerable:!0,configurable:!0}),r.init_HasProps=function(){this.prototype._props={},this.prototype._mixins=[],this.define({id:[i.String,function(){return u.uniqueId()}]})},r._fix_default=function(e,r){if(void 0!==e){if(f.isFunction(e))return e;if(f.isArray(e))return function(){return c.copy(e)};if(f.isPlainObject(e))return function(){return _.clone(e)};if(f.isObject(e))throw new Error(e+" must be explicitly wrapped in a function");return function(){return e}}},r.define=function(e){var r,t,a=function(e,r){if(null!=o.prototype._props[e])throw new Error("attempted to redefine property '"+o.prototype.type+"."+e+"'");if(null!=o.prototype[e])throw new Error("attempted to redefine attribute '"+o.prototype.type+"."+e+"'");Object.defineProperty(o.prototype,e,{get:function(){return this.properties[e].get_value()},set:function(r){var t;return this.setv(((t={})[e]=r,t)),this},configurable:!1,enumerable:!0});var t=n.__read(r,3),a=t[0],i=t[1],l=t[2],s={type:a,default_value:o._fix_default(i,e),options:l},u=_.clone(o.prototype._props);u[e]=s,o.prototype._props=u},o=this;try{for(var i=n.__values(_.entries(f.isFunction(e)?e(x):e)),l=i.next();!l.done;l=i.next()){var s=n.__read(l.value,2);a(s[0],s[1])}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(r)throw r.error}}},r.internal=function(e){var r,t,a={};try{for(var o=n.__values(_.entries(e)),i=o.next();!i.done;i=o.next()){var l=n.__read(i.value,2),s=l[0],u=l[1],c=n.__read(u,3),f=c[0],v=c[1],y=c[2],d=void 0===y?{}:y;a[s]=[f,v,Object.assign(Object.assign({},d),{internal:!0})]}}catch(e){r={error:e}}finally{try{i&&!i.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}this.define(a)},r.mixins=function(e){var r,t;function a(e){switch(e){case"line":return s.LineVector;case"fill":return s.FillVector;case"hatch":return s.HatchVector;case"text":return s.TextVector;default:throw new Error("Unknown property mixin kind '"+e+"'")}}function o(e,r){var t,a,o={};try{for(var i=n.__values(_.entries(r)),l=i.next();!l.done;l=i.next()){var s=n.__read(l.value,2),u=s[0],c=s[1];o[e+u]=c}}catch(e){t={error:e}}finally{try{l&&!l.done&&(a=i.return)&&a.call(i)}finally{if(t)throw t.error}}return o}function i(e){var r=n.__read(Object.keys(e),1)[0];return n.__read(r.split("_",1),1)[0]}f.isArray(e)||(e=[e]);var l={},u=[];try{for(var c=n.__values(e),v=c.next();!v.done;v=c.next()){var y=v.value;if(f.isString(y)){var d=n.__read(y.split(":"),2),p=d[0],h=d[1],g=void 0===h?"":h,x=a(p);u.push(y),_.extend(l,o(g,x))}else if(f.isArray(y)){var w=n.__read(y,2);g=w[0],x=w[1];u.push(i(x)+":"+g),_.extend(l,o(g,x))}else{x=y;u.push(i(x)),_.extend(l,x)}}}catch(e){r={error:e}}finally{try{v&&!v.done&&(t=c.return)&&t.call(c)}finally{if(r)throw r.error}}this.define(l),this.prototype._mixins=n.__spread(this.prototype._mixins,u)},r.override=function(e){var r,t;try{for(var a=n.__values(_.entries(e)),o=a.next();!o.done;o=a.next()){var i=n.__read(o.value,2),l=i[0],s=i[1],u=this._fix_default(s,l),c=this.prototype._props[l];if(null==c)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+l+"'");var f=_.clone(this.prototype._props);f[l]=Object.assign(Object.assign({},c),{default_value:u}),this.prototype._props=f}}catch(e){r={error:e}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}},r.prototype.toString=function(){return this.type+"("+this.id+")"},r.prototype.property=function(e){var r=this.properties[e];if(null!=r)return r;throw new Error("unknown property "+this.type+"."+e)},Object.defineProperty(r.prototype,"attributes",{get:function(){var e,r,t={};try{for(var a=n.__values(this),o=a.next();!o.done;o=a.next()){var i=o.value;t[i.attr]=i.get_value()}}catch(r){e={error:r}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}return t},enumerable:!0,configurable:!0}),r.prototype[h.equals]=function(e,r){var t,a;try{for(var o=n.__values(this),i=o.next();!i.done;i=o.next()){var l=i.value,s=e.property(l.attr);if(r.eq(l.get_value(),s.get_value()))return!1}}catch(e){t={error:e}}finally{try{i&&!i.done&&(a=o.return)&&a.call(o)}finally{if(t)throw t.error}}return!0},r.prototype[g.pretty]=function(e){var r,t,a=e.token,o=[];try{for(var i=n.__values(this),l=i.next();!l.done;l=i.next()){var s=l.value;if(s.dirty){var u=s.get_value();o.push(""+s.attr+a(":")+" "+e.to_string(u))}}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(r)throw r.error}}return""+this.constructor.__qualified__+a("(")+a("{")+o.join(a(",")+" ")+a("}")+a(")")},r.prototype.finalize=function(){var e,r,t=this;try{for(var a=n.__values(this),o=a.next();!o.done;o=a.next()){var i=o.value;null!=i.spec.transform&&this.connect(i.spec.transform.change,(function(){return t.transformchange.emit()}))}}catch(r){e={error:r}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}this.initialize()},r.prototype.initialize=function(){},r.prototype.connect_signals=function(){},r.prototype.disconnect_signals=function(){a.Signal.disconnectReceiver(this)},r.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},r.prototype.clone=function(){return new this.constructor(this.attributes)},r.prototype._setv=function(e,r){var t,a,o,i,l=r.check_eq,s=[],u=this._changing;this._changing=!0;try{for(var c=n.__values(e),_=c.next();!_.done;_=c.next()){var f=n.__read(_.value,2),y=f[0],d=f[1];!1!==l&&v.isEqual(y.get_value(),d)||(y.set_value(d),s.push(y))}}catch(e){t={error:e}}finally{try{_&&!_.done&&(a=c.return)&&a.call(c)}finally{if(t)throw t.error}}s.length>0&&(this._pending=!0);try{for(var p=n.__values(s),h=p.next();!h.done;h=p.next()){(y=h.value).change.emit()}}catch(e){o={error:e}}finally{try{h&&!h.done&&(i=p.return)&&i.call(p)}finally{if(o)throw o.error}}if(!u){if(!r.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},r.prototype.setv=function(e,r){var t,a,o,i,l,s,u,c;void 0===r&&(r={});var f=_.entries(e);if(0!=f.length)if(!0!==r.silent){var v=new Map,y=new Map;try{for(var d=n.__values(f),p=d.next();!p.done;p=d.next()){var h=n.__read(p.value,2),g=(M=h[0],V=h[1],this.properties[M]);v.set(g,V),y.set(g,g.get_value())}}catch(e){o={error:e}}finally{try{p&&!p.done&&(i=d.return)&&i.call(d)}finally{if(o)throw o.error}}this._setv(v,r);var x=this.document;if(null!=x){var w=[];try{for(var m=n.__values(y),b=m.next();!b.done;b=m.next()){var j=n.__read(b.value,2);g=j[0],V=j[1];w.push([g,V,g.get_value()])}}catch(e){l={error:e}}finally{try{b&&!b.done&&(s=m.return)&&s.call(m)}finally{if(l)throw l.error}}try{for(var S=n.__values(w),O=S.next();!O.done;O=S.next()){var P=n.__read(O.value,3),A=P[1],E=P[2];if(this._needs_invalidate(A,E)){x._invalidate_all_models();break}}}catch(e){u={error:e}}finally{try{O&&!O.done&&(c=S.return)&&c.call(S)}finally{if(u)throw u.error}}this._push_changes(w,r)}}else try{for(var q=n.__values(f),k=q.next();!k.done;k=q.next()){var z=n.__read(k.value,2),M=z[0],V=z[1];this.properties[M].set_value(V)}}catch(e){t={error:e}}finally{try{k&&!k.done&&(a=q.return)&&a.call(q)}finally{if(t)throw t.error}}},r.prototype.getv=function(e){return this.property(e).get_value()},r.prototype.ref=function(){return{id:this.id}},r.prototype.struct=function(){var e={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(e.subtype=this._subtype),e},r.prototype.set_subtype=function(e){this._subtype=e},r.prototype[Symbol.iterator]=function(){return n.__generator(this,(function(e){switch(e.label){case 0:return[5,n.__values(_.values(this.properties))];case 1:return e.sent(),[2]}}))},r.prototype.syncable_properties=function(){var e,r,t,a,o,i;return n.__generator(this,(function(l){switch(l.label){case 0:l.trys.push([0,5,6,7]),e=n.__values(this),r=e.next(),l.label=1;case 1:return r.done?[3,4]:(t=r.value).syncable?[4,t]:[3,3];case 2:l.sent(),l.label=3;case 3:return r=e.next(),[3,1];case 4:return[3,7];case 5:return a=l.sent(),o={error:a},[3,7];case 6:try{r&&!r.done&&(i=e.return)&&i.call(e)}finally{if(o)throw o.error}return[7];case 7:return[2]}}))},r.prototype.serializable_attributes=function(){var e,r,t={};try{for(var a=n.__values(this.syncable_properties()),o=a.next();!o.done;o=a.next()){var i=o.value;t[i.attr]=i.get_value()}}catch(r){e={error:r}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}return t},r._value_to_json=function(e){var t,a;if(e instanceof r)return e.ref();if(d.is_NDArray(e))return p.encode_NDArray(e);if(f.isArray(e)||f.isTypedArray(e)){for(var o=e.length,i=new Array(o),l=0;l<o;l++){var s=e[l];i[l]=r._value_to_json(s)}return i}if(f.isPlainObject(e)){var u={};try{for(var c=n.__values(_.entries(e)),v=c.next();!v.done;v=c.next()){var y=n.__read(v.value,2),h=y[0],g=y[1];u[h]=r._value_to_json(g)}}catch(e){t={error:e}}finally{try{v&&!v.done&&(a=c.return)&&a.call(c)}finally{if(t)throw t.error}}return u}return e},r.prototype.attributes_as_json=function(e,t){var a,o;void 0===e&&(e=!0),void 0===t&&(t=r._value_to_json);var i={};try{for(var l=n.__values(this),s=l.next();!s.done;s=l.next()){var u=s.value;u.syncable&&(e||u.dirty)&&(i[u.attr]=t(u.get_value()))}}catch(e){a={error:e}}finally{try{s&&!s.done&&(o=l.return)&&o.call(l)}finally{if(a)throw a.error}}return i},r._json_record_references=function(e,t,a,i){var l,s,u,c,v=i.recursive;if(o.is_ref(t)){var y=e.get_model_by_id(t.id);null==y||a.has(y)||r._value_record_references(y,a,{recursive:v})}else if(f.isArray(t))try{for(var d=n.__values(t),p=d.next();!p.done;p=d.next()){var h=p.value;r._json_record_references(e,h,a,{recursive:v})}}catch(e){l={error:e}}finally{try{p&&!p.done&&(s=d.return)&&s.call(d)}finally{if(l)throw l.error}}else if(f.isPlainObject(t))try{for(var g=n.__values(_.values(t)),x=g.next();!x.done;x=g.next()){h=x.value;r._json_record_references(e,h,a,{recursive:v})}}catch(e){u={error:e}}finally{try{x&&!x.done&&(c=g.return)&&c.call(g)}finally{if(u)throw u.error}}},r._value_record_references=function(e,t,a){var o,i,l,s,u,c,v=a.recursive;if(e instanceof r){if(!t.has(e)&&(t.add(e),v)){var y=e._immediate_references();try{for(var d=n.__values(y),p=d.next();!p.done;p=d.next()){var h=p.value;r._value_record_references(h,t,{recursive:!0})}}catch(e){o={error:e}}finally{try{p&&!p.done&&(i=d.return)&&i.call(d)}finally{if(o)throw o.error}}}}else if(f.isArray(e))try{for(var g=n.__values(e),x=g.next();!x.done;x=g.next()){var w=x.value;r._value_record_references(w,t,{recursive:v})}}catch(e){l={error:e}}finally{try{x&&!x.done&&(s=g.return)&&s.call(g)}finally{if(l)throw l.error}}else if(f.isPlainObject(e))try{for(var m=n.__values(_.values(e)),b=m.next();!b.done;b=m.next()){w=b.value;r._value_record_references(w,t,{recursive:v})}}catch(e){u={error:e}}finally{try{b&&!b.done&&(c=m.return)&&c.call(m)}finally{if(u)throw u.error}}},r.prototype._immediate_references=function(){var e,t,a=new Set;try{for(var o=n.__values(this.syncable_properties()),i=o.next();!i.done;i=o.next()){var l=i.value.get_value();r._value_record_references(l,a,{recursive:!1})}}catch(r){e={error:r}}finally{try{i&&!i.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}return a},r.prototype.references=function(){var e=new Set;return r._value_record_references(this,e,{recursive:!0}),e},r.prototype._doc_attached=function(){},r.prototype._doc_detached=function(){},r.prototype.attach_document=function(e){if(null!=this.document&&this.document!=e)throw new Error("models must be owned by only a single document");this.document=e,this._doc_attached()},r.prototype.detach_document=function(){this._doc_detached(),this.document=null},r.prototype._needs_invalidate=function(e,t){var a,o,i,l,s=new Set;r._value_record_references(t,s,{recursive:!1});var u=new Set;r._value_record_references(e,u,{recursive:!1});try{for(var c=n.__values(s),_=c.next();!_.done;_=c.next()){var f=_.value;if(!u.has(f))return!0}}catch(e){a={error:e}}finally{try{_&&!_.done&&(o=c.return)&&o.call(c)}finally{if(a)throw a.error}}try{for(var v=n.__values(u),y=v.next();!y.done;y=v.next()){var d=y.value;if(!s.has(d))return!0}}catch(e){i={error:e}}finally{try{y&&!y.done&&(l=v.return)&&l.call(v)}finally{if(i)throw i.error}}return!1},r.prototype._push_changes=function(e,r){var t,a;void 0===r&&(r={});var o=this.document;if(null!=o){var i=r.setter_id,l=[];try{for(var s=n.__values(e),u=s.next();!u.done;u=s.next()){var c=n.__read(u.value,3),_=c[0],f=c[1],v=c[2];_.syncable&&l.push(new y.ModelChangedEvent(o,this,_.attr,f,v,i))}}catch(e){t={error:e}}finally{try{u&&!u.done&&(a=s.return)&&a.call(s)}finally{if(t)throw t.error}}if(0!=l.length){var d=void 0;1==l.length?d=n.__read(l,1)[0]:d=new y.DocumentEventBatch(o,l,i),o._trigger_on_change(d)}}},r.prototype.materialize_dataspecs=function(e){var r,t,a={};try{for(var o=n.__values(this),l=o.next();!l.done;l=o.next()){var s=l.value;if(s instanceof i.VectorSpec&&(!s.optional||null!=s.spec.value||s.dirty)){var u=s.attr,_=s.array(e);a["_"+u]=_,s instanceof i.DistanceSpec&&(a["max_"+u]=c.max(_))}}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}return a},r.prototype.on_change=function(e,r){var t,a;try{for(var o=n.__values(f.isArray(e)?e:[e]),i=o.next();!i.done;i=o.next()){var l=i.value;this.connect(l.change,r)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(a=o.return)&&a.call(o)}finally{if(t)throw t.error}}},r}(a.Signalable());t.HasProps=w,w.init_HasProps()},
function _(n,e,r){Object.defineProperty(r,"__esModule",{value:!0});var t=n(1),l=n(131),i=n(124),a=function(){function n(n,e){this.sender=n,this.name=e}return n.prototype.connect=function(n,e){void 0===e&&(e=null),u.has(this.sender)||u.set(this.sender,[]);var r=u.get(this.sender);if(null!=s(r,this,n,e))return!1;var t=null!=e?e:n;c.has(t)||c.set(t,[]);var l=c.get(t),i={signal:this,slot:n,context:e};return r.push(i),l.push(i),!0},n.prototype.disconnect=function(n,e){void 0===e&&(e=null);var r=u.get(this.sender);if(null==r||0===r.length)return!1;var t=s(r,this,n,e);if(null==t)return!1;var l=null!=e?e:n,i=c.get(l);return t.signal=null,v(r),v(i),!0},n.prototype.emit=function(n){var e,r,l,i=null!==(l=u.get(this.sender))&&void 0!==l?l:[];try{for(var a=t.__values(i),o=a.next();!o.done;o=a.next()){var c=o.value,s=c.signal,f=c.slot,v=c.context;s===this&&f.call(v,n,this.sender)}}catch(n){e={error:n}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}},n}();r.Signal=a,a.__name__="Signal";var o=function(n){function e(){return null!==n&&n.apply(this,arguments)||this}return t.__extends(e,n),e.prototype.emit=function(){n.prototype.emit.call(this,void 0)},e}(a);r.Signal0=o,o.__name__="Signal0",function(n){n.disconnectBetween=function(n,e){var r,l,i=u.get(n);if(null!=i&&0!==i.length){var a=c.get(e);if(null!=a&&0!==a.length){try{for(var o=t.__values(a),s=o.next();!s.done;s=o.next()){var f=s.value;if(null==f.signal)return;f.signal.sender===n&&(f.signal=null)}}catch(n){r={error:n}}finally{try{s&&!s.done&&(l=o.return)&&l.call(o)}finally{if(r)throw r.error}}v(i),v(a)}}},n.disconnectSender=function(n){var e,r,l,i=u.get(n);if(null!=i&&0!==i.length){try{for(var a=t.__values(i),o=a.next();!o.done;o=a.next()){var s=o.value;if(null==s.signal)return;var f=null!==(l=s.context)&&void 0!==l?l:s.slot;s.signal=null,v(c.get(f))}}catch(n){e={error:n}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}v(i)}},n.disconnectReceiver=function(n){var e,r,l=c.get(n);if(null!=l&&0!==l.length){try{for(var i=t.__values(l),a=i.next();!a.done;a=i.next()){var o=a.value;if(null==o.signal)return;var s=o.signal.sender;o.signal=null,v(u.get(s))}}catch(n){e={error:n}}finally{try{a&&!a.done&&(r=i.return)&&r.call(i)}finally{if(e)throw e.error}}v(l)}},n.disconnectAll=function(n){var e,r,l,i,a=u.get(n);if(null!=a&&0!==a.length){try{for(var o=t.__values(a),s=o.next();!s.done;s=o.next()){s.value.signal=null}}catch(n){e={error:n}}finally{try{s&&!s.done&&(r=o.return)&&r.call(o)}finally{if(e)throw e.error}}v(a)}var f=c.get(n);if(null!=f&&0!==f.length){try{for(var d=t.__values(f),h=d.next();!h.done;h=d.next()){h.value.signal=null}}catch(n){l={error:n}}finally{try{h&&!h.done&&(i=d.return)&&i.call(d)}finally{if(l)throw l.error}}v(f)}}}(a||(r.Signal=a={})),r.Signalable=function(){return function(){function n(){}return n.prototype.connect=function(n,e){return n.connect(e,this)},n.prototype.disconnect=function(n,e){return n.disconnect(e,this)},n}()};var u=new WeakMap,c=new WeakMap;function s(n,e,r,t){return i.find(n,(function(n){return n.signal===e&&n.slot===r&&n.context===t}))}var f=new Set;function v(n){0===f.size&&l.defer(d),f.add(n)}function d(){var n,e;try{for(var r=t.__values(f),l=r.next();!l.done;l=r.next()){var a=l.value;i.remove_by(a,(function(n){return null==n.signal}))}}catch(e){n={error:e}}finally{try{l&&!l.done&&(e=r.return)&&e.call(r)}finally{if(n)throw n.error}}f.clear()}},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.delay=
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
function(n,e){return setTimeout(n,e)};var r="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;t.defer=function(n){return new Promise((function(e){r((function(){return e(n())}))}))},t.throttle=function(n,e,t){var r,u,i;void 0===t&&(t={});var o=null,a=0,l=function(){a=!1===t.leading?0:Date.now(),o=null,i=n.apply(r,u),o||(r=u=null)};return function(){var c=Date.now();a||!1!==t.leading||(a=c);var f=e-(c-a);return r=this,u=arguments,f<=0||f>e?(o&&(clearTimeout(o),o=null),a=c,i=n.apply(r,u),o||(r=u=null)):o||!1===t.trailing||(o=setTimeout(l,f)),i}},t.once=function(n){var e,t=!1;return function(){return t||(t=!0,e=n()),e}}},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(123),t=e(128);r.is_ref=function(e){if(i.isPlainObject(e)){var n=t.keys(e);return 1==n.length&&"id"==n[0]}return!1}},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});var r=n(1),i=n(130),o=n(134),a=r.__importStar(n(135)),u=n(139),l=n(124),_=n(127),s=n(137),p=n(123),c=n(142);function f(n){try{return JSON.stringify(n)}catch(t){return n.toString()}}function d(n){return p.isPlainObject(n)&&(void 0===n.value?0:1)+(void 0===n.field?0:1)+(void 0===n.expr?0:1)==1}e.isSpec=d;var h=function(){function n(n,t,e,r,o,a){var u,l,_;if(void 0===a&&(a={}),this.obj=n,this.attr=t,this.kind=e,this.default_value=r,this._dirty=!1,this.change=new i.Signal0(this.obj,"change"),this.internal=null!==(u=a.internal)&&void 0!==u&&u,this.optional=null!==(l=a.optional)&&void 0!==l&&l,void 0!==o)_=o,this._dirty=!0;else{var s=this._default_override();_=void 0!==s?s:void 0!==r?r(n):null}this._update(_)}return Object.defineProperty(n.prototype,"is_value",{get:function(){return void 0!==this.spec.value},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"syncable",{get:function(){return!this.internal},enumerable:!0,configurable:!0}),n.prototype.get_value=function(){return this.spec.value},n.prototype.set_value=function(n){this._update(n),this._dirty=!0},n.prototype._default_override=function(){},Object.defineProperty(n.prototype,"dirty",{get:function(){return this._dirty},enumerable:!0,configurable:!0}),n.prototype._update=function(n){null!=n&&this.validate(n),this.spec={value:n}},n.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+f(this.spec)+")"},n.prototype.normalize=function(n){return n},n.prototype.validate=function(n){if(!this.valid(n))throw new Error(this.obj.type+"."+this.attr+" given invalid value: "+f(n))},n.prototype.valid=function(n){return this.kind.valid(n)},n.prototype.value=function(n){if(void 0===n&&(n=!0),!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");var t=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&n&&(t=this.spec.transform.compute(t)),t},n}();e.Property=h,h.__name__="Property";var y=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(h);e.PrimitiveProperty=y,y.__name__="PrimitiveProperty";var v=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(h);e.Any=v,v.__name__="Any";var S=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isArray(n)||n instanceof Float32Array||n instanceof Float64Array},t}(h);e.Array=S,S.__name__="Array";var m=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isBoolean(n)},t}(h);e.Boolean=m,m.__name__="Boolean";var g=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isString(n)&&s.is_color(n)},t}(h);e.Color=g,g.__name__="Color";var x=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(h);e.Instance=x,x.__name__="Instance";var b=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isNumber(n)},t}(h);e.Number=b,b.__name__="Number";var P=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isNumber(n)&&(0|n)==n},t}(b);e.Int=P,P.__name__="Int";var A=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(b);e.Angle=A,A.__name__="Angle";var C=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isNumber(n)&&0<=n&&n<=1},t}(b);e.Percent=C,C.__name__="Percent";var L=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isString(n)},t}(h);e.String=L,L.__name__="String";var N=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return null===n||p.isString(n)},t}(h);e.NullString=N,N.__name__="NullString";var T=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(L);e.FontSize=T,T.__name__="FontSize";var q=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype._default_override=function(){return c.settings.dev?"Bokeh":void 0},t}(L);e.Font=q,q.__name__="Font";var O=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.valid=function(n){return p.isString(n)&&l.includes(this.enum_values,n)},t}(h);function B(n){return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),Object.defineProperty(e.prototype,"enum_values",{get:function(){return r.__spread(n)},enumerable:!0,configurable:!0}),e}(O)}e.EnumProperty=O,O.__name__="EnumProperty",e.Enum=B;var M=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),Object.defineProperty(t.prototype,"enum_values",{get:function(){return r.__spread(a.Direction)},enumerable:!0,configurable:!0}),t.prototype.normalize=function(n){for(var t=new Uint8Array(n.length),e=0;e<n.length;e++)switch(n[e]){case"clock":t[e]=0;break;case"anticlock":t[e]=1}return t},t}(O);e.Direction=M,M.__name__="Direction",e.Anchor=B(a.Anchor),e.AngleUnits=B(a.AngleUnits),e.BoxOrigin=B(a.BoxOrigin),e.ButtonType=B(a.ButtonType),e.CalendarPosition=B(a.CalendarPosition),e.Dimension=B(a.Dimension),e.Dimensions=B(a.Dimensions),e.Distribution=B(a.Distribution),e.FontStyle=B(a.FontStyle),e.HatchPatternType=B(a.HatchPatternType),e.HTTPMethod=B(a.HTTPMethod),e.HexTileOrientation=B(a.HexTileOrientation),e.HoverMode=B(a.HoverMode),e.LatLon=B(a.LatLon),e.LegendClickPolicy=B(a.LegendClickPolicy),e.LegendLocation=B(a.LegendLocation),e.LineCap=B(a.LineCap),e.LineJoin=B(a.LineJoin),e.LinePolicy=B(a.LinePolicy),e.Location=B(a.Location),e.Logo=B(a.Logo),e.MarkerType=B(a.MarkerType),e.MutedPolicy=B(a.MutedPolicy),e.Orientation=B(a.Orientation),e.OutputBackend=B(a.OutputBackend),e.PaddingUnits=B(a.PaddingUnits),e.Place=B(a.Place),e.PointPolicy=B(a.PointPolicy),e.RadiusDimension=B(a.RadiusDimension),e.RenderLevel=B(a.RenderLevel),e.RenderMode=B(a.RenderMode),e.ResetPolicy=B(a.ResetPolicy),e.RoundingFunction=B(a.RoundingFunction),e.Side=B(a.Side),e.SizingMode=B(a.SizingMode),e.Sort=B(a.Sort),e.SpatialUnits=B(a.SpatialUnits),e.StartEnd=B(a.StartEnd),e.StepMode=B(a.StepMode),e.TapBehavior=B(a.TapBehavior),e.TextAlign=B(a.TextAlign),e.TextBaseline=B(a.TextBaseline),e.TextureRepetition=B(a.TextureRepetition),e.TickLabelOrientation=B(a.TickLabelOrientation),e.TooltipAttachment=B(a.TooltipAttachment),e.UpdateMode=B(a.UpdateMode),e.VerticalAlign=B(a.VerticalAlign);var j=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.get_value=function(){return null===this.spec.value?null:this.spec},t.prototype._update=function(n){d(n)?this.spec=n:this.spec={value:n},null!=this.spec.value&&this.validate(this.spec.value)},t}(h);e.ScalarSpec=j,j.__name__="ScalarSpec";var w=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.AnyScalar=w,w.__name__="AnyScalar";var D=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.ColorScalar=D,D.__name__="ColorScalar";var k=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.NumberScalar=k,k.__name__="NumberScalar";var F=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.StringScalar=F,F.__name__="StringScalar";var U=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.NullStringScalar=U,U.__name__="NullStringScalar";var z=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.ArrayScalar=z,z.__name__="ArrayScalar";var R=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.LineJoinScalar=R,R.__name__="LineJoinScalar";var E=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.LineCapScalar=E,E.__name__="LineCapScalar";var H=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.FontSizeScalar=H,H.__name__="FontSizeScalar";var X=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.FontStyleScalar=X,X.__name__="FontStyleScalar";var Y=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.TextAlignScalar=Y,Y.__name__="TextAlignScalar";var I=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(j);e.TextBaselineScalar=I,I.__name__="TextBaselineScalar";var J=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.get_value=function(){return null===this.spec.value?null:this.spec},t.prototype._update=function(n){d(n)?this.spec=n:this.spec={value:n},null!=this.spec.value&&this.validate(this.spec.value)},t.prototype.array=function(n){var t,e,r=null!==(t=n.get_length())&&void 0!==t?t:1;if(null!=this.spec.field){var i=n.get_column(this.spec.field);if(null!=i)e=this.normalize(i);else{o.logger.warn("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'");var a=new u.NumberArray(r);a.fill(NaN),e=a}}else if(null!=this.spec.expr)e=this.normalize(this.spec.expr.v_compute(n));else{var _=this.value(!1);if(p.isNumber(_)){var s=new u.NumberArray(r);s.fill(_),e=s}else e=l.repeat(_,r)}return null!=this.spec.transform&&(e=this.spec.transform.v_compute(e)),e},t}(h);e.VectorSpec=J,J.__name__="VectorSpec";var V=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(J);e.DataSpec=V,V.__name__="DataSpec";var G=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype._update=function(t){n.prototype._update.call(this,t),null==this.spec.units&&(this.spec.units=this.default_units);var e=this.spec.units;if(!l.includes(this.valid_units,e))throw new Error("units must be one of "+this.valid_units.join(", ")+"; got: "+e)},Object.defineProperty(t.prototype,"units",{get:function(){return this.spec.units},set:function(n){this.spec.units=n},enumerable:!0,configurable:!0}),t}(J);e.UnitsSpec=G,G.__name__="UnitsSpec";var K=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.array=function(t){return new u.NumberArray(n.prototype.array.call(this,t))},t}(G);e.NumberUnitsSpec=K,K.__name__="NumberUnitsSpec";var Q=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(V);e.BaseCoordinateSpec=Q,Q.__name__="BaseCoordinateSpec";var W=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(Q);e.CoordinateSpec=W,W.__name__="CoordinateSpec";var Z=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(Q);e.CoordinateSeqSpec=Z,Z.__name__="CoordinateSeqSpec";var $=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(Q);e.CoordinateSeqSeqSeqSpec=$,$.__name__="CoordinateSeqSeqSeqSpec";var nn=function(n){function t(){var t=n.apply(this,r.__spread(arguments))||this;return t.dimension="x",t}return r.__extends(t,n),t}(W);e.XCoordinateSpec=nn,nn.__name__="XCoordinateSpec";var tn=function(n){function t(){var t=n.apply(this,r.__spread(arguments))||this;return t.dimension="y",t}return r.__extends(t,n),t}(W);e.YCoordinateSpec=tn,tn.__name__="YCoordinateSpec";var en=function(n){function t(){var t=n.apply(this,r.__spread(arguments))||this;return t.dimension="x",t}return r.__extends(t,n),t}(Z);e.XCoordinateSeqSpec=en,en.__name__="XCoordinateSeqSpec";var rn=function(n){function t(){var t=n.apply(this,r.__spread(arguments))||this;return t.dimension="y",t}return r.__extends(t,n),t}(Z);e.YCoordinateSeqSpec=rn,rn.__name__="YCoordinateSeqSpec";var on=function(n){function t(){var t=n.apply(this,r.__spread(arguments))||this;return t.dimension="x",t}return r.__extends(t,n),t}($);e.XCoordinateSeqSeqSeqSpec=on,on.__name__="XCoordinateSeqSeqSeqSpec";var an=function(n){function t(){var t=n.apply(this,r.__spread(arguments))||this;return t.dimension="y",t}return r.__extends(t,n),t}($);e.YCoordinateSeqSeqSeqSpec=an,an.__name__="YCoordinateSeqSeqSeqSpec";var un=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),Object.defineProperty(t.prototype,"default_units",{get:function(){return"rad"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"valid_units",{get:function(){return r.__spread(a.AngleUnits)},enumerable:!0,configurable:!0}),t.prototype.normalize=function(t){return"deg"==this.spec.units&&(t=_.map(t,(function(n){return n*Math.PI/180}))),t=_.map(t,(function(n){return-n})),n.prototype.normalize.call(this,t)},t}(K);e.AngleSpec=un,un.__name__="AngleSpec";var ln=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),Object.defineProperty(t.prototype,"default_units",{get:function(){return"data"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"valid_units",{get:function(){return r.__spread(a.SpatialUnits)},enumerable:!0,configurable:!0}),t}(K);e.DistanceSpec=ln,ln.__name__="DistanceSpec";var _n=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.array=function(t){return new Uint8Array(n.prototype.array.call(this,t))},t}(V);e.BooleanSpec=_n,_n.__name__="BooleanSpec";var sn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.array=function(t){return new u.NumberArray(n.prototype.array.call(this,t))},t}(V);e.NumberSpec=sn,sn.__name__="NumberSpec";var pn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.array=function(t){for(var e=n.prototype.array.call(this,t),r=e.length,i=new u.ColorArray(r),o=0;o<r;o++){var a=e[o];if(p.isNumber(a))i[o]=a;else{var l=s.color2rgba(a);i[o]=s.encode_rgba(l)}}return i},t}(V);e.ColorSpec=pn,pn.__name__="ColorSpec";var cn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(V);e.FontSizeSpec=cn,cn.__name__="FontSizeSpec";var fn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(V);e.MarkerSpec=fn,fn.__name__="MarkerSpec";var dn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(V);e.StringSpec=dn,dn.__name__="StringSpec";var hn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(V);e.NullStringSpec=hn,hn.__name__="NullStringSpec";var yn=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t}(V);e.NDArraySpec=yn,yn.__name__="NDArraySpec"},
function _(e,l,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),t=e(123),r=e(128),g={},i=function(e,l){this.name=e,this.level=l};o.LogLevel=i,i.__name__="LogLevel";var v=function(){function e(l,o){void 0===o&&(o=e.INFO),this._name=l,this.set_level(o)}return Object.defineProperty(e,"levels",{get:function(){return Object.keys(e.log_levels)},enumerable:!0,configurable:!0}),e.get=function(l,o){if(void 0===o&&(o=e.INFO),l.length>0){var n=g[l];return null==n&&(g[l]=n=new e(l,o)),n}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(e.prototype,"level",{get:function(){return this.get_level()},enumerable:!0,configurable:!0}),e.prototype.get_level=function(){return this._log_level},e.prototype.set_level=function(l){var o,g;if(l instanceof i)this._log_level=l;else{if(!t.isString(l)||null==e.log_levels[l])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=e.log_levels[l]}var v="["+this._name+"]";try{for(var s=n.__values(r.entries(e.log_levels)),f=s.next();!f.done;f=s.next()){var c=n.__read(f.value,2),_=c[0];c[1].level<this._log_level.level||this._log_level.level===e.OFF.level?this[_]=function(){}:this[_]=a(_,v)}}catch(e){o={error:e}}finally{try{f&&!f.done&&(g=s.return)&&g.call(s)}finally{if(o)throw o.error}}},e.prototype.trace=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.debug=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.info=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.warn=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.error=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e}();function a(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function s(e){var l=o.logger.level;return t.isString(e)&&null==v.log_levels[e]?(console.log("[bokeh] unrecognized logging level '"+e+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+v.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+(t.isString(e)?e:e.level)+"'"),o.logger.set_level(e)),l}o.Logger=v,v.__name__="Logger",v.TRACE=new i("trace",0),v.DEBUG=new i("debug",1),v.INFO=new i("info",2),v.WARN=new i("warn",6),v.ERROR=new i("error",7),v.FATAL=new i("fatal",8),v.OFF=new i("off",9),v.log_levels={trace:v.TRACE,debug:v.DEBUG,info:v.INFO,warn:v.WARN,error:v.ERROR,fatal:v.FATAL,off:v.OFF},o.logger=v.get("bokeh"),o.set_log_level=s,o.with_log_level=function(e,l){var o=s(e);try{l()}finally{s(o)}}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var o=e(136);t.Align=o.Enum("start","center","end"),t.Anchor=o.Enum("top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"),t.AngleUnits=o.Enum("deg","rad"),t.BoxOrigin=o.Enum("corner","center"),t.ButtonType=o.Enum("default","primary","success","warning","danger"),t.CalendarPosition=o.Enum("auto","above","below"),t.Dimension=o.Enum("width","height"),t.Dimensions=o.Enum("width","height","both"),t.Direction=o.Enum("clock","anticlock"),t.Distribution=o.Enum("uniform","normal"),t.FontStyle=o.Enum("normal","italic","bold","bold italic"),t.HatchPatternType=o.Enum("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=o.Enum("POST","GET"),t.HexTileOrientation=o.Enum("pointytop","flattop"),t.HoverMode=o.Enum("mouse","hline","vline"),t.LatLon=o.Enum("lat","lon"),t.LegendClickPolicy=o.Enum("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=o.Enum("butt","round","square"),t.LineJoin=o.Enum("miter","round","bevel"),t.LinePolicy=o.Enum("prev","next","nearest","interp","none"),t.Location=o.Enum("above","below","left","right"),t.Logo=o.Enum("normal","grey"),t.MarkerType=o.Enum("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=o.Enum("show","ignore"),t.Orientation=o.Enum("vertical","horizontal"),t.OutputBackend=o.Enum("canvas","svg","webgl"),t.PaddingUnits=o.Enum("percent","absolute"),t.Place=o.Enum("above","below","left","right","center"),t.PointPolicy=o.Enum("snap_to_data","follow_mouse","none"),t.RadiusDimension=o.Enum("x","y","max","min"),t.RenderLevel=o.Enum("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=o.Enum("canvas","css"),t.ResetPolicy=o.Enum("standard","event_only"),t.RoundingFunction=o.Enum("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=o.Enum("replace","append","intersect","subtract"),t.Side=o.Enum("above","below","left","right"),t.SizingMode=o.Enum("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=o.Enum("ascending","descending"),t.SpatialUnits=o.Enum("screen","data"),t.StartEnd=o.Enum("start","end"),t.StepMode=o.Enum("after","before","center"),t.TapBehavior=o.Enum("select","inspect"),t.TextAlign=o.Enum("left","right","center"),t.TextBaseline=o.Enum("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=o.Enum("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=o.Enum("vertical","horizontal","parallel","normal"),t.TooltipAttachment=o.Enum("horizontal","vertical","left","right","above","below"),t.UpdateMode=o.Enum("replace","append"),t.VerticalAlign=o.Enum("top","middle","bottom")},
function _(n,t,r){Object.defineProperty(r,"__esModule",{value:!0});var e=n(1),i=e.__importStar(n(123)),u=n(137),o=function(){};r.Kind=o,o.__name__="Kind",function(n){var t=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(n){return!0},t}(o);t.__name__="Any",n.Any=t;var r=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(n){return!0},t}(o);r.__name__="Unknown",n.Unknown=r;var a=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(n){return i.isBoolean(n)},t}(o);a.__name__="Boolean",n.Boolean=a;var l=function(n){function t(t){var r=n.call(this)||this;return r.obj_type=t,r}return e.__extends(t,n),t.prototype.valid=function(n){return!0},t}(o);l.__name__="Ref",n.Ref=l;var _=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(n){return i.isNumber(n)},t}(o);_.__name__="Number",n.Number=_;var s=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&i.isInteger(t)},t}(_);s.__name__="Int",n.Int=s;var c=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return e.__extends(t,n),t.prototype.valid=function(n){return this.types.some((function(t){return t.valid(n)}))},t}(o);c.__name__="Or",n.Or=c;var f=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return e.__extends(t,n),t.prototype.valid=function(n){if(!i.isArray(n))return!1;for(var t=0;t<this.types.length;t++){var r=this.types[t],e=n[t];if(!r.valid(e))return!1}return!0},t}(o);f.__name__="Tuple",n.Tuple=f;var p=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return e.__extends(t,n),t.prototype.valid=function(n){var t=this;return i.isArray(n)&&n.every((function(n){return t.item_type.valid(n)}))},t}(o);p.__name__="Array",n.Array=p;var v=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(n){return null===n},t}(o);v.__name__="Null",n.Null=v;var d=function(n){function t(t){var r=n.call(this)||this;return r.base_type=t,r}return e.__extends(t,n),t.prototype.valid=function(n){return null===n||this.base_type.valid(n)},t}(o);d.__name__="Nullable",n.Nullable=d;var y=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(n){return i.isString(n)},t}(o);y.__name__="String",n.String=y;var h=function(n){function t(t){var r=n.call(this)||this;return r.values=new Set(t),r}return e.__extends(t,n),t.prototype.valid=function(n){return this.values.has(n)},t.prototype[Symbol.iterator]=function(){return e.__generator(this,(function(n){switch(n.label){case 0:return[5,e.__values(this.values)];case 1:return n.sent(),[2]}}))},t}(o);h.__name__="Enum",n.Enum=h;var m=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return e.__extends(t,n),t.prototype.valid=function(n){if(!i.isPlainObject(n))return!1;for(var t in n)if(n.hasOwnProperty(t)){var r=n[t];if(!this.item_type.valid(r))return!1}return!0},t}(o);m.__name__="Struct",n.Struct=m;var w=function(n){function t(t,r){var e=n.call(this)||this;return e.key_type=t,e.item_type=r,e}return e.__extends(t,n),t.prototype.valid=function(n){var t,r;if(!(n instanceof Map))return!1;try{for(var i=e.__values(n.entries()),u=i.next();!u.done;u=i.next()){var o=e.__read(u.value,2),a=o[0],l=o[1];if(!this.key_type.valid(a)||!this.item_type.valid(l))return!1}}catch(n){t={error:n}}finally{try{u&&!u.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}return!0},t}(o);w.__name__="Dict",n.Dict=w;var K=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(n){return i.isString(n)&&u.is_color(n)},t}(o);K.__name__="Color",n.Color=K;var x=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&0<=t&&t<=1},t}(_);x.__name__="Percent",n.Percent=x}(r.Kinds||(r.Kinds={})),r.Any=new r.Kinds.Any,r.Unknown=new r.Kinds.Unknown,r.Boolean=new r.Kinds.Boolean,r.Number=new r.Kinds.Number,r.Int=new r.Kinds.Int,r.String=new r.Kinds.String,r.Null=new r.Kinds.Null,r.Nullable=function(n){return new r.Kinds.Nullable(n)},r.Or=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Or(n)},r.Tuple=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Tuple(n)},r.Array=function(n){return new r.Kinds.Array(n)},r.Struct=function(n){return new r.Kinds.Struct(n)},r.Dict=function(n,t){return new r.Kinds.Dict(n,t)},r.Enum=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Enum(n)},r.Ref=function(n){return new r.Kinds.Ref(n)},r.Percent=new r.Kinds.Percent,r.Color=new r.Kinds.Color,r.Auto=r.Enum("auto"),r.FontSize=r.String,r.Font=r.String,r.Angle=r.Number},
function _(r,e,n){Object.defineProperty(n,"__esModule",{value:!0});var t=r(1),a=r(138),l=r(124);function o(r){var e=Number(r).toString(16);return 1==e.length?"0"+e:e}function i(r){if(0==(r+="").indexOf("#"))return r;if(a.is_svg_color(r))return a.svg_colors[r];if(0==r.indexOf("rgb")){var e=r.replace(/^rgba?\(|\s+|\)$/g,"").split(","),n=e.slice(0,3).map(o).join("");return 4==e.length&&(n+=o(Math.floor(255*parseFloat(e[3])))),"#"+n.slice(0,8)}return r}function u(r){var e;switch(r.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(r))return!1;var n=r.replace(e.start,"").replace(")","").split(",").map(parseFloat);return n.length==e.len&&((!e.alpha||0<=n[3]&&n[3]<=1)&&!l.includes(n.slice(0,3).map((function(r){return 0<=r&&r<=255})),!1))}n.is_color=function(r){return a.is_svg_color(r.toLowerCase())||"#"==r.substring(0,1)||u(r)},n.rgb2hex=function(r,e,n){return"#"+o(255&r)+o(255&e)+o(255&n)},n.color2hex=i,n.encode_rgba=function(r){var e=t.__read(r,4);return(255*e[0]|0)<<24|(255*e[1]|0)<<16|(255*e[2]|0)<<8|255*e[3]|0},n.decode_rgba=function(r){return[(r>>24&255)/255,(r>>16&255)/255,(r>>8&255)/255,(r>>0&255)/255]},n.color2rgba=function(r,e){if(void 0===e&&(e=1),!r)return[0,0,0,0];var n=i(r);(n=n.replace(/ |#/g,"")).length<=4&&(n=n.replace(/(.)/g,"$1$1"));for(var t=n.match(/../g).map((function(r){return parseInt(r,16)/255}));t.length<3;)t.push(0);return t.length<4&&t.push(e),t.slice(0,4)},n.valid_rgb=u},
function _(e,F,r){Object.defineProperty(r,"__esModule",{value:!0}),r.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},r.is_svg_color=function(e){return e in r.svg_colors}},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var a=r(1);e.NumberArray=Float32Array,e.ColorArray=Uint32Array;var n=r(140),o=function(){function r(r,t){this.offsets=r,this.array=t}return r.prototype[n.equals]=function(r,t){return t.arrays(this.offsets,r.offsets)&&t.arrays(this.array,r.array)},Object.defineProperty(r.prototype,"length",{get:function(){return this.offsets.length},enumerable:!0,configurable:!0}),r.prototype.clone=function(){return new r(new Uint32Array(this.offsets),new e.NumberArray(this.array))},r.from=function(t){for(var a=t.length,n=new Uint32Array(a),o=0,s=0;s<a;s++){var i=t[s].length;n[s]=o,o+=i}var f=new e.NumberArray(o);for(s=0;s<a;s++)f.set(t[s],n[s]);return new r(n,f)},r.prototype[Symbol.iterator]=function(){var r,t,e,n;return a.__generator(this,(function(a){switch(a.label){case 0:t=(r=this).offsets,e=r.length,n=0,a.label=1;case 1:return n<e?[4,this.array.subarray(t[n],t[n+1])]:[3,4];case 2:a.sent(),a.label=3;case 3:return n++,[3,1];case 4:return[2]}}))},r.prototype.get=function(r){var t=this.offsets;return this.array.subarray(t[r],t[r+1])},r.prototype.set=function(r,t){this.array.set(t,this.offsets[r])},r}();e.RaggedArray=o,o.__name__="RaggedArray",o[Symbol.toStringTag]="RaggedArray";var s=r(141);e.Indices=s.BitSet},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=r(1);e.equals=Symbol("equals"),e.wildcard=Symbol("wildcard");var o=Object.prototype.toString,a=function(){function r(){this.a_stack=[],this.b_stack=[]}return r.prototype.eq=function(r,t){var n=this;if(Object.is(r,t))return!0;if(r===e.wildcard||t===e.wildcard)return!0;if(null==r||null==t)return r===t;var a=o.call(r);if(a!=o.call(t))return!1;switch(a){case"[object Number]":return this.numbers(r,t);case"[object RegExp]":case"[object String]":return""+r==""+t;case"[object Date]":case"[object Boolean]":return+r==+t}for(var c=this.a_stack,i=this.b_stack,u=c.length;u--;)if(c[u]===r)return i[u]===t;c.push(r),i.push(t);var s=function(){if(null!=r[e.equals]&&null!=t[e.equals])return r[e.equals](t,n);switch(a){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return n.arrays(r,t);case"[object Map]":return n.maps(r,t);case"[object Set]":return n.sets(r,t);case"[object Object]":if(r.constructor==t.constructor&&(null==r.constructor||r.constructor===Object))return n.objects(r,t);case"[object Function]":if(r.constructor==t.constructor&&r.constructor===Function)return n.eq(""+r,""+t)}if(r instanceof Node)return n.nodes(r,t);throw Error("can't compare objects of type "+a)}();return c.pop(),i.pop(),s},r.prototype.numbers=function(r,t){return Object.is(r,t)},r.prototype.arrays=function(r,t){var e=r.length;if(e!=t.length)return!1;for(var n=0;n<e;n++)if(!this.eq(r[n],t[n]))return!1;return!0},r.prototype.iterables=function(r,t){for(var e=r[Symbol.iterator](),n=t[Symbol.iterator]();;){var o=e.next(),a=n.next();if(o.done&&a.done)return!0;if(o.done||a.done)return!1;if(!this.eq(o.value,a.value))return!1}},r.prototype.maps=function(r,t){var e,o;if(r.size!=t.size)return!1;try{for(var a=n.__values(r),c=a.next();!c.done;c=a.next()){var i=n.__read(c.value,2),u=i[0],s=i[1];if(!t.has(u)||!this.eq(s,t.get(u)))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(o=a.return)&&o.call(a)}finally{if(e)throw e.error}}return!0},r.prototype.sets=function(r,t){var e,o;if(r.size!=t.size)return!1;try{for(var a=n.__values(r),c=a.next();!c.done;c=a.next()){var i=c.value;if(!t.has(i))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(o=a.return)&&o.call(a)}finally{if(e)throw e.error}}return!0},r.prototype.objects=function(r,t){var e,o,a=Object.keys(r);if(a.length!=Object.keys(t).length)return!1;try{for(var c=n.__values(a),i=c.next();!i.done;i=c.next()){var u=i.value;if(!t.hasOwnProperty(u)||!this.eq(r[u],t[u]))return!1}}catch(r){e={error:r}}finally{try{i&&!i.done&&(o=c.return)&&o.call(c)}finally{if(e)throw e.error}}return!0},r.prototype.nodes=function(r,t){return r.nodeType==t.nodeType&&(r.textContent==t.textContent&&!!this.iterables(r.childNodes,t.childNodes))},r}();e.Comparator=a,a.__name__="Comparator";var c=Math.abs,i=function(r){function t(t){void 0===t&&(t=1e-4);var e=r.call(this)||this;return e.tolerance=t,e}return n.__extends(t,r),t.prototype.numbers=function(t,e){return r.prototype.numbers.call(this,t,e)||c(t-e)<this.tolerance},t}(a);function u(r,t){return(new a).eq(r,t)}e.SimilarComparator=i,i.__name__="SimilarComparator",e.is_equal=u,e.is_similar=function(r,t,e){return new i(e).eq(r,t)},e.isEqual=u},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=r(1),a=r(126),i=r(124),s=r(140),o=function(){function r(r,t){void 0===t&&(t=0),this.size=r,this[Symbol.toStringTag]="BitSet",this._count=null,this._nwords=Math.ceil(r/32),0==t||1==t?(this._array=new Uint32Array(this._nwords),1==t&&this._array.fill(4294967295)):(a.assert(t.length==this._nwords,"Initializer size mismatch"),this._array=t)}return r.prototype.clone=function(){return new r(this.size,new Uint32Array(this._array))},r.prototype[s.equals]=function(r,t){if(!t.eq(this.size,r.size))return!1;for(var e=this._nwords,n=this.size%e,a=0==n?e:e-1,i=0;i<a;i++)if(this._array[i]!=r._array[i])return!1;if(0==n)return!0;var s=1<<n-1,o=s-1^s;return(this._array[a]&o)==(r._array[a]&o)},r.all_set=function(t){return new r(t,1)},r.all_unset=function(t){return new r(t,0)},r.from_indices=function(t,e){var a,i,s=new r(t);try{for(var o=n.__values(e),u=o.next();!u.done;u=o.next()){var c=u.value;s.set(c)}}catch(r){a={error:r}}finally{try{u&&!u.done&&(i=o.return)&&i.call(o)}finally{if(a)throw a.error}}return s},r.from_booleans=function(t,e){for(var n=new r(t),a=Math.min(t,e.length),i=0;i<a;i++)e[i]&&n.set(i);return n},r.prototype._check_bounds=function(r){a.assert(0<=r&&r<this.size,"Out of bounds")},r.prototype.get=function(r){this._check_bounds(r);var t=r>>>5,e=31&r;return!!(this._array[t]>>e&1)},r.prototype.set=function(r,t){void 0===t&&(t=!0),this._check_bounds(r),this._count=null;var e=r>>>5,n=31&r;t?this._array[e]|=1<<n:this._array[e]&=~(1<<n)},r.prototype.unset=function(r){this.set(r,!1)},r.prototype[Symbol.iterator]=function(){return n.__generator(this,(function(r){switch(r.label){case 0:return[5,n.__values(this.ones())];case 1:return r.sent(),[2]}}))},Object.defineProperty(r.prototype,"count",{get:function(){var r=this._count;return null==r&&(this._count=r=this._get_count()),r},enumerable:!0,configurable:!0}),r.prototype._get_count=function(){for(var r=this._array,t=this._nwords,e=this.size,n=0,a=0,i=0;i<t;i++){var s=r[i];if(0==s)a+=32;else for(var o=0;o<32&&a<e;o++,a++)s>>>o&1&&(n+=1)}return n},r.prototype.ones=function(){var r,t,e,a,i,s,o,u;return n.__generator(this,(function(n){switch(n.label){case 0:t=(r=this)._array,e=r._nwords,a=r.size,i=0,s=0,n.label=1;case 1:if(!(s<e))return[3,6];if(0==(o=t[s]))return i+=32,[3,5];u=0,n.label=2;case 2:return u<32&&i<a?o>>>u&1?[4,i]:[3,4]:[3,5];case 3:n.sent(),n.label=4;case 4:return u++,i++,[3,2];case 5:return s++,[3,1];case 6:return[2]}}))},r.prototype.zeros=function(){var r,t,e,a,i,s,o,u;return n.__generator(this,(function(n){switch(n.label){case 0:t=(r=this)._array,e=r._nwords,a=r.size,i=0,s=0,n.label=1;case 1:if(!(s<e))return[3,6];if(4294967295==(o=t[s]))return i+=32,[3,5];u=0,n.label=2;case 2:return u<32&&i<a?o>>>u&1?[3,4]:[4,i]:[3,5];case 3:n.sent(),n.label=4;case 4:return u++,i++,[3,2];case 5:return s++,[3,1];case 6:return[2]}}))},r.prototype._check_size=function(r){a.assert(this.size==r.size,"Size mismatch")},r.prototype.add=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]|=r._array[t]},r.prototype.intersect=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]&=r._array[t]},r.prototype.subtract=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++){var e=this._array[t],n=r._array[t];this._array[t]=(e^n)&e}},r.prototype.union=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]|=r._array[e];return t},r.prototype.intersection=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]&=r._array[e];return t},r.prototype.difference=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++){var n=this._array[e],a=r._array[e];t._array[e]=(n^a)&n}return t},r.prototype.select=function(r){var t,e,a=this.count,i=new r.constructor(a),s=0;try{for(var o=n.__values(this),u=o.next();!u.done;u=o.next()){var c=u.value;i[s++]=r[c]}}catch(r){t={error:r}}finally{try{u&&!u.done&&(e=o.return)&&e.call(o)}finally{if(t)throw t.error}}return i},r}();e.BitSet=o,o.__name__="BitSet";var u=function(){function r(r,t,e){this.nrows=r,this.ncols=t,this._matrix=new Array(r);for(var n=0;n<r;n++){this._matrix[n]=new Array(t);for(var a=0;a<t;a++)this._matrix[n][a]=e(n,a)}}return r.prototype.at=function(r,t){return this._matrix[r][t]},r.prototype[Symbol.iterator]=function(){var r,t;return n.__generator(this,(function(e){switch(e.label){case 0:r=0,e.label=1;case 1:if(!(r<this.nrows))return[3,6];t=0,e.label=2;case 2:return t<this.ncols?[4,[this._matrix[r][t],r,t]]:[3,5];case 3:e.sent(),e.label=4;case 4:return t++,[3,2];case 5:return r++,[3,1];case 6:return[2]}}))},r.prototype.values=function(){var r,t,e,a,i,s;return n.__generator(this,(function(o){switch(o.label){case 0:o.trys.push([0,5,6,7]),r=n.__values(this),t=r.next(),o.label=1;case 1:return t.done?[3,4]:(e=n.__read(t.value,1),[4,e[0]]);case 2:o.sent(),o.label=3;case 3:return t=r.next(),[3,1];case 4:return[3,7];case 5:return a=o.sent(),i={error:a},[3,7];case 6:try{t&&!t.done&&(s=r.return)&&s.call(r)}finally{if(i)throw i.error}return[7];case 7:return[2]}}))},r.prototype.map=function(t){var e=this;return new r(this.nrows,this.ncols,(function(r,n){return t(e.at(r,n),r,n)}))},r.prototype.apply=function(t){var e=this,n=r.from(t),a=this.nrows,i=this.ncols;if(a==n.nrows&&i==n.ncols)return new r(a,i,(function(r,t){return n.at(r,t)(e.at(r,t),r,t)}));throw new Error("dimensions don't match")},r.prototype.to_sparse=function(){return n.__spread(this)},r.from=function(t,e){if(t instanceof r)return t;if(null!=e){var n=t;return new r(Math.floor(n.length/e),e,(function(r,t){return n[r*e+t]}))}var a=t;return new r(t.length,i.min(a.map((function(r){return r.length}))),(function(r,t){return a[r][t]}))},r}();e.Matrix=u,u.__name__="Matrix"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=function(){function e(){this._dev=!1}return Object.defineProperty(e.prototype,"dev",{get:function(){return this._dev},set:function(e){this._dev=e},enumerable:!0,configurable:!0}),e}();n.Settings=i,i.__name__="Settings",n.settings=new i},
function _(e,l,t){Object.defineProperty(t,"__esModule",{value:!0});var a=e(1).__importStar(e(133));t.Line={line_color:[a.Color,"black"],line_alpha:[a.Number,1],line_width:[a.Number,1],line_join:[a.LineJoin,"bevel"],line_cap:[a.LineCap,"butt"],line_dash:[a.Array,[]],line_dash_offset:[a.Number,0]},t.Fill={fill_color:[a.Color,"gray"],fill_alpha:[a.Number,1]},t.Hatch={hatch_color:[a.Color,"black"],hatch_alpha:[a.Number,1],hatch_scale:[a.Number,12],hatch_pattern:[a.NullString,null],hatch_weight:[a.Number,1],hatch_extra:[a.Any,{}]},t.Text={text_color:[a.Color,"#444444"],text_alpha:[a.Number,1],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSize,"16px"],text_font_style:[a.FontStyle,"normal"],text_align:[a.TextAlign,"left"],text_baseline:[a.TextBaseline,"bottom"],text_line_height:[a.Number,1.2]},t.LineScalar={line_color:[a.ColorScalar,"black"],line_alpha:[a.NumberScalar,1],line_width:[a.NumberScalar,1],line_join:[a.LineJoinScalar,"bevel"],line_cap:[a.LineCapScalar,"butt"],line_dash:[a.ArrayScalar,[]],line_dash_offset:[a.NumberScalar,0]},t.FillScalar={fill_color:[a.ColorScalar,"gray"],fill_alpha:[a.NumberScalar,1]},t.HatchScalar={hatch_color:[a.ColorScalar,"black"],hatch_alpha:[a.NumberScalar,1],hatch_scale:[a.NumberScalar,12],hatch_pattern:[a.NullStringScalar,null],hatch_weight:[a.NumberScalar,1],hatch_extra:[a.AnyScalar,{}]},t.TextScalar={text_color:[a.ColorScalar,"#444444"],text_alpha:[a.NumberScalar,1],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSizeScalar,"16px"],text_font_style:[a.FontStyleScalar,"normal"],text_align:[a.TextAlignScalar,"left"],text_baseline:[a.TextBaselineScalar,"bottom"],text_line_height:[a.NumberScalar,1.2]},t.LineVector={line_color:[a.ColorSpec,"black"],line_alpha:[a.NumberSpec,1],line_width:[a.NumberSpec,1],line_join:[a.LineJoin,"bevel"],line_cap:[a.LineCap,"butt"],line_dash:[a.Array,[]],line_dash_offset:[a.Number,0]},t.FillVector={fill_color:[a.ColorSpec,"gray"],fill_alpha:[a.NumberSpec,1]},t.HatchVector={hatch_color:[a.ColorSpec,"black"],hatch_alpha:[a.NumberSpec,1],hatch_scale:[a.NumberSpec,12],hatch_pattern:[a.NullStringSpec,null],hatch_weight:[a.NumberSpec,1],hatch_extra:[a.Any,{}]},t.TextVector={text_color:[a.ColorSpec,"#444444"],text_alpha:[a.NumberSpec,1],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSizeSpec,"16px"],text_font_style:[a.FontStyle,"normal"],text_align:[a.TextAlign,"left"],text_baseline:[a.TextBaseline,"bottom"],text_line_height:[a.Number,1.2]}},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=r(142);function u(){for(var r=new Array(32),t=0;t<32;t++)r[t]="0123456789ABCDEF".substr(Math.floor(16*Math.random()),1);return r[12]="4",r[16]="0123456789ABCDEF".substr(3&r[16].charCodeAt(0)|8,1),r.join("")}e.startsWith=function(r,t,e){return void 0===e&&(e=0),r.substr(e,t.length)==t},e.uuid4=u;var a=1e3;e.uniqueId=function(r){var t=n.settings.dev?"j"+a++:u();return null!=r?r+"-"+t:t},e.escape=function(r){return r.replace(/(?:[&<>"'`])/g,(function(r){switch(r){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return r}}))},e.unescape=function(r){return r.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(function(r,t){switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return t}}))},e.use_strict=function(r){return"'use strict';\n"+r}},
function _(n,r,e){Object.defineProperty(e,"__esModule",{value:!0});var t=n(1),a=n(123),s=n(126),i=n(140),u=Symbol("__ndarray__"),_=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="uint8",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Uint8Array);e.Uint8NDArray=_,_.__name__="Uint8NDArray";var o=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="int8",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Int8Array);e.Int8NDArray=o,o.__name__="Int8NDArray";var h=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="uint16",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Uint16Array);e.Uint16NDArray=h,h.__name__="Uint16NDArray";var y=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="int16",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Int16Array);e.Int16NDArray=y,y.__name__="Int16NDArray";var p=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="uint32",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Uint32Array);e.Uint32NDArray=p,p.__name__="Uint32NDArray";var l=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="int32",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Int32Array);e.Int32NDArray=l,l.__name__="Int32NDArray";var c=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="float32",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Float32Array);e.Float32NDArray=c,c.__name__="Float32NDArray";var f=function(n){function r(r,e){var t=new n(r);return t.__ndarray__=u,t.dtype="float64",t.shape=null!=e?e:d(r)?r.shape:[t.length],t.dimension=t.shape.length,t}return t.__extends(r,n),r.prototype[i.equals]=function(n,r){return r.eq(this.shape,n.shape)&&r.arrays(this,n)},r}(Float64Array);function d(n){return a.isObject(n)&&n.__ndarray__==u}e.Float64NDArray=f,f.__name__="Float64NDArray",e.is_NDArray=d,e.ndarray=function(n,r){void 0===r&&(r={});var e=r.dtype;null==e&&(e=n instanceof ArrayBuffer||a.isArray(n)?"float32":function(){switch(!0){case n instanceof Uint8Array:return"uint8";case n instanceof Int8Array:return"int8";case n instanceof Uint16Array:return"uint16";case n instanceof Int16Array:return"int16";case n instanceof Uint32Array:return"uint32";case n instanceof Int32Array:return"int32";case n instanceof Float32Array:return"float32";case n instanceof Float64Array:return"float64";default:s.unreachable()}}());var t=r.shape;switch(e){case"uint8":return new _(n,t);case"int8":return new o(n,t);case"uint16":return new h(n,t);case"int16":return new y(n,t);case"uint32":return new p(n,t);case"int32":return new l(n,t);case"float32":return new c(n,t);case"float64":return new f(n,t)}}},
function _(r,e,n){Object.defineProperty(n,"__esModule",{value:!0});var t=r(1),a=r(123),f=r(147),_=t.__importStar(r(145));function i(r){var e=new Uint8Array(r),n=Array.from(e).map((function(r){return String.fromCharCode(r)}));return btoa(n.join(""))}function u(r){for(var e=atob(r),n=e.length,t=new Uint8Array(n),a=0,f=n;a<f;a++)t[a]=e.charCodeAt(a);return t.buffer}function o(r){for(var e=new Uint8Array(r.buffer,r.byteOffset,2*r.length),n=0,t=e.length;n<t;n+=2){var a=e[n];e[n]=e[n+1],e[n+1]=a}}function s(r){for(var e=new Uint8Array(r.buffer,r.byteOffset,4*r.length),n=0,t=e.length;n<t;n+=4){var a=e[n];e[n]=e[n+3],e[n+3]=a,a=e[n+1],e[n+1]=e[n+2],e[n+2]=a}}function c(r){for(var e=new Uint8Array(r.buffer,r.byteOffset,8*r.length),n=0,t=e.length;n<t;n+=8){var a=e[n];e[n]=e[n+7],e[n+7]=a,a=e[n+1],e[n+1]=e[n+6],e[n+6]=a,a=e[n+2],e[n+2]=e[n+5],e[n+5]=a,a=e[n+3],e[n+3]=e[n+4],e[n+4]=a}}n.buffer_to_base64=i,n.base64_to_buffer=u,n.BYTE_ORDER=f.is_little_endian?"little":"big",n.swap16=o,n.swap32=s,n.swap64=c,n.is_NDArray_ref=function(r){return a.isPlainObject(r)&&("__buffer__"in r||"__ndarray__"in r)},n.decode_NDArray=function(r,e){var t,a=r.shape,f=r.dtype,i=r.order;if("__buffer__"in r){var b=e.get(r.__buffer__);if(null==b)throw new Error("buffer for "+r.__buffer__+" not found");t=b}else t=u(r.__ndarray__);var y=function(){switch(f){case"uint8":return new _.Uint8NDArray(t,a);case"int8":return new _.Int8NDArray(t,a);case"uint16":return new _.Uint16NDArray(t,a);case"int16":return new _.Int16NDArray(t,a);case"uint32":return new _.Uint32NDArray(t,a);case"int32":return new _.Int32NDArray(t,a);case"float32":return new _.Float32NDArray(t,a);case"float64":return new _.Float64NDArray(t,a)}}();if(i!==n.BYTE_ORDER)switch(y.BYTES_PER_ELEMENT){case 2:o(y);break;case 4:s(y);break;case 8:c(y)}return y},n.encode_NDArray=function(r,e){var t={order:n.BYTE_ORDER,dtype:r.dtype,shape:r.shape};if(null!=e){var a=""+e.size;return e.set(a,r.buffer),Object.assign({__buffer__:a},t)}var f=i(r.buffer);return Object.assign({__ndarray__:f},t)}},
function _(n,e,i){var r;Object.defineProperty(i,"__esModule",{value:!0}),i.is_ie=(r="undefined"!=typeof navigator?navigator.userAgent:"").indexOf("MSIE")>=0||r.indexOf("Trident")>0||r.indexOf("Edge")>0,i.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),i.is_little_endian=function(){var n=new ArrayBuffer(4),e=new Uint8Array(n);new Uint32Array(n)[1]=168496141;var i=!0;return 10==e[4]&&11==e[5]&&12==e[6]&&13==e[7]&&(i=!1),i}()},
function _(t,r,n){Object.defineProperty(n,"__esModule",{value:!0});var e=t(1),o=t(123),i=t(128);n.pretty=Symbol("pretty");var a=function(){function t(t){this.precision=null==t?void 0:t.precision}return t.prototype.to_string=function(t){return function(t){return n.pretty in Object(t)}(t)?t[n.pretty](this):o.isBoolean(t)?this.boolean(t):o.isNumber(t)?this.number(t):o.isString(t)?this.string(t):o.isArray(t)?this.array(t):o.isIterable(t)?this.iterable(t):o.isPlainObject(t)?this.object(t):""+t},t.prototype.token=function(t){return t},t.prototype.boolean=function(t){return""+t},t.prototype.number=function(t){return null!=this.precision?t.toFixed(this.precision):""+t},t.prototype.string=function(t){return'"'+t.replace(/'/g,"\\'")+'"'},t.prototype.array=function(t){var r,n,o=this.token,i=[];try{for(var a=e.__values(t),u=a.next();!u.done;u=a.next()){var s=u.value;i.push(this.to_string(s))}}catch(t){r={error:t}}finally{try{u&&!u.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}return""+o("[")+i.join(o(",")+" ")+o("]")},t.prototype.iterable=function(t){var r,n=this.token,e=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",o=this.array(t);return""+e+n("(")+o+n(")")},t.prototype.object=function(t){var r,n,o=this.token,a=[];try{for(var u=e.__values(i.entries(t)),s=u.next();!s.done;s=u.next()){var l=e.__read(s.value,2),c=l[0],p=l[1];a.push(""+c+o(":")+" "+this.to_string(p))}}catch(t){r={error:t}}finally{try{s&&!s.done&&(n=u.return)&&n.call(u)}finally{if(r)throw r.error}}return""+o("{")+a.join(o(",")+" ")+o("}")},t}();n.Printer=a,a.__name__="Printer",n.to_string=function(t,r){return new a(r).to_string(t)}},
function _(r,t,_){Object.defineProperty(_,"__esModule",{value:!0});var e=r(1);e.__exportStar(r(150),_),e.__exportStar(r(291),_),e.__exportStar(r(318),_),e.__exportStar(r(322),_),e.__exportStar(r(333),_),e.__exportStar(r(337),_),e.__exportStar(r(343),_),e.__exportStar(r(347),_),e.__exportStar(r(380),_),e.__exportStar(r(383),_),e.__exportStar(r(385),_),e.__exportStar(r(247),_),e.__exportStar(r(263),_),e.__exportStar(r(402),_),e.__exportStar(r(406),_),e.__exportStar(r(435),_),e.__exportStar(r(436),_),e.__exportStar(r(437),_),e.__exportStar(r(438),_),e.__exportStar(r(439),_),e.__exportStar(r(444),_),e.__exportStar(r(446),_),e.__exportStar(r(457),_),e.__exportStar(r(461),_)},
function _(a,e,o){Object.defineProperty(o,"__esModule",{value:!0});var r=a(151);o.Annotation=r.Annotation;var n=a(198);o.Arrow=n.Arrow;var t=a(199);o.ArrowHead=t.ArrowHead;var v=a(199);o.OpenHead=v.OpenHead;var l=a(199);o.NormalHead=l.NormalHead;var d=a(199);o.TeeHead=d.TeeHead;var i=a(199);o.VeeHead=i.VeeHead;var A=a(237);o.Band=A.Band;var H=a(239);o.BoxAnnotation=H.BoxAnnotation;var T=a(240);o.ColorBar=T.ColorBar;var p=a(275);o.Label=p.Label;var L=a(277);o.LabelSet=L.LabelSet;var b=a(278);o.Legend=b.Legend;var B=a(279);o.LegendItem=B.LegendItem;var S=a(281);o.PolyAnnotation=S.PolyAnnotation;var P=a(282);o.Slope=P.Slope;var g=a(283);o.Span=g.Span;var m=a(276);o.TextAnnotation=m.TextAnnotation;var w=a(284);o.Title=w.Title;var x=a(285);o.ToolbarPanel=x.ToolbarPanel;var s=a(286);o.Tooltip=s.Tooltip;var u=a(290);o.Whisker=u.Whisker},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),o=i.__importStar(t(152)),r=t(128),s=t(185),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.visible,(function(){return e.plot_view.request_layout()}))},e.prototype.get_size=function(){if(this.model.visible){var t=this._get_size(),e=t.width,n=t.height;return{width:Math.round(e),height:Math.round(n)}}return{width:0,height:0}},e.prototype._get_size=function(){throw new Error("not implemented")},e.prototype.set_data=function(t){var e,n,s=this.model.materialize_dataspecs(t);if(r.extend(this,s),this.plot_model.use_map){null!=this._x&&(e=i.__read(o.project_xy(this._x,this._y),2),this._x=e[0],this._y=e[1]),null!=this._xs&&(n=i.__read(o.project_xsys(this._xs,this._ys),2),this._xs=n[0],this._ys=n[1])}},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null==this.layout},enumerable:!0,configurable:!0}),e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this);return null==this.layout?e:Object.assign(Object.assign({},e),{bbox:this.layout.bbox.box})},e}(s.RendererView);n.AnnotationView=a,a.__name__="AnnotationView";var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Annotation=function(){this.override({level:"annotation"})},e}(s.Renderer);n.Annotation=_,_.__name__="Annotation",_.init_Annotation()},
function _(r,n,e){Object.defineProperty(e,"__esModule",{value:!0});var t=r(1),a=t.__importDefault(r(153)),i=t.__importDefault(r(154)),u=r(139),l=new i.default("GOOGLE"),o=new i.default("WGS84"),c=a.default(o,l);e.wgs84_mercator={compute:function(r,n){return isFinite(r)&&isFinite(n)?c.forward([r,n]):[NaN,NaN]},invert:function(r,n){return isFinite(r)&&isFinite(n)?c.inverse([r,n]):[NaN,NaN]}};var _={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},f={lon:[-180,180],lat:[-85.06,85.06]},v=Math.min,p=Math.max;function s(r,n){var t=v(r.length,n.length),a=new u.NumberArray(t),i=new u.NumberArray(t);return e.inplace.project_xy(r,n,a,i),[a,i]}e.clip_mercator=function(r,n,e){var a=t.__read(_[e],2),i=a[0],u=a[1];return[p(r,i),v(n,u)]},e.in_bounds=function(r,n){var e=t.__read(f[n],2),a=e[0],i=e[1];return a<r&&r<i},function(r){function n(r,n,a,i){var u=v(r.length,n.length);a=null!=a?a:r,i=null!=i?i:n;for(var l=0;l<u;l++){var o=r[l],c=n[l],_=t.__read(e.wgs84_mercator.compute(o,c),2),f=_[0],p=_[1];a[l]=f,i[l]=p}}r.project_xy=n,r.project_xsys=function(r,e,t,a){var i=v(r.length,e.length);t=null!=t?t:r,a=null!=a?a:e;for(var u=0;u<i;u++)n(r[u],e[u],t[u],a[u])}}(e.inplace||(e.inplace={})),e.project_xy=s,e.project_xsys=function(r,n){for(var e=v(r.length,n.length),a=new Array(e),i=new Array(e),u=0;u<e;u++){var l=t.__read(s(r[u],n[u]),2),o=l[0],c=l[1];a[u]=o,i[u]=c}return[a,i]}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),o=r.__importDefault(e(154)),a=r.__importDefault(e(179)),i=o.default("WGS84");function u(e,n,t){var r,o,i;return Array.isArray(t)?(r=a.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=a.default(e,n,t),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function c(e){return e instanceof o.default?e:e.oProj?e.oProj:o.default(e)}t.default=function(e,n,t){e=c(e);var r,o=!1;return void 0===n?(n=e,e=i,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=i,o=!0),n=c(n),t?u(e,n,t):(r={forward:function(t){return u(e,n,t)},inverse:function(t){return u(n,e,t)}},o&&(r.oProj=n),r)}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var s=e(1),i=s.__importDefault(e(155)),u=s.__importDefault(e(166)),l=s.__importDefault(e(167)),r=e(175),o=s.__importDefault(e(177)),f=s.__importDefault(e(178)),d=s.__importDefault(e(162));function p(e,t){if(!(this instanceof p))return new p(e);t=t||function(e){if(e)throw e};var a=i.default(e);if("object"==typeof a){var s=p.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var l=d.default(o.default,a.datumCode);l&&(a.datum_params=l.towgs84?l.towgs84.split(","):null,a.ellps=l.ellipse,a.datumName=l.datumName?l.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84";var m=r.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),n=r.eccentricity(m.a,m.b,m.rf,a.R_A),h=a.datum||f.default(a.datumCode,a.datum_params,m.a,m.b,n.es,n.ep2);u.default(this,a),u.default(this,s),this.a=m.a,this.b=m.b,this.rf=m.rf,this.sphere=m.sphere,this.es=n.es,this.e=n.e,this.ep2=n.ep2,this.datum=h,this.init(),t(null,this)}else t(e)}else t(e)}p.projections=l.default,p.projections.start(),a.default=p},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var u=t(1),n=u.__importDefault(t(156)),f=u.__importDefault(t(163)),i=u.__importDefault(t(158)),a=u.__importDefault(t(162));var o=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var l=["3857","900913","3785","102113"];r.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in n.default}(t))return n.default[t];if(function(t){return o.some((function(e){return t.indexOf(e)>-1}))}(t)){var e=f.default(t);if(function(t){var e=a.default(t,"authority");if(e){var r=a.default(e,"epsg");return r&&l.indexOf(r)>-1}}(e))return n.default["EPSG:3857"];var r=function(t){var e=a.default(t,"extension");if(e)return a.default(e,"proj4")}(e);return r?i.default(r):e}return function(t){return"+"===t[0]}(t)?i.default(t):void 0}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=i.__importDefault(e(157)),a=i.__importDefault(e(158)),f=i.__importDefault(e(163));function l(e){var t=this;if(2===arguments.length){var r=arguments[1];"string"==typeof r?"+"===r.charAt(0)?l[e]=a.default(arguments[1]):l[e]=f.default(arguments[1]):l[e]=r}else if(1===arguments.length){if(Array.isArray(e))return e.map((function(e){Array.isArray(e)?l.apply(t,e):l(e)}));if("string"==typeof e){if(e in l)return l[e]}else"EPSG"in e?l["EPSG:"+e.EPSG]=e:"ESRI"in e?l["ESRI:"+e.ESRI]=e:"IAU2000"in e?l["IAU2000:"+e.IAU2000]=e:console.log(e);return}}n.default(l),r.default=l},
function _(e,t,l){Object.defineProperty(l,"__esModule",{value:!0}),l.default=function(e){e("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),e("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),e("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),e.WGS84=e["EPSG:4326"],e["EPSG:3785"]=e["EPSG:3857"],e.GOOGLE=e["EPSG:3857"],e["EPSG:900913"]=e["EPSG:3857"],e["EPSG:102113"]=e["EPSG:3857"]}},
function _(t,n,o){Object.defineProperty(o,"__esModule",{value:!0});var e=t(1),a=t(159),u=e.__importDefault(t(160)),r=e.__importDefault(t(161)),i=e.__importDefault(t(162));o.default=function(t){var n,o,e,f={},l=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){f.rf=parseFloat(t)},lat_0:function(t){f.lat0=t*a.D2R},lat_1:function(t){f.lat1=t*a.D2R},lat_2:function(t){f.lat2=t*a.D2R},lat_ts:function(t){f.lat_ts=t*a.D2R},lon_0:function(t){f.long0=t*a.D2R},lon_1:function(t){f.long1=t*a.D2R},lon_2:function(t){f.long2=t*a.D2R},alpha:function(t){f.alpha=parseFloat(t)*a.D2R},lonc:function(t){f.longc=t*a.D2R},x_0:function(t){f.x0=parseFloat(t)},y_0:function(t){f.y0=parseFloat(t)},k_0:function(t){f.k0=parseFloat(t)},k:function(t){f.k0=parseFloat(t)},a:function(t){f.a=parseFloat(t)},b:function(t){f.b=parseFloat(t)},r_a:function(){f.R_A=!0},zone:function(t){f.zone=parseInt(t,10)},south:function(){f.utmSouth=!0},towgs84:function(t){f.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){f.to_meter=parseFloat(t)},units:function(t){f.units=t;var n=i.default(r.default,t);n&&(f.to_meter=n.to_meter)},from_greenwich:function(t){f.from_greenwich=t*a.D2R},pm:function(t){var n=i.default(u.default,t);f.from_greenwich=(n||parseFloat(t))*a.D2R},nadgrids:function(t){"@null"===t?f.datumCode="none":f.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(f.axis=t)}};for(n in l)o=l[n],n in c?"function"==typeof(e=c[n])?e(o):f[e]=o:f[n]=o;return"string"==typeof f.datumCode&&"WGS84"!==f.datumCode&&(f.datumCode=f.datumCode.toLowerCase()),f}},
function _(P,_,e){Object.defineProperty(e,"__esModule",{value:!0}),e.PJD_3PARAM=1,e.PJD_7PARAM=2,e.PJD_WGS84=4,e.PJD_NODATUM=5,e.SEC_TO_RAD=484813681109536e-20,e.HALF_PI=Math.PI/2,e.SIXTH=.16666666666666666,e.RA4=.04722222222222222,e.RA6=.022156084656084655,e.EPSLN=1e-10,e.D2R=.017453292519943295,e.R2D=57.29577951308232,e.FORTPI=Math.PI/4,e.TWO_PI=2*Math.PI,e.SPI=3.14159265359},
function _(e,o,r){Object.defineProperty(r,"__esModule",{value:!0});var a={};r.default=a,a.greenwich=0,a.lisbon=-9.131906111111,a.paris=2.337229166667,a.bogota=-74.080916666667,a.madrid=-3.687938888889,a.rome=12.452333333333,a.bern=7.439583333333,a.jakarta=106.807719444444,a.ferro=-17.666666666667,a.brussels=4.367975,a.stockholm=18.058277777778,a.athens=23.7163375,a.oslo=10.722916666667},
function _(e,t,f){Object.defineProperty(f,"__esModule",{value:!0}),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t){Object.defineProperty(t,"__esModule",{value:!0});var o=e(1),d=o.__importDefault(e(164)),r=e(165);function n(e){return.017453292519943295*e}t.default=function(e){var a=d.default(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var l={};return r.sExpr(a,l),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var d=e.AXIS[t][0].toLowerCase();-1!==d.indexOf("north")?a+="n":-1!==d.indexOf("south")?a+="s":-1!==d.indexOf("east")?a+="e":-1!==d.indexOf("west")&&(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",n],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",n],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",n],["lat0","latitude_of_origin",n],["lat0","standard_parallel_1",n],["lat1","standard_parallel_1",n],["lat2","standard_parallel_2",n],["azimuth","Azimuth"],["alpha","azimuth",n],["srsCode","name"]].forEach((function(a){return t=e,d=(o=a)[0],r=o[1],void(!(d in t)&&r in t&&(t[d]=t[r],3===o.length&&(t[d]=o[2](t[d]))));var t,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=n(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(l),l}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(t){return new a(t).output()};var i=/\s/,s=/[A-Za-z]/,h=/[A-Za-z84]/,o=/[,\]]/,n=/[\d\.E\-\+]/;function a(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}a.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;i.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},a.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(o.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},a.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},a.prototype.number=function(t){if(!n.test(t)){if(o.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},a.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},a.prototype.keyword=function(t){if(h.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!o.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},a.prototype.neutral=function(t){if(s.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(n.test(t))return this.word=t,void(this.state=3);if(!o.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},a.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,r,a){function s(e,r,a){Array.isArray(r)&&(a.unshift(r),r=null);var s=r?{}:e,n=a.reduce((function(e,r){return c(r,e),e}),s);r&&(e[r]=n)}function c(e,r){if(Array.isArray(e)){var a=e.shift();if("PARAMETER"===a&&(a=e.shift()),1===e.length)return Array.isArray(e[0])?(r[a]={},void c(e[0],r[a])):void(r[a]=e[0]);if(e.length)if("TOWGS84"!==a){if("AXIS"===a)return a in r||(r[a]=[]),void r[a].push(e);var n;switch(Array.isArray(a)||(r[a]={}),a){case"UNIT":case"PRIMEM":case"VERT_DATUM":return r[a]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&c(e[2],r[a]));case"SPHEROID":case"ELLIPSOID":return r[a]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&c(e[3],r[a]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void s(r,a,e);default:for(n=-1;++n<e.length;)if(!Array.isArray(e[n]))return c(e,r[a]);return s(r,a,e)}}else r[a]=e;else r[a]=!0}else r[e]=!0}Object.defineProperty(a,"__esModule",{value:!0}),a.sExpr=c},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(e,n){var r,t;if(e=e||{},!n)return e;for(t in n)void 0!==(r=n[t])&&(e[t]=r);return e}},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var a=t(1),r=a.__importDefault(t(168)),n=a.__importDefault(t(174)),u=[r.default,n.default],f={},i=[];function d(t,e){var o=i.length;return t.names?(i[o]=t,t.names.forEach((function(t){f[t.toLowerCase()]=o})),this):(console.log(e),!0)}function l(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==f[e]&&i[f[e]]?i[f[e]]:void 0}function c(){u.forEach(d)}o.add=d,o.get=l,o.start=c,o.default={start:c,add:d,get:l}},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});var h=t(1),a=h.__importDefault(t(169)),e=h.__importDefault(t(170)),r=h.__importDefault(t(172)),n=h.__importDefault(t(173)),l=t(159);function u(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=a.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function o(t){var i,s,h=t.x,a=t.y;if(a*l.R2D>90&&a*l.R2D<-90&&h*l.R2D>180&&h*l.R2D<-180)return null;if(Math.abs(Math.abs(a)-l.HALF_PI)<=l.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(l.FORTPI+.5*a));else{var n=Math.sin(a),u=r.default(this.e,a,n);i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(u)}return t.x=i,t.y=s,t}function f(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=l.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var r=Math.exp(-a/(this.a*this.k0));if(-9999===(s=n.default(this.e,r)))return null}return i=e.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=u,s.forward=o,s.inverse=f,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:u,forward:o,inverse:f,names:s.names}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,t,n){var r=e*t;return n/Math.sqrt(1-r*r)}},
function _(e,t,u){Object.defineProperty(u,"__esModule",{value:!0});var a=e(1),f=e(159),n=a.__importDefault(e(171));u.default=function(e){return Math.abs(e)<=f.SPI?e:e-n.default(e)*f.TWO_PI}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){return e<0?-1:1}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var n=e(159);a.default=function(e,t,a){var r=e*a,u=.5*e;return r=Math.pow((1-r)/(1+r),u),Math.tan(.5*(n.HALF_PI-t))/r}},
function _(a,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=a(159);e.default=function(a,t){for(var e,r,u=.5*a,f=n.HALF_PI-2*Math.atan(t),o=0;o<=15;o++)if(e=a*Math.sin(f),f+=r=n.HALF_PI-2*Math.atan(t*Math.pow((1-e)/(1+e),u))-f,Math.abs(r)<=1e-10)return f;return-9999}},
function _(e,n,i){function t(){}function r(e){return e}Object.defineProperty(i,"__esModule",{value:!0}),i.init=t,i.forward=r,i.inverse=r,i.names=["longlat","identity"],i.default={init:t,forward:r,inverse:r,names:i.names}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var a=e(1),f=e(159),n=a.__importStar(e(176)),u=a.__importDefault(e(162));t.eccentricity=function(e,r,t,a){var n=e*e,u=r*r,i=(n-u)/n,c=0;return a?(n=(e*=1-i*(f.SIXTH+i*(f.RA4+i*f.RA6)))*e,i=0):c=Math.sqrt(i),{es:i,e:c,ep2:(n-u)/u}},t.sphere=function(e,r,t,a,i){if(!e){var c=u.default(n.default,a);c||(c=n.WGS84),e=c.a,r=c.b,t=c.rf}return t&&!r&&(r=(1-1/t)*e),(0===t||Math.abs(e-r)<f.EPSLN)&&(i=!0,r=e),{a:e,b:r,rf:t,sphere:i}}},
function _(e,a,l){Object.defineProperty(l,"__esModule",{value:!0});var s={};l.default=s,s.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},s.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},s.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},s.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},s.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},s.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},s.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},s.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},s.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},s.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},s.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},s.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},s.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},s.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},s.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},s.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},s.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},s.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},s.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},s.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},s.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},s.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},s.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},s.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},s.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},s.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},s.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},s.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},s.hough={a:6378270,rf:297,ellipseName:"Hough"},s.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},s.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},s.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},s.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},s.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},s.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},s.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},s.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},s.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},s.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},s.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},s.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=s.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},s.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s){Object.defineProperty(s,"__esModule",{value:!0});var t={};s.default=t,t.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},t.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},t.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},t.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},t.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},t.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},t.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},t.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},t.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},t.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},t.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},t.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},t.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},t.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},t.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},t.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},t.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_){Object.defineProperty(_,"__esModule",{value:!0});var t=a(159);_.default=function(a,m,_,u,d,p){var r={};return r.datum_type=void 0===a||"none"===a?t.PJD_NODATUM:t.PJD_WGS84,m&&(r.datum_params=m.map(parseFloat),0===r.datum_params[0]&&0===r.datum_params[1]&&0===r.datum_params[2]||(r.datum_type=t.PJD_3PARAM),r.datum_params.length>3&&(0===r.datum_params[3]&&0===r.datum_params[4]&&0===r.datum_params[5]&&0===r.datum_params[6]||(r.datum_type=t.PJD_7PARAM,r.datum_params[3]*=t.SEC_TO_RAD,r.datum_params[4]*=t.SEC_TO_RAD,r.datum_params[5]*=t.SEC_TO_RAD,r.datum_params[6]=r.datum_params[6]/1e6+1))),r.a=_,r.b=u,r.es=d,r.ep2=p,r}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var r=e(1),u=e(159),m=r.__importDefault(e(180)),_=r.__importDefault(e(182)),o=r.__importDefault(e(154)),d=r.__importDefault(e(183)),f=r.__importDefault(e(184));a.default=function e(t,a,r){var n;if(Array.isArray(r)&&(r=d.default(r)),f.default(r),t.datum&&a.datum&&function(e,t){return(e.datum.datum_type===u.PJD_3PARAM||e.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==t.datumCode||(t.datum.datum_type===u.PJD_3PARAM||t.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==e.datumCode}(t,a)&&(r=e(t,n=new o.default("WGS84"),r),t=n),"enu"!==t.axis&&(r=_.default(t,!1,r)),"longlat"===t.projName)r={x:r.x*u.D2R,y:r.y*u.D2R,z:r.z||0};else if(t.to_meter&&(r={x:r.x*t.to_meter,y:r.y*t.to_meter,z:r.z||0}),!(r=t.inverse(r)))return;return t.from_greenwich&&(r.x+=t.from_greenwich),r=m.default(t.datum,a.datum,r),a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*u.R2D,y:r.y*u.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?_.default(a,!0,r):r}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var u=e(159),_=e(181);function o(e){return e===u.PJD_3PARAM||e===u.PJD_7PARAM}a.default=function(e,t,a){return _.compareDatums(e,t)||e.datum_type===u.PJD_NODATUM||t.datum_type===u.PJD_NODATUM?a:e.es!==t.es||e.a!==t.a||o(e.datum_type)||o(t.datum_type)?(a=_.geodeticToGeocentric(a,e.es,e.a),o(e.datum_type)&&(a=_.geocentricToWgs84(a,e.datum_type,e.datum_params)),o(t.datum_type)&&(a=_.geocentricFromWgs84(a,t.datum_type,t.datum_params)),_.geocentricToGeodetic(a,t.es,t.a,t.b)):a}},
function _(a,t,r){Object.defineProperty(r,"__esModule",{value:!0});var e=a(159);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===e.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==e.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,u,_,s,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-e.HALF_PI&&d>-1.001*e.HALF_PI)d=-e.HALF_PI;else if(d>e.HALF_PI&&d<1.001*e.HALF_PI)d=e.HALF_PI;else{if(d<-e.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>e.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),u=Math.sin(d),s=Math.cos(d),_=u*u,{x:((m=r/Math.sqrt(1-t*_))+i)*s*Math.cos(n),y:(m+i)*s*Math.sin(n),z:(m*(1-t)+i)*u}},r.geocentricToGeodetic=function(a,t,r,m){var u,_,s,n,d,i,p,P,y,M,o,z,A,c,x,f=a.x,h=a.y,I=a.z?a.z:0;if(u=Math.sqrt(f*f+h*h),_=Math.sqrt(f*f+h*h+I*I),u/r<1e-12){if(c=0,_/r<1e-12)return e.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(h,f);s=I/_,P=(n=u/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=s*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=u*P+I*y-p*(1-t*y*y))),z=(o=s*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(M=n*(1-i)*d)*y,P=M,y=o}while(z*z>1e-24&&A<30);return{x:c,y:Math.atan(o/Math.abs(M)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],s=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-s*a.z)+u,z:i*(-n*a.x+s*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],s=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-u)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+s*y,z:n*p-s*P+y}}}},
function _(e,a,i){Object.defineProperty(i,"__esModule",{value:!0}),i.default=function(e,a,i){var s,n,r,c=i.x,d=i.y,u=i.z||0,f={};for(r=0;r<3;r++)if(!a||2!==r||void 0!==i.z)switch(0===r?(s=c,n=-1!=="ew".indexOf(e.axis[r])?"x":"y"):1===r?(s=d,n=-1!=="ns".indexOf(e.axis[r])?"y":"x"):(s=u,n="z"),e.axis[r]){case"e":case"w":case"n":case"s":f[n]=s;break;case"u":void 0!==i[n]&&(f.z=s);break;case"d":void 0!==i[n]&&(f.z=-s);break;default:return null}return f}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var n={x:e[0],y:e[1]};return e.length>2&&(n.z=e[2]),e.length>3&&(n.m=e[3]),n}},
function _(e,i,n){function t(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e){t(e.x),t(e.y)}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(186),o=i.__importStar(e(189)),a=i.__importStar(e(133)),l=e(196),_=e(197),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),Object.defineProperty(t.prototype,"coordinates",{get:function(){return this._coordinates},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new o.Visuals(this.model),this.needs_webgl_blit=!1,this._initialize_coordinates()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var n=this.model.properties,i=n.x_range_name,r=n.y_range_name;this.on_change([i,r],(function(){return t._initialize_coordinates()}))},t.prototype._initialize_coordinates=function(){var e=this.model,t=e.x_range_name,n=e.y_range_name,i=this.plot_view.frame,r=i.x_scales.get(t),o=i.y_scales.get(n);this._coordinates=new _.CoordinateTransform(r,o)},Object.defineProperty(t.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"layer",{get:function(){var e=this.plot_view.canvas_view,t=e.overlays,n=e.primary;return"overlay"==this.model.level?t:n},enumerable:!0,configurable:!0}),t.prototype.request_render=function(){this.plot_view.request_render()},t.prototype.notify_finished=function(){this.plot_view.notify_finished()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return!1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"has_webgl",{get:function(){return!1},enumerable:!0,configurable:!0}),t.prototype.render=function(){this.model.visible&&this._render(),this._has_finished=!0},t}(r.View);n.RendererView=s,s.__name__="RendererView";var p=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Renderer=function(){this.define({level:[a.RenderLevel],visible:[a.Boolean,!0],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]})},t}(l.Model);n.Renderer=p,p.__name__="Renderer",p.init_Renderer()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),o=t(130),i=t(187),s=t(123),a=n.__importDefault(t(188)),u=function(){function t(t){if(this.removed=new o.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),null==t.model)throw new Error("model of a view wasn't configured");this.model=t.model,this._parent=t.parent}return Object.defineProperty(t.prototype,"ready",{get:function(){return this._ready},enumerable:!0,configurable:!0}),t.prototype.connect=function(t,e){var r=this;return t.connect((function(t,n){var o=Promise.resolve(e.call(r,t,n));r._ready=r._ready.then((function(){return o}))}),this)},t.prototype.disconnect=function(t,e){return t.disconnect(e,this)},t.prototype.initialize=function(){var t,e;this._has_finished=!1,this.is_root&&(this._stylesheet=i.stylesheet);try{for(var r=n.__values(this.styles()),o=r.next();!o.done;o=r.next()){var s=o.value;this.stylesheet.append(s)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}},t.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(t){return[2]}))}))},t.prototype.remove=function(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()},t.prototype.toString=function(){return this.model.type+"View("+this.model.id+")"},t.prototype.serializable_state=function(){return{type:this.model.type}},Object.defineProperty(t.prototype,"parent",{get:function(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_root",{get:function(){return null===this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"root",{get:function(){return this.is_root?this:this.parent.root},enumerable:!0,configurable:!0}),t.prototype.assert_root=function(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")},t.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(t.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!0,configurable:!0}),t.prototype.connect_signals=function(){},t.prototype.disconnect_signals=function(){o.Signal.disconnectReceiver(this)},t.prototype.on_change=function(t,e){var r,o;try{for(var i=n.__values(s.isArray(t)?t:[t]),a=i.next();!a.done;a=i.next()){var u=a.value;this.connect(u.change,e)}}catch(t){r={error:t}}finally{try{a&&!a.done&&(o=i.return)&&o.call(i)}finally{if(r)throw r.error}}},t.prototype.cursor=function(t,e){return null},Object.defineProperty(t.prototype,"stylesheet",{get:function(){return this.is_root?this._stylesheet:this.root.stylesheet},enumerable:!0,configurable:!0}),t.prototype.styles=function(){return[a.default]},t}();r.View=u,u.__name__="View"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),i=t(123),l=t(128),a=function(t){return function(e){var r,a,o,s,c,u,h,d,f,y,p,v;void 0===e&&(e={});for(var g=[],m=1;m<arguments.length;m++)g[m-1]=arguments[m];var _=document.createElement(t);_.classList.add("bk");try{for(var x=n.__values(l.entries(e)),w=x.next();!w.done;w=x.next()){var b=n.__read(w.value,2),L=b[0],C=b[1];if(null!=C&&(!i.isBoolean(C)||C))if("class"===L&&(i.isString(C)&&(C=C.split(/\s+/)),i.isArray(C)))try{for(var M=(o=void 0,n.__values(C)),E=M.next();!E.done;E=M.next()){var S=E.value;null!=S&&_.classList.add(S)}}catch(t){o={error:t}}finally{try{E&&!E.done&&(s=M.return)&&s.call(M)}finally{if(o)throw o.error}}else if("style"===L&&i.isPlainObject(C))try{for(var B=(c=void 0,n.__values(l.entries(C))),k=B.next();!k.done;k=B.next()){var T=n.__read(k.value,2),N=T[0],R=T[1];_.style[N]=R}}catch(t){c={error:t}}finally{try{k&&!k.done&&(u=B.return)&&u.call(B)}finally{if(c)throw c.error}}else if("data"===L&&i.isPlainObject(C))try{for(var A=(h=void 0,n.__values(l.entries(C))),O=A.next();!O.done;O=A.next()){var P=n.__read(O.value,2),z=P[0];R=P[1];_.dataset[z]=R}}catch(t){h={error:t}}finally{try{O&&!O.done&&(d=A.return)&&d.call(A)}finally{if(h)throw h.error}}else _.setAttribute(L,C)}}catch(t){r={error:t}}finally{try{w&&!w.done&&(a=x.return)&&a.call(x)}finally{if(r)throw r.error}}function D(t){var e,r;if(i.isString(t))_.appendChild(document.createTextNode(t));else if(t instanceof Node)_.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)try{for(var l=n.__values(t),a=l.next();!a.done;a=l.next()){var o=a.value;_.appendChild(o)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=l.return)&&r.call(l)}finally{if(e)throw e.error}}else if(null!=t&&!1!==t)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(t))}try{for(var W=n.__values(g),j=W.next();!j.done;j=W.next()){var U=j.value;if(i.isArray(U))try{for(var H=(p=void 0,n.__values(U)),K=H.next();!K.done;K=H.next()){var F=K.value;D(F)}}catch(t){p={error:t}}finally{try{K&&!K.done&&(v=H.return)&&v.call(H)}finally{if(p)throw p.error}}else D(U)}}catch(t){f={error:t}}finally{try{j&&!j.done&&(y=W.return)&&y.call(W)}finally{if(f)throw f.error}}return _}};function o(t){var e=t.parentNode;null!=e&&e.removeChild(t)}function s(t){for(var e,r,i=[],l=1;l<arguments.length;l++)i[l-1]=arguments[l];var a=t.firstChild;try{for(var o=n.__values(i),s=o.next();!s.done;s=o.next()){var c=s.value;t.insertBefore(c,a)}}catch(t){e={error:t}}finally{try{s&&!s.done&&(r=o.return)&&r.call(o)}finally{if(e)throw e.error}}}function c(t,e){var r=Element.prototype;return(r.matches||r.webkitMatchesSelector||r.mozMatchesSelector||r.msMatchesSelector).call(t,e)}function u(t){return parseFloat(t)||0}function h(t){var e=getComputedStyle(t);return{border:{top:u(e.borderTopWidth),bottom:u(e.borderBottomWidth),left:u(e.borderLeftWidth),right:u(e.borderRightWidth)},margin:{top:u(e.marginTop),bottom:u(e.marginBottom),left:u(e.marginLeft),right:u(e.marginRight)},padding:{top:u(e.paddingTop),bottom:u(e.paddingBottom),left:u(e.paddingLeft),right:u(e.paddingRight)}}}function d(t){var e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}r.createElement=function(t,e){for(var r=[],i=2;i<arguments.length;i++)r[i-2]=arguments[i];return a(t).apply(void 0,n.__spread([e],r))},r.div=a("div"),r.span=a("span"),r.canvas=a("canvas"),r.link=a("link"),r.style=a("style"),r.a=a("a"),r.p=a("p"),r.i=a("i"),r.pre=a("pre"),r.button=a("button"),r.label=a("label"),r.input=a("input"),r.select=a("select"),r.option=a("option"),r.optgroup=a("optgroup"),r.textarea=a("textarea"),r.nbsp=function(){return document.createTextNode(" ")},r.append=function(t){for(var e,r,i=[],l=1;l<arguments.length;l++)i[l-1]=arguments[l];try{for(var a=n.__values(i),o=a.next();!o.done;o=a.next()){var s=o.value;t.appendChild(s)}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}},r.remove=o,r.removeElement=o,r.replaceWith=function(t,e){var r=t.parentNode;null!=r&&r.replaceChild(e,t)},r.prepend=s,r.empty=function(t,e){var r,i,l;for(void 0===e&&(e=!1);l=t.firstChild;)t.removeChild(l);if(e&&t instanceof Element)try{for(var a=n.__values(t.attributes),o=a.next();!o.done;o=a.next()){var s=o.value;t.removeAttributeNode(s)}}catch(t){r={error:t}}finally{try{o&&!o.done&&(i=a.return)&&i.call(a)}finally{if(r)throw r.error}}},r.display=function(t){t.style.display=""},r.undisplay=function(t){t.style.display="none"},r.show=function(t){t.style.visibility=""},r.hide=function(t){t.style.visibility="hidden"},r.offset=function(t){var e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},r.matches=c,r.parent=function(t,e){for(var r=t;r=r.parentElement;)if(c(r,e))return r;return null},r.extents=h,r.size=d,r.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},r.outer_size=function(t){var e=h(t).margin,r=e.left,n=e.right,i=e.top,l=e.bottom,a=d(t),o=a.width,s=a.height;return{width:Math.ceil(o+r+n),height:Math.ceil(s+i+l)}},r.content_size=function(t){var e,r,i=t.getBoundingClientRect(),l=i.left,a=i.top,o=h(t).padding,s=0,c=0;try{for(var u=n.__values(t.children),d=u.next();!d.done;d=u.next()){var f=d.value.getBoundingClientRect();s=Math.max(s,Math.ceil(f.left-l-o.left+f.width)),c=Math.max(c,Math.ceil(f.top-a-o.top+f.height))}}catch(t){e={error:t}}finally{try{d&&!d.done&&(r=u.return)&&r.call(u)}finally{if(e)throw e.error}}return{width:s,height:c}},r.position=function(t,e,r){var n=t.style;if(n.left=e.x+"px",n.top=e.y+"px",n.width=e.width+"px",n.height=e.height+"px",null==r)n.margin="";else{var i=r.top,l=r.right,a=r.bottom,o=r.left;n.margin=i+"px "+l+"px "+a+"px "+o+"px"}},r.children=function(t){return Array.from(t.children)};var f,y=function(){function t(t){this.el=t,this.classList=t.classList}return Object.defineProperty(t.prototype,"values",{get:function(){for(var t=[],e=0;e<this.classList.length;e++){var r=this.classList.item(e);null!=r&&t.push(r)}return t},enumerable:!0,configurable:!0}),t.prototype.has=function(t){return this.classList.contains(t)},t.prototype.add=function(){for(var t,e,r=[],i=0;i<arguments.length;i++)r[i]=arguments[i];try{for(var l=n.__values(r),a=l.next();!a.done;a=l.next()){var o=a.value;this.classList.add(o)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=l.return)&&e.call(l)}finally{if(t)throw t.error}}return this},t.prototype.remove=function(){for(var t,e,r=[],i=0;i<arguments.length;i++)r[i]=arguments[i];try{for(var l=n.__values(r),a=l.next();!a.done;a=l.next()){var o=a.value;this.classList.remove(o)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=l.return)&&e.call(l)}finally{if(t)throw t.error}}return this},t.prototype.clear=function(){var t,e;try{for(var r=n.__values(this.values),i=r.next();!i.done;i=r.next()){var l=i.value;"bk"!=l&&this.classList.remove(l)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return this},t.prototype.toggle=function(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this},t}();function p(t,e,r){var n=t.style,i=n.width,l=n.height,a=n.position,o=n.display;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return r()}finally{t.style.position=a,t.style.display=o,t.style.width=i,t.style.height=l}}r.ClassList=y,y.__name__="ClassList",r.classes=function(t){return new y(t)},r.toggle_attribute=function(t,e,r){null==r&&(r=!t.hasAttribute(e)),r?t.setAttribute(e,"true"):t.removeAttribute(e)},(f=r.Keys||(r.Keys={}))[f.Backspace=8]="Backspace",f[f.Tab=9]="Tab",f[f.Enter=13]="Enter",f[f.Esc=27]="Esc",f[f.PageUp=33]="PageUp",f[f.PageDown=34]="PageDown",f[f.Left=37]="Left",f[f.Up=38]="Up",f[f.Right=39]="Right",f[f.Down=40]="Down",f[f.Delete=46]="Delete",r.undisplayed=function(t,e){var r=t.style.display;t.style.display="none";try{return e()}finally{t.style.display=r}},r.unsized=function(t,e){return p(t,{},e)},r.sized=p;var v=function(){function t(t){this.root=t,this.known=new Set,this.style=r.style({type:"text/css"}),s(t,this.style)}return t.prototype.append=function(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))},t}();r.StyleSheet=v,v.__name__="StyleSheet",r.stylesheet=new v(document.head)},
function _(n,o,e){Object.defineProperty(e,"__esModule",{value:!0});e.default="\n.bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 13px;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var r=e(1),o=r.__importStar(e(143)),i=r.__importStar(e(133)),l=e(137),n=e(123),c=e(190),s=e(192);function h(e,t){var a=r.__read(n.isString(e)?l.color2rgba(e):l.decode_rgba(e),4),o=a[0],i=a[1],c=a[2],s=a[3];return"rgba("+255*o+", "+255*i+", "+255*c+", "+(1==s?t:s)+")"}function _(e,t,a){e.moveTo(0,a+.5),e.lineTo(t,a+.5),e.stroke()}function u(e,t,a){e.moveTo(a+.5,0),e.lineTo(a+.5,t),e.stroke()}function p(e,t){e.moveTo(0,t),e.lineTo(t,0),e.stroke(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"};var v=function(){function e(e,t){var a,o;void 0===t&&(t=""),this.obj=e,this.prefix=t,this.cache={};try{for(var i=r.__values(this.attrs),l=i.next();!l.done;l=i.next()){var n=l.value;this[n]=e.properties[t+n]}}catch(e){a={error:e}}finally{try{l&&!l.done&&(o=i.return)&&o.call(i)}finally{if(a)throw a.error}}}return e.prototype.warm_cache=function(e,t){var a,o;try{for(var l=r.__values(this.attrs),n=l.next();!n.done;n=l.next()){var c=n.value,s=this.obj.properties[this.prefix+c];if(void 0!==s.spec.value)this.cache[c]=s.spec.value;else{if(!(null!=e&&s instanceof i.VectorSpec))throw new Error("source is required with a vectorized visual property");var h=s.array(e),_=null!=t?t.select(h):h;this.cache[c+"_array"]=_}}}catch(e){a={error:e}}finally{try{n&&!n.done&&(o=l.return)&&o.call(l)}finally{if(a)throw a.error}}},e.prototype.cache_select=function(e,t){var a,r=this.obj.properties[this.prefix+e];return void 0!==r.spec.value?this.cache[e]=a=r.spec.value:this.cache[e]=a=this.cache[e+"_array"][t],a},e.prototype.get_array=function(e){return this.cache[e+"_array"]},e.prototype.set_vectorize=function(e,t){this._set_vectorize(e,t)},e}();a.ContextProperties=v,v.__name__="ContextProperties";var f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.set_value=function(e){var t=this.line_color.value(),a=this.line_alpha.value();e.strokeStyle=h(t,a),e.lineWidth=this.line_width.value(),e.lineJoin=this.line_join.value(),e.lineCap=this.line_cap.value(),e.lineDash=this.line_dash.value(),e.lineDashOffset=this.line_dash_offset.value()},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)},enumerable:!0,configurable:!0}),t.prototype._set_vectorize=function(e,t){var a=this.cache_select("line_color",t),r=this.cache_select("line_alpha",t),o=this.cache_select("line_width",t),i=this.cache_select("line_join",t),l=this.cache_select("line_cap",t),n=this.cache_select("line_dash",t),c=this.cache_select("line_dash_offset",t);e.strokeStyle=h(a,r),e.lineWidth=o,e.lineJoin=i,e.lineCap=l,e.lineDash=n,e.lineDashOffset=c},t.prototype.color_value=function(){return h(this.line_color.value(),this.line_alpha.value())},t}(v);a.Line=f,f.__name__="Line",f.prototype.attrs=Object.keys(o.LineVector);var y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.set_value=function(e){var t=this.fill_color.value(),a=this.fill_alpha.value();e.fillStyle=h(t,a)},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)},enumerable:!0,configurable:!0}),t.prototype._set_vectorize=function(e,t){var a=this.cache_select("fill_color",t),r=this.cache_select("fill_alpha",t);e.fillStyle=h(a,r)},t.prototype.color_value=function(){return h(this.fill_color.value(),this.fill_alpha.value())},t}(v);a.Fill=y,y.__name__="Fill",y.prototype.attrs=Object.keys(o.FillVector);var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.cache_select=function(t,r){var o;if("pattern"==t){var i=this.cache_select("hatch_color",r),l=this.cache_select("hatch_alpha",r),n=this.cache_select("hatch_scale",r),v=this.cache_select("hatch_pattern",r),f=this.cache_select("hatch_weight",r),y=this.cache.hatch_extra;if(null!=y&&y.hasOwnProperty(v)){var d=y[v];this.cache.pattern=d.get_pattern(i,l,n,f)}else this.cache.pattern=function(e){var t=e instanceof c.SVGRenderingContext2D?"svg":"canvas",r=new s.CanvasLayer(t,!0);return r.resize(n,n),r.prepare(),function(e,t,r,o,i,l){var n,c=i,s=c/2,v=s/2;switch(e.strokeStyle=h(r,o),e.lineCap="square",e.fillStyle=r,e.lineWidth=l,null!==(n=a.hatch_aliases[t])&&void 0!==n?n:t){case"blank":break;case"dot":e.arc(s,s,s/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(s,s,s/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":_(e,c,s);break;case"vertical_line":u(e,c,s);break;case"cross":_(e,c,s),u(e,c,s);break;case"horizontal_dash":_(e,s,s);break;case"vertical_dash":u(e,s,s);break;case"spiral":var f=c/30;e.moveTo(s,s);for(var y=0;y<360;y++){var d=.1*y,x=s+f*d*Math.cos(d),k=s+f*d*Math.sin(d);e.lineTo(x,k)}e.stroke();break;case"right_diagonal_line":e.moveTo(.5-v,c),e.lineTo(v+.5,0),e.stroke(),e.moveTo(v+.5,c),e.lineTo(3*v+.5,0),e.stroke(),e.moveTo(3*v+.5,c),e.lineTo(5*v+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(v+.5,c),e.lineTo(.5-v,0),e.stroke(),e.moveTo(3*v+.5,c),e.lineTo(v+.5,0),e.stroke(),e.moveTo(5*v+.5,c),e.lineTo(3*v+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":p(e,c);break;case"right_diagonal_dash":e.moveTo(v+.5,3*v+.5),e.lineTo(3*v+.5,v+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(v+.5,v+.5),e.lineTo(3*v+.5,3*v+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,v),e.lineTo(s,3*v),e.lineTo(c,v),e.stroke();break;case"vertical_wave":e.moveTo(v,0),e.lineTo(3*v,s),e.lineTo(v,c),e.stroke();break;case"criss_cross":p(e,c),_(e,c,s),u(e,c,s)}}(r.ctx,v,i,l,n,f),e.createPattern(r.canvas,"repeat")}}else o=e.prototype.cache_select.call(this,t,r);return o},t.prototype._try_defer=function(e){var t=this.cache,a=t.hatch_pattern,r=t.hatch_extra;null!=r&&r.hasOwnProperty(a)&&r[a].onload(e)},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)},enumerable:!0,configurable:!0}),t.prototype.doit2=function(e,t,a,r){this.doit&&(this.cache_select("pattern",t),null==this.cache.pattern(e)?this._try_defer(r):(this.set_vectorize(e,t),a()))},t.prototype._set_vectorize=function(e,t){this.cache_select("pattern",t),e.fillStyle=this.cache.pattern(e)},t.prototype.color_value=function(){return h(this.hatch_color.value(),this.hatch_alpha.value())},t}(v);a.Hatch=d,d.__name__="Hatch",d.prototype.attrs=Object.keys(o.HatchVector);var x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.color_value=function(){return h(this.text_color.value(),this.text_alpha.value())},t.prototype.font_value=function(){var e=this.text_font.value(),t=this.text_font_size.value();return this.text_font_style.value()+" "+t+" "+e},t.prototype.v_font_value=function(t){e.prototype.cache_select.call(this,"text_font_style",t),e.prototype.cache_select.call(this,"text_font_size",t),e.prototype.cache_select.call(this,"text_font",t);var a=this.cache;return a.text_font_style+" "+a.text_font_size+" "+a.text_font},t.prototype.cache_select=function(t,a){var r;return"font"==t?this.cache.font=r=this.v_font_value(a):r=e.prototype.cache_select.call(this,t,a),r},t.prototype.set_value=function(e){var t=this.text_color.value(),a=this.text_alpha.value();e.fillStyle=h(t,a),e.font=this.font_value(),e.textAlign=this.text_align.value(),e.textBaseline=this.text_baseline.value()},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)},enumerable:!0,configurable:!0}),t.prototype._set_vectorize=function(e,t){var a=this.cache_select("text_color",t),r=this.cache_select("text_alpha",t),o=this.cache_select("font",t),i=this.cache_select("text_align",t),l=this.cache_select("text_baseline",t);e.fillStyle=h(a,r),e.font=o,e.textAlign=i,e.textBaseline=l},t}(v);a.Text=x,x.__name__="Text",x.prototype.attrs=Object.keys(o.TextVector);var k=function(){function e(e){var t,a;try{for(var o=r.__values(e._mixins),i=o.next();!i.done;i=o.next()){var l=i.value,n=r.__read(l.split(":"),2),c=n[0],s=n[1],h=void 0===s?"":s,_=void 0;switch(c){case"line":_=f;break;case"fill":_=y;break;case"hatch":_=d;break;case"text":_=x;break;default:throw new Error("unknown visual: "+c)}this[h+c]=new _(e,h)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(a=o.return)&&a.call(o)}finally{if(t)throw t.error}}}return e.prototype.warm_cache=function(e,t){for(var a in this)if(this.hasOwnProperty(a)){var r=this[a];r instanceof v&&r.warm_cache(e,t)}},e}();a.Visuals=k,k.__name__="Visuals"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),n=t(191),a=t(123),s=t(187);function o(t){if(!t)throw new Error("cannot create a random attribute name for an undefined object");var e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",r="";do{r="";for(var i=0;i<12;i++)r+=e[Math.floor(Math.random()*e.length)]}while(t[r]);return r}function l(t){var e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return e[t]||e.alphabetic}var h=function(t,e){var r=new Map,i=t.split(",");e=e||10;for(var n=0;n<i.length;n+=2){var a="&"+i[n+1]+";",s=parseInt(i[n],e);r.set(a,"&#"+s+";")}return r.set("\\xa0","&#160;"),r}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),_={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}},p=function(){function t(t,e){this.__root=t,this.__ctx=e}return t.prototype.addColorStop=function(t,e){var r=this.__ctx.__createElement("stop");if(r.setAttribute("offset",""+t),-1!==e.indexOf("rgba")){var n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),a=i.__read(n,5),s=a[1],o=a[2],l=a[3],h=a[4];r.setAttribute("stop-color","rgb("+s+","+o+","+l+")"),r.setAttribute("stop-opacity",h)}else r.setAttribute("stop-color",e);this.__root.appendChild(r)},t}();p.__name__="CanvasGradient";var u=function(t,e){this.__root=t,this.__ctx=e};u.__name__="CanvasPattern";var c=function(){function t(t){var e,r,i;this.__currentPosition=null,this.__currentElementsToStyle=null,this._transform=new n.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.width=null!==(r=null==t?void 0:t.width)&&void 0!==r?r:500,this.height=null!==(i=null==t?void 0:t.height)&&void 0!==i?i:500,this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}return Object.defineProperty(t.prototype,"canvas",{get:function(){return this},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this._width},set:function(t){this._width=t,this.__root.setAttribute("width",""+t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this._height},set:function(t){this._height=t,this.__root.setAttribute("height",""+t)},enumerable:!0,configurable:!0}),t.prototype.__createElement=function(t,e,r){var n,a;void 0===e&&(e={}),void 0===r&&(r=!1);var s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);r&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));var o=Object.keys(e);try{for(var l=i.__values(o),h=l.next();!h.done;h=l.next()){var _=h.value;s.setAttribute(_,""+e[_])}}catch(t){n={error:t}}finally{try{h&&!h.done&&(a=l.return)&&a.call(l)}finally{if(n)throw n.error}}return s},t.prototype.__setDefaultStyles=function(){for(var t=Object.keys(_),e=0;e<t.length;e++){var r=t[e];this[r]=_[r].canvas}},t.prototype.__applyStyleState=function(t){for(var e=Object.keys(t),r=0;r<e.length;r++){var i=e[r];this[i]=t[i]}},t.prototype.__getStyleState=function(){for(var t=Object.keys(_),e={},r=0;r<t.length;r++){var i=t[r];e[i]=this[i]}return e},t.prototype.__applyStyleToCurrentElement=function(t){var e,r,n,s,o=this.__currentElement,l=this.__currentElementsToStyle;if(null!=l){o.setAttribute(t,""),o=l.element;try{for(var h=i.__values(l.children),c=h.next();!c.done;c=h.next()){c.value.setAttribute(t,"")}}catch(t){e={error:t}}finally{try{c&&!c.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}}for(var d=Object.keys(_),f=0;f<d.length;f++){var m=_[d[f]],g=this[d[f]];if(m.apply)if(g instanceof u){try{for(var v=(n=void 0,i.__values(i.__spread(g.__ctx.__defs.childNodes))),y=v.next();!y.done;y=v.next()){var b=y.value;if(b instanceof Element){var w=b.getAttribute("id");this.__ids[w]=w,this.__defs.appendChild(b)}}}catch(t){n={error:t}}finally{try{y&&!y.done&&(s=v.return)&&s.call(v)}finally{if(n)throw n.error}}var x=g.__root.getAttribute("id");o.setAttribute(m.apply,"url(#"+x+")")}else if(g instanceof p){x=g.__root.getAttribute("id");o.setAttribute(m.apply,"url(#"+x+")")}else if(-1!==m.apply.indexOf(t)&&m.svg!==g)if("stroke"!==m.svgAttr&&"fill"!==m.svgAttr||!a.isString(g)||-1===g.indexOf("rgba")){var A=m.svgAttr;if("globalAlpha"===d[f]&&(A=t+"-"+m.svgAttr,o.getAttribute(A)))continue;o.setAttribute(A,""+g)}else{var E=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(g),k=i.__read(E,5),C=k[1],S=k[2],P=k[3],T=k[4];o.setAttribute(m.svgAttr,"rgb("+C+","+S+","+P+")");var j=parseFloat(T),M=this.globalAlpha;null!=M&&(j*=M),o.setAttribute(m.svgAttr+"-opacity",""+j)}}},t.prototype.get_serialized_svg=function(t){var e,r;void 0===t&&(t=!1);var n=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(n)&&(n=n.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)try{for(var a=i.__values(h),s=a.next();!s.done;s=a.next()){var o=i.__read(s.value,2),l=o[0],_=o[1],p=new RegExp(l,"gi");p.test(n)&&(n=n.replace(p,_))}}catch(t){e={error:t}}finally{try{s&&!s.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}return n},t.prototype.get_svg=function(){return this.__root},t.prototype.save=function(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()},t.prototype.restore=function(){if(0!=this.__stack.length){var t=this.__stack.pop(),e=t.transform,r=t.clip_path,i=t.attributes;this._transform=e,this._clip_path=r,this.__applyStyleState(i)}},t.prototype._apply_transform=function(t,e){void 0===e&&(e=this._transform),e.is_identity||t.setAttribute("transform",e.toString())},t.prototype.scale=function(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)},t.prototype.rotate=function(t){isFinite(t)&&this._transform.rotate(t)},t.prototype.translate=function(t,e){isFinite(t+e)&&this._transform.translate(t,e)},t.prototype.transform=function(t,e,r,i,n,a){isFinite(t+e+r+i+n+a)&&this._transform.transform(t,e,r,i,n,a)},t.prototype.beginPath=function(){this.__currentDefaultPath="",this.__currentPosition=null;var t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t},t.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},t.prototype.__addPathCommand=function(t,e,r){var i=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=i+r,this.__currentPosition={x:t,y:e}},Object.defineProperty(t.prototype,"_hasCurrentDefaultPath",{get:function(){return!!this.__currentDefaultPath},enumerable:!0,configurable:!0}),t.prototype.moveTo=function(t,e){if(isFinite(t+e)){"path"!==this.__currentElement.nodeName&&this.beginPath();var r=i.__read(this._transform.apply(t,e),2),n=r[0],a=r[1];this.__addPathCommand(n,a,"M "+n+" "+a)}},t.prototype.closePath=function(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")},t.prototype.lineTo=function(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){var r=i.__read(this._transform.apply(t,e),2),n=r[0],a=r[1];this.__addPathCommand(n,a,"L "+n+" "+a)}else this.moveTo(t,e)},t.prototype.bezierCurveTo=function(t,e,r,n,a,s){if(isFinite(t+e+r+n+a+s)){var o=i.__read(this._transform.apply(a,s),2),l=o[0],h=o[1],_=i.__read(this._transform.apply(t,e),2),p=_[0],u=_[1],c=i.__read(this._transform.apply(r,n),2),d=c[0],f=c[1];this.__addPathCommand(l,h,"C "+p+" "+u+" "+d+" "+f+" "+l+" "+h)}},t.prototype.quadraticCurveTo=function(t,e,r,n){if(isFinite(t+e+r+n)){var a=i.__read(this._transform.apply(r,n),2),s=a[0],o=a[1],l=i.__read(this._transform.apply(t,e),2),h=l[0],_=l[1];this.__addPathCommand(s,o,"Q "+h+" "+_+" "+s+" "+o)}},t.prototype.arcTo=function(t,e,r,n,a){if(isFinite(t+e+r+n+a)&&null!=this.__currentPosition){var s=this.__currentPosition.x,o=this.__currentPosition.y;if(a<0)throw new Error("IndexSizeError: The radius provided ("+a+") is negative.");if(s===t&&o===e||t===r&&e===n||0===a)this.lineTo(t,e);else{var l=b([s-t,o-e]),h=b([r-t,n-e]);if(l[0]*h[1]!=l[1]*h[0]){var _=l[0]*h[0]+l[1]*h[1],p=Math.acos(Math.abs(_)),u=b([l[0]+h[0],l[1]+h[1]]),c=a/Math.sin(p/2),d=t+c*u[0],f=e+c*u[1],m=[-l[1],l[0]],g=[h[1],-h[0]],v=w(m),y=w(g);this.lineTo(d+m[0]*a,f+m[1]*a),this.arc(d,f,a,v,y)}else this.lineTo(t,e)}}function b(t){var e=i.__read(t,2),r=e[0],n=e[1],a=Math.sqrt(Math.pow(r,2)+Math.pow(n,2));return[r/a,n/a]}function w(t){var e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}},t.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.fill=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.rect=function(t,e,r,i){isFinite(t+e+r+i)&&("path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+i),this.lineTo(t,e+i),this.lineTo(t,e))},t.prototype.fillRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.fill())},t.prototype.strokeRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.stroke())},t.prototype.__clearCanvas=function(){s.empty(this.__defs),s.empty(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root},t.prototype.clearRect=function(t,e,r,i){if(isFinite(t+e+r+i))if(0!==t||0!==e||r!==this.width||i!==this.height){var n=this.__createElement("rect",{x:t,y:e,width:r,height:i,fill:"#FFFFFF"},!0);this._apply_transform(n),this.__root.appendChild(n)}else this.__clearCanvas()},t.prototype.createLinearGradient=function(t,e,r,n){if(!isFinite(t+e+r+n))throw new Error("The provided double value is non-finite");var a=i.__read(this._transform.apply(t,e),2),s=a[0],l=a[1],h=i.__read(this._transform.apply(r,n),2),_=h[0],u=h[1],c=this.__createElement("linearGradient",{id:o(this.__ids),x1:s+"px",x2:_+"px",y1:l+"px",y2:u+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(c),new p(c,this)},t.prototype.createRadialGradient=function(t,e,r,n,a,s){if(!isFinite(t+e+r+n+a+s))throw new Error("The provided double value is non-finite");var l=i.__read(this._transform.apply(t,e),2),h=l[0],_=l[1],u=i.__read(this._transform.apply(n,a),2),c=u[0],d=u[1],f=this.__createElement("radialGradient",{id:o(this.__ids),cx:c+"px",cy:d+"px",r:s+"px",fx:h+"px",fy:_+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(f),new p(f,this)},t.prototype.__parseFont=function(){var t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal"};return"underline"===this.__fontUnderline&&(e.decoration="underline"),null!=this.__fontHref&&(e.href=this.__fontHref),e},t.prototype.__wrapTextLink=function(t,e){if(t.href){var r=this.__createElement("a");return r.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),r.appendChild(e),r}return e},t.prototype.__applyText=function(t,e,r,i){var n,a,s=this.__parseFont(),o=this.__createElement("text",{"font-family":s.family,"font-size":s.size,"font-style":s.style,"font-weight":s.weight,"text-decoration":s.decoration,x:e,y:r,"text-anchor":(n=this.textAlign,a={left:"start",right:"end",center:"middle",start:"start",end:"end"},a[n]||a.start),"dominant-baseline":l(this.textBaseline)},!0);o.appendChild(this.__document.createTextNode(t)),this._apply_transform(o),this.__currentElement=o,this.__applyStyleToCurrentElement(i),this.__root.appendChild(this.__wrapTextLink(s,o))},t.prototype.fillText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"fill")},t.prototype.strokeText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"stroke")},t.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},t.prototype.arc=function(t,e,r,n,a,s){if(void 0===s&&(s=!1),isFinite(t+e+r+n+a)&&n!==a){(n%=2*Math.PI)===(a%=2*Math.PI)&&(a=(a+2*Math.PI-.001*(s?-1:1))%(2*Math.PI));var o=t+r*Math.cos(a),l=e+r*Math.sin(a),h=t+r*Math.cos(n),_=e+r*Math.sin(n),p=s?0:1,u=0,c=a-n;c<0&&(c+=2*Math.PI),u=s?c>Math.PI?0:1:c>Math.PI?1:0,this.lineTo(h,_);var d=r,f=r,m=i.__read(this._transform.apply(o,l),2),g=m[0],v=m[1];this.__addPathCommand(g,v,"A "+d+" "+f+" 0 "+u+" "+p+" "+g+" "+v)}},t.prototype.clip=function(){var t=this.__createElement("clipPath"),e=o(this.__ids);this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path="url(#"+e+")"},t.prototype.drawImage=function(e){for(var r,n,a,s,o,l,h,_,p,u,c,d,f,m,g,v=[],y=1;y<arguments.length;y++)v[y-1]=arguments[y];if(2==v.length){if(_=(r=i.__read(v,2))[0],p=r[1],!isFinite(_+p))return;d=0,f=0,u=m=e.width,c=g=e.height}else if(4==v.length){if(_=(n=i.__read(v,4))[0],p=n[1],u=n[2],c=n[3],!isFinite(_+p+u+c))return;d=0,f=0,m=e.width,g=e.height}else{if(8!==v.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);if(d=(a=i.__read(v,8))[0],f=a[1],m=a[2],g=a[3],_=a[4],p=a[5],u=a[6],c=a[7],!isFinite(d+f+m+g+_+p+u+c))return}var b=this.__root,w="translate("+_+", "+p+")",x=this._transform.clone().translate(_,p);if(e instanceof t||e instanceof SVGSVGElement){var A=e instanceof SVGSVGElement?e:e.get_svg(),E=A.cloneNode(!0),k=void 0;x.is_identity?k=b:(k=this.__createElement("g"),this._apply_transform(k,x),b.appendChild(k));try{for(var C=i.__values(i.__spread(E.childNodes)),S=C.next();!S.done;S=C.next()){var P=S.value;if(P instanceof SVGDefsElement)try{for(var T=(l=void 0,i.__values(i.__spread(P.childNodes))),j=T.next();!j.done;j=T.next()){var M=j.value;if(M instanceof Element){var F=M.getAttribute("id");this.__ids[F]=F,this.__defs.appendChild(M)}}}catch(t){l={error:t}}finally{try{j&&!j.done&&(h=T.return)&&h.call(T)}finally{if(l)throw l.error}}else k.appendChild(P)}}catch(t){s={error:t}}finally{try{S&&!S.done&&(o=C.return)&&o.call(C)}finally{if(s)throw s.error}}}else if(e instanceof HTMLImageElement||e instanceof SVGImageElement){if((D=this.__createElement("image")).setAttribute("width",""+u),D.setAttribute("height",""+c),D.setAttribute("preserveAspectRatio","none"),d||f||m!==e.width||g!==e.height)(O=this.__document.createElement("canvas")).width=u,O.height=c,(q=O.getContext("2d")).drawImage(e,d,f,m,g,0,0,u,c),e=O;D.setAttribute("transform",w);var N=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",N),b.appendChild(D)}else if(e instanceof HTMLCanvasElement){var D,O,q;(D=this.__createElement("image")).setAttribute("width",""+u),D.setAttribute("height",""+c),D.setAttribute("preserveAspectRatio","none"),(O=this.__document.createElement("canvas")).width=u,O.height=c,(q=O.getContext("2d")).imageSmoothingEnabled=!1,q.drawImage(e,d,f,m,g,0,0,u,c),e=O,D.setAttribute("transform",w),D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",e.toDataURL()),b.appendChild(D)}},t.prototype.createPattern=function(e,r){var n,a,s,l,h=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),_=o(this.__ids);if(h.setAttribute("id",_),h.setAttribute("width",""+this._to_number(e.width)),h.setAttribute("height",""+this._to_number(e.height)),h.setAttribute("patternUnits","userSpaceOnUse"),e instanceof HTMLCanvasElement||e instanceof HTMLImageElement||e instanceof SVGImageElement){var p=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),c=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");p.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",c),h.appendChild(p),this.__defs.appendChild(h)}else if(e instanceof t){try{for(var d=i.__values(i.__spread(e.__root.childNodes)),f=d.next();!f.done;f=d.next()){(v=f.value)instanceof SVGDefsElement||h.appendChild(v)}}catch(t){n={error:t}}finally{try{f&&!f.done&&(a=d.return)&&a.call(d)}finally{if(n)throw n.error}}this.__defs.appendChild(h)}else{if(!(e instanceof SVGSVGElement))throw new Error("unsupported");try{for(var m=i.__values(i.__spread(e.childNodes)),g=m.next();!g.done;g=m.next()){var v;(v=g.value)instanceof SVGDefsElement||h.appendChild(v)}}catch(t){s={error:t}}finally{try{g&&!g.done&&(l=m.return)&&l.call(m)}finally{if(s)throw s.error}}this.__defs.appendChild(h)}return new u(h,this)},t.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},t.prototype._to_number=function(t){return a.isNumber(t)?t:t.baseVal.value},t}();r.SVGRenderingContext2D=c,c.__name__="SVGRenderingContext2D"},
function _(t,r,n){Object.defineProperty(n,"__esModule",{value:!0});var e=Math.sin,o=Math.cos,i=function(){function t(t,r,n,e,o,i){void 0===t&&(t=1),void 0===r&&(r=0),void 0===n&&(n=0),void 0===e&&(e=1),void 0===o&&(o=0),void 0===i&&(i=0),this.a=t,this.b=r,this.c=n,this.d=e,this.e=o,this.f=i}return t.prototype.toString=function(){var t=this;return"matrix("+t.a+", "+t.b+", "+t.c+", "+t.d+", "+t.e+", "+t.f+")"},t.prototype.clone=function(){var r=this;return new t(r.a,r.b,r.c,r.d,r.e,r.f)},Object.defineProperty(t.prototype,"is_identity",{get:function(){var t=this,r=t.a,n=t.b,e=t.c,o=t.d,i=t.e,a=t.f;return 1==r&&0==n&&0==e&&1==o&&0==i&&0==a},enumerable:!0,configurable:!0}),t.prototype.apply=function(t,r){var n=this,e=n.a,o=n.b,i=n.c,a=n.d;return[e*t+i*r+n.e,o*t+a*r+n.f]},t.prototype.iv_apply=function(t,r){for(var n=this,e=n.a,o=n.b,i=n.c,a=n.d,s=n.e,f=n.f,p=t.length,u=0;u<p;u++){var c=t[u],h=r[u];t[u]=e*c+i*h+s,r[u]=o*c+a*h+f}},t.prototype.transform=function(t,r,n,e,o,i){var a=this,s=a.a,f=a.b,p=a.c,u=a.d,c=a.e,h=a.f;return this.a=s*t+p*r,this.c=s*n+p*e,this.e=s*o+p*i+c,this.b=f*t+u*r,this.d=f*n+u*e,this.f=f*o+u*i+h,this},t.prototype.translate=function(t,r){return this.transform(1,0,0,1,t,r)},t.prototype.scale=function(t,r){return this.transform(t,0,0,r,0,0)},t.prototype.skew=function(t,r){return this.transform(1,r,t,1,0,0)},t.prototype.rotate=function(t){var r=e(t),n=o(t);return this.transform(n,r,-r,n,0,0)},t.prototype.rotate_ccw=function(t){return this.rotate(-t)},t.prototype.translate_x=function(t){return this.translate(t,0)},t.prototype.translate_y=function(t){return this.translate(0,t)},t.prototype.flip=function(){return this.scale(-1,-1)},t.prototype.flip_x=function(){return this.scale(1,-1)},t.prototype.flip_y=function(){return this.scale(-1,1)},t}();n.AffineTransform=i,i.__name__="AffineTransform"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n,a,r=e(1),o=e(129),s=e(193),l=e(134),h=r.__importStar(e(133)),p=e(187),c=e(128),_=e(194),v=e(195),u=e(190),d=(n=document.createElement("canvas"),null!=(a=n.getContext("webgl",{premultipliedAlpha:!0}))?{canvas:n,gl:a}:void l.logger.trace("WebGL is not supported")),b={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"},g=function(){function e(e,t){switch(this.backend=e,this.hidpi=t,this.pixel_ratio=1,this.bbox=new _.BBox,e){case"webgl":case"canvas":if(this._el=this._canvas=p.canvas({style:b}),null==(i=this.canvas.getContext("2d")))throw new Error("unable to obtain 2D rendering context");this._ctx=i,t&&(this.pixel_ratio=devicePixelRatio);break;case"svg":var i=new u.SVGRenderingContext2D;this._ctx=i,this._canvas=i.get_svg(),this._el=p.div({style:b},this._canvas)}v.fixup_ctx(this._ctx)}return Object.defineProperty(e.prototype,"canvas",{get:function(){return this._canvas},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"ctx",{get:function(){return this._ctx},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"el",{get:function(){return this._el},enumerable:!0,configurable:!0}),e.prototype.resize=function(e,t){this.bbox=new _.BBox({left:0,top:0,width:e,height:t});var i=this._ctx instanceof u.SVGRenderingContext2D?this._ctx:this.canvas;i.width=e*this.pixel_ratio,i.height=t*this.pixel_ratio},e.prototype.prepare=function(){var e=this.ctx,t=this.hidpi,i=this.pixel_ratio;e.save(),t&&(e.scale(i,i),e.translate(.5,.5)),this.clear()},e.prototype.clear=function(){var e=this.bbox,t=e.x,i=e.y,n=e.width,a=e.height;this.ctx.clearRect(t,i,n,a)},e.prototype.finish=function(){this.ctx.restore()},e.prototype.to_blob=function(){var e=this._canvas;if(e instanceof HTMLCanvasElement)return null!=e.msToBlob?Promise.resolve(e.msToBlob()):new Promise((function(t,i){e.toBlob((function(e){return null!=e?t(e):i()}),"image/png")}));var t=this._ctx.get_serialized_svg(!0),i=new Blob([t],{type:"image/svg+xml"});return Promise.resolve(i)},e}();i.CanvasLayer=g,g.__name__="CanvasLayer";var y=function(e){function t(){var t=e.apply(this,r.__spread(arguments))||this;return t.bbox=new _.BBox,t}return r.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this);var t=this.model,i=t.output_backend,n=t.hidpi;"webgl"==i&&(this.webgl=d),this.underlays_el=p.div({style:b}),this.primary=new g(i,n),this.overlays=new g(i,n),this.overlays_el=p.div({style:b}),this.events_el=p.div({class:"bk-canvas-events",style:b});var a=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];c.extend(this.el.style,b),p.append.apply(void 0,r.__spread([this.el],a)),l.logger.debug("CanvasView initialized")},t.prototype.add_underlay=function(e){this.underlays_el.appendChild(e)},t.prototype.add_overlay=function(e){this.overlays_el.appendChild(e)},t.prototype.add_event=function(e){this.events_el.appendChild(e)},Object.defineProperty(t.prototype,"pixel_ratio",{get:function(){return this.primary.pixel_ratio},enumerable:!0,configurable:!0}),t.prototype.resize=function(e,t){this.bbox=new _.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)},t.prototype.prepare_webgl=function(e){var t=this.webgl;if(null!=t){var i=this.bbox,n=i.width,a=i.height;t.canvas.width=this.pixel_ratio*n,t.canvas.height=this.pixel_ratio*a;var o=t.gl;o.enable(o.SCISSOR_TEST);var s=r.__read(e,4),l=s[0],h=s[1],p=s[2],c=s[3],_=this.bbox,v=_.xview,u=_.yview,d=v.compute(l),b=u.compute(h+c),g=this.pixel_ratio;o.scissor(g*d,g*b,g*p,g*c),o.enable(o.BLEND),o.blendFuncSeparate(o.SRC_ALPHA,o.ONE_MINUS_SRC_ALPHA,o.ONE_MINUS_DST_ALPHA,o.ONE)}},t.prototype.clear_webgl=function(){var e=this.webgl;if(null!=e){var t=e.gl,i=e.canvas;t.viewport(0,0,i.width,i.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT||t.DEPTH_BUFFER_BIT)}},t.prototype.blit_webgl=function(e){var t=this.webgl;if(null!=t&&(l.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi)){var i=this.pixel_ratio;e.scale(i,i),e.translate(.5,.5)}},t.prototype.compose=function(){var e=this.model,t=e.output_backend,i=e.hidpi,n=this.bbox,a=n.width,r=n.height,o=new g(t,i);return o.resize(a,r),o.ctx.drawImage(this.primary.canvas,0,0),o.ctx.drawImage(this.overlays.canvas,0,0),o},t.prototype.to_blob=function(){return this.compose().to_blob()},t}(s.DOMView);i.CanvasView=y,y.__name__="CanvasView";var f=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Canvas=function(){this.prototype.default_view=y,this.internal({hidpi:[h.Boolean,!0],output_backend:[h.OutputBackend,"canvas"]})},t}(o.HasProps);i.Canvas=f,f.__name__="Canvas",f.init_Canvas()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),o=e(186),r=e(187),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.el=this._createElement()},t.prototype.remove=function(){r.remove(this.el),e.prototype.remove.call(this)},t.prototype.css_classes=function(){return[]},t.prototype.render=function(){},t.prototype.renderTo=function(e){e.appendChild(this.el),this.render()},t.prototype._createElement=function(){return r.createElement(this.tagName,{class:this.css_classes()})},t}(o.View);n.DOMView=s,s.__name__="DOMView",s.prototype.tagName="div"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(139),n=Math.min,o=Math.max;i.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},i.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},i.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},i.union=function(t,e){return{x0:n(t.x0,e.x0),x1:o(t.x1,e.x1),y0:n(t.y0,e.y0),y1:o(t.y1,e.y1)}};var h=function(){function t(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){var e=t.x0,i=t.y0,r=t.x1,n=t.y1;if(!(e<=r&&i<=n))throw new Error("invalid bbox {x0: "+e+", y0: "+i+", x1: "+r+", y1: "+n+"}");this.x0=e,this.y0=i,this.x1=r,this.y1=n}else if("x"in t){var o=t.x,h=t.y,u=t.width,y=t.height;if(!(u>=0&&y>=0))throw new Error("invalid bbox {x: "+o+", y: "+h+", width: "+u+", height: "+y+"}");this.x0=o,this.y0=h,this.x1=o+u,this.y1=h+y}else{var f=void 0,s=void 0,c=void 0,p=void 0;if("width"in t)if("left"in t)s=(f=t.left)+t.width;else if("right"in t)f=(s=t.right)-t.width;else{var b=t.width/2;f=t.hcenter-b,s=t.hcenter+b}else f=t.left,s=t.right;if("height"in t)if("top"in t)p=(c=t.top)+t.height;else if("bottom"in t)c=(p=t.bottom)-t.height;else{var l=t.height/2;c=t.vcenter-l,p=t.vcenter+l}else c=t.top,p=t.bottom;if(!(f<=s&&c<=p))throw new Error("invalid bbox {left: "+f+", top: "+c+", right: "+s+", bottom: "+p+"}");this.x0=f,this.y0=c,this.x1=s,this.y1=p}}return t.prototype.toString=function(){return"BBox({left: "+this.left+", top: "+this.top+", width: "+this.width+", height: "+this.height+"})"},Object.defineProperty(t.prototype,"left",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rect",{get:function(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"box",{get:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hcenter",{get:function(){return(this.left+this.right)/2},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"vcenter",{get:function(){return(this.top+this.bottom)/2},enumerable:!0,configurable:!0}),t.prototype.relativize=function(){return new t({x:0,y:0,width:this.width,height:this.height})},t.prototype.contains=function(t,e){return t>=this.x0&&t<=this.x1&&e>=this.y0&&e<=this.y1},t.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},t.prototype.union=function(e){return new t({x0:n(this.x0,e.x0),y0:n(this.y0,e.y0),x1:o(this.x1,e.x1),y1:o(this.y1,e.y1)})},t.prototype.equals=function(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1},Object.defineProperty(t.prototype,"xview",{get:function(){var t=this;return{compute:function(e){return t.left+e},v_compute:function(e){for(var i=new r.NumberArray(e.length),n=t.left,o=0;o<e.length;o++)i[o]=n+e[o];return i}}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var t=this;return{compute:function(e){return t.bottom-e},v_compute:function(e){for(var i=new r.NumberArray(e.length),n=t.bottom,o=0;o<e.length;o++)i[o]=n-e[o];return i}}},enumerable:!0,configurable:!0}),t}();i.BBox=h,h.__name__="BBox"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.fixup_ctx=function(e){!function(e){void 0===e.lineDash&&Object.defineProperty(e,"lineDash",{get:function(){return e.getLineDash()},set:function(t){return e.setLineDash(t)}})}(e),function(e){e.setImageSmoothingEnabled=function(t){e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t},e.getImageSmoothingEnabled=function(){var t=e.imageSmoothingEnabled;return null==t||t}}(e),function(e){e.measureText&&null==e.html5MeasureText&&(e.html5MeasureText=e.measureText,e.measureText=function(t){var n=e.html5MeasureText(t);return n.ascent=1.6*e.html5MeasureText("m").width,n})}(e),function(e){e.ellipse||(e.ellipse=function(t,n,o,a,i,r,u,m){void 0===m&&(m=!1);var l=.551784;e.translate(t,n),e.rotate(i);var s=o,g=a;m&&(s=-o,g=-a),e.moveTo(-s,0),e.bezierCurveTo(-s,g*l,-s*l,g,0,g),e.bezierCurveTo(s*l,g,s,g*l,s,0),e.bezierCurveTo(s,-g*l,s*l,-g,0,-g),e.bezierCurveTo(-s*l,-g,-s,-g*l,-s,0),e.rotate(-i),e.translate(-t,-n)})}(e)}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),a=e(129),o=r.__importStar(e(133)),c=e(123),i=e(128),s=e(134),l=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Model=function(){this.define({tags:[o.Array,[]],name:[o.String],js_property_callbacks:[o.Any,{}],js_event_callbacks:[o.Any,{}],subscribed_events:[o.Array,[]]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._js_callbacks=new Map},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(function(){return t._update_property_callbacks()})),this.connect(this.properties.js_event_callbacks.change,(function(){return t._update_event_callbacks()})),this.connect(this.properties.subscribed_events.change,(function(){return t._update_event_callbacks()}))},t.prototype._process_event=function(e){var t,n;try{for(var a=r.__values(this.js_event_callbacks[e.event_name]||[]),o=a.next();!o.done;o=a.next()){o.value.execute(e)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}null!=this.document&&this.subscribed_events.some((function(t){return t==e.event_name}))&&this.document.event_manager.send_event(e)},t.prototype.trigger_event=function(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))},t.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this):s.logger.warn("WARNING: Document not defined for updating event callbacks")},t.prototype._update_property_callbacks=function(){var e,t,n,a,o,c,s,l,_=this,u=function(e){var t=r.__read(e.split(":"),2),n=t[0],a=t[1],o=void 0===a?null:a;return null!=o?_.properties[o][n]:_[n]};try{for(var p=r.__values(this._js_callbacks),d=p.next();!d.done;d=p.next()){var h=r.__read(d.value,2),f=h[0],v=h[1],y=u(f);try{for(var b=(n=void 0,r.__values(v)),m=b.next();!m.done;m=b.next()){var g=m.value;this.disconnect(y,g)}}catch(e){n={error:e}}finally{try{m&&!m.done&&(a=b.return)&&a.call(b)}finally{if(n)throw n.error}}}}catch(t){e={error:t}}finally{try{d&&!d.done&&(t=p.return)&&t.call(p)}finally{if(e)throw e.error}}this._js_callbacks.clear();try{for(var k=r.__values(i.entries(this.js_property_callbacks)),j=k.next();!j.done;j=k.next()){var x=r.__read(j.value,2),w=(f=x[0],(v=x[1]).map((function(e){return function(){return e.execute(_)}})));this._js_callbacks.set(f,w);y=u(f);try{for(var M=(s=void 0,r.__values(w)),A=M.next();!A.done;A=M.next()){g=A.value;this.connect(y,g)}}catch(e){s={error:e}}finally{try{A&&!A.done&&(l=M.return)&&l.call(M)}finally{if(s)throw s.error}}}}catch(e){o={error:e}}finally{try{j&&!j.done&&(c=k.return)&&c.call(k)}finally{if(o)throw o.error}}},t.prototype._doc_attached=function(){i.isEmpty(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()},t.prototype._doc_detached=function(){this.document.event_manager.subscribed_models.delete(this)},t.prototype.select=function(e){if(c.isString(e))return r.__spread(this.references()).filter((function(n){return n instanceof t&&n.name===e}));if(e.prototype instanceof a.HasProps)return r.__spread(this.references()).filter((function(t){return t instanceof e}));throw new Error("invalid selector")},t.prototype.select_one=function(e){var t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}},t}(a.HasProps);n.Model=l,l.__name__="Model",l.init_Model()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});var r=function(){function e(e,t){this.x_scale=e,this.y_scale=t,this.x_range=this.x_scale.source_range,this.y_range=this.y_scale.source_range,this.ranges=[this.x_range,this.y_range],this.scales=[this.x_scale,this.y_scale]}return e.prototype.map_to_screen=function(e,t){return[this.x_scale.v_compute(e),this.y_scale.v_compute(t)]},e.prototype.map_from_screen=function(e,t){return[this.x_scale.v_invert(e),this.y_scale.v_invert(t)]},e}();s.CoordinateTransform=r,r.__name__="CoordinateTransform"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(151),o=t(199),s=t(200),a=t(143),_=n.__importStar(t(133)),c=t(125),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.model.source&&(this.model.source=new s.ColumnDataSource),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.streaming,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.patching,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.change,(function(){return e.set_data(e.model.source)}))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,i,n,r=this.plot_view.frame;return"data"==this.model.start_units?(t=this.coordinates.x_scale.v_compute(this._x_start),e=this.coordinates.y_scale.v_compute(this._y_start)):(t=r.xview.v_compute(this._x_start),e=r.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=this.coordinates.x_scale.v_compute(this._x_end),n=this.coordinates.y_scale.v_compute(this._y_end)):(i=r.xview.v_compute(this._x_end),n=r.yview.v_compute(this._y_end)),[[t,e],[i,n]]},e.prototype._render=function(){var t=this.layer.ctx;t.save();var e=n.__read(this._map_data(),2),i=e[0],r=e[1];null!=this.model.end&&this._arrow_head(t,"render",this.model.end,i,r),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,r,i),t.beginPath();var o=this.plot_view.frame.bbox,s=o.x,a=o.y,_=o.width,c=o.height;t.rect(s,a,_,c),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,i,r),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,r,i),t.closePath(),t.clip(),this._arrow_body(t,i,r),t.restore()},e.prototype._arrow_head=function(t,e,i,n,r){for(var o=0,s=this._x_start.length;o<s;o++){var a=Math.PI/2+c.atan2([n[0][o],n[1][o]],[r[0][o],r[1][o]]);t.save(),t.translate(r[0][o],r[1][o]),t.rotate(a),"render"==e?i.render(t,o):"clip"==e&&i.clip(t,o),t.restore()}},e.prototype._arrow_body=function(t,e,i){if(this.visuals.line.doit)for(var n=0,r=this._x_start.length;n<r;n++)this.visuals.line.set_vectorize(t,n),t.beginPath(),t.moveTo(e[0][n],e[1][n]),t.lineTo(i[0][n],i[1][n]),t.stroke()},e}(r.AnnotationView);i.ArrowView=h,h.__name__="ArrowView";var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Arrow=function(){this.prototype.default_view=h,this.mixins(a.LineVector),this.define({x_start:[_.NumberSpec],y_start:[_.NumberSpec],start_units:[_.SpatialUnits,"data"],start:[_.Instance,null],x_end:[_.NumberSpec],y_end:[_.NumberSpec],end_units:[_.SpatialUnits,"data"],end:[_.Instance,function(){return new o.OpenHead({})}],source:[_.Instance]})},e}(r.Annotation);i.Arrow=l,l.__name__="Arrow",l.init_Arrow()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});var s=i(1),n=i(151),o=i(189),l=i(143),r=s.__importStar(i(133)),h=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_ArrowHead=function(){this.define({size:[r.Number,25]})},e.prototype.initialize=function(){i.prototype.initialize.call(this),this.visuals=new o.Visuals(this)},e}(n.Annotation);t.ArrowHead=h,h.__name__="ArrowHead",h.init_ArrowHead();var a=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_OpenHead=function(){this.mixins(l.LineVector)},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,0),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.stroke())},e}(h);t.OpenHead=a,a.__name__="OpenHead",a.init_OpenHead();var _=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_NormalHead=function(){this.mixins([l.LineVector,l.FillVector]),this.override({fill_color:"black"})},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._normal(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._normal(i,e),i.stroke())},e.prototype._normal=function(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.closePath()},e}(h);t.NormalHead=_,_.__name__="NormalHead",_.init_NormalHead();var c=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_VeeHead=function(){this.mixins([l.LineVector,l.FillVector]),this.override({fill_color:"black"})},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._vee(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._vee(i,e),i.stroke())},e.prototype._vee=function(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.closePath()},e}(h);t.VeeHead=c,c.__name__="VeeHead",c.init_VeeHead();var u=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_TeeHead=function(){this.mixins(l.LineVector)},e.prototype.render=function(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,0),i.lineTo(-.5*this.size,0),i.stroke())},e.prototype.clip=function(i,e){},e}(h);t.TeeHead=u,u.__name__="TeeHead",u.init_TeeHead()},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),a=t(201),o=n.__importStar(t(133)),i=t(123),l=t(128),u=n.__importStar(t(234)),s=t(235),c=t(236);function d(t,r,e){if(i.isArray(t)){var n=t.concat(r);return null!=e&&n.length>e?n.slice(-e):n}if(i.isTypedArray(t)){var a=t.length+r.length;if(null!=e&&a>e){var o=a-e,l=t.length;n=void 0;t.length<e?(n=new t.constructor(e)).set(t,0):n=t;for(var s=o,c=l;s<c;s++)n[s-o]=n[s];for(s=0,c=r.length;s<c;s++)n[s+(l-o)]=r[s];return n}var d=new t.constructor(r);return u.concat(t,d)}throw new Error("unsupported array types")}function _(t,r){var e,n,a;return i.isNumber(t)?(e=t,a=t+1,n=1):(e=null!=t.start?t.start:0,a=null!=t.stop?t.stop:r,n=null!=t.step?t.step:1),[e,a,n]}function h(t,r){var e,a,o=new Set,l=!1;try{for(var u=n.__values(r),s=u.next();!s.done;s=u.next()){var c=n.__read(s.value,2),d=c[0],h=c[1],v=void 0,f=void 0,m=void 0,y=void 0;if(i.isArray(d)){var p=n.__read(d,1)[0];o.add(p),v=t[p].shape,f=t[p],y=h,2===d.length?(v=[1,v[0]],m=[d[0],0,d[1]]):m=d}else i.isNumber(d)?(y=[h],o.add(d)):(y=h,l=!0),m=[0,0,d],v=[1,t.length],f=t;var g=0,w=n.__read(_(m[1],v[0]),3),S=w[0],x=w[1],C=w[2],D=n.__read(_(m[2],v[1]),3),A=D[0],b=D[1],E=D[2];for(p=S;p<x;p+=C)for(var N=A;N<b;N+=E)l&&o.add(N),f[p*v[1]+N]=y[g],g++}}catch(t){e={error:t}}finally{try{s&&!s.done&&(a=u.return)&&a.call(u)}finally{if(e)throw e.error}}return o}e.stream_to_column=d,e.slice=_,e.patch_to_column=h;var v=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_ColumnDataSource=function(){this.define({data:[o.Any,{}]})},r.prototype.stream=function(t,r,e){var a,o,i=this.data;try{for(var u=n.__values(l.entries(t)),s=u.next();!s.done;s=u.next()){var _=n.__read(s.value,2),h=_[0],v=_[1];i[h]=d(i[h],v,r)}}catch(t){a={error:t}}finally{try{s&&!s.done&&(o=u.return)&&o.call(u)}finally{if(a)throw a.error}}if(this.setv({data:i},{silent:!0}),this.streaming.emit(),null!=this.document){var f=new c.ColumnsStreamedEvent(this.document,this.ref(),t,r);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:f})}},r.prototype.patch=function(t,r){var e,a,o=this.data,i=new Set;try{for(var u=n.__values(l.entries(t)),d=u.next();!d.done;d=u.next()){var _=n.__read(d.value,2),v=_[0],f=_[1];i=s.union(i,h(o[v],f))}}catch(t){e={error:t}}finally{try{d&&!d.done&&(a=u.return)&&a.call(u)}finally{if(e)throw e.error}}if(this.setv({data:o},{silent:!0}),this.patching.emit(n.__spread(i)),null!=this.document){var m=new c.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:r,hint:m})}},r}(a.ColumnarDataSource);e.ColumnDataSource=v,v.__name__="ColumnDataSource",v.init_ColumnDataSource()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),a=t(202),i=t(130),o=t(134),u=t(204),l=r.__importStar(t(133)),c=t(123),s=t(124),h=t(128),f=t(203),p=t(233),g=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.prototype.get_array=function(t){var n=this.data[t];return null==n?this.data[t]=n=[]:c.isArray(n)||(this.data[t]=n=Array.from(n)),n},n.init_ColumnarDataSource=function(){this.define({selection_policy:[l.Instance,function(){return new p.UnionRenderers}]}),this.internal({selection_manager:[l.Instance,function(t){return new u.SelectionManager({source:t})}],inspected:[l.Instance,function(){return new f.Selection}]})},n.prototype.initialize=function(){t.prototype.initialize.call(this),this._select=new i.Signal0(this,"select"),this.inspect=new i.Signal(this,"inspect"),this.streaming=new i.Signal0(this,"streaming"),this.patching=new i.Signal(this,"patching")},n.prototype.get_column=function(t){var n=this.data[t];return null!=n?n:null},n.prototype.columns=function(){return h.keys(this.data)},n.prototype.get_length=function(t){void 0===t&&(t=!0);var n=s.uniq(h.values(this.data).map((function(t){return t.length})));switch(n.length){case 0:return null;case 1:return n[0];default:var e="data source has columns of inconsistent lengths";if(t)return o.logger.warn(e),n.sort()[0];throw new Error(e)}},Object.defineProperty(n.prototype,"length",{get:function(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0},enumerable:!0,configurable:!0}),n.prototype.clear=function(){var t,n,e={};try{for(var a=r.__values(this.columns()),i=a.next();!i.done;i=a.next()){var o=i.value;e[o]=new this.data[o].constructor(0)}}catch(n){t={error:n}}finally{try{i&&!i.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}this.data=e},n}(a.DataSource);e.ColumnarDataSource=g,g.__name__="ColumnarDataSource",g.init_ColumnarDataSource()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(196),a=e(203),c=i.__importStar(e(133)),o=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_DataSource=function(){this.define({selected:[c.Instance,function(){return new a.Selection}]})},t}(r.Model);n.DataSource=o,o.__name__="DataSource",o.init_DataSource()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=i(1),s=i(196),l=n.__importStar(i(133)),c=i(124),h=i(128),d=function(i){function e(e){return i.call(this,e)||this}return n.__extends(e,i),e.prototype.get_view=function(){return this.view},e.init_Selection=function(){this.define({indices:[l.Array,[]],line_indices:[l.Array,[]],multiline_indices:[l.Any,{}]}),this.internal({selected_glyphs:[l.Array,[]],view:[l.Any],image_indices:[l.Array,[]]})},e.prototype.initialize=function(){i.prototype.initialize.call(this)},Object.defineProperty(e.prototype,"selected_glyph",{get:function(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null},enumerable:!0,configurable:!0}),e.prototype.add_to_selected_glyphs=function(i){this.selected_glyphs.push(i)},e.prototype.update=function(i,e,t){switch(void 0===e&&(e=!0),void 0===t&&(t="replace"),t){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.view=i.view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}},e.prototype.clear=function(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.view=null,this.selected_glyphs=[]},e.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},e.prototype.update_through_union=function(i){this.indices=c.union(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_intersection=function(i){this.indices=c.intersection(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_subtraction=function(i){this.indices=c.difference(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)},e}(s.Model);t.Selection=d,d.__name__="Selection",d.init_Selection()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),i=e(129),o=e(203),c=e(205),l=e(231),s=n.__importStar(e(133)),a=function(e){function t(t){var r=e.call(this,t)||this;return r.inspectors=new Map,r}return n.__extends(t,e),t.init_SelectionManager=function(){this.internal({source:[s.Any]})},t.prototype.select=function(e,t,r,i){var o,s,a,p;void 0===i&&(i="replace");var _=[],u=[];try{for(var h=n.__values(e),d=h.next();!d.done;d=h.next()){(m=d.value)instanceof c.GlyphRendererView?_.push(m):m instanceof l.GraphRendererView&&u.push(m)}}catch(e){o={error:e}}finally{try{d&&!d.done&&(s=h.return)&&s.call(h)}finally{if(o)throw o.error}}var f=!1;try{for(var y=n.__values(u),v=y.next();!v.done;v=y.next()){var m,g=(m=v.value).model.selection_policy.hit_test(t,m);f=f||m.model.selection_policy.do_selection(g,m.model,r,i)}}catch(e){a={error:e}}finally{try{v&&!v.done&&(p=y.return)&&p.call(y)}finally{if(a)throw a.error}}if(_.length>0){g=this.source.selection_policy.hit_test(t,_);f=f||this.source.selection_policy.do_selection(g,this.source,r,i)}return f},t.prototype.inspect=function(e,t){var r=!1;if(e instanceof c.GlyphRendererView){if(null!=(i=e.hit_test(t))){r=!i.is_empty();var n=this.get_or_create_inspector(e.model);n.update(i,!0,"replace"),this.source.setv({inspected:n},{silent:!0}),this.source.inspect.emit([e,{geometry:t}])}}else if(e instanceof l.GraphRendererView){var i=e.model.inspection_policy.hit_test(t,e);r=r||e.model.inspection_policy.do_inspection(i,t,e,!1,"replace")}return r},t.prototype.clear=function(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()},t.prototype.get_or_create_inspector=function(e){var t=this.inspectors.get(e);return null==t&&(t=new o.Selection,this.inspectors.set(e,t)),t},t}(i.HasProps);r.SelectionManager=a,a.__name__="SelectionManager",a.init_SelectionManager()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),l=e(206),r=e(207),s=e(225),h=e(226),o=e(228),a=e(229),c=e(139),_=n.__importStar(e(133)),d=e(127),u=e(124),p=e(128),y=e(230),g=e(213),v={fill:{},line:{}},f={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},m={fill:{fill_alpha:.2},line:{}},w=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){function t(e){var t=p.clone(s);return l&&p.extend(t,e.fill),r&&p.extend(t,e.line),new i.constructor(t)}var i,l,r,s,h,o,a,c,_,d,y,g,w,b,x;return n.__generator(this,(function(n){switch(n.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return n.sent(),i=this.model.glyph,l=u.includes(i._mixins,"fill"),r=u.includes(i._mixins,"line"),delete(s=p.clone(i.attributes)).id,h=this,[4,this.build_glyph_view(i)];case 2:return h.glyph=n.sent(),null==(o=this.model.selection_glyph)?o=t({fill:{},line:{}}):"auto"===o&&(o=t(v)),a=this,[4,this.build_glyph_view(o)];case 3:return a.selection_glyph=n.sent(),null==(c=this.model.nonselection_glyph)?c=t({fill:{},line:{}}):"auto"===c&&(c=t(m)),_=this,[4,this.build_glyph_view(c)];case 4:return _.nonselection_glyph=n.sent(),null==(d=this.model.hover_glyph)?[3,6]:(y=this,[4,this.build_glyph_view(d)]);case 5:y.hover_glyph=n.sent(),n.label=6;case 6:return null==(g=this.model.muted_glyph)?[3,8]:(w=this,[4,this.build_glyph_view(g)]);case 7:w.muted_glyph=n.sent(),n.label=8;case 8:return b=t(f),x=this,[4,this.build_glyph_view(b)];case 9:return x.decimated_glyph=n.sent(),this.set_data(!1),[2]}}))}))},t.prototype.build_glyph_view=function(e){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(t){return[2,y.build_view(e,{parent:this})]}))}))},t.prototype.remove=function(){var t,i;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(t=this.hover_glyph)||void 0===t||t.remove(),null===(i=this.muted_glyph)||void 0===i||i.remove(),this.decimated_glyph.remove(),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t,i,l,r,s=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return s.request_render()})),this.connect(this.model.glyph.change,(function(){return s.set_data()})),this.connect(this.model.data_source.change,(function(){return s.set_data()})),this.connect(this.model.data_source.streaming,(function(){return s.set_data()})),this.connect(this.model.data_source.patching,(function(e){return s.set_data(!0,e)})),this.connect(this.model.data_source.selected.change,(function(){return s.request_render()})),this.connect(this.model.data_source._select,(function(){return s.request_render()})),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,(function(){return s.request_render()})),this.connect(this.model.properties.view.change,(function(){return s.set_data()})),this.connect(this.model.view.change,(function(){return s.set_data()})),this.connect(this.model.properties.visible.change,(function(){return s.plot_view.update_dataranges()}));var h=this.plot_view.frame,o=h.x_ranges,a=h.y_ranges;try{for(var c=n.__values(o),_=c.next();!_.done;_=c.next()){(p=n.__read(_.value,2)[1])instanceof g.FactorRange&&this.connect(p.change,(function(){return s.set_data()}))}}catch(e){t={error:e}}finally{try{_&&!_.done&&(i=c.return)&&i.call(c)}finally{if(t)throw t.error}}try{for(var d=n.__values(a),u=d.next();!u.done;u=d.next()){var p;(p=n.__read(u.value,2)[1])instanceof g.FactorRange&&this.connect(p.change,(function(){return s.set_data()}))}}catch(e){l={error:e}}finally{try{u&&!u.done&&(r=d.return)&&r.call(d)}finally{if(l)throw l.error}}this.connect(this.model.glyph.transformchange,(function(){return s.set_data()}))},t.prototype._update_masked_indices=function(){var e=this.glyph.mask_data();return this.model.view.masked=e,e},t.prototype.set_data=function(e,t){var i,n,l,r;void 0===e&&(e=!0),void 0===t&&(t=null);var s=this.model.data_source;this.all_indices=this.model.view.indices;var h=this.all_indices;this.glyph.set_data(s,h,t),this.glyph.set_visuals(s,h),this.decimated_glyph.set_visuals(s,h),null===(i=this.selection_glyph)||void 0===i||i.set_visuals(s,h),null===(n=this.nonselection_glyph)||void 0===n||n.set_visuals(s,h),null===(l=this.hover_glyph)||void 0===l||l.set_visuals(s,h),null===(r=this.muted_glyph)||void 0===r||r.set_visuals(s,h),this._update_masked_indices();var o=this.plot_model.lod_factor,a=this.all_indices.count;this.decimated=new c.Indices(a);for(var _=0;_<a;_+=o)this.decimated.set(_);this.set_data_timestamp=Date.now(),e&&this.request_render()},Object.defineProperty(t.prototype,"has_webgl",{get:function(){return this.glyph.has_webgl},enumerable:!0,configurable:!0}),t.prototype._render=function(){var e,t,i,l,a,c,_,p,y=this,g=this.has_webgl;this.glyph.map_data();var v=n.__spread(this.all_indices),f=n.__spread(this._update_masked_indices()),m=this.layer.ctx;m.save();var w,b=this.model.data_source.selected;w=!b||b.is_empty()?[]:this.glyph instanceof r.LineView&&b.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(f):b.indices;var x,V,R,I=this.model.data_source.inspected,k=new Set(!I||I.is_empty()?[]:I.selected_glyph?y.model.view.convert_indices_from_subset(f):I.indices.length>0?I.indices:Object.keys(I.multiline_indices).map((function(e){return parseInt(e)}))),z=d.filter(f,(function(e){return k.has(v[e])})),A=this.plot_model.lod_threshold;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!g&&null!=A&&v.length>A?(f=n.__spread(this.decimated),x=this.decimated_glyph,V=this.decimated_glyph,R=this.selection_glyph):(x=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,V=this.nonselection_glyph,R=this.selection_glyph),null!=this.hover_glyph&&z.length&&(f=u.difference(f,z)),w.length){var G={};try{for(var q=n.__values(w),D=q.next();!D.done;D=q.next()){G[B=D.value]=!0}}catch(e){i={error:e}}finally{try{D&&!D.done&&(l=q.return)&&l.call(q)}finally{if(i)throw i.error}}var L=new Array,O=new Array;if(this.glyph instanceof r.LineView)try{for(var j=n.__values(v),P=j.next();!P.done;P=j.next()){null!=G[B=P.value]?L.push(B):O.push(B)}}catch(e){a={error:e}}finally{try{P&&!P.done&&(c=j.return)&&c.call(j)}finally{if(a)throw a.error}}else try{for(var S=n.__values(f),F=S.next();!F.done;F=S.next()){var B=F.value;null!=G[v[B]]?L.push(B):O.push(B)}}catch(e){_={error:e}}finally{try{F&&!F.done&&(p=S.return)&&p.call(S)}finally{if(_)throw _.error}}V.render(m,O,this.glyph),R.render(m,L,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof r.LineView?this.hover_glyph.render(m,this.model.view.convert_indices_from_subset(z),this.glyph):this.hover_glyph.render(m,z,this.glyph))}else if(this.glyph instanceof r.LineView)this.hover_glyph&&z.length?this.hover_glyph.render(m,this.model.view.convert_indices_from_subset(z),this.glyph):x.render(m,v,this.glyph);else if(this.glyph instanceof s.PatchView||this.glyph instanceof h.HAreaView||this.glyph instanceof o.VAreaView)if(0==I.selected_glyphs.length||null==this.hover_glyph)x.render(m,v,this.glyph);else try{for(var C=n.__values(I.selected_glyphs),H=C.next();!H.done;H=C.next()){H.value==this.glyph.model&&this.hover_glyph.render(m,v,this.glyph)}}catch(t){e={error:t}}finally{try{H&&!H.done&&(t=C.return)&&t.call(C)}finally{if(e)throw e.error}}else x.render(m,f,this.glyph),this.hover_glyph&&z.length&&this.hover_glyph.render(m,z,this.glyph);m.restore()},t.prototype.draw_legend=function(e,t,i,n,l,r,s,h){null==h&&(h=this.model.get_reference_point(r,s)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:n,y1:l},h)},t.prototype.hit_test=function(e){if(!this.model.visible)return null;var t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)},t}(l.DataRendererView);i.GlyphRendererView=w,w.__name__="GlyphRendererView";var b=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_GlyphRenderer=function(){this.prototype.default_view=w,this.define({data_source:[_.Instance],view:[_.Instance,function(){return new a.CDSView}],glyph:[_.Instance],hover_glyph:[_.Instance],nonselection_glyph:[_.Any,"auto"],selection_glyph:[_.Any,"auto"],muted_glyph:[_.Instance],muted:[_.Boolean,!1]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())},t.prototype.get_reference_point=function(e,t){var i=0;if(null!=e){var n=this.data_source.get_column(e);if(null!=n){var l=d.indexOf(n,t);-1!=l&&(i=l)}}return i},t.prototype.get_selection_manager=function(){return this.data_source.selection_manager},t}(l.DataRenderer);i.GlyphRenderer=b,b.__name__="GlyphRenderer",b.init_GlyphRenderer()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(1),i=e(185),a=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return t.__extends(n,e),Object.defineProperty(n.prototype,"xscale",{get:function(){return this.coordinates.x_scale},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"yscale",{get:function(){return this.coordinates.y_scale},enumerable:!0,configurable:!0}),n}(i.RendererView);r.DataRendererView=a,a.__name__="DataRendererView";var o=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_DataRenderer=function(){this.override({level:"glyph"})},n}(i.Renderer);r.DataRenderer=o,o.__name__="DataRenderer",o.init_DataRenderer()},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(1),r=e(208),s=e(215),l=e(217),o=n.__importStar(e(143)),_=n.__importStar(e(216)),a=e(203),h=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(i,e),i.prototype.initialize=function(){e.prototype.initialize.call(this);var i=this.renderer.plot_view.canvas_view.webgl;null!=i&&(this.glglyph=new l.LineGL(i.gl,this))},i.prototype._render=function(e,i,t){var r,s,l=t.sx,o=t.sy,_=!1,a=null;this.visuals.line.set_value(e);try{for(var h=n.__values(i),u=h.next();!u.done;u=h.next()){var p=u.value;if(_){if(!isFinite(l[p]+o[p])){e.stroke(),e.beginPath(),_=!1,a=p;continue}null!=a&&p-a>1&&(e.stroke(),_=!1)}_?e.lineTo(l[p],o[p]):(e.beginPath(),e.moveTo(l[p],o[p]),_=!0),a=p}}catch(e){r={error:e}}finally{try{u&&!u.done&&(s=h.return)&&s.call(h)}finally{if(r)throw r.error}}_&&e.stroke()},i.prototype._hit_point=function(e){for(var i=new a.Selection,t={x:e.sx,y:e.sy},n=9999,r=Math.max(2,this.visuals.line.line_width.value()/2),s=0,l=this.sx.length-1;s<l;s++){var o={x:this.sx[s],y:this.sy[s]},h={x:this.sx[s+1],y:this.sy[s+1]},u=_.dist_to_segment(t,o,h);u<r&&u<n&&(n=u,i.add_to_selected_glyphs(this.model),i.view=this,i.line_indices=[s])}return i},i.prototype._hit_span=function(e){var i,t,n=e.sx,r=e.sy,s=new a.Selection;"v"==e.direction?(i=this.renderer.yscale.invert(r),t=this._y):(i=this.renderer.xscale.invert(n),t=this._x);for(var l=0,o=t.length-1;l<o;l++)(t[l]<=i&&i<=t[l+1]||t[l+1]<=i&&i<=t[l])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(l));return s},i.prototype.get_interpolation_hit=function(e,i){var t=n.__read([this._x[e],this._y[e],this._x[e+1],this._y[e+1]],4),r=t[0],l=t[1],o=t[2],_=t[3];return s.line_interpolation(this.renderer,i,r,l,o,_)},i.prototype.draw_legend_for_index=function(e,i,t){s.generic_line_legend(this.visuals,e,i,t)},i}(r.XYGlyphView);t.LineView=h,h.__name__="LineView";var u=function(e){function i(i){return e.call(this,i)||this}return n.__extends(i,e),i.init_Line=function(){this.prototype.default_view=h,this.mixins(o.Line)},i}(r.XYGlyph);t.Line=u,u.__name__="Line",u.init_Line()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),_=t(152),r=n.__importStar(t(133)),o=t(209),p=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype._project_data=function(){_.inplace.project_xy(this._x,this._y)},i.prototype._index_data=function(t){for(var i=this.data_size,e=0;e<i;e++){var n=this._x[e],_=this._y[e];isNaN(n+_)||!isFinite(n+_)?t.add_empty():t.add(n,_,n,_)}},i.prototype.scenterxy=function(t){return[this.sx[t],this.sy[t]]},i}(o.GlyphView);e.XYGlyphView=p,p.__name__="XYGlyphView";var a=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_XYGlyph=function(){this.define({x:[r.XCoordinateSpec,{field:"x"}],y:[r.YCoordinateSpec,{field:"y"}]})},i}(o.Glyph);e.XYGlyph=a,a.__name__="XYGlyph",a.init_XYGlyph()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=r.__importStar(e(133)),a=r.__importStar(e(194)),o=r.__importStar(e(189)),s=e(186),_=e(196),l=e(134),d=e(139),p=e(127),c=e(210),h=e(213),u=e(203),y=function(e){function t(){var t=e.apply(this,r.__spread(arguments))||this;return t._index=null,t._data_size=null,t._nohit_warned=new Set,t}return r.__extends(t,e),Object.defineProperty(t.prototype,"renderer",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"has_webgl",{get:function(){return null!=this.glglyph},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"index",{get:function(){var e=this._index;if(null!=e)return e;throw new Error(this+".index_data() wasn't called")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"data_size",{get:function(){var e=this._data_size;if(null!=e)return e;throw new Error(this+".set_data() wasn't called")},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new o.Visuals(this.model)},t.prototype.set_visuals=function(e,t){this.visuals.warm_cache(e,t),null!=this.glglyph&&this.glglyph.set_visuals_changed()},t.prototype.render=function(e,t,n){e.beginPath(),null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(e,t,n),this.renderer.needs_webgl_blit)||this._render(e,t,n)},t.prototype.has_finished=function(){return!0},t.prototype.notify_finished=function(){this.renderer.notify_finished()},t.prototype._bounds=function(e){return e},t.prototype.bounds=function(){return this._bounds(this.index.bbox)},t.prototype.log_bounds=function(){var e=this.index.bounds(a.positive_x()),t=e.x0,n=e.x1,r=this.index.bounds(a.positive_y()),i=r.y0,o=r.y1;return this._bounds({x0:t,y0:i,x1:n,y1:o})},t.prototype.get_anchor_point=function(e,t,n){var i=r.__read(n,2),a=i[0],o=i[1];switch(e){case"center":var s=r.__read(this.scenterxy(t,a,o),2);return{x:s[0],y:s[1]};default:return null}},t.prototype.scenterx=function(e,t,n){return this.scenterxy(e,t,n)[0]},t.prototype.scentery=function(e,t,n){return this.scenterxy(e,t,n)[1]},t.prototype.sdist=function(e,t,n,r,i){var a,o;void 0===r&&(r="edge"),void 0===i&&(i=!1);var s=t.length;if("center"==r){var _=p.map(n,(function(e){return e/2}));a=new d.NumberArray(s);for(var l=0;l<s;l++)a[l]=t[l]-_[l];o=new d.NumberArray(s);for(l=0;l<s;l++)o[l]=t[l]+_[l]}else{a=t,o=new d.NumberArray(s);for(l=0;l<s;l++)o[l]=a[l]+n[l]}var c=e.v_compute(a),h=e.v_compute(o);return i?p.map(c,(function(e,t){return Math.ceil(Math.abs(h[t]-c[t]))})):p.map(c,(function(e,t){return Math.abs(h[t]-c[t])}))},t.prototype.draw_legend_for_index=function(e,t,n){},t.prototype.hit_test=function(e){switch(e.type){case"point":if(null!=this._hit_point)return this._hit_point(e);break;case"span":if(null!=this._hit_span)return this._hit_span(e);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(e);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(e)}return this._nohit_warned.has(e.type)||(l.logger.debug("'"+e.type+"' selection not available for "+this.model.type),this._nohit_warned.add(e.type)),null},t.prototype._hit_rect_against_index=function(e){var t=e.sx0,n=e.sx1,i=e.sy0,a=e.sy1,o=r.__read(this.renderer.coordinates.x_scale.r_invert(t,n),2),s=o[0],_=o[1],l=r.__read(this.renderer.coordinates.y_scale.r_invert(i,a),2),d=l[0],p=l[1],c=r.__spread(this.index.indices({x0:s,x1:_,y0:d,y1:p}));return new u.Selection({indices:c})},t.prototype._project_data=function(){},t.prototype.set_data=function(e,t,n){var a,o,s,_,l=this.renderer.coordinates,c=l.x_range,u=l.y_range;this._data_size=null!==(s=e.get_length())&&void 0!==s?s:1;try{for(var y=r.__values(this.model),f=y.next();!f.done;f=y.next()){var g=f.value;if(g instanceof i.VectorSpec&&(!g.optional||null!=g.spec.value||g.dirty)){var v=g.attr,x=g.array(e),b=t.select(x);if(g instanceof i.BaseCoordinateSpec){var m="x"==g.dimension?c:u;if(m instanceof h.FactorRange)if(g instanceof i.CoordinateSpec)b=m.v_synthetic(b);else if(g instanceof i.CoordinateSeqSpec)for(var w=0;w<b.length;w++)b[w]=m.v_synthetic(b[w]);g instanceof i.CoordinateSeqSpec&&(b=d.RaggedArray.from(b))}else g instanceof i.DistanceSpec&&(this["max_"+v]=p.max(b));this["_"+v]=b}}}catch(e){a={error:e}}finally{try{f&&!f.done&&(o=y.return)&&o.call(y)}finally{if(a)throw a.error}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(n),null===(_=this.glglyph)||void 0===_||_.set_data_changed(),this.index_data()},t.prototype._set_data=function(e){},Object.defineProperty(t.prototype,"_index_size",{get:function(){return this.data_size},enumerable:!0,configurable:!0}),t.prototype.index_data=function(){var e=new c.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e},t.prototype.mask_data=function(){return null!=this.glglyph||null==this._mask_data?d.Indices.all_set(this.data_size):this._mask_data()},t.prototype.map_data=function(){var e,t,n,a=this.renderer.coordinates,o=a.x_scale,s=a.y_scale;try{for(var _=r.__values(this.model),l=_.next();!l.done;l=_.next()){var p=l.value;if(p instanceof i.BaseCoordinateSpec){var c="x"==p.dimension?o:s,h=this["_"+p.attr];if(h instanceof d.RaggedArray){var u=c.v_compute(h.array);h=new d.RaggedArray(h.offsets,u)}else h=c.v_compute(h);this["s"+p.attr]=h}}}catch(t){e={error:t}}finally{try{l&&!l.done&&(t=_.return)&&t.call(_)}finally{if(e)throw e.error}}this._map_data(),null===(n=this.glglyph)||void 0===n||n.set_data_changed()},t.prototype._map_data=function(){},t}(s.View);n.GlyphView=y,y.__name__="GlyphView";var f=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Glyph=function(){},t}(_.Model);n.Glyph=f,f.__name__="Glyph",f.init_Glyph()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),r=i.__importDefault(e(211)),o=e(139),s=e(194);function a(e,n){for(var t=0,i=n.length-1;t<i;){var r=t+i>>1;n[r]>e?i=r:t=r+1}return n[t]}var u=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(n,e),n.prototype.search_indices=function(e,n,t,i){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var r=this._boxes.length-4,s=[],u=new o.Indices(this.numItems);void 0!==r;){for(var d=Math.min(r+4*this.nodeSize,a(r,this._levelBounds)),l=r;l<d;l+=4){var h=0|this._indices[l>>2];t<this._boxes[l+0]||(i<this._boxes[l+1]||e>this._boxes[l+2]||n>this._boxes[l+3]||(r<4*this.numItems?u.set(h):s.push(h)))}r=s.pop()}return u},n}(r.default);u.__name__="_FlatBush";var d=function(){function e(e){this.index=null,e>0&&(this.index=new u(e))}return e.prototype.add=function(e,n,t,i){var r;null===(r=this.index)||void 0===r||r.add(e,n,t,i)},e.prototype.add_empty=function(){var e;null===(e=this.index)||void 0===e||e.add(1/0,1/0,-1/0,-1/0)},e.prototype.finish=function(){var e;null===(e=this.index)||void 0===e||e.finish()},e.prototype._normalize=function(e){var n,t,r=e.x0,o=e.y0,s=e.x1,a=e.y1;return r>s&&(r=(n=i.__read([s,r],2))[0],s=n[1]),o>a&&(o=(t=i.__read([a,o],2))[0],a=t[1]),{x0:r,y0:o,x1:s,y1:a}},Object.defineProperty(e.prototype,"bbox",{get:function(){if(null==this.index)return s.empty();var e=this.index;return{x0:e.minX,y0:e.minY,x1:e.maxX,y1:e.maxY}},enumerable:!0,configurable:!0}),e.prototype.indices=function(e){if(null==this.index)return new o.Indices(0);var n=this._normalize(e),t=n.x0,i=n.y0,r=n.x1,s=n.y1;return this.index.search_indices(t,i,r,s)},e.prototype.bounds=function(e){var n,t,r=s.empty();try{for(var o=i.__values(this.indices(e)),a=o.next();!a.done;a=o.next()){var u=a.value,d=this.index._boxes,l=d[4*u+0],h=d[4*u+1],x=d[4*u+2],_=d[4*u+3];x<r.x0&&(r.x0=x),l>r.x1&&(r.x1=l),_<r.y0&&(r.y0=_),h>r.y1&&(r.y1=h)}}catch(e){n={error:e}}finally{try{a&&!a.done&&(t=o.return)&&t.call(o)}finally{if(n)throw n.error}}return r},e}();t.SpatialIndex=d,d.__name__="SpatialIndex"},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});var e=t(1),r=e.__importDefault(t(212)),h=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],o=function(){function t(t,i,s,e){if(void 0===i&&(i=16),void 0===s&&(s=Float64Array),void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error("Unpexpected numItems value: "+t+".");this.numItems=+t,this.nodeSize=Math.min(Math.max(+i,2),65535);var o=t,n=o;this._levelBounds=[4*o];do{n+=o=Math.ceil(o/this.nodeSize),this._levelBounds.push(4*n)}while(1!==o);this.ArrayType=s||Float64Array,this.IndexArrayType=n<16384?Uint16Array:Uint32Array;var a=h.indexOf(this.ArrayType),_=4*n*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error("Unexpected typed array class: "+s+".");e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*n),this._indices=new this.IndexArrayType(this.data,8+_,n),this._pos=4*n,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+n*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*n),this._indices=new this.IndexArrayType(this.data,8+_,n),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=i,new Uint32Array(this.data,4,1)[0]=t),this._queue=new r.default}return t.from=function(i){if(!(i instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var s=e.__read(new Uint8Array(i,0,2),2),r=s[0],o=s[1];if(251!==r)throw new Error("Data does not appear to be in a Flatbush format.");if(o>>4!=3)throw new Error("Got v"+(o>>4)+" data when expected v3.");var n=e.__read(new Uint16Array(i,2,1),1)[0];return new t(e.__read(new Uint32Array(i,4,1),1)[0],n,h[15&o],i)},t.prototype.add=function(t,i,s,e){var r=this._pos>>2;return this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=i,this._boxes[this._pos++]=s,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),i<this.minY&&(this.minY=i),s>this.maxX&&(this.maxX=s),e>this.maxY&&(this.maxY=e),r},t.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);for(var t=this.maxX-this.minX,i=this.maxY-this.minY,s=new Uint32Array(this.numItems),e=0;e<this.numItems;e++){var r=4*e,h=this._boxes[r++],o=this._boxes[r++],n=this._boxes[r++],a=this._boxes[r++],u=Math.floor(65535*((h+n)/2-this.minX)/t),x=Math.floor(65535*((o+a)/2-this.minY)/i);s[e]=d(u,x)}!function t(i,s,e,r,h,o){if(Math.floor(r/o)>=Math.floor(h/o))return;var n=i[r+h>>1],a=r-1,d=h+1;for(;;){do{a++}while(i[a]<n);do{d--}while(i[d]>n);if(a>=d)break;_(i,s,e,a,d)}t(i,s,e,r,d,o),t(i,s,e,d+1,h,o)}(s,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(e=0,r=0;e<this._levelBounds.length-1;e++)for(var p=this._levelBounds[e];r<p;){for(var f=r,m=1/0,y=1/0,l=-1/0,b=-1/0,v=0;v<this.nodeSize&&r<p;v++)m=Math.min(m,this._boxes[r++]),y=Math.min(y,this._boxes[r++]),l=Math.max(l,this._boxes[r++]),b=Math.max(b,this._boxes[r++]);this._indices[this._pos>>2]=f,this._boxes[this._pos++]=m,this._boxes[this._pos++]=y,this._boxes[this._pos++]=l,this._boxes[this._pos++]=b}},t.prototype.search=function(t,i,s,e,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=[],n=[];void 0!==h;){for(var _=Math.min(h+4*this.nodeSize,a(h,this._levelBounds)),d=h;d<_;d+=4){var u=0|this._indices[d>>2];s<this._boxes[d]||(e<this._boxes[d+1]||t>this._boxes[d+2]||i>this._boxes[d+3]||(h<4*this.numItems?(void 0===r||r(u))&&n.push(u):o.push(u)))}h=o.pop()}return n},t.prototype.neighbors=function(t,i,s,e,r){if(void 0===s&&(s=1/0),void 0===e&&(e=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=this._queue,_=[],d=e*e;void 0!==h;){for(var u=Math.min(h+4*this.nodeSize,a(h,this._levelBounds)),x=h;x<u;x+=4){var p=0|this._indices[x>>2],f=n(t,this._boxes[x],this._boxes[x+2]),m=n(i,this._boxes[x+1],this._boxes[x+3]),y=f*f+m*m;h<4*this.numItems?(void 0===r||r(p))&&o.push(-p-1,y):o.push(p,y)}for(;o.length&&o.peek()<0;){if((y=o.peekValue())>d)return o.clear(),_;if(_.push(-o.pop()-1),_.length===s)return o.clear(),_}h=o.pop()}return o.clear(),_},t}();function n(t,i,s){return t<i?i-t:t<=s?0:t-s}function a(t,i){for(var s=0,e=i.length-1;s<e;){var r=s+e>>1;i[r]>t?e=r:s=r+1}return i[s]}function _(t,i,s,e,r){var h=t[e];t[e]=t[r],t[r]=h;var o=4*e,n=4*r,a=i[o],_=i[o+1],d=i[o+2],u=i[o+3];i[o]=i[n],i[o+1]=i[n+1],i[o+2]=i[n+2],i[o+3]=i[n+3],i[n]=a,i[n+1]=_,i[n+2]=d,i[n+3]=u;var x=s[e];s[e]=s[r],s[r]=x}function d(t,i){var s=t^i,e=65535^s,r=65535^(t|i),h=t&(65535^i),o=s|e>>1,n=s>>1^s,a=r>>1^e&h>>1^r,_=s&r>>1^h>>1^h;n=(s=o)&(e=n)>>2^e&(s^e)>>2,a^=s&(r=a)>>2^e&(h=_)>>2,_^=e&r>>2^(s^e)&h>>2,n=(s=o=s&s>>2^e&e>>2)&(e=n)>>4^e&(s^e)>>4,a^=s&(r=a)>>4^e&(h=_)>>4,_^=e&r>>4^(s^e)&h>>4,a^=(s=o=s&s>>4^e&e>>4)&(r=a)>>8^(e=n)&(h=_)>>8;var d=t^i,u=(e=(_^=e&r>>8^(s^e)&h>>8)^_>>1)|65535^(d|(s=a^a>>1));return((u=1431655765&((u=858993459&((u=252645135&((u=16711935&(u|u<<8))|u<<4))|u<<2))|u<<1))<<1|(d=1431655765&((d=858993459&((d=252645135&((d=16711935&(d|d<<8))|d<<4))|d<<2))|d<<1)))>>>0}s.default=o},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});var h=function(){function t(){this.ids=[],this.values=[],this.length=0}return t.prototype.clear=function(){this.length=0},t.prototype.push=function(t,i){var s=this.length++;for(this.ids[s]=t,this.values[s]=i;s>0;){var h=s-1>>1,e=this.values[h];if(i>=e)break;this.ids[s]=this.ids[h],this.values[s]=e,s=h}this.ids[s]=t,this.values[s]=i},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var i=this.ids[0]=this.ids[this.length],s=this.values[0]=this.values[this.length],h=this.length>>1,e=0;e<h;){var n=1+(e<<1),l=n+1,u=this.ids[n],r=this.values[n],a=this.values[l];if(l<this.length&&a<r&&(n=l,u=this.ids[l],r=a),r>=s)break;this.ids[e]=u,this.values[e]=r,e=n}this.ids[e]=i,this.values[e]=s}return t}},t.prototype.peek=function(){if(0!==this.length)return this.ids[0]},t.prototype.peekValue=function(){if(0!==this.length)return this.values[0]},t}();s.default=h},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=r(1),a=r(214),i=n.__importStar(r(133)),o=r(139),s=r(124),u=r(123),l=r(126);function p(r,e,t){void 0===t&&(t=0);for(var n=new Map,a=0;a<r.length;a++){var i=r[a];if(n.has(i))throw new Error("duplicate factor or subfactor: "+i);n.set(i,{value:.5+a*(1+e)+t})}return[n,(r.length-1)*e]}function c(r,e,t,a){var i,o,u,l,c;void 0===a&&(a=0);var d=new Map,_=new Map;try{for(var g=n.__values(r),f=g.next();!f.done;f=g.next()){var v=n.__read(f.value,2),h=v[0],y=v[1],m=null!==(c=_.get(h))&&void 0!==c?c:[];_.set(h,n.__spread(m,[y]))}}catch(r){i={error:r}}finally{try{f&&!f.done&&(o=g.return)&&o.call(g)}finally{if(i)throw i.error}}var b=a,w=0,N=function(r,a){var i=a.length,o=n.__read(p(a,t,b),2),u=o[0],l=o[1];w+=l;var c=s.sum(a.map((function(r){return u.get(r).value})));d.set(r,{value:c/i,mapping:u}),b+=i+e+l};try{for(var x=n.__values(_),S=x.next();!S.done;S=x.next()){var k=n.__read(S.value,2);N(h=k[0],m=k[1])}}catch(r){u={error:r}}finally{try{S&&!S.done&&(l=x.return)&&l.call(x)}finally{if(u)throw u.error}}return[d,(_.size-1)*e+w]}function d(r,e,t,a,i){var o,u,l,p,d;void 0===i&&(i=0);var _=new Map,g=new Map;try{for(var f=n.__values(r),v=f.next();!v.done;v=f.next()){var h=n.__read(v.value,3),y=h[0],m=h[1],b=h[2],w=null!==(d=g.get(y))&&void 0!==d?d:[];g.set(y,n.__spread(w,[[m,b]]))}}catch(r){o={error:r}}finally{try{v&&!v.done&&(u=f.return)&&u.call(f)}finally{if(o)throw o.error}}var N=i,x=0,S=function(r,i){var o=i.length,u=n.__read(c(i,t,a,N),2),l=u[0],p=u[1];x+=p;var d=s.sum(i.map((function(r){var e=n.__read(r,1)[0];return l.get(e).value})));_.set(r,{value:d/o,mapping:l}),N+=o+e+p};try{for(var k=n.__values(g),A=k.next();!A.done;A=k.next()){var M=n.__read(A.value,2);S(y=M[0],w=M[1])}}catch(r){l={error:r}}finally{try{A&&!A.done&&(p=k.return)&&p.call(k)}finally{if(l)throw l.error}}return[_,(g.size-1)*e+x]}t.map_one_level=p,t.map_two_levels=c,t.map_three_levels=d;var _=function(r){function e(e){return r.call(this,e)||this}return n.__extends(e,r),e.init_FactorRange=function(){this.define({factors:[i.Array,[]],factor_padding:[i.Number,0],subgroup_padding:[i.Number,.8],group_padding:[i.Number,1.4],range_padding:[i.Number,0],range_padding_units:[i.PaddingUnits,"percent"],start:[i.Number],end:[i.Number]}),this.internal({levels:[i.Number],mids:[i.Array,null],tops:[i.Array,null]})},Object.defineProperty(e.prototype,"min",{get:function(){return this.start},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this.end},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){r.prototype.initialize.call(this),this._init(!0)},e.prototype.connect_signals=function(){var e=this;r.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,(function(){return e.reset()})),this.connect(this.properties.factor_padding.change,(function(){return e.reset()})),this.connect(this.properties.group_padding.change,(function(){return e.reset()})),this.connect(this.properties.subgroup_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding_units.change,(function(){return e.reset()}))},e.prototype.reset=function(){this._init(!1),this.change.emit()},e.prototype._lookup=function(r){switch(r.length){case 1:var e=n.__read(r,1)[0];return null!=(i=this._mapping.get(e))?i.value:NaN;case 2:var t=n.__read(r,2),a=(e=t[0],t[1]);if(null!=(i=this._mapping.get(e)))if(null!=(o=i.mapping.get(a)))return o.value;return NaN;case 3:var i,o,s=n.__read(r,3),u=(e=s[0],a=s[1],s[2]);if(null!=(i=this._mapping.get(e)))if(null!=(o=i.mapping.get(a))){var p=o.mapping.get(u);if(null!=p)return p.value}return NaN;default:l.unreachable()}},e.prototype.synthetic=function(r){if(u.isNumber(r))return r;if(u.isString(r))return this._lookup([r]);var e=0,t=r[r.length-1];return u.isNumber(t)&&(e=t,r=r.slice(0,-1)),this._lookup(r)+e},e.prototype.v_synthetic=function(r){for(var e=r.length,t=new o.NumberArray(e),n=0;n<e;n++)t[n]=this.synthetic(r[n]);return t},e.prototype._init=function(r){var e=this,t=function(){var r,t,a,i;if(s.every(e.factors,u.isString)){var o=e.factors,_=n.__read(p(o,e.factor_padding),2);return{levels:1,mapping:_[0],tops:null,mids:null,inside_padding:_[1]}}if(s.every(e.factors,(function(r){return u.isArray(r)&&2==r.length&&u.isString(r[0])&&u.isString(r[1])}))){o=e.factors;var g=n.__read(c(o,e.group_padding,e.factor_padding),2),f=g[0],v=g[1],h=n.__spread(f.keys());return{levels:2,mapping:f,tops:h,mids:null,inside_padding:v}}if(s.every(e.factors,(function(r){return u.isArray(r)&&3==r.length&&u.isString(r[0])&&u.isString(r[1])&&u.isString(r[2])}))){o=e.factors;var y=n.__read(d(o,e.group_padding,e.subgroup_padding,e.factor_padding),2),m=y[0],b=y[1],w=n.__spread(m.keys()),N=[];try{for(var x=n.__values(m),S=x.next();!S.done;S=x.next()){var k=n.__read(S.value,2),A=k[0],M=k[1];try{for(var R=(a=void 0,n.__values(M.mapping.keys())),z=R.next();!z.done;z=R.next()){var F=z.value;N.push([A,F])}}catch(r){a={error:r}}finally{try{z&&!z.done&&(i=R.return)&&i.call(R)}finally{if(a)throw a.error}}}}catch(e){r={error:e}}finally{try{S&&!S.done&&(t=x.return)&&t.call(x)}finally{if(r)throw r.error}}return{levels:3,mapping:m,tops:w,mids:N,inside_padding:b}}l.unreachable()}(),a=t.levels,i=t.mapping,o=t.tops,_=t.mids,g=t.inside_padding;this._mapping=i,this.tops=o,this.mids=_;var f=0,v=this.factors.length+g;if("percent"==this.range_padding_units){var h=(v-f)*this.range_padding/2;f-=h,v+=h}else f-=this.range_padding,v+=this.range_padding;this.setv({start:f,end:v,levels:a},{silent:r}),"auto"==this.bounds&&this.setv({bounds:[f,v]},{silent:!0})},e}(a.Range);t.FactorRange=_,_.__name__="FactorRange",_.init_FactorRange()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),r=e(196),a=i.__importStar(e(133)),o=function(e){function n(n){var t=e.call(this,n)||this;return t.have_updated_interactively=!1,t}return i.__extends(n,e),n.init_Range=function(){this.define({bounds:[a.Any],min_interval:[a.Any],max_interval:[a.Any]}),this.internal({plots:[a.Array,[]]})},Object.defineProperty(n.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"is_valid",{get:function(){return!isNaN(this.min)&&!isNaN(this.max)},enumerable:!0,configurable:!0}),n}(r.Model);t.Range=o,o.__name__="Range",o.init_Range()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),n=r.__importStar(e(216));i.generic_line_legend=function(e,t,i,r){var n=i.x0,a=i.x1,_=i.y0,l=i.y1;t.save(),t.beginPath(),t.moveTo(n,(_+l)/2),t.lineTo(a,(_+l)/2),e.line.doit&&(e.line.set_vectorize(t,r),t.stroke()),t.restore()},i.generic_area_legend=function(e,t,i,r){var n=i.x0,a=i.x1,_=i.y0,l=i.y1,c=.1*Math.abs(a-n),o=.1*Math.abs(l-_),s=n+c,v=a-c,d=_+o,h=l-o;e.fill.doit&&(e.fill.set_vectorize(t,r),t.fillRect(s,d,v-s,h-d)),null!=e.hatch&&e.hatch.doit&&(e.hatch.set_vectorize(t,r),t.fillRect(s,d,v-s,h-d)),e.line&&e.line.doit&&(t.beginPath(),t.rect(s,d,v-s,h-d),e.line.set_vectorize(t,r),t.stroke())},i.line_interpolation=function(e,t,i,a,_,l){var c,o,s,v,d,h,x,y,f,u,g=t.sx,m=t.sy;"point"==t.type?(f=(c=r.__read(e.yscale.r_invert(m-1,m+1),2))[0],u=c[1],x=(o=r.__read(e.xscale.r_invert(g-1,g+1),2))[0],y=o[1]):"v"==t.direction?(f=(s=r.__read(e.yscale.r_invert(m,m),2))[0],u=s[1],x=(v=r.__read([Math.min(i-1,_-1),Math.max(i+1,_+1)],2))[0],y=v[1]):(x=(d=r.__read(e.xscale.r_invert(g,g),2))[0],y=d[1],f=(h=r.__read([Math.min(a-1,l-1),Math.max(a+1,l+1)],2))[0],u=h[1]);var M=n.check_2_segments_intersect(x,f,y,u,i,a,_,l);return[M.x,M.y]}},
function _(t,n,e){function r(t,n){return Math.pow(t.x-n.x,2)+Math.pow(t.y-n.y,2)}function o(t,n,e){var o=r(n,e);if(0==o)return r(t,n);var a=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/o;return r(t,a<0?n:a>1?e:{x:n.x+a*(e.x-n.x),y:n.y+a*(e.y-n.y)})}Object.defineProperty(e,"__esModule",{value:!0}),e.point_in_poly=function(t,n,e,r){for(var o=!1,a=e[e.length-1],i=r[r.length-1],h=0;h<e.length;h++){var u=e[h],s=r[h];i<n!=s<n&&a+(n-i)/(s-i)*(u-a)<t&&(o=!o),a=u,i=s}return o},e.point_in_ellipse=function(t,n,e,r,o,a,i){var h=Math.pow(Math.cos(e)/o,2)+Math.pow(Math.sin(e)/r,2),u=2*Math.cos(e)*Math.sin(e)*(Math.pow(1/o,2)-Math.pow(1/r,2)),s=Math.pow(Math.cos(e)/r,2)+Math.pow(Math.sin(e)/o,2);return h*Math.pow(t-a,2)+u*(t-a)*(n-i)+s*Math.pow(n-i,2)<=1},e.dist_2_pts=r,e.dist_to_segment_squared=o,e.dist_to_segment=function(t,n,e){return Math.sqrt(o(t,n,e))},e.check_2_segments_intersect=function(t,n,e,r,o,a,i,h){var u=(h-a)*(e-t)-(i-o)*(r-n);if(0==u)return{hit:!1,x:null,y:null};var s=n-a,M=t-o,_=(i-o)*s-(h-a)*M;return M=((e-t)*s-(r-n)*M)/u,{hit:(s=_/u)>0&&s<1&&M>0&&M<1,x:t+s*(e-t),y:n+s*(r-n)}}},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var i=t(1),a=t(218),r=t(222),n=t(223),o=t(224),_=t(137),h=function(){function t(t){this._atlas=new Map,this._width=256,this._height=256,this.tex=new a.Texture2d(t),this.tex.set_wrapping(t.REPEAT,t.REPEAT),this.tex.set_interpolation(t.NEAREST,t.NEAREST),this.tex.set_size([this._width,this._height],t.RGBA),this.tex.set_data([0,0],[this._width,this._height],new Uint8Array(4*this._width*this._height)),this.get_atlas_data([1])}return t.prototype.get_atlas_data=function(t){var e=t.join("-"),s=this._atlas.get(e);if(null==s){var a=i.__read(this.make_pattern(t),2),r=a[0],n=a[1],o=this._atlas.size;this.tex.set_data([0,o],[this._width,1],new Uint8Array(r.map((function(t){return t+10})))),s=[o/this._height,n],this._atlas.set(e,s)}return s},t.prototype.make_pattern=function(t){var e,s;t.length>1&&t.length%2&&(t=t.concat(t));var a=0;try{for(var r=i.__values(t),n=r.next();!n.done;n=r.next()){a+=n.value}}catch(t){e={error:t}}finally{try{n&&!n.done&&(s=r.return)&&s.call(r)}finally{if(e)throw e.error}}for(var o=[],_=0,h=0,l=t.length+2;h<l;h+=2){var g=Math.max(1e-4,t[h%t.length]),u=Math.max(1e-4,t[(h+1)%t.length]);o.push(_,_+g),_+=g+u}var f=this._width,v=new Float32Array(4*f);for(h=0,l=f;h<l;h++){for(var p=void 0,d=void 0,c=void 0,b=a*h/(f-1),y=0,w=1e16,m=0,x=o.length;m<x;m++){var A=Math.abs(o[m]-b);A<w&&(y=m,w=A)}y%2==0?(c=b<=o[y]?1:0,d=o[y],p=o[y+1]):(c=b>o[y]?-1:0,d=o[y-1],p=o[y]),v[4*h+0]=o[y],v[4*h+1]=c,v[4*h+2]=d,v[4*h+3]=p}return[v,a]},t}();h.__name__="DashAtlas";var l={miter:0,round:1,bevel:2},g={"":0,none:0,".":0,round:1,")":1,"(":1,o:1,"triangle in":2,"<":2,"triangle out":3,">":3,square:4,"[":4,"]":4,"=":4,butt:5,"|":5},u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.init=function(){var t=this.gl;this._scale_aspect=0;var e=n.vertex_shader,s=o.fragment_shader;this.prog=new a.Program(t),this.prog.set_shaders(e,s),this.index_buffer=new a.IndexBuffer(t),this.vbo_position=new a.VertexBuffer(t),this.vbo_tangents=new a.VertexBuffer(t),this.vbo_segment=new a.VertexBuffer(t),this.vbo_angles=new a.VertexBuffer(t),this.vbo_texcoord=new a.VertexBuffer(t),this.dash_atlas=new h(t)},e.prototype.draw=function(t,e,s){var i=e.glglyph;if(i.data_changed&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),i._update_scale(1,1),this._scale_aspect=1,this.prog.set_attribute("a_position","vec2",i.vbo_position),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents),this.prog.set_attribute("a_segment","vec2",i.vbo_segment),this.prog.set_attribute("a_angles","vec2",i.vbo_angles),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord),this.prog.set_uniform("u_length","float",[i.cumsum]),this.prog.set_texture("u_dash_atlas",this.dash_atlas.tex),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_uniform("u_scale_aspect","vec2",[1,1]),this.prog.set_uniform("u_scale_length","float",[Math.sqrt(2)]),this.I_triangles=i.I_triangles,this.I_triangles.length<65535)this.index_buffer.set_size(2*this.I_triangles.length),this.index_buffer.set_data(0,new Uint16Array(this.I_triangles)),this.prog.draw(this.gl.TRIANGLES,this.index_buffer);else{t=Array.from(this.I_triangles);for(var a=this.I_triangles.length,r=[],n=0,o=Math.ceil(a/64008);n<o;n++)r.push([]);for(n=0,o=t.length;n<o;n++){var _=t[n]%64008;r[h=Math.floor(t[n]/64008)].push(_)}var h=0;for(o=r.length;h<o;h++){var l=new Uint16Array(r[h]),g=64008*h*4;0!==l.length&&(this.prog.set_attribute("a_position","vec2",i.vbo_position,0,2*g),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents,0,4*g),this.prog.set_attribute("a_segment","vec2",i.vbo_segment,0,2*g),this.prog.set_attribute("a_angles","vec2",i.vbo_angles,0,2*g),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord,0,2*g),this.index_buffer.set_size(2*l.length),this.index_buffer.set_data(0,l),this.prog.draw(this.gl.TRIANGLES,this.index_buffer))}}},e.prototype._set_data=function(){this._bake(),this.vbo_position.set_size(4*this.V_position.length),this.vbo_position.set_data(0,this.V_position),this.vbo_tangents.set_size(4*this.V_tangents.length),this.vbo_tangents.set_data(0,this.V_tangents),this.vbo_angles.set_size(4*this.V_angles.length),this.vbo_angles.set_data(0,this.V_angles),this.vbo_texcoord.set_size(4*this.V_texcoord.length),this.vbo_texcoord.set_data(0,this.V_texcoord)},e.prototype._set_visuals=function(){var t,e=_.color2rgba(this.glyph.visuals.line.line_color.value(),this.glyph.visuals.line.line_alpha.value()),s=g[this.glyph.visuals.line.line_cap.value()],a=l[this.glyph.visuals.line.line_join.value()];this.prog.set_uniform("u_color","vec4",e),this.prog.set_uniform("u_linewidth","float",[this.glyph.visuals.line.line_width.value()]),this.prog.set_uniform("u_antialias","float",[.9]),this.prog.set_uniform("u_linecaps","vec2",[s,s]),this.prog.set_uniform("u_linejoin","float",[a]),this.prog.set_uniform("u_miter_limit","float",[10]);var r=this.glyph.visuals.line.line_dash.value(),n=0,o=1;r.length&&(n=(t=i.__read(this.dash_atlas.get_atlas_data(r),2))[0],o=t[1]),this.prog.set_uniform("u_dash_index","float",[n]),this.prog.set_uniform("u_dash_phase","float",[this.glyph.visuals.line.line_dash_offset.value()]),this.prog.set_uniform("u_dash_period","float",[o]),this.prog.set_uniform("u_dash_caps","vec2",[s,s]),this.prog.set_uniform("u_closed","float",[0])},e.prototype._bake=function(){for(var t,e,s,i,a,r,n,o,_=this.nvertices,h=this.glyph.sx,l=this.glyph.sy,g=n=new Float32Array(2*_),u=new Float32Array(2*_),f=o=new Float32Array(4*_),v=0,p=_;v<p;v++)g[2*v+0]=h[v],g[2*v+1]=l[v];this.tangents=e=new Float32Array(2*_-2);for(v=0,p=_-1;v<p;v++)e[2*v+0]=n[2*(v+1)+0]-n[2*v+0],e[2*v+1]=n[2*(v+1)+1]-n[2*v+1];for(v=0,p=_-1;v<p;v++)f[4*(v+1)+0]=e[2*v+0],f[4*(v+1)+1]=e[2*v+1],f[4*v+2]=e[2*v+0],f[4*v+3]=e[2*v+1];f[0]=e[0],f[1]=e[1],f[4*(_-1)+2]=e[2*(_-2)+0],f[4*(_-1)+3]=e[2*(_-2)+1];var d=new Float32Array(_);for(v=0,p=_;v<p;v++)d[v]=Math.atan2(o[4*v+0]*o[4*v+3]-o[4*v+1]*o[4*v+2],o[4*v+0]*o[4*v+2]+o[4*v+1]*o[4*v+3]);for(v=0,p=_-1;v<p;v++)u[2*v+0]=d[v],u[2*v+1]=d[v+1];var c=4*_-4;this.V_position=i=new Float32Array(2*c),this.V_angles=s=new Float32Array(2*c),this.V_tangents=a=new Float32Array(4*c),this.V_texcoord=r=new Float32Array(2*c);for(v=0,p=_;v<p;v++)for(var b=0;b<4;b++){for(var y=0;y<2;y++)i[2*(4*v+b-2)+y]=g[2*v+y],s[2*(4*v+b)+y]=u[2*v+y];for(y=0;y<4;y++)a[4*(4*v+b-2)+y]=f[4*v+y]}for(v=0,p=_;v<p;v++)r[2*(4*v+0)+0]=-1,r[2*(4*v+1)+0]=-1,r[2*(4*v+2)+0]=1,r[2*(4*v+3)+0]=1,r[2*(4*v+0)+1]=-1,r[2*(4*v+1)+1]=1,r[2*(4*v+2)+1]=-1,r[2*(4*v+3)+1]=1;var w=6*(_-1);this.I_triangles=t=new Uint32Array(w);for(v=0,p=_;v<p;v++)t[6*v+0]=0+4*v,t[6*v+1]=1+4*v,t[6*v+2]=3+4*v,t[6*v+3]=2+4*v,t[6*v+4]=0+4*v,t[6*v+5]=3+4*v},e.prototype._update_scale=function(t,e){var s,i=this.nvertices,a=4*i-4,r=this.tangents,n=new Float32Array(i-1),o=new Float32Array(2*i);this.V_segment=s=new Float32Array(2*a);for(var _=0,h=i-1;_<h;_++)n[_]=Math.sqrt(Math.pow(r[2*_+0]*t,2)+Math.pow(r[2*_+1]*e,2));var l=0;for(_=0,h=i-1;_<h;_++)l+=n[_],o[2*(_+1)+0]=l,o[2*_+1]=l;for(_=0,h=i;_<h;_++)for(var g=0;g<4;g++)for(var u=0;u<2;u++)s[2*(4*_+g)+u]=o[2*_+u];this.cumsum=l,this.vbo_segment.set_size(4*this.V_segment.length),this.vbo_segment.set_data(0,this.V_segment)},e}(r.BaseGLGlyph);s.LineGL=u,u.__name__="LineGL"},
function _(e,r,f){Object.defineProperty(f,"__esModule",{value:!0});var u=e(219);f.Program=u.Program;var t=e(221);f.Texture2d=t.Texture2d;var a=e(220);f.IndexBuffer=a.IndexBuffer,f.VertexBuffer=a.VertexBuffer},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var a=t(1),i=t(220),n=function(){function t(t){this.gl=t,this.UTYPEMAP={float:"uniform1fv",vec2:"uniform2fv",vec3:"uniform3fv",vec4:"uniform4fv",int:"uniform1iv",ivec2:"uniform2iv",ivec3:"uniform3iv",ivec4:"uniform4iv",bool:"uniform1iv",bvec2:"uniform2iv",bvec3:"uniform3iv",bvec4:"uniform4iv",mat2:"uniformMatrix2fv",mat3:"uniformMatrix3fv",mat4:"uniformMatrix4fv",sampler1D:"uniform1i",sampler2D:"uniform1i",sampler3D:"uniform1i"},this.ATYPEMAP={float:"vertexAttrib1f",vec2:"vertexAttrib2f",vec3:"vertexAttrib3f",vec4:"vertexAttrib4f"},this.ATYPEINFO={float:[1,5126],vec2:[2,5126],vec3:[3,5126],vec4:[4,5126]},this._linked=!1,this._validated=!1,this._unset_variables=new Set,this._known_invalid=new Set,this._locations=new Map,this._samplers=new Map,this._attributes=new Map,this.handle=this.gl.createProgram()}return t.prototype.delete=function(){this.gl.deleteProgram(this.handle)},t.prototype.activate=function(){this.gl.useProgram(this.handle)},t.prototype.deactivate=function(){this.gl.useProgram(0)},t.prototype.set_shaders=function(t,e){var r,i,n=this.gl;this._linked=!1;var s=n.createShader(n.VERTEX_SHADER),o=n.createShader(n.FRAGMENT_SHADER),l=[[t,s,"vertex"],[e,o,"fragment"]];try{for(var h=a.__values(l),_=h.next();!_.done;_=h.next()){var v=a.__read(_.value,3),d=v[0],f=v[1],u=v[2];if(n.shaderSource(f,d),n.compileShader(f),!n.getShaderParameter(f,n.COMPILE_STATUS)){var c=n.getShaderInfoLog(f);throw new Error("errors in "+u+" shader:\n"+c)}}}catch(t){r={error:t}}finally{try{_&&!_.done&&(i=h.return)&&i.call(h)}finally{if(r)throw r.error}}if(n.attachShader(this.handle,s),n.attachShader(this.handle,o),n.linkProgram(this.handle),!n.getProgramParameter(this.handle,n.LINK_STATUS)){var g=n.getProgramInfoLog(this.handle);throw new Error("Program link error:\n"+g)}this._unset_variables=this._get_active_attributes_and_uniforms(),n.detachShader(this.handle,s),n.detachShader(this.handle,o),n.deleteShader(s),n.deleteShader(o),this._known_invalid.clear(),this._linked=!0},t.prototype._get_active_attributes_and_uniforms=function(){var t,e,r,i,n,s,o=this.gl;this._locations.clear();var l=new RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*"),h=o.getProgramParameter(this.handle,o.ACTIVE_UNIFORMS),_=[],v=[],d=[[_,o.getProgramParameter(this.handle,o.ACTIVE_ATTRIBUTES),o.getActiveAttrib,o.getAttribLocation],[v,h,o.getActiveUniform,o.getUniformLocation]];try{for(var f=a.__values(d),u=f.next();!u.done;u=f.next())for(var c=a.__read(u.value,4),g=c[0],m=c[1],p=c[2],b=c[3],w=0;w<m;w+=1){var y=p.call(o,this.handle,w),A=(k=y.name).match(l);if(null!=A)for(var P=A[1],x=0;x<y.size;x+=1)g.push([P+"["+x+"]",y.type]);else g.push([k,y.type]);this._locations.set(k,b.call(o,this.handle,k))}}catch(e){t={error:e}}finally{try{u&&!u.done&&(e=f.return)&&e.call(f)}finally{if(t)throw t.error}}var E=new Set;try{for(var S=a.__values(_),T=S.next();!T.done;T=S.next()){var k=a.__read(T.value,1)[0];E.add(k)}}catch(t){r={error:t}}finally{try{T&&!T.done&&(i=S.return)&&i.call(S)}finally{if(r)throw r.error}}try{for(var I=a.__values(v),M=I.next();!M.done;M=I.next()){k=a.__read(M.value,1)[0];E.add(k)}}catch(t){n={error:t}}finally{try{M&&!M.done&&(s=I.return)&&s.call(I)}finally{if(n)throw n.error}}return E},t.prototype.set_texture=function(t,e){var r;if(!this._linked)throw new Error("Cannot set uniform when program has no code");var a=null!==(r=this._locations.get(t))&&void 0!==r?r:-1;if(a<0)this._known_invalid.has(t)||(this._known_invalid.add(t),console.log('"Variable '+t+" is not an active texture"));else{this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate();var i=this._samplers.size;this._samplers.has(t)&&(i=this._samplers.get(t)[2]),this._samplers.set(t,[e._target,e.handle,i]),this.gl.uniform1i(a,i)}},t.prototype.set_uniform=function(t,e,r){var a;if(!this._linked)throw new Error("Cannot set uniform when program has no code");var i=null!==(a=this._locations.get(t))&&void 0!==a?a:-1;if(i<0)this._known_invalid.has(t)||(this._known_invalid.add(t),console.log("Variable "+t+" is not an active uniform"));else{this._unset_variables.has(t)&&this._unset_variables.delete(t);var n=1;if(!e.startsWith("mat")){var s="int"==e||"bool"==e?"float":e.replace(/^ib/,"");n=Math.floor(r.length/this.ATYPEINFO[s][0])}if(n>1)for(var o=0;o<n;o+=1)if(this._unset_variables.has(t+"["+o+"]")){var l=t+"["+o+"]";this._unset_variables.has(l)&&this._unset_variables.delete(l)}var h=this.UTYPEMAP[e];this.activate(),e.startsWith("mat")?this.gl[h](i,!1,r):this.gl[h](i,r)}},t.prototype.set_attribute=function(t,e,r,n,s){var o;if(void 0===n&&(n=0),void 0===s&&(s=0),!this._linked)throw new Error("Cannot set attribute when program has no code");var l=null!==(o=this._locations.get(t))&&void 0!==o?o:-1;if(l<0)this._known_invalid.has(t)||(this._known_invalid.add(t),r instanceof i.VertexBuffer&&s>0||console.log("Variable "+t+" is not an active attribute"));else if(this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate(),r instanceof i.VertexBuffer){var h=a.__read(this.ATYPEINFO[e],2),_=(v="vertexAttribPointer",[h[0],h[1],!1,n,s]);this._attributes.set(t,[r.handle,l,v,_])}else{var v=this.ATYPEMAP[e];this._attributes.set(t,[null,l,v,r])}},t.prototype._pre_draw=function(){var t,e,r,i;this.activate();try{for(var n=a.__values(this._samplers.values()),s=n.next();!s.done;s=n.next()){var o=a.__read(s.value,3),l=o[0],h=o[1],_=o[2];this.gl.activeTexture(this.gl.TEXTURE0+_),this.gl.bindTexture(l,h)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=n.return)&&e.call(n)}finally{if(t)throw t.error}}try{for(var v=a.__values(this._attributes.values()),d=v.next();!d.done;d=v.next()){var f=a.__read(d.value,4),u=f[0],c=f[1],g=f[2],m=f[3];null!=u?(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,u),this.gl.enableVertexAttribArray(c),this.gl[g].apply(this.gl,a.__spread([c],m))):(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,null),this.gl.disableVertexAttribArray(c),this.gl[g].apply(this.gl,a.__spread([c],m)))}}catch(t){r={error:t}}finally{try{d&&!d.done&&(i=v.return)&&i.call(v)}finally{if(r)throw r.error}}this._validated||(this._validated=!0,this._validate())},t.prototype._validate=function(){if(this._unset_variables.size&&console.log("Program has unset variables: "+this._unset_variables),this.gl.validateProgram(this.handle),!this.gl.getProgramParameter(this.handle,this.gl.VALIDATE_STATUS))throw console.log(this.gl.getProgramInfoLog(this.handle)),new Error("Program validation error")},t.prototype.draw=function(t,e){if(!this._linked)throw new Error("Cannot draw program if code has not been set");if(e instanceof i.IndexBuffer){this._pre_draw(),e.activate();var r=e.buffer_size/2,n=this.gl.UNSIGNED_SHORT;this.gl.drawElements(t,r,n,0),e.deactivate()}else{var s=a.__read(e,2),o=s[0];0!=(r=s[1])&&(this._pre_draw(),this.gl.drawArrays(t,o,r))}},t}();r.Program=n,n.__name__="Program"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),f=function(){function t(t){this.gl=t,this._usage=35048,this.buffer_size=0,this.handle=this.gl.createBuffer()}return t.prototype.delete=function(){this.gl.deleteBuffer(this.handle)},t.prototype.activate=function(){this.gl.bindBuffer(this._target,this.handle)},t.prototype.deactivate=function(){this.gl.bindBuffer(this._target,null)},t.prototype.set_size=function(t){t!=this.buffer_size&&(this.activate(),this.gl.bufferData(this._target,t,this._usage),this.buffer_size=t)},t.prototype.set_data=function(t,e){this.activate(),this.gl.bufferSubData(this._target,t,e)},t}();i.Buffer=f,f.__name__="Buffer";var n=function(t){function e(){var e=t.apply(this,r.__spread(arguments))||this;return e._target=34962,e}return r.__extends(e,t),e}(f);i.VertexBuffer=n,n.__name__="VertexBuffer";var a=function(t){function e(){var e=t.apply(this,r.__spread(arguments))||this;return e._target=34963,e}return r.__extends(e,t),e}(f);i.IndexBuffer=a,a.__name__="IndexBuffer"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),a=t(126),n=function(){function t(t){this.gl=t,this._target=3553,this._types={Int8Array:5120,Uint8Array:5121,Int16Array:5122,Uint16Array:5123,Int32Array:5124,Uint32Array:5125,Float32Array:5126},this.handle=this.gl.createTexture()}return t.prototype.delete=function(){this.gl.deleteTexture(this.handle)},t.prototype.activate=function(){this.gl.bindTexture(this._target,this.handle)},t.prototype.deactivate=function(){this.gl.bindTexture(this._target,0)},t.prototype._get_alignment=function(t){var e,r;try{for(var n=i.__values([4,8,2,1]),o=n.next();!o.done;o=n.next()){var h=o.value;if(t%h==0)return h}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}a.unreachable()},t.prototype.set_wrapping=function(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_S,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_T,e)},t.prototype.set_interpolation=function(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_MIN_FILTER,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_MAG_FILTER,e)},t.prototype.set_size=function(t,e){var r,a,n,o=i.__read(t,2),h=o[0],s=o[1];h==(null===(r=this._shape_format)||void 0===r?void 0:r.width)&&s==(null===(a=this._shape_format)||void 0===a?void 0:a.height)&&e==(null===(n=this._shape_format)||void 0===n?void 0:n.format)||(this._shape_format={width:h,height:s,format:e},this.activate(),this.gl.texImage2D(this._target,0,e,h,s,0,e,this.gl.UNSIGNED_BYTE,null))},t.prototype.set_data=function(t,e,r){var a=i.__read(e,2),n=a[0],o=a[1];this.activate();var h=this._shape_format.format,s=i.__read(t,2),_=s[0],l=s[1],g=this._types[r.constructor.name];if(null==g)throw new Error("Type "+r.constructor.name+" not allowed for texture");var u=this._get_alignment(n);4!=u&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,u),this.gl.texSubImage2D(this._target,0,_,l,n,o,h,g,r),4!=u&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,4)},t}();r.Texture2d=n,n.__name__="Texture2d"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var h=function(){function e(e,t){this.gl=e,this.glyph=t,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.init()}return e.prototype.set_data_changed=function(){var e=this.glyph.data_size;e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0},e.prototype.set_visuals_changed=function(){this.visuals_changed=!0},e.prototype.render=function(e,t,i){if(0==t.length)return!0;var h=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,n=h.width,s=h.height,a={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:n,height:s};return this.draw(t,i,a),!0},e}();i.BaseGLGlyph=h,h.__name__="BaseGLGlyph"},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.vertex_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = a_position;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n"},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0}),e.fragment_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}\n"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(208),o=t(215),l=n.__importStar(t(216)),s=n.__importStar(t(143)),a=t(203),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._inner_loop=function(t,e,i,r,o){var l,s;try{for(var a=n.__values(e),_=a.next();!_.done;_=a.next()){var h=_.value;0!=h?isNaN(i[h]+r[h])?(t.closePath(),o.apply(t),t.beginPath()):t.lineTo(i[h],r[h]):(t.beginPath(),t.moveTo(i[h],r[h]))}}catch(t){l={error:t}}finally{try{_&&!_.done&&(s=a.return)&&s.call(a)}finally{if(l)throw l.error}}t.closePath(),o.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx,o=i.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner_loop(t,e,r,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return n._inner_loop(t,e,r,o,t.fill)}),(function(){return n.renderer.request_render()})),this.visuals.line.doit&&(this.visuals.line.set_value(t),this._inner_loop(t,e,r,o,t.stroke))},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e.prototype._hit_point=function(t){var e=new a.Selection;return l.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(e.add_to_selected_glyphs(this.model),e.view=this),e},e}(r.XYGlyphView);i.PatchView=_,_.__name__="PatchView";var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Patch=function(){this.prototype.default_view=_,this.mixins([s.Line,s.Fill,s.Hatch])},e}(r.XYGlyph);i.Patch=h,h.__name__="Patch",h.init_Patch()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),n=t(139),s=t(227),o=r.__importStar(t(216)),a=r.__importStar(t(133)),_=t(203),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x1[n],o=this._x2[n],a=this._y[n];isNaN(s+o+a)||!isFinite(s+o+a)?t.add_empty():t.add(e(s,o),a,i(s,o),a)}},e.prototype._inner=function(t,e,i,r,n){t.beginPath();for(var s=0,o=e.length;s<o;s++)t.lineTo(e[s],r[s]);for(s=i.length-1;s>=0;s--)t.lineTo(i[s],r[s]);t.closePath(),n.call(t)},e.prototype._render=function(t,e,i){var r=this,n=i.sx1,s=i.sx2,o=i.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,n,s,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return r._inner(t,n,s,o,t.fill)}),(function(){return r.renderer.request_render()}))},e.prototype._hit_point=function(t){for(var e=this.sy.length,i=new n.NumberArray(2*e),r=new n.NumberArray(2*e),s=0,a=e;s<a;s++)i[s]=this.sx1[s],r[s]=this.sy[s],i[e+s]=this.sx2[e-s-1],r[e+s]=this.sy[e-s-1];var h=new _.Selection;return o.point_in_poly(t.sx,t.sy,i,r)&&(h.add_to_selected_glyphs(this.model),h.view=this),h},e.prototype.scenterxy=function(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]},e.prototype._map_data=function(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)},e}(s.AreaView);i.HAreaView=h,h.__name__="HAreaView";var l=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_HArea=function(){this.prototype.default_view=h,this.define({x1:[a.XCoordinateSpec,{field:"x1"}],x2:[a.XCoordinateSpec,{field:"x2"}],y:[a.YCoordinateSpec,{field:"y"}]})},e}(s.Area);i.HArea=l,l.__name__="HArea",l.init_HArea()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),r=e(209),_=e(215),a=i.__importStar(e(143)),u=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(n,e),n.prototype.draw_legend_for_index=function(e,n,t){_.generic_area_legend(this.visuals,e,n,t)},n}(r.GlyphView);t.AreaView=u,u.__name__="AreaView";var l=function(e){function n(n){return e.call(this,n)||this}return i.__extends(n,e),n.init_Area=function(){this.mixins([a.Fill,a.HatchVector])},n}(r.Glyph);t.Area=l,l.__name__="Area",l.init_Area()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),n=t(139),s=t(227),o=r.__importStar(t(216)),a=r.__importStar(t(133)),_=t(203),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x[n],o=this._y1[n],a=this._y2[n];isNaN(s+o+a)||!isFinite(s+o+a)?t.add_empty():t.add(s,e(o,a),s,i(o,a))}},e.prototype._inner=function(t,e,i,r,n){t.beginPath();for(var s=0,o=i.length;s<o;s++)t.lineTo(e[s],i[s]);for(s=r.length-1;s>=0;s--)t.lineTo(e[s],r[s]);t.closePath(),n.call(t)},e.prototype._render=function(t,e,i){var r=this,n=i.sx,s=i.sy1,o=i.sy2;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,n,s,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return r._inner(t,n,s,o,t.fill)}),(function(){return r.renderer.request_render()}))},e.prototype.scenterxy=function(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]},e.prototype._hit_point=function(t){for(var e=this.sx.length,i=new n.NumberArray(2*e),r=new n.NumberArray(2*e),s=0,a=e;s<a;s++)i[s]=this.sx[s],r[s]=this.sy1[s],i[e+s]=this.sx[e-s-1],r[e+s]=this.sy2[e-s-1];var h=new _.Selection;return o.point_in_poly(t.sx,t.sy,i,r)&&(h.add_to_selected_glyphs(this.model),h.view=this),h},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)},e}(s.AreaView);i.VAreaView=h,h.__name__="VAreaView";var l=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_VArea=function(){this.prototype.default_view=h,this.define({x:[a.XCoordinateSpec,{field:"x"}],y1:[a.YCoordinateSpec,{field:"y1"}],y2:[a.YCoordinateSpec,{field:"y2"}]})},e}(s.Area);i.VArea=l,l.__name__="VArea",l.init_VArea()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),s=t(196),c=n.__importStar(t(133)),r=t(203),o=t(139),u=t(201),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_CDSView=function(){this.define({filters:[c.Array,[]],source:[c.Instance]}),this.internal({indices:[c.Any],indices_map:[c.Any,{}],masked:[c.Any,null]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.compute_indices()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,(function(){e.compute_indices(),e.change.emit()}));var i=function(){var t=function(){return e.compute_indices()};null!=e.source&&(e.connect(e.source.change,t),e.source instanceof u.ColumnarDataSource&&(e.connect(e.source.streaming,t),e.connect(e.source.patching,t)))},n=null!=this.source;n?i():this.connect(this.properties.source.change,(function(){n||(i(),n=!0)}))},e.prototype.compute_indices=function(){var t,e,i,s=this.source;if(null!=s){var c=null!==(i=s.get_length())&&void 0!==i?i:1,r=o.Indices.all_set(c);try{for(var u=n.__values(this.filters),a=u.next();!a.done;a=u.next()){var _=a.value;r.intersect(_.compute_indices(s))}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=u.return)&&e.call(u)}finally{if(t)throw t.error}}this.indices=r,this._indices=n.__spread(r),this.indices_map_to_subset()}},e.prototype.indices_map_to_subset=function(){this.indices_map={};for(var t=0;t<this._indices.length;t++)this.indices_map[this._indices[t]]=t},e.prototype.convert_selection_from_subset=function(t){var e=this,i=t.indices.map((function(t){return e._indices[t]}));return new r.Selection(Object.assign(Object.assign({},t.attributes),{indices:i}))},e.prototype.convert_selection_to_subset=function(t){var e=this,i=t.indices.map((function(t){return e.indices_map[t]}));return new r.Selection(Object.assign(Object.assign({},t.attributes),{indices:i}))},e.prototype.convert_indices_from_subset=function(t){var e=this;return t.map((function(t){return e._indices[t]}))},e}(s.Model);i.CDSView=a,a.__name__="CDSView",a.init_CDSView()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(1),a=e(124);function i(e,r,n){return t.__awaiter(this,void 0,void 0,(function(){var a;return t.__generator(this,(function(t){switch(t.label){case 0:return(a=new e(Object.assign(Object.assign({},n),{model:r}))).initialize(),[4,a.lazy_initialize()];case 1:return t.sent(),[2,a]}}))}))}n.build_view=function(e,r,n){return void 0===r&&(r={parent:null}),void 0===n&&(n=function(e){return e.default_view}),t.__awaiter(this,void 0,void 0,(function(){var a;return t.__generator(this,(function(t){switch(t.label){case 0:return[4,i(n(e),e,r)];case 1:return(a=t.sent()).connect_signals(),[2,a]}}))}))},n.build_views=function(e,r,n,l){return void 0===n&&(n={parent:null}),void 0===l&&(l=function(e){return e.default_view}),t.__awaiter(this,void 0,void 0,(function(){var o,u,c,s,_,f,v,d,h,y,w,b,g,x,p,m,j,z;return t.__generator(this,(function(O){switch(O.label){case 0:o=a.difference(t.__spread(e.keys()),r);try{for(u=t.__values(o),c=u.next();!c.done;c=u.next())d=c.value,e.get(d).remove(),e.delete(d)}catch(e){g={error:e}}finally{try{c&&!c.done&&(x=u.return)&&x.call(u)}finally{if(g)throw g.error}}s=[],_=r.filter((function(r){return!e.has(r)})),O.label=1;case 1:O.trys.push([1,6,7,8]),f=t.__values(_),v=f.next(),O.label=2;case 2:return v.done?[3,5]:(d=v.value,[4,i(l(d),d,n)]);case 3:b=O.sent(),e.set(d,b),s.push(b),O.label=4;case 4:return v=f.next(),[3,2];case 5:return[3,8];case 6:return h=O.sent(),p={error:h},[3,8];case 7:try{v&&!v.done&&(m=f.return)&&m.call(f)}finally{if(p)throw p.error}return[7];case 8:try{for(y=t.__values(s),w=y.next();!w.done;w=y.next())(b=w.value).connect_signals()}catch(e){j={error:e}}finally{try{w&&!w.done&&(z=y.return)&&z.call(y)}finally{if(j)throw j.error}}return[2,s]}}))}))},n.remove_views=function(e){var r,n;try{for(var a=t.__values(e),i=a.next();!i.done;i=a.next()){var l=t.__read(i.value,2),o=l[0];l[1].remove(),e.delete(o)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),i=e(206),o=e(232),a=r.__importStar(e(133)),_=e(230),s=e(126),u=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(n,e),n.prototype.lazy_initialize=function(){return r.__awaiter(this,void 0,void 0,(function(){var n,t,i,o,a,u,d,l,c,p,h,v,y;return r.__generator(this,(function(f){switch(f.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return f.sent(),n=this.model,t=null,i=null,o={v_compute:function(e){return s.assert(null==t),r.__read(t=n.layout_provider.get_edge_coordinates(e),1)[0]}},a={v_compute:function(e){s.assert(null!=t);var n=r.__read(t,2)[1];return t=null,n}},u={v_compute:function(e){return s.assert(null==i),r.__read(i=n.layout_provider.get_node_coordinates(e),1)[0]}},d={v_compute:function(e){s.assert(null!=i);var n=r.__read(i,2)[1];return i=null,n}},l=this.model,c=l.edge_renderer,p=l.node_renderer,c.glyph.xs={expr:o},c.glyph.ys={expr:a},p.glyph.x={expr:u},p.glyph.y={expr:d},h=this.parent,v=this,[4,_.build_view(c,{parent:h})];case 2:return v.edge_view=f.sent(),y=this,[4,_.build_view(p,{parent:h})];case 3:return y.node_view=f.sent(),[2]}}))}))},n.prototype.connect_signals=function(){var n=this;e.prototype.connect_signals.call(this),this.connect(this.model.layout_provider.change,(function(){n.edge_view.set_data(!1),n.node_view.set_data(!1),n.request_render()}))},n.prototype.remove=function(){this.edge_view.remove(),this.node_view.remove(),e.prototype.remove.call(this)},n.prototype._render=function(){this.edge_view.render(),this.node_view.render()},n}(i.DataRendererView);t.GraphRendererView=u,u.__name__="GraphRendererView";var d=function(e){function n(n){return e.call(this,n)||this}return r.__extends(n,e),n.init_GraphRenderer=function(){this.prototype.default_view=u,this.define({layout_provider:[a.Instance],node_renderer:[a.Instance],edge_renderer:[a.Instance],selection_policy:[a.Instance,function(){return new o.NodesOnly}],inspection_policy:[a.Instance,function(){return new o.NodesOnly}]})},n.prototype.get_selection_manager=function(){return this.node_renderer.data_source.selection_manager},n}(i.DataRenderer);t.GraphRenderer=d,d.__name__="GraphRenderer",d.init_GraphRenderer()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),o=e(196),d=e(127),i=e(124),_=e(203),s=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype._hit_test_nodes=function(e,t){if(!t.model.visible)return null;var n=t.node_view.glyph.hit_test(e);return null==n?null:t.node_view.model.view.convert_selection_from_subset(n)},t.prototype._hit_test_edges=function(e,t){if(!t.model.visible)return null;var n=t.edge_view.glyph.hit_test(e);return null==n?null:t.edge_view.model.view.convert_selection_from_subset(n)},t}(o.Model);n.GraphHitTestPolicy=s,s.__name__="GraphHitTestPolicy";var a=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_nodes(e,t)},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var o=t.node_renderer.data_source.selected;return o.update(e,n,r),t.node_renderer.data_source._select.emit(),!o.is_empty()},t.prototype.do_inspection=function(e,t,n,r,o){if(null==e)return!1;var d=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return d.update(e,r,o),n.node_view.model.data_source.setv({inspected:d},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!d.is_empty()},t}(s);n.NodesOnly=a,a.__name__="NodesOnly";var c=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_nodes(e,t)},t.prototype.get_linked_edges=function(e,t,n){var o,d,s=[];"selection"==n?s=e.selected.indices.map((function(t){return e.data.index[t]})):"inspection"==n&&(s=e.inspected.indices.map((function(t){return e.data.index[t]})));for(var a=[],c=0;c<t.data.start.length;c++)(i.contains(s,t.data.start[c])||i.contains(s,t.data.end[c]))&&a.push(c);var l=new _.Selection;try{for(var u=r.__values(a),p=u.next();!p.done;p=u.next()){c=p.value;l.multiline_indices[c]=[0]}}catch(e){o={error:e}}finally{try{p&&!p.done&&(d=u.return)&&d.call(u)}finally{if(o)throw o.error}}return l.indices=a,l},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var o=t.node_renderer.data_source.selected;o.update(e,n,r);var d=t.edge_renderer.data_source.selected,i=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return d.update(i,n,r),t.node_renderer.data_source._select.emit(),!o.is_empty()},t.prototype.do_inspection=function(e,t,n,r,o){if(null==e)return!1;var d=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);d.update(e,r,o),n.node_view.model.data_source.setv({inspected:d},{silent:!0});var i=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),_=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,o),n.edge_view.model.data_source.setv({inspected:i},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!d.is_empty()},t}(s);n.NodesAndLinkedEdges=c,c.__name__="NodesAndLinkedEdges";var l=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_edges(e,t)},t.prototype.get_linked_nodes=function(e,t,n){var o,s,a=[];"selection"==n?a=t.selected.indices:"inspection"==n&&(a=t.inspected.indices);var c=[];try{for(var l=r.__values(a),u=l.next();!u.done;u=l.next()){var p=u.value;c.push(t.data.start[p]),c.push(t.data.end[p])}}catch(e){o={error:e}}finally{try{u&&!u.done&&(s=l.return)&&s.call(l)}finally{if(o)throw o.error}}var v=i.uniq(c).map((function(t){return d.indexOf(e.data.index,t)}));return new _.Selection({indices:v})},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var o=t.edge_renderer.data_source.selected;o.update(e,n,r);var d=t.node_renderer.data_source.selected,i=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return d.update(i,n,r),t.edge_renderer.data_source._select.emit(),!o.is_empty()},t.prototype.do_inspection=function(e,t,n,r,o){if(null==e)return!1;var d=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);d.update(e,r,o),n.edge_view.model.data_source.setv({inspected:d},{silent:!0});var i=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),_=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,o),n.node_view.model.data_source.setv({inspected:i},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view,{geometry:t}]),!d.is_empty()},t}(s);n.EdgesAndLinkedNodes=l,l.__name__="EdgesAndLinkedNodes"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(1),l=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(r,e),r.prototype.do_selection=function(e,r,t,n){return null!==e&&(r.selected.update(e,t,n),r._select.emit(),!r.selected.is_empty())},r}(e(196).Model);t.SelectionPolicy=l,l.__name__="SelectionPolicy";var o=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(r,e),r.prototype.hit_test=function(e,r){var t,l,o,u,a=[];try{for(var i=n.__values(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!==c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(l=i.return)&&l.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=n.__values(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_intersection(y)}}catch(e){o={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(o)throw o.error}}return s}return null},r}(l);t.IntersectRenderers=o,o.__name__="IntersectRenderers";var u=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(r,e),r.prototype.hit_test=function(e,r){var t,l,o,u,a=[];try{for(var i=n.__values(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!==c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(l=i.return)&&l.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=n.__values(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_union(y)}}catch(e){o={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(o)throw o.error}}return s}return null},r}(l);t.UnionRenderers=u,u.__name__="UnionRenderers"},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=r(1);t.concat=function(r){for(var e,t,l,a,o=[],c=1;c<arguments.length;c++)o[c-1]=arguments[c];var v=r.length;try{for(var f=n.__values(o),u=f.next();!u.done;u=f.next()){v+=(d=u.value).length}}catch(r){e={error:r}}finally{try{u&&!u.done&&(t=f.return)&&t.call(f)}finally{if(e)throw e.error}}var h=new r.constructor(v);h.set(r,0);var i=r.length;try{for(var y=n.__values(o),_=y.next();!_.done;_=y.next()){var d=_.value;h.set(d,i),i+=d.length}}catch(r){l={error:r}}finally{try{_&&!_.done&&(a=y.return)&&a.call(y)}finally{if(l)throw l.error}}return h}},
function _(r,e,n){Object.defineProperty(n,"__esModule",{value:!0});var t=r(1);function a(){for(var r,e,n,a,l=[],o=0;o<arguments.length;o++)l[o]=arguments[o];var f=new Set;try{for(var v=t.__values(l),i=v.next();!i.done;i=v.next()){var u=i.value;try{for(var c=(n=void 0,t.__values(u)),d=c.next();!d.done;d=c.next()){var y=d.value;f.add(y)}}catch(r){n={error:r}}finally{try{d&&!d.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}}}catch(e){r={error:e}}finally{try{i&&!i.done&&(e=v.return)&&e.call(v)}finally{if(r)throw r.error}}return f}n.union=a,n.intersection=function(r){for(var e,n,a,l,o=[],f=1;f<arguments.length;f++)o[f-1]=arguments[f];var v=new Set;try{r:for(var i=t.__values(r),u=i.next();!u.done;u=i.next()){var c=u.value;try{for(var d=(a=void 0,t.__values(o)),y=d.next();!y.done;y=d.next()){var _=y.value;if(!_.has(c))continue r}}catch(r){a={error:r}}finally{try{y&&!y.done&&(l=d.return)&&l.call(d)}finally{if(a)throw a.error}}v.add(c)}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=i.return)&&n.call(i)}finally{if(e)throw e.error}}return v},n.difference=function(r){for(var e,n,l=[],o=1;o<arguments.length;o++)l[o-1]=arguments[o];var f=new Set(r);try{for(var v=t.__values(a.apply(void 0,t.__spread(l))),i=v.next();!i.done;i=v.next()){var u=i.value;f.delete(u)}}catch(r){e={error:r}}finally{try{i&&!i.done&&(n=v.return)&&n.call(v)}finally{if(e)throw e.error}}return f}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),o=e(129),s=function(e){this.document=e};n.DocumentEvent=s,s.__name__="DocumentEvent";var a=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.events=n,o.setter_id=r,o}return r.__extends(t,e),t}(s);n.DocumentEventBatch=a,a.__name__="DocumentEventBatch";var i=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t}(s);n.DocumentChangedEvent=i,i.__name__="DocumentChangedEvent";var _=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.msg_type=n,o.msg_data=r,o}return r.__extends(t,e),t.prototype.json=function(e){var t=this.msg_data,n=o.HasProps._value_to_json(t),r=new Set;return o.HasProps._value_record_references(t,r,{recursive:!0}),{kind:"MessageSent",msg_type:this.msg_type,msg_data:n}},t}(i);n.MessageSentEvent=_,_.__name__="MessageSentEvent";var u=function(e){function t(t,n,r,o,s,a,i){var _=e.call(this,t)||this;return _.model=n,_.attr=r,_.old=o,_.new_=s,_.setter_id=a,_.hint=i,_}return r.__extends(t,e),t.prototype.json=function(e){var t,n;if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(e);var s=this.new_,a=o.HasProps._value_to_json(s),i=new Set;o.HasProps._value_record_references(s,i,{recursive:!0}),i.has(this.model)&&this.model!==s&&i.delete(this.model);try{for(var _=r.__values(i),u=_.next();!u.done;u=_.next()){var d=u.value;e.add(d)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(n=_.return)&&n.call(_)}finally{if(t)throw t.error}}return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:a}},t}(i);n.ModelChangedEvent=u,u.__name__="ModelChangedEvent";var d=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.column_source=n,o.patches=r,o}return r.__extends(t,e),t.prototype.json=function(e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},t}(i);n.ColumnsPatchedEvent=d,d.__name__="ColumnsPatchedEvent";var l=function(e){function t(t,n,r,o){var s=e.call(this,t)||this;return s.column_source=n,s.data=r,s.rollover=o,s}return r.__extends(t,e),t.prototype.json=function(e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},t}(i);n.ColumnsStreamedEvent=l,l.__name__="ColumnsStreamedEvent";var c=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.title=n,o.setter_id=r,o}return r.__extends(t,e),t.prototype.json=function(e){return{kind:"TitleChanged",title:this.title}},t}(i);n.TitleChangedEvent=c,c.__name__="TitleChangedEvent";var h=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.model=n,o.setter_id=r,o}return r.__extends(t,e),t.prototype.json=function(e){return o.HasProps._value_record_references(this.model,e,{recursive:!0}),{kind:"RootAdded",model:this.model.ref()}},t}(i);n.RootAddedEvent=h,h.__name__="RootAddedEvent";var v=function(e){function t(t,n,r){var o=e.call(this,t)||this;return o.model=n,o.setter_id=r,o}return r.__extends(t,e),t.prototype.json=function(e){return{kind:"RootRemoved",model:this.model.ref()}},t}(i);n.RootRemovedEvent=v,v.__name__="RootRemovedEvent"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var s=e(1),n=e(238),o=s.__importStar(e(143)),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var i=function(){return t.set_data(t.model.source)};this.connect(this.model.change,i),this.connect(this.model.source.streaming,i),this.connect(this.model.source.patching,i),this.connect(this.model.source.change,i)},t.prototype._render=function(){this._map_data();var e=this.layer.ctx;e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var t=0,i=this._lower_sx.length;t<i;t++)e.lineTo(this._lower_sx[t],this._lower_sy[t]);for(t=this._upper_sx.length-1;t>=0;t--)e.lineTo(this._upper_sx[t],this._upper_sy[t]);e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(e),e.fill()),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(t=0,i=this._lower_sx.length;t<i;t++)e.lineTo(this._lower_sx[t],this._lower_sy[t]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke()),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(t=0,i=this._upper_sx.length;t<i;t++)e.lineTo(this._upper_sx[t],this._upper_sy[t]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke())},t}(n.UpperLowerView);i.BandView=_,_.__name__="BandView";var l=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Band=function(){this.prototype.default_view=_,this.mixins([o.Line,o.Fill]),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},t}(n.UpperLower);i.Band=l,l.__name__="Band",l.init_Band()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var o=e(1),r=e(151),s=e(200),n=o.__importStar(e(133)),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.set_data(this.model.source)},t.prototype.set_data=function(t){e.prototype.set_data.call(this,t),this.visuals.warm_cache(t),this.plot_view.request_render()},t.prototype._map_data=function(){var e,t,i,r=this.plot_view.frame,s=this.model.dimension,n=this.coordinates.x_scale,p=this.coordinates.y_scale,_="height"==s?p:n,a="height"==s?n:p,h="height"==s?r.yview:r.xview,u="height"==s?r.xview:r.yview;e="data"==this.model.properties.lower.units?_.v_compute(this._lower):h.v_compute(this._lower),t="data"==this.model.properties.upper.units?_.v_compute(this._upper):h.v_compute(this._upper),i="data"==this.model.properties.base.units?a.v_compute(this._base):u.v_compute(this._base);var c=o.__read("height"==s?[1,0]:[0,1],2),l=c[0],d=c[1],w=[e,i],m=[t,i];this._lower_sx=w[l],this._lower_sy=w[d],this._upper_sx=m[l],this._upper_sy=m[d]},t}(r.AnnotationView);i.UpperLowerView=p,p.__name__="UpperLowerView";var _=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_UpperLower=function(){this.define({lower:[n.DistanceSpec],upper:[n.DistanceSpec],base:[n.DistanceSpec],dimension:[n.Dimension,"height"],source:[n.Instance,function(){return new s.ColumnDataSource}]})},t}(r.Annotation);i.UpperLower=_,_.__name__="UpperLower",_.init_UpperLower()},
function _(t,i,o){Object.defineProperty(o,"__esModule",{value:!0});var e=t(1),n=t(151),s=t(130),l=e.__importStar(t(143)),r=e.__importStar(t(133)),a=t(194);o.EDGE_TOLERANCE=2.5;var h=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return i.plot_view.request_paint(i)})),this.connect(this.model.data_update,(function(){return i.plot_view.request_paint(i)}))},i.prototype._render=function(){var t=this;if(null!=this.model.left||null!=this.model.right||null!=this.model.top||null!=this.model.bottom){var i=this.plot_view.frame,o=this.coordinates.x_scale,e=this.coordinates.y_scale,n=function(i,o,e,n,s){return null!=i?t.model.screen?i:"data"==o?e.compute(i):n.compute(i):s};this.sleft=n(this.model.left,this.model.left_units,o,i.xview,i.bbox.left),this.sright=n(this.model.right,this.model.right_units,o,i.xview,i.bbox.right),this.stop=n(this.model.top,this.model.top_units,e,i.yview,i.bbox.top),this.sbottom=n(this.model.bottom,this.model.bottom_units,e,i.yview,i.bbox.bottom),this._paint_box(this.sleft,this.sright,this.sbottom,this.stop)}},i.prototype._paint_box=function(t,i,o,e){var n=this.layer.ctx;n.save(),n.beginPath(),n.rect(t,e,i-t,o-e),this.visuals.fill.doit&&(this.visuals.fill.set_value(n),n.fill()),this.visuals.line.doit&&(this.visuals.line.set_value(n),n.stroke()),n.restore()},i.prototype.interactive_bbox=function(){var t=this.model.properties.line_width.value()+o.EDGE_TOLERANCE;return new a.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})},i.prototype.interactive_hit=function(t,i){return null!=this.model.in_cursor&&this.interactive_bbox().contains(t,i)},i.prototype.cursor=function(t,i){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(i-this.sbottom)<3||Math.abs(i-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&i>this.stop&&i<this.sbottom?this.model.in_cursor:null},i}(n.AnnotationView);o.BoxAnnotationView=h,h.__name__="BoxAnnotationView";var u=function(t){function i(i){return t.call(this,i)||this}return e.__extends(i,t),i.init_BoxAnnotation=function(){this.prototype.default_view=h,this.mixins([l.Line,l.Fill]),this.define({render_mode:[r.RenderMode,"canvas"],top:[r.Number,null],top_units:[r.SpatialUnits,"data"],bottom:[r.Number,null],bottom_units:[r.SpatialUnits,"data"],left:[r.Number,null],left_units:[r.SpatialUnits,"data"],right:[r.Number,null],right_units:[r.SpatialUnits,"data"]}),this.internal({screen:[r.Boolean,!1],ew_cursor:[r.String,null],ns_cursor:[r.String,null],in_cursor:[r.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new s.Signal0(this,"data_update")},i.prototype.update=function(t){var i=t.left,o=t.right,e=t.top,n=t.bottom;this.setv({left:i,right:o,top:e,bottom:n,screen:!0},{silent:!0}),this.data_update.emit()},i}(n.Annotation);o.BoxAnnotation=u,u.__name__="BoxAnnotation",u.init_BoxAnnotation()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),r=t(151),a=t(241),n=t(245),s=t(247),l=t(260),_=t(271),h=t(272),m=t(273),d=o.__importStar(t(143)),c=o.__importStar(t(133)),u=o.__importStar(t(274)),p=t(124),f=t(127),g=t(123),v=t(126),b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_canvas_image()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.ticker.change,(function(){return e.plot_view.request_render()})),this.connect(this.model.formatter.change,(function(){return e.plot_view.request_render()})),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,(function(){e._set_canvas_image(),e.plot_view.request_render()}))},e.prototype._get_size=function(){if(null==this.model.color_mapper)return{width:0,height:0};var t=this.compute_legend_dimensions();return{width:t.width,height:t.height}},e.prototype._set_canvas_image=function(){var t,e;if(null!=this.model.color_mapper){var i,r,a=this.model.color_mapper.palette;switch("vertical"==this.model.orientation&&(a=p.reversed(a)),this.model.orientation){case"vertical":i=(t=o.__read([1,a.length],2))[0],r=t[1];break;case"horizontal":i=(e=o.__read([a.length,1],2))[0],r=e[1]}var n=document.createElement("canvas");n.width=i,n.height=r;var l=n.getContext("2d"),_=l.getImageData(0,0,i,r),h=new s.LinearColorMapper({palette:a}).rgba_mapper.v_compute(p.range(0,a.length));_.data.set(h),l.putImageData(_,0,0),this.image=n}},e.prototype.compute_legend_dimensions=function(){var t,e,i=this._computed_image_dimensions(),r=o.__read([i.height,i.width],2),a=r[0],n=r[1],s=this._get_label_extent(),l=this._title_extent(),_=this._tick_extent(),h=this.model.padding;switch(this.model.orientation){case"vertical":t=a+l+2*h,e=n+_+s+2*h;break;case"horizontal":t=a+l+_+s+2*h,e=n+2*h}return{width:e,height:t}},e.prototype.compute_legend_location=function(){var t,e,i=this.compute_legend_dimensions(),r=o.__read([i.height,i.width],2),a=r[0],n=r[1],s=this.model.margin,l=null!=this.panel?this.panel:this.plot_view.frame,_=o.__read(l.bbox.ranges,2),h=_[0],m=_[1],d=this.model.location;if(g.isString(d))switch(d){case"top_left":t=h.start+s,e=m.start+s;break;case"top_center":t=(h.end+h.start)/2-n/2,e=m.start+s;break;case"top_right":t=h.end-s-n,e=m.start+s;break;case"bottom_right":t=h.end-s-n,e=m.end-s-a;break;case"bottom_center":t=(h.end+h.start)/2-n/2,e=m.end-s-a;break;case"bottom_left":t=h.start+s,e=m.end-s-a;break;case"center_left":t=h.start+s,e=(m.end+m.start)/2-a/2;break;case"center":t=(h.end+h.start)/2-n/2,e=(m.end+m.start)/2-a/2;break;case"center_right":t=h.end-s-n,e=(m.end+m.start)/2-a/2}else if(g.isArray(d)&&2==d.length){var c=o.__read(d,2),u=c[0],p=c[1];t=l.xview.compute(u),e=l.yview.compute(p)-a}else v.unreachable();return{sx:t,sy:e}},e.prototype._render=function(){if(null!=this.model.color_mapper){var t=this.layer.ctx;t.save();var e=this.compute_legend_location(),i=e.sx,o=e.sy;t.translate(i,o),this._draw_bbox(t);var r=this._get_image_offset();t.translate(r.x,r.y),this._draw_image(t);var a=this.tick_info();this._draw_major_ticks(t,a),this._draw_minor_ticks(t,a),this._draw_major_labels(t,a),this.model.title&&this._draw_title(t),t.restore()}},e.prototype._draw_bbox=function(t){var e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_image=function(t){var e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_major_ticks=function(t,e){if(this.visuals.major_tick_line.doit){var i=o.__read(this._normals(),2),r=i[0],a=i[1],n=this._computed_image_dimensions(),s=o.__read([n.width*r,n.height*a],2),l=s[0],_=s[1],h=o.__read(e.coords.major,2),m=h[0],d=h[1],c=this.model.major_tick_in,u=this.model.major_tick_out;t.save(),t.translate(l,_),this.visuals.major_tick_line.set_value(t);for(var p=0,f=m.length;p<f;p++)t.beginPath(),t.moveTo(Math.round(m[p]+r*u),Math.round(d[p]+a*u)),t.lineTo(Math.round(m[p]-r*c),Math.round(d[p]-a*c)),t.stroke();t.restore()}},e.prototype._draw_minor_ticks=function(t,e){if(this.visuals.minor_tick_line.doit){var i=o.__read(this._normals(),2),r=i[0],a=i[1],n=this._computed_image_dimensions(),s=o.__read([n.width*r,n.height*a],2),l=s[0],_=s[1],h=o.__read(e.coords.minor,2),m=h[0],d=h[1],c=this.model.minor_tick_in,u=this.model.minor_tick_out;t.save(),t.translate(l,_),this.visuals.minor_tick_line.set_value(t);for(var p=0,f=m.length;p<f;p++)t.beginPath(),t.moveTo(Math.round(m[p]+r*u),Math.round(d[p]+a*u)),t.lineTo(Math.round(m[p]-r*c),Math.round(d[p]-a*c)),t.stroke();t.restore()}},e.prototype._draw_major_labels=function(t,e){if(this.visuals.major_label_text.doit){var i=o.__read(this._normals(),2),r=i[0],a=i[1],n=this._computed_image_dimensions(),s=o.__read([n.width*r,n.height*a],2),l=s[0],_=s[1],h=this.model.label_standoff+this._tick_extent(),m=o.__read([h*r,h*a],2),d=m[0],c=m[1],u=o.__read(e.coords.major,2),p=u[0],f=u[1],g=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(l+d,_+c);for(var v=0,b=p.length;v<b;v++)t.fillText(g[v],Math.round(p[v]+r*this.model.label_standoff),Math.round(f[v]+a*this.model.label_standoff));t.restore()}},e.prototype._draw_title=function(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())},e.prototype._get_label_extent=function(){var t,e=this.tick_info().labels.major;if(p.is_empty(e))t=0;else{var i=this.layer.ctx;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":t=p.max(e.map((function(t){return i.measureText(t.toString()).width})));break;case"horizontal":t=u.measure_font(this.visuals.major_label_text.font_value()).height}t+=this.model.label_standoff,i.restore()}return t},e.prototype._get_image_offset=function(){return{x:this.model.padding,y:this.model.padding+this._title_extent()}},e.prototype._normals=function(){return"vertical"==this.model.orientation?[1,0]:[0,1]},e.prototype._title_extent=function(){var t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style;return this.model.title?u.measure_font(t).height+this.model.title_standoff:0},e.prototype._tick_extent=function(){return p.max([this.model.major_tick_out,this.model.minor_tick_out])},e.prototype._computed_image_dimensions=function(){var t,e,i=this.plot_view.frame.bbox.height,o=this.plot_view.frame.bbox.width,r=this._title_extent();switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?t=i-2*this.model.padding-r:(t=p.max([25*this.model.color_mapper.palette.length,.3*i]),t=p.min([t,.8*i-2*this.model.padding-r])):t=this.model.height,e="auto"==this.model.width?25:this.model.width;break;case"horizontal":t="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?e=o-2*this.model.padding:(e=p.max([25*this.model.color_mapper.palette.length,.3*o]),e=p.min([e,.8*o-2*this.model.padding])):e=this.model.width}return{width:e,height:t}},e.prototype._tick_coordinate_scale=function(t){var e={source_range:new m.Range1d({start:this.model.color_mapper.metrics.min,end:this.model.color_mapper.metrics.max}),target_range:new m.Range1d({start:0,end:t})},i=this.model.color_mapper;if(i instanceof s.LinearColorMapper)return new l.LinearScale(e);if(i instanceof s.LogColorMapper)return new h.LogScale(e);if(i instanceof s.ScanningColorMapper){var o=i.metrics.binning;return new _.LinearInterpolationScale(Object.assign(Object.assign({},e),{binning:o}))}v.unreachable()},e.prototype._format_major_labels=function(t,e){for(var i=this.model.formatter.doFormat(t,null),o=0,r=e.length;o<r;o++)e[o]in this.model.major_label_overrides&&(i[o]=this.model.major_label_overrides[e[o]]);return i},e.prototype.tick_info=function(){var t,e=this._computed_image_dimensions();switch(this.model.orientation){case"vertical":t=e.height;break;case"horizontal":t=e.width}for(var i=this._tick_coordinate_scale(t),r=o.__read(this._normals(),2),a=r[0],n=r[1],s=o.__read([this.model.color_mapper.metrics.min,this.model.color_mapper.metrics.max],2),l=s[0],_=s[1],h=this.model.ticker.get_ticks(l,_,null,null,this.model.ticker.desired_num_ticks),m=h.major,d=h.minor,c=[[],[]],u=[[],[]],p=0,g=m.length;p<g;p++)m[p]<l||m[p]>_||(c[a].push(m[p]),c[n].push(0));for(p=0,g=d.length;p<g;p++)d[p]<l||d[p]>_||(u[a].push(d[p]),u[n].push(0));var v={major:this._format_major_labels(c[a],m)},b={major:[[],[]],minor:[[],[]]};return b.major[a]=i.v_compute(c[a]),b.minor[a]=i.v_compute(u[a]),b.major[n]=c[n],b.minor[n]=u[n],"vertical"==this.model.orientation&&(b.major[a]=f.map(b.major[a],(function(e){return t-e})),b.minor[a]=f.map(b.minor[a],(function(e){return t-e}))),{coords:b,labels:v}},e}(r.AnnotationView);i.ColorBarView=b,b.__name__="ColorBarView";var w=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_ColorBar=function(){this.prototype.default_view=b,this.mixins([["major_label_",d.Text],["title_",d.Text],["major_tick_",d.Line],["minor_tick_",d.Line],["border_",d.Line],["bar_",d.Line],["background_",d.Fill]]),this.define({location:[c.Any,"top_right"],orientation:[c.Orientation,"vertical"],title:[c.String],title_standoff:[c.Number,2],width:[c.Any,"auto"],height:[c.Any,"auto"],scale_alpha:[c.Number,1],ticker:[c.Instance,function(){return new a.BasicTicker}],formatter:[c.Instance,function(){return new n.BasicTickFormatter}],major_label_overrides:[c.Any,{}],color_mapper:[c.Instance],label_standoff:[c.Number,5],margin:[c.Number,30],padding:[c.Number,10],major_tick_in:[c.Number,5],major_tick_out:[c.Number,0],minor_tick_in:[c.Number,0],minor_tick_out:[c.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},e}(r.Annotation);i.ColorBar=w,w.__name__="ColorBar",w.init_ColorBar()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(1),c=function(e){function i(i){return e.call(this,i)||this}return t.__extends(i,e),i}(e(242).AdaptiveTicker);n.BasicTicker=c,c.__name__="BasicTicker"},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var a=t(1),n=t(243),s=t(124),r=a.__importStar(t(133));var _=function(t){function i(i){return t.call(this,i)||this}return a.__extends(i,t),i.init_AdaptiveTicker=function(){this.define({base:[r.Number,10],mantissas:[r.Array,[1,2,5]],min_interval:[r.Number,0],max_interval:[r.Number]})},i.prototype.initialize=function(){t.prototype.initialize.call(this);var i=s.nth(this.mantissas,-1)/this.base,e=s.nth(this.mantissas,0)*this.base;this.extended_mantissas=a.__spread([i],this.mantissas,[e]),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},i.prototype.get_interval=function(t,i,e){var a,n,r=i-t,_=this.get_ideal_interval(t,i,e),h=Math.floor((a=_/this.base_factor,void 0===(n=this.base)&&(n=Math.E),Math.log(a)/Math.log(n))),o=Math.pow(this.base,h)*this.base_factor,m=this.extended_mantissas,l=m.map((function(t){return Math.abs(e-r/(t*o))}));return function(t,i,e){return Math.max(i,Math.min(e,t))}(m[s.argmin(l)]*o,this.get_min_interval(),this.get_max_interval())},i}(n.ContinuousTicker);e.AdaptiveTicker=_,_.__name__="AdaptiveTicker",_.init_AdaptiveTicker()},
function _(t,r,n){Object.defineProperty(n,"__esModule",{value:!0});var e=t(1),i=t(244),o=e.__importStar(t(133)),u=t(124),a=function(t){function r(r){return t.call(this,r)||this}return e.__extends(r,t),r.init_ContinuousTicker=function(){this.define({num_minor_ticks:[o.Number,5],desired_num_ticks:[o.Number,6]})},r.prototype.get_ticks=function(t,r,n,e,i){return this.get_ticks_no_defaults(t,r,e,this.desired_num_ticks)},r.prototype.get_ticks_no_defaults=function(t,r,n,i){var o,a,l,_,c,s,f=this.get_interval(t,r,i),v=Math.floor(t/f),h=Math.ceil(r/f),m=(isFinite(v)&&isFinite(h)?u.range(v,h+1):[]).map((function(t){return t*f})).filter((function(n){return t<=n&&n<=r})),d=this.num_minor_ticks,y=[];if(d>0&&m.length>0){var p=f/d,k=u.range(0,d).map((function(t){return t*p}));try{for(var g=e.__values(k.slice(1)),x=g.next();!x.done;x=g.next()){var T=x.value,C=m[0]-T;t<=C&&C<=r&&y.push(C)}}catch(t){o={error:t}}finally{try{x&&!x.done&&(a=g.return)&&a.call(g)}finally{if(o)throw o.error}}try{for(var b=e.__values(m),w=b.next();!w.done;w=b.next()){var M=w.value;try{for(var j=(c=void 0,e.__values(k)),F=j.next();!F.done;F=j.next()){T=F.value;t<=(C=M+T)&&C<=r&&y.push(C)}}catch(t){c={error:t}}finally{try{F&&!F.done&&(s=j.return)&&s.call(j)}finally{if(c)throw c.error}}}}catch(t){l={error:t}}finally{try{w&&!w.done&&(_=b.return)&&_.call(b)}finally{if(l)throw l.error}}}return{major:m,minor:y}},r.prototype.get_min_interval=function(){return this.min_interval},r.prototype.get_max_interval=function(){return null!=this.max_interval?this.max_interval:1/0},r.prototype.get_ideal_interval=function(t,r,n){return(r-t)/n},r}(i.Ticker);n.ContinuousTicker=a,a.__name__="ContinuousTicker",a.init_ContinuousTicker()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),_=function(e){function n(n){return e.call(this,n)||this}return r.__extends(n,e),n}(e(196).Model);t.Ticker=_,_.__name__="Ticker"},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});var r=i(1),n=i(246),o=r.__importStar(i(133)),a=function(i){function t(t){var e=i.call(this,t)||this;return e.last_precision=3,e}return r.__extends(t,i),t.init_BasicTickFormatter=function(){this.define({precision:[o.Any,"auto"],use_scientific:[o.Boolean,!0],power_limit_high:[o.Number,5],power_limit_low:[o.Number,-3]})},Object.defineProperty(t.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!0,configurable:!0}),t.prototype._need_sci=function(i){var t,e;if(!this.use_scientific)return!1;var n=this.scientific_limit_high,o=this.scientific_limit_low,a=i.length<2?0:Math.abs(i[1]-i[0])/1e4;try{for(var c=r.__values(i),s=c.next();!s.done;s=c.next()){var _=s.value,l=Math.abs(_);if(!(l<=a)&&(l>=n||l<=o))return!0}}catch(i){t={error:i}}finally{try{s&&!s.done&&(e=c.return)&&e.call(c)}finally{if(t)throw t.error}}return!1},t.prototype._format_with_precision=function(i,t,e){var r=new Array(i.length);if(t)for(var n=0,o=i.length;n<o;n++)r[n]=i[n].toExponential(e);else for(n=0,o=i.length;n<o;n++)r[n]=i[n].toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");return r},t.prototype._auto_precision=function(i,t){var e=new Array(i.length),r=this.last_precision<=15;i:for(var n=this.last_precision;r?n<=15:n>=1;r?n++:n--){if(t){e[0]=i[0].toExponential(n);for(var o=1;o<i.length;o++)if(e[o]==e[o-1])continue i;this.last_precision=n;break}e[0]=i[0].toFixed(n).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");for(o=1;o<i.length;o++)if(e[o]=i[o].toFixed(n).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),e[o]==e[o-1])continue i;this.last_precision=n;break}return this.last_precision},t.prototype.doFormat=function(i,t){if(0==i.length)return[];var e=this._need_sci(i),r="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,r)},t}(n.TickFormatter);e.BasicTickFormatter=a,a.__name__="BasicTickFormatter",a.init_BasicTickFormatter()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),_=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t}(e(196).Model);n.TickFormatter=_,_.__name__="TickFormatter"},
function _(r,a,o){Object.defineProperty(o,"__esModule",{value:!0});var e=r(248);o.CategoricalColorMapper=e.CategoricalColorMapper;var p=r(253);o.CategoricalMarkerMapper=p.CategoricalMarkerMapper;var l=r(254);o.CategoricalPatternMapper=l.CategoricalPatternMapper;var C=r(255);o.ContinuousColorMapper=C.ContinuousColorMapper;var M=r(250);o.ColorMapper=M.ColorMapper;var n=r(256);o.LinearColorMapper=n.LinearColorMapper;var t=r(257);o.LogColorMapper=t.LogColorMapper;var i=r(258);o.ScanningColorMapper=i.ScanningColorMapper;var c=r(259);o.EqHistColorMapper=c.EqHistColorMapper},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var o=t(1),a=t(249),i=t(250),n=o.__importStar(t(133)),_=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_CategoricalColorMapper=function(){this.define({factors:[n.Array],start:[n.Number,0],end:[n.Number]})},r.prototype._v_compute=function(t,r,e,o){var i=o.nan_color;a.cat_v_compute(t,this.factors,e,r,this.start,this.end,i)},r}(i.ColorMapper);e.CategoricalColorMapper=_,_.__name__="CategoricalColorMapper",_.init_CategoricalColorMapper()},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0});var i=n(127),l=n(123);function r(n,e){if(n.length!=e.length)return!1;for(var t=0,i=n.length;t<i;t++)if(n[t]!==e[t])return!1;return!0}t._cat_equals=r,t.cat_v_compute=function(n,e,t,u,o,f,c){for(var _=function(_,a){var v=n[_],d=void 0;l.isString(v)?d=i.index_of(e,v):(null!=o?v=null!=f?v.slice(o,f):v.slice(o):null!=f&&(v=v.slice(0,f)),d=1==v.length?i.index_of(e,v[0]):i.find_index(e,(function(n){return r(n,v)})));var g=void 0;g=d<0||d>=t.length?c:t[d],u[_]=g},a=0,v=n.length;a<v;a++)_(a)}},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),o=t(251),i=n.__importStar(t(133)),a=t(123),_=t(137),u=t(147);function l(t){return a.isNumber(t)?t:("#"!=t[0]&&(t=_.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function c(t){for(var r=new Uint32Array(t.length),e=0,n=t.length;e<n;e++)r[e]=l(t[e]);return r}function p(t){if(u.is_little_endian)for(var r=new DataView(t.buffer),e=0,n=t.length;e<n;e++)r.setUint32(4*e,t[e]);return new Uint8Array(t.buffer)}e._convert_color=l,e._convert_palette=c,e._uint32_to_rgba=p;var f=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_ColorMapper=function(){this.define({palette:[i.Any],nan_color:[i.Color,"gray"]})},r.prototype.v_compute=function(t){var r=new Array(t.length);return this._v_compute(t,r,this.palette,this._colors((function(t){return t}))),r},Object.defineProperty(r.prototype,"rgba_mapper",{get:function(){var t=this,r=c(this.palette),e=this._colors(l);return{v_compute:function(n){var o=new Uint32Array(n.length);return t._v_compute(n,o,r,e),p(o)}}},enumerable:!0,configurable:!0}),r.prototype._colors=function(t){return{nan_color:t(this.nan_color)}},r}(o.Mapper);e.ColorMapper=f,f.__name__="ColorMapper",f.init_ColorMapper()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(1),o=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.prototype.compute=function(e){throw new Error("mapping single values is not supported")},n}(e(252).Transform);r.Mapper=o,o.__name__="Mapper"},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(1),_=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n}(e(196).Model);r.Transform=_,_.__name__="Transform"},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var a=r(1),i=r(249),n=r(251),c=a.__importStar(r(133)),o=function(r){function e(e){return r.call(this,e)||this}return a.__extends(e,r),e.init_CategoricalMarkerMapper=function(){this.define({factors:[c.Array],markers:[c.Array],start:[c.Number,0],end:[c.Number],default_value:[c.MarkerType,"circle"]})},e.prototype.v_compute=function(r){var e=new Array(r.length);return i.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e},e}(n.Mapper);t.CategoricalMarkerMapper=o,o.__name__="CategoricalMarkerMapper",o.init_CategoricalMarkerMapper()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var a=t(1),n=t(249),i=t(251),p=a.__importStar(t(133)),o=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_CategoricalPatternMapper=function(){this.define({factors:[p.Array],patterns:[p.Array],start:[p.Number,0],end:[p.Number],default_value:[p.HatchPatternType," "]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return n.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e},e}(i.Mapper);r.CategoricalPatternMapper=o,o.__name__="CategoricalPatternMapper",o.init_CategoricalPatternMapper()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),a=e(250),o=e(205),l=e(124),s=e(123),c=function(e){function t(t){var r=e.call(this,t)||this;return r._scan_data=null,r}return n.__extends(t,e),t.init_ContinuousColorMapper=function(){this.define((function(e){var t=e.Number,r=e.String,n=e.Null,a=e.Ref,l=e.Color,s=e.Or,c=e.Tuple,i=e.Array;return{high:[s(t,n),null],low:[s(t,n),null],high_color:[s(l,n),null],low_color:[s(l,n),null],domain:[i(c(a(o.GlyphRenderer),s(r,i(r)))),[]]}}))},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var r=function(){var e,r;try{for(var a=n.__values(t.domain),o=a.next();!o.done;o=a.next()){var l=n.__read(o.value,1)[0];t.connect(l.view.change,(function(){return t.update_data()})),t.connect(l.data_source.selected.change,(function(){return t.update_data()}))}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}};this.connect(this.properties.domain.change,(function(){return r()})),r()},t.prototype.update_data=function(){var e=this.domain,t=this.palette,r=n.__spread(this._collect(e));this._scan_data=this.scan(r,t.length),this.change.emit()},Object.defineProperty(t.prototype,"metrics",{get:function(){return null==this._scan_data&&this.update_data(),this._scan_data},enumerable:!0,configurable:!0}),t.prototype._collect=function(e){var t,r,a,o,c,i,u,_,h,d,p,f,v,g,y;return n.__generator(this,(function(b){switch(b.label){case 0:b.trys.push([0,11,12,13]),t=n.__values(e),r=t.next(),b.label=1;case 1:if(r.done)return[3,10];a=n.__read(r.value,2),o=a[0],c=a[1],i=function(e){var t,r,a,c,i,u,_,h,d,p;return n.__generator(this,(function(f){switch(f.label){case 0:if(t=o.data_source.get_column(e),t=o.view.indices.select(t),r=o.view.masked,a=o.data_source.selected.indices,c=void 0,null!=r&&a.length>0?c=l.intersection(n.__spread(r),a):null!=r?c=n.__spread(r):a.length>0&&(c=a),null!=c&&(t=l.map(c,(function(e){return t[e]}))),!(t.length>0)||s.isNumber(t[0]))return[3,9];f.label=1;case 1:f.trys.push([1,6,7,8]),d=void 0,i=n.__values(t),u=i.next(),f.label=2;case 2:return u.done?[3,5]:(_=u.value,[5,n.__values(_)]);case 3:f.sent(),f.label=4;case 4:return u=i.next(),[3,2];case 5:return[3,8];case 6:return h=f.sent(),d={error:h},[3,8];case 7:try{u&&!u.done&&(p=i.return)&&p.call(i)}finally{if(d)throw d.error}return[7];case 8:return[3,11];case 9:return[5,n.__values(t)];case 10:f.sent(),f.label=11;case 11:return[2]}}))},b.label=2;case 2:b.trys.push([2,7,8,9]),g=void 0,u=n.__values(s.isArray(c)?c:[c]),_=u.next(),b.label=3;case 3:return _.done?[3,6]:(h=_.value,[5,i(h)]);case 4:b.sent(),b.label=5;case 5:return _=u.next(),[3,3];case 6:return[3,9];case 7:return d=b.sent(),g={error:d},[3,9];case 8:try{_&&!_.done&&(y=u.return)&&y.call(u)}finally{if(g)throw g.error}return[7];case 9:return r=t.next(),[3,1];case 10:return[3,13];case 11:return p=b.sent(),f={error:p},[3,13];case 12:try{r&&!r.done&&(v=t.return)&&v.call(t)}finally{if(f)throw f.error}return[7];case 13:return[2]}}))},t.prototype._v_compute=function(e,t,r,a){var o=a.nan_color,s=a.low_color,c=a.high_color;null==s&&(s=r[0]),null==c&&(c=r[r.length-1]);var i=this.domain,u=l.is_empty(i)?e:n.__spread(this._collect(i));this._scan_data=this.scan(u,r.length);for(var _=0,h=e.length;_<h;_++){var d=e[_];isNaN(d)?t[_]=o:t[_]=this.cmap(d,r,s,c,this._scan_data)}},t.prototype._colors=function(t){return Object.assign(Object.assign({},e.prototype._colors.call(this,t)),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})},t}(a.ColorMapper);r.ContinuousColorMapper=c,c.__name__="ContinuousColorMapper",c.init_ContinuousColorMapper()},
function _(n,r,t){Object.defineProperty(t,"__esModule",{value:!0});var o=n(1),e=n(255),i=n(127),a=function(n){function r(r){return n.call(this,r)||this}return o.__extends(r,n),r.prototype.scan=function(n,r){var t=null!=this.low?this.low:i.min(n),o=null!=this.high?this.high:i.max(n);return{max:o,min:t,norm_factor:1/(o-t),normed_interval:1/r}},r.prototype.cmap=function(n,r,t,o,e){var i=r.length-1;if(n==e.max)return r[i];var a=(n-e.min)*e.norm_factor,l=Math.floor(a/e.normed_interval);return l<0?t:l>i?o:r[l]},r}(e.ContinuousColorMapper);t.LinearColorMapper=a,a.__name__="LinearColorMapper"},
function _(t,n,o){Object.defineProperty(o,"__esModule",{value:!0});var r=t(1),e=t(255),a=t(127),i=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.prototype.scan=function(t,n){var o=null!=this.low?this.low:a.min(t),r=null!=this.high?this.high:a.max(t);return{max:r,min:o,scale:n/(Math.log(r)-Math.log(o))}},n.prototype.cmap=function(t,n,o,r,e){var a=n.length-1;if(t>e.max)return r;if(t==e.max)return n[a];if(t<e.min)return o;var i=Math.log(t)-Math.log(e.min),l=Math.floor(i*e.scale);return l>a&&(l=a),n[l]},n}(e.ContinuousColorMapper);o.LogColorMapper=i,i.__name__="LogColorMapper"},
function _(n,e,i){Object.defineProperty(i,"__esModule",{value:!0});var t=n(1),o=n(255),r=n(127),u=function(n){function e(e){return n.call(this,e)||this}return t.__extends(e,n),e.prototype.cmap=function(n,e,i,t,o){return n<o.binning[0]?i:n>o.binning[o.binning.length-1]?t:e[r.left_edge_index(n,o.binning)]},e}(o.ContinuousColorMapper);i.ScanningColorMapper=u,u.__name__="ScanningColorMapper"},
function _(n,i,r){Object.defineProperty(r,"__esModule",{value:!0});var t=n(1),e=n(258),o=n(127),a=n(124),l=t.__importStar(n(133)),s=n(134),u=function(n){function i(i){return n.call(this,i)||this}return t.__extends(i,n),i.init_EqHistColorMapper=function(){this.define({bins:[l.Int,65536]})},i.prototype.scan=function(n,i){for(var r=null!=this.low?this.low:o.min(n),t=null!=this.high?this.high:o.max(n),e=this.bins,l=a.linspace(r,t,e+1),u=o.bin_counts(n,l),p=new Array(e),h=0,c=l.length;h<c-1;h++){var f=l[h],g=l[h+1];p[h]=(f+g)/2}for(var _=a.cumsum(u),m=_[_.length-1],v=o.map(_,(function(n){return n/m})),M=i-1,d=[],q=0,b=2*i;M!=i&&q<4&&0!=M;){var C=b/M;if(C>1e3)break;b=Math.round(Math.max(i*C,i));var H=a.range(0,b),w=o.map(v,(function(n){return n*(b-1)}));d=o.interpolate(H,w,p),M=a.uniq(d).length-1,q++}if(0==M){d=[r,t];for(var E=0;E<i-1;E++)d.push(t)}else d=d.slice(d.length-i-1),M!=i&&s.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");return{min:r,max:t,binning:d}},i}(e.ScanningColorMapper);r.EqHistColorMapper=u,u.__name__="EqHistColorMapper",u.init_EqHistColorMapper()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),r=t(261),_=i.__importStar(t(133)),o=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.init_LinearScale=function(){this.internal({scan_result:[_.Any]})},n.prototype.compute=function(t){return this._linear_compute(t)},n.prototype.v_compute=function(t){return this._linear_v_compute(t)},n.prototype.invert=function(t){return this._linear_invert(t)},n.prototype.v_invert=function(t){return this._linear_v_invert(t)},n}(r.ContinuousScale);e.LinearScale=o,o.__name__="LinearScale",o.init_LinearScale()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var u=e(1),o=function(e){function n(n){return e.call(this,n)||this}return u.__extends(n,e),n}(e(262).Scale);t.ContinuousScale=o,o.__name__="ContinuousScale"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),_=t(263),i=t(139),a=n.__importStar(t(133)),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Scale=function(){this.internal({source_range:[a.Any],target_range:[a.Any]})},e.prototype.r_compute=function(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]},e.prototype.r_invert=function(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]},e.prototype._linear_compute=function(t){var e=n.__read(this._linear_compute_state(),2);return e[0]*t+e[1]},e.prototype._linear_v_compute=function(t){for(var e=n.__read(this._linear_compute_state(),2),r=e[0],_=e[1],a=new i.NumberArray(t.length),o=0;o<t.length;o++)a[o]=r*t[o]+_;return a},e.prototype._linear_invert=function(t){var e=n.__read(this._linear_compute_state(),2),r=e[0];return(t-e[1])/r},e.prototype._linear_v_invert=function(t){for(var e=n.__read(this._linear_compute_state(),2),r=e[0],_=e[1],a=new i.NumberArray(t.length),o=0;o<t.length;o++)a[o]=(t[o]-_)/r;return a},e.prototype._linear_compute_state=function(){var t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]},e}(_.Transform);r.Scale=o,o.__name__="Scale",o.init_Scale()},
function _(r,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=r(264);t.CustomJSTransform=e.CustomJSTransform;var a=r(265);t.Dodge=a.Dodge;var n=r(267);t.Interpolator=n.Interpolator;var p=r(268);t.Jitter=p.Jitter;var l=r(269);t.LinearInterpolator=l.LinearInterpolator;var v=r(270);t.StepInterpolator=v.StepInterpolator;var s=r(252);t.Transform=s.Transform},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),o=t(252),s=n.__importStar(t(133)),i=t(128),a=t(144),u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_CustomJSTransform=function(){this.define({args:[s.Any,{}],func:[s.String,""],v_func:[s.String,""]})},Object.defineProperty(e.prototype,"names",{get:function(){return i.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"values",{get:function(){return i.values(this.args)},enumerable:!0,configurable:!0}),e.prototype._make_transform=function(t,e){return new(Function.bind.apply(Function,n.__spread([void 0],this.names,[t,a.use_strict(e)])))},Object.defineProperty(e.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!0,configurable:!0}),e.prototype.compute=function(t){return this.scalar_transform.apply(this,n.__spread(this.values,[t]))},e.prototype.v_compute=function(t){return this.vector_transform.apply(this,n.__spread(this.values,[t]))},e}(o.Transform);r.CustomJSTransform=u,u.__name__="CustomJSTransform",u.init_CustomJSTransform()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),o=e(266),r=i.__importStar(e(133)),u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Dodge=function(){this.define({value:[r.Number,0]})},t.prototype._compute=function(e){return e+this.value},t}(o.RangeTransform);n.Dodge=u,u.__name__="Dodge",u.init_Dodge()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(1),i=e(252),a=e(213),o=t.__importStar(e(133)),s=e(139),u=e(123),c=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_RangeTransform=function(){this.define({range:[o.Instance]})},n.prototype.v_compute=function(e){var n;if(this.range instanceof a.FactorRange)n=this.range.v_synthetic(e);else{if(!u.isArrayableOf(e,u.isNumber))throw new Error("unexpected");n=e}for(var r=new s.NumberArray(n.length),t=0;t<n.length;t++){var i=n[t];r[t]=this._compute(i)}return r},n.prototype.compute=function(e){if(this.range instanceof a.FactorRange)return this._compute(this.range.synthetic(e));if(u.isNumber(e))return this._compute(e);throw new Error("unexpected")},n}(i.Transform);r.RangeTransform=c,c.__name__="RangeTransform",c.init_RangeTransform()},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),o=t(252),i=n.__importStar(t(133)),a=t(139),s=t(124),h=t(123),d=function(t){function r(r){var e=t.call(this,r)||this;return e._sorted_dirty=!0,e}return n.__extends(r,t),r.init_Interpolator=function(){this.define({x:[i.Any],y:[i.Any],data:[i.Any],clip:[i.Boolean,!0]})},r.prototype.connect_signals=function(){var r=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return r._sorted_dirty=!0}))},r.prototype.v_compute=function(t){for(var r=new a.NumberArray(t.length),e=0;e<t.length;e++){var n=t[e];r[e]=this.compute(n)}return r},r.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var r,e;if(h.isString(this.x)&&h.isString(this.y)&&null!=this.data){var n=this.data.columns();if(!s.includes(n,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!s.includes(n,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");r=this.data.get_column(this.x),e=this.data.get_column(this.y)}else{if(!h.isArray(this.x)||!h.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");r=this.x,e=this.y}if(r.length!==e.length)throw new Error("The length for x and y do not match");if(r.length<2)throw new Error("x and y must have at least two elements to support interpolation");for(var o=r.length,i=new Uint32Array(o),d=0;d<o;d++)i[d]=d;var l=t?-1:1;i.sort((function(t,e){return l*(r[t]-r[e])})),this._x_sorted=new a.NumberArray(o),this._y_sorted=new a.NumberArray(o);for(d=0;d<o;d++)this._x_sorted[d]=r[i[d]],this._y_sorted[d]=e[i[d]];this._sorted_dirty=!1}},r}(o.Transform);e.Interpolator=d,d.__name__="Interpolator",d.init_Interpolator()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),n=t(266),o=r.__importStar(t(133)),u=r.__importStar(t(125)),s=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_Jitter=function(){this.define({mean:[o.Number,0],width:[o.Number,1],distribution:[o.Distribution,"uniform"]})},i.prototype.v_compute=function(i){return null!=this.previous_values&&this.previous_values.length==i.length||(this.previous_values=t.prototype.v_compute.call(this,i)),this.previous_values},i.prototype._compute=function(t){switch(this.distribution){case"uniform":return t+this.mean+(u.random()-.5)*this.width;case"normal":return t+u.rnorm(this.mean,this.width)}},i}(n.RangeTransform);e.Jitter=s,s.__name__="Jitter",s.init_Jitter()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var _=t(1),s=t(124),i=function(t){function e(e){return t.call(this,e)||this}return _.__extends(e,t),e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];var e=s.find_last_index(this._x_sorted,(function(e){return e<t})),r=this._x_sorted[e],_=this._x_sorted[e+1],i=this._y_sorted[e],o=this._y_sorted[e+1];return i+(t-r)/(_-r)*(o-i)},e}(t(267).Interpolator);r.LinearInterpolator=i,i.__name__="LinearInterpolator"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),i=t(267),o=n.__importStar(t(133)),s=t(124),_=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_StepInterpolator=function(){this.define({mode:[o.StepMode,"after"]})},e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var e;switch(this.mode){case"after":e=s.find_last_index(this._x_sorted,(function(e){return t>=e}));break;case"before":e=s.find_index(this._x_sorted,(function(e){return t<=e}));break;case"center":var r=this._x_sorted.map((function(e){return Math.abs(e-t)})),n=s.min(r);e=s.find_index(r,(function(t){return n===t}));break;default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN},e}(i.Interpolator);r.StepInterpolator=_,_.__name__="StepInterpolator",_.init_StepInterpolator()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),i=t(262),a=t(139),o=t(124),u=t(127),c=r.__importStar(t(133)),s=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_LinearInterpolationScale=function(){this.internal({binning:[c.Array]})},n.prototype.compute=function(t){return t},n.prototype.v_compute=function(t){var n=this,e=u.norm(t,this.source_range.start,this.source_range.end),r=o.linspace(0,1,this.binning.length),i=u.interpolate(e,r,this.binning),c=u.norm(i,this.source_range.start,this.source_range.end),s=this.target_range.end-this.target_range.start,_=u.map(c,(function(t){return n.target_range.start+t*s}));return new a.NumberArray(_)},n.prototype.invert=function(t){return t},n.prototype.v_invert=function(t){return new a.NumberArray(t)},n}(i.Scale);e.LinearInterpolationScale=s,s.__name__="LinearInterpolationScale",s.init_LinearInterpolationScale()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var a=t(1),o=t(261),n=t(139),_=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.prototype.compute=function(t){var e,r=a.__read(this._compute_state(),4),o=r[0],n=r[1],_=r[2],i=r[3];if(0==_)e=0;else{var h=(Math.log(t)-i)/_;e=isFinite(h)?h*o+n:NaN}return e},e.prototype.v_compute=function(t){var e=a.__read(this._compute_state(),4),r=e[0],o=e[1],_=e[2],i=e[3],h=new n.NumberArray(t.length);if(0==_)for(var u=0;u<t.length;u++)h[u]=0;else for(u=0;u<t.length;u++){var s=(Math.log(t[u])-i)/_,c=void 0;c=isFinite(s)?s*r+o:NaN,h[u]=c}return h},e.prototype.invert=function(t){var e=a.__read(this._compute_state(),4),r=e[0],o=e[1],n=e[2],_=e[3],i=(t-o)/r;return Math.exp(n*i+_)},e.prototype.v_invert=function(t){for(var e=a.__read(this._compute_state(),4),r=e[0],o=e[1],_=e[2],i=e[3],h=new n.NumberArray(t.length),u=0;u<t.length;u++){var s=(t[u]-o)/r;h[u]=Math.exp(_*s+i)}return h},e.prototype._get_safe_factor=function(t,e){var r,o=t<0?0:t,n=e<0?0:e;if(o==n)if(0==o)o=(r=a.__read([1,10],2))[0],n=r[1];else{var _=Math.log(o)/Math.log(10);o=Math.pow(10,Math.floor(_)),n=Math.ceil(_)!=Math.floor(_)?Math.pow(10,Math.ceil(_)):Math.pow(10,Math.ceil(_)+1)}return[o,n]},e.prototype._compute_state=function(){var t,e,r=this.source_range.start,o=this.source_range.end,n=this.target_range.start,_=this.target_range.end-n,i=a.__read(this._get_safe_factor(r,o),2),h=i[0],u=i[1];return 0==h?(t=Math.log(u),e=0):(t=Math.log(u)-Math.log(h),e=Math.log(h)),[_,n,t,e]},e}(o.ContinuousScale);r.LogScale=_,_.__name__="LogScale"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var n=t(1),i=t(214),r=n.__importStar(t(133)),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Range1d=function(){this.define({start:[r.Number,0],end:[r.Number,1],reset_start:[r.Number],reset_end:[r.Number]})},e.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this.reset_start,this.reset_end),e=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,e]},{silent:!0})}},e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),e.prototype.reset=function(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()},e}(i.Range);s.Range1d=a,a.__name__="Range1d",a.init_Range1d()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(187),l=new Map;n.measure_font=function(e){var t=l.get(e);if(null!=t)return t;var n=i.span({style:{font:e}},"Hg"),o=i.div({style:{display:"inline-block",width:"1px",height:"0px"}}),a=i.div({},n,o);document.body.appendChild(a);try{o.style.verticalAlign="baseline";var r=i.offset(o).top-i.offset(n).top;o.style.verticalAlign="bottom";var d=i.offset(o).top-i.offset(n).top,s={height:d,ascent:r,descent:d-r};return l.set(e,s),s}finally{document.body.removeChild(a)}};var o=new Map;n.measure_text=function(e,t){var n=o.get(t);if(null!=n){var l=n.get(e);if(null!=l)return l}else n=new Map,o.set(t,n);var a=i.div({style:{display:"inline-block","white-space":"nowrap",font:t}},e);document.body.appendChild(a);try{var r=a.getBoundingClientRect(),d=r.width,s=r.height;return n.set(e,{width:d,height:s}),{width:d,height:s}}finally{document.body.removeChild(a)}}},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),s=t(276),a=n.__importStar(t(143)),l=n.__importStar(t(133)),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.warm_cache()},e.prototype._get_size=function(){var t=this.layer.ctx;this.visuals.text.set_value(t);var e=t.measureText(this.model.text);return{width:e.width,height:e.ascent}},e.prototype._render=function(){var t;switch(this.model.angle_units){case"rad":t=-this.model.angle;break;case"deg":t=-this.model.angle*Math.PI/180}var e=null!=this.panel?this.panel:this.plot_view.frame,i=this.coordinates.x_scale,n=this.coordinates.y_scale,s="data"==this.model.x_units?i.compute(this.model.x):e.xview.compute(this.model.x),a="data"==this.model.y_units?n.compute(this.model.y):e.yview.compute(this.model.y);s+=this.model.x_offset,a-=this.model.y_offset,("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,s,a,t)},e}(s.TextAnnotationView);i.LabelView=o,o.__name__="LabelView";var r=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Label=function(){this.prototype.default_view=o,this.mixins([a.Text,["border_",a.Line],["background_",a.Fill]]),this.define({x:[l.Number],x_units:[l.SpatialUnits,"data"],y:[l.Number],y_units:[l.SpatialUnits,"data"],text:[l.String],angle:[l.Angle,0],angle_units:[l.AngleUnits,"rad"],x_offset:[l.Number,0],y_offset:[l.Number,0]}),this.override({background_fill_color:null,border_line_color:null})},e}(s.TextAnnotation);i.Label=r,r.__name__="Label",r.init_Label()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),n=t(151),o=t(187),a=s.__importStar(t(133)),l=t(274),r=t(126),u=function(t){function e(){var e=t.apply(this,s.__spread(arguments))||this;return e.rotate=!0,e}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),"css"==this.model.render_mode&&(this.el=o.div(),this.plot_view.canvas_view.add_overlay(this.el))},e.prototype.remove=function(){null!=this.el&&o.remove(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,(function(){return e.render()})):this.connect(this.model.change,(function(){return e.plot_view.request_render()}))},e.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),t.prototype.render.call(this)},e.prototype._calculate_text_dimensions=function(t,e){return[t.measureText(e).width,l.measure_font(this.visuals.text.font_value()).height]},e.prototype._calculate_bounding_box_dimensions=function(t,e){var i,n,o=s.__read(this._calculate_text_dimensions(t,e),2),a=o[0],l=o[1];switch(t.textAlign){case"left":i=0;break;case"center":i=-a/2;break;case"right":i=-a;break;default:r.unreachable()}switch(t.textBaseline){case"top":n=0;break;case"middle":n=-.5*l;break;case"bottom":n=-1*l;break;case"alphabetic":n=-.8*l;break;case"hanging":n=-.17*l;break;case"ideographic":n=-.83*l;break;default:r.unreachable()}return[i,n,a,l]},e.prototype._canvas_text=function(t,e,i,s,n){this.visuals.text.set_value(t);var o=this._calculate_bounding_box_dimensions(t,e);t.save(),t.beginPath(),t.translate(i,s),n&&t.rotate(n),t.rect(o[0],o[1],o[2],o[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(t),t.fillText(e,0,0)),t.restore()},e.prototype._css_text=function(t,e,i,s,n){var a=this.el;r.assert(null!=a),o.undisplay(a),this.visuals.text.set_value(t);var l=this._calculate_bounding_box_dimensions(t,e),u=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_value(t),this.visuals.background_fill.set_value(t),a.style.position="absolute",a.style.left=i+l[0]+"px",a.style.top=s+l[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",n&&(a.style.transform="rotate("+n+"rad)"),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+u,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),a.textContent=e,o.display(a)},e}(n.AnnotationView);i.TextAnnotationView=u,u.__name__="TextAnnotationView";var _=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_TextAnnotation=function(){this.define({render_mode:[a.RenderMode,"canvas"]})},e}(n.Annotation);i.TextAnnotation=_,_.__name__="TextAnnotation",_.init_TextAnnotation()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),o=t(276),n=t(200),l=s.__importStar(t(143)),r=t(187),a=s.__importStar(t(133)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){if(t.prototype.initialize.call(this),this.set_data(this.model.source),"css"==this.model.render_mode)for(var e=0,i=this._text.length;e<i;e++){var s=r.div({style:{display:"none"}});this.el.appendChild(s)}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.streaming,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.patching,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.change,(function(){e.set_data(e.model.source),e.render()}))):(this.connect(this.model.change,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.streaming,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.patching,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.change,(function(){e.set_data(e.model.source),e.plot_view.request_render()})))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e)},e.prototype._map_data=function(){var t=this.coordinates.x_scale,e=this.coordinates.y_scale,i=null!=this.panel?this.panel:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):i.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):i.yview.v_compute(this._y)]},e.prototype._render=function(){for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.layer.ctx,i=s.__read(this._map_data(),2),o=i[0],n=i[1],l=0,r=this._text.length;l<r;l++)t(e,l,this._text[l],o[l]+this._x_offset[l],n[l]-this._y_offset[l],this._angle[l])},e.prototype._get_size=function(){var t=this.layer.ctx;this.visuals.text.set_value(t);var e=t.measureText(this._text[0]);return{width:e.width,height:e.ascent}},e.prototype._v_canvas_text=function(t,e,i,s,o,n){this.visuals.text.set_vectorize(t,e);var l=this._calculate_bounding_box_dimensions(t,i);t.save(),t.beginPath(),t.translate(s,o),t.rotate(n),t.rect(l[0],l[1],l[2],l[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(i,0,0)),t.restore()},e.prototype._v_css_text=function(t,e,i,s,o,n){var l=this.el.children[e];l.textContent=i,this.visuals.text.set_vectorize(t,e);var a=this._calculate_bounding_box_dimensions(t,i),_=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),l.style.position="absolute",l.style.left=s+a[0]+"px",l.style.top=o+a[1]+"px",l.style.color=""+this.visuals.text.text_color.value(),l.style.opacity=""+this.visuals.text.text_alpha.value(),l.style.font=""+this.visuals.text.font_value(),l.style.lineHeight="normal",n&&(l.style.transform="rotate("+n+"rad)"),this.visuals.background_fill.doit&&(l.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(l.style.borderStyle=""+_,l.style.borderWidth=this.visuals.border_line.line_width.value()+"px",l.style.borderColor=""+this.visuals.border_line.color_value()),r.display(l)},e}(o.TextAnnotationView);i.LabelSetView=_,_.__name__="LabelSetView";var c=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_LabelSet=function(){this.prototype.default_view=_,this.mixins([l.TextVector,["border_",l.LineVector],["background_",l.FillVector]]),this.define({x:[a.NumberSpec],y:[a.NumberSpec],x_units:[a.SpatialUnits,"data"],y_units:[a.SpatialUnits,"data"],text:[a.StringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,{value:0}],y_offset:[a.NumberSpec,{value:0}],source:[a.Instance,function(){return new n.ColumnDataSource}]}),this.override({background_fill_color:null,border_line_color:null})},e}(o.TextAnnotation);i.LabelSet=c,c.__name__="LabelSet",c.init_LabelSet()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),l=e(151),n=r.__importStar(e(143)),a=r.__importStar(e(133)),o=e(130),_=e(274),s=e(194),h=e(124),d=e(123),c=e(126),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.cursor=function(e,t){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(t.prototype,"legend_padding",{get:function(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0},enumerable:!0,configurable:!0}),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.plot_view.request_render()})),this.connect(this.model.item_change,(function(){return t.plot_view.request_render()}))},t.prototype.compute_legend_bbox=function(){var e,t,i,l,n=this.model.get_legend_names(),a=this.model,o=a.glyph_height,u=a.glyph_width,f=this.model,v=f.label_height,g=f.label_width;this.max_label_height=h.max([_.measure_font(this.visuals.label_text.font_value()).height,v,o]);var m=this.layer.ctx;m.save(),this.visuals.label_text.set_value(m),this.text_widths=new Map;try{for(var p=r.__values(n),b=p.next();!b.done;b=p.next()){var x=b.value;this.text_widths.set(x,h.max([m.measureText(x).width,g]))}}catch(t){e={error:t}}finally{try{b&&!b.done&&(t=p.return)&&t.call(p)}finally{if(e)throw e.error}}this.visuals.title_text.set_value(m),this.title_height=this.model.title?_.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?m.measureText(this.model.title).width:0,m.restore();var y,w,k=Math.max(h.max(r.__spread(this.text_widths.values())),0),N=this.model.margin,L=this.legend_padding,A=this.model.spacing,T=this.model.label_standoff;if("vertical"==this.model.orientation)y=n.length*this.max_label_height+Math.max(n.length-1,0)*A+2*L+this.title_height,w=h.max([k+u+T+2*L,this.title_width+2*L]);else{var z=2*L+Math.max(n.length-1,0)*A;try{for(var M=r.__values(this.text_widths),S=M.next();!S.done;S=M.next()){var B=r.__read(S.value,2)[1];z+=h.max([B,g])+u+T}}catch(e){i={error:e}}finally{try{S&&!S.done&&(l=M.return)&&l.call(M)}finally{if(i)throw i.error}}w=h.max([this.title_width+2*L,z]),y=this.max_label_height+this.title_height+2*L}var P,O,V=null!=this.panel?this.panel:this.plot_view.frame,j=r.__read(V.bbox.ranges,2),q=j[0],F=j[1],C=this.model.location;if(d.isString(C))switch(C){case"top_left":P=q.start+N,O=F.start+N;break;case"top_center":P=(q.end+q.start)/2-w/2,O=F.start+N;break;case"top_right":P=q.end-N-w,O=F.start+N;break;case"bottom_right":P=q.end-N-w,O=F.end-N-y;break;case"bottom_center":P=(q.end+q.start)/2-w/2,O=F.end-N-y;break;case"bottom_left":P=q.start+N,O=F.end-N-y;break;case"center_left":P=q.start+N,O=(F.end+F.start)/2-y/2;break;case"center":P=(q.end+q.start)/2-w/2,O=(F.end+F.start)/2-y/2;break;case"center_right":P=q.end-N-w,O=(F.end+F.start)/2-y/2}else if(d.isArray(C)&&2==C.length){var D=r.__read(C,2),E=D[0],G=D[1];P=V.xview.compute(E),O=V.yview.compute(G)-y}else c.unreachable();return new s.BBox({left:P,top:O,width:w,height:y})},t.prototype.interactive_bbox=function(){return this.compute_legend_bbox()},t.prototype.interactive_hit=function(e,t){return this.interactive_bbox().contains(e,t)},t.prototype.on_hit=function(e,t){var i,l,n,a,o,_,h,d,c,u,f,v=this.model.glyph_width,g=this.legend_padding,m=this.model.spacing,p=this.model.label_standoff,b=f=g,x=this.compute_legend_bbox(),y="vertical"==this.model.orientation;try{for(var w=r.__values(this.model.items),k=w.next();!k.done;k=w.next()){var N=k.value,L=N.get_labels_list_from_label_prop();try{for(var A=(n=void 0,r.__values(L)),T=A.next();!T.done;T=A.next()){var z=T.value,M=x.x+b,S=x.y+f+this.title_height,B=void 0,P=void 0;if(y?(B=(o=r.__read([x.width-2*g,this.max_label_height],2))[0],P=o[1]):(B=(_=r.__read([this.text_widths.get(z)+v+p,this.max_label_height],2))[0],P=_[1]),new s.BBox({left:M,top:S,width:B,height:P}).contains(e,t)){switch(this.model.click_policy){case"hide":try{for(var O=(h=void 0,r.__values(N.renderers)),V=O.next();!V.done;V=O.next()){(F=V.value).visible=!F.visible}}catch(e){h={error:e}}finally{try{V&&!V.done&&(d=O.return)&&d.call(O)}finally{if(h)throw h.error}}break;case"mute":try{for(var j=(c=void 0,r.__values(N.renderers)),q=j.next();!q.done;q=j.next()){var F;(F=q.value).muted=!F.muted}}catch(e){c={error:e}}finally{try{q&&!q.done&&(u=j.return)&&u.call(j)}finally{if(c)throw c.error}}}return!0}y?f+=this.max_label_height+m:b+=this.text_widths.get(z)+v+p+m}}catch(e){n={error:e}}finally{try{T&&!T.done&&(a=A.return)&&a.call(A)}finally{if(n)throw n.error}}}}catch(e){i={error:e}}finally{try{k&&!k.done&&(l=w.return)&&l.call(w)}finally{if(i)throw i.error}}return!1},t.prototype._render=function(){var e,t;if(0!=this.model.items.length){try{for(var i=r.__values(this.model.items),l=i.next();!l.done;l=i.next()){l.value.legend=this.model}}catch(t){e={error:t}}finally{try{l&&!l.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}var n=this.layer.ctx,a=this.compute_legend_bbox();n.save(),this._draw_legend_box(n,a),this._draw_legend_items(n,a),this.model.title&&this._draw_title(n,a),n.restore()}},t.prototype._draw_legend_box=function(e,t){e.beginPath(),e.rect(t.x,t.y,t.width,t.height),this.visuals.background_fill.set_value(e),e.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),e.stroke())},t.prototype._draw_legend_items=function(e,t){var i,l,n=this,a=this.model,o=a.glyph_width,_=a.glyph_height,s=this.legend_padding,d=this.model.spacing,c=this.model.label_standoff,u=s,f=s,v="vertical"==this.model.orientation,g=function(i){var l,a,g,p,b,x,y=i.get_labels_list_from_label_prop(),w=i.get_field_from_label_prop();if(0==y.length)return"continue";var k=function(){switch(n.model.click_policy){case"none":return!0;case"hide":return h.every(i.renderers,(function(e){return e.visible}));case"mute":return h.every(i.renderers,(function(e){return!e.muted}))}}();try{for(var N=(l=void 0,r.__values(y)),L=N.next();!L.done;L=N.next()){var A=L.value,T=t.x+u,z=t.y+f+m.title_height,M=T+o,S=z+_;v?f+=m.max_label_height+d:u+=m.text_widths.get(A)+o+c+d,m.visuals.label_text.set_value(e),e.fillText(A,M+c,z+m.max_label_height/2);try{for(var B=(g=void 0,r.__values(i.renderers)),P=B.next();!P.done;P=B.next()){var O=P.value;m.plot_view.renderer_views.get(O).draw_legend(e,T,M,z,S,w,A,i.index)}}catch(e){g={error:e}}finally{try{P&&!P.done&&(p=B.return)&&p.call(B)}finally{if(g)throw g.error}}if(!k){var V=void 0,j=void 0;v?(V=(b=r.__read([t.width-2*s,m.max_label_height],2))[0],j=b[1]):(V=(x=r.__read([m.text_widths.get(A)+o+c,m.max_label_height],2))[0],j=x[1]),e.beginPath(),e.rect(T,z,V,j),m.visuals.inactive_fill.set_value(e),e.fill()}}}catch(e){l={error:e}}finally{try{L&&!L.done&&(a=N.return)&&a.call(N)}finally{if(l)throw l.error}}},m=this;try{for(var p=r.__values(this.model.items),b=p.next();!b.done;b=p.next()){g(b.value)}}catch(e){i={error:e}}finally{try{b&&!b.done&&(l=p.return)&&l.call(p)}finally{if(i)throw i.error}}},t.prototype._draw_title=function(e,t){this.visuals.title_text.doit&&(e.save(),e.translate(t.x0,t.y0+this.title_height),this.visuals.title_text.set_value(e),e.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),e.restore())},t.prototype._get_size=function(){var e=this.compute_legend_bbox(),t=e.width,i=e.height;return{width:t+2*this.model.margin,height:i+2*this.model.margin}},t}(l.AnnotationView);i.LegendView=u,u.__name__="LegendView";var f=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.item_change=new o.Signal0(this,"item_change")},t.init_Legend=function(){this.prototype.default_view=u,this.mixins([["label_",n.Text],["title_",n.Text],["inactive_",n.Fill],["border_",n.Line],["background_",n.Fill]]),this.define({orientation:[a.Orientation,"vertical"],location:[a.Any,"top_right"],title:[a.String],title_standoff:[a.Number,5],label_standoff:[a.Number,5],glyph_height:[a.Number,20],glyph_width:[a.Number,20],label_height:[a.Number,20],label_width:[a.Number,20],margin:[a.Number,10],padding:[a.Number,10],spacing:[a.Number,3],items:[a.Array,[]],click_policy:[a.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},t.prototype.get_legend_names=function(){var e,t,i=[];try{for(var l=r.__values(this.items),n=l.next();!n.done;n=l.next()){var a=n.value.get_labels_list_from_label_prop();i.push.apply(i,r.__spread(a))}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=l.return)&&t.call(l)}finally{if(e)throw e.error}}return i},t}(l.Annotation);i.Legend=f,f.__name__="Legend",f.init_Legend()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(1),l=e(196),i=e(201),o=e(280),a=t.__importStar(e(133)),_=e(134),u=e(124),s=function(e){function r(r){return e.call(this,r)||this}return t.__extends(r,e),r.init_LegendItem=function(){this.define({label:[a.StringSpec,null],renderers:[a.Array,[]],index:[a.Number,null]})},r.prototype._check_data_sources_on_renderers=function(){var e,r;if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;var n=this.renderers[0].data_source;if(null!=n)try{for(var l=t.__values(this.renderers),i=l.next();!i.done;i=l.next()){if(i.value.data_source!=n)return!1}}catch(r){e={error:r}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(e)throw e.error}}}return!0},r.prototype._check_field_label_on_data_source=function(){var e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;var r=this.renderers[0].data_source;if(null!=r&&!u.includes(r.columns(),e))return!1}return!0},r.prototype.initialize=function(){var r=this;e.prototype.initialize.call(this),this.legend=null,this.connect(this.change,(function(){var e;return null===(e=r.legend)||void 0===e?void 0:e.item_change.emit()})),this._check_data_sources_on_renderers()||_.logger.error("Non matching data sources on legend item renderers"),this._check_field_label_on_data_source()||_.logger.error("Bad column name on label: "+this.label)},r.prototype.get_field_from_label_prop=function(){var e=this.label;return o.isField(e)?e.field:null},r.prototype.get_labels_list_from_label_prop=function(){if(o.isValue(this.label)){var e=this.label.value;return null!=e?[e]:[]}var r=this.get_field_from_label_prop();if(null!=r){var n=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((n=this.renderers[0].data_source)instanceof i.ColumnarDataSource){var t=n.get_column(r);return null!=t?u.uniq(Array.from(t)):["Invalid field"]}}return[]},r}(l.Model);n.LegendItem=s,s.__name__="LegendItem",s.init_LegendItem()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(123);n.isValue=function(e){return t.isPlainObject(e)&&"value"in e},n.isField=function(e){return t.isPlainObject(e)&&"field"in e}},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),o=t(151),s=n.__importStar(t(143)),l=t(130),a=n.__importStar(t(133)),r=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return i.plot_view.request_render()})),this.connect(this.model.data_update,(function(){return i.plot_view.request_render()}))},i.prototype._render=function(){var t=this.model,i=t.xs,e=t.ys;if(i.length==e.length&&!(i.length<3||e.length<3)){for(var n=this.plot_view.frame,o=this.layer.ctx,s=0,l=i.length;s<l;s++){var a=void 0;if("screen"!=this.model.xs_units)throw new Error("not implemented");a=this.model.screen?i[s]:n.xview.compute(i[s]);var r=void 0;if("screen"!=this.model.ys_units)throw new Error("not implemented");r=this.model.screen?e[s]:n.yview.compute(e[s]),0==s?(o.beginPath(),o.moveTo(a,r)):o.lineTo(a,r)}o.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(o),o.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(o),o.fill())}},i}(o.AnnotationView);e.PolyAnnotationView=r,r.__name__="PolyAnnotationView";var _=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_PolyAnnotation=function(){this.prototype.default_view=r,this.mixins([s.Line,s.Fill]),this.define({xs:[a.Array,[]],xs_units:[a.SpatialUnits,"data"],ys:[a.Array,[]],ys_units:[a.SpatialUnits,"data"]}),this.internal({screen:[a.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new l.Signal0(this,"data_update")},i.prototype.update=function(t){var i=t.xs,e=t.ys;this.setv({xs:i,ys:e,screen:!0},{silent:!0}),this.data_update.emit()},i}(o.Annotation);e.PolyAnnotation=_,_.__name__="PolyAnnotation",_.init_PolyAnnotation()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),o=t(151),r=n.__importStar(t(143)),l=n.__importStar(t(133)),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.plot_view.request_render()}))},e.prototype._render=function(){var t=this.model.gradient,e=this.model.y_intercept;if(null!=t&&null!=e){var i=this.plot_view.frame,n=this.coordinates.x_scale,o=this.coordinates.y_scale,r=i.bbox.top,l=r+i.bbox.height,s=(o.invert(r)-e)/t,a=(o.invert(l)-e)/t,_=n.compute(s),c=n.compute(a),p=this.layer.ctx;p.save(),p.beginPath(),this.visuals.line.set_value(p),p.moveTo(_,r),p.lineTo(c,l),p.stroke(),p.restore()}},e}(o.AnnotationView);i.SlopeView=s,s.__name__="SlopeView";var a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Slope=function(){this.prototype.default_view=s,this.mixins(r.Line),this.define({gradient:[l.Number,null],y_intercept:[l.Number,null]}),this.override({line_color:"black"})},e}(o.Annotation);i.Slope=a,a.__name__="Slope",a.init_Slope()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),o=t(151),a=n.__importStar(t(143)),r=n.__importStar(t(133)),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.plot_view.request_paint(e)}))},e.prototype._render=function(){var t=this,e=this.model.location;if(null!=e){var i,n,o,a,r=this.plot_view.frame,s=this.coordinates.x_scale,l=this.coordinates.y_scale,_=function(i,n){return"data"==t.model.location_units?i.compute(e):t.model.for_hover?e:n.compute(e)};"width"==this.model.dimension?(o=_(l,r.yview),n=r.bbox.left,a=r.bbox.width,i=this.model.properties.line_width.value()):(o=r.bbox.top,n=_(s,r.xview),a=this.model.properties.line_width.value(),i=r.bbox.height);var h=this.layer.ctx;h.save(),h.beginPath(),this.visuals.line.set_value(h),h.moveTo(n,o),"width"==this.model.dimension?h.lineTo(n+a,o):h.lineTo(n,o+i),h.stroke(),h.restore()}},e}(o.AnnotationView);i.SpanView=s,s.__name__="SpanView";var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Span=function(){this.prototype.default_view=s,this.mixins(a.Line),this.define({render_mode:[r.RenderMode,"canvas"],location:[r.Number,null],location_units:[r.SpatialUnits,"data"],dimension:[r.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[r.Boolean,!1]})},e}(o.Annotation);i.Span=l,l.__name__="Span",l.init_Span()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var l=t(1),a=t(276),n=t(189),r=l.__importStar(t(143)),o=l.__importStar(t(133)),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.visuals.text=new n.Text(this.model)},e.prototype._get_location=function(){var t,e,i=this.panel,l=this.model.offset,a=i.bbox;switch(i.side){case"above":case"below":switch(this.model.vertical_align){case"top":e=a.top+5;break;case"middle":e=a.vcenter;break;case"bottom":e=a.bottom-5}switch(this.model.align){case"left":t=a.left+l;break;case"center":t=a.hcenter;break;case"right":t=a.right-l}break;case"left":switch(this.model.vertical_align){case"top":t=a.left-5;break;case"middle":t=a.hcenter;break;case"bottom":t=a.right+5}switch(this.model.align){case"left":e=a.bottom-l;break;case"center":e=a.vcenter;break;case"right":e=a.top+l}break;case"right":switch(this.model.vertical_align){case"top":t=a.right-5;break;case"middle":t=a.hcenter;break;case"bottom":t=a.left+5}switch(this.model.align){case"left":e=a.top+l;break;case"center":e=a.vcenter;break;case"right":e=a.bottom-l}}return[t,e]},e.prototype._render=function(){var t=this.model.text;if(null!=t&&0!=t.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var e=l.__read(this._get_location(),2),i=e[0],a=e[1],n=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,i,a,n)}},e.prototype._get_size=function(){var t=this.model.text;if(null==t||0==t.length)return{width:0,height:0};this.visuals.text.set_value(this.layer.ctx);var e=this.layer.ctx.measureText(t);return{width:e.width,height:e.ascent*this.visuals.text.text_line_height.value()+10}},e}(a.TextAnnotationView);i.TitleView=s,s.__name__="TitleView";var c=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.init_Title=function(){this.prototype.default_view=s,this.mixins([["border_",r.Line],["background_",r.Fill]]),this.define({text:[o.String],text_font:[o.Font,"helvetica"],text_font_size:[o.StringSpec,"13px"],text_font_style:[o.FontStyle,"bold"],text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],text_line_height:[o.Number,1],vertical_align:[o.VerticalAlign,"bottom"],align:[o.TextAlign,"left"],offset:[o.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"]})},e}(a.TextAnnotation);i.Title=c,c.__name__="Title",c.init_Title()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),n=t(151),l=t(230),r=t(187),a=t(194),s=o.__importStar(t(133)),_=function(t){function e(){var e=t.apply(this,o.__spread(arguments))||this;return e.rotate=!0,e._invalidate_toolbar=!0,e._previous_bbox=new a.BBox,e}return o.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=r.div(),this.plot_view.canvas_view.add_event(this.el)},e.prototype.lazy_initialize=function(){return o.__awaiter(this,void 0,void 0,(function(){var t,e=this;return o.__generator(this,(function(i){switch(i.label){case 0:return t=this,[4,l.build_view(this.model.toolbar,{parent:this})];case 1:return t._toolbar_view=i.sent(),this.plot_view.visibility_callbacks.push((function(t){return e._toolbar_view.set_visibility(t)})),[2]}}))}))},e.prototype.remove=function(){this._toolbar_view.remove(),r.remove(this.el),t.prototype.remove.call(this)},e.prototype.render=function(){this.model.visible||r.undisplay(this.el),t.prototype.render.call(this)},e.prototype._render=function(){var t=this.panel.bbox;this._previous_bbox.equals(t)||(r.position(this.el,t),this._previous_bbox=t),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",this._toolbar_view.render(),r.empty(this.el),this.el.appendChild(this._toolbar_view.el),this._invalidate_toolbar=!1),r.display(this.el)},e.prototype._get_size=function(){var t=this.model.toolbar,e=t.tools,i=t.logo;return{width:30*e.length+(null!=i?25:0),height:30}},e}(n.AnnotationView);i.ToolbarPanelView=_,_.__name__="ToolbarPanelView";var h=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_ToolbarPanel=function(){this.prototype.default_view=_,this.define({toolbar:[s.Instance]})},e}(n.Annotation);i.ToolbarPanel=h,h.__name__="ToolbarPanel",h.init_ToolbarPanel()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),l=t(151),s=t(187),n=o.__importStar(t(133)),r=t(287),a=t(288),h=o.__importDefault(t(289)),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=s.div({class:r.bk_tooltip}),s.undisplay(this.el),this.plot_view.canvas_view.add_overlay(this.el)},e.prototype.remove=function(){s.remove(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.content.change,(function(){return e.render()})),this.connect(this.model.properties.position.change,(function(){return e._reposition()}))},e.prototype.styles=function(){return o.__spread(t.prototype.styles.call(this),[h.default])},e.prototype.render=function(){this.model.visible||s.undisplay(this.el),t.prototype.render.call(this)},e.prototype._render=function(){var t=this.model.content;null!=t?(s.empty(this.el),s.classes(this.el).toggle(r.bk_tooltip_custom,this.model.custom),this.el.appendChild(t),this.model.show_arrow&&this.el.classList.add(r.bk_tooltip_arrow)):s.undisplay(this.el)},e.prototype._reposition=function(){var t=this,e=this.model.position;if(null!=e){var i,l=o.__read(e,2),n=l[0],r=l[1],h=function(){var e=t.parent.layout.bbox.relativize(),i=t.model.attachment;switch(i){case"horizontal":return n<e.hcenter?"right":"left";case"vertical":return r<e.vcenter?"below":"above";default:return i}}();this.el.classList.remove(a.bk_right),this.el.classList.remove(a.bk_left),this.el.classList.remove(a.bk_above),this.el.classList.remove(a.bk_below),s.display(this.el);var c=null,p=null;switch(h){case"right":this.el.classList.add(a.bk_left),c=n+(this.el.offsetWidth-this.el.clientWidth)+10,i=r-this.el.offsetHeight/2;break;case"left":this.el.classList.add(a.bk_right),p=this.plot_view.layout.bbox.width-n+10,i=r-this.el.offsetHeight/2;break;case"below":this.el.classList.add(a.bk_above),i=r+(this.el.offsetHeight-this.el.clientHeight)+10,c=Math.round(n-this.el.offsetWidth/2);break;case"above":this.el.classList.add(a.bk_below),i=r-this.el.offsetHeight-10,c=Math.round(n-this.el.offsetWidth/2)}this.el.style.top=i+"px",this.el.style.left=null!=c?c+"px":"auto",this.el.style.right=null!=p?p+"px":"auto"}else s.undisplay(this.el)},e}(l.AnnotationView);i.TooltipView=c,c.__name__="TooltipView";var p=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Tooltip=function(){this.prototype.default_view=c,this.define({attachment:[n.TooltipAttachment,"horizontal"],inner_only:[n.Boolean,!0],show_arrow:[n.Boolean,!0]}),this.override({level:"overlay"}),this.internal({position:[n.Any,null],content:[n.Any,function(){return s.div()}],custom:[n.Any]})},e.prototype.clear=function(){this.position=null},e}(l.Annotation);i.Tooltip=p,p.__name__="Tooltip",p.init_Tooltip()},
function _(o,t,l){Object.defineProperty(l,"__esModule",{value:!0}),l.bk_tooltip="bk-tooltip",l.bk_tooltip_arrow="bk-tooltip-arrow",l.bk_tooltip_custom="bk-tooltip-custom",l.bk_tooltip_row_label="bk-tooltip-row-label",l.bk_tooltip_row_value="bk-tooltip-row-value",l.bk_tooltip_color_block="bk-tooltip-color-block"},
function _(e,b,k){Object.defineProperty(k,"__esModule",{value:!0}),k.bk_active="bk-active",k.bk_inline="bk-inline",k.bk_left="bk-left",k.bk_right="bk-right",k.bk_above="bk-above",k.bk_below="bk-below",k.bk_up="bk-up",k.bk_down="bk-down",k.bk_side=function(e){switch(e){case"above":return k.bk_above;case"below":return k.bk_below;case"left":return k.bk_left;case"right":return k.bk_right}}},
function _(o,n,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),s=e(238),n=e(199),o=e(143),h=i.__importStar(e(133)),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.patching,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.change,(function(){return t.set_data(t.model.source)}))},t.prototype._render=function(){this._map_data();var e=this.layer.ctx;if(this.visuals.line.doit)for(var t=0,r=this._lower_sx.length;t<r;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();var i="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(t=0,r=this._lower_sx.length;t<r;t++)e.save(),e.translate(this._lower_sx[t],this._lower_sy[t]),e.rotate(i+Math.PI),this.model.lower_head.render(e,t),e.restore();if(null!=this.model.upper_head)for(t=0,r=this._upper_sx.length;t<r;t++)e.save(),e.translate(this._upper_sx[t],this._upper_sy[t]),e.rotate(i),this.model.upper_head.render(e,t),e.restore()},t}(s.UpperLowerView);r.WhiskerView=_,_.__name__="WhiskerView";var l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Whisker=function(){this.prototype.default_view=_,this.mixins(o.LineVector),this.define({lower_head:[h.Instance,function(){return new n.TeeHead({level:"underlay",size:10})}],upper_head:[h.Instance,function(){return new n.TeeHead({level:"underlay",size:10})}]}),this.override({level:"underlay"})},t}(s.UpperLower);r.Whisker=l,l.__name__="Whisker",l.init_Whisker()},
function _(i,a,e){Object.defineProperty(e,"__esModule",{value:!0});var r=i(292);e.Axis=r.Axis;var s=i(294);e.CategoricalAxis=s.CategoricalAxis;var x=i(297);e.ContinuousAxis=x.ContinuousAxis;var A=i(298);e.DatetimeAxis=A.DatetimeAxis;var o=i(299);e.LinearAxis=o.LinearAxis;var t=i(312);e.LogAxis=t.LogAxis;var n=i(315);e.MercatorAxis=n.MercatorAxis},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),a=e(293),o=r.__importStar(e(143)),n=r.__importStar(e(133)),s=e(124),l=e(123),_=e(213),h=Math.abs,c=Math.min,d=Math.max,u=function(e){function t(){var t=e.apply(this,r.__spread(arguments))||this;return t.rotate=!0,t}return r.__extends(t,e),Object.defineProperty(t.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_renderable",{get:function(){var e=r.__read(this.ranges,2),t=e[0],i=e[1];return t.is_valid&&i.is_valid},enumerable:!0,configurable:!0}),t.prototype._render=function(){var e;if(this.is_renderable){var t={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},i=this.tick_coords,r=this.layer.ctx;r.save(),this._draw_rule(r,t),this._draw_major_ticks(r,t,i),this._draw_minor_ticks(r,t,i),this._draw_major_labels(r,t,i),this._draw_axis_label(r,t,i),null===(e=this._paint)||void 0===e||e.call(this,r,t,i),r.restore()}},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.plot_view.request_layout()}))},t.prototype.get_size=function(){if(this.model.visible&&null==this.model.fixed_location&&this.is_renderable){var e=this._get_size();return{width:0,height:Math.round(e)}}return{width:0,height:0}},t.prototype._get_size=function(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!0,configurable:!0}),t.prototype._draw_rule=function(e,t){if(this.visuals.axis_line.doit){var i=r.__read(this.rule_coords,2),a=i[0],o=i[1],n=r.__read(this.coordinates.map_to_screen(a,o),2),s=n[0],l=n[1],_=r.__read(this.normals,2),h=_[0],c=_[1],d=r.__read(this.offsets,2),u=d[0],b=d[1];this.visuals.axis_line.set_value(e),e.beginPath(),e.moveTo(Math.round(s[0]+h*u),Math.round(l[0]+c*b));for(var m=1;m<s.length;m++){var p=Math.round(s[m]+h*u),f=Math.round(l[m]+c*b);e.lineTo(p,f)}e.stroke()}},t.prototype._draw_major_ticks=function(e,t,i){var r=this.model.major_tick_in,a=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(e,i.major,r,a,o)},t.prototype._draw_minor_ticks=function(e,t,i){var r=this.model.minor_tick_in,a=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(e,i.minor,r,a,o)},t.prototype._draw_major_labels=function(e,t,i){var r=i.major,a=this.compute_labels(r[this.dimension]),o=this.model.major_label_orientation,n=t.tick+this.model.major_label_standoff,s=this.visuals.major_label_text;this._draw_oriented_labels(e,a,r,o,this.panel.side,n,s)},t.prototype._draw_axis_label=function(e,t,i){if(null!=this.model.axis_label&&0!=this.model.axis_label.length&&null==this.model.fixed_location){var r,a,o=this.panel.bbox;switch(this.panel.side){case"above":r=o.hcenter,a=o.bottom;break;case"below":r=o.hcenter,a=o.top;break;case"left":r=o.right,a=o.vcenter;break;case"right":r=o.left,a=o.vcenter;break;default:throw new Error("unknown side: "+this.panel.side)}var n=[[r],[a]],l=t.tick+s.sum(t.tick_label)+this.model.axis_label_standoff,_=this.visuals.axis_label_text;this._draw_oriented_labels(e,[this.model.axis_label],n,"parallel",this.panel.side,l,_,"screen")}},t.prototype._draw_ticks=function(e,t,i,a,o){if(o.doit){var n=r.__read(t,2),s=n[0],l=n[1],_=r.__read(this.coordinates.map_to_screen(s,l),2),h=_[0],c=_[1],d=r.__read(this.normals,2),u=d[0],b=d[1],m=r.__read(this.offsets,2),p=m[0],f=m[1],x=r.__read([u*(p-i),b*(f-i)],2),v=x[0],g=x[1],y=r.__read([u*(p+a),b*(f+a)],2),k=y[0],j=y[1];o.set_value(e),e.beginPath();for(var w=0;w<h.length;w++){var M=Math.round(h[w]+k),O=Math.round(c[w]+j),P=Math.round(h[w]+v),A=Math.round(c[w]+g);e.moveTo(M,O),e.lineTo(P,A)}e.stroke()}},t.prototype._draw_oriented_labels=function(e,t,i,a,o,n,s,_){var h,c,d,u;if(void 0===_&&(_="data"),s.doit&&0!=t.length){var b,m,p,f;if("screen"==_)b=(h=r.__read(i,2))[0],m=h[1],p=(c=r.__read([0,0],2))[0],f=c[1];else{var x=r.__read(i,2),v=x[0],g=x[1];b=(d=r.__read(this.coordinates.map_to_screen(v,g),2))[0],m=d[1],p=(u=r.__read(this.offsets,2))[0],f=u[1]}var y,k=r.__read(this.normals,2),j=k[0]*(p+n),w=k[1]*(f+n);s.set_value(e),this.panel.apply_label_text_heuristics(e,a),y=l.isString(a)?this.panel.get_label_angle_heuristic(a):-a;for(var M=0;M<b.length;M++){var O=Math.round(b[M]+j),P=Math.round(m[M]+w);e.translate(O,P),e.rotate(y),e.fillText(t[M],0,0),e.rotate(-y),e.translate(-O,-P)}}},t.prototype._axis_label_extent=function(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;var e=this.model.axis_label_standoff,t=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,e,t)},t.prototype._tick_extent=function(){return this.model.major_tick_out},t.prototype._tick_label_extent=function(){return s.sum(this._tick_label_extents())},t.prototype._tick_label_extents=function(){var e=this.tick_coords.major,t=this.compute_labels(e[this.dimension]),i=this.model.major_label_orientation,r=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(t,i,this.panel.side,r,a)]},t.prototype._oriented_labels_extent=function(e,t,i,r,a){if(0==e.length)return 0;var o,n,s=this.layer.ctx;a.set_value(s),l.isString(t)?(o=1,n=this.panel.get_label_angle_heuristic(t)):(o=2,n=-t),n=Math.abs(n);for(var _=Math.cos(n),h=Math.sin(n),c=0,d=0;d<e.length;d++){var u=1.1*s.measureText(e[d]).width,b=.9*s.measureText(e[d]).ascent,m=void 0;(m="above"==i||"below"==i?u*h+b/o*_:u*_+b/o*h)>c&&(c=m)}return c>0&&(c+=r),c},Object.defineProperty(t.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!0,configurable:!0}),t.prototype.compute_labels=function(e){for(var t=this.model.formatter.doFormat(e,this),i=0;i<e.length;i++)e[i]in this.model.major_label_overrides&&(t[i]=this.model.major_label_overrides[e[i]]);return t},Object.defineProperty(t.prototype,"offsets",{get:function(){if(null!=this.model.fixed_location)return[0,0];var e=this.plot_view.frame,t=r.__read([0,0],2),i=t[0],a=t[1];switch(this.panel.side){case"below":a=h(this.panel.bbox.top-e.bbox.bottom);break;case"above":a=h(this.panel.bbox.bottom-e.bbox.top);break;case"right":i=h(this.panel.bbox.left-e.bbox.right);break;case"left":i=h(this.panel.bbox.right-e.bbox.left)}return[i,a]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){var e=this.dimension,t=(e+1)%2,i=this.coordinates.ranges;return[i[e],i[t]]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_bounds",{get:function(){var e=r.__read(this.ranges,1)[0],t=this.model.bounds,i=[e.min,e.max];if("auto"==t)return[e.min,e.max];var a=void 0,o=void 0,n=r.__read(t,2),s=n[0],l=n[1],_=r.__read(i,2),u=_[0],b=_[1];return h(s-l)>h(u-b)?(a=d(c(s,l),u),o=c(d(s,l),b)):(a=c(s,l),o=d(s,l)),[a,o]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rule_coords",{get:function(){var e=this.dimension,t=(e+1)%2,i=r.__read(this.ranges,1)[0],a=r.__read(this.computed_bounds,2),o=a[0],n=a[1],s=[new Array(2),new Array(2)];return s[e][0]=Math.max(o,i.min),s[e][1]=Math.min(n,i.max),s[e][0]>s[e][1]&&(s[e][0]=s[e][1]=NaN),s[t][0]=this.loc,s[t][1]=this.loc,s},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tick_coords",{get:function(){for(var e=this.dimension,t=(e+1)%2,i=r.__read(this.ranges,1)[0],a=r.__read(this.computed_bounds,2),o=a[0],n=a[1],s=this.model.ticker.get_ticks(o,n,i,this.loc,{}),l=s.major,_=s.minor,h=[[],[]],c=[[],[]],d=r.__read([i.min,i.max],2),u=d[0],b=d[1],m=0;m<l.length;m++)l[m]<u||l[m]>b||(h[e].push(l[m]),h[t].push(this.loc));for(m=0;m<_.length;m++)_[m]<u||_[m]>b||(c[e].push(_[m]),c[t].push(this.loc));return{major:h,minor:c}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"loc",{get:function(){var e=this.model.fixed_location;if(null!=e){if(l.isNumber(e))return e;var t=r.__read(this.ranges,2)[1];if(t instanceof _.FactorRange)return t.synthetic(e);throw new Error("unexpected")}var i=r.__read(this.ranges,2)[1];switch(this.panel.side){case"left":case"below":return i.start;case"right":case"above":return i.end}},enumerable:!0,configurable:!0}),t.prototype.serializable_state=function(){return Object.assign(Object.assign({},e.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box})},t}(a.GuideRendererView);i.AxisView=u,u.__name__="AxisView";var b=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Axis=function(){this.prototype.default_view=u,this.mixins([["axis_",o.Line],["major_tick_",o.Line],["minor_tick_",o.Line],["major_label_",o.Text],["axis_label_",o.Text]]),this.define({bounds:[n.Any,"auto"],ticker:[n.Instance],formatter:[n.Instance],axis_label:[n.String,""],axis_label_standoff:[n.Int,5],major_label_standoff:[n.Int,5],major_label_orientation:[n.Any,"horizontal"],major_label_overrides:[n.Any,{}],major_tick_in:[n.Number,2],major_tick_out:[n.Number,6],minor_tick_in:[n.Number,0],minor_tick_out:[n.Number,4],fixed_location:[n.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})},t}(a.GuideRenderer);i.Axis=b,b.__name__="Axis",b.init_Axis()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),t=e(185),d=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(n,e),n}(t.RendererView);r.GuideRendererView=d,d.__name__="GuideRendererView";var u=function(e){function n(n){return e.call(this,n)||this}return i.__extends(n,e),n.init_GuideRenderer=function(){this.override({level:"guide"})},n}(t.Renderer);r.GuideRenderer=u,u.__name__="GuideRenderer",u.init_GuideRenderer()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var r=t(1),i=t(292),a=t(295),s=t(296),_=r.__importStar(t(143)),n=r.__importStar(t(133)),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._paint=function(t,e,o){this._draw_group_separators(t,e,o)},e.prototype._draw_group_separators=function(t,e,o){var i,a=r.__read(this.ranges,1)[0],s=r.__read(this.computed_bounds,2),_=s[0],n=s[1];if(a.tops&&!(a.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.dimension,u=(l+1)%2,p=[[],[]],h=0,c=0;c<a.tops.length-1;c++){for(var d=void 0,m=void 0,f=h;f<a.factors.length;f++)if(a.factors[f][0]==a.tops[c+1]){d=(i=r.__read([a.factors[f-1],a.factors[f]],2))[0],m=i[1],h=f;break}var g=(a.synthetic(d)+a.synthetic(m))/2;g>_&&g<n&&(p[l].push(g),p[u].push(this.loc))}var v=this._tick_label_extent();this._draw_ticks(t,p,-3,v-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,o){for(var i=this._get_factor_info(),a=e.tick+this.model.major_label_standoff,s=0;s<i.length;s++){var _=r.__read(i[s],4),n=_[0],l=_[1],u=_[2],p=_[3];this._draw_oriented_labels(t,n,l,u,this.panel.side,a,p),a+=e.tick_label[s]}},e.prototype._tick_label_extents=function(){var t,e,o=this._get_factor_info(),i=[];try{for(var a=r.__values(o),s=a.next();!s.done;s=a.next()){var _=r.__read(s.value,4),n=_[0],l=_[2],u=_[3],p=this._oriented_labels_extent(n,l,this.panel.side,this.model.major_label_standoff,u);i.push(p)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=a.return)&&e.call(a)}finally{if(t)throw t.error}}return i},e.prototype._get_factor_info=function(){var t=r.__read(this.ranges,1)[0],e=r.__read(this.computed_bounds,2),o=e[0],i=e[1],a=this.loc,s=this.model.ticker.get_ticks(o,i,t,a,{}),_=this.tick_coords,n=[];if(1==t.levels){var l=s.major,u=this.model.formatter.doFormat(l,this);n.push([u,_.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){l=s.major.map((function(t){return t[1]})),u=this.model.formatter.doFormat(l,this);n.push([u,_.major,this.model.major_label_orientation,this.visuals.major_label_text]),n.push([s.tops,_.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){l=s.major.map((function(t){return t[2]})),u=this.model.formatter.doFormat(l,this);var p=s.mids.map((function(t){return t[1]}));n.push([u,_.major,this.model.major_label_orientation,this.visuals.major_label_text]),n.push([p,_.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),n.push([s.tops,_.tops,this.model.group_label_orientation,this.visuals.group_text])}return n},Object.defineProperty(e.prototype,"tick_coords",{get:function(){var t=this,e=this.dimension,o=(e+1)%2,i=r.__read(this.ranges,1)[0],a=r.__read(this.computed_bounds,2),s=a[0],_=a[1],n=this.model.ticker.get_ticks(s,_,i,this.loc,{}),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[e]=n.major,l.major[o]=n.major.map((function(e){return t.loc})),3==i.levels&&(l.mids[e]=n.mids,l.mids[o]=n.mids.map((function(e){return t.loc}))),i.levels>1&&(l.tops[e]=n.tops,l.tops[o]=n.tops.map((function(e){return t.loc}))),l},enumerable:!0,configurable:!0}),e}(i.AxisView);o.CategoricalAxisView=l,l.__name__="CategoricalAxisView";var u=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_CategoricalAxis=function(){this.prototype.default_view=l,this.mixins([["separator_",_.Line],["group_",_.Text],["subgroup_",_.Text]]),this.define({group_label_orientation:[n.Any,"parallel"],subgroup_label_orientation:[n.Any,"parallel"]}),this.override({ticker:function(){return new a.CategoricalTicker},formatter:function(){return new s.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},e}(i.Axis);o.CategoricalAxis=u,u.__name__="CategoricalAxis",u.init_CategoricalAxis()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var o=t(1),c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.prototype.get_ticks=function(t,e,r,o,c){return{major:this._collect(r.factors,r,t,e),minor:[],tops:this._collect(r.tops||[],r,t,e),mids:this._collect(r.mids||[],r,t,e)}},e.prototype._collect=function(t,e,r,c){var n,i,l=[];try{for(var a=o.__values(t),s=a.next();!s.done;s=a.next()){var _=s.value,u=e.synthetic(_);u>r&&u<c&&l.push(_)}}catch(t){n={error:t}}finally{try{s&&!s.done&&(i=a.return)&&i.call(a)}finally{if(n)throw n.error}}return l},e}(t(244).Ticker);r.CategoricalTicker=c,c.__name__="CategoricalTicker"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var o=t(1),n=t(246),a=t(124),c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.prototype.doFormat=function(t,e){return a.copy(t)},e}(n.TickFormatter);r.CategoricalTickFormatter=c,c.__name__="CategoricalTickFormatter"},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0});var i=n(1),u=function(n){function e(e){return n.call(this,e)||this}return i.__extends(e,n),e}(n(292).Axis);t.ContinuousAxis=u,u.__name__="ContinuousAxis"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),r=e(299),a=e(300),u=e(305),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t}(r.LinearAxisView);i.DatetimeAxisView=_,_.__name__="DatetimeAxisView";var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_DatetimeAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new u.DatetimeTicker},formatter:function(){return new a.DatetimeTickFormatter}})},t}(r.LinearAxis);i.DatetimeAxis=s,s.__name__="DatetimeAxis",s.init_DatetimeAxis()},
function _(i,n,e){Object.defineProperty(e,"__esModule",{value:!0});var t=i(1),r=i(292),s=i(297),u=i(245),a=i(241),_=function(i){function n(){return null!==i&&i.apply(this,arguments)||this}return t.__extends(n,i),n}(r.AxisView);e.LinearAxisView=_,_.__name__="LinearAxisView";var o=function(i){function n(n){return i.call(this,n)||this}return t.__extends(n,i),n.init_LinearAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new a.BasicTicker},formatter:function(){return new u.BasicTickFormatter}})},n}(s.ContinuousAxis);e.LinearAxis=o,o.__name__="LinearAxis",o.init_LinearAxis()},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=r(1),i=n.__importDefault(r(301)),s=r(246),o=r(134),a=n.__importStar(r(133)),u=r(302),c=r(124),m=r(123);function h(r){return i.default(r,"%Y %m %d %H %M %S").split(/\s+/).map((function(r){return parseInt(r,10)}))}function d(r,t){if(m.isFunction(t))return t(r);var e=u.sprintf("$1%06d",function(r){return Math.round(r/1e3%1*1e6)}(r));return-1==(t=t.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?t:i.default(r,t)}var l=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],f=function(r){function t(t){var e=r.call(this,t)||this;return e.strip_leading_zeros=!0,e}return n.__extends(t,r),t.init_DatetimeTickFormatter=function(){this.define({microseconds:[a.Array,["%fus"]],milliseconds:[a.Array,["%3Nms","%S.%3Ns"]],seconds:[a.Array,["%Ss"]],minsec:[a.Array,[":%M:%S"]],minutes:[a.Array,[":%M","%Mm"]],hourmin:[a.Array,["%H:%M"]],hours:[a.Array,["%Hh","%H:%M"]],days:[a.Array,["%m/%d","%a%d"]],months:[a.Array,["%m/%Y","%b %Y"]],years:[a.Array,["%Y"]]})},t.prototype.initialize=function(){r.prototype.initialize.call(this),this._update_width_formats()},t.prototype._update_width_formats=function(){var r=+i.default(new Date),t=function(t){var e=t.map((function(t){return d(r,t).length})),i=c.sort_by(c.zip(e,t),(function(r){return n.__read(r,1)[0]}));return c.unzip(i)};this._width_formats={microseconds:t(this.microseconds),milliseconds:t(this.milliseconds),seconds:t(this.seconds),minsec:t(this.minsec),minutes:t(this.minutes),hourmin:t(this.hourmin),hours:t(this.hours),days:t(this.days),months:t(this.months),years:t(this.years)}},t.prototype._get_resolution_str=function(r,t){var e=1.1*r;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return t>=60?"minsec":"seconds";case!(e<3600):return t>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}},t.prototype.doFormat=function(r,t){var e,i,s,a;if(0==r.length)return[];var u=Math.abs(r[r.length-1]-r[0])/1e3,c=u/(r.length-1),m=this._get_resolution_str(c,u),f=n.__read(this._width_formats[m],2),_=n.__read(f[1],1)[0],y=[],p=l.indexOf(m),v={};try{for(var g=n.__values(l),w=g.next();!w.done;w=g.next()){v[w.value]=0}}catch(r){e={error:r}}finally{try{w&&!w.done&&(i=g.return)&&i.call(g)}finally{if(e)throw e.error}}v.seconds=5,v.minsec=4,v.minutes=4,v.hourmin=3,v.hours=3;try{for(var A=n.__values(r),M=A.next();!M.done;M=A.next()){var k=M.value,b=void 0,x=void 0;try{x=h(k),b=d(k,_)}catch(r){o.logger.warn("unable to format tick for timestamp value "+k),o.logger.warn(" - "+r),y.push("ERR");continue}for(var F=!1,z=p;0==x[v[l[z]]];){if((z+=1)==l.length)break;if(("minsec"==m||"hourmin"==m)&&!F){if("minsec"==m&&0==x[4]&&0!=x[5]||"hourmin"==m&&0==x[3]&&0!=x[4]){b=d(k,this._width_formats[l[p-1]][1][0]);break}F=!0}b=d(k,this._width_formats[l[z]][1][0])}if(this.strip_leading_zeros){var D=b.replace(/^0+/g,"");D!=b&&isNaN(parseInt(D))&&(D="0"+D),y.push(D)}else y.push(b)}}catch(r){s={error:r}}finally{try{M&&!M.done&&(a=A.return)&&a.call(A)}finally{if(s)throw s.error}}return y},t}(s.TickFormatter);e.DatetimeTickFormatter=f,f.__name__="DatetimeTickFormatter",f.init_DatetimeTickFormatter()},
function _(e,t,n){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,n,e){Object.defineProperty(e,"__esModule",{value:!0});var t=r(1),i=t.__importStar(r(303)),u=r(304),a=t.__importDefault(r(301)),f=r(144),o=r(123);function l(r){for(var n=[],e=1;e<arguments.length;e++)n[e-1]=arguments[e];return u.sprintf.apply(void 0,t.__spread([r],n))}function c(r,n,e){return o.isNumber(r)?l(function(){switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}}(),r):""+r}function s(r,n,t){if(null==n)return c;if(null!=t&&r in t){var i=t[r];if(o.isString(i)){if(i in e.DEFAULT_FORMATTERS)return e.DEFAULT_FORMATTERS[i];throw new Error("Unknown tooltip field formatter type '"+i+"'")}return function(r,n,e){return i.format(r,n,e)}}return e.DEFAULT_FORMATTERS.numeral}function p(r,n,e,t){return"$"==r[0]?function(r,n){if(r in n)return n[r];throw new Error("Unknown special variable '$"+r+"'")}(r.substring(1),t):function(r,n,e){var t=n.get_column(r);if(null==t)return null;if(o.isNumber(e))return t[e];var i=t[e.index];return o.isTypedArray(i)||o.isArray(i)?o.isArray(i[0])?i[e.dim2][e.dim1]:i[e.flat_index]:i}(r.substring(1).replace(/[{}]/g,""),n,e)}e.DEFAULT_FORMATTERS={numeral:function(r,n,e){return i.format(r,n)},datetime:function(r,n,e){return a.default(r,n)},printf:function(r,n,e){return l(n,r)}},e.sprintf=l,e.basic_formatter=c,e.get_formatter=s,e.get_value=p,e.replace_placeholders=function(r,n,e,i,u){var a,l;if(void 0===u&&(u={}),o.isString(r)?(a=r,l=!1):(a=r.html,l=!0),a=(a=a.replace(/@\$name/g,(function(r){return"@{"+u.name+"}"}))).replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(function(r,t,a){var o=p(t,n,e,u);if(null==o)return""+f.escape("???");if("safe"==a)return l=!0,""+o;var c=s(t,a,i);return""+f.escape(c(o,a,u))})),l){var c=(new DOMParser).parseFromString(a,"text/html");return t.__spread(c.body.childNodes)}return a}},
function _(e,n,t){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var r,i={},a=i,o="en-US",l=null,u="0,0";void 0!==n&&n.exports;function c(e){this._value=e}function s(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function f(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+s(i-r.length),n>0&&(a+="."+s(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function d(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,a,l=n,u=l.indexOf("$"),c=l.indexOf("("),s=l.indexOf("+"),f=l.indexOf("-"),d="",p="";-1===l.indexOf("$")?"infix"===i[o].currency.position?(p=i[o].currency.symbol,i[o].currency.spaceSeparated&&(p=" "+p+" ")):i[o].currency.spaceSeparated&&(d=" "):l.indexOf(" $")>-1?(d=" ",l=l.replace(" $","")):l.indexOf("$ ")>-1?(d=" ",l=l.replace("$ ","")):l=l.replace("$","");if(a=h(e,l,t,p),-1===n.indexOf("$"))switch(i[o].currency.position){case"postfix":a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;break;case"infix":break;case"prefix":a.indexOf("(")>-1||a.indexOf("-")>-1?(a=a.split(""),r=Math.max(c,f)+1,a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else u<=1?a.indexOf("(")>-1||a.indexOf("+")>-1||a.indexOf("-")>-1?(a=a.split(""),r=1,(u<c||u<s||u<f)&&(r=0),a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a:a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;return a}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=h(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):h(e,n,t)}function h(e,n,t,r){var a,u,c,s,d,h,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==l)return l;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(d=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(h=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,d)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===h?0:3*~~(h/3)-h)<0?M+3:M,a=0;a<M;a++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=i[o].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=i[o].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=i[o].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=i[o].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(u=Math.pow(1024,s),c=Math.pow(1024,s+1),e>=u&&e<c){C+=K[s],u>0&&(e/=u);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(u=Math.pow(1e3,s),c=Math.pow(1e3,s+1),e>=u&&e<c){C+=G[s],u>0&&(e/=u);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),i[o].ordinal&&(L+=i[o].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?f(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?f(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):f(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:i[o].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=f(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+i[o].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function p(e,n){i[e]=n}function m(e){o=e;var n=i[e].defaults;n&&n.format&&r.defaultFormat(n.format),n&&n.currencyFormat&&r.defaultCurrencyFormat(n.currencyFormat)}(r=function(e){return r.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=r.fn.unformat(e)),new c(Number(e))}).version="1.6.2",r.isNumbro=function(e){return e instanceof c},r.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;a[t]||(Object.keys(a).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),m(t)},r.setCulture=function(e,n){var t=e,r=e.split("-")[1],a=null;i[t]||(r&&Object.keys(i).forEach((function(e){a||e.split("-")[1]!==r||(a=e)})),t=a||n||"en-US"),m(t)},r.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return o;if(e&&!n){if(!a[e])throw new Error("Unknown language : "+e);m(e)}return!n&&a[e]||p(e,n),r},r.culture=function(e,n){if(!e)return o;if(e&&!n){if(!i[e])throw new Error("Unknown culture : "+e);m(e)}return!n&&i[e]||p(e,n),r},r.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return a[o];if(!a[e])throw new Error("Unknown language : "+e);return a[e]},r.cultureData=function(e){if(!e)return i[o];if(!i[e])throw new Error("Unknown culture : "+e);return i[e]},r.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),r.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),a},r.cultures=function(){return i},r.zeroFormat=function(e){l="string"==typeof e?e:null},r.defaultFormat=function(e){u="string"==typeof e?e:"0.0"},r.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},r.validate=function(e,n){var t,i,a,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=r.cultureData(n)}catch(e){c=r.cultureData(r.culture())}return a=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,i="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===a))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(i+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,i){return null!=t&&t!==r.culture()&&r.setCulture(t),d(Number(e),null!=n?n:u,null==i?Math.round:i)}}},
function _(e,n,t){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,n,i){Object.defineProperty(i,"__esModule",{value:!0});var t=e(1),r=e(124),a=e(242),s=e(306),_=e(307),c=e(310),m=e(311),k=e(309),o=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_DatetimeTicker=function(){this.override({num_minor_ticks:0,tickers:function(){return[new a.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*k.ONE_MILLI,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:k.ONE_SECOND,max_interval:30*k.ONE_MINUTE,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:k.ONE_HOUR,max_interval:12*k.ONE_HOUR,num_minor_ticks:0}),new _.DaysTicker({days:r.range(1,32)}),new _.DaysTicker({days:r.range(1,31,3)}),new _.DaysTicker({days:[1,8,15,22]}),new _.DaysTicker({days:[1,15]}),new c.MonthsTicker({months:r.range(0,12,1)}),new c.MonthsTicker({months:r.range(0,12,2)}),new c.MonthsTicker({months:r.range(0,12,4)}),new c.MonthsTicker({months:r.range(0,12,6)}),new m.YearsTicker({})]}})},n}(s.CompositeTicker);i.DatetimeTicker=o,o.__name__="DatetimeTicker",o.init_DatetimeTicker()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),n=t(243),o=r.__importStar(t(133)),s=t(124),a=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_CompositeTicker=function(){this.define({tickers:[o.Array,[]]})},Object.defineProperty(e.prototype,"min_intervals",{get:function(){return this.tickers.map((function(t){return t.get_min_interval()}))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_intervals",{get:function(){return this.tickers.map((function(t){return t.get_max_interval()}))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"min_interval",{get:function(){return this.min_intervals[0]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_interval",{get:function(){return this.max_intervals[0]},enumerable:!0,configurable:!0}),e.prototype.get_best_ticker=function(t,e,i){var r,n=e-t,o=this.get_ideal_interval(t,e,i),a=[s.sorted_index(this.min_intervals,o)-1,s.sorted_index(this.max_intervals,o)],_=[this.min_intervals[a[0]],this.max_intervals[a[1]]].map((function(t){return Math.abs(i-n/t)}));if(s.is_empty(_.filter((function(t){return!isNaN(t)}))))r=this.tickers[0];else{var u=a[s.argmin(_)];r=this.tickers[u]}return r},e.prototype.get_interval=function(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)},e.prototype.get_ticks_no_defaults=function(t,e,i,r){return this.get_best_ticker(t,e,r).get_ticks_no_defaults(t,e,i,r)},e}(n.ContinuousTicker);i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),i=t(308),a=t(309),o=r.__importStar(t(133)),_=t(124);var s=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_DaysTicker=function(){this.define({days:[o.Array,[]]}),this.override({num_minor_ticks:0})},e.prototype.initialize=function(){t.prototype.initialize.call(this);var e=this.days;e.length>1?this.interval=(e[1]-e[0])*a.ONE_DAY:this.interval=31*a.ONE_DAY},e.prototype.get_ticks_no_defaults=function(t,e,n,i){var o=function(t,e){var n=a.last_month_no_later_than(new Date(t)),r=a.last_month_no_later_than(new Date(e));r.setUTCMonth(r.getUTCMonth()+1);for(var i=[],o=n;i.push(a.copy_date(o)),o.setUTCMonth(o.getUTCMonth()+1),!(o>r););return i}(t,e),s=this.days,c=this.interval;return{major:_.concat(o.map((function(t){return function(t,e){var n,i,o=t.getUTCMonth(),_=[];try{for(var c=r.__values(s),l=c.next();!l.done;l=c.next()){var u=l.value,h=a.copy_date(t);h.setUTCDate(u),new Date(h.getTime()+e/2).getUTCMonth()==o&&_.push(h)}}catch(t){n={error:t}}finally{try{l&&!l.done&&(i=c.return)&&i.call(c)}finally{if(n)throw n.error}}return _}(t,c)}))).map((function(t){return t.getTime()})).filter((function(n){return t<=n&&n<=e})),minor:[]}},e}(i.SingleIntervalTicker);n.DaysTicker=s,s.__name__="DaysTicker",s.init_DaysTicker()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(243),l=r.__importStar(e(133)),o=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_SingleIntervalTicker=function(){this.define({interval:[l.Number]})},t.prototype.get_interval=function(e,t,n){return this.interval},Object.defineProperty(t.prototype,"min_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),t}(i.ContinuousTicker);n.SingleIntervalTicker=o,o.__name__="SingleIntervalTicker",o.init_SingleIntervalTicker()},
function _(e,t,_){function n(e){return new Date(e.getTime())}function O(e){var t=n(e);return t.setUTCDate(1),t.setUTCHours(0),t.setUTCMinutes(0),t.setUTCSeconds(0),t.setUTCMilliseconds(0),t}Object.defineProperty(_,"__esModule",{value:!0}),_.ONE_MILLI=1,_.ONE_SECOND=1e3,_.ONE_MINUTE=60*_.ONE_SECOND,_.ONE_HOUR=60*_.ONE_MINUTE,_.ONE_DAY=24*_.ONE_HOUR,_.ONE_MONTH=30*_.ONE_DAY,_.ONE_YEAR=365*_.ONE_DAY,_.copy_date=n,_.last_month_no_later_than=O,_.last_year_no_later_than=function(e){var t=O(e);return t.setUTCMonth(0),t}},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),i=t(308),a=t(309),o=r.__importStar(t(133)),_=t(124);var l=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_MonthsTicker=function(){this.define({months:[o.Array,[]]})},n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.months;n.length>1?this.interval=(n[1]-n[0])*a.ONE_MONTH:this.interval=12*a.ONE_MONTH},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var i=function(t,n){var e=a.last_year_no_later_than(new Date(t)),r=a.last_year_no_later_than(new Date(n));r.setUTCFullYear(r.getUTCFullYear()+1);for(var i=[],o=e;i.push(a.copy_date(o)),o.setUTCFullYear(o.getUTCFullYear()+1),!(o>r););return i}(t,n),o=this.months;return{major:_.concat(i.map((function(t){return o.map((function(n){var e=a.copy_date(t);return e.setUTCMonth(n),e}))}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(i.SingleIntervalTicker);e.MonthsTicker=l,l.__name__="MonthsTicker",l.init_MonthsTicker()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(241),a=t(308),_=t(309),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.interval=_.ONE_YEAR,this.basic_ticker=new r.BasicTicker({num_minor_ticks:0})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=_.last_year_no_later_than(new Date(t)).getUTCFullYear(),a=_.last_year_no_later_than(new Date(e)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,a,i,n).major.map((function(t){return Date.UTC(t,0,1)})).filter((function(i){return t<=i&&i<=e})),minor:[]}},e}(a.SingleIntervalTicker);i.YearsTicker=o,o.__name__="YearsTicker"},
function _(i,t,n){Object.defineProperty(n,"__esModule",{value:!0});var e=i(1),o=i(292),r=i(297),u=i(313),s=i(314),_=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return e.__extends(t,i),t}(o.AxisView);n.LogAxisView=_,_.__name__="LogAxisView";var c=function(i){function t(t){return i.call(this,t)||this}return e.__extends(t,i),t.init_LogAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new s.LogTicker},formatter:function(){return new u.LogTickFormatter}})},t}(r.ContinuousAxis);n.LogAxis=c,c.__name__="LogAxis",c.init_LogAxis()},
function _(t,i,r){Object.defineProperty(r,"__esModule",{value:!0});var e=t(1),o=t(246),n=t(245),a=e.__importStar(t(133)),c=function(t){function i(i){return t.call(this,i)||this}return e.__extends(i,t),i.init_LogTickFormatter=function(){this.define({ticker:[a.Instance,null]})},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.basic_formatter=new n.BasicTickFormatter},i.prototype.doFormat=function(t,i){if(0==t.length)return[];for(var r=null!=this.ticker?this.ticker.base:10,e=!1,o=new Array(t.length),n=0,a=t.length;n<a;n++)if(o[n]=r+"^"+Math.round(Math.log(t[n])/Math.log(r)),n>0&&o[n]==o[n-1]){e=!0;break}return e?this.basic_formatter.doFormat(t,i):o},i}(o.TickFormatter);r.LogTickFormatter=c,c.__name__="LogTickFormatter",c.init_LogTickFormatter()},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=r(1),a=r(242),o=r(124),i=function(r){function e(e){return r.call(this,e)||this}return n.__extends(e,r),e.init_LogTicker=function(){this.override({mantissas:[1,5]})},e.prototype.get_ticks_no_defaults=function(r,e,t,a){var i,l,u,f,c,h,v,s,_,y,d,g,p,x=this.num_minor_ticks,M=[],m=this.base,w=Math.log(r)/Math.log(m),k=Math.log(e)/Math.log(m),T=k-w;if(isFinite(T))if(T<2){var L=this.get_interval(r,e,a),b=Math.floor(r/L),j=Math.ceil(e/L);if(p=o.range(b,j+1).filter((function(r){return 0!=r})).map((function(r){return r*L})).filter((function(t){return r<=t&&t<=e})),x>0&&p.length>0){var A=L/x,F=o.range(0,x).map((function(r){return r*A}));try{for(var O=n.__values(F.slice(1)),P=O.next();!P.done;P=O.next()){var q=P.value;M.push(p[0]-q)}}catch(r){i={error:r}}finally{try{P&&!P.done&&(l=O.return)&&l.call(O)}finally{if(i)throw i.error}}try{for(var z=n.__values(p),B=z.next();!B.done;B=z.next()){var C=B.value;try{for(var D=(c=void 0,n.__values(F)),E=D.next();!E.done;E=D.next()){q=E.value;M.push(C+q)}}catch(r){c={error:r}}finally{try{E&&!E.done&&(h=D.return)&&h.call(D)}finally{if(c)throw c.error}}}}catch(r){u={error:r}}finally{try{B&&!B.done&&(f=z.return)&&f.call(z)}finally{if(u)throw u.error}}}}else{var G=Math.ceil(.999999*w),H=Math.floor(1.000001*k),I=Math.ceil((H-G)/9);if(p=o.range(G-1,H+1,I).map((function(r){return Math.pow(m,r)})),x>0&&p.length>0){var J=Math.pow(m,I)/x;F=o.range(1,x+1).map((function(r){return r*J}));try{for(var K=n.__values(F),N=K.next();!N.done;N=K.next()){q=N.value;M.push(p[0]/q)}}catch(r){v={error:r}}finally{try{N&&!N.done&&(s=K.return)&&s.call(K)}finally{if(v)throw v.error}}M.push(p[0]);try{for(var Q=n.__values(p),R=Q.next();!R.done;R=Q.next()){C=R.value;try{for(var S=(d=void 0,n.__values(F)),U=S.next();!U.done;U=S.next()){q=U.value;M.push(C*q)}}catch(r){d={error:r}}finally{try{U&&!U.done&&(g=S.return)&&g.call(S)}finally{if(d)throw d.error}}}}catch(r){_={error:r}}finally{try{R&&!R.done&&(y=Q.return)&&y.call(Q)}finally{if(_)throw _.error}}}}else p=[];return{major:p.filter((function(t){return r<=t&&t<=e})),minor:M.filter((function(t){return r<=t&&t<=e}))}},e}(a.AdaptiveTicker);t.LogTicker=i,i.__name__="LogTicker",i.init_LogTicker()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(292),o=e(299),a=e(316),c=e(317),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t}(n.AxisView);r.MercatorAxisView=s,s.__name__="MercatorAxisView";var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_MercatorAxis=function(){this.prototype.default_view=s,this.override({ticker:function(){return new c.MercatorTicker({dimension:"lat"})},formatter:function(){return new a.MercatorTickFormatter({dimension:"lat"})}})},t}(o.LinearAxis);r.MercatorAxis=u,u.__name__="MercatorAxis",u.init_MercatorAxis()},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var o=r(1),i=r(245),n=o.__importStar(r(133)),a=r(152),c=function(r){function t(t){return r.call(this,t)||this}return o.__extends(t,r),t.init_MercatorTickFormatter=function(){this.define({dimension:[n.LatLon]})},t.prototype.doFormat=function(t,e){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==t.length)return[];var i=t.length,n=new Array(i);if("lon"==this.dimension)for(var c=0;c<i;c++){var _=o.__read(a.wgs84_mercator.invert(t[c],e.loc),1)[0];n[c]=_}else for(c=0;c<i;c++){var m=o.__read(a.wgs84_mercator.invert(e.loc,t[c]),2)[1];n[c]=m}return r.prototype.doFormat.call(this,n,e)},t}(i.BasicTickFormatter);e.MercatorTickFormatter=c,c.__name__="MercatorTickFormatter",c.init_MercatorTickFormatter()},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=r(1),o=r(241),a=n.__importStar(r(133)),i=r(152),_=function(r){function t(t){return r.call(this,t)||this}return n.__extends(t,r),t.init_MercatorTicker=function(){this.define({dimension:[a.LatLon]})},t.prototype.get_ticks_no_defaults=function(r,t,e,o){var a;if(null==this.dimension)throw new Error(this+".dimension wasn't configured");return r=(a=n.__read(i.clip_mercator(r,t,this.dimension),2))[0],t=a[1],"lon"==this.dimension?this._get_ticks_lon(r,t,e,o):this._get_ticks_lat(r,t,e,o)},t.prototype._get_ticks_lon=function(t,e,o,a){var _,c,l,s,u=n.__read(i.wgs84_mercator.invert(t,o),1)[0],d=n.__read(i.wgs84_mercator.invert(e,o),2),f=d[0],m=d[1],v=r.prototype.get_ticks_no_defaults.call(this,u,f,o,a),h=[];try{for(var y=n.__values(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if(i.in_bounds(g,"lon")){var w=n.__read(i.wgs84_mercator.compute(g,m),1)[0];h.push(w)}}}catch(r){_={error:r}}finally{try{p&&!p.done&&(c=y.return)&&c.call(y)}finally{if(_)throw _.error}}var k=[];try{for(var x=n.__values(v.minor),b=x.next();!b.done;b=x.next()){g=b.value;if(i.in_bounds(g,"lon")){w=n.__read(i.wgs84_mercator.compute(g,m),1)[0];k.push(w)}}}catch(r){l={error:r}}finally{try{b&&!b.done&&(s=x.return)&&s.call(x)}finally{if(l)throw l.error}}return{major:h,minor:k}},t.prototype._get_ticks_lat=function(t,e,o,a){var _,c,l,s,u=n.__read(i.wgs84_mercator.invert(o,t),2)[1],d=n.__read(i.wgs84_mercator.invert(o,e),2),f=d[0],m=d[1],v=r.prototype.get_ticks_no_defaults.call(this,u,m,o,a),h=[];try{for(var y=n.__values(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if(i.in_bounds(g,"lat")){var w=n.__read(i.wgs84_mercator.compute(f,g),2)[1];h.push(w)}}}catch(r){_={error:r}}finally{try{p&&!p.done&&(c=y.return)&&c.call(y)}finally{if(_)throw _.error}}var k=[];try{for(var x=n.__values(v.minor),b=x.next();!b.done;b=x.next()){g=b.value;if(i.in_bounds(g,"lat")){w=n.__read(i.wgs84_mercator.compute(f,g),2)[1];k.push(w)}}}catch(r){l={error:r}}finally{try{b&&!b.done&&(s=x.return)&&s.call(x)}finally{if(l)throw l.error}}return{major:h,minor:k}},t}(o.BasicTicker);e.MercatorTicker=_,_.__name__="MercatorTicker",_.init_MercatorTicker()},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(319);o.CustomJS=t.CustomJS;var u=e(321);o.OpenURL=u.OpenURL},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(320),o=r.__importStar(e(133)),u=e(128),c=e(144),a=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_CustomJS=function(){this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(t.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var e=c.use_strict(this.code);return new(Function.bind.apply(Function,r.__spread([void 0],this.names,["cb_obj","cb_data",e])))},enumerable:!0,configurable:!0}),t.prototype.execute=function(e,t){return void 0===t&&(t={}),this.func.apply(e,this.values.concat(e,t))},t}(i.Callback);n.CustomJS=a,a.__name__="CustomJS",a.init_CustomJS()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var l=e(1),_=function(e){function n(n){return e.call(this,n)||this}return l.__extends(n,e),n}(e(196).Model);t.Callback=_,_.__name__="Callback"},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),i=e(320),o=e(302),a=e(123),l=r.__importStar(e(133)),c=function(e){function n(n){return e.call(this,n)||this}return r.__extends(n,e),n.init_OpenURL=function(){this.define({url:[l.String,"http://"],same_tab:[l.Boolean,!1]})},n.prototype.execute=function(e,n){var t,i,l,c,u=this,_=n.source,s=function(e){var n=o.replace_placeholders(u.url,_,e);if(!a.isString(n))throw new Error("HTML output is not supported in this context");u.same_tab?window.location.href=n:window.open(n)},f=_.selected;try{for(var d=r.__values(f.indices),p=d.next();!p.done;p=d.next()){s(p.value)}}catch(e){t={error:e}}finally{try{p&&!p.done&&(i=d.return)&&i.call(d)}finally{if(t)throw t.error}}try{for(var h=r.__values(f.line_indices),v=h.next();!v.done;v=h.next()){s(v.value)}}catch(e){l={error:e}}finally{try{v&&!v.done&&(c=h.return)&&c.call(h)}finally{if(l)throw l.error}}},n}(i.Callback);t.OpenURL=c,c.__name__="OpenURL",c.init_OpenURL()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=a(192);r.Canvas=n.Canvas;var s=a(323);r.CartesianFrame=s.CartesianFrame},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),a=e(324),s=e(261),_=e(272),o=e(273),i=e(325),c=e(213),l=e(327),g=e(128),u=e(126),f=function(e){function t(t,r,n,a,s,_){void 0===s&&(s={}),void 0===_&&(_={});var o=e.call(this)||this;return o.in_x_scale=t,o.in_y_scale=r,o.x_range=n,o.y_range=a,o.extra_x_ranges=s,o.extra_y_ranges=_,u.assert(null==t.source_range&&null==t.target_range),u.assert(null==r.source_range&&null==r.target_range),o._configure_scales(),o}return n.__extends(t,e),t.prototype._get_ranges=function(e,t){return new Map(g.entries(Object.assign(Object.assign({},t),{default:e})))},t.prototype._get_scales=function(e,t,r){var l,g,u=new Map;try{for(var f=n.__values(t),y=f.next();!y.done;y=f.next()){var p=n.__read(y.value,2),h=p[0],b=p[1];if((b instanceof i.DataRange1d||b instanceof o.Range1d)&&!(e instanceof s.ContinuousScale))throw new Error("Range "+b.type+" is incompatible is Scale "+e.type);if(b instanceof c.FactorRange&&!(e instanceof a.CategoricalScale))throw new Error("Range "+b.type+" is incompatible is Scale "+e.type);e instanceof _.LogScale&&b instanceof i.DataRange1d&&(b.scale_hint="log");var d=e.clone();d.setv({source_range:b,target_range:r}),u.set(h,d)}}catch(e){l={error:e}}finally{try{y&&!y.done&&(g=f.return)&&g.call(f)}finally{if(l)throw l.error}}return u},t.prototype._configure_frame_ranges=function(){var e=this.bbox;this._x_target=new o.Range1d({start:e.left,end:e.right}),this._y_target=new o.Range1d({start:e.bottom,end:e.top})},t.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this._y_ranges,this._y_target)},t.prototype._update_scales=function(){var e,t,r,a;this._configure_frame_ranges();try{for(var s=n.__values(this._x_scales),_=s.next();!_.done;_=s.next()){n.__read(_.value,2)[1].target_range=this._x_target}}catch(t){e={error:t}}finally{try{_&&!_.done&&(t=s.return)&&t.call(s)}finally{if(e)throw e.error}}try{for(var o=n.__values(this._y_scales),i=o.next();!i.done;i=o.next()){n.__read(i.value,2)[1].target_range=this._y_target}}catch(e){r={error:e}}finally{try{i&&!i.done&&(a=o.return)&&a.call(o)}finally{if(r)throw r.error}}},t.prototype._set_geometry=function(t,r){e.prototype._set_geometry.call(this,t,r),this._update_scales()},Object.defineProperty(t.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x_scales",{get:function(){return this._x_scales},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_scales",{get:function(){return this._y_scales},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x_scale",{get:function(){return this._x_scales.get("default")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_scale",{get:function(){return this._y_scales.get("default")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"xscales",{get:function(){return g.to_object(this.x_scales)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yscales",{get:function(){return g.to_object(this.y_scales)},enumerable:!0,configurable:!0}),t}(l.LayoutItem);r.CartesianFrame=f,f.__name__="CartesianFrame"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),o=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.prototype.compute=function(e){return t.prototype._linear_compute.call(this,this.source_range.synthetic(e))},e.prototype.v_compute=function(e){return t.prototype._linear_v_compute.call(this,this.source_range.v_synthetic(e))},e.prototype.invert=function(t){return this._linear_invert(t)},e.prototype.v_invert=function(t){return this._linear_v_invert(t)},e}(t(262).Scale);n.CategoricalScale=o,o.__name__="CategoricalScale"},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),a=t(326),r=t(205),l=t(134),o=n.__importStar(t(133)),s=n.__importStar(t(194)),_=t(124),d=function(t){function i(i){var e=t.call(this,i)||this;return e.have_updated_interactively=!1,e}return n.__extends(i,t),i.init_DataRange1d=function(){this.define({start:[o.Number],end:[o.Number],range_padding:[o.Number,.1],range_padding_units:[o.PaddingUnits,"percent"],flipped:[o.Boolean,!1],follow:[o.StartEnd],follow_interval:[o.Number],default_span:[o.Number,2],only_visible:[o.Boolean,!1]}),this.internal({scale_hint:[o.String,"auto"]})},i.prototype.initialize=function(){t.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map},Object.defineProperty(i.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),i.prototype.computed_renderers=function(){var t,i,e,a,o=this.names,s=this.renderers;if(0==s.length)try{for(var d=n.__values(this.plots),u=d.next();!u.done;u=d.next()){var h=u.value.renderers.filter((function(t){return t instanceof r.GlyphRenderer}));s=s.concat(h)}}catch(i){t={error:i}}finally{try{u&&!u.done&&(i=d.return)&&i.call(d)}finally{if(t)throw t.error}}o.length>0&&(s=s.filter((function(t){return _.includes(o,t.name)}))),l.logger.debug("computed "+s.length+" renderers for "+this);try{for(var p=n.__values(s),f=p.next();!f.done;f=p.next()){var g=f.value;l.logger.trace(" - "+g)}}catch(t){e={error:t}}finally{try{f&&!f.done&&(a=p.return)&&a.call(p)}finally{if(e)throw e.error}}return s},i.prototype._compute_plot_bounds=function(t,i){var e,a,r=s.empty();try{for(var l=n.__values(t),o=l.next();!o.done;o=l.next()){var _=o.value,d=i.get(_);null==d||!_.visible&&this.only_visible||(r=s.union(r,d))}}catch(t){e={error:t}}finally{try{o&&!o.done&&(a=l.return)&&a.call(l)}finally{if(e)throw e.error}}return r},i.prototype.adjust_bounds_for_aspect=function(t,i){var e=s.empty(),n=t.x1-t.x0;n<=0&&(n=1);var a=t.y1-t.y0;a<=0&&(a=1);var r=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return n<i*a?n=i*a:a=n/i,e.x1=r+.5*n,e.x0=r-.5*n,e.y1=l+.5*a,e.y0=l-.5*a,e},i.prototype._compute_min_max=function(t,i){var e,a,r,l,o,_,d=s.empty();try{for(var u=n.__values(t),h=u.next();!h.done;h=u.next()){var p=h.value;d=s.union(d,p)}}catch(t){e={error:t}}finally{try{h&&!h.done&&(a=u.return)&&a.call(u)}finally{if(e)throw e.error}}return 0==i?(o=(r=n.__read([d.x0,d.x1],2))[0],_=r[1]):(o=(l=n.__read([d.y0,d.y1],2))[0],_=l[1]),[o,_]},i.prototype._compute_range=function(t,i){var e,a,r,o=this.range_padding;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,l.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,l.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i));var s=void 0,_=void 0;if(i==t)_=this.default_span+.001,s=Math.log(t)/Math.log(10);else{var d=void 0,u=void 0;"percent"==this.range_padding_units?(d=Math.log(t)/Math.log(10),_=((u=Math.log(i)/Math.log(10))-d)*(1+o)):(d=Math.log(t-o)/Math.log(10),_=(u=Math.log(i+o)/Math.log(10))-d),s=(d+u)/2}a=Math.pow(10,s-_/2),r=Math.pow(10,s+_/2)}else{_=void 0;a=(s=(i+t)/2)-(_=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+o):i-t+2*o)/2,r=s+_/2}var h=1;this.flipped&&(a=(e=n.__read([r,a],2))[0],r=e[1],h=-1);var p=this.follow_interval;return null!=p&&Math.abs(a-r)>p&&("start"==this.follow?r=a+h*p:"end"==this.follow&&(a=r-h*p)),[a,r]},i.prototype.update=function(t,i,e,a){if(!this.have_updated_interactively){var r=this.computed_renderers(),l=this._compute_plot_bounds(r,t);null!=a&&(l=this.adjust_bounds_for_aspect(l,a)),this._plot_bounds.set(e,l);var o=n.__read(this._compute_min_max(this._plot_bounds.values(),i),2),s=o[0],_=o[1],d=n.__read(this._compute_range(s,_),2),u=d[0],h=d[1];null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(u=this._initial_start):u=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(h=this._initial_end):h=this._initial_end);var p=n.__read([this.start,this.end],2),f=p[0],g=p[1];if(u!=f||h!=g){var c={};u!=f&&(c.start=u),h!=g&&(c.end=h),this.setv(c)}"auto"==this.bounds&&this.setv({bounds:[u,h]},{silent:!0}),this.change.emit()}},i.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},i}(a.DataRange);e.DataRange1d=d,d.__name__="DataRange1d",d.init_DataRange1d()},
function _(e,n,a){Object.defineProperty(a,"__esModule",{value:!0});var t=e(1),r=e(214),i=t.__importStar(e(133)),_=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_DataRange=function(){this.define({names:[i.Array,[]],renderers:[i.Array,[]]})},n}(r.Range);a.DataRange=_,_.__name__="DataRange",_.init_DataRange()},
function _(a,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=a(328);t.Sizeable=e.Sizeable,t.SizingPolicy=e.SizingPolicy;var i=a(329);t.Layoutable=i.Layoutable,t.LayoutItem=i.LayoutItem;var n=a(330);t.HStack=n.HStack,t.VStack=n.VStack,t.AnchorLayout=n.AnchorLayout;var r=a(331);t.Grid=r.Grid,t.Row=r.Row,t.Column=r.Column;var c=a(332);t.ContentBox=c.ContentBox,t.VariadicBox=c.VariadicBox},
function _(t,h,i){Object.defineProperty(i,"__esModule",{value:!0});var e=t(136),n=Math.min,o=Math.max,r=function(){function t(t){void 0===t&&(t={}),this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}return t.prototype.bounded_to=function(h){var i=h.width,e=h.height;return new t({width:this.width==1/0&&null!=i?i:this.width,height:this.height==1/0&&null!=e?e:this.height})},t.prototype.expanded_to=function(h){var i=h.width,e=h.height;return new t({width:i!=1/0?o(this.width,i):this.width,height:e!=1/0?o(this.height,e):this.height})},t.prototype.expand_to=function(t){var h=t.width,i=t.height;this.width=o(this.width,h),this.height=o(this.height,i)},t.prototype.narrowed_to=function(h){var i=h.width,e=h.height;return new t({width:n(this.width,i),height:n(this.height,e)})},t.prototype.narrow_to=function(t){var h=t.width,i=t.height;this.width=n(this.width,h),this.height=n(this.height,i)},t.prototype.grow_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:this.width+i+e,height:this.height+n+o})},t.prototype.shrink_by=function(h){var i=h.left,e=h.right,n=h.top,r=h.bottom;return new t({width:o(this.width-i-e,0),height:o(this.height-n-r,0)})},t.prototype.map=function(h,i){return new t({width:h(this.width),height:(null!=i?i:h)(this.height)})},t}();i.Sizeable=r,r.__name__="Sizeable",i.SizingPolicy=e.Enum("fixed","fit","min","max")},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});var h=i(1),n=i(328),s=i(194),r=Math.min,g=Math.max,o=Math.round,a=function(){function i(){this._bbox=new s.BBox,this._inner_bbox=new s.BBox}return Object.defineProperty(i.prototype,"bbox",{get:function(){return this._bbox},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"inner_bbox",{get:function(){return this._inner_bbox},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"sizing",{get:function(){return this._sizing},enumerable:!0,configurable:!0}),i.prototype.set_sizing=function(i){var t=i.width_policy||"fit",e=i.width,h=null!=i.min_width?i.min_width:0,n=null!=i.max_width?i.max_width:1/0,s=i.height_policy||"fit",r=i.height,g=null!=i.min_height?i.min_height:0,o=null!=i.max_height?i.max_height:1/0,a=i.aspect,u=i.margin||{top:0,right:0,bottom:0,left:0},l=!1!==i.visible,d=i.halign||"start",_=i.valign||"start";this._sizing={width_policy:t,min_width:h,width:e,max_width:n,height_policy:s,min_height:g,height:r,max_height:o,aspect:a,margin:u,visible:l,halign:d,valign:_,size:{width:e,height:r},min_size:{width:h,height:g},max_size:{width:n,height:o}},this._init()},i.prototype._init=function(){},i.prototype._set_geometry=function(i,t){this._bbox=i,this._inner_bbox=t},i.prototype.set_geometry=function(i,t){this._set_geometry(i,t||i)},i.prototype.is_width_expanding=function(){return"max"==this.sizing.width_policy},i.prototype.is_height_expanding=function(){return"max"==this.sizing.height_policy},i.prototype.apply_aspect=function(i,t){var e=t.width,h=t.height,n=this.sizing.aspect;if(null!=n){var s=this.sizing,r=s.width_policy,g=s.height_policy;if("fixed"!=r&&"fixed"!=g)if(r==g){var a=e,u=o(e/n),l=o(h*n),d=h;Math.abs(i.width-a)+Math.abs(i.height-u)<=Math.abs(i.width-l)+Math.abs(i.height-d)?(e=a,h=u):(e=l,h=d)}else!function(i,t){var e={max:4,fit:3,min:2,fixed:1};return e[i]>e[t]}(r,g)?e=o(h*n):h=o(e/n);else"fixed"==r?h=o(e/n):"fixed"==g&&(e=o(h*n))}return{width:e,height:h}},i.prototype.measure=function(i){var t=this;if(!this.sizing.visible)return{width:0,height:0};var e=function(i){return"fixed"==t.sizing.width_policy&&null!=t.sizing.width?t.sizing.width:i},h=function(i){return"fixed"==t.sizing.height_policy&&null!=t.sizing.height?t.sizing.height:i},s=new n.Sizeable(i).shrink_by(this.sizing.margin).map(e,h),r=this._measure(s),g=this.clip_size(r),o=e(g.width),a=h(g.height),u=this.apply_aspect(s,{width:o,height:a});return Object.assign(Object.assign({},r),u)},i.prototype.compute=function(i){void 0===i&&(i={});var t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),e=t.width,h=t.height,n=new s.BBox({left:0,top:0,width:e,height:h}),r=void 0;if(null!=t.inner){var g=t.inner,o=g.left,a=g.top,u=g.right,l=g.bottom;r=new s.BBox({left:o,top:a,right:e-u,bottom:h-l})}this.set_geometry(n,r)},Object.defineProperty(i.prototype,"xview",{get:function(){return this.bbox.xview},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"yview",{get:function(){return this.bbox.yview},enumerable:!0,configurable:!0}),i.prototype.clip_width=function(i){return g(this.sizing.min_width,r(i,this.sizing.max_width))},i.prototype.clip_height=function(i){return g(this.sizing.min_height,r(i,this.sizing.max_height))},i.prototype.clip_size=function(i){var t=i.width,e=i.height;return{width:this.clip_width(t),height:this.clip_height(e)}},i}();e.Layoutable=a,a.__name__="Layoutable";var u=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return h.__extends(t,i),t.prototype._measure=function(i){var t,e,h=this.sizing,n=h.width_policy,s=h.height_policy;if(i.width==1/0)t=null!=this.sizing.width?this.sizing.width:0;else switch(n){case"fixed":t=null!=this.sizing.width?this.sizing.width:0;break;case"min":t=null!=this.sizing.width?r(i.width,this.sizing.width):0;break;case"fit":t=null!=this.sizing.width?r(i.width,this.sizing.width):i.width;break;case"max":t=null!=this.sizing.width?g(i.width,this.sizing.width):i.width}if(i.height==1/0)e=null!=this.sizing.height?this.sizing.height:0;else switch(s){case"fixed":e=null!=this.sizing.height?this.sizing.height:0;break;case"min":e=null!=this.sizing.height?r(i.height,this.sizing.height):0;break;case"fit":e=null!=this.sizing.height?r(i.height,this.sizing.height):i.height;break;case"max":e=null!=this.sizing.height?g(i.height,this.sizing.height):i.height}return{width:t,height:e}},t}(a);e.LayoutItem=u,u.__name__="LayoutItem";var l=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return h.__extends(t,i),t.prototype._measure=function(i){var t=this,e=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(e);return{width:function(){switch(t.sizing.width_policy){case"fixed":return null!=t.sizing.width?t.sizing.width:e.width;case"min":return e.width;case"fit":return h.width;case"max":return Math.max(e.width,h.width)}}(),height:function(){switch(t.sizing.height_policy){case"fixed":return null!=t.sizing.height?t.sizing.height:e.height;case"min":return e.height;case"fit":return h.height;case"max":return Math.max(e.height,h.height)}}()}},t}(a);e.ContentLayoutable=l,l.__name__="ContentLayoutable"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),o=t(329),a=t(194),h=function(t){function e(){var e=t.apply(this,n.__spread(arguments))||this;return e.children=[],e}return n.__extends(e,t),e}(o.Layoutable);r.Stack=h,h.__name__="Stack";var i=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._measure=function(t){var e,r,o=0,a=0;try{for(var h=n.__values(this.children),i=h.next();!i.done;i=h.next()){var l=i.value.measure({width:0,height:0});o+=l.width,a=Math.max(a,l.height)}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}return{width:o,height:a}},e.prototype._set_geometry=function(e,r){var o,h;t.prototype._set_geometry.call(this,e,r);var i=e.top,l=e.bottom,c=e.left;try{for(var _=n.__values(this.children),u=_.next();!u.done;u=_.next()){var s=u.value,y=s.measure({width:0,height:0}).width;s.set_geometry(new a.BBox({left:c,width:y,top:i,bottom:l})),c+=y}}catch(t){o={error:t}}finally{try{u&&!u.done&&(h=_.return)&&h.call(_)}finally{if(o)throw o.error}}},e}(h);r.HStack=i,i.__name__="HStack";var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._measure=function(t){var e,r,o=0,a=0;try{for(var h=n.__values(this.children),i=h.next();!i.done;i=h.next()){var l=i.value.measure({width:0,height:0});o=Math.max(o,l.width),a+=l.height}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}return{width:o,height:a}},e.prototype._set_geometry=function(e,r){var o,h;t.prototype._set_geometry.call(this,e,r);var i=e.left,l=e.right,c=e.top;try{for(var _=n.__values(this.children),u=_.next();!u.done;u=_.next()){var s=u.value,y=s.measure({width:0,height:0}).height;s.set_geometry(new a.BBox({top:c,height:y,left:i,right:l})),c+=y}}catch(t){o={error:t}}finally{try{u&&!u.done&&(h=_.return)&&h.call(_)}finally{if(o)throw o.error}}},e}(h);r.VStack=l,l.__name__="VStack";var c=function(t){function e(){var e=t.apply(this,n.__spread(arguments))||this;return e.children=[],e}return n.__extends(e,t),e.prototype._measure=function(t){var e,r,o=0,a=0;try{for(var h=n.__values(this.children),i=h.next();!i.done;i=h.next()){var l=i.value.layout.measure(t);o=Math.max(o,l.width),a=Math.max(a,l.height)}}catch(t){e={error:t}}finally{try{i&&!i.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}return{width:o,height:a}},e.prototype._set_geometry=function(e,r){var o,h;t.prototype._set_geometry.call(this,e,r);try{for(var i=n.__values(this.children),l=i.next();!l.done;l=i.next()){var c=l.value,_=c.layout,u=c.anchor,s=c.margin,y=e.left,d=e.right,f=e.top,v=e.bottom,g=e.hcenter,p=e.vcenter,w=_.measure(e),m=w.width,x=w.height,B=void 0;switch(u){case"top_left":B=new a.BBox({left:y+s,top:f+s,width:m,height:x});break;case"top_center":B=new a.BBox({hcenter:g,top:f+s,width:m,height:x});break;case"top_right":B=new a.BBox({right:d-s,top:f+s,width:m,height:x});break;case"bottom_right":B=new a.BBox({right:d-s,bottom:v-s,width:m,height:x});break;case"bottom_center":B=new a.BBox({hcenter:g,bottom:v-s,width:m,height:x});break;case"bottom_left":B=new a.BBox({left:y+s,bottom:v-s,width:m,height:x});break;case"center_left":B=new a.BBox({left:y+s,vcenter:p,width:m,height:x});break;case"center":B=new a.BBox({hcenter:g,vcenter:p,width:m,height:x});break;case"center_right":B=new a.BBox({right:d-s,vcenter:p,width:m,height:x})}_.set_geometry(B)}}catch(t){o={error:t}}finally{try{l&&!l.done&&(h=i.return)&&h.call(i)}finally{if(o)throw o.error}}},e}(o.Layoutable);r.AnchorLayout=c,c.__name__="AnchorLayout"},
function _(t,i,r){Object.defineProperty(r,"__esModule",{value:!0});var e=t(1),n=t(328),o=t(329),a=t(123),s=t(194),l=t(124),h=Math.max,c=Math.round,u=function(){function t(t){this.def=t,this._map=new Map}return t.prototype.get=function(t){var i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i},t.prototype.apply=function(t,i){var r=this.get(t);this._map.set(t,i(r))},t}();u.__name__="DefaultMap";var f=function(){function t(){this._items=[],this._nrows=0,this._ncols=0}return Object.defineProperty(t.prototype,"nrows",{get:function(){return this._nrows},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ncols",{get:function(){return this._ncols},enumerable:!0,configurable:!0}),t.prototype.add=function(t,i){var r=t.r1,e=t.c1;this._nrows=h(this._nrows,r+1),this._ncols=h(this._ncols,e+1),this._items.push({span:t,data:i})},t.prototype.at=function(t,i){return this._items.filter((function(r){var e=r.span;return e.r0<=t&&t<=e.r1&&e.c0<=i&&i<=e.c1})).map((function(t){return t.data}))},t.prototype.row=function(t){return this._items.filter((function(i){var r=i.span;return r.r0<=t&&t<=r.r1})).map((function(t){return t.data}))},t.prototype.col=function(t){return this._items.filter((function(i){var r=i.span;return r.c0<=t&&t<=r.c1})).map((function(t){return t.data}))},t.prototype.foreach=function(t){var i,r;try{for(var n=e.__values(this._items),o=n.next();!o.done;o=n.next()){var a=o.value;t(a.span,a.data)}}catch(t){i={error:t}}finally{try{o&&!o.done&&(r=n.return)&&r.call(n)}finally{if(i)throw i.error}}},t.prototype.map=function(i){var r,n,o=new t;try{for(var a=e.__values(this._items),s=a.next();!s.done;s=a.next()){var l=s.value,h=l.span,c=l.data;o.add(h,i(h,c))}}catch(t){r={error:t}}finally{try{s&&!s.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}return o},t}();f.__name__="Container";var p=function(t){function i(i){void 0===i&&(i=[]);var r=t.call(this)||this;return r.items=i,r.rows="auto",r.cols="auto",r.spacing=0,r.absolute=!1,r}return e.__extends(i,t),i.prototype.is_width_expanding=function(){if(t.prototype.is_width_expanding.call(this))return!0;if("fixed"==this.sizing.width_policy)return!1;var i=this._state.cols;return l.some(i,(function(t){return"max"==t.policy}))},i.prototype.is_height_expanding=function(){if(t.prototype.is_height_expanding.call(this))return!0;if("fixed"==this.sizing.height_policy)return!1;var i=this._state.rows;return l.some(i,(function(t){return"max"==t.policy}))},i.prototype._init=function(){var i,r,n=this;t.prototype._init.call(this);var o=new f;try{for(var s=e.__values(this.items),h=s.next();!h.done;h=s.next()){var c=h.value,u=c.layout,p=c.row,_=c.col,g=c.row_span,d=c.col_span;if(u.sizing.visible){var y=p,w=_,v=p+(null!=g?g:1)-1,m=_+(null!=d?d:1)-1;o.add({r0:y,c0:w,r1:v,c1:m},u)}}}catch(t){i={error:t}}finally{try{h&&!h.done&&(r=s.return)&&r.call(s)}finally{if(i)throw i.error}}for(var x=o.nrows,b=o.ncols,z=new Array(x),j=function(t){var i,r=null==(i=a.isPlainObject(n.rows)?n.rows[t]||n.rows["*"]:n.rows)?{policy:"auto"}:a.isNumber(i)?{policy:"fixed",height:i}:a.isString(i)?{policy:i}:i,e=r.align||"auto";if("fixed"==r.policy)z[t]={policy:"fixed",height:r.height,align:e};else if("min"==r.policy)z[t]={policy:"min",align:e};else if("fit"==r.policy||"max"==r.policy)z[t]={policy:r.policy,flex:r.flex||1,align:e};else{if("auto"!=r.policy)throw new Error("unrechable");l.some(o.row(t),(function(t){return t.is_height_expanding()}))?z[t]={policy:"max",flex:1,align:e}:z[t]={policy:"min",align:e}}},O=0;O<x;O++)j(O);for(var B=new Array(b),M=function(t){var i,r=null==(i=a.isPlainObject(n.cols)?n.cols[t]||n.cols["*"]:n.cols)?{policy:"auto"}:a.isNumber(i)?{policy:"fixed",width:i}:a.isString(i)?{policy:i}:i,e=r.align||"auto";if("fixed"==r.policy)B[t]={policy:"fixed",width:r.width,align:e};else if("min"==r.policy)B[t]={policy:"min",align:e};else if("fit"==r.policy||"max"==r.policy)B[t]={policy:r.policy,flex:r.flex||1,align:e};else{if("auto"!=r.policy)throw new Error("unrechable");l.some(o.col(t),(function(t){return t.is_width_expanding()}))?B[t]={policy:"max",flex:1,align:e}:B[t]={policy:"min",align:e}}},P=0;P<b;P++)M(P);var A=e.__read(a.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing,2),C=A[0],N=A[1];this._state={items:o,nrows:x,ncols:b,rows:z,cols:B,rspacing:C,cspacing:N}},i.prototype._measure_totals=function(t,i){var r=this._state,e=r.nrows,n=r.ncols,o=r.rspacing,a=r.cspacing;return{height:l.sum(t)+(e-1)*o,width:l.sum(i)+(n-1)*a}},i.prototype._measure_cells=function(t){for(var i=this._state,r=i.items,o=i.nrows,a=i.ncols,s=i.rows,l=i.cols,u=i.rspacing,p=i.cspacing,_=new Array(o),g=0;g<o;g++){var d=s[g];_[g]="fixed"==d.policy?d.height:0}for(var y=new Array(a),w=0;w<a;w++){var v=l[w];y[w]="fixed"==v.policy?v.width:0}var m=new f;return r.foreach((function(i,r){for(var o,a,f,g,d=i.r0,w=i.c0,v=i.r1,x=i.c1,b=(v-d)*u,z=(x-w)*p,j=0,O=d;O<=v;O++)j+=t(O,w).height;j+=b;for(var B=0,M=w;M<=x;M++)B+=t(d,M).width;B+=z;var P=r.measure({width:B,height:j});m.add(i,{layout:r,size_hint:P});var A=new n.Sizeable(P).grow_by(r.sizing.margin);A.height-=b,A.width-=z;var C=[];for(O=d;O<=v;O++){var N=s[O];"fixed"==N.policy?A.height-=N.height:C.push(O)}if(A.height>0){var S=c(A.height/C.length);try{for(var E=e.__values(C),G=E.next();!G.done;G=E.next()){O=G.value;_[O]=h(_[O],S)}}catch(t){o={error:t}}finally{try{G&&!G.done&&(a=E.return)&&a.call(E)}finally{if(o)throw o.error}}}var R=[];for(M=w;M<=x;M++){var D=l[M];"fixed"==D.policy?A.width-=D.width:R.push(M)}if(A.width>0){var L=c(A.width/R.length);try{for(var k=e.__values(R),q=k.next();!q.done;q=k.next()){M=q.value;y[M]=h(y[M],L)}}catch(t){f={error:t}}finally{try{q&&!q.done&&(g=k.return)&&g.call(k)}finally{if(f)throw f.error}}}})),{size:this._measure_totals(_,y),row_heights:_,col_widths:y,size_hints:m}},i.prototype._measure_grid=function(t){var i,r=this._state,e=r.nrows,n=r.ncols,o=r.rows,a=r.cols,s=r.rspacing,l=r.cspacing,u=this._measure_cells((function(t,i){var r=o[t],e=a[i];return{width:"fixed"==e.policy?e.width:1/0,height:"fixed"==r.policy?r.height:1/0}}));i="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:u.size.height;for(var f,p=0,_=0;_<e;_++){"fit"==(y=o[_]).policy||"max"==y.policy?p+=y.flex:i-=u.row_heights[_]}if(i-=(e-1)*s,0!=p&&i>0)for(_=0;_<e;_++){if("fit"==(y=o[_]).policy||"max"==y.policy)i-=w=c(i*(y.flex/p)),u.row_heights[_]=w,p-=y.flex}else if(i<0){var g=0;for(_=0;_<e;_++){"fixed"!=(y=o[_]).policy&&g++}var d=-i;for(_=0;_<e;_++){var y;if("fixed"!=(y=o[_]).policy){var w=u.row_heights[_],v=c(d/g);u.row_heights[_]=h(w-v,0),d-=v>w?w:v,g--}}}f="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:u.size.width;for(var m=0,x=0;x<n;x++){"fit"==(z=a[x]).policy||"max"==z.policy?m+=z.flex:f-=u.col_widths[x]}if(f-=(n-1)*l,0!=m&&f>0)for(x=0;x<n;x++){if("fit"==(z=a[x]).policy||"max"==z.policy)f-=j=c(f*(z.flex/m)),u.col_widths[x]=j,m-=z.flex}else if(f<0){for(g=0,x=0;x<n;x++){"fixed"!=(z=a[x]).policy&&g++}var b=-f;for(x=0;x<n;x++){var z;if("fixed"!=(z=a[x]).policy){var j=u.col_widths[x];v=c(b/g);u.col_widths[x]=h(j-v,0),b-=v>j?j:v,g--}}}var O=this._measure_cells((function(t,i){return{width:u.col_widths[i],height:u.row_heights[t]}})),B=O.row_heights,M=O.col_widths,P=O.size_hints;return{size:this._measure_totals(B,M),row_heights:B,col_widths:M,size_hints:P}},i.prototype._measure=function(t){return this._measure_grid(t).size},i.prototype._set_geometry=function(i,r){t.prototype._set_geometry.call(this,i,r);for(var e=this._state,n=e.nrows,o=e.ncols,a=e.rspacing,l=e.cspacing,f=this._measure_grid(i),p=f.row_heights,_=f.col_widths,g=f.size_hints,d=this._state.rows.map((function(t,i){return Object.assign(Object.assign({},t),{top:0,height:p[i],get bottom(){return this.top+this.height}})})),y=this._state.cols.map((function(t,i){return Object.assign(Object.assign({},t),{left:0,width:_[i],get right(){return this.left+this.width}})})),w=g.map((function(t,i){return Object.assign(Object.assign({},i),{outer:new s.BBox,inner:new s.BBox})})),v=0,m=this.absolute?i.top:0;v<n;v++){var x=d[v];x.top=m,m+=x.height+a}for(var b=0,z=this.absolute?i.left:0;b<o;b++){var j=y[b];j.left=z,z+=j.width+l}w.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,h=i.layout,u=i.size_hint,f=h.sizing,p=u.width,_=u.height,g=function(t,i){for(var r=(i-t)*l,e=t;e<=i;e++)r+=y[e].width;return r}(e,o),w=function(t,i){for(var r=(i-t)*a,e=t;e<=i;e++)r+=d[e].height;return r}(r,n),v=e==o&&"auto"!=y[e].align?y[e].align:f.halign,m=r==n&&"auto"!=d[r].align?d[r].align:f.valign,x=y[e].left;"start"==v?x+=f.margin.left:"center"==v?x+=c((g-p)/2):"end"==v&&(x+=g-f.margin.right-p);var b=d[r].top;"start"==m?b+=f.margin.top:"center"==m?b+=c((w-_)/2):"end"==m&&(b+=w-f.margin.bottom-_),i.outer=new s.BBox({left:x,top:b,width:p,height:_})}));var O=d.map((function(){return{start:new u((function(){return 0})),end:new u((function(){return 0}))}})),B=y.map((function(){return{start:new u((function(){return 0})),end:new u((function(){return 0}))}}));w.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.size_hint,s=i.outer,l=a.inner;null!=l&&(O[r].start.apply(s.top,(function(t){return h(t,l.top)})),O[n].end.apply(d[n].bottom-s.bottom,(function(t){return h(t,l.bottom)})),B[e].start.apply(s.left,(function(t){return h(t,l.left)})),B[o].end.apply(y[o].right-s.right,(function(t){return h(t,l.right)})))})),w.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.size_hint,l=i.outer;function h(t){var i=t.left,r=t.right,e=t.top,n=t.bottom,o=l.width-i-r,a=l.height-e-n;return new s.BBox({left:i,top:e,width:o,height:a})}if(null!=a.inner){var c=h(a.inner);if(!1!==a.align){var u=O[r].start.get(l.top),f=O[n].end.get(d[n].bottom-l.bottom),p=B[e].start.get(l.left),_=B[o].end.get(y[o].right-l.right);try{c=h({top:u,bottom:f,left:p,right:_})}catch(t){}}i.inner=c}else i.inner=l})),w.foreach((function(t,i){var r=i.layout,e=i.outer,n=i.inner;r.set_geometry(e,n)}))},i}(o.Layoutable);r.Grid=p,p.__name__="Grid";var _=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:0,col:i}})),r.rows="fit",r}return e.__extends(i,t),i}(p);r.Row=_,_.__name__="Row";var g=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:i,col:0}})),r.cols="fit",r}return e.__extends(i,t),i}(p);r.Column=g,g.__name__="Column"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(329),a=e(328),o=e(187),c=function(e){function t(t){var n=e.call(this)||this;return n.content_size=o.unsized(t,(function(){return new a.Sizeable(o.size(t))})),n}return i.__extends(t,e),t.prototype._content_size=function(){return this.content_size},t}(r.ContentLayoutable);n.ContentBox=c,c.__name__="ContentBox";var _=function(e){function t(t){var n=e.call(this)||this;return n.el=t,n}return i.__extends(t,e),t.prototype._measure=function(e){var t=this,n=new a.Sizeable(e).bounded_to(this.sizing.size);return o.sized(this.el,n,(function(){var e=new a.Sizeable(o.content_size(t.el)),n=o.extents(t.el),i=n.border,r=n.padding;return e.grow_by(i).grow_by(r).map(Math.ceil)}))},t}(r.Layoutable);n.VariadicBox=_,_.__name__="VariadicBox";var u=function(e){function t(t){var n=e.call(this,t)||this;return n._cache=new Map,n}return i.__extends(t,e),t.prototype._measure=function(t){var n=t.width+","+t.height,i=this._cache.get(n);return null==i&&(i=e.prototype._measure.call(this,t),this._cache.set(n,i)),i},t.prototype.invalidate_cache=function(){this._cache.clear()},t}(_);n.CachedVariadicBox=u,u.__name__="CachedVariadicBox"},
function _(e,r,u){Object.defineProperty(u,"__esModule",{value:!0});var a=e(334);u.Expression=a.Expression;var n=e(335);u.Stack=n.Stack;var o=e(336);u.CumSum=o.CumSum},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),r=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._connected=new Set,this._result=new Map},e.prototype.v_compute=function(t){var e=this;this._connected.has(t)||(this.connect(t.change,(function(){return e._result.delete(t)})),this.connect(t.patching,(function(){return e._result.delete(t)})),this.connect(t.streaming,(function(){return e._result.delete(t)})),this._connected.add(t));var n=this._result.get(t);return null==n&&(n=this._v_compute(t),this._result.set(t,n)),n},e}(t(196).Model);n.Expression=r,r.__name__="Expression"},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),i=t(334),a=t(139),l=n.__importStar(t(133)),o=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_Stack=function(){this.define({fields:[l.Array,[]]})},r.prototype._v_compute=function(t){var r,e,i,l=null!==(i=t.get_length())&&void 0!==i?i:0,o=new a.NumberArray(l);try{for(var _=n.__values(this.fields),u=_.next();!u.done;u=_.next()){var c=u.value,f=t.data[c];if(null!=f)for(var s=0,d=Math.min(l,f.length);s<d;s++)o[s]+=f[s]}}catch(t){r={error:t}}finally{try{u&&!u.done&&(e=_.return)&&e.call(_)}finally{if(r)throw r.error}}return o},r}(i.Expression);e.Stack=o,o.__name__="Stack",o.init_Stack()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(334),u=e(139),_=i.__importStar(e(133)),o=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_CumSum=function(){this.define({field:[_.String],include_zero:[_.Boolean,!1]})},t.prototype._v_compute=function(e){var t=new u.NumberArray(e.get_length()||0),n=e.data[this.field],i=this.include_zero?1:0;t[0]=this.include_zero?0:n[0];for(var r=1;r<t.length;r++)t[r]=t[r-1]+n[r-i];return t},t}(r.Expression);n.CumSum=o,o.__name__="CumSum",o.init_CumSum()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var l=e(338);t.BooleanFilter=l.BooleanFilter;var i=e(340);t.CustomJSFilter=i.CustomJSFilter;var o=e(339);t.Filter=o.Filter;var F=e(341);t.GroupFilter=F.GroupFilter;var a=e(342);t.IndexFilter=a.IndexFilter},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var o=e(1),i=e(339),l=o.__importStar(e(133)),r=e(139),_=function(e){function n(n){return e.call(this,n)||this}return o.__extends(n,e),n.init_BooleanFilter=function(){this.define({booleans:[l.Array,null]})},n.prototype.compute_indices=function(e){var n=e.length,t=this.booleans;return null==t?r.Indices.all_set(n):r.Indices.from_booleans(n,t)},n}(i.Filter);t.BooleanFilter=_,_.__name__="BooleanFilter",_.init_BooleanFilter()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),_=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t}(e(196).Model);n.Filter=_,_.__name__="Filter"},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),i=e(339),o=n.__importStar(e(133)),s=e(139),u=e(128),a=e(123),c=e(144),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_CustomJSFilter=function(){this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(t.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var e=c.use_strict(this.code);return new(Function.bind.apply(Function,n.__spread([void 0],this.names,["source",e])))},enumerable:!0,configurable:!0}),t.prototype.compute_indices=function(e){var t=e.length,r=this.func.apply(this,n.__spread(this.values,[e]));if(null==r)return s.Indices.all_set(t);if(a.isArrayOf(r,a.isInteger))return s.Indices.from_indices(t,r);if(a.isArrayOf(r,a.isBoolean))return s.Indices.from_booleans(t,r);throw new Error("expect an array of integers or booleans, or null, got "+r)},t}(i.Filter);r.CustomJSFilter=l,l.__name__="CustomJSFilter",l.init_CustomJSFilter()},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});var r=n(1),i=n(339),o=r.__importStar(n(133)),u=n(139),l=n(134),_=function(n){function t(t){return n.call(this,t)||this}return r.__extends(t,n),t.init_GroupFilter=function(){this.define({column_name:[o.String],group:[o.String]})},t.prototype.compute_indices=function(n){var t=n.get_column(this.column_name);if(null==t)return l.logger.warn(this+": groupby column '"+this.column_name+"' not found in the data source"),new u.Indices(n.length,1);for(var e=new u.Indices(n.length),r=0;r<e.size;r++)t[r]===this.group&&e.set(r);return e},t}(i.Filter);e.GroupFilter=_,_.__name__="GroupFilter",_.init_GroupFilter()},
function _(e,n,i){Object.defineProperty(i,"__esModule",{value:!0});var t=e(1),r=e(339),l=t.__importStar(e(133)),_=e(139),c=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_IndexFilter=function(){this.define({indices:[l.Array,null]})},n.prototype.compute_indices=function(e){var n=e.length,i=this.indices;return null==i?_.Indices.all_set(n):_.Indices.from_indices(n,i)},n}(r.Filter);i.IndexFilter=c,c.__name__="IndexFilter",c.init_IndexFilter()},
function _(r,t,a){Object.defineProperty(a,"__esModule",{value:!0});var e=r(245);a.BasicTickFormatter=e.BasicTickFormatter;var c=r(296);a.CategoricalTickFormatter=c.CategoricalTickFormatter;var i=r(300);a.DatetimeTickFormatter=i.DatetimeTickFormatter;var o=r(344);a.FuncTickFormatter=o.FuncTickFormatter;var m=r(313);a.LogTickFormatter=m.LogTickFormatter;var F=r(316);a.MercatorTickFormatter=F.MercatorTickFormatter;var k=r(345);a.NumeralTickFormatter=k.NumeralTickFormatter;var T=r(346);a.PrintfTickFormatter=T.PrintfTickFormatter;var v=r(246);a.TickFormatter=v.TickFormatter},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),i=t(246),o=r.__importStar(t(133)),u=t(128),c=t(144),a=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_FuncTickFormatter=function(){this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(e.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!0,configurable:!0}),e.prototype._make_func=function(){var t=c.use_strict(this.code);return new(Function.bind.apply(Function,r.__spread([void 0,"tick","index","ticks"],this.names,[t])))},e.prototype.doFormat=function(t,e){var n=this,i=this._make_func().bind({});return t.map((function(t,e,o){return i.apply(void 0,r.__spread([t,e,o],n.values))}))},e}(i.TickFormatter);n.FuncTickFormatter=a,a.__name__="FuncTickFormatter",a.init_FuncTickFormatter()},
function _(r,t,n){Object.defineProperty(n,"__esModule",{value:!0});var e=r(1),o=e.__importStar(r(303)),i=r(246),a=e.__importStar(r(133)),u=function(r){function t(t){return r.call(this,t)||this}return e.__extends(t,r),t.init_NumeralTickFormatter=function(){this.define({format:[a.String,"0,0"],language:[a.String,"en"],rounding:[a.RoundingFunction,"round"]})},Object.defineProperty(t.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!0,configurable:!0}),t.prototype.doFormat=function(r,t){var n=this.format,e=this.language,i=this._rounding_fn;return r.map((function(r){return o.format(r,n,e,i)}))},t}(i.TickFormatter);n.NumeralTickFormatter=u,u.__name__="NumeralTickFormatter",u.init_NumeralTickFormatter()},
function _(t,r,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),e=t(246),o=t(302),a=n.__importStar(t(133)),f=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_PrintfTickFormatter=function(){this.define({format:[a.String,"%s"]})},r.prototype.doFormat=function(t,r){var i=this;return t.map((function(t){return o.sprintf(i.format,t)}))},r}(e.TickFormatter);i.PrintfTickFormatter=f,f.__name__="PrintfTickFormatter",f.init_PrintfTickFormatter()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var v=a(348);r.AnnularWedge=v.AnnularWedge;var l=a(349);r.Annulus=l.Annulus;var t=a(350);r.Arc=t.Arc;var i=a(351);r.Bezier=i.Bezier;var n=a(352);r.Circle=n.Circle;var u=a(356);r.CenterRotatable=u.CenterRotatable;var c=a(357);r.Ellipse=c.Ellipse;var g=a(358);r.EllipseOval=g.EllipseOval;var A=a(209);r.Glyph=A.Glyph;var p=a(226);r.HArea=p.HArea;var s=a(359);r.HBar=s.HBar;var d=a(361);r.HexTile=d.HexTile;var R=a(362);r.Image=R.Image;var o=a(364);r.ImageRGBA=o.ImageRGBA;var y=a(365);r.ImageURL=y.ImageURL;var h=a(207);r.Line=h.Line;var m=a(367);r.MultiLine=m.MultiLine;var B=a(368);r.MultiPolygons=B.MultiPolygons;var P=a(369);r.Oval=P.Oval;var G=a(225);r.Patch=G.Patch;var H=a(370);r.Patches=H.Patches;var I=a(371);r.Quad=I.Quad;var L=a(372);r.Quadratic=L.Quadratic;var M=a(373);r.Ray=M.Ray;var O=a(374);r.Rect=O.Rect;var x=a(375);r.Segment=x.Segment;var C=a(376);r.Step=C.Step;var E=a(377);r.Text=E.Text;var Q=a(228);r.VArea=Q.VArea;var S=a(378);r.VBar=S.VBar;var T=a(379);r.Wedge=T.Wedge;var V=a(208);r.XYGlyph=V.XYGlyph},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),s=e(208),a=e(215),n=e(143),_=e(139),o=i.__importStar(e(133)),l=e(125),u=e(203),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new _.NumberArray(this._start_angle.length);for(var e=0,t=this._start_angle.length;e<t;e++)this._angle[e]=this._end_angle[e]-this._start_angle[e]},t.prototype._render=function(e,t,r){var s,a,n=r.sx,_=r.sy,o=r._start_angle,l=r._angle,u=r.sinner_radius,h=r.souter_radius,d=this.model.properties.direction.value();try{for(var c=i.__values(t),p=c.next();!p.done;p=c.next()){var v=p.value;isNaN(n[v]+_[v]+u[v]+h[v]+o[v]+l[v])||(e.translate(n[v],_[v]),e.rotate(o[v]),e.beginPath(),e.moveTo(h[v],0),e.arc(0,0,h[v],0,l[v],d),e.rotate(l[v]),e.lineTo(u[v],0),e.arc(0,0,u[v],0,-l[v],!d),e.closePath(),e.rotate(-l[v]-o[v]),e.translate(-n[v],-_[v]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,v),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,v),e.stroke()))}}catch(e){s={error:e}}finally{try{p&&!p.done&&(a=c.return)&&a.call(c)}finally{if(s)throw s.error}}},t.prototype._hit_point=function(e){var t,r,s,a,n,_,o,h,d,c,p=e.sx,v=e.sy,x=this.renderer.xscale.invert(p),y=this.renderer.yscale.invert(v);if("data"==this.model.properties.outer_radius.units)o=x-this.max_outer_radius,d=x+this.max_outer_radius,h=y-this.max_outer_radius,c=y+this.max_outer_radius;else{var f=p-this.max_outer_radius,g=p+this.max_outer_radius;o=(t=i.__read(this.renderer.xscale.r_invert(f,g),2))[0],d=t[1];var m=v-this.max_outer_radius,w=v+this.max_outer_radius;h=(r=i.__read(this.renderer.yscale.r_invert(m,w),2))[0],c=r[1]}var A=[];try{for(var M=i.__values(this.index.indices({x0:o,x1:d,y0:h,y1:c})),S=M.next();!S.done;S=M.next()){var W=S.value,V=Math.pow(this.souter_radius[W],2),b=Math.pow(this.sinner_radius[W],2),D=i.__read(this.renderer.xscale.r_compute(x,this._x[W]),2),N=(f=D[0],g=D[1],i.__read(this.renderer.yscale.r_compute(y,this._y[W]),2)),P=(m=N[0],w=N[1],Math.pow(f-g,2)+Math.pow(m-w,2));P<=V&&P>=b&&A.push(W)}}catch(e){s={error:e}}finally{try{S&&!S.done&&(a=M.return)&&a.call(M)}finally{if(s)throw s.error}}var k=this.model.properties.direction.value(),z=[];try{for(var G=i.__values(A),T=G.next();!T.done;T=G.next()){W=T.value;var X=Math.atan2(v-this.sy[W],p-this.sx[W]);l.angle_between(-X,-this._start_angle[W],-this._end_angle[W],k)&&z.push(W)}}catch(e){n={error:e}}finally{try{T&&!T.done&&(_=G.return)&&_.call(G)}finally{if(n)throw n.error}}return new u.Selection({indices:z})},t.prototype.draw_legend_for_index=function(e,t,r){a.generic_area_legend(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=(this.sinner_radius[e]+this.souter_radius[e])/2,r=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(s.XYGlyphView);r.AnnularWedgeView=h,h.__name__="AnnularWedgeView";var d=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_AnnularWedge=function(){this.prototype.default_view=h,this.mixins([n.LineVector,n.FillVector]),this.define({direction:[o.Direction,"anticlock"],inner_radius:[o.DistanceSpec],outer_radius:[o.DistanceSpec],start_angle:[o.AngleSpec],end_angle:[o.AngleSpec]})},t}(s.XYGlyph);r.AnnularWedge=d,d.__name__="AnnularWedge",d.init_AnnularWedge()},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var i=r(1),s=r(208),a=r(143),n=i.__importStar(r(133)),u=r(147),_=r(203),o=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return i.__extends(e,r),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius},e.prototype._render=function(r,e,t){var s,a,n,_,o=t.sx,h=t.sy,d=t.sinner_radius,l=t.souter_radius;try{for(var c=i.__values(e),v=c.next();!v.done;v=c.next()){var y=v.value;if(!isNaN(o[y]+h[y]+d[y]+l[y])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(r,y),r.beginPath(),u.is_ie)try{for(var x=(n=void 0,i.__values([!1,!0])),f=x.next();!f.done;f=x.next()){var p=f.value;r.arc(o[y],h[y],d[y],0,Math.PI,p),r.arc(o[y],h[y],l[y],Math.PI,0,!p)}}catch(r){n={error:r}}finally{try{f&&!f.done&&(_=x.return)&&_.call(x)}finally{if(n)throw n.error}}else r.arc(o[y],h[y],d[y],0,2*Math.PI,!0),r.arc(o[y],h[y],l[y],2*Math.PI,0,!1);r.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(r,y),r.beginPath(),r.arc(o[y],h[y],d[y],0,2*Math.PI),r.moveTo(o[y]+l[y],h[y]),r.arc(o[y],h[y],l[y],0,2*Math.PI),r.stroke())}}}catch(r){s={error:r}}finally{try{v&&!v.done&&(a=c.return)&&a.call(c)}finally{if(s)throw s.error}}},e.prototype._hit_point=function(r){var e,t,s,a,n,u,o,h,d=r.sx,l=r.sy,c=this.renderer.xscale.invert(d),v=this.renderer.yscale.invert(l);if("data"==this.model.properties.outer_radius.units)n=c-this.max_outer_radius,o=c+this.max_outer_radius,u=v-this.max_outer_radius,h=v+this.max_outer_radius;else{var y=d-this.max_outer_radius,x=d+this.max_outer_radius;n=(e=i.__read(this.renderer.xscale.r_invert(y,x),2))[0],o=e[1];var f=l-this.max_outer_radius,p=l+this.max_outer_radius;u=(t=i.__read(this.renderer.yscale.r_invert(f,p),2))[0],h=t[1]}var m=[];try{for(var w=i.__values(this.index.indices({x0:n,x1:o,y0:u,y1:h})),M=w.next();!M.done;M=w.next()){var A=M.value,P=Math.pow(this.souter_radius[A],2),I=Math.pow(this.sinner_radius[A],2),b=i.__read(this.renderer.xscale.r_compute(c,this._x[A]),2),V=(y=b[0],x=b[1],i.__read(this.renderer.yscale.r_compute(v,this._y[A]),2)),S=(f=V[0],p=V[1],Math.pow(y-x,2)+Math.pow(f-p,2));S<=P&&S>=I&&m.push(A)}}catch(r){s={error:r}}finally{try{M&&!M.done&&(a=w.return)&&a.call(w)}finally{if(s)throw s.error}}return new _.Selection({indices:m})},e.prototype.draw_legend_for_index=function(r,e,t){var i=e.x0,s=e.y0,a=e.x1,n=e.y1,u=t+1,_=new Array(u);_[t]=(i+a)/2;var o=new Array(u);o[t]=(s+n)/2;var h=.5*Math.min(Math.abs(a-i),Math.abs(n-s)),d=new Array(u);d[t]=.4*h;var l=new Array(u);l[t]=.8*h,this._render(r,[t],{sx:_,sy:o,sinner_radius:d,souter_radius:l})},e}(s.XYGlyphView);t.AnnulusView=o,o.__name__="AnnulusView";var h=function(r){function e(e){return r.call(this,e)||this}return i.__extends(e,r),e.init_Annulus=function(){this.prototype.default_view=o,this.mixins([a.LineVector,a.FillVector]),this.define({inner_radius:[n.DistanceSpec],outer_radius:[n.DistanceSpec]})},e}(s.XYGlyph);t.Annulus=h,h.__name__="Annulus",h.init_Annulus()},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),n=e(208),s=e(215),a=e(143),_=r.__importStar(e(133)),o=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(i,e),i.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},i.prototype._render=function(e,i,t){var n,s,a=t.sx,_=t.sy,o=t.sradius,l=t._start_angle,c=t._end_angle;if(this.visuals.line.doit){var u=this.model.properties.direction.value();try{for(var d=r.__values(i),h=d.next();!h.done;h=d.next()){var p=h.value;isNaN(a[p]+_[p]+o[p]+l[p]+c[p])||(e.beginPath(),e.arc(a[p],_[p],o[p],l[p],c[p],u),this.visuals.line.set_vectorize(e,p),e.stroke())}}catch(e){n={error:e}}finally{try{h&&!h.done&&(s=d.return)&&s.call(d)}finally{if(n)throw n.error}}}},i.prototype.draw_legend_for_index=function(e,i,t){s.generic_line_legend(this.visuals,e,i,t)},i}(n.XYGlyphView);t.ArcView=o,o.__name__="ArcView";var l=function(e){function i(i){return e.call(this,i)||this}return r.__extends(i,e),i.init_Arc=function(){this.prototype.default_view=o,this.mixins(a.LineVector),this.define({direction:[_.Direction,"anticlock"],radius:[_.DistanceSpec],start_angle:[_.AngleSpec],end_angle:[_.AngleSpec]})},i}(n.XYGlyph);t.Arc=l,l.__name__="Arc",l.init_Arc()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),a=e(143),n=e(209),s=e(215),o=e(152),_=r.__importStar(e(133));function c(e,t,i,a,n,s,o,_){for(var c=[],h=[[],[]],p=0;p<=2;p++){var d=void 0,y=void 0,l=void 0;if(0===p?(y=6*e-12*i+6*n,d=-3*e+9*i-9*n+3*o,l=3*i-3*e):(y=6*t-12*a+6*s,d=-3*t+9*a-9*s+3*_,l=3*a-3*t),Math.abs(d)<1e-12){if(Math.abs(y)<1e-12)continue;0<(z=-l/y)&&z<1&&c.push(z)}else{var f=y*y-4*l*d,x=Math.sqrt(f);if(!(f<0)){var u=(-y+x)/(2*d);0<u&&u<1&&c.push(u);var v=(-y-x)/(2*d);0<v&&v<1&&c.push(v)}}}for(var m=c.length,M=m;m--;){var z,C=1-(z=c[m]),S=C*C*C*e+3*C*C*z*i+3*C*z*z*n+z*z*z*o;h[0][m]=S;var w=C*C*C*t+3*C*C*z*a+3*C*z*z*s+z*z*z*_;h[1][m]=w}return h[0][M]=e,h[1][M]=t,h[0][M+1]=o,h[1][M+1]=_,[Math.min.apply(Math,r.__spread(h[0])),Math.max.apply(Math,r.__spread(h[1])),Math.max.apply(Math,r.__spread(h[0])),Math.min.apply(Math,r.__spread(h[1]))]}var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype._project_data=function(){o.inplace.project_xy(this._x0,this._y0),o.inplace.project_xy(this._x1,this._y1)},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++)if(isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx0[i]+this._cy0[i]+this._cx1[i]+this._cy1[i]))e.add_empty();else{var a=r.__read(c(this._x0[i],this._y0[i],this._x1[i],this._y1[i],this._cx0[i],this._cy0[i],this._cx1[i],this._cy1[i]),4),n=a[0],s=a[1],o=a[2],_=a[3];e.add(n,s,o,_)}},t.prototype._render=function(e,t,i){var a,n,s=i.sx0,o=i.sy0,_=i.sx1,c=i.sy1,h=i.scx0,p=i.scy0,d=i.scx1,y=i.scy1;if(this.visuals.line.doit)try{for(var l=r.__values(t),f=l.next();!f.done;f=l.next()){var x=f.value;isNaN(s[x]+o[x]+_[x]+c[x]+h[x]+p[x]+d[x]+y[x])||(e.beginPath(),e.moveTo(s[x],o[x]),e.bezierCurveTo(h[x],p[x],d[x],y[x],_[x],c[x]),this.visuals.line.set_vectorize(e,x),e.stroke())}}catch(e){a={error:e}}finally{try{f&&!f.done&&(n=l.return)&&n.call(l)}finally{if(a)throw a.error}}},t.prototype.draw_legend_for_index=function(e,t,i){s.generic_line_legend(this.visuals,e,t,i)},t.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},t}(n.GlyphView);i.BezierView=h,h.__name__="BezierView";var p=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Bezier=function(){this.prototype.default_view=h,this.define({x0:[_.XCoordinateSpec,{field:"x0"}],y0:[_.YCoordinateSpec,{field:"y0"}],x1:[_.XCoordinateSpec,{field:"x1"}],y1:[_.YCoordinateSpec,{field:"y1"}],cx0:[_.XCoordinateSpec,{field:"cx0"}],cy0:[_.YCoordinateSpec,{field:"cy0"}],cx1:[_.XCoordinateSpec,{field:"cx1"}],cy1:[_.YCoordinateSpec,{field:"cy1"}]}),this.mixins(a.LineVector)},t}(n.Glyph);i.Bezier=p,p.__name__="Bezier",p.init_Bezier()},
function _(i,e,r){Object.defineProperty(r,"__esModule",{value:!0});var s=i(1),t=i(208),a=i(353),n=i(143),d=s.__importStar(i(216)),h=s.__importStar(i(133)),_=i(124),l=i(127),o=i(203),u=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return s.__extends(e,i),e.prototype.initialize=function(){i.prototype.initialize.call(this);var e=this.renderer.plot_view.canvas_view.webgl;null!=e&&(this.glglyph=new a.CircleGL(e.gl,this))},e.prototype._map_data=function(){if(null!=this._radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":var i=this.sdist(this.renderer.xscale,this._x,this._radius),e=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=l.map(i,(function(i,r){return Math.max(i,e[r])}));break;case"min":i=this.sdist(this.renderer.xscale,this._x,this._radius);var r=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=l.map(i,(function(i,e){return Math.min(i,r[e])}))}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=l.map(this._size,(function(i){return i/2}))},e.prototype._mask_data=function(){var i,e,r,t,a,n,d,h,_=s.__read(this.renderer.plot_view.frame.bbox.ranges,2),l=_[0],o=_[1];if(null!=this._radius&&"data"==this.model.properties.radius.units){var u=l.start,c=l.end;a=(i=s.__read(this.renderer.xscale.r_invert(u,c),2))[0],d=i[1],a-=this.max_radius,d+=this.max_radius;var x=o.start,p=o.end;n=(e=s.__read(this.renderer.yscale.r_invert(x,p),2))[0],h=e[1],n-=this.max_radius,h+=this.max_radius}else{u=l.start-this.max_size,c=l.end+this.max_size;a=(r=s.__read(this.renderer.xscale.r_invert(u,c),2))[0],d=r[1];x=o.start-this.max_size,p=o.end+this.max_size;n=(t=s.__read(this.renderer.yscale.r_invert(x,p),2))[0],h=t[1]}return this.index.indices({x0:a,x1:d,y0:n,y1:h})},e.prototype._render=function(i,e,r){var t,a,n=r.sx,d=r.sy,h=r.sradius;try{for(var _=s.__values(e),l=_.next();!l.done;l=_.next()){var o=l.value;isNaN(n[o]+d[o]+h[o])||(i.beginPath(),i.arc(n[o],d[o],h[o],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,o),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,o),i.stroke()))}}catch(i){t={error:i}}finally{try{l&&!l.done&&(a=_.return)&&a.call(_)}finally{if(t)throw t.error}}},e.prototype._hit_point=function(i){var e,r,t,a,n,d,h,_,l,u,c=i.sx,x=i.sy,p=this.renderer.xscale.invert(c),y=this.renderer.yscale.invert(x);if(null!=this._radius&&"data"==this.model.properties.radius.units)h=p-this.max_radius,_=p+this.max_radius,l=y-this.max_radius,u=y+this.max_radius;else{var v=c-this.max_size,m=c+this.max_size;h=(e=s.__read(this.renderer.xscale.r_invert(v,m),2))[0],_=e[1];var f=x-this.max_size,w=x+this.max_size;l=(r=s.__read(this.renderer.yscale.r_invert(f,w),2))[0],u=r[1]}var z=this.index.indices({x0:h,x1:_,y0:l,y1:u}),M=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)try{for(var g=s.__values(z),b=g.next();!b.done;b=g.next()){var S=b.value,C=Math.pow(this.sradius[S],2),k=s.__read(this.renderer.xscale.r_compute(p,this._x[S]),2),V=(v=k[0],m=k[1],s.__read(this.renderer.yscale.r_compute(y,this._y[S]),2));f=V[0],w=V[1];Math.pow(v-m,2)+Math.pow(f-w,2)<=C&&M.push(S)}}catch(i){t={error:i}}finally{try{b&&!b.done&&(a=g.return)&&a.call(g)}finally{if(t)throw t.error}}else try{for(var A=s.__values(z),D=A.next();!D.done;D=A.next()){S=D.value,C=Math.pow(this.sradius[S],2);Math.pow(this.sx[S]-c,2)+Math.pow(this.sy[S]-x,2)<=C&&M.push(S)}}catch(i){n={error:i}}finally{try{D&&!D.done&&(d=A.return)&&d.call(A)}finally{if(n)throw n.error}}return new o.Selection({indices:M})},e.prototype._hit_span=function(i){var e,r,t,a,n,d,h,_,l=i.sx,u=i.sy,c=this.bounds();if("h"==i.direction){var x=void 0,p=void 0;if(h=c.y0,_=c.y1,null!=this._radius&&"data"==this.model.properties.radius.units)x=l-this.max_radius,p=l+this.max_radius,n=(e=s.__read(this.renderer.xscale.r_invert(x,p),2))[0],d=e[1];else x=l-(y=this.max_size/2),p=l+y,n=(r=s.__read(this.renderer.xscale.r_invert(x,p),2))[0],d=r[1]}else{var y,v=void 0,m=void 0;if(n=c.x0,d=c.x1,null!=this._radius&&"data"==this.model.properties.radius.units)v=u-this.max_radius,m=u+this.max_radius,h=(t=s.__read(this.renderer.yscale.r_invert(v,m),2))[0],_=t[1];else v=u-(y=this.max_size/2),m=u+y,h=(a=s.__read(this.renderer.yscale.r_invert(v,m),2))[0],_=a[1]}var f=s.__spread(this.index.indices({x0:n,x1:d,y0:h,y1:_}));return new o.Selection({indices:f})},e.prototype._hit_rect=function(i){var e=i.sx0,r=i.sx1,t=i.sy0,a=i.sy1,n=s.__read(this.renderer.xscale.r_invert(e,r),2),d=n[0],h=n[1],_=s.__read(this.renderer.yscale.r_invert(t,a),2),l=_[0],u=_[1],c=s.__spread(this.index.indices({x0:d,x1:h,y0:l,y1:u}));return new o.Selection({indices:c})},e.prototype._hit_poly=function(i){for(var e=i.sx,r=i.sy,s=_.range(0,this.sx.length),t=[],a=0,n=s.length;a<n;a++){var h=s[a];d.point_in_poly(this.sx[a],this.sy[a],e,r)&&t.push(h)}return new o.Selection({indices:t})},e.prototype.draw_legend_for_index=function(i,e,r){var s=e.x0,t=e.y0,a=e.x1,n=e.y1,d=r+1,h=new Array(d);h[r]=(s+a)/2;var _=new Array(d);_[r]=(t+n)/2;var l=new Array(d);l[r]=.2*Math.min(Math.abs(a-s),Math.abs(n-t)),this._render(i,[r],{sx:h,sy:_,sradius:l})},e}(t.XYGlyphView);r.CircleView=u,u.__name__="CircleView";var c=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_Circle=function(){this.prototype.default_view=u,this.mixins([n.LineVector,n.FillVector]),this.define({angle:[h.AngleSpec,0],size:[h.DistanceSpec,{units:"screen",value:4}],radius:[h.DistanceSpec,void 0,{optional:!0}],radius_dimension:[h.RadiusDimension,"x"]})},e}(t.XYGlyph);r.Circle=c,c.__name__="Circle",c.init_Circle()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var i=t(1),r=t(218),a=t(222),o=t(354),_=t(355),l=t(352),n=t(127),h=t(134),u=t(137);function f(t,e,s,i,r,a){if(r.doit)if(r[a].is_value)e.used=!1,t.set_attribute(s,"float",[r[a].value()]);else{e.used=!0;var o=new Float32Array(r.get_array(a));e.set_size(4*i),e.set_data(0,o),t.set_attribute(s,"float",e)}else e.used=!1,t.set_attribute(s,"float",[0])}function g(t,e,s,i,r,a){var o=a+"_color",_=a+"_alpha";if(r.doit){e.used=!0;var l=void 0;if(r[o].is_value){var n=u.encode_rgba(u.color2rgba(r[o].value()));(f=new Uint32Array(i)).fill(n),l=f}else l=r.get_array(o);var h=void 0;if(r[_].is_value){var f;n=r[_].value();(f=new Float32Array(i)).fill(n),h=f}else h=r.get_array(_);for(var g=new Float32Array(4*i),v=0,d=i;v<d;v++){var b=u.decode_rgba(l[v]);1==b[3]&&(b[3]=h[v]),g.set(b,4*v)}e.set_size(4*i*4),e.set_data(0,g),t.set_attribute(s,"vec4",e)}else e.used=!1,t.set_attribute(s,"vec4",[0,0,0,0])}s.attach_float=f,s.attach_color=g;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.init=function(){var t=this.gl,e=o.vertex_shader,s=_.fragment_shader(this._marker_code);this.prog=new r.Program(t),this.prog.set_shaders(e,s),this.vbo_sx=new r.VertexBuffer(t),this.prog.set_attribute("a_sx","float",this.vbo_sx),this.vbo_sy=new r.VertexBuffer(t),this.prog.set_attribute("a_sy","float",this.vbo_sy),this.vbo_s=new r.VertexBuffer(t),this.prog.set_attribute("a_size","float",this.vbo_s),this.vbo_a=new r.VertexBuffer(t),this.prog.set_attribute("a_angle","float",this.vbo_a),this.vbo_linewidth=new r.VertexBuffer(t),this.vbo_fg_color=new r.VertexBuffer(t),this.vbo_bg_color=new r.VertexBuffer(t),this.index_buffer=new r.IndexBuffer(t)},e.prototype.draw=function(t,e,s){var i=e.glglyph,r=i.nvertices;if(i.data_changed&&(i._set_data(r),this.glyph instanceof l.CircleView&&null!=this.glyph._radius&&this.vbo_s.set_data(0,n.map(this.glyph.sradius,(function(t){return 2*t}))),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(r),this.visuals_changed=!1),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_attribute("a_sx","float",i.vbo_sx),this.prog.set_attribute("a_sy","float",i.vbo_sy),this.prog.set_attribute("a_size","float",i.vbo_s),this.prog.set_attribute("a_angle","float",i.vbo_a),0!=t.length)if(t.length===r)this.prog.draw(this.gl.POINTS,[0,r]);else if(r<65535){var a=window.navigator.userAgent;a.indexOf("MSIE ")+a.indexOf("Trident/")+a.indexOf("Edge/")>0&&h.logger.warn("WebGL warning: IE is known to produce 1px sprites whith selections."),this.index_buffer.set_size(2*t.length),this.index_buffer.set_data(0,new Uint16Array(t)),this.prog.draw(this.gl.POINTS,this.index_buffer)}else{for(var o=[],_=0,u=Math.ceil(r/64e3);_<u;_++)o.push([]);for(_=0,u=t.length;_<u;_++){var f=t[_]%64e3;o[g=Math.floor(t[_]/64e3)].push(f)}var g=0;for(u=o.length;g<u;g++){var v=new Uint16Array(o[g]),d=64e3*g*4;0!==v.length&&(this.prog.set_attribute("a_sx","float",i.vbo_sx,0,d),this.prog.set_attribute("a_sy","float",i.vbo_sy,0,d),this.prog.set_attribute("a_size","float",i.vbo_s,0,d),this.prog.set_attribute("a_angle","float",i.vbo_a,0,d),this.vbo_linewidth.used&&this.prog.set_attribute("a_linewidth","float",this.vbo_linewidth,0,d),this.vbo_fg_color.used&&this.prog.set_attribute("a_fg_color","vec4",this.vbo_fg_color,0,4*d),this.vbo_bg_color.used&&this.prog.set_attribute("a_bg_color","vec4",this.vbo_bg_color,0,4*d),this.index_buffer.set_size(2*v.length),this.index_buffer.set_data(0,v),this.prog.draw(this.gl.POINTS,this.index_buffer))}}},e.prototype._set_data=function(t){var e=4*t;this.vbo_sx.set_size(e),this.vbo_sy.set_size(e),this.vbo_a.set_size(e),this.vbo_s.set_size(e),this.vbo_sx.set_data(0,this.glyph.sx),this.vbo_sy.set_data(0,this.glyph.sy),null!=this.glyph._angle&&this.vbo_a.set_data(0,new Float32Array(this.glyph._angle)),this.glyph instanceof l.CircleView&&null!=this.glyph._radius?this.vbo_s.set_data(0,n.map(this.glyph.sradius,(function(t){return 2*t}))):this.vbo_s.set_data(0,new Float32Array(this.glyph._size))},e.prototype._set_visuals=function(t){f(this.prog,this.vbo_linewidth,"a_linewidth",t,this.glyph.visuals.line,"line_width"),g(this.prog,this.vbo_fg_color,"a_fg_color",t,this.glyph.visuals.line,"line"),g(this.prog,this.vbo_bg_color,"a_bg_color",t,this.glyph.visuals.fill,"fill"),this.prog.set_uniform("u_antialias","float",[.8])},e}(a.BaseGLGlyph);function d(t){return function(e){function s(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(s,e),Object.defineProperty(s.prototype,"_marker_code",{get:function(){return t},enumerable:!0,configurable:!0}),s}(v)}s.MarkerGL=v,v.__name__="MarkerGL";var b=i.__importStar(t(355));s.AsteriskGL=d(b.asterisk),s.CircleGL=d(b.circle),s.CircleCrossGL=d(b.circlecross),s.CircleXGL=d(b.circlex),s.CrossGL=d(b.cross),s.DiamondGL=d(b.diamond),s.DiamondCrossGL=d(b.diamondcross),s.HexGL=d(b.hex),s.InvertedTriangleGL=d(b.invertedtriangle),s.SquareGL=d(b.square),s.SquareCrossGL=d(b.squarecross),s.SquareXGL=d(b.squarex),s.TriangleGL=d(b.triangle),s.XGL=d(b.x)},
function _(n,i,a){Object.defineProperty(a,"__esModule",{value:!0}),a.vertex_shader="\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\n//\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform vec2 u_offset;\nuniform vec2 u_scale;\nuniform float u_antialias;\n//\nattribute float a_sx;\nattribute float a_sy;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4  a_fg_color;\nattribute vec4  a_bg_color;\n//\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying vec2  v_rotation;\n\nvoid main (void)\n{\n    v_size = a_size * u_pixel_ratio;\n    v_linewidth = a_linewidth * u_pixel_ratio;\n    v_fg_color = a_fg_color;\n    v_bg_color = a_bg_color;\n    v_rotation = vec2(cos(-a_angle), sin(-a_angle));\n    vec2 pos = vec2(a_sx, a_sy);  // in pixels\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(pos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n    gl_PointSize = SQRT_2 * v_size + 2.0 * (v_linewidth + 1.5*u_antialias);\n}\n"},
function _(a,n,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fragment_shader=function(a){return"\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\nconst float PI = 3.14159265358979323846264;\n//\nuniform float u_antialias;\n//\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2  v_rotation;\n\n"+a+"\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 fg_color, vec4 bg_color)\n{\n    vec4 frag_color;\n    float t = linewidth/2.0 - antialias;\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If fg alpha is zero, it probably means no outline. To avoid a dark outline\n    // shining through due to aa, we set the fg color to the bg color. Avoid if (i.e. branching).\n    float select = float(bool(fg_color.a));\n    fg_color.rgb = select * fg_color.rgb + (1.0  - select) * bg_color.rgb;\n    // Similarly, if we want a transparent bg\n    select = float(bool(bg_color.a));\n    bg_color.rgb = select * bg_color.rgb + (1.0  - select) * fg_color.rgb;\n\n    if( border_distance < 0.0)\n        frag_color = fg_color;\n    else if( signed_distance < 0.0 ) {\n        frag_color = mix(bg_color, fg_color, sqrt(alpha));\n    } else {\n        if( abs(signed_distance) < (linewidth/2.0 + antialias) ) {\n            frag_color = vec4(fg_color.rgb, fg_color.a * alpha);\n        } else {\n            discard;\n        }\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    vec2 P = gl_PointCoord.xy - vec2(0.5, 0.5);\n    P = vec2(v_rotation.x*P.x - v_rotation.y*P.y,\n             v_rotation.y*P.x + v_rotation.x*P.y);\n    float point_size = SQRT_2*v_size  + 2.0 * (v_linewidth + 1.5*u_antialias);\n    float distance = marker(P*point_size, v_size);\n    gl_FragColor = outline(distance, v_linewidth, u_antialias, v_fg_color, v_bg_color);\n}\n"},s.circle="\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n",s.square="\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n",s.diamond="\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n",s.hex="\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n",s.triangle="\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.invertedtriangle="\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.cross='\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.5;   // 2.5 is a tweak\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(square, cross);\n}\n',s.circlecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.squarecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.diamondcross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.x='\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 1.6;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(circle, X);\n}\n',s.circlex='\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    float almost = min(min(min(c1, c2), c3), c4);\n    // In this case, the X is also outside of the main shape\n    float Xmask = length(P) - size / 1.6;  // a circle\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return min(max(X, Xmask), almost);\n}\n',s.squarex="\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.asterisk='\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / (2.0 * SQRT_2);\n    float square = max(abs(P.x), abs(P.y)) - size / (2.0 * SQRT_2);\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    // Result is union of masked shapes\n    return min(max(X, diamond), max(cross, square));\n}\n'},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),a=e(208),r=e(143),l=i.__importStar(e(133)),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t}(a.XYGlyphView);n.CenterRotatableView=_,_.__name__="CenterRotatableView";var o=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_CenterRotatable=function(){this.mixins([r.LineVector,r.FillVector]),this.define({angle:[l.AngleSpec,0],width:[l.DistanceSpec],height:[l.DistanceSpec]})},t}(a.XYGlyph);n.CenterRotatable=o,o.__name__="CenterRotatable",o.init_CenterRotatable()},
function _(e,i,l){Object.defineProperty(l,"__esModule",{value:!0});var n=e(1),t=e(358),_=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(i,e),i}(t.EllipseOvalView);l.EllipseView=_,_.__name__="EllipseView";var s=function(e){function i(i){return e.call(this,i)||this}return n.__extends(i,e),i.init_Ellipse=function(){this.prototype.default_view=_},i}(t.EllipseOval);l.Ellipse=s,s.__name__="Ellipse",s.init_Ellipse()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),r=t(356),h=s.__importStar(t(216)),a=t(203),n=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},e.prototype._render=function(t,e,i){var r,h,a=i.sx,n=i.sy,l=i.sw,_=i.sh,o=i._angle;try{for(var d=s.__values(e),x=d.next();!x.done;x=d.next()){var p=x.value;isNaN(a[p]+n[p]+l[p]+_[p]+o[p])||(t.beginPath(),t.ellipse(a[p],n[p],l[p]/2,_[p]/2,o[p],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,p),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,p),t.stroke()))}}catch(t){r={error:t}}finally{try{x&&!x.done&&(h=d.return)&&h.call(d)}finally{if(r)throw r.error}}},e.prototype._hit_point=function(t){var e,i,r,n,l,_,o,d,x,p,u,y,c=t.sx,v=t.sy,w=this.renderer.xscale.invert(c),m=this.renderer.yscale.invert(v);"data"==this.model.properties.width.units?(l=w-this.max_width,_=w+this.max_width):(x=c-this.max_width,p=c+this.max_width,l=(e=s.__read(this.renderer.xscale.r_invert(x,p),2))[0],_=e[1]),"data"==this.model.properties.height.units?(o=m-this.max_height,d=m+this.max_height):(u=v-this.max_height,y=v+this.max_height,o=(i=s.__read(this.renderer.yscale.r_invert(u,y),2))[0],d=i[1]);var f=this.index.indices({x0:l,x1:_,y0:o,y1:d}),g=[];try{for(var b=s.__values(f),M=b.next();!M.done;M=b.next()){var O=M.value;h.point_in_ellipse(c,v,this._angle[O],this.sh[O]/2,this.sw[O]/2,this.sx[O],this.sy[O])&&g.push(O)}}catch(t){r={error:t}}finally{try{M&&!M.done&&(n=b.return)&&n.call(b)}finally{if(r)throw r.error}}return new a.Selection({indices:g})},e.prototype.draw_legend_for_index=function(t,e,i){var s=e.x0,r=e.y0,h=e.x1,a=e.y1,n=i+1,l=new Array(n);l[i]=(s+h)/2;var _=new Array(n);_[i]=(r+a)/2;var o=this.sw[i]/this.sh[i],d=.8*Math.min(Math.abs(h-s),Math.abs(a-r)),x=new Array(n),p=new Array(n);o>1?(x[i]=d,p[i]=d/o):(x[i]=d*o,p[i]=d),this._render(t,[i],{sx:l,sy:_,sw:x,sh:p,_angle:[0]})},e.prototype._bounds=function(t){var e=t.x0,i=t.x1,s=t.y0,r=t.y1;return{x0:e-this.max_w2,x1:i+this.max_w2,y0:s-this.max_h2,y1:r+this.max_h2}},e}(r.CenterRotatableView);i.EllipseOvalView=n,n.__name__="EllipseOvalView";var l=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e}(r.CenterRotatable);i.EllipseOval=l,l.__name__="EllipseOval"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),r=t(360),h=t(139),n=s.__importStar(t(133)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.scenterxy=function(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]},e.prototype._lrtb=function(t){return[Math.min(this._left[t],this._right[t]),Math.max(this._left[t],this._right[t]),this._y[t]+.5*this._height[t],this._y[t]-.5*this._height[t]]},e.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new h.NumberArray(t),this.sbottom=new h.NumberArray(t);for(var e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()},e}(r.BoxView);i.HBarView=_,_.__name__="HBarView";var o=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_HBar=function(){this.prototype.default_view=_,this.define({left:[n.XCoordinateSpec,{value:0}],y:[n.YCoordinateSpec,{field:"y"}],height:[n.NumberSpec,{value:1}],right:[n.XCoordinateSpec,{field:"right"}]})},e}(r.Box);i.HBar=o,o.__name__="HBar",o.init_HBar()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),n=t(143),s=t(209),o=t(215),a=t(203),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.get_anchor_point=function(t,e,r){var i=Math.min(this.sleft[e],this.sright[e]),n=Math.max(this.sright[e],this.sleft[e]),s=Math.min(this.stop[e],this.sbottom[e]),o=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:s};case"top_center":return{x:(i+n)/2,y:s};case"top_right":return{x:n,y:s};case"bottom_left":return{x:i,y:o};case"bottom_center":return{x:(i+n)/2,y:o};case"bottom_right":return{x:n,y:o};case"center_left":return{x:i,y:(s+o)/2};case"center":return{x:(i+n)/2,y:(s+o)/2};case"center_right":return{x:n,y:(s+o)/2};default:return null}},e.prototype._index_data=function(t){for(var e=Math.min,r=Math.max,n=this.data_size,s=0;s<n;s++){var o=i.__read(this._lrtb(s),4),a=o[0],h=o[1],_=o[2],c=o[3];isNaN(a+h+_+c)||!isFinite(a+h+_+c)?t.add_empty():t.add(e(a,h),e(_,c),r(h,a),r(_,c))}},e.prototype._render=function(t,e,r){var n,s,o=this,a=r.sleft,h=r.sright,_=r.stop,c=r.sbottom,l=function(e){if(isNaN(a[e]+_[e]+h[e]+c[e]))return"continue";t.rect(a[e],_[e],h[e]-a[e],c[e]-_[e]),d.visuals.fill.doit&&(d.visuals.fill.set_vectorize(t,e),t.beginPath(),t.rect(a[e],_[e],h[e]-a[e],c[e]-_[e]),t.fill()),d.visuals.hatch.doit2(t,e,(function(){t.beginPath(),t.rect(a[e],_[e],h[e]-a[e],c[e]-_[e]),t.fill()}),(function(){return o.renderer.request_render()})),d.visuals.line.doit&&(d.visuals.line.set_vectorize(t,e),t.beginPath(),t.rect(a[e],_[e],h[e]-a[e],c[e]-_[e]),t.stroke())},d=this;try{for(var u=i.__values(e),x=u.next();!x.done;x=u.next()){l(x.value)}}catch(t){n={error:t}}finally{try{x&&!x.done&&(s=u.return)&&s.call(u)}finally{if(n)throw n.error}}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,r=this.stop.length,i=0;i<r;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,r=t.sy,n=this.renderer.xscale.invert(e),s=this.renderer.yscale.invert(r),o=i.__spread(this.index.indices({x0:n,y0:s,x1:n,y1:s}));return new a.Selection({indices:o})},e.prototype._hit_span=function(t){var e,r=t.sx,n=t.sy;if("v"==t.direction){var s=this.renderer.yscale.invert(n),o=this.renderer.plot_view.frame.bbox.h_range,h=i.__read(this.renderer.xscale.r_invert(o.start,o.end),2),_=h[0],c=h[1];e=i.__spread(this.index.indices({x0:_,y0:s,x1:c,y1:s}))}else{var l=this.renderer.xscale.invert(r),d=this.renderer.plot_view.frame.bbox.v_range,u=i.__read(this.renderer.yscale.r_invert(d.start,d.end),2),x=u[0],f=u[1];e=i.__spread(this.index.indices({x0:l,y0:x,x1:l,y1:f}))}return new a.Selection({indices:e})},e.prototype.draw_legend_for_index=function(t,e,r){o.generic_area_legend(this.visuals,t,e,r)},e}(s.GlyphView);r.BoxView=h,h.__name__="BoxView";var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Box=function(){this.mixins([n.LineVector,n.FillVector,n.HatchVector])},e}(s.Glyph);r.Box=_,_.__name__="Box",_.init_Box()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),s=e(209),n=i.__importStar(e(216)),a=i.__importStar(e(133)),o=e(143),_=e(139),l=e(152),h=e(215),c=e(203),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.scenterxy=function(e){return[this.sx[e],this.sy[e]]},t.prototype._set_data=function(){var e=this._q.length,t=this.model,r=t.orientation,i=t.size,s=t.aspect_scale;this._x=new _.NumberArray(e),this._y=new _.NumberArray(e);var n=Math.sqrt(3);if("pointytop"==r)for(var a=0;a<e;a++)this._x[a]=i*n*(this._q[a]+this._r[a]/2)/s,this._y[a]=3*-i/2*this._r[a];else for(a=0;a<e;a++)this._x[a]=3*i/2*this._q[a],this._y[a]=-i*n*(this._r[a]+this._q[a]/2)*s},t.prototype._project_data=function(){l.inplace.project_xy(this._x,this._y)},t.prototype._index_data=function(e){var t,r=this.model.size,s=Math.sqrt(3)*r/2;"flattop"==this.model.orientation?(s=(t=i.__read([r,s],2))[0],r=t[1],r*=this.model.aspect_scale):s/=this.model.aspect_scale;for(var n=this.data_size,a=0;a<n;a++){var o=this._x[a],_=this._y[a];isNaN(o+_)||!isFinite(o+_)?e.add_empty():e.add(o-s,_-r,o+s,_+r)}},t.prototype.map_data=function(){var e,t;e=i.__read(this.renderer.coordinates.map_to_screen(this._x,this._y),2),this.sx=e[0],this.sy=e[1],t=i.__read(this._get_unscaled_vertices(),2),this.svx=t[0],this.svy=t[1]},t.prototype._get_unscaled_vertices=function(){var e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){var r=this.renderer.yscale,i=this.renderer.xscale,s=Math.abs(r.compute(0)-r.compute(e));return[[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t),-n,0,n,n],[s,a=s/2,-a,-s,-a,a]]}var n,a;r=this.renderer.xscale,i=this.renderer.yscale;return[[s=Math.abs(r.compute(0)-r.compute(e)),a=s/2,-a,-s,-a,a],[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t),-n,0,n,n]]},t.prototype._render=function(e,t,r){var s,n,a=r.sx,o=r.sy,_=r.svx,l=r.svy,h=r._scale;try{for(var c=i.__values(t),d=c.next();!d.done;d=c.next()){var p=d.value;if(!isNaN(a[p]+o[p]+h[p])){e.translate(a[p],o[p]),e.beginPath();for(var y=0;y<6;y++)e.lineTo(_[y]*h[p],l[y]*h[p]);e.closePath(),e.translate(-a[p],-o[p]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,p),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,p),e.stroke())}}}catch(e){s={error:e}}finally{try{d&&!d.done&&(n=c.return)&&n.call(c)}finally{if(s)throw s.error}}},t.prototype._hit_point=function(e){var t,r,s=e.sx,a=e.sy,o=this.renderer.xscale.invert(s),_=this.renderer.yscale.invert(a),l=this.index.indices({x0:o,y0:_,x1:o,y1:_}),h=[];try{for(var d=i.__values(l),p=d.next();!p.done;p=d.next()){var y=p.value;n.point_in_poly(s-this.sx[y],a-this.sy[y],this.svx,this.svy)&&h.push(y)}}catch(e){t={error:e}}finally{try{p&&!p.done&&(r=d.return)&&r.call(d)}finally{if(t)throw t.error}}return new c.Selection({indices:h})},t.prototype._hit_span=function(e){var t,r=e.sx,s=e.sy;if("v"==e.direction){var n=this.renderer.yscale.invert(s),a=this.renderer.plot_view.frame.bbox.h_range,o=i.__read(this.renderer.xscale.r_invert(a.start,a.end),2),_=o[0],l=o[1];t=i.__spread(this.index.indices({x0:_,y0:n,x1:l,y1:n}))}else{var h=this.renderer.xscale.invert(r),d=this.renderer.plot_view.frame.bbox.v_range,p=i.__read(this.renderer.yscale.r_invert(d.start,d.end),2),y=p[0],u=p[1];t=i.__spread(this.index.indices({x0:h,y0:y,x1:h,y1:u}))}return new c.Selection({indices:t})},t.prototype._hit_rect=function(e){var t=e.sx0,r=e.sx1,s=e.sy0,n=e.sy1,a=i.__read(this.renderer.xscale.r_invert(t,r),2),o=a[0],_=a[1],l=i.__read(this.renderer.yscale.r_invert(s,n),2),h=l[0],d=l[1],p=i.__spread(this.index.indices({x0:o,x1:_,y0:h,y1:d}));return new c.Selection({indices:p})},t.prototype.draw_legend_for_index=function(e,t,r){h.generic_area_legend(this.visuals,e,t,r)},t}(s.GlyphView);r.HexTileView=d,d.__name__="HexTileView";var p=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_HexTile=function(){this.prototype.default_view=d,this.mixins([o.LineVector,o.FillVector]),this.define({r:[a.NumberSpec],q:[a.NumberSpec],size:[a.Number,1],aspect_scale:[a.Number,1],scale:[a.NumberSpec,1],orientation:[a.HexTileOrientation,"pointytop"]}),this.override({line_color:null})},t}(s.Glyph);r.HexTile=p,p.__name__="HexTile",p.init_HexTile()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),a=e(363),r=e(256),o=i.__importStar(e(133)),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.color_mapper.change,(function(){return t._update_image()}))},t.prototype._update_image=function(){null!=this.image_data&&(this._set_data(null),this.renderer.plot_view.request_render())},t.prototype._flat_img_to_buf8=function(e){return this.model.color_mapper.rgba_mapper.v_compute(e)},t}(a.ImageBaseView);n.ImageView=_,_.__name__="ImageView";var p=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Image=function(){this.prototype.default_view=_,this.define({color_mapper:[o.Instance,function(){return new r.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]})},t}(a.ImageBase);n.Image=p,p.__name__="Image",p.init_Image()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var a=e(1),r=e(208),s=e(139),h=a.__importStar(e(133)),n=e(203),_=e(124),d=e(145),o=e(126),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._render=function(e,t,i){var r,s,h=i.image_data,n=i.sx,_=i.sy,d=i.sw,o=i.sh,l=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;try{for(var g=a.__values(t),c=g.next();!c.done;c=g.next()){var u=c.value;if(null!=h[u]&&!isNaN(n[u]+_[u]+d[u]+o[u])){var m=_[u];e.translate(0,m),e.scale(1,-1),e.translate(0,-m),e.drawImage(h[u],0|n[u],0|_[u],d[u],o[u]),e.translate(0,m),e.scale(1,-1),e.translate(0,-m)}}}catch(e){r={error:e}}finally{try{c&&!c.done&&(s=g.return)&&s.call(g)}finally{if(r)throw r.error}}e.setImageSmoothingEnabled(l)},t.prototype._set_data=function(e){this._set_width_heigh_data();for(var t=0,i=this._image.length;t<i;t++)if(!(null!=e&&e.indexOf(t)<0)){var a=this._image[t],r=void 0;d.is_NDArray(a)?(o.assert(2==a.dimension,"expected a 2D array"),r=a,this._height[t]=a.shape[0],this._width[t]=a.shape[1]):(r=_.concat(a),this._height[t]=a.length,this._width[t]=a[0].length);var s=this._flat_img_to_buf8(r);this._set_image_data_from_buffer(t,s)}},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++){var r=a.__read(this._lrtb(i),4),s=r[0],h=r[1],n=r[2],_=r[3];isNaN(s+h+n+_)||!isFinite(s+h+n+_)?e.add_empty():e.add(s,_,h,n)}},t.prototype._lrtb=function(e){var t=this.renderer.xscale.source_range,i=this._x[e],r=t.is_reversed?i-this._dw[e]:i+this._dw[e],s=this.renderer.yscale.source_range,h=this._y[e],n=s.is_reversed?h-this._dh[e]:h+this._dh[e],_=a.__read(i<r?[i,r]:[r,i],2),d=_[0],o=_[1],l=a.__read(h<n?[h,n]:[n,h],2),g=l[0];return[d,o,l[1],g]},t.prototype._set_width_heigh_data=function(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new s.NumberArray(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new s.NumberArray(this._image.length))},t.prototype._get_or_create_canvas=function(e){var t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;var i=document.createElement("canvas");return i.width=this._width[e],i.height=this._height[e],i},t.prototype._set_image_data_from_buffer=function(e,t){var i=this._get_or_create_canvas(e),a=i.getContext("2d"),r=a.getImageData(0,0,this._width[e],this._height[e]);r.data.set(t),a.putImageData(r,0,0),this.image_data[e]=i},t.prototype._map_data=function(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}},t.prototype._image_index=function(e,t,i){var r=a.__read(this._lrtb(e),4),s=r[0],h=r[1],n=r[2],_=r[3],d=this._width[e],o=this._height[e],l=(h-s)/d,g=(n-_)/o,c=Math.floor((t-s)/l),u=Math.floor((i-_)/g);return this.renderer.xscale.source_range.is_reversed&&(c=d-c-1),this.renderer.yscale.source_range.is_reversed&&(u=o-u-1),{index:e,dim1:c,dim2:u,flat_index:u*d+c}},t.prototype._hit_point=function(e){var t,i,r=e.sx,s=e.sy,h=this.renderer.xscale.invert(r),_=this.renderer.yscale.invert(s),d=this.index.indices({x0:h,x1:h,y0:_,y1:_}),o=new n.Selection;try{for(var l=a.__values(d),g=l.next();!g.done;g=l.next()){var c=g.value;r!=1/0&&s!=1/0&&o.image_indices.push(this._image_index(c,h,_))}}catch(e){t={error:e}}finally{try{g&&!g.done&&(i=l.return)&&i.call(l)}finally{if(t)throw t.error}}return o},t}(r.XYGlyphView);i.ImageBaseView=l,l.__name__="ImageBaseView";var g=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_ImageBase=function(){this.define({image:[h.NDArraySpec],dw:[h.DistanceSpec],dh:[h.DistanceSpec],dilate:[h.Boolean,!1],global_alpha:[h.Number,1]})},t}(r.XYGlyph);i.ImageBase=g,g.__name__="ImageBase",g.init_ImageBase()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(363),a=e(123),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._flat_img_to_buf8=function(e){var t;return t=a.isArray(e)?new Uint32Array(e):e,new Uint8Array(t.buffer)},t}(r.ImageBaseView);n.ImageRGBAView=_,_.__name__="ImageRGBAView";var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_ImageRGBA=function(){this.prototype.default_view=_},t}(r.ImageBase);n.ImageRGBA=u,u.__name__="ImageRGBA",u.init_ImageRGBA()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),a=e(208),n=e(139),s=i.__importStar(e(133)),o=e(127),_=e(366),h=function(e){function t(){var t=e.apply(this,i.__spread(arguments))||this;return t._images_rendered=!1,t}return i.__extends(t,e),t.prototype.initialize=function(){var t=this;e.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++)e.add_empty()},t.prototype._set_data=function(){var e,t,r=this;null!=this.image&&this.image.length==this._url.length||(this.image=o.map(this._url,(function(){return null})));for(var a=this.model,s=a.retry_attempts,h=a.retry_timeout,c=function(e,t){var i=l._url[e];if(null==i||""==i)return"continue";new _.ImageLoader(i,{loaded:function(t){r.image[e]=t,r.renderer.request_render()},attempts:s+1,timeout:h})},l=this,u=0,d=this._url.length;u<d;u++)c(u);var p="data"==this.model.properties.w.units,m="data"==this.model.properties.h.units,f=this._x.length,g=new n.NumberArray(p?2*f:f),y=new n.NumberArray(m?2*f:f),b=this.model.anchor;function w(e,t){switch(b){case"top_left":case"bottom_left":case"center_left":return[e,e+t];case"top_center":case"bottom_center":case"center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"center_right":return[e-t,e]}}function v(e,t){switch(b){case"top_left":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom_center":case"bottom_right":return[e+t,e];case"center_left":case"center":case"center_right":return[e+t/2,e-t/2]}}if(p)for(u=0;u<f;u++)e=i.__read(w(this._x[u],this._w[u]),2),g[u]=e[0],g[f+u]=e[1];else g.set(this._x,0);if(m)for(u=0;u<f;u++)t=i.__read(v(this._y[u],this._h[u]),2),y[u]=t[0],y[f+u]=t[1];else y.set(this._y,0);var x=i.__read(o.minmax(g),2),N=x[0],I=x[1],L=i.__read(o.minmax(y),2),R=L[0],S=L[1];this._bounds_rect={x0:N,x1:I,y0:R,y1:S}},t.prototype.has_finished=function(){return e.prototype.has_finished.call(this)&&1==this._images_rendered},t.prototype._map_data=function(){var e=null!=this.model.w?this._w:o.map(this._x,(function(){return NaN})),t=null!=this.model.h?this._h:o.map(this._x,(function(){return NaN}));switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,e,"edge",this.model.dilate);break;case"screen":this.sw=e}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,t,"edge",this.model.dilate);break;case"screen":this.sh=t}},t.prototype._render=function(e,t,r){var a,n,s=r.image,o=r.sx,_=r.sy,h=r.sw,c=r.sh,l=r._angle,u=this.renderer.plot_view.frame;e.rect(u.bbox.left+1,u.bbox.top+1,u.bbox.width-2,u.bbox.height-2),e.clip();var d=!0;try{for(var p=i.__values(t),m=p.next();!m.done;m=p.next()){var f=m.value;if(!isNaN(o[f]+_[f]+l[f])){var g=s[f];null!=g?this._render_image(e,f,g,o,_,h,c,l):d=!1}}}catch(e){a={error:e}}finally{try{m&&!m.done&&(n=p.return)&&n.call(p)}finally{if(a)throw a.error}}d&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},t.prototype._final_sx_sy=function(e,t,r,i,a){switch(e){case"top_left":return[t,r];case"top_center":return[t-i/2,r];case"top_right":return[t-i,r];case"center_right":return[t-i,r-a/2];case"bottom_right":return[t-i,r-a];case"bottom_center":return[t-i/2,r-a];case"bottom_left":return[t,r-a];case"center_left":return[t,r-a/2];case"center":return[t-i/2,r-a/2]}},t.prototype._render_image=function(e,t,r,a,n,s,o,_){isNaN(s[t])&&(s[t]=r.width),isNaN(o[t])&&(o[t]=r.height);var h=this.model.anchor,c=i.__read(this._final_sx_sy(h,a[t],n[t],s[t],o[t]),2),l=c[0],u=c[1];e.save(),e.globalAlpha=this.model.global_alpha;var d=s[t]/2,p=o[t]/2;_[t]?(e.translate(l,u),e.translate(d,p),e.rotate(_[t]),e.translate(-d,-p),e.drawImage(r,0,0,s[t],o[t]),e.translate(d,p),e.rotate(-_[t]),e.translate(-d,-p),e.translate(-l,-u)):e.drawImage(r,l,u,s[t],o[t]),e.restore()},t.prototype.bounds=function(){return this._bounds_rect},t}(a.XYGlyphView);r.ImageURLView=h,h.__name__="ImageURLView";var c=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_ImageURL=function(){this.prototype.default_view=h,this.define({url:[s.StringSpec],anchor:[s.Anchor,"top_left"],global_alpha:[s.Number,1],angle:[s.AngleSpec,0],w:[s.DistanceSpec],h:[s.DistanceSpec],dilate:[s.Boolean,!1],retry_attempts:[s.Number,0],retry_timeout:[s.Number,0]})},t}(a.XYGlyph);r.ImageURL=c,c.__name__="ImageURL",c.init_ImageURL()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(134),t=function(){function e(e,i){var n=this;void 0===i&&(i={}),this._image=new Image,this._finished=!1;var t=i.attempts,r=void 0===t?1:t,a=i.timeout,g=void 0===a?1:a;this.promise=new Promise((function(t,a){n._image.crossOrigin="anonymous";var u=0;n._image.onerror=function(){if(++u==r){var t="unable to load "+e+" image after "+r+" attempts";if(o.logger.warn(t),null==n._image.crossOrigin)return void(null!=i.failed&&i.failed());o.logger.warn("attempting to load "+e+" without a cross origin policy"),n._image.crossOrigin=null,u=0}setTimeout((function(){return n._image.src=e}),g)},n._image.onload=function(){n._finished=!0,null!=i.loaded&&i.loaded(n._image),t(n._image)},n._image.src=e}))}return Object.defineProperty(e.prototype,"finished",{get:function(){return this._finished},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"image",{get:function(){return this._image},enumerable:!0,configurable:!0}),e}();n.ImageLoader=t,t.__name__="ImageLoader"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),r=e(152),s=e(143),o=n.__importStar(e(216)),a=n.__importStar(e(133)),_=e(127),l=e(128),h=e(209),c=e(215),d=e(203),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype._project_data=function(){r.inplace.project_xy(this._xs.array,this._ys.array)},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++){var r=this._xs.get(i);if(0!=r.length){var s=this._ys.get(i);if(0!=s.length){var o=n.__read(_.minmax(r),2),a=o[0],l=o[1],h=n.__read(_.minmax(s),2),c=h[0],d=h[1];e.add(a,c,l,d)}else e.add_empty()}else e.add_empty()}},t.prototype._render=function(e,t,i){var r,s,o=i.sxs,a=i.sys;try{for(var _=n.__values(t),l=_.next();!l.done;l=_.next()){var h=l.value,c=o.get(h),d=a.get(h);this.visuals.line.set_vectorize(e,h);for(var p=0,u=c.length;p<u;p++)0!=p?isNaN(c[p])||isNaN(d[p])?(e.stroke(),e.beginPath()):e.lineTo(c[p],d[p]):(e.beginPath(),e.moveTo(c[p],d[p]));e.stroke()}}catch(e){r={error:e}}finally{try{l&&!l.done&&(s=_.return)&&s.call(_)}finally{if(r)throw r.error}}},t.prototype._hit_point=function(e){for(var t={x:e.sx,y:e.sy},i=9999,r=new Map,s=0,a=this.sxs.length;s<a;s++){for(var _=Math.max(2,this.visuals.line.cache_select("line_width",s)/2),h=this.sxs.get(s),c=this.sys.get(s),p=null,u=0,y=h.length-1;u<y;u++){var f={x:h[u],y:c[u]},v={x:h[u+1],y:c[u+1]},x=o.dist_to_segment(t,f,v);x<_&&x<i&&(i=x,p=[u])}null!=p&&r.set(s,p)}return new d.Selection({indices:n.__spread(r.keys()),multiline_indices:l.to_object(r)})},t.prototype._hit_span=function(e){var t,i,r=e.sx,s=e.sy;"v"==e.direction?(t=this.renderer.yscale.invert(s),i=this._ys):(t=this.renderer.xscale.invert(r),i=this._xs);for(var o=new Map,a=0,_=i.length;a<_;a++){for(var h=i.get(a),c=[],p=0,u=h.length-1;p<u;p++)h[p]<=t&&t<=h[p+1]&&c.push(p);c.length>0&&o.set(a,c)}return new d.Selection({indices:n.__spread(o.keys()),multiline_indices:l.to_object(o)})},t.prototype.get_interpolation_hit=function(e,t,i){var n=this._xs.get(e),r=this._ys.get(e),s=n[t],o=r[t],a=n[t+1],_=r[t+1];return c.line_interpolation(this.renderer,i,s,o,a,_)},t.prototype.draw_legend_for_index=function(e,t,i){c.generic_line_legend(this.visuals,e,t,i)},t.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},t}(h.GlyphView);i.MultiLineView=p,p.__name__="MultiLineView";var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_MultiLine=function(){this.prototype.default_view=p,this.define({xs:[a.XCoordinateSeqSpec,{field:"xs"}],ys:[a.YCoordinateSeqSpec,{field:"ys"}]}),this.mixins(s.LineVector)},t}(h.Glyph);i.MultiLine=u,u.__name__="MultiLine",u.init_MultiLine()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(210),s=e(209),o=e(215),a=e(127),_=e(127),l=e(143),h=i.__importStar(e(216)),d=i.__importStar(e(133)),y=e(203),f=e(126),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._project_data=function(){},t.prototype._index_data=function(e){for(var t=Math.min,r=Math.max,n=this.data_size,s=0;s<n;s++){var o=this._xs[s],_=this._ys[s];if(0!=o.length&&0!=_.length){for(var l=1/0,h=-1/0,d=1/0,y=-1/0,f=0,p=o.length;f<p;f++){var u=o[f][0],v=_[f][0];if(0!=u.length&&0!=v.length){var c=i.__read(a.minmax(u),2),x=c[0],g=c[1],m=i.__read(a.minmax(v),2),w=m[0],S=m[1];l=t(l,x),h=r(h,g),d=t(d,w),y=r(y,S)}}isFinite(l+h+d+y)?e.add(l,d,h,y):e.add_empty()}else e.add_empty()}this._hole_index=this._index_hole_data()},t.prototype._index_hole_data=function(){for(var e=Math.min,t=Math.max,r=this.data_size,s=new n.SpatialIndex(r),o=0;o<r;o++){var _=this._xs[o],l=this._ys[o];if(0!=_.length&&0!=l.length){for(var h=1/0,d=-1/0,y=1/0,f=-1/0,p=0,u=_.length;p<u;p++){var v=_[p],c=l[p];if(v.length>1&&c.length>1)for(var x=1,g=v.length;x<g;x++){var m=i.__read(a.minmax(v[x]),2),w=m[0],S=m[1],M=i.__read(a.minmax(c[x]),2),P=M[0],q=M[1];h=e(h,w),d=t(d,S),y=e(y,P),f=t(f,q)}}isFinite(h+d+y+f)?s.add(h,y,d,f):s.add_empty()}else s.add_empty()}return s.finish(),s},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame.x_range,t=i.__read([e.min,e.max],2),r=t[0],n=t[1],s=this.renderer.plot_view.frame.y_range,o=i.__read([s.min,s.max],2),a=o[0],_=o[1];return this.index.indices({x0:r,x1:n,y0:a,y1:_})},t.prototype._inner_loop=function(e,t,r){e.beginPath();for(var i=0,n=t.length;i<n;i++)for(var s=0,o=t[i].length;s<o;s++){for(var a=t[i][s],_=r[i][s],l=0,h=a.length;l<h;l++)0!=l?e.lineTo(a[l],_[l]):e.moveTo(a[l],_[l]);e.closePath()}},t.prototype._render=function(e,t,r){var n,s,o=this,a=r.sxs,_=r.sys;if(this.visuals.fill.doit||this.visuals.line.doit){var l=function(t){var r=i.__read([a[t],_[t]],2),n=r[0],s=r[1];h.visuals.fill.doit&&(h.visuals.fill.set_vectorize(e,t),h._inner_loop(e,n,s),e.fill("evenodd")),h.visuals.hatch.doit2(e,t,(function(){o._inner_loop(e,n,s),e.fill("evenodd")}),(function(){return o.renderer.request_render()})),h.visuals.line.doit&&(h.visuals.line.set_vectorize(e,t),h._inner_loop(e,n,s),e.stroke())},h=this;try{for(var d=i.__values(t),y=d.next();!y.done;y=d.next()){l(y.value)}}catch(e){n={error:e}}finally{try{y&&!y.done&&(s=d.return)&&s.call(d)}finally{if(n)throw n.error}}}},t.prototype._hit_rect=function(e){var t,r,n=e.sx0,s=e.sx1,o=e.sy0,a=e.sy1,_=[n,s,s,n],l=[o,o,a,a],d=i.__read(this.renderer.xscale.r_invert(n,s),2),f=d[0],p=d[1],u=i.__read(this.renderer.yscale.r_invert(o,a),2),v=u[0],c=u[1],x=this.index.indices({x0:f,x1:p,y0:v,y1:c}),g=[];try{for(var m=i.__values(x),w=m.next();!w.done;w=m.next()){for(var S=w.value,M=this.sxs[S],P=this.sys[S],q=!0,b=0,A=M.length;b<A;b++){for(var V=0,k=M[b][0].length;V<k;V++){var z=M[b][0][V],F=P[b][0][V];if(!h.point_in_poly(z,F,_,l)){q=!1;break}}if(!q)break}q&&g.push(S)}}catch(e){t={error:e}}finally{try{w&&!w.done&&(r=m.return)&&r.call(m)}finally{if(t)throw t.error}}return new y.Selection({indices:g})},t.prototype._hit_point=function(e){var t,r,n=e.sx,s=e.sy,o=this.renderer.xscale.invert(n),a=this.renderer.yscale.invert(s),_=this.index.indices({x0:o,y0:a,x1:o,y1:a}),l=this._hole_index.indices({x0:o,y0:a,x1:o,y1:a}),d=[];try{for(var f=i.__values(_),p=f.next();!p.done;p=f.next())for(var u=p.value,v=this.sxs[u],c=this.sys[u],x=0,g=v.length;x<g;x++){var m=v[x].length;if(h.point_in_poly(n,s,v[x][0],c[x][0]))if(1==m)d.push(u);else if(l.get(u)){if(m>1){for(var w=!1,S=1;S<m;S++){var M=v[x][S],P=c[x][S];if(h.point_in_poly(n,s,M,P)){w=!0;break}}w||d.push(u)}}else d.push(u)}}catch(e){t={error:e}}finally{try{p&&!p.done&&(r=f.return)&&r.call(f)}finally{if(t)throw t.error}}return new y.Selection({indices:d})},t.prototype._get_snap_coord=function(e){return _.sum(e)/e.length},t.prototype.scenterxy=function(e,t,r){if(1==this.sxs[e].length)return[this._get_snap_coord(this.sxs[e][0][0]),this._get_snap_coord(this.sys[e][0][0])];for(var i=this.sxs[e],n=this.sys[e],s=0,o=i.length;s<o;s++){if(h.point_in_poly(t,r,i[s][0],n[s][0]))return[this._get_snap_coord(i[s][0]),this._get_snap_coord(n[s][0])]}f.unreachable()},t.prototype.map_data=function(){var e=this._xs.length;this.sxs=new Array(e),this.sys=new Array(e);for(var t=0;t<e;t++){var r=this._xs[t].length;this.sxs[t]=new Array(r),this.sys[t]=new Array(r);for(var n=0;n<r;n++){var s=this._xs[t][n].length;this.sxs[t][n]=new Array(s),this.sys[t][n]=new Array(s);for(var o=0;o<s;o++){var a=i.__read(this.renderer.coordinates.map_to_screen(this._xs[t][n][o],this._ys[t][n][o]),2),_=a[0],l=a[1];this.sxs[t][n][o]=_,this.sys[t][n][o]=l}}}},t.prototype.draw_legend_for_index=function(e,t,r){o.generic_area_legend(this.visuals,e,t,r)},t}(s.GlyphView);r.MultiPolygonsView=p,p.__name__="MultiPolygonsView";var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_MultiPolygons=function(){this.prototype.default_view=p,this.define({xs:[d.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[d.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}),this.mixins([l.LineVector,l.FillVector,l.HatchVector])},t}(s.Glyph);r.MultiPolygons=u,u.__name__="MultiPolygons",u.init_MultiPolygons()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),a=t(358),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._map_data=function(){t.prototype._map_data.call(this);for(var e=this.sw,n=e.length,i=0;i<n;i++)e[i]*=.75},e}(a.EllipseOvalView);n.OvalView=l,l.__name__="OvalView";var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Oval=function(){this.prototype.default_view=l},e}(a.EllipseOval);n.Oval=_,_.__name__="Oval",_.init_Oval()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(209),a=e(215),s=e(127),o=e(143),_=i.__importStar(e(216)),l=i.__importStar(e(133)),c=e(203),h=e(126),d=e(152),y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._project_data=function(){d.inplace.project_xy(this._xs.array,this._ys.array)},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++){var n=this._xs.get(r),a=this._ys.get(r);if(0==n.length)e.add_empty();else{var o=i.__read(s.minmax(n),2),_=o[0],l=o[1],c=i.__read(s.minmax(a),2),h=c[0],d=c[1];e.add(_,h,l,d)}}},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame.x_range,t=i.__read([e.min,e.max],2),r=t[0],n=t[1],a=this.renderer.plot_view.frame.y_range,s=i.__read([a.min,a.max],2),o=s[0],_=s[1];return this.index.indices({x0:r,x1:n,y0:o,y1:_})},t.prototype._inner_loop=function(e,t,r,i){for(var n=0,a=t.length;n<a;n++)0!=n?isNaN(t[n]+r[n])?(e.closePath(),i.apply(e),e.beginPath()):e.lineTo(t[n],r[n]):(e.beginPath(),e.moveTo(t[n],r[n]));e.closePath(),i.call(e)},t.prototype._render=function(e,t,r){var n,a,s=this,o=r.sxs,_=r.sys,l=function(t){var r=o.get(t),i=_.get(t);c.visuals.fill.doit&&(c.visuals.fill.set_vectorize(e,t),c._inner_loop(e,r,i,e.fill)),c.visuals.hatch.doit2(e,t,(function(){return s._inner_loop(e,r,i,e.fill)}),(function(){return s.renderer.request_render()})),c.visuals.line.doit&&(c.visuals.line.set_vectorize(e,t),c._inner_loop(e,r,i,e.stroke))},c=this;try{for(var h=i.__values(t),d=h.next();!d.done;d=h.next()){l(d.value)}}catch(e){n={error:e}}finally{try{d&&!d.done&&(a=h.return)&&a.call(h)}finally{if(n)throw n.error}}},t.prototype._hit_rect=function(e){var t,r,n=e.sx0,a=e.sx1,s=e.sy0,o=e.sy1,l=[n,a,a,n],h=[s,s,o,o],d=i.__read(this.renderer.xscale.r_invert(n,a),2),y=d[0],u=d[1],f=i.__read(this.renderer.yscale.r_invert(s,o),2),p=f[0],v=f[1],x=this.index.indices({x0:y,x1:u,y0:p,y1:v}),g=[];try{for(var m=i.__values(x),b=m.next();!b.done;b=m.next()){for(var w=b.value,P=this.sxs.get(w),S=this.sys.get(w),k=!0,N=0,V=P.length;N<V;N++){var j=P[N],q=S[N];if(!_.point_in_poly(j,q,l,h)){k=!1;break}}k&&g.push(w)}}catch(e){t={error:e}}finally{try{b&&!b.done&&(r=m.return)&&r.call(m)}finally{if(t)throw t.error}}return new c.Selection({indices:g})},t.prototype._hit_point=function(e){var t,r,n=e.sx,a=e.sy,s=this.renderer.xscale.invert(n),o=this.renderer.yscale.invert(a),l=this.index.indices({x0:s,y0:o,x1:s,y1:o}),h=[];try{for(var d=i.__values(l),y=d.next();!y.done;y=d.next())for(var u=y.value,f=this.sxs.get(u),p=this.sys.get(u),v=f.length,x=0,g=0;;g++){if(isNaN(f[g])||g==v){var m=f.subarray(x,g),b=p.subarray(x,g);if(_.point_in_poly(n,a,m,b)){h.push(u);break}x=g+1}if(g==v)break}}catch(e){t={error:e}}finally{try{y&&!y.done&&(r=d.return)&&r.call(d)}finally{if(t)throw t.error}}return new c.Selection({indices:h})},t.prototype._get_snap_coord=function(e){return s.sum(e)/e.length},t.prototype.scenterxy=function(e,t,r){for(var i=this.sxs.get(e),n=this.sys.get(e),a=i.length,s=!1,o=0,l=0;;l++){var c=isNaN(i[l]);if(s=s||c,l==a&&!s)return[this._get_snap_coord(i),this._get_snap_coord(n)];if(c||l==a){var d=i.subarray(o,l),y=n.subarray(o,l);if(_.point_in_poly(t,r,d,y))return[this._get_snap_coord(d),this._get_snap_coord(y)];o=l+1}if(l==a)break}h.unreachable()},t.prototype.draw_legend_for_index=function(e,t,r){a.generic_area_legend(this.visuals,e,t,r)},t}(n.GlyphView);r.PatchesView=y,y.__name__="PatchesView";var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Patches=function(){this.prototype.default_view=y,this.define({xs:[l.XCoordinateSeqSpec,{field:"xs"}],ys:[l.YCoordinateSeqSpec,{field:"ys"}]}),this.mixins([o.LineVector,o.FillVector,o.HatchVector])},t}(n.Glyph);r.Patches=u,u.__name__="Patches",u.init_Patches()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),n=t(360),r=o.__importStar(t(133)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.scenterxy=function(t){return[(this.sleft[t]+this.sright[t])/2,(this.stop[t]+this.sbottom[t])/2]},e.prototype._lrtb=function(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]},e}(n.BoxView);i.QuadView=_,_.__name__="QuadView";var u=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Quad=function(){this.prototype.default_view=_,this.define({right:[r.XCoordinateSpec,{field:"right"}],bottom:[r.YCoordinateSpec,{field:"bottom"}],left:[r.XCoordinateSpec,{field:"left"}],top:[r.YCoordinateSpec,{field:"top"}]})},e}(n.Box);i.Quad=u,u.__name__="Quad",u.init_Quad()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),n=t(143),a=t(152),o=t(209),_=t(215),s=r.__importStar(t(133));function c(t,e,i){if(e==(t+i)/2)return[t,i];var r=(t-e)/(t-2*e+i),n=t*Math.pow(1-r,2)+2*e*(1-r)*r+i*Math.pow(r,2);return[Math.min(t,i,n),Math.max(t,i,n)]}var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._project_data=function(){a.inplace.project_xy(this._x0,this._y0),a.inplace.project_xy(this._x1,this._y1)},e.prototype._index_data=function(t){for(var e=this.data_size,i=0;i<e;i++)if(isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx[i]+this._cy[i]))t.add_empty();else{var n=r.__read(c(this._x0[i],this._cx[i],this._x1[i]),2),a=n[0],o=n[1],_=r.__read(c(this._y0[i],this._cy[i],this._y1[i]),2),s=_[0],d=_[1];t.add(a,s,o,d)}},e.prototype._render=function(t,e,i){var n,a,o=i.sx0,_=i.sy0,s=i.sx1,c=i.sy1,d=i.scx,h=i.scy;if(this.visuals.line.doit)try{for(var l=r.__values(e),u=l.next();!u.done;u=l.next()){var y=u.value;isNaN(o[y]+_[y]+s[y]+c[y]+d[y]+h[y])||(t.beginPath(),t.moveTo(o[y],_[y]),t.quadraticCurveTo(d[y],h[y],s[y],c[y]),this.visuals.line.set_vectorize(t,y),t.stroke())}}catch(t){n={error:t}}finally{try{u&&!u.done&&(a=l.return)&&a.call(l)}finally{if(n)throw n.error}}},e.prototype.draw_legend_for_index=function(t,e,i){_.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},e}(o.GlyphView);i.QuadraticView=d,d.__name__="QuadraticView";var h=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Quadratic=function(){this.prototype.default_view=d,this.define({x0:[s.XCoordinateSpec,{field:"x0"}],y0:[s.YCoordinateSpec,{field:"y0"}],x1:[s.XCoordinateSpec,{field:"x1"}],y1:[s.YCoordinateSpec,{field:"y1"}],cx:[s.XCoordinateSpec,{field:"cx"}],cy:[s.YCoordinateSpec,{field:"cy"}]}),this.mixins(n.LineVector)},e}(o.Glyph);i.Quadratic=h,h.__name__="Quadratic",h.init_Quadratic()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),r=e(208),a=e(215),s=e(143),l=n.__importStar(e(133)),o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length},t.prototype._render=function(e,t,i){var r,a,s=i.sx,l=i.sy,o=i.slength,_=i._angle;if(this.visuals.line.doit){for(var h=2*(this.renderer.plot_view.frame.bbox.width+this.renderer.plot_view.frame.bbox.height),u=0,d=o.length;u<d;u++)0==o[u]&&(o[u]=h);try{for(var c=n.__values(t),f=c.next();!f.done;f=c.next()){u=f.value;isNaN(s[u]+l[u]+_[u]+o[u])||(e.translate(s[u],l[u]),e.rotate(_[u]),e.beginPath(),e.moveTo(0,0),e.lineTo(o[u],0),this.visuals.line.set_vectorize(e,u),e.stroke(),e.rotate(-_[u]),e.translate(-s[u],-l[u]))}}catch(e){r={error:e}}finally{try{f&&!f.done&&(a=c.return)&&a.call(c)}finally{if(r)throw r.error}}}},t.prototype.draw_legend_for_index=function(e,t,i){a.generic_line_legend(this.visuals,e,t,i)},t}(r.XYGlyphView);i.RayView=o,o.__name__="RayView";var _=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Ray=function(){this.prototype.default_view=o,this.mixins(s.LineVector),this.define({length:[l.DistanceSpec],angle:[l.AngleSpec]})},t}(r.XYGlyph);i.Ray=_,_.__name__="Ray",_.init_Ray()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var i=t(1),r=t(356),a=t(215),h=t(139),n=i.__importStar(t(133)),_=t(127),o=t(203),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){var t,e;if("data"==this.model.properties.width.units)t=i.__read(this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale),2),this.sw=t[0],this.sx0=t[1];else{this.sw=this._width;var s=this.sx.length;this.sx0=new h.NumberArray(s);for(var r=0;r<s;r++)this.sx0[r]=this.sx[r]-this.sw[r]/2}if("data"==this.model.properties.height.units)e=i.__read(this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale),2),this.sh=e[0],this.sy1=e[1];else{this.sh=this._height;var a=this.sy.length;this.sy1=new h.NumberArray(a);for(r=0;r<a;r++)this.sy1[r]=this.sy[r]-this.sh[r]/2}var n=this.sw.length;this.ssemi_diag=new h.NumberArray(n);for(r=0;r<n;r++)this.ssemi_diag[r]=Math.sqrt(this.sw[r]/2*this.sw[r]/2+this.sh[r]/2*this.sh[r]/2)},e.prototype._render=function(t,e,s){var r,a,h,n,_=s.sx,o=s.sy,l=s.sx0,d=s.sy1,u=s.sw,y=s.sh,c=s._angle;if(this.visuals.fill.doit)try{for(var f=i.__values(e),x=f.next();!x.done;x=f.next()){var v=x.value;isNaN(_[v]+o[v]+l[v]+d[v]+u[v]+y[v]+c[v])||(this.visuals.fill.set_vectorize(t,v),c[v]?(t.translate(_[v],o[v]),t.rotate(c[v]),t.fillRect(-u[v]/2,-y[v]/2,u[v],y[v]),t.rotate(-c[v]),t.translate(-_[v],-o[v])):t.fillRect(l[v],d[v],u[v],y[v]))}}catch(t){r={error:t}}finally{try{x&&!x.done&&(a=f.return)&&a.call(f)}finally{if(r)throw r.error}}if(this.visuals.line.doit){t.beginPath();try{for(var p=i.__values(e),m=p.next();!m.done;m=p.next()){v=m.value;isNaN(_[v]+o[v]+l[v]+d[v]+u[v]+y[v]+c[v])||0!=u[v]&&0!=y[v]&&(c[v]?(t.translate(_[v],o[v]),t.rotate(c[v]),t.rect(-u[v]/2,-y[v]/2,u[v],y[v]),t.rotate(-c[v]),t.translate(-_[v],-o[v])):t.rect(l[v],d[v],u[v],y[v]),this.visuals.line.set_vectorize(t,v),t.stroke(),t.beginPath())}}catch(t){h={error:t}}finally{try{m&&!m.done&&(n=p.return)&&n.call(p)}finally{if(h)throw h.error}}t.stroke()}},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){for(var e,s,r=t.sx,a=t.sy,n=this.renderer.xscale.invert(r),l=this.renderer.yscale.invert(a),d=this.sx0.length,u=new h.NumberArray(d),y=0;y<d;y++)u[y]=this.sx0[y]+this.sw[y]/2;var c=new h.NumberArray(d);for(y=0;y<d;y++)c[y]=this.sy1[y]+this.sh[y]/2;var f,x,v=_.max(this._ddist(0,u,this.ssemi_diag)),p=_.max(this._ddist(1,c,this.ssemi_diag)),m=n-v,w=n+v,g=l-p,b=l+p,N=[];try{for(var R=i.__values(this.index.indices({x0:m,x1:w,y0:g,y1:b})),A=R.next();!A.done;A=R.next()){y=A.value;if(this._angle[y]){var M=Math.sin(-this._angle[y]),k=Math.cos(-this._angle[y]),P=k*(r-this.sx[y])-M*(a-this.sy[y])+this.sx[y],V=M*(r-this.sx[y])+k*(a-this.sy[y])+this.sy[y];r=P,a=V,f=Math.abs(this.sx[y]-r)<=this.sw[y]/2,x=Math.abs(this.sy[y]-a)<=this.sh[y]/2}else{var z=r-this.sx0[y],C=a-this.sy1[y];f=0<=z&&z<=this.sw[y],x=0<=C&&C<=this.sh[y]}f&&x&&N.push(y)}}catch(t){e={error:t}}finally{try{A&&!A.done&&(s=R.return)&&s.call(R)}finally{if(e)throw e.error}}return new o.Selection({indices:N})},e.prototype._map_dist_corner_for_data_side_length=function(t,e,s){for(var i=t.length,r=new h.NumberArray(i),a=new h.NumberArray(i),n=0;n<i;n++)r[n]=t[n]-e[n]/2,a[n]=t[n]+e[n]/2;var _=s.v_compute(r),o=s.v_compute(a),l=this.sdist(s,r,e,"edge",this.model.dilate),d=_;for(n=0;n<i;n++){var u=_[n],y=o[n];if(!isNaN(u+y)&&u!=y){d=u<y?_:o;break}}return[l,d]},e.prototype._ddist=function(t,e,s){for(var i=0==t?this.renderer.xscale:this.renderer.yscale,r=e,a=r.length,n=new h.NumberArray(a),_=0;_<a;_++)n[_]=r[_]+s[_];var o=i.v_invert(r),l=i.v_invert(n),d=o.length,u=new h.NumberArray(d);for(_=0;_<d;_++)u[_]=Math.abs(l[_]-o[_]);return u},e.prototype.draw_legend_for_index=function(t,e,s){a.generic_area_legend(this.visuals,t,e,s)},e.prototype._bounds=function(t){var e=t.x0,s=t.x1,i=t.y0,r=t.y1;return{x0:e-this.max_w2,x1:s+this.max_w2,y0:i-this.max_h2,y1:r+this.max_h2}},e}(r.CenterRotatableView);s.RectView=l,l.__name__="RectView";var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Rect=function(){this.prototype.default_view=l,this.define({dilate:[n.Boolean,!1]})},e}(r.CenterRotatable);s.Rect=d,d.__name__="Rect",d.init_Rect()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),n=r.__importStar(e(216)),s=r.__importStar(e(133)),a=e(143),_=e(152),o=e(209),h=e(215),l=e(203),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype._project_data=function(){_.inplace.project_xy(this._x0,this._y0),_.inplace.project_xy(this._x1,this._y1)},t.prototype._index_data=function(e){for(var t=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x0[n],a=this._x1[n],_=this._y0[n],o=this._y1[n];isNaN(s+a+_+o)?e.add_empty():e.add(t(s,a),t(_,o),i(s,a),i(_,o))}},t.prototype._render=function(e,t,i){var n,s,a=i.sx0,_=i.sy0,o=i.sx1,h=i.sy1;if(this.visuals.line.doit)try{for(var l=r.__values(t),d=l.next();!d.done;d=l.next()){var c=d.value;isNaN(a[c]+_[c]+o[c]+h[c])||(e.beginPath(),e.moveTo(a[c],_[c]),e.lineTo(o[c],h[c]),this.visuals.line.set_vectorize(e,c),e.stroke())}}catch(e){n={error:e}}finally{try{d&&!d.done&&(s=l.return)&&s.call(l)}finally{if(n)throw n.error}}},t.prototype._hit_point=function(e){var t,i,s=e.sx,a=e.sy,_={x:s,y:a},o=r.__read(this.renderer.xscale.r_invert(s-2,s+2),2),h=o[0],d=o[1],c=r.__read(this.renderer.yscale.r_invert(a-2,a+2),2),y=c[0],x=c[1],u=this.index.indices({x0:h,y0:y,x1:d,y1:x}),p=[];try{for(var v=r.__values(u),f=v.next();!f.done;f=v.next()){var m=f.value,w=Math.pow(Math.max(2,this.visuals.line.cache_select("line_width",m)/2),2),S={x:this.sx0[m],y:this.sy0[m]},g={x:this.sx1[m],y:this.sy1[m]};n.dist_to_segment_squared(_,S,g)<w&&p.push(m)}}catch(e){t={error:e}}finally{try{f&&!f.done&&(i=v.return)&&i.call(v)}finally{if(t)throw t.error}}return new l.Selection({indices:p})},t.prototype._hit_span=function(e){var t,i,n,s,a,_,o,h=r.__read(this.renderer.plot_view.frame.bbox.ranges,2),d=h[0],c=h[1],y=e.sx,x=e.sy;"v"==e.direction?(o=this.renderer.yscale.invert(x),a=(t=r.__read([this._y0,this._y1],2))[0],_=t[1]):(o=this.renderer.xscale.invert(y),a=(i=r.__read([this._x0,this._x1],2))[0],_=i[1]);var u=[],p=r.__read(this.renderer.xscale.r_invert(d.start,d.end),2),v=p[0],f=p[1],m=r.__read(this.renderer.yscale.r_invert(c.start,c.end),2),w=m[0],S=m[1],g=this.index.indices({x0:v,y0:w,x1:f,y1:S});try{for(var M=r.__values(g),b=M.next();!b.done;b=M.next()){var j=b.value;(a[j]<=o&&o<=_[j]||_[j]<=o&&o<=a[j])&&u.push(j);var C=1.5+this.visuals.line.cache_select("line_width",j)/2;a[j]==_[j]&&("h"==e.direction?Math.abs(this.sx0[j]-y)<=C&&u.push(j):Math.abs(this.sy0[j]-x)<=C&&u.push(j))}}catch(e){n={error:e}}finally{try{b&&!b.done&&(s=M.return)&&s.call(M)}finally{if(n)throw n.error}}return new l.Selection({indices:u})},t.prototype.scenterxy=function(e){return[(this.sx0[e]+this.sx1[e])/2,(this.sy0[e]+this.sy1[e])/2]},t.prototype.draw_legend_for_index=function(e,t,i){h.generic_line_legend(this.visuals,e,t,i)},t}(o.GlyphView);i.SegmentView=d,d.__name__="SegmentView";var c=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Segment=function(){this.prototype.default_view=d,this.define({x0:[s.XCoordinateSpec,{field:"x0"}],y0:[s.YCoordinateSpec,{field:"y0"}],x1:[s.XCoordinateSpec,{field:"x1"}],y1:[s.YCoordinateSpec,{field:"y1"}]}),this.mixins(a.LineVector)},t}(o.Glyph);i.Segment=c,c.__name__="Segment",c.init_Segment()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(208),o=e(215),a=e(143),_=r.__importStar(e(133)),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype._render=function(e,t,n){var i,o,a,_,l,s,d,u,f=n.sx,c=n.sy,h=!1,p=null;this.visuals.line.set_value(e);var v=t.length;if(!(v<2)){e.beginPath(),e.moveTo(f[0],c[0]);try{for(var y=r.__values(t),b=y.next();!b.done;b=y.next()){var m=b.value,w=void 0,x=void 0,S=void 0,g=void 0;switch(this.model.mode){case"before":w=(a=r.__read([f[m-1],c[m]],2))[0],S=a[1],x=(_=r.__read([f[m],c[m]],2))[0],g=_[1];break;case"after":w=(l=r.__read([f[m],c[m-1]],2))[0],S=l[1],x=(s=r.__read([f[m],c[m]],2))[0],g=s[1];break;case"center":var k=(f[m-1]+f[m])/2;w=(d=r.__read([k,c[m-1]],2))[0],S=d[1],x=(u=r.__read([k,c[m]],2))[0],g=u[1];break;default:throw new Error("unexpected")}if(h){if(!isFinite(f[m]+c[m])){e.stroke(),e.beginPath(),h=!1,p=m;continue}null!=p&&m-p>1&&(e.stroke(),h=!1)}h?(e.lineTo(w,S),e.lineTo(x,g)):(e.beginPath(),e.moveTo(f[m],c[m]),h=!0),p=m}}catch(e){i={error:e}}finally{try{b&&!b.done&&(o=y.return)&&o.call(y)}finally{if(i)throw i.error}}e.lineTo(f[v-1],c[v-1]),e.stroke()}},t.prototype.draw_legend_for_index=function(e,t,n){o.generic_line_legend(this.visuals,e,t,n)},t}(i.XYGlyphView);n.StepView=l,l.__name__="StepView";var s=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Step=function(){this.prototype.default_view=l,this.mixins(a.LineVector),this.define({mode:[_.StepMode,"before"]})},t}(i.XYGlyph);n.Step=s,s.__name__="Step",s.init_Step()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var i=t(1),r=t(208),n=t(143),_=i.__importStar(t(216)),a=i.__importStar(t(133)),o=t(274),l=t(126),h=t(203),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._rotate_point=function(t,e,s,i,r){return[(t-s)*Math.cos(r)-(e-i)*Math.sin(r)+s,(t-s)*Math.sin(r)+(e-i)*Math.cos(r)+i]},e.prototype._text_bounds=function(t,e,s,i){return[[t,t+s,t+s,t,t],[e,e,e-i,e-i,e]]},e.prototype._render=function(t,e,s){var r,n,_,a,l=s.sx,h=s.sy,u=s._x_offset,x=s._y_offset,c=s._angle,f=s._text;this._sys=[],this._sxs=[];try{for(var p=i.__values(e),v=p.next();!v.done;v=p.next()){var d=v.value;if(this._sxs[d]=[],this._sys[d]=[],!isNaN(l[d]+h[d]+u[d]+x[d]+c[d])&&null!=f[d]&&this.visuals.text.doit){var y=""+f[d];t.save(),t.translate(l[d]+u[d],h[d]+x[d]),t.rotate(c[d]),this.visuals.text.set_vectorize(t,d);var g=this.visuals.text.cache_select("font",d),m=o.measure_font(g).height,b=this.visuals.text.text_line_height.value()*m;if(-1==y.indexOf("\n")){t.fillText(y,0,0);var w=l[d]+u[d],T=h[d]+x[d],S=t.measureText(y).width,M=i.__read(this._text_bounds(w,T,S,b),2),N=M[0],V=M[1];this._sxs[d].push(N),this._sys[d].push(V)}else{var k=y.split("\n"),G=b*k.length,O=this.visuals.text.cache_select("text_baseline",d),X=void 0;switch(O){case"top":X=0;break;case"middle":X=-G/2+b/2;break;case"bottom":X=-G+b;break;default:X=0,console.warn("'"+O+"' baseline not supported with multi line text")}try{for(var Y=(_=void 0,i.__values(k)),j=Y.next();!j.done;j=Y.next()){var z=j.value;t.fillText(z,0,X);w=l[d]+u[d],T=X+h[d]+x[d],S=t.measureText(z).width;var A=i.__read(this._text_bounds(w,T,S,b),2);N=A[0],V=A[1];this._sxs[d].push(N),this._sys[d].push(V),X+=b}}catch(t){_={error:t}}finally{try{j&&!j.done&&(a=Y.return)&&a.call(Y)}finally{if(_)throw _.error}}}t.restore()}}}catch(t){r={error:t}}finally{try{v&&!v.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}},e.prototype._hit_point=function(t){for(var e=t.sx,s=t.sy,r=[],n=0;n<this._sxs.length;n++)for(var a=this._sxs[n],o=this._sys[n],l=a.length,u=0,x=l;u<x;u++){var c=i.__read(this._rotate_point(e,s,a[l-1][0],o[l-1][0],-this._angle[n]),2),f=c[0],p=c[1];_.point_in_poly(f,p,a[u],o[u])&&r.push(n)}return new h.Selection({indices:r})},e.prototype.scenterxy=function(t){var e=this._sxs[t],s=this._sys[t];l.assert(0!=e.length&&0!=s.length);var r=e[0][0],n=s[0][0],_=(e[0][2]+r)/2,a=(s[0][2]+n)/2,o=i.__read(this._rotate_point(_,a,r,n,this._angle[t]),2);return[o[0],o[1]]},e}(r.XYGlyphView);s.TextView=u,u.__name__="TextView";var x=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Text=function(){this.prototype.default_view=u,this.mixins(n.TextVector),this.define({text:[a.NullStringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,0],y_offset:[a.NumberSpec,0]})},e}(r.XYGlyph);s.Text=x,x.__name__="Text",x.init_Text()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var s=t(1),r=t(360),o=t(139),h=s.__importStar(t(133)),n=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype.scenterxy=function(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]},i.prototype._lrtb=function(t){return[this._x[t]-this._width[t]/2,this._x[t]+this._width[t]/2,Math.max(this._top[t],this._bottom[t]),Math.min(this._top[t],this._bottom[t])]},i.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new o.NumberArray(t),this.sright=new o.NumberArray(t);for(var i=0;i<t;i++)this.sleft[i]=this.sx[i]-this.sw[i]/2,this.sright[i]=this.sx[i]+this.sw[i]/2;this._clamp_viewport()},i}(r.BoxView);e.VBarView=n,n.__name__="VBarView";var _=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_VBar=function(){this.prototype.default_view=n,this.define({x:[h.XCoordinateSpec,{field:"x"}],bottom:[h.YCoordinateSpec,{value:0}],width:[h.NumberSpec,{value:1}],top:[h.YCoordinateSpec,{field:"top"}]})},i}(r.Box);e.VBar=_,_.__name__="VBar",_.init_VBar()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),s=e(208),n=e(215),a=e(143),l=i.__importStar(e(133)),o=e(125),_=e(203),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},t.prototype._render=function(e,t,r){var s,n,a=r.sx,l=r.sy,o=r.sradius,_=r._start_angle,d=r._end_angle,h=this.model.properties.direction.value();try{for(var u=i.__values(t),c=u.next();!c.done;c=u.next()){var p=c.value;isNaN(a[p]+l[p]+o[p]+_[p]+d[p])||(e.beginPath(),e.arc(a[p],l[p],o[p],_[p],d[p],h),e.lineTo(a[p],l[p]),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,p),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,p),e.stroke()))}}catch(e){s={error:e}}finally{try{c&&!c.done&&(n=u.return)&&n.call(u)}finally{if(s)throw s.error}}},t.prototype._hit_point=function(e){var t,r,s,n,a,l,d,h,u,c,p,v,y,f,x,g,w=e.sx,m=e.sy,M=this.renderer.xscale.invert(w),W=this.renderer.yscale.invert(m),S=2*this.max_radius;"data"===this.model.properties.radius.units?(y=M-S,f=M+S,x=W-S,g=W+S):(u=w-S,c=w+S,y=(t=i.__read(this.renderer.xscale.r_invert(u,c),2))[0],f=t[1],p=m-S,v=m+S,x=(r=i.__read(this.renderer.yscale.r_invert(p,v),2))[0],g=r[1]);var V=[];try{for(var b=i.__values(this.index.indices({x0:y,x1:f,y0:x,y1:g})),P=b.next();!P.done;P=b.next()){var k=P.value,z=Math.pow(this.sradius[k],2);u=(a=i.__read(this.renderer.xscale.r_compute(M,this._x[k]),2))[0],c=a[1],p=(l=i.__read(this.renderer.yscale.r_compute(W,this._y[k]),2))[0],v=l[1],Math.pow(u-c,2)+Math.pow(p-v,2)<=z&&V.push(k)}}catch(e){s={error:e}}finally{try{P&&!P.done&&(n=b.return)&&n.call(b)}finally{if(s)throw s.error}}var A=this.model.properties.direction.value(),D=[];try{for(var G=i.__values(V),N=G.next();!N.done;N=G.next()){k=N.value;var X=Math.atan2(m-this.sy[k],w-this.sx[k]);o.angle_between(-X,-this._start_angle[k],-this._end_angle[k],A)&&D.push(k)}}catch(e){d={error:e}}finally{try{N&&!N.done&&(h=G.return)&&h.call(G)}finally{if(d)throw d.error}}return new _.Selection({indices:D})},t.prototype.draw_legend_for_index=function(e,t,r){n.generic_area_legend(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=this.sradius[e]/2,r=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(s.XYGlyphView);r.WedgeView=d,d.__name__="WedgeView";var h=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Wedge=function(){this.prototype.default_view=d,this.mixins([a.LineVector,a.FillVector]),this.define({direction:[l.Direction,"anticlock"],radius:[l.DistanceSpec],start_angle:[l.AngleSpec],end_angle:[l.AngleSpec]})},t}(s.XYGlyph);r.Wedge=h,h.__name__="Wedge",h.init_Wedge()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);_.__exportStar(e(232),t),_.__exportStar(e(381),t),_.__exportStar(e(382),t)},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),o=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t}(e(196).Model);n.LayoutProvider=o,o.__name__="LayoutProvider"},
function _(t,a,r){Object.defineProperty(r,"__esModule",{value:!0});var e=t(1),o=t(381),n=t(139),i=e.__importStar(t(133)),u=function(t){function a(a){return t.call(this,a)||this}return e.__extends(a,t),a.init_StaticLayoutProvider=function(){this.define({graph_layout:[i.Any,{}]})},a.prototype.get_node_coordinates=function(t){for(var a=t.data.index,r=a.length,o=new n.NumberArray(r),i=new n.NumberArray(r),u=0;u<r;u++){var d=this.graph_layout[a[u]],_=e.__read(null!=d?d:[NaN,NaN],2),l=_[0],s=_[1];o[u]=l,i[u]=s}return[o,i]},a.prototype.get_edge_coordinates=function(t){for(var a=t.data.start,r=t.data.end,e=a.length,o=[],n=[],i=null!=t.data.xs&&null!=t.data.ys,u=0;u<e;u++){var d=null!=this.graph_layout[a[u]]&&null!=this.graph_layout[r[u]];if(i&&d)o.push(t.data.xs[u]),n.push(t.data.ys[u]);else{var _=void 0,l=void 0;d?(_=this.graph_layout[a[u]],l=this.graph_layout[r[u]]):(_=[NaN,NaN],l=[NaN,NaN]),o.push([_[0],l[0]]),n.push([_[1],l[1]])}}return[o,n]},a}(o.LayoutProvider);r.StaticLayoutProvider=u,u.__name__="StaticLayoutProvider",u.init_StaticLayoutProvider()},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var i=e(384);d.Grid=i.Grid},
function _(i,r,e){Object.defineProperty(e,"__esModule",{value:!0});var t=i(1),n=i(293),o=t.__importStar(i(143)),a=t.__importStar(i(133)),_=i(123),s=function(i){function r(){return null!==i&&i.apply(this,arguments)||this}return t.__extends(r,i),r.prototype._render=function(){var i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()},r.prototype.connect_signals=function(){var r=this;i.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return r.request_render()}))},r.prototype._draw_regions=function(i){var r=this;if(this.visuals.band_fill.doit||this.visuals.band_hatch.doit){this.visuals.band_fill.set_value(i);for(var e=t.__read(this.grid_coords("major",!1),2),n=e[0],o=e[1],a=function(e){if(e%2!=1)return"continue";var a=t.__read(_.coordinates.map_to_screen(n[e],o[e]),2),s=a[0],d=a[1],l=t.__read(_.coordinates.map_to_screen(n[e+1],o[e+1]),2),u=l[0],h=l[1];_.visuals.band_fill.doit&&i.fillRect(s[0],d[0],u[1]-s[0],h[1]-d[0]),_.visuals.band_hatch.doit2(i,e,(function(){i.fillRect(s[0],d[0],u[1]-s[0],h[1]-d[0])}),(function(){return r.request_render()}))},_=this,s=0;s<n.length-1;s++)a(s)}},r.prototype._draw_grids=function(i){if(this.visuals.grid_line.doit){var r=t.__read(this.grid_coords("major"),2),e=r[0],n=r[1];this._draw_grid_helper(i,this.visuals.grid_line,e,n)}},r.prototype._draw_minor_grids=function(i){if(this.visuals.minor_grid_line.doit){var r=t.__read(this.grid_coords("minor"),2),e=r[0],n=r[1];this._draw_grid_helper(i,this.visuals.minor_grid_line,e,n)}},r.prototype._draw_grid_helper=function(i,r,e,n){r.set_value(i),i.beginPath();for(var o=0;o<e.length;o++){var a=t.__read(this.coordinates.map_to_screen(e[o],n[o]),2),_=a[0],s=a[1];i.moveTo(Math.round(_[0]),Math.round(s[0]));for(var d=1;d<_.length;d++)i.lineTo(Math.round(_[d]),Math.round(s[d]))}i.stroke()},r.prototype.ranges=function(){var i=this.model.dimension,r=(i+1)%2,e=this.coordinates.ranges;return[e[i],e[r]]},r.prototype.computed_bounds=function(){var i,r,e,n,o,a,s=t.__read(this.ranges(),1)[0],d=this.model.bounds,l=[s.min,s.max];if(_.isArray(d))o=Math.min(d[0],d[1]),a=Math.max(d[0],d[1]),o<l[0]&&(o=l[0]),a>l[1]&&(a=l[1]);else{o=(i=t.__read(l,2))[0],a=i[1];try{for(var u=t.__values(this.plot_view.axis_views),h=u.next();!h.done;h=u.next()){var c=h.value;c.dimension==this.model.dimension&&c.model.x_range_name==this.model.x_range_name&&c.model.y_range_name==this.model.y_range_name&&(o=(n=t.__read(c.computed_bounds,2))[0],a=n[1])}}catch(i){r={error:i}}finally{try{h&&!h.done&&(e=u.return)&&e.call(u)}finally{if(r)throw r.error}}}return[o,a]},r.prototype.grid_coords=function(i,r){var e;void 0===r&&(r=!0);var n=this.model.dimension,o=(n+1)%2,a=t.__read(this.ranges(),2),_=a[0],s=a[1],d=t.__read(this.computed_bounds(),2),l=d[0],u=d[1];l=(e=t.__read([Math.min(l,u),Math.max(l,u)],2))[0],u=e[1];var h=[[],[]],c=this.model.get_ticker();if(null==c)return h;var m=c.get_ticks(l,u,_,s.min,{})[i],f=_.min,p=_.max,v=s.min,g=s.max;r||(m[0]!=f&&m.splice(0,0,f),m[m.length-1]!=p&&m.push(p));for(var y=0;y<m.length;y++)if(m[y]!=f&&m[y]!=p||!r){for(var x=[],b=[],w=0;w<2;w++){var M=v+(g-v)/1*w;x.push(m[y]),b.push(M)}h[n].push(x),h[o].push(b)}return h},r}(n.GuideRendererView);e.GridView=s,s.__name__="GridView";var d=function(i){function r(r){return i.call(this,r)||this}return t.__extends(r,i),r.init_Grid=function(){this.prototype.default_view=s,this.mixins([["grid_",o.Line],["minor_grid_",o.Line],["band_",o.Fill],["band_",o.Hatch]]),this.define({bounds:[a.Any,"auto"],dimension:[a.Any,0],axis:[a.Instance],ticker:[a.Instance]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},r.prototype.get_ticker=function(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null},r}(n.GuideRenderer);e.Grid=d,d.__name__="Grid",d.init_Grid()},
function _(a,o,r){Object.defineProperty(r,"__esModule",{value:!0});var e=a(386);r.Box=e.Box;var v=a(389);r.Column=v.Column;var x=a(390);r.GridBox=x.GridBox;var B=a(391);r.HTMLBox=B.HTMLBox;var n=a(387);r.LayoutDOM=n.LayoutDOM;var t=a(392);r.Row=t.Row;var u=a(393);r.Spacer=u.Spacer;var d=a(394);r.Panel=d.Panel,r.Tabs=d.Tabs;var i=a(401);r.WidgetBox=i.WidgetBox},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),o=e(387),r=i.__importStar(e(133)),c=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(n,e),n.prototype.connect_signals=function(){var n=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,(function(){return n.rebuild()}))},Object.defineProperty(n.prototype,"child_models",{get:function(){return this.model.children},enumerable:!0,configurable:!0}),n}(o.LayoutDOMView);t.BoxView=c,c.__name__="BoxView";var u=function(e){function n(n){return e.call(this,n)||this}return i.__extends(n,e),n.init_Box=function(){this.define({children:[r.Array,[]],spacing:[r.Number,0]})},n}(o.LayoutDOM);t.Box=u,u.__name__="Box",u.init_Box()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),n=t(196),r=t(135),l=t(187),a=t(134),s=t(123),h=t(230),u=t(193),_=t(327),c=t(388),d=t(192),p=function(t){function e(){var e=t.apply(this,o.__spread(arguments))||this;return e._idle_notified=!1,e._offset_parent=null,e._viewport={},e}return o.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el.style.position=this.is_root?"relative":"absolute",this._child_views=new Map},e.prototype.lazy_initialize=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_child_views()];case 1:return t.sent(),[2]}}))}))},e.prototype.remove=function(){var e,i;try{for(var n=o.__values(this.child_views),r=n.next();!r.done;r=n.next()){r.value.remove()}}catch(t){e={error:t}}finally{try{r&&!r.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}this._child_views.clear(),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.is_root&&(this._on_resize=function(){return e.resize_layout()},window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval((function(){var t=e.el.offsetParent;e._offset_parent!=t&&(e._offset_parent=t,null!=t&&(e.compute_viewport(),e.invalidate_layout()))}),250));var i=this.model.properties;this.on_change([i.width,i.height,i.min_width,i.min_height,i.max_width,i.max_height,i.margin,i.width_policy,i.height_policy,i.sizing_mode,i.aspect_ratio,i.visible],(function(){return e.invalidate_layout()})),this.on_change([i.background,i.css_classes],(function(){return e.invalidate_render()}))},e.prototype.disconnect_signals=function(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),t.prototype.disconnect_signals.call(this)},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(this.model.css_classes)},Object.defineProperty(e.prototype,"child_views",{get:function(){var t=this;return this.child_models.map((function(e){return t._child_views.get(e)}))},enumerable:!0,configurable:!0}),e.prototype.build_child_views=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[4,h.build_views(this._child_views,this.child_models,{parent:this})];case 1:return t.sent(),[2]}}))}))},e.prototype.render=function(){var e,i,n;t.prototype.render.call(this),l.empty(this.el);var r=this.model.background;this.el.style.backgroundColor=null!=r?r:"",(e=l.classes(this.el).clear()).add.apply(e,o.__spread(this.css_classes()));try{for(var a=o.__values(this.child_views),s=a.next();!s.done;s=a.next()){var h=s.value;this.el.appendChild(h.el),h.render()}}catch(t){i={error:t}}finally{try{s&&!s.done&&(n=a.return)&&n.call(a)}finally{if(i)throw i.error}}},e.prototype.update_layout=function(){var t,e;try{for(var i=o.__values(this.child_views),n=i.next();!n.done;n=i.next()){n.value.update_layout()}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}this._update_layout()},e.prototype.update_position=function(){var t,e;this.el.style.display=this.model.visible?"block":"none";var i=this.is_root?this.layout.sizing.margin:void 0;l.position(this.el,this.layout.bbox,i);try{for(var n=o.__values(this.child_views),r=n.next();!r.done;r=n.next()){r.value.update_position()}}catch(e){t={error:e}}finally{try{r&&!r.done&&(e=n.return)&&e.call(n)}finally{if(t)throw t.error}}},e.prototype.after_layout=function(){var t,e;try{for(var i=o.__values(this.child_views),n=i.next();!n.done;n=i.next()){n.value.after_layout()}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}this._has_finished=!0},e.prototype.compute_viewport=function(){this._viewport=this._viewport_size()},e.prototype.renderTo=function(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()},e.prototype.build=function(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this},e.prototype.rebuild=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_child_views()];case 1:return t.sent(),this.invalidate_render(),[2]}}))}))},e.prototype.compute_layout=function(){var t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),a.logger.debug("layout computed in "+(Date.now()-t)+" ms"),this.notify_finished()},e.prototype.resize_layout=function(){this.root.compute_viewport(),this.root.compute_layout()},e.prototype.invalidate_layout=function(){this.root.update_layout(),this.root.compute_layout()},e.prototype.invalidate_render=function(){this.render(),this.invalidate_layout()},e.prototype.has_finished=function(){var e,i;if(!t.prototype.has_finished.call(this))return!1;try{for(var n=o.__values(this.child_views),r=n.next();!r.done;r=n.next()){if(!r.value.has_finished())return!1}}catch(t){e={error:t}}finally{try{r&&!r.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}return!0},e.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()},e.prototype._width_policy=function(){return null!=this.model.width?"fixed":"fit"},e.prototype._height_policy=function(){return null!=this.model.height?"fixed":"fit"},e.prototype.box_sizing=function(){var t,e=this.model,i=e.width_policy,n=e.height_policy,r=e.aspect_ratio;"auto"==i&&(i=this._width_policy()),"auto"==n&&(n=this._height_policy());var l=this.model.sizing_mode;if(null!=l)if("fixed"==l)i=n="fixed";else if("stretch_both"==l)i=n="max";else if("stretch_width"==l)i="max";else if("stretch_height"==l)n="max";else switch(null==r&&(r="auto"),l){case"scale_width":i="max",n="min";break;case"scale_height":i="min",n="max";break;case"scale_both":i="max",n="max"}var a={width_policy:i,height_policy:n},h=this.model,u=h.min_width,_=h.min_height;null!=u&&(a.min_width=u),null!=_&&(a.min_height=_);var c=this.model,d=c.width,p=c.height;null!=d&&(a.width=d),null!=p&&(a.height=p);var f=this.model,y=f.max_width,v=f.max_height;null!=y&&(a.max_width=y),null!=v&&(a.max_height=v),"auto"==r&&null!=d&&null!=p?a.aspect=d/p:s.isNumber(r)&&(a.aspect=r);var m=this.model.margin;if(null!=m)if(s.isNumber(m))a.margin={top:m,right:m,bottom:m,left:m};else if(2==m.length){var g=o.__read(m,2),w=g[0],b=g[1];a.margin={top:w,right:b,bottom:w,left:b}}else{var x=o.__read(m,4),z=x[0],M=x[1],O=x[2],L=x[3];a.margin={top:z,right:M,bottom:O,left:L}}a.visible=this.model.visible;var D=this.model.align;return s.isArray(D)?(t=o.__read(D,2),a.halign=t[0],a.valign=t[1]):a.halign=a.valign=D,a},e.prototype._viewport_size=function(){var t=this;return l.undisplayed(this.el,(function(){for(var e=t.el;e=e.parentElement;)if(!e.classList.contains(c.bk_root)){if(e==document.body){var i=l.extents(document.body).margin,o=i.left,n=i.right,r=i.top,a=i.bottom;return{width:Math.ceil(document.documentElement.clientWidth-o-n),height:Math.ceil(document.documentElement.clientHeight-r-a)}}var s=l.extents(e).padding,h=s.left,u=s.right,_=s.top,d=s.bottom,p=e.getBoundingClientRect(),f=p.width,y=p.height,v=Math.ceil(f-h-u),m=Math.ceil(y-_-d);if(v>0||m>0)return{width:v>0?v:void 0,height:m>0?m:void 0}}return{}}))},e.prototype.export=function(t,e){var i,n;void 0===e&&(e=!0);var r="png"==t?"canvas":"svg",l=new d.CanvasLayer(r,e),a=this.layout.bbox,s=a.width,h=a.height;l.resize(s,h);try{for(var u=o.__values(this.child_views),_=u.next();!_.done;_=u.next()){var c=_.value,p=c.export(t,e),f=c.layout.bbox,y=f.x,v=f.y;l.ctx.drawImage(p.canvas,y,v)}}catch(t){i={error:t}}finally{try{_&&!_.done&&(n=u.return)&&n.call(u)}finally{if(i)throw i.error}}return l},e.prototype.serializable_state=function(){return Object.assign(Object.assign({},t.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box,children:this.child_views.map((function(t){return t.serializable_state()}))})},e}(u.DOMView);i.LayoutDOMView=p,p.__name__="LayoutDOMView";var f=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_LayoutDOM=function(){this.define((function(t){var e=t.Boolean,i=t.Number,o=t.String,n=t.Null,l=t.Auto,a=t.Color,s=t.Array,h=t.Tuple,u=t.Or,c=h(i,i),d=h(i,i,i,i);return{width:[u(i,n),null],height:[u(i,n),null],min_width:[u(i,n),null],min_height:[u(i,n),null],max_width:[u(i,n),null],max_height:[u(i,n),null],margin:[u(i,c,d),[0,0,0,0]],width_policy:[u(_.SizingPolicy,l),"auto"],height_policy:[u(_.SizingPolicy,l),"auto"],aspect_ratio:[u(i,l,n),null],sizing_mode:[u(r.SizingMode,n),null],visible:[e,!0],disabled:[e,!1],align:[u(r.Align,h(r.Align,r.Align)),"start"],background:[u(a,n),null],css_classes:[s(o),[]]}}))},e}(n.Model);i.LayoutDOM=f,f.__name__="LayoutDOM",f.init_LayoutDOM()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_root="bk-root"},
function _(t,n,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),e=t(386),u=t(331),s=o.__importStar(t(133)),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new u.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())},n}(e.BoxView);i.ColumnView=_,_.__name__="ColumnView";var l=function(t){function n(n){return t.call(this,n)||this}return o.__extends(n,t),n.init_Column=function(){this.prototype.default_view=_,this.define({rows:[s.Any,"auto"]})},n}(e.Box);i.Column=l,l.__name__="Column",l.init_Column()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),n=t(387),r=t(331),l=o.__importStar(t(133)),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,(function(){return e.rebuild()}))},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.children.map((function(t){return o.__read(t,1)[0]}))},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){var t,e;this.layout=new r.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;try{for(var i=o.__values(this.model.children),n=i.next();!n.done;n=i.next()){var l=o.__read(n.value,5),s=l[0],a=l[1],u=l[2],c=l[3],_=l[4],d=this._child_views.get(s);this.layout.items.push({layout:d.layout,row:a,col:u,row_span:c,col_span:_})}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}this.layout.set_sizing(this.box_sizing())},e}(n.LayoutDOMView);i.GridBoxView=s,s.__name__="GridBoxView";var a=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_GridBox=function(){this.prototype.default_view=s,this.define({children:[l.Array,[]],rows:[l.Any,"auto"],cols:[l.Any,"auto"],spacing:[l.Any,0]})},e}(n.LayoutDOM);i.GridBox=a,a.__name__="GridBox",a.init_GridBox()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=t(387),u=t(327),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new u.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())},e}(i.LayoutDOMView);n.HTMLBoxView=r,r.__name__="HTMLBoxView";var _=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e}(i.LayoutDOM);n.HTMLBox=_,_.__name__="HTMLBox"},
function _(t,i,o){Object.defineProperty(o,"__esModule",{value:!0});var n=t(1),e=t(386),s=t(331),u=n.__importStar(t(133)),_=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new s.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())},i}(e.BoxView);o.RowView=_,_.__name__="RowView";var a=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_Row=function(){this.prototype.default_view=_,this.define({cols:[u.Any,"auto"]})},i}(e.Box);o.Row=a,a.__name__="Row",a.init_Row()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(387),o=e(327),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),Object.defineProperty(t.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),t.prototype._update_layout=function(){this.layout=new o.LayoutItem,this.layout.set_sizing(this.box_sizing())},t}(r.LayoutDOMView);n.SpacerView=u,u.__name__="SpacerView";var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Spacer=function(){this.prototype.default_view=u},t}(r.LayoutDOM);n.Spacer=a,a.__name__="Spacer",a.init_Spacer()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var a=e(1),r=e(327),l=e(187),s=e(124),n=a.__importStar(e(133)),o=e(387),h=e(196),c=e(288),d=e(395),_=e(396),u=e(397),p=a.__importDefault(e(398)),v=a.__importDefault(e(399)),b=a.__importDefault(e(400)),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,(function(){return t.rebuild()})),this.connect(this.model.properties.active.change,(function(){return t.on_active_change()}))},t.prototype.styles=function(){return a.__spread(e.prototype.styles.call(this),[p.default,v.default,b.default])},Object.defineProperty(t.prototype,"child_models",{get:function(){return this.model.tabs.map((function(e){return e.child}))},enumerable:!0,configurable:!0}),t.prototype._update_layout=function(){var e=this.model.tabs_location,t="above"==e||"below"==e,i=this.scroll_el,n=this.headers_el;this.header=new(function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(r,e),r.prototype._measure=function(a){var r=l.size(i),o=l.children(n).slice(0,3).map((function(e){return l.size(e)})),h=e.prototype._measure.call(this,a),c=h.width,d=h.height;if(t){var _=r.width+s.sum(o.map((function(e){return e.width})));return{width:a.width!=1/0?a.width:_,height:d}}var u=r.height+s.sum(o.map((function(e){return e.height})));return{width:c,height:a.height!=1/0?a.height:u}},r}(r.ContentBox))(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});var o=1,h=1;switch(e){case"above":o-=1;break;case"below":o+=1;break;case"left":h-=1;break;case"right":h+=1}var c={layout:this.header,row:o,col:h},d=this.child_views.map((function(e){return{layout:e.layout,row:1,col:1}}));this.layout=new r.Grid(a.__spread([c],d)),this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){var t,i;e.prototype.update_position.call(this),this.header_el.style.position="absolute",l.position(this.header_el,this.header.bbox);var r=this.model.tabs_location,s="above"==r||"below"==r,n=l.size(this.scroll_el),o=l.scroll_size(this.headers_el);if(s){var h=this.header.bbox.width;o.width>h?(this.wrapper_el.style.maxWidth=h-n.width+"px",l.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",l.undisplay(this.scroll_el))}else{var c=this.header.bbox.height;o.height>c?(this.wrapper_el.style.maxHeight=c-n.height+"px",l.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",l.undisplay(this.scroll_el))}var d=this.child_views;try{for(var _=a.__values(d),u=_.next();!u.done;u=_.next()){var p=u.value;l.hide(p.el)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(i=_.return)&&i.call(_)}finally{if(t)throw t.error}}var v=d[this.model.active];null!=v&&l.show(v.el)},t.prototype.render=function(){var t=this;e.prototype.render.call(this);var i=this.model.active,a=this.model.tabs_location,r="above"==a||"below"==a,n=this.model.tabs.map((function(e,a){var r=l.div({class:[d.bk_tab,a==i?c.bk_active:null]},e.title);if(r.addEventListener("click",(function(e){e.target==e.currentTarget&&t.change_active(a)})),e.closable){var n=l.div({class:d.bk_close});n.addEventListener("click",(function(e){if(e.target==e.currentTarget){t.model.tabs=s.remove_at(t.model.tabs,a);var i=t.model.tabs.length;t.model.active>i-1&&(t.model.active=i-1)}})),r.appendChild(n)}return r}));this.headers_el=l.div({class:[d.bk_headers]},n),this.wrapper_el=l.div({class:d.bk_headers_wrapper},this.headers_el);var o=l.div({class:[_.bk_btn,_.bk_btn_default],disabled:""},l.div({class:[u.bk_caret,c.bk_left]})),h=l.div({class:[_.bk_btn,_.bk_btn_default]},l.div({class:[u.bk_caret,c.bk_right]})),p=0,v=function(e){return function(){var i=t.model.tabs.length;0==(p="left"==e?Math.max(p-1,0):Math.min(p+1,i-1))?o.setAttribute("disabled",""):o.removeAttribute("disabled"),p==i-1?h.setAttribute("disabled",""):h.removeAttribute("disabled");var a=l.children(t.headers_el).slice(0,p).map((function(e){return e.getBoundingClientRect()}));if(r){var n=-s.sum(a.map((function(e){return e.width})));t.headers_el.style.left=n+"px"}else{var c=-s.sum(a.map((function(e){return e.height})));t.headers_el.style.top=c+"px"}}};o.addEventListener("click",v("left")),h.addEventListener("click",v("right")),this.scroll_el=l.div({class:_.bk_btn_group},o,h),this.header_el=l.div({class:[d.bk_tabs_header,c.bk_side(a)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)},t.prototype.change_active=function(e){e!=this.model.active&&(this.model.active=e)},t.prototype.on_active_change=function(){var e,t,i,r,s=this.model.active,n=l.children(this.headers_el);try{for(var o=a.__values(n),h=o.next();!h.done;h=o.next()){h.value.classList.remove(c.bk_active)}}catch(t){e={error:t}}finally{try{h&&!h.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}n[s].classList.add(c.bk_active);var d=this.child_views;try{for(var _=a.__values(d),u=_.next();!u.done;u=_.next()){var p=u.value;l.hide(p.el)}}catch(e){i={error:e}}finally{try{u&&!u.done&&(r=_.return)&&r.call(_)}finally{if(i)throw i.error}}l.show(d[s].el)},t}(o.LayoutDOMView);i.TabsView=f,f.__name__="TabsView";var y=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Tabs=function(){this.prototype.default_view=f,this.define({tabs:[n.Array,[]],tabs_location:[n.Location,"above"],active:[n.Number,0]})},t}(o.LayoutDOM);i.Tabs=y,y.__name__="Tabs",y.init_Tabs();var m=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Panel=function(){this.define({title:[n.String,""],child:[n.Instance],closable:[n.Boolean,!1]})},t}(h.Model);i.Panel=m,m.__name__="Panel",m.init_Panel()},
function _(e,b,a){Object.defineProperty(a,"__esModule",{value:!0}),a.bk_tabs_header="bk-tabs-header",a.bk_headers_wrapper="bk-headers-wrapper",a.bk_headers="bk-headers",a.bk_tab="bk-tab",a.bk_close="bk-close"},
function _(n,b,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_btn="bk-btn",t.bk_btn_group="bk-btn-group",t.bk_btn_default="bk-btn-default",t.bk_btn_primary="bk-btn-primary",t.bk_btn_success="bk-btn-success",t.bk_btn_warning="bk-btn-warning",t.bk_btn_danger="bk-btn-danger",t.bk_btn_type=function(n){switch(n){case"default":return t.bk_btn_default;case"primary":return t.bk_btn_primary;case"success":return t.bk_btn_success;case"warning":return t.bk_btn_warning;case"danger":return t.bk_btn_danger}},t.bk_dropdown_toggle="bk-dropdown-toggle"},
function _(e,b,d){Object.defineProperty(d,"__esModule",{value:!0}),d.bk_menu="bk-menu",d.bk_caret="bk-caret",d.bk_divider="bk-divider"},
function _(n,o,b){Object.defineProperty(b,"__esModule",{value:!0});b.default="\n.bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"},
function _(n,o,r){Object.defineProperty(r,"__esModule",{value:!0});r.default="\n.bk-root .bk-menu-icon {\n  width: 28px;\n  height: 28px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-context-menu {\n  position: absolute;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  width: auto;\n  height: auto;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-context-menu.bk-horizontal {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-context-menu.bk-vertical {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-context-menu > .bk-divider {\n  cursor: default;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-context-menu.bk-horizontal > .bk-divider {\n  width: 1px;\n  margin: 5px 0;\n}\n.bk-root .bk-context-menu.bk-vertical > .bk-divider {\n  height: 1px;\n  margin: 0 5px;\n}\n.bk-root .bk-context-menu > :not(.bk-divider) {\n  border: 1px solid transparent;\n}\n.bk-root .bk-context-menu > :not(.bk-divider).bk-active {\n  border-color: #26aae1;\n}\n.bk-root .bk-context-menu > :not(.bk-divider):hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-bottom-left-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child {\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child {\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});n.default='\n.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');\n}\n'},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),o=t(389),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(o.ColumnView);i.WidgetBoxView=_,_.__name__="WidgetBoxView";var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_WidgetBox=function(){this.prototype.default_view=_},e}(o.Column);i.WidgetBox=u,u.__name__="WidgetBox",u.init_WidgetBox()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0}),e(1).__exportStar(e(403),t);var a=e(404);t.Marker=a.Marker;var _=e(405);t.Scatter=_.Scatter},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var i=e(1),r=e(404),n=i.__importStar(e(353)),s=Math.sqrt(3);function c(e,t){e.rotate(Math.PI/4),l(e,t),e.rotate(-Math.PI/4)}function a(e,t){var o=t*s,i=o/3;e.moveTo(-o/2,-i),e.lineTo(0,0),e.lineTo(o/2,-i),e.lineTo(0,0),e.lineTo(0,t)}function l(e,t){e.moveTo(0,t),e.lineTo(0,-t),e.moveTo(-t,0),e.lineTo(t,0)}function u(e,t){e.moveTo(0,t),e.lineTo(t/1.5,0),e.lineTo(0,-t),e.lineTo(-t/1.5,0),e.closePath()}function v(e,t){var o=t*s,i=o/3;e.moveTo(-t,i),e.lineTo(t,i),e.lineTo(0,i-o),e.closePath()}function d(e,t,o,i,r){l(e,o),c(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function _(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function f(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),l(e,o),e.stroke())}function T(e,t,o,i,r){_(e,t,o,i,r),P(e,t,o,i,r)}function z(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),a(e,o),e.stroke())}function C(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),c(e,o),e.stroke())}function h(e,t,o,i,r){l(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function k(e,t,o,i,r){u(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function m(e,t,o,i,r){u(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(0,o),e.lineTo(0,-o),e.moveTo(-o/1.5,0),e.lineTo(o/1.5,0),e.stroke())}function q(e,t,o,i,r){k(e,t,o,i,r),P(e,t,o,i,r)}function P(e,t,o,i,r){!function(e,t){e.beginPath(),e.arc(0,0,t/4,0,2*Math.PI,!1),e.closePath()}(e,o),i.set_vectorize(e,t),e.fillStyle=e.strokeStyle,e.fill()}function D(e,t,o,i,r){!function(e,t){var o=t/2,i=s*o;e.moveTo(t,0),e.lineTo(o,-i),e.lineTo(-o,-i),e.lineTo(-t,0),e.lineTo(-o,i),e.lineTo(o,i),e.closePath()}(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function g(e,t,o,i,r){D(e,t,o,i,r),P(e,t,o,i)}function p(e,t,o,i,r){e.rotate(Math.PI),v(e,o),e.rotate(-Math.PI),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function S(e,t,o,i,r){var n=3*o/8,s=[n,n,o,o,n,n,-n,-n,-o,-o,-n,-n],c=[o,n,n,-n,-n,-o,-o,-n,-n,n,n,o];for(e.moveTo(s[0],c[0]),t=1;t<12;t++)e.lineTo(s[t],c[t]);e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function G(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function L(e,t,o,i,r){var n=3*o/8;e.moveTo(-o,-o),e.quadraticCurveTo(0,-n,o,-o),e.quadraticCurveTo(n,0,o,o),e.quadraticCurveTo(0,n,-o,o),e.quadraticCurveTo(-n,0,-o,-o),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function M(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),l(e,o),e.stroke())}function x(e,t,o,i,r){G(e,t,o,i,r),P(e,t,o,i)}function I(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(-o,o),e.lineTo(o,-o),e.moveTo(-o,-o),e.lineTo(o,o),e.stroke())}function y(e,t,o,i,r){v(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function X(e,t,o,i,r){y(e,t,o,i,r),P(e,t,o,i)}function H(e,t,o,i,r){var n=o*s,c=n/3,a=3*c/8;e.moveTo(-o,c),e.quadraticCurveTo(0,a,o,c),e.quadraticCurveTo(s*a/2,a/2,0,c-n),e.quadraticCurveTo(-s*a/2,a/2,-o,c),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function Y(e,t,o,i,r){!function(e,t){e.moveTo(-t,0),e.lineTo(t,0)}(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function A(e,t,o,i,r){c(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function b(e,t,o,i,r){a(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function w(e,t,o){var n,s=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(r,e),r.initClass=function(){this.prototype._render_one=t,this.prototype.glglyph_cls=o},r}(r.MarkerView);s.initClass();var c=((n=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.default_view=s},t}(r.Marker)).__name__=e,n);return c.initClass(),c}o.Asterisk=w("Asterisk",d,n.AsteriskGL),o.CircleCross=w("CircleCross",f,n.CircleCrossGL),o.CircleDot=w("CircleDot",T),o.CircleY=w("CircleY",z),o.CircleX=w("CircleX",C,n.CircleXGL),o.Cross=w("Cross",h,n.CrossGL),o.Dash=w("Dash",Y),o.Diamond=w("Diamond",k,n.DiamondGL),o.DiamondCross=w("DiamondCross",m,n.DiamondCrossGL),o.DiamondDot=w("DiamondDot",q),o.Dot=w("Dot",P),o.Hex=w("Hex",D,n.HexGL),o.HexDot=w("HexDot",g),o.InvertedTriangle=w("InvertedTriangle",p,n.InvertedTriangleGL),o.Plus=w("Plus",S),o.Square=w("Square",G,n.SquareGL),o.SquareCross=w("SquareCross",M,n.SquareCrossGL),o.SquareDot=w("SquareDot",x),o.SquarePin=w("SquarePin",L),o.SquareX=w("SquareX",I,n.SquareXGL),o.Triangle=w("Triangle",y,n.TriangleGL),o.TriangleDot=w("TriangleDot",X),o.TrianglePin=w("TrianglePin",H),o.X=w("X",A,n.XGL),o.Y=w("Y",b),o.marker_funcs={asterisk:d,circle:_,circle_cross:f,circle_dot:T,circle_y:z,circle_x:C,cross:h,diamond:k,diamond_dot:q,diamond_cross:m,dot:P,hex:D,hex_dot:g,inverted_triangle:p,plus:S,square:G,square_cross:M,square_dot:x,square_pin:L,square_x:I,triangle:y,triangle_dot:X,triangle_pin:H,dash:Y,x:A,y:b}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),n=e(208),s=e(143),a=i.__importStar(e(216)),_=i.__importStar(e(133)),l=e(124),o=e(203),h=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(r,e),r.prototype.initialize=function(){e.prototype.initialize.call(this);var r=this.renderer.plot_view.canvas_view.webgl;null!=r&&null!=this.glglyph_cls&&(this.glglyph=new this.glglyph_cls(r.gl,this))},r.prototype._render=function(e,r,t){var n,s,a=t.sx,_=t.sy,l=t._size,o=t._angle;try{for(var h=i.__values(r),y=h.next();!y.done;y=h.next()){var c=y.value;if(!isNaN(a[c]+_[c]+l[c]+o[c])){var d=l[c]/2;e.beginPath(),e.translate(a[c],_[c]),o[c]&&e.rotate(o[c]),this._render_one(e,c,d,this.visuals.line,this.visuals.fill),o[c]&&e.rotate(-o[c]),e.translate(-a[c],-_[c])}}}catch(e){n={error:e}}finally{try{y&&!y.done&&(s=h.return)&&s.call(h)}finally{if(n)throw n.error}}},r.prototype._mask_data=function(){var e=this.renderer.plot_view.frame.bbox.h_range,r=e.start-this.max_size,t=e.end+this.max_size,n=i.__read(this.renderer.xscale.r_invert(r,t),2),s=n[0],a=n[1],_=this.renderer.plot_view.frame.bbox.v_range,l=_.start-this.max_size,o=_.end+this.max_size,h=i.__read(this.renderer.yscale.r_invert(l,o),2),y=h[0],c=h[1];return this.index.indices({x0:s,x1:a,y0:y,y1:c})},r.prototype._hit_point=function(e){var r,t,n=e.sx,s=e.sy,a=n-this.max_size,_=n+this.max_size,l=i.__read(this.renderer.xscale.r_invert(a,_),2),h=l[0],y=l[1],c=s-this.max_size,d=s+this.max_size,x=i.__read(this.renderer.yscale.r_invert(c,d),2),v=x[0],p=x[1],u=this.index.indices({x0:h,x1:y,y0:v,y1:p}),f=[];try{for(var g=i.__values(u),w=g.next();!w.done;w=g.next()){var m=w.value,z=this._size[m]/2;Math.abs(this.sx[m]-n)<=z&&Math.abs(this.sy[m]-s)<=z&&f.push(m)}}catch(e){r={error:e}}finally{try{w&&!w.done&&(t=g.return)&&t.call(g)}finally{if(r)throw r.error}}return new o.Selection({indices:f})},r.prototype._hit_span=function(e){var r,t,n,s,a,_,l=e.sx,h=e.sy,y=this.bounds(),c=this.max_size/2;if("h"==e.direction){a=y.y0,_=y.y1;var d=l-c,x=l+c;n=(r=i.__read(this.renderer.xscale.r_invert(d,x),2))[0],s=r[1]}else{n=y.x0,s=y.x1;var v=h-c,p=h+c;a=(t=i.__read(this.renderer.yscale.r_invert(v,p),2))[0],_=t[1]}var u=i.__spread(this.index.indices({x0:n,x1:s,y0:a,y1:_}));return new o.Selection({indices:u})},r.prototype._hit_rect=function(e){var r=e.sx0,t=e.sx1,n=e.sy0,s=e.sy1,a=i.__read(this.renderer.xscale.r_invert(r,t),2),_=a[0],l=a[1],h=i.__read(this.renderer.yscale.r_invert(n,s),2),y=h[0],c=h[1],d=i.__spread(this.index.indices({x0:_,x1:l,y0:y,y1:c}));return new o.Selection({indices:d})},r.prototype._hit_poly=function(e){for(var r=e.sx,t=e.sy,i=l.range(0,this.sx.length),n=[],s=0,_=i.length;s<_;s++){var h=i[s];a.point_in_poly(this.sx[s],this.sy[s],r,t)&&n.push(h)}return new o.Selection({indices:n})},r.prototype._get_legend_args=function(e,r){var t=e.x0,i=e.x1,n=e.y0,s=e.y1,a=r+1,_=new Array(a);_[r]=(t+i)/2;var l=new Array(a);l[r]=(n+s)/2;var o=new Array(a);o[r]=.4*Math.min(Math.abs(i-t),Math.abs(s-n));var h=new Array(a);return h[r]=0,{sx:_,sy:l,_size:o,_angle:h}},r.prototype.draw_legend_for_index=function(e,r,t){var i=r.x0,n=r.x1,s=r.y0,a=r.y1,_=this._get_legend_args({x0:i,x1:n,y0:s,y1:a},t);this._render(e,[t],_)},r}(n.XYGlyphView);t.MarkerView=h,h.__name__="MarkerView";var y=function(e){function r(r){return e.call(this,r)||this}return i.__extends(r,e),r.init_Marker=function(){this.mixins([s.LineVector,s.FillVector]),this.define({size:[_.DistanceSpec,{units:"screen",value:4}],angle:[_.AngleSpec,0]})},r}(n.XYGlyph);t.Marker=y,y.__name__="Marker",y.init_Marker()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var a=e(1),n=e(404),i=e(403),_=a.__importStar(e(133)),l=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(r,e),r.prototype._render=function(e,r,t){var n,_,l=t.sx,s=t.sy,o=t._size,u=t._angle,c=t._marker;try{for(var f=a.__values(r),y=f.next();!y.done;y=f.next()){var d=y.value;if(!isNaN(l[d]+s[d]+o[d]+u[d])&&null!=c[d]){var h=o[d]/2;e.beginPath(),e.translate(l[d],s[d]),u[d]&&e.rotate(u[d]),i.marker_funcs[c[d]](e,d,h,this.visuals.line,this.visuals.fill),u[d]&&e.rotate(-u[d]),e.translate(-l[d],-s[d])}}}catch(e){n={error:e}}finally{try{y&&!y.done&&(_=f.return)&&_.call(f)}finally{if(n)throw n.error}}},r.prototype.draw_legend_for_index=function(e,r,t){var a=r.x0,n=r.x1,i=r.y0,_=r.y1,l=this._get_legend_args({x0:a,x1:n,y0:i,y1:_},t),s=new Array(t+1);s[t]=this._marker[t],l._marker=s,this._render(e,[t],l)},r}(n.MarkerView);t.ScatterView=l,l.__name__="ScatterView";var s=function(e){function r(r){return e.call(this,r)||this}return a.__extends(r,e),r.init_Scatter=function(){this.prototype.default_view=l,this.define({marker:[_.MarkerSpec,{value:"circle"}]})},r}(n.Marker);t.Scatter=s,s.__name__="Scatter",s.init_Scatter()},
function _(a,o,p){Object.defineProperty(p,"__esModule",{value:!0});var t=a(407);p.MapOptions=t.MapOptions;var e=a(407);p.GMapOptions=e.GMapOptions;var n=a(407);p.GMapPlot=n.GMapPlot;var M=a(408);p.Plot=M.Plot},
function _(t,n,i){Object.defineProperty(i,"__esModule",{value:!0});var e=t(1),o=t(134),a=t(408),r=e.__importStar(t(133)),p=t(196),_=t(273),s=t(434);i.GMapPlotView=s.GMapPlotView;var l=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_MapOptions=function(){this.define({lat:[r.Number],lng:[r.Number],zoom:[r.Number,12]})},n}(p.Model);i.MapOptions=l,l.__name__="MapOptions",l.init_MapOptions();var u=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_GMapOptions=function(){this.define({map_type:[r.String,"roadmap"],scale_control:[r.Boolean,!1],styles:[r.String],tilt:[r.Int,45]})},n}(l);i.GMapOptions=u,u.__name__="GMapOptions",u.init_GMapOptions();var c=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_GMapPlot=function(){this.prototype.default_view=s.GMapPlotView,this.define({map_options:[r.Instance],api_key:[r.String]}),this.override({x_range:function(){return new _.Range1d},y_range:function(){return new _.Range1d}})},n.prototype.initialize=function(){t.prototype.initialize.call(this),this.use_map=!0,this.api_key||o.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")},n}(a.Plot);i.GMapPlot=c,c.__name__="GMapPlot",c.init_GMapPlot()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),o=n.__importStar(e(143)),i=n.__importStar(e(133)),a=e(130),l=e(124),s=e(128),u=e(123),_=e(387),h=e(284),c=e(260),d=e(409),p=e(200),f=e(205),b=e(325),y=e(427);r.PlotView=y.PlotView;var g=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Plot=function(){this.prototype.default_view=y.PlotView,this.mixins([["outline_",o.Line],["background_",o.Fill],["border_",o.Fill]]),this.define({toolbar:[i.Instance,function(){return new d.Toolbar}],toolbar_location:[i.Location,"right"],toolbar_sticky:[i.Boolean,!0],plot_width:[i.Number,600],plot_height:[i.Number,600],frame_width:[i.Number,null],frame_height:[i.Number,null],title:[i.Any,function(){return new h.Title({text:""})}],title_location:[i.Location,"above"],above:[i.Array,[]],below:[i.Array,[]],left:[i.Array,[]],right:[i.Array,[]],center:[i.Array,[]],renderers:[i.Array,[]],x_range:[i.Instance,function(){return new b.DataRange1d}],extra_x_ranges:[i.Any,{}],y_range:[i.Instance,function(){return new b.DataRange1d}],extra_y_ranges:[i.Any,{}],x_scale:[i.Instance,function(){return new c.LinearScale}],y_scale:[i.Instance,function(){return new c.LinearScale}],lod_factor:[i.Number,10],lod_interval:[i.Number,300],lod_threshold:[i.Number,2e3],lod_timeout:[i.Number,500],hidpi:[i.Boolean,!0],output_backend:[i.OutputBackend,"canvas"],min_border:[i.Number,5],min_border_top:[i.Number,null],min_border_left:[i.Number,null],min_border_bottom:[i.Number,null],min_border_right:[i.Number,null],inner_width:[i.Number],inner_height:[i.Number],outer_width:[i.Number],outer_height:[i.Number],match_aspect:[i.Boolean,!1],aspect_scale:[i.Number,1],reset_policy:[i.ResetPolicy,"standard"]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},Object.defineProperty(t.prototype,"width",{get:function(){var e=this.properties.width.get_value();return null!=e?e:this.plot_width},set:function(e){this.setv({width:e,plot_width:e})},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){var e=this.properties.height.get_value();return null!=e?e:this.plot_height},set:function(e){this.setv({height:e,plot_height:e})},enumerable:!0,configurable:!0}),t.prototype._doc_attached=function(){e.prototype._doc_attached.call(this),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])},t.prototype.initialize=function(){var t,r,o,i;e.prototype.initialize.call(this),this.reset=new a.Signal0(this,"reset");try{for(var l=n.__values(s.values(this.extra_x_ranges).concat(this.x_range)),_=l.next();!_.done;_=l.next()){var h=_.value,c=h.plots;u.isArray(c)&&(c=c.concat(this),h.setv({plots:c},{silent:!0}))}}catch(e){t={error:e}}finally{try{_&&!_.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}try{for(var d=n.__values(s.values(this.extra_y_ranges).concat(this.y_range)),p=d.next();!p.done;p=d.next()){var f=p.value;c=f.plots;u.isArray(c)&&(c=c.concat(this),f.setv({plots:c},{silent:!0}))}}catch(e){o={error:e}}finally{try{p&&!p.done&&(i=d.return)&&i.call(d)}finally{if(o)throw o.error}}},t.prototype.add_layout=function(e,t){var r;void 0===t&&(t="center");var o=this.properties[t].get_value();this.setv(((r={})[t]=n.__spread(o,[e]),r))},t.prototype.remove_layout=function(e){var t=function(t){l.remove_by(t,(function(t){return t==e}))};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)},t.prototype.add_renderers=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.renderers=this.renderers.concat(e)},t.prototype.add_glyph=function(e,t,r){void 0===t&&(t=new p.ColumnDataSource),void 0===r&&(r={});var n=Object.assign(Object.assign({},r),{data_source:t,glyph:e}),o=new f.GlyphRenderer(n);return this.add_renderers(o),o},t.prototype.add_tools=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.toolbar.tools=this.toolbar.tools.concat(e)},Object.defineProperty(t.prototype,"panels",{get:function(){return n.__spread(this.side_panels,this.center)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"side_panels",{get:function(){var e=this.above,t=this.below,r=this.left,n=this.right;return l.concat([e,t,r,n])},enumerable:!0,configurable:!0}),t}(_.LayoutDOM);r.Plot=g,g.__name__="Plot",g.init_Plot()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),n=i.__importStar(t(133)),a=t(123),o=t(124),l=t(128),c=t(410),s=t(420),u=function(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},_=function(t){return"tap"==t||"pan"==t},v=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Toolbar=function(){this.prototype.default_view=s.ToolbarBaseView,this.define({active_drag:[n.Any,"auto"],active_inspect:[n.Any,"auto"],active_scroll:[n.Any,"auto"],active_tap:[n.Any,"auto"],active_multi:[n.Any,null]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var r=this.properties,i=r.tools,n=r.active_drag,a=r.active_inspect,o=r.active_scroll,l=r.active_tap,c=r.active_multi;this.on_change([i,n,a,o,l,c],(function(){return e._init_tools()}))},e.prototype._init_tools=function(){var e,r,n,s,v,h,f,p,y,d,g,x,w=this;if(t.prototype._init_tools.call(this),"auto"==this.active_inspect);else if(this.active_inspect instanceof c.InspectTool){var b=!1;try{for(var T=i.__values(this.inspectors),m=T.next();!m.done;m=T.next()){(I=m.value)!=this.active_inspect?I.active=!1:b=!0}}catch(t){e={error:t}}finally{try{m&&!m.done&&(r=T.return)&&r.call(T)}finally{if(e)throw e.error}}b||(this.active_inspect=null)}else if(a.isArray(this.active_inspect)){var A=o.intersection(this.active_inspect,this.inspectors);A.length!=this.active_inspect.length&&(this.active_inspect=A);try{for(var B=i.__values(this.inspectors),j=B.next();!j.done;j=B.next()){var I=j.value;o.includes(this.active_inspect,I)||(I.active=!1)}}catch(t){n={error:t}}finally{try{j&&!j.done&&(s=B.return)&&s.call(B)}finally{if(n)throw n.error}}}else if(null==this.active_inspect)try{for(var M=i.__values(this.inspectors),O=M.next();!O.done;O=M.next()){(I=O.value).active=!1}}catch(t){v={error:t}}finally{try{O&&!O.done&&(h=M.return)&&h.call(M)}finally{if(v)throw v.error}}var P=function(t){t.active?w._active_change(t):t.active=!0};try{for(var S=i.__values(l.values(this.gestures)),V=S.next();!V.done;V=S.next()){(H=V.value).tools=o.sort_by(H.tools,(function(t){return t.default_order}));var k=function(t){q.connect(t.properties.active.change,(function(){return w._active_change(t)}))},q=this;try{for(var z=(y=void 0,i.__values(H.tools)),C=z.next();!C.done;C=z.next()){k(C.value)}}catch(t){y={error:t}}finally{try{C&&!C.done&&(d=z.return)&&d.call(z)}finally{if(y)throw y.error}}}}catch(t){f={error:t}}finally{try{V&&!V.done&&(p=S.return)&&p.call(S)}finally{if(f)throw f.error}}try{for(var D=i.__values(l.entries(this.gestures)),E=D.next();!E.done;E=D.next()){var F=i.__read(E.value,2),G=F[0],H=F[1],J=u(G);if(J){var K=this[J];"auto"==K?0!=H.tools.length&&_(G)&&P(H.tools[0]):null!=K&&(o.includes(this.tools,K)?P(K):this[J]=null)}}}catch(t){g={error:t}}finally{try{E&&!E.done&&(x=D.return)&&x.call(D)}finally{if(g)throw g.error}}},e}(s.ToolbarBase);r.Toolbar=v,v.__name__="Toolbar",v.init_Toolbar()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=t(411),_=t(419),l=o.__importStar(t(133)),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(i.ButtonToolView);n.InspectToolView=r,r.__name__="InspectToolView";var u=function(t){function e(e){var n=t.call(this,e)||this;return n.event_type="move",n}return o.__extends(e,t),e.init_InspectTool=function(){this.prototype.button_view=_.OnOffButtonView,this.define({toggleable:[l.Boolean,!0]}),this.override({active:!0})},e}(i.ButtonTool);n.InspectTool=u,u.__name__="InspectTool",u.init_InspectTool()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var n=t(1),i=n.__importDefault(t(412)),r=t(193),l=t(413),u=t(187),a=n.__importStar(t(133)),s=t(144),c=t(123),p=t(124),_=t(414),h=n.__importDefault(t(415)),m=n.__importDefault(t(416)),d=n.__importDefault(t(399)),f=t(417),y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this);var o=this.model.menu;if(null!=o){var n=this.parent.model.toolbar_location,r="left"==n||"above"==n,l=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new f.ContextMenu(r?p.reversed(o):o,{orientation:l,prevent_hide:function(t){return t.target==e.el}})}this._hammer=new i.default(this.el,{touchAction:"auto",inputClass:i.default.TouchMouseInput}),this.connect(this.model.change,(function(){return e.render()})),this._hammer.on("tap",(function(t){var o;(null===(o=e._menu)||void 0===o?void 0:o.is_open)?e._menu.hide():t.target==e.el&&e._clicked()})),this._hammer.on("press",(function(){return e._pressed()}))},e.prototype.remove=function(){var e;this._hammer.destroy(),null===(e=this._menu)||void 0===e||e.remove(),t.prototype.remove.call(this)},e.prototype.styles=function(){return n.__spread(t.prototype.styles.call(this),[h.default,m.default,d.default])},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(_.bk_toolbar_button)},e.prototype.render=function(){u.empty(this.el);var t=this.model.computed_icon;c.isString(t)&&(s.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip,null!=this._menu&&this.root.el.appendChild(this._menu.el)},e.prototype._pressed=function(){var t,e=this,o=this.el.getBoundingClientRect(),n=o.left,i=o.top,r=o.right,l=o.bottom,u=function(){switch(e.parent.model.toolbar_location){case"right":return{right:n,top:i};case"left":return{left:r,top:i};case"above":return{left:n,top:l};case"below":return{left:n,bottom:i}}}();null===(t=this._menu)||void 0===t||t.toggle(u)},e}(r.DOMView);o.ButtonToolButtonView=y,y.__name__="ButtonToolButtonView";var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(l.ToolView);o.ButtonToolView=v,v.__name__="ButtonToolView";var b=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_ButtonTool=function(){this.internal({disabled:[a.Boolean,!1]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"menu",{get:function(){return null},enumerable:!0,configurable:!0}),e}(l.Tool);o.ButtonTool=b,b.__name__="ButtonTool",b.init_ButtonTool()},
function _(t,e,n){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,n,i,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=n.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,n){return setTimeout(y(t,n),e)}function p(t,e,n){return!!Array.isArray(t)&&(f(t,n[e],n),!0)}function f(t,e,n){var i;if(t)if(t.forEach)t.forEach(e,n);else if(void 0!==t.length)for(i=0;i<t.length;)e.call(n,t[i],i,t),i++;else for(i in t)t.hasOwnProperty(i)&&e.call(n,t[i],i,t)}function v(e,n,i){var r="DEPRECATED METHOD: "+n+"\n"+i+" AT \n";return function(){var n=new Error("get-stack-trace"),i=n&&n.stack?n.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,i),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(null==t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),n=1;n<arguments.length;n++){var i=arguments[n];if(null!=i)for(var r in i)i.hasOwnProperty(r)&&(e[r]=i[r])}return e}:Object.assign;var d=v((function(t,e,n){for(var i=Object.keys(e),r=0;r<i.length;)(!n||n&&void 0===t[i[r]])&&(t[i[r]]=e[i[r]]),r++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,n){var i,r=e.prototype;(i=t.prototype=Object.create(r)).constructor=t,i._super=r,n&&s(i,n)}function y(t,e){return function(){return t.apply(e,arguments)}}function T(t,e){return"function"==typeof t?t.apply(e&&e[0]||void 0,e):t}function E(t,e){return void 0===t?e:t}function I(t,e,n){f(S(e),(function(e){t.addEventListener(e,n,!1)}))}function A(t,e,n){f(S(e),(function(e){t.removeEventListener(e,n,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,n){if(t.indexOf&&!n)return t.indexOf(e);for(var i=0;i<t.length;){if(n&&t[i][n]==e||!n&&t[i]===e)return i;i++}return-1}function x(t){return Array.prototype.slice.call(t,0)}function P(t,e,n){for(var i=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&i.push(t[s]),r[s]=o,s++}return n&&(i=e?i.sort((function(t,n){return t[e]>n[e]})):i.sort()),i}function D(t,e){for(var n,i,r=e[0].toUpperCase()+e.slice(1),s=0;s<o.length;){if((i=(n=o[s])?n+r:e)in t)return i;s++}}var w=1;function O(e){var n=e.ownerDocument||e;return n.defaultView||n.parentWindow||t}var R="ontouchstart"in t,M=void 0!==D(t,"PointerEvent"),z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N=["x","y"],X=["clientX","clientY"];function Y(t,e){var n=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){T(t.options.enable,[t])&&n.handler(e)},this.init()}function F(t,e,n){var i=n.pointers.length,r=n.changedPointers.length,s=1&e&&i-r==0,o=12&e&&i-r==0;n.isFirst=!!s,n.isFinal=!!o,s&&(t.session={}),n.eventType=e,function(t,e){var n=t.session,i=e.pointers,r=i.length;n.firstInput||(n.firstInput=W(e));r>1&&!n.firstMultiple?n.firstMultiple=W(e):1===r&&(n.firstMultiple=!1);var s=n.firstInput,o=n.firstMultiple,a=o?o.center:s.center,h=e.center=q(i);e.timeStamp=c(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=U(a,h),e.distance=L(a,h),function(t,e){var n=e.center,i=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},i=t.offsetDelta={x:n.x,y:n.y});e.deltaX=r.x+(n.x-i.x),e.deltaY=r.y+(n.y-i.y)}(n,e),e.offsetDirection=H(e.deltaX,e.deltaY);var l=k(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=l.x,e.overallVelocityY=l.y,e.overallVelocity=u(l.x)>u(l.y)?l.x:l.y,e.scale=o?(p=o.pointers,f=i,L(f[0],f[1],X)/L(p[0],p[1],X)):1,e.rotation=o?function(t,e){return U(e[1],e[0],X)+U(t[1],t[0],X)}(o.pointers,i):0,e.maxPointers=n.prevInput?e.pointers.length>n.prevInput.maxPointers?e.pointers.length:n.prevInput.maxPointers:e.pointers.length,function(t,e){var n,i,r,s,o=t.lastInterval||e,a=e.timeStamp-o.timeStamp;if(8!=e.eventType&&(a>25||void 0===o.velocity)){var h=e.deltaX-o.deltaX,c=e.deltaY-o.deltaY,l=k(a,h,c);i=l.x,r=l.y,n=u(l.x)>u(l.y)?l.x:l.y,s=H(h,c),t.lastInterval=e}else n=o.velocity,i=o.velocityX,r=o.velocityY,s=o.direction;e.velocity=n,e.velocityX=i,e.velocityY=r,e.direction=s}(n,e);var p,f;var v=t.element;_(e.srcEvent.target,v)&&(v=e.srcEvent.target);e.target=v}(t,n),t.emit("hammer.input",n),t.recognize(n),t.session.prevInput=n}function W(t){for(var e=[],n=0;n<t.pointers.length;)e[n]={clientX:h(t.pointers[n].clientX),clientY:h(t.pointers[n].clientY)},n++;return{timeStamp:c(),pointers:e,center:q(e),deltaX:t.deltaX,deltaY:t.deltaY}}function q(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var n=0,i=0,r=0;r<e;)n+=t[r].clientX,i+=t[r].clientY,r++;return{x:h(n/e),y:h(i/e)}}function k(t,e,n){return{x:e/t||0,y:n/t||0}}function H(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function L(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return Math.sqrt(i*i+r*r)}function U(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return 180*Math.atan2(r,i)/Math.PI}Y.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var V={mousedown:1,mousemove:2,mouseup:4};function j(){this.evEl="mousedown",this.evWin="mousemove mouseup",this.pressed=!1,Y.apply(this,arguments)}g(j,Y,{handler:function(t){var e=V[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var G={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Z={2:"touch",3:"pen",4:"mouse",5:"kinect"},B="pointerdown",$="pointermove pointerup pointercancel";function J(){this.evEl=B,this.evWin=$,Y.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(B="MSPointerDown",$="MSPointerMove MSPointerUp MSPointerCancel"),g(J,Y,{handler:function(t){var e=this.store,n=!1,i=t.type.toLowerCase().replace("ms",""),r=G[i],s=Z[t.pointerType]||t.pointerType,o="touch"==s,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(n=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),n&&e.splice(a,1))}});var K={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function Q(){this.evTarget="touchstart",this.evWin="touchstart touchmove touchend touchcancel",this.started=!1,Y.apply(this,arguments)}function tt(t,e){var n=x(t.touches),i=x(t.changedTouches);return 12&e&&(n=P(n.concat(i),"identifier",!0)),[n,i]}g(Q,Y,{handler:function(t){var e=K[t.type];if(1===e&&(this.started=!0),this.started){var n=tt.call(this,t,e);12&e&&n[0].length-n[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}}});var et={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function nt(){this.evTarget="touchstart touchmove touchend touchcancel",this.targetIds={},Y.apply(this,arguments)}function it(t,e){var n=x(t.touches),i=this.targetIds;if(3&e&&1===n.length)return i[n[0].identifier]=!0,[n,n];var r,s,o=x(t.changedTouches),a=[],h=this.target;if(s=n.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)i[s[r].identifier]=!0,r++;for(r=0;r<o.length;)i[o[r].identifier]&&a.push(o[r]),12&e&&delete i[o[r].identifier],r++;return a.length?[P(s.concat(a),"identifier",!0),a]:void 0}g(nt,Y,{handler:function(t){var e=et[t.type],n=it.call(this,t,e);n&&this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}});function rt(){Y.apply(this,arguments);var t=y(this.handler,this);this.touch=new nt(this.manager,t),this.mouse=new j(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function st(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,ot.call(this,e)):12&t&&ot.call(this,e)}function ot(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var n={x:e.clientX,y:e.clientY};this.lastTouches.push(n);var i=this.lastTouches;setTimeout((function(){var t=i.indexOf(n);t>-1&&i.splice(t,1)}),2500)}}function at(t){for(var e=t.srcEvent.clientX,n=t.srcEvent.clientY,i=0;i<this.lastTouches.length;i++){var r=this.lastTouches[i],s=Math.abs(e-r.x),o=Math.abs(n-r.y);if(s<=25&&o<=25)return!0}return!1}g(rt,Y,{handler:function(t,e,n){var i="touch"==n.pointerType,r="mouse"==n.pointerType;if(!(r&&n.sourceCapabilities&&n.sourceCapabilities.firesTouchEvents)){if(i)st.call(this,e,n);else if(r&&at.call(this,n))return;this.callback(t,e,n)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var ht=D(a.style,"touchAction"),ut=void 0!==ht,ct=function(){if(!ut)return!1;var e={},n=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(i){e[i]=!n||t.CSS.supports("touch-action",i)})),e}();function lt(t,e){this.manager=t,this.set(e)}lt.prototype={set:function(t){"compute"==t&&(t=this.compute()),ut&&this.manager.element.style&&ct[t]&&(this.manager.element.style[ht]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){T(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,"none"))return"none";var e=C(t,"pan-x"),n=C(t,"pan-y");if(e&&n)return"none";if(e||n)return e?"pan-x":"pan-y";if(C(t,"manipulation"))return"manipulation";return"auto"}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,n=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var i=this.actions,r=C(i,"none")&&!ct.none,s=C(i,"pan-y")&&!ct["pan-y"],o=C(i,"pan-x")&&!ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&n||o&&24&n?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};function pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function ft(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function vt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function dt(t,e){var n=e.manager;return n?n.get(t):t}function mt(){pt.apply(this,arguments)}function gt(){mt.apply(this,arguments),this.pX=null,this.pY=null}function yt(){mt.apply(this,arguments)}function Tt(){pt.apply(this,arguments),this._timer=null,this._input=null}function Et(){mt.apply(this,arguments)}function It(){mt.apply(this,arguments)}function At(){pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function _t(t,e){return(e=e||{}).recognizers=E(e.recognizers,_t.defaults.preset),new Ct(t,e)}pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=dt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=dt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=dt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=dt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,n=this.state;function i(n){e.manager.emit(n,t)}n<8&&i(e.options.event+ft(n)),i(e.options.event),t.additionalEvent&&i(t.additionalEvent),n>=8&&i(e.options.event+ft(n))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!T(this.options.enable,[this,e]))return this.reset(),void(this.state=32);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(mt,pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,n=t.eventType,i=6&e,r=this.attrTest(t);return i&&(8&n||!r)?16|e:i||r?4&n?8|e:2&e?4|e:2:32}}),g(gt,mt,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push("pan-y"),24&t&&e.push("pan-x"),e},directionTest:function(t){var e=this.options,n=!0,i=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,n=s!=this.pX,i=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,n=o!=this.pY,i=Math.abs(t.deltaY))),t.direction=r,n&&i>e.threshold&&r&e.direction},attrTest:function(t){return mt.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=vt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(yt,mt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(Tt,pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return["auto"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!i||!n||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Et,mt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(It,mt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return gt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,n=this.options.direction;return 30&n?e=t.overallVelocity:6&n?e=t.overallVelocityX:24&n&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&n&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=vt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(At,pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return["manipulation"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(i&&r&&n){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||L(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return 32},failTimeout:function(){return this._timer=l((function(){this.state=32}),this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),_t.VERSION="2.0.7",_t.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Et,{enable:!1}],[yt,{enable:!1},["rotate"]],[It,{direction:6}],[gt,{direction:6},["swipe"]],[At],[At,{event:"doubletap",taps:2},["tap"]],[Tt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Ct(t,e){var n;this.options=s({},_t.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((n=this).options.inputClass||(M?J:z?nt:R?rt:j))(n,F),this.touchAction=new lt(this,this.options.touchAction),St(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function St(t,e){var n,i=t.element;i.style&&(f(t.options.cssProps,(function(r,s){n=D(i.style,s),e?(t.oldCssProps[n]=i.style[n],i.style[n]=r):i.style[n]=t.oldCssProps[n]||""})),e||(t.oldCssProps={}))}Ct.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var n;this.touchAction.preventDefaults(t);var i=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<i.length;)n=i[s],2===e.stopped||r&&n!=r&&!n.canRecognizeWith(r)?n.reset():n.recognize(t),!r&&14&n.state&&(r=e.curRecognizer=n),s++}},get:function(t){if(t instanceof pt)return t;for(var e=this.recognizers,n=0;n<e.length;n++)if(e[n].options.event==t)return e[n];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,n=b(e,t);-1!==n&&(e.splice(n,1),this.touchAction.update())}return this},on:function(t,e){if(void 0!==t&&void 0!==e){var n=this.handlers;return f(S(t),(function(t){n[t]=n[t]||[],n[t].push(e)})),this}},off:function(t,e){if(void 0!==t){var n=this.handlers;return f(S(t),(function(t){e?n[t]&&n[t].splice(b(n[t],e),1):delete n[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var i=n.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<i.length;)i[r](e),r++}},destroy:function(){this.element&&St(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(_t,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:32,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:24,DIRECTION_ALL:30,Manager:Ct,Input:Y,TouchAction:lt,TouchInput:nt,MouseInput:j,PointerEventInput:J,TouchMouseInput:rt,SingleTouchInput:Q,Recognizer:pt,AttrRecognizer:mt,Tap:At,Pan:gt,Swipe:It,Pinch:yt,Rotate:Et,Press:Tt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:y,prefixed:D}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=_t,"function"==typeof define&&define.amd?define((function(){return _t})):void 0!==e&&e.exports?e.exports=_t:t.Hammer=_t}(window,document)},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=o.__importStar(t(133)),r=t(186),a=t(124),s=t(196),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){e.model.active?e.activate():e.deactivate()}))},e.prototype.activate=function(){},e.prototype.deactivate=function(){},e}(r.View);n.ToolView=_,_.__name__="ToolView";var c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Tool=function(){this.prototype._known_aliases=new Map,this.internal({active:[i.Boolean,!1]})},Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._get_dim_tooltip=function(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}},e.prototype._get_dim_limits=function(t,e,n,i){var r,s=o.__read(t,2),_=s[0],c=s[1],l=o.__read(e,2),p=l[0],u=l[1],h=n.bbox.h_range;"width"==i||"both"==i?(r=[a.min([_,p]),a.max([_,p])],r=[a.max([r[0],h.start]),a.min([r[1],h.end])]):r=[h.start,h.end];var d,f=n.bbox.v_range;return"height"==i||"both"==i?(d=[a.min([c,u]),a.max([c,u])],d=[a.max([d[0],f.start]),a.min([d[1],f.end])]):d=[f.start,f.end],[r,d]},e.register_alias=function(t,e){this.prototype._known_aliases.set(t,e)},e.from_string=function(t){var e=this.prototype._known_aliases.get(t);if(null!=e)return e();var n=o.__spread(this.prototype._known_aliases.keys());throw new Error("unexpected tool name '"+t+"', possible tools are "+n.join(", "))},e}(s.Model);n.Tool=c,c.__name__="Tool",c.init_Tool()},
function _(o,b,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_toolbar="bk-toolbar",t.bk_toolbar_hidden="bk-toolbar-hidden",t.bk_toolbar_button="bk-toolbar-button",t.bk_button_bar="bk-button-bar",t.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},
function _(o,b,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  cursor: pointer;\n  background-size: 60% 60%;\n  background-origin: border-box;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: rgba(192, 192, 192, 0.15);\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'},
function _(A,g,C){Object.defineProperty(C,"__esModule",{value:!0});C.default='\n.bk-root .bk-tool-icon-copy-to-clipboard {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-replace-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-append-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-intersect-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-subtract-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-clear-selection {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-line-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAG/3pUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHjarVdpknSpDfzPKXwEJBDLccQW4Rv4+E4BtXR198znCdeLLijgQUoppWg3//Pv5f6FDwefXJRcUk3J4xNrrKzoFH8+pyUf9/f+8J3C7y/j7jnBGApow/mZ5l2vGJfXCzne8fZ13OV+9yl3ozvx2DDYyXbauCDvRoHPON3frl5Imt7MuX8hH0seiz9/xwxnDMFgYMczUPD7m89J4fwp/iK+OVRbiMf6gm8K4bv/3NN1Pzjw2fvwn+93PLzccTZ6mJU+/HTHSX723/bSOyLi58n8jmiqz/798+a/tUZZax7rNCKOakzXqIcpu4eFDe483kh4Mv4E/byfiqd49R2OHzC1Od/woxLD44siDVJaNHfbqQNi5MkZLXPnsMdKyFy5gwwCHXhocXahhhEK+OhgLmCYn1hon1vtPBxWcPIgrGTCZrR5fHvc58A/fb5stJaFOZEvT18BF1t8AYYxZ99YBUJoXZ/K9i+50/jPjxEbwKBsNxcYqL6dLZrQK7bC5jl4cVga/Ql5yuNuABfhbAEYCmDAJwpCiXxmzkTwYwE/CuQcIjcwQOKEB1ByDCGBnMJ2Nt7JtNey8BmGvIAICSlkUFODgqwYJSbkW0EIqZMgUUSSZClSRVNIMUlKKSfTKc0hxyw55ZxLrllLKLFISSWXUmrRyjVAxsTVVHMttVZVHKpRsZdivWKgcQstNmmp5VZabdoRPj126annXnrtOniEAQlwI408yqhDJ02E0oxTZpp5llmnLsTaCisuWWnlVVZd+mTtsvqVtU/m/po1uqzxJsrW5RdrGM75sQWZnIhxBsY4EhjPxgACmo0zXyhGNuaMM185uBCEgVKMnEHGGBiMk1gWPbl7Mfcrbw7e/V9545+Yc0bd/4M5Z9S9Mfedtx9YG7rlNmyCLAvhUyhkQPrNhvO5AJFnrZIR0plaLL5liQYdDi5TubaIokFDkmoFEB8CzxZVxemssDqthPhUblPgW1iQU5g6XwNwyVI7bUFRm035iNziMkgWvEso2SXnsJfveR0Y4SlVF8YWC1pVQhJiQa8JwDvlMNIxAfq3F7GDObHU1LlhzlZaWwNp6BvACxAgInGXlllMGZCpEnZHrGA6GM2718xuFcz7YdUQxzEEfjdWz4GlkcwaonT0pgA6mB25grPILtnSMhuCpsGhmMU6uJbixJs4lbKHqh+wos1jW2rchyGRCIvN9MXu+KAmMSfAlIKVvi/tybhCPJZCu2Ow9pLdyo427+X2ovMBmKNu8PA0zgl3fS0PB1DWWkVYB47bkyiJHhkFPzTzCjzn4Dq1mqoIWzCmcDGsHQmQAQdEHsixK1IXESd5rLU7THVJNV8obHS8sZeN0G5Jdt5pQTVKCCbgK1hItTS8o92iEZpuWJ/oC2r/0+zTmhvFXoaMVKRe27altDtid6OvG1hENVwBnC61KKugNoemOiPCCNb3GoHAZOFuDxxPsD+07nbSPcr/o1Zmc4jARhotrA5F5ZcjP9rPk90vR8A+k028A+8+5wKlHVID542sMzMCuXktkRzUCpE+xCBZywjNcJITx0II9x5948CekBl4XaC5OCX2nCyObdwN3HwQh5DWL/BBEkhDYHn/vpXNgZkVTZs8rj+HO8JFC6qvDVhgAEQSYCDyC86rMhG1WPzAVB9ZldDWG6EzDcFiqJBDvFS8mXDv3SK2LPoguVB2kwUx7UL5KqZWiEzocsbvSjNnaYDNtcYJuA5cDcsrvHd6yCxGjqvl9+wh3Qh8Kc9py8sNW8ncU8qwxdPj1qIGfrPqlXeoS4/JLa/LwRLTCtxuSoZUT+2Su6kXW3QNacYQbId6NUKVbROpviybFSPQQL9lhB2MamEnFyB9Y+hrG1+xBg+L0QG2TZdTdlcsBdq9oHdt9Bu5/IM9+Nfh1AwrSqlboTA6Bgq568A7UfbaMrZjoQZhQphofvNw93+bN+5X7FYKBgLmRid+tSdV6c02A4R0cHwKobmoMt5+6WI9XNISFIywpf6RMd5/a91vE78FzVHIFmxud4woyJx76OMTCa4yhgN3iJO2VfRPFMv9sYTxFzU+1eWeYS52pwOoSJldZY6koib4P1O427rbeUrNZfu44hWjz5ZSuu/vKPpimoXbLkfxWSPetvxDWG5jQSaZCxA3ad+p6rlttDhK+YwwK1LHVe0drDtorc5vnQ1247g58vewDtU7L3DRwrG4dhCUDRKKOtYr2dXHtpt+33d1WZmfkAHdl7Q8ENF+CNgB+nOw29n5F7SeNo/ckbu4laLTCdqJLHjmhJbKzmrCEX7zULrhefuHmu0V/1nbP1pnb6FaT7sOxn4pvWkfrYhYtCeJ4Xv+kOXrroIs1eHWXN1/AfzaY94ms5vaAAABg2lDQ1BJQ0MgcHJvZmlsZQAAeJx9kT1Iw0AcxV/TSkUqDnYQUchQnSyIijhqFYpQIdQKrTqYXPoFTRqSFBdHwbXg4Mdi1cHFWVcHV0EQ/ABxcnRSdJES/5cUWsR4cNyPd/ced+8AoVFhmhUaBzTdNtPJhJjNrYrhV4QwjAgGIMrMMuYkKQXf8XWPAF/v4jzL/9yfo1fNWwwIiMSzzDBt4g3i6U3b4LxPHGUlWSU+Jx4z6YLEj1xXPH7jXHRZ4JlRM5OeJ44Si8UOVjqYlUyNeIo4pmo65QtZj1XOW5y1So217slfGMnrK8tcpzmEJBaxBAkiFNRQRgU24rTqpFhI037Cxz/o+iVyKeQqg5FjAVVokF0/+B/87tYqTE54SZEE0PXiOB8jQHgXaNYd5/vYcZonQPAZuNLb/moDmPkkvd7WYkdA3zZwcd3WlD3gcgcYeDJkU3alIE2hUADez+ibckD/LdCz5vXW2sfpA5ChrlI3wMEhMFqk7HWfd3d39vbvmVZ/P2aecqIM1FFZAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AQdDBkQmV+argAABM5JREFUWMOtl9trHFUcxz9n9jYzm7Tb9JIWGtqUllLwVgRBQWl90S6lTaGmF6E2/4H+A4r+A0offdlWodL4kEZw9bG+iC9iKqLF0os0EBq02dtcdmdnfj7szGZ2M5vulv5g4JwzZ873+7ufUfMLi0RSa1TZNzVFrW511xBhzMxx79EyOwrbGSSzZ073zOcXFnlv5lTi3mvfzAPwwYVZ0tHiq6+/xu+/LlGtWYgEINL9oG657N41yfSRgxw9cHjDgfMLi8QVsR0X23E3gMXnkXQJ3L9zB99vI4EA0sVXqsPF93xW7y73ACVJBJwE1j8HUBIi3Sz/QNtrIzHN+yWdSdNue915IMKWXI4TJ050Adp+U+2bmkrV6tZeYAXwEJExMyf3Hi0rM5fvAvS4wPdBKRW6vZeEUiq0RIBCddddpymu0+rRbPvEzkPVmmWLBA1EdGAbYNctt7V712QwfeSgd/uXJQnPVVoEEAQBTxXpuEMELNtNNFW1WrsrQdBCRImQEeE/wBUh53v+7tW7y5n1+BZRIoJSioXvy3itdgclURSZTBrP87AdV57G1TT0d4GPgC+Bw8Ca7bifATsTgzBvjlH1qgNdICJM7tjB8soKw4jtuD+Gw3c229e1wF+P/uHPpT86rhBBRHActwAcAl4EjgIvAYcFJnlOoq5dv6EBU8AR4OUQ6AVgGjATwuC5YUdZ4A+z+1mBTUM/AKwqpZSIpPfu2VP7+/6DYEMMPE9N83lzq23ZWwxDd4GaQnmgUloqperSCpKC8HGCXz8G7NANU8CWUKPzsUDbyLPVyjYC39e0VMZx3Ccoha4b4lQqbUlnsBqNWCXpEMgKfA38DNSBcdPQr4zlMtTtFiqlulmQmJv9ks2idUZGZMjZmZMAfBUvxWHR0y5dmPV2FcbPG9ncFdPQS3nTuAJQLBZpBS1qjSqFwjipdGr9SWlsHTewm9ZmnngMKAaV9nBd+/bmdxSLRc6dnemm3+yZ06pcLvPGW2+yfWIn1ZpFEAQEvt95goCV1TXMXH4zAt4woaRF7RTAVylAUS6Xpdpsdjvk2VMnsSyHhuVEZTh+xgywBhwLfZIdKRfj7dWqPGFubq7T428ukslkaHttLNsZ9P3nwIfh+DhwS4EO9DA0zByBCE2n1fPxpQuznSCaX1js9nFp2pjbtqGhobQ0jUY9CbgALERah3IM+El1rNqTaqaph5W1uYGAFrfA5YvnyE9MoFBYtjMI/BXgQR/4pqVDZL3V9/cYrX+x7SnsXh/H5TLwW2iBQbVLNgn65CDsrSPOIJOXwmdQ4fRHrZilUqmXwNXrNzbbfxv4ArgFVBLeJ95oDEMHwHHcvvUcRqEwuBf0SSUEB9gfxsAgAkO1kcj/WvwKPaR8EhvPAUvRtdIMtR1FtBH37w8DEeChaehXw/xfAnzHcVOjEkhHrIe0Qlz7T8PuWLEd9+2w9KphgUUgQJ7JAgAPDT13NTrJyOYqIilrlEwQv/NPMTSByxfPIU37eCqtq2zWmPYDjbavaLYVdn2NuffPjqRJK2hRLBaHzoK+X7L1QE+nIFeYoFQqkTVMaTn2UOe1LWtwEJqGzqgRnS9M4Fb+3XBJGfSrFzW9dBw0icioJBzHzUXdMJM18APwWo6Kmy1O6X+V8UHDotBqogAAAABJRU5ErkJggg==");\n}\n'},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),o=t(187),l=t(418),s=i.__importStar(t(397)),r=function(){function t(t,e){var n=this;void 0===e&&(e={}),this.items=t,this.options=e,this.el=o.div(),this._open=!1,this._item_click=function(t){var e;null===(e=n.items[t])||void 0===e||e.handler(),n.hide()},this._on_mousedown=function(t){var e,i,o=t.target;o instanceof Node&&n.el.contains(o)||(null===(i=(e=n.options).prevent_hide)||void 0===i?void 0:i.call(e,t))||n.hide()},this._on_keydown=function(t){t.keyCode==o.Keys.Esc&&n.hide()},this._on_blur=function(){n.hide()},o.undisplay(this.el)}return Object.defineProperty(t.prototype,"is_open",{get:function(){return this._open},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"can_open",{get:function(){return 0!=this.items.length},enumerable:!0,configurable:!0}),t.prototype.remove=function(){o.remove(this.el),this._unlisten()},t.prototype._listen=function(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)},t.prototype._unlisten=function(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)},t.prototype._position=function(t){var e=this.el.parentElement;if(null!=e){var n=e.getBoundingClientRect();this.el.style.left=null!=t.left?t.left-n.left+"px":"",this.el.style.top=null!=t.top?t.top-n.top+"px":"",this.el.style.right=null!=t.right?n.right-t.right+"px":"",this.el.style.bottom=null!=t.bottom?n.bottom-t.bottom+"px":""}},t.prototype.render=function(){var t,e,n,r,u=this;o.empty(this.el,!0);var h=null!==(n=this.options.orientation)&&void 0!==n?n:"vertical";o.classes(this.el).add("bk-context-menu","bk-"+h);var d=function(t,e){var n=void 0;if(null==t)n=o.div({class:s.bk_divider});else{if(null!=t.if&&!t.if())return"continue";var i=null!=t.icon?o.div({class:["bk-menu-icon",t.icon]}):null;n=o.div({class:(null===(r=t.active)||void 0===r?void 0:r.call(t))?"bk-active":null,title:t.tooltip},i,t.label)}n.addEventListener("click",(function(){return u._item_click(e)})),c.el.appendChild(n)},c=this;try{for(var p=i.__values(l.enumerate(this.items)),a=p.next();!a.done;a=p.next()){var _=i.__read(a.value,2);d(_[0],_[1])}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=p.return)&&e.call(p)}finally{if(t)throw t.error}}},t.prototype.show=function(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),o.display(this.el),this._listen(),this._open=!0}},t.prototype.hide=function(){this._open&&(this._open=!1,this._unlisten(),o.undisplay(this.el))},t.prototype.toggle=function(t){this._open?this.hide():this.show(t)},t}();n.ContextMenu=r,r.__name__="ContextMenu"},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(1),a=e(124);function l(e,r){var n,l,u,s,c,o,i,f,_,v,h,y,d;return t.__generator(this,(function(b){switch(b.label){case 0:return n=e.length,r>n?[2]:[4,(l=a.range(r)).map((function(r){return e[r]}))];case 1:b.sent(),b.label=2;case 2:0,u=void 0;try{for(v=void 0,s=t.__values(a.reversed(a.range(r))),c=s.next();!c.done;c=s.next())if(o=c.value,l[o]!=o+n-r){u=o;break}}catch(e){v={error:e}}finally{try{c&&!c.done&&(h=s.return)&&h.call(s)}finally{if(v)throw v.error}}if(null==u)return[2];l[u]+=1;try{for(y=void 0,i=t.__values(a.range(u+1,r)),f=i.next();!f.done;f=i.next())_=f.value,l[_]=l[_-1]+1}catch(e){y={error:e}}finally{try{f&&!f.done&&(d=i.return)&&d.call(i)}finally{if(y)throw y.error}}return[4,l.map((function(r){return e[r]}))];case 3:return b.sent(),[3,2];case 4:return[2]}}))}n.enumerate=function(e){var r,n,a,l,u,s;return t.__generator(this,(function(c){switch(c.label){case 0:r=0,c.label=1;case 1:c.trys.push([1,6,7,8]),n=t.__values(e),a=n.next(),c.label=2;case 2:return a.done?[3,5]:[4,[a.value,r++]];case 3:c.sent(),c.label=4;case 4:return a=n.next(),[3,2];case 5:return[3,8];case 6:return l=c.sent(),u={error:l},[3,8];case 7:try{a&&!a.done&&(s=n.return)&&s.call(n)}finally{if(u)throw u.error}return[7];case 8:return[2]}}))},n.combinations=l,n.subsets=function(e){var r,n,u,s,c,o;return t.__generator(this,(function(i){switch(i.label){case 0:i.trys.push([0,5,6,7]),r=t.__values(a.range(e.length+1)),n=r.next(),i.label=1;case 1:return n.done?[3,4]:(u=n.value,[5,t.__values(l(e,u))]);case 2:i.sent(),i.label=3;case 3:return n=r.next(),[3,1];case 4:return[3,7];case 5:return s=i.sent(),c={error:s},[3,7];case 6:try{n&&!n.done&&(o=r.return)&&o.call(r)}finally{if(c)throw c.error}return[7];case 7:return[2]}}))}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=t(411),l=t(288),r=t(187),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),r.classes(this.el).toggle(l.bk_active,this.model.active)},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e}(i.ButtonToolButtonView);n.OnOffButtonView=c,c.__name__="OnOffButtonView"},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),l=t(134),n=t(187),r=t(230),a=i.__importStar(t(133)),s=t(193),u=t(124),c=t(128),_=t(123),h=t(196),v=t(421),p=t(422),f=t(423),d=t(410),b=t(414),y=t(425),g=t(288),m=i.__importDefault(t(415)),w=i.__importDefault(t(426)),x=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_ToolbarViewModel=function(){this.define({_visible:[a.Any,null],autohide:[a.Boolean,!1]})},Object.defineProperty(e.prototype,"visible",{get:function(){return!this.autohide||null!=this._visible&&this._visible},enumerable:!0,configurable:!0}),e}(h.Model);o.ToolbarViewModel=x,x.__name__="ToolbarViewModel",x.init_ToolbarViewModel();var T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._tool_button_views=new Map,this._toolbar_view_model=new x({autohide:this.model.autohide})},e.prototype.lazy_initialize=function(){return i.__awaiter(this,void 0,void 0,(function(){return i.__generator(this,(function(t){switch(t.label){case 0:return[4,this._build_tool_button_views()];case 1:return t.sent(),[2]}}))}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,(function(){return i.__awaiter(e,void 0,void 0,(function(){return i.__generator(this,(function(t){switch(t.label){case 0:return[4,this._build_tool_button_views()];case 1:return t.sent(),this.render(),[2]}}))}))})),this.connect(this.model.properties.autohide.change,(function(){e._toolbar_view_model.autohide=e.model.autohide,e._on_visible_change()})),this.connect(this._toolbar_view_model.properties._visible.change,(function(){return e._on_visible_change()}))},e.prototype.styles=function(){return i.__spread(t.prototype.styles.call(this),[m.default,w.default])},e.prototype.remove=function(){r.remove_views(this._tool_button_views),t.prototype.remove.call(this)},e.prototype._build_tool_button_views=function(){return i.__awaiter(this,void 0,void 0,(function(){var t;return i.__generator(this,(function(e){switch(e.label){case 0:return t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools,[4,r.build_views(this._tool_button_views,t,{parent:this},(function(t){return t.button_view}))];case 1:return e.sent(),[2]}}))}))},e.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},e.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible,e=b.bk_toolbar_hidden;this.el.classList.contains(e)&&t?this.el.classList.remove(e):t||this.el.classList.add(e)},e.prototype.render=function(){var t,e,o,l,r,a,s=this;if(n.empty(this.el),this.el.classList.add(b.bk_toolbar),this.el.classList.add(g.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){var u="grey"===this.model.logo?y.bk_grey:null,_=n.a({href:"https://bokeh.org/",target:"_blank",class:[y.bk_logo,y.bk_logo_small,u]});this.el.appendChild(_)}try{for(var h=i.__values(this._tool_button_views),v=h.next();!v.done;v=h.next()){i.__read(v.value,2)[1].render()}}catch(e){t={error:e}}finally{try{v&&!v.done&&(e=h.return)&&e.call(h)}finally{if(t)throw t.error}}var p=[],f=function(t){return s._tool_button_views.get(t).el},d=this.model.gestures;try{for(var m=i.__values(c.values(d)),w=m.next();!w.done;w=m.next()){var x=w.value;p.push(x.tools.map(f))}}catch(t){o={error:t}}finally{try{w&&!w.done&&(l=m.return)&&l.call(m)}finally{if(o)throw o.error}}p.push(this.model.actions.map(f)),p.push(this.model.inspectors.filter((function(t){return t.toggleable})).map(f));try{for(var T=i.__values(p),k=T.next();!k.done;k=T.next()){var M=k.value;if(0!==M.length){var B=n.div({class:b.bk_button_bar},M);this.el.appendChild(B)}}}catch(t){r={error:t}}finally{try{k&&!k.done&&(a=T.return)&&a.call(T)}finally{if(r)throw r.error}}},e.prototype.update_layout=function(){},e.prototype.update_position=function(){},e.prototype.after_layout=function(){this._has_finished=!0},e}(s.DOMView);function k(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}o.ToolbarBaseView=T,T.__name__="ToolbarBaseView";var M=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_ToolbarBase=function(){this.prototype.default_view=T,this.define({tools:[a.Array,[]],logo:[a.Logo,"normal"],autohide:[a.Boolean,!1]}),this.internal({gestures:[a.Any,k],actions:[a.Array,[]],inspectors:[a.Array,[]],help:[a.Array,[]],toolbar_location:[a.Location,"right"]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools()},e.prototype._init_tools=function(){var t,e,o,n,r,a,s=this,c=function(t,e){if(t.length!=e.length)return!0;var o=new Set(e.map((function(t){return t.id})));return u.some(t,(function(t){return!o.has(t.id)}))},h=this.tools.filter((function(t){return t instanceof d.InspectTool}));c(this.inspectors,h)&&(this.inspectors=h);var b=this.tools.filter((function(t){return t instanceof f.HelpTool}));c(this.help,b)&&(this.help=b);var y=this.tools.filter((function(t){return t instanceof p.ActionTool}));c(this.actions,y)&&(this.actions=y);var g=function(t,e){t in s.gestures||l.logger.warn("Toolbar: unknown event type '"+t+"' for tool: "+e)},m={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};try{for(var w=i.__values(this.tools),x=w.next();!x.done;x=w.next()){var T=x.value;if(T instanceof v.GestureTool&&T.event_type)if(_.isString(T.event_type))m[T.event_type].tools.push(T),g(T.event_type,T);else{m.multi.tools.push(T);try{for(var k=(o=void 0,i.__values(T.event_type)),M=k.next();!M.done;M=k.next()){g(M.value,T)}}catch(t){o={error:t}}finally{try{M&&!M.done&&(n=k.return)&&n.call(k)}finally{if(o)throw o.error}}}}}catch(e){t={error:e}}finally{try{x&&!x.done&&(e=w.return)&&e.call(w)}finally{if(t)throw t.error}}var B=function(t){var e=z.gestures[t];c(e.tools,m[t].tools)&&(e.tools=m[t].tools),e.active&&u.every(e.tools,(function(t){return t.id!=e.active.id}))&&(e.active=null)},z=this;try{for(var A=i.__values(Object.keys(m)),L=A.next();!L.done;L=A.next()){B(L.value)}}catch(t){r={error:t}}finally{try{L&&!L.done&&(a=A.return)&&a.call(A)}finally{if(r)throw r.error}}},Object.defineProperty(e.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!0,configurable:!0}),e.prototype._active_change=function(t){var e,o,n=t.event_type;if(null!=n){var r=_.isString(n)?[n]:n;try{for(var a=i.__values(r),s=a.next();!s.done;s=a.next()){var u=s.value;if(t.active){var c=this.gestures[u].active;null!=c&&t!=c&&(l.logger.debug("Toolbar: deactivating tool: "+c+" for event type '"+u+"'"),c.active=!1),this.gestures[u].active=t,l.logger.debug("Toolbar: activating tool: "+t+" for event type '"+u+"'")}else this.gestures[u].active=null}}catch(t){e={error:t}}finally{try{s&&!s.done&&(o=a.return)&&o.call(a)}finally{if(e)throw e.error}}}},e}(h.Model);o.ToolbarBase=M,M.__name__="ToolbarBase",M.init_ToolbarBase()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(1),u=e(411),r=e(419),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t}(u.ButtonToolView);n.GestureToolView=_,_.__name__="GestureToolView";var i=function(e){function t(t){var n=e.call(this,t)||this;return n.button_view=r.OnOffButtonView,n}return o.__extends(t,e),t}(u.ButtonTool);n.GestureTool=i,i.__name__="GestureTool"},
function _(t,o,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),e=t(411),u=t(130),c=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype._clicked=function(){this.model.do.emit(void 0)},o}(e.ButtonToolButtonView);n.ActionToolButtonView=c,c.__name__="ActionToolButtonView";var l=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype.connect_signals=function(){var o=this;t.prototype.connect_signals.call(this),this.connect(this.model.do,(function(t){return o.doit(t)}))},o}(e.ButtonToolView);n.ActionToolView=l,l.__name__="ActionToolView";var _=function(t){function o(o){var n=t.call(this,o)||this;return n.button_view=c,n.do=new u.Signal(n,"do"),n}return i.__extends(o,t),o}(e.ButtonTool);n.ActionTool=_,_.__name__="ActionTool"},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),n=t(422),l=i.__importStar(t(133)),r=t(424),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){window.open(this.model.redirect)},e}(n.ActionToolView);o.HelpToolView=p,p.__name__="HelpToolView";var _=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Help",o.icon=r.bk_tool_icon_help,o}return i.__extends(e,t),e.init_HelpTool=function(){this.prototype.default_view=p,this.define({help_tooltip:[l.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[l.String,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}),this.register_alias("help",(function(){return new e}))},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.help_tooltip},enumerable:!0,configurable:!0}),e}(n.ActionTool);o.HelpTool=_,_.__name__="HelpTool",_.init_HelpTool()},
function _(o,_,l){Object.defineProperty(l,"__esModule",{value:!0}),l.bk_tool_icon_box_select="bk-tool-icon-box-select",l.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",l.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",l.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",l.bk_tool_icon_help="bk-tool-icon-help",l.bk_tool_icon_hover="bk-tool-icon-hover",l.bk_tool_icon_crosshair="bk-tool-icon-crosshair",l.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",l.bk_tool_icon_pan="bk-tool-icon-pan",l.bk_tool_icon_xpan="bk-tool-icon-xpan",l.bk_tool_icon_ypan="bk-tool-icon-ypan",l.bk_tool_icon_range="bk-tool-icon-range",l.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",l.bk_tool_icon_redo="bk-tool-icon-redo",l.bk_tool_icon_reset="bk-tool-icon-reset",l.bk_tool_icon_save="bk-tool-icon-save",l.bk_tool_icon_tap_select="bk-tool-icon-tap-select",l.bk_tool_icon_undo="bk-tool-icon-undo",l.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",l.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",l.bk_tool_icon_box_edit="bk-tool-icon-box-edit",l.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",l.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",l.bk_tool_icon_point_draw="bk-tool-icon-point-draw",l.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit",l.bk_tool_icon_line_edit="bk-tool-icon-line-edit"},
function _(o,l,b){Object.defineProperty(b,"__esModule",{value:!0}),b.bk_logo="bk-logo",b.bk_logo_notebook="bk-logo-notebook",b.bk_logo_small="bk-logo-small",b.bk_grey="bk-grey"},
function _(l,n,o){Object.defineProperty(o,"__esModule",{value:!0});o.default="\n.bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),n=this&&this.__rest||function(t,e){var r={};for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&e.indexOf(i)<0&&(r[i]=t[i]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(i=Object.getOwnPropertySymbols(t);n<i.length;n++)e.indexOf(i[n])<0&&Object.prototype.propertyIsEnumerable.call(t,i[n])&&(r[i[n]]=t[i[n]])}return r},a=t(323),o=t(192),s=t(325),l=t(205),_=t(387),h=t(284),u=t(292),d=t(285),c=t(428),p=t(130),v=t(230),f=t(429),y=t(189),b=t(134),g=t(431),w=t(123),m=t(124),x=t(330),O=t(432),z=t(433),M=t(331),k=t(194),j=function(t){function e(){var e=t.apply(this,i.__spread(arguments))||this;return e._outer_bbox=new k.BBox,e._inner_bbox=new k.BBox,e._needs_paint=!0,e._needs_layout=!1,e._invalidated_painters=new Set,e._invalidate_all=!0,e}return i.__extends(e,t),Object.defineProperty(e.prototype,"is_paused",{get:function(){return null!=this._is_paused&&0!==this._is_paused},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype.pause=function(){null==this._is_paused?this._is_paused=1:this._is_paused+=1},e.prototype.unpause=function(t){if(void 0===t&&(t=!1),null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()},e.prototype.request_render=function(){this.request_paint()},e.prototype.request_paint=function(t){if(null!=t?this._invalidated_painters.add(t):this._invalidate_all=!0,!this.is_paused){var e=this.throttled_paint();this._ready=this._ready.then((function(){return e}))}},e.prototype.request_layout=function(){this._needs_layout=!0,this.request_paint()},e.prototype.reset=function(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new c.Reset)},e.prototype.remove=function(){this.ui_event_bus.destroy(),v.remove_views(this.renderer_views),v.remove_views(this.tool_views),this.canvas_view.remove(),t.prototype.remove.call(this)},e.prototype.render=function(){t.prototype.render.call(this),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()},e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this.state_changed=new p.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new y.Visuals(this.model),this._initial_state_info={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1};var r=this.model,i=r.hidpi,n=r.output_backend;this.canvas=new o.Canvas({hidpi:i,output_backend:n}),this.frame=new a.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this.throttled_paint=g.throttle((function(){return e.repaint()}),1e3/60);var s=this.model,l=s.title_location,_=s.title;null!=l&&null!=_&&(this._title=_ instanceof h.Title?_:new h.Title({text:_}));var u=this.model,c=u.toolbar_location,v=u.toolbar;null!=c&&null!=v&&(this._toolbar=new d.ToolbarPanel({toolbar:v}),v.toolbar_location=c),this.renderer_views=new Map,this.tool_views=new Map},e.prototype.lazy_initialize=function(){return i.__awaiter(this,void 0,void 0,(function(){var t;return i.__generator(this,(function(e){switch(e.label){case 0:return t=this,[4,v.build_view(this.canvas,{parent:this})];case 1:return t.canvas_view=e.sent(),this.ui_event_bus=new f.UIEvents(this,this.model.toolbar,this.canvas_view.events_el),[4,this.build_renderer_views()];case 2:return e.sent(),[4,this.build_tool_views()];case 3:return e.sent(),this.update_dataranges(),this.unpause(!0),b.logger.debug("PlotView initialized"),[2]}}))}))},e.prototype._width_policy=function(){return null==this.model.frame_width?t.prototype._width_policy.call(this):"min"},e.prototype._height_policy=function(){return null==this.model.frame_height?t.prototype._height_policy.call(this):"min"},e.prototype._update_layout=function(){var t=this;this.layout=new O.BorderLayout,this.layout.set_sizing(this.box_sizing());var e=this.model,r=e.frame_width,n=e.frame_height;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(Object.assign(Object.assign({},null!=r?{width_policy:"fixed",width:r}:{width_policy:"fit"}),null!=n?{height_policy:"fixed",height:n}:{height_policy:"fit"}));var a=m.copy(this.model.above),o=m.copy(this.model.below),s=m.copy(this.model.left),l=m.copy(this.model.right),_=function(t){switch(t){case"above":return a;case"below":return o;case"left":return s;case"right":return l}},u=this.model,c=u.title_location,p=u.title;null!=c&&null!=p&&_(c).push(this._title);var v=this.model,f=v.toolbar_location,y=v.toolbar;if(null!=f&&null!=y){var b=_(f),g=!0;if(this.model.toolbar_sticky)for(var k=0;k<b.length;k++){var j=b[k];if(j instanceof h.Title){b[k]="above"==f||"below"==f?[j,this._toolbar]:[this._toolbar,j],g=!1;break}}g&&b.push(this._toolbar)}var P=function(e,r){var i=t.renderer_views.get(r);return i.layout=new z.SidePanel(e,i)},R=function(t,e){var r,n,a="above"==t||"below"==t,o=[];try{for(var s=i.__values(e),l=s.next();!l.done;l=s.next()){var _=l.value;if(w.isArray(_)){var h=_.map((function(e){var r,i=P(t,e);if(e instanceof d.ToolbarPanel){var n=a?"width_policy":"height_policy";i.set_sizing(Object.assign(Object.assign({},i.sizing),((r={})[n]="min",r)))}return i})),u=void 0;a?(u=new M.Row(h)).set_sizing({width_policy:"max",height_policy:"min"}):(u=new M.Column(h)).set_sizing({width_policy:"min",height_policy:"max"}),u.absolute=!0,o.push(u)}else o.push(P(t,_))}}catch(t){r={error:t}}finally{try{l&&!l.done&&(n=s.return)&&n.call(s)}finally{if(r)throw r.error}}return o},q=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:q,top:null!=this.model.min_border_top?this.model.min_border_top:q,right:null!=this.model.min_border_right?this.model.min_border_right:q,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:q};var V=new x.VStack,S=new x.VStack,D=new x.HStack,T=new x.HStack;V.children=m.reversed(R("above",a)),S.children=R("below",o),D.children=m.reversed(R("left",s)),T.children=R("right",l),V.set_sizing({width_policy:"fit",height_policy:"min"}),S.set_sizing({width_policy:"fit",height_policy:"min"}),D.set_sizing({width_policy:"min",height_policy:"fit"}),T.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=V,this.layout.bottom_panel=S,this.layout.left_panel=D,this.layout.right_panel=T},Object.defineProperty(e.prototype,"axis_views",{get:function(){var t,e,r=[];try{for(var n=i.__values(this.renderer_views),a=n.next();!a.done;a=n.next()){var o=i.__read(a.value,2)[1];o instanceof u.AxisView&&r.push(o)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=n.return)&&e.call(n)}finally{if(t)throw t.error}}return r},enumerable:!0,configurable:!0}),e.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.canvas_view.el.style.cursor=t},e.prototype.set_toolbar_visibility=function(t){var e,r;try{for(var n=i.__values(this.visibility_callbacks),a=n.next();!a.done;a=n.next()){(0,a.value)(t)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}},e.prototype.update_dataranges=function(){var t,e,r,n,a,o,_,h,u,d,c,p,v,f,y=new Map,g=new Map,w=!1;try{for(var m=i.__values(this.frame.x_ranges),x=m.next();!x.done;x=m.next()){(U=i.__read(x.value,2)[1])instanceof s.DataRange1d&&"log"==U.scale_hint&&(w=!0)}}catch(e){t={error:e}}finally{try{x&&!x.done&&(e=m.return)&&e.call(m)}finally{if(t)throw t.error}}try{for(var O=i.__values(this.frame.y_ranges),z=O.next();!z.done;z=O.next()){(Q=i.__read(z.value,2)[1])instanceof s.DataRange1d&&"log"==Q.scale_hint&&(w=!0)}}catch(t){r={error:t}}finally{try{z&&!z.done&&(n=O.return)&&n.call(O)}finally{if(r)throw r.error}}try{for(var M=i.__values(this.renderer_views),k=M.next();!k.done;k=M.next()){var j=i.__read(k.value,2),P=j[0],R=j[1];if(R instanceof l.GlyphRendererView){var q=R.glyph.bounds();if(null!=q&&y.set(P,q),w){var V=R.glyph.log_bounds();null!=V&&g.set(P,V)}}}}catch(t){a={error:t}}finally{try{k&&!k.done&&(o=M.return)&&o.call(M)}finally{if(a)throw a.error}}var S,D=!1,T=!1,B=this.frame.bbox,C=B.width,G=B.height;!1!==this.model.match_aspect&&0!=C&&0!=G&&(S=1/this.model.aspect_scale*(C/G));try{for(var N=i.__values(this.frame.x_ranges),E=N.next();!E.done;E=N.next()){if((U=i.__read(E.value,2)[1])instanceof s.DataRange1d){var I="log"==U.scale_hint?g:y;U.update(I,0,this.model,S),U.follow&&(D=!0)}null!=U.bounds&&(T=!0)}}catch(t){_={error:t}}finally{try{E&&!E.done&&(h=N.return)&&h.call(N)}finally{if(_)throw _.error}}try{for(var L=i.__values(this.frame.y_ranges),A=L.next();!A.done;A=L.next()){if((Q=i.__read(A.value,2)[1])instanceof s.DataRange1d){I="log"==Q.scale_hint?g:y;Q.update(I,1,this.model,S),Q.follow&&(D=!0)}null!=Q.bounds&&(T=!0)}}catch(t){u={error:t}}finally{try{A&&!A.done&&(d=L.return)&&d.call(L)}finally{if(u)throw u.error}}if(D&&T){b.logger.warn("Follow enabled so bounds are unset.");try{for(var F=i.__values(this.frame.x_ranges),H=F.next();!H.done;H=F.next()){var U;(U=i.__read(H.value,2)[1]).bounds=null}}catch(t){c={error:t}}finally{try{H&&!H.done&&(p=F.return)&&p.call(F)}finally{if(c)throw c.error}}try{for(var J=i.__values(this.frame.y_ranges),K=J.next();!K.done;K=J.next()){var Q;(Q=i.__read(K.value,2)[1]).bounds=null}}catch(t){v={error:t}}finally{try{K&&!K.done&&(f=J.return)&&f.call(J)}finally{if(v)throw v.error}}}this.range_update_timestamp=Date.now()},e.prototype.push_state=function(t,e){var r=this.state,i=r.history,n=r.index,a=null!=i[n]?i[n].info:{},o=Object.assign(Object.assign(Object.assign({},this._initial_state_info),a),e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:o}),this.state.index=this.state.history.length-1,this.state_changed.emit()},e.prototype.clear_state=function(){this.state={history:[],index:-1},this.state_changed.emit()},e.prototype.can_undo=function(){return this.state.index>=0},e.prototype.can_redo=function(){return this.state.index<this.state.history.length-1},e.prototype.undo=function(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())},e.prototype.redo=function(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())},e.prototype._do_state_change=function(t){var e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)},e.prototype.get_selection=function(){var t,e,r=new Map;try{for(var n=i.__values(this.model.renderers),a=n.next();!a.done;a=n.next()){var o=a.value;if(o instanceof l.GlyphRenderer){var s=o.data_source.selected;r.set(o,s)}}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=n.return)&&e.call(n)}finally{if(t)throw t.error}}return r},e.prototype.update_selection=function(t){var e,r;try{for(var n=i.__values(this.model.renderers),a=n.next();!a.done;a=n.next()){var o=a.value;if(o instanceof l.GlyphRenderer){var s=o.data_source;if(null!=t){var _=t.get(o);null!=_&&s.selected.update(_,!0)}else s.selection_manager.clear()}}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}},e.prototype.reset_selection=function(){this.update_selection(null)},e.prototype._update_ranges_together=function(t){var e,r,n,a,o=1;try{for(var s=i.__values(t),l=s.next();!l.done;l=s.next()){var _=i.__read(l.value,2),h=_[0],u=_[1];o=Math.min(o,this._get_weight_to_constrain_interval(h,u))}}catch(t){e={error:t}}finally{try{l&&!l.done&&(r=s.return)&&r.call(s)}finally{if(e)throw e.error}}if(o<1)try{for(var d=i.__values(t),c=d.next();!c.done;c=d.next()){var p=i.__read(c.value,2);h=p[0];(u=p[1]).start=o*u.start+(1-o)*h.start,u.end=o*u.end+(1-o)*h.end}}catch(t){n={error:t}}finally{try{c&&!c.done&&(a=d.return)&&a.call(d)}finally{if(n)throw n.error}}},e.prototype._update_ranges_individually=function(t,e,r,n){var a,o,s,l,_=!1;try{for(var h=i.__values(t),u=h.next();!u.done;u=h.next()){var d=i.__read(u.value,2),c=d[0],p=d[1];if(!r){var v=this._get_weight_to_constrain_interval(c,p);v<1&&(p.start=v*p.start+(1-v)*c.start,p.end=v*p.end+(1-v)*c.end)}if(null!=c.bounds&&"auto"!=c.bounds){var f=i.__read(c.bounds,2),y=f[0],b=f[1],g=Math.abs(p.end-p.start);c.is_reversed?(null!=y&&y>=p.end&&(_=!0,p.end=y,(e||r)&&(p.start=y+g)),null!=b&&b<=p.start&&(_=!0,p.start=b,(e||r)&&(p.end=b-g))):(null!=y&&y>=p.start&&(_=!0,p.start=y,(e||r)&&(p.end=y+g)),null!=b&&b<=p.end&&(_=!0,p.end=b,(e||r)&&(p.start=b-g)))}}}catch(t){a={error:t}}finally{try{u&&!u.done&&(o=h.return)&&o.call(h)}finally{if(a)throw a.error}}if(!(r&&_&&n))try{for(var w=i.__values(t),m=w.next();!m.done;m=w.next()){var x=i.__read(m.value,2);c=x[0],p=x[1];c.have_updated_interactively=!0,c.start==p.start&&c.end==p.end||c.setv(p)}}catch(t){s={error:t}}finally{try{m&&!m.done&&(l=w.return)&&l.call(w)}finally{if(s)throw s.error}}},e.prototype._get_weight_to_constrain_interval=function(t,e){var r=t.min_interval,n=t.max_interval;if(null!=t.bounds&&"auto"!=t.bounds){var a=i.__read(t.bounds,2),o=a[0],s=a[1];if(null!=o&&null!=s){var l=Math.abs(s-o);n=null!=n?Math.min(n,l):l}}var _=1;if(null!=r||null!=n){var h=Math.abs(t.end-t.start),u=Math.abs(e.end-e.start);r>0&&u<r&&(_=(h-r)/(h-u)),n>0&&u>n&&(_=(n-h)/(u-h)),_=Math.max(0,Math.min(1,_))}return _},e.prototype.update_range=function(t,e,r,n){var a,o,s,l,_,h,u,d;void 0===e&&(e=!1),void 0===r&&(r=!1),void 0===n&&(n=!0),this.pause();var c=this.frame,p=c.x_ranges,v=c.y_ranges;if(null==t){try{for(var f=i.__values(p),y=f.next();!y.done;y=f.next()){(M=i.__read(y.value,2)[1]).reset()}}catch(t){a={error:t}}finally{try{y&&!y.done&&(o=f.return)&&o.call(f)}finally{if(a)throw a.error}}try{for(var b=i.__values(v),g=b.next();!g.done;g=b.next()){(M=i.__read(g.value,2)[1]).reset()}}catch(t){s={error:t}}finally{try{g&&!g.done&&(l=b.return)&&l.call(b)}finally{if(s)throw s.error}}this.update_dataranges()}else{var w=[];try{for(var m=i.__values(p),x=m.next();!x.done;x=m.next()){var O=i.__read(x.value,2),z=O[0],M=O[1];w.push([M,t.xrs.get(z)])}}catch(t){_={error:t}}finally{try{x&&!x.done&&(h=m.return)&&h.call(m)}finally{if(_)throw _.error}}try{for(var k=i.__values(v),j=k.next();!j.done;j=k.next()){var P=i.__read(j.value,2);z=P[0],M=P[1];w.push([M,t.yrs.get(z)])}}catch(t){u={error:t}}finally{try{j&&!j.done&&(d=k.return)&&d.call(k)}finally{if(u)throw u.error}}r&&this._update_ranges_together(w),this._update_ranges_individually(w,e,r,n)}this.unpause()},e.prototype.reset_range=function(){this.update_range(null)},e.prototype._invalidate_layout=function(){var t=this;(function(){var e,r;try{for(var n=i.__values(t.model.side_panels),a=n.next();!a.done;a=n.next()){var o=a.value;if(t.renderer_views.get(o).layout.has_size_changed())return!0}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return!1})()&&this.root.compute_layout()},e.prototype.get_renderer_views=function(){var t=this;return this.computed_renderers.map((function(e){return t.renderer_views.get(e)}))},e.prototype.build_renderer_views=function(){return i.__awaiter(this,void 0,void 0,(function(){var t,e,r,n,a,o,s,l,_,h,u,d,c,p;return i.__generator(this,(function(f){switch(f.label){case 0:this.computed_renderers=[],t=this.model,e=t.above,r=t.below,n=t.left,a=t.right,o=t.center,s=t.renderers,(u=this.computed_renderers).push.apply(u,i.__spread(e,r,n,a,o,s)),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar);try{for(l=i.__values(this.model.toolbar.tools),_=l.next();!_.done;_=l.next())null!=(h=_.value).overlay&&this.computed_renderers.push(h.overlay),(p=this.computed_renderers).push.apply(p,i.__spread(h.synthetic_renderers))}catch(t){d={error:t}}finally{try{_&&!_.done&&(c=l.return)&&c.call(l)}finally{if(d)throw d.error}}return[4,v.build_views(this.renderer_views,this.computed_renderers,{parent:this})];case 1:return f.sent(),[2]}}))}))},e.prototype.build_tool_views=function(){return i.__awaiter(this,void 0,void 0,(function(){var t,e=this;return i.__generator(this,(function(r){switch(r.label){case 0:return t=this.model.toolbar.tools,[4,v.build_views(this.tool_views,t,{parent:this})];case 1:return r.sent().map((function(t){return e.ui_event_bus.register_tool(t)})),[2]}}))}))},e.prototype.connect_signals=function(){var e,r,n,a,o=this;t.prototype.connect_signals.call(this);var s=this.frame,l=s.x_ranges,_=s.y_ranges;try{for(var h=i.__values(l),u=h.next();!u.done;u=h.next()){var d=i.__read(u.value,2)[1];this.connect(d.change,(function(){o._needs_layout=!0,o.request_paint()}))}}catch(t){e={error:t}}finally{try{u&&!u.done&&(r=h.return)&&r.call(h)}finally{if(e)throw e.error}}try{for(var c=i.__values(_),p=c.next();!p.done;p=c.next()){d=i.__read(p.value,2)[1];this.connect(d.change,(function(){o._needs_layout=!0,o.request_paint()}))}}catch(t){n={error:t}}finally{try{p&&!p.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}var v=this.model.properties,f=v.plot_width,y=v.plot_height;this.on_change([f,y],(function(){return o.invalidate_layout()}));var b=this.model.properties,g=b.above,w=b.below,m=b.left,x=b.right,O=b.center,z=b.renderers;this.on_change([g,w,m,x,O,z],(function(){return i.__awaiter(o,void 0,void 0,(function(){return i.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_renderer_views()];case 1:return[2,t.sent()]}}))}))})),this.connect(this.model.toolbar.properties.tools.change,(function(){return i.__awaiter(o,void 0,void 0,(function(){return i.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_renderer_views()];case 1:return t.sent(),[4,this.build_tool_views()];case 2:return t.sent(),[2]}}))}))})),this.connect(this.model.change,(function(){return o.request_paint()})),this.connect(this.model.reset,(function(){return o.reset()}))},e.prototype.set_initial_range=function(){var t,e,r,n,a=!0,o=this.frame,s=o.x_ranges,l=o.y_ranges,_=new Map,h=new Map;try{for(var u=i.__values(s),d=u.next();!d.done;d=u.next()){var c=i.__read(d.value,2),p=c[0],v=(w=c[1]).start,f=w.end;if(null==v||null==f||isNaN(v+f)){a=!1;break}_.set(p,{start:v,end:f})}}catch(e){t={error:e}}finally{try{d&&!d.done&&(e=u.return)&&e.call(u)}finally{if(t)throw t.error}}if(a)try{for(var y=i.__values(l),g=y.next();!g.done;g=y.next()){var w,m=i.__read(g.value,2);p=m[0],v=(w=m[1]).start,f=w.end;if(null==v||null==f||isNaN(v+f)){a=!1;break}h.set(p,{start:v,end:f})}}catch(t){r={error:t}}finally{try{g&&!g.done&&(n=y.return)&&n.call(y)}finally{if(r)throw r.error}}a?(this._initial_state_info.range={xrs:_,yrs:h},b.logger.debug("initial ranges set")):b.logger.warn("could not set initial ranges")},e.prototype.has_finished=function(){var e,r;if(!t.prototype.has_finished.call(this))return!1;if(this.model.visible)try{for(var n=i.__values(this.renderer_views),a=n.next();!a.done;a=n.next()){if(!i.__read(a.value,2)[1].has_finished())return!1}}catch(t){e={error:t}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return!0},e.prototype.after_layout=function(){if(t.prototype.after_layout.call(this),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.layout.bbox.width),outer_height:Math.round(this.layout.bbox.height)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){var e=this.layout.bbox,r=e.width,i=e.height;this.canvas_view.resize(r,i),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&this.paint()},e.prototype.repaint=function(){this._needs_layout&&this._invalidate_layout(),this.paint()},e.prototype.paint=function(){var t,e,r,n,a=this;if(!this.is_paused&&this.model.visible){b.logger.trace("PlotView.paint() for "+this.model.id);var o=this.model.document;if(null!=o){var s=o.interactive_duration();s>=0&&s<this.model.lod_interval?setTimeout((function(){o.interactive_duration()>a.model.lod_timeout&&o.interactive_stop(),a.request_paint()}),this.model.lod_timeout):o.interactive_stop()}try{for(var _=i.__values(this.renderer_views),h=_.next();!h.done;h=_.next()){var u=i.__read(h.value,2)[1];if(null==this.range_update_timestamp||u instanceof l.GlyphRendererView&&u.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}}}catch(e){t={error:e}}finally{try{h&&!h.done&&(e=_.return)&&e.call(_)}finally{if(t)throw t.error}}var d=!1,c=!1;if(this._invalidate_all)d=!0,c=!0;else try{for(var p=i.__values(this._invalidated_painters),v=p.next();!v.done;v=p.next()){if("overlay"!=v.value.model.level?d=!0:c=!0,d&&c)break}}catch(t){r={error:t}}finally{try{v&&!v.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}this._invalidated_painters.clear(),this._invalidate_all=!1;var f=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],y=this.canvas_view,g=y.primary,w=y.overlays;d&&(g.prepare(),this.canvas_view.prepare_webgl(f),this.canvas_view.clear_webgl(),this._map_hook(g.ctx,f),this._paint_empty(g.ctx,f),this._paint_outline(g.ctx,f),this._paint_levels(g.ctx,"image",f,!0),this._paint_levels(g.ctx,"underlay",f,!0),this._paint_levels(g.ctx,"glyph",f,!0),this._paint_levels(g.ctx,"guide",f,!1),this._paint_levels(g.ctx,"annotation",f,!1),g.finish()),c&&(w.prepare(),this._paint_levels(w.ctx,"overlay",f,!1),w.finish()),null==this._initial_state_info.range&&this.set_initial_range(),this._needs_paint=!1}},e.prototype._paint_levels=function(t,e,r,n){var a,o;try{for(var s=i.__values(this.computed_renderers),l=s.next();!l.done;l=s.next()){var _=l.value;if(_.level==e){var h=this.renderer_views.get(_);t.save(),(n||h.needs_clip)&&(t.beginPath(),t.rect.apply(t,i.__spread(r)),t.clip()),h.render(),t.restore(),h.has_webgl&&h.needs_webgl_blit&&(this.canvas_view.blit_webgl(t),this.canvas_view.clear_webgl())}}}catch(t){a={error:t}}finally{try{l&&!l.done&&(o=s.return)&&o.call(s)}finally{if(a)throw a.error}}},e.prototype._map_hook=function(t,e){},e.prototype._paint_empty=function(t,e){var r=i.__read([0,0,this.layout.bbox.width,this.layout.bbox.height],4),n=r[0],a=r[1],o=r[2],s=r[3],l=i.__read(e,4),_=l[0],h=l[1],u=l[2],d=l[3];this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(n,a,o,s),t.clearRect(_,h,u,d)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(_,h,u,d))},e.prototype._paint_outline=function(t,e){if(this.visuals.outline_line.doit){t.save(),this.visuals.outline_line.set_value(t);var r=i.__read(e,4),n=r[0],a=r[1],o=r[2],s=r[3];n+o==this.layout.bbox.width&&(o-=1),a+s==this.layout.bbox.height&&(s-=1),t.strokeRect(n,a,o,s),t.restore()}},e.prototype.to_blob=function(){return this.canvas_view.to_blob()},e.prototype.export=function(t,e){void 0===e&&(e=!0);var r="png"==t?"canvas":"svg",i=new o.CanvasLayer(r,e),n=this.layout.bbox,a=n.width,s=n.height;i.resize(a,s);var l=this.canvas_view.compose().canvas;return i.ctx.drawImage(l,0,0),i},e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this),r=e.children,a=n(e,["children"]),o=this.get_renderer_views().map((function(t){return t.serializable_state()})).filter((function(t){return"bbox"in t}));return Object.assign(Object.assign({},a),{children:i.__spread(r,o)})},e}(_.LayoutDOMView);r.PlotView=j,j.__name__="PlotView"},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),o=this&&this.__decorate||function(t,n,e,r){var o,_=arguments.length,s=_<3?n:null===r?r=Object.getOwnPropertyDescriptor(n,e):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(t,n,e,r);else for(var i=t.length-1;i>=0;i--)(o=t[i])&&(s=(_<3?o(s):_>3?o(n,e,s):o(n,e))||s);return _>3&&s&&Object.defineProperty(n,e,s),s};function _(t){return function(n){n.prototype.event_name=t}}var s=function(){function t(){}return t.prototype.to_json=function(){return{event_name:this.event_name,event_values:this._to_json()}},t}();e.BokehEvent=s,s.__name__="BokehEvent";var i=function(t){function n(){var n=t.apply(this,r.__spread(arguments))||this;return n.origin=null,n}return r.__extends(n,t),n.prototype._to_json=function(){return{model:this.origin}},n}(s);e.ModelEvent=i,i.__name__="ModelEvent";var a=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n.prototype._to_json=function(){return{}},n}(s);e.DocumentReady=a,a.__name__="DocumentReady",e.DocumentReady=a=o([_("document_ready")],a);var u=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(i);e.ButtonClick=u,u.__name__="ButtonClick",e.ButtonClick=u=o([_("button_click")],u);var c=function(t){function n(n){var e=t.call(this)||this;return e.item=n,e}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.item;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{item:n})},n}(i);e.MenuItemClick=c,c.__name__="MenuItemClick",e.MenuItemClick=c=o([_("menu_item_click")],c);var l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(i);e.UIEvent=l,l.__name__="UIEvent";var p=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(l);e.LODStart=p,p.__name__="LODStart",e.LODStart=p=o([_("lodstart")],p);var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(l);e.LODEnd=h,h.__name__="LODEnd",e.LODEnd=h=o([_("lodend")],h);var f=function(t){function n(n,e){var r=t.call(this)||this;return r.geometry=n,r.final=e,r}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.geometry,e=this.final;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{geometry:n,final:e})},n}(l);e.SelectionGeometry=f,f.__name__="SelectionGeometry",e.SelectionGeometry=f=o([_("selectiongeometry")],f);var y=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(l);e.Reset=y,y.__name__="Reset",e.Reset=y=o([_("reset")],y);var d=function(t){function n(n,e,r,o){var _=t.call(this)||this;return _.sx=n,_.sy=e,_.x=r,_.y=o,_}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.sx,e=this.sy,r=this.x,o=this.y;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{sx:n,sy:e,x:r,y:o})},n}(l);e.PointEvent=d,d.__name__="PointEvent";var v=function(t){function n(n,e,r,o,_,s){var i=t.call(this,n,e,r,o)||this;return i.sx=n,i.sy=e,i.x=r,i.y=o,i.delta_x=_,i.delta_y=s,i}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.delta_x,e=this.delta_y;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{delta_x:n,delta_y:e})},n}(d);e.Pan=v,v.__name__="Pan",e.Pan=v=o([_("pan")],v);var m=function(t){function n(n,e,r,o,_){var s=t.call(this,n,e,r,o)||this;return s.sx=n,s.sy=e,s.x=r,s.y=o,s.scale=_,s}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.scale;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{scale:n})},n}(d);e.Pinch=m,m.__name__="Pinch",e.Pinch=m=o([_("pinch")],m);var x=function(t){function n(n,e,r,o,_){var s=t.call(this,n,e,r,o)||this;return s.sx=n,s.sy=e,s.x=r,s.y=o,s.rotation=_,s}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.rotation;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{rotation:n})},n}(d);e.Rotate=x,x.__name__="Rotate",e.Rotate=x=o([_("rotate")],x);var j=function(t){function n(n,e,r,o,_){var s=t.call(this,n,e,r,o)||this;return s.sx=n,s.sy=e,s.x=r,s.y=o,s.delta=_,s}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.delta;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{delta:n})},n}(d);e.MouseWheel=j,j.__name__="MouseWheel",e.MouseWheel=j=o([_("wheel")],j);var P=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.MouseMove=P,P.__name__="MouseMove",e.MouseMove=P=o([_("mousemove")],P);var O=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.MouseEnter=O,O.__name__="MouseEnter",e.MouseEnter=O=o([_("mouseenter")],O);var b=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.MouseLeave=b,b.__name__="MouseLeave",e.MouseLeave=b=o([_("mouseleave")],b);var g=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.Tap=g,g.__name__="Tap",e.Tap=g=o([_("tap")],g);var E=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.DoubleTap=E,E.__name__="DoubleTap",e.DoubleTap=E=o([_("doubletap")],E);var M=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.Press=M,M.__name__="Press",e.Press=M=o([_("press")],M);var R=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.PressUp=R,R.__name__="PressUp",e.PressUp=R=o([_("pressup")],R);var S=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.PanStart=S,S.__name__="PanStart",e.PanStart=S=o([_("panstart")],S);var D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.PanEnd=D,D.__name__="PanEnd",e.PanEnd=D=o([_("panend")],D);var k=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.PinchStart=k,k.__name__="PinchStart",e.PinchStart=k=o([_("pinchstart")],k);var L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.PinchEnd=L,L.__name__="PinchEnd",e.PinchEnd=L=o([_("pinchend")],L);var C=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.RotateStart=C,C.__name__="RotateStart",e.RotateStart=C=o([_("rotatestart")],C);var T=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(d);e.RotateEnd=T,T.__name__="RotateEnd",e.RotateEnd=T=o([_("rotateend")],T)},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),i=r.__importDefault(t(412)),s=t(130),o=t(134),a=t(187),_=r.__importStar(t(428)),h=t(430),c=t(124),p=t(123),u=t(147),l=t(417);var v=function(){function t(t,e,n){var r=this;this.plot_view=t,this.toolbar=e,this.hit_area=n,this.pan_start=new s.Signal(this,"pan:start"),this.pan=new s.Signal(this,"pan"),this.pan_end=new s.Signal(this,"pan:end"),this.pinch_start=new s.Signal(this,"pinch:start"),this.pinch=new s.Signal(this,"pinch"),this.pinch_end=new s.Signal(this,"pinch:end"),this.rotate_start=new s.Signal(this,"rotate:start"),this.rotate=new s.Signal(this,"rotate"),this.rotate_end=new s.Signal(this,"rotate:end"),this.tap=new s.Signal(this,"tap"),this.doubletap=new s.Signal(this,"doubletap"),this.press=new s.Signal(this,"press"),this.pressup=new s.Signal(this,"pressup"),this.move_enter=new s.Signal(this,"move:enter"),this.move=new s.Signal(this,"move"),this.move_exit=new s.Signal(this,"move:exit"),this.scroll=new s.Signal(this,"scroll"),this.keydown=new s.Signal(this,"keydown"),this.keyup=new s.Signal(this,"keyup"),this.hammer=new i.default(this.hit_area,{touchAction:"auto",inputClass:i.default.TouchMouseInput}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(function(t){return r._mouse_move(t)})),this.hit_area.addEventListener("mouseenter",(function(t){return r._mouse_enter(t)})),this.hit_area.addEventListener("mouseleave",(function(t){return r._mouse_exit(t)})),this.hit_area.addEventListener("contextmenu",(function(t){return r._context_menu(t)})),this.hit_area.addEventListener("wheel",(function(t){return r._mouse_wheel(t)})),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new l.ContextMenu([],{prevent_hide:function(t){return 2==t.button&&t.target==r.hit_area}}),this.hit_area.appendChild(this.menu.el)}return t.prototype.destroy=function(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var t=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(function(e){return t._doubletap(e)})),this.hammer.on("tap",(function(e){return t._tap(e)})),this.hammer.on("press",(function(e){return t._press(e)})),this.hammer.on("pressup",(function(e){return t._pressup(e)})),this.hammer.get("pan").set({direction:i.default.DIRECTION_ALL}),this.hammer.on("panstart",(function(e){return t._pan_start(e)})),this.hammer.on("pan",(function(e){return t._pan(e)})),this.hammer.on("panend",(function(e){return t._pan_end(e)})),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(function(e){return t._pinch_start(e)})),this.hammer.on("pinch",(function(e){return t._pinch(e)})),this.hammer.on("pinchend",(function(e){return t._pinch_end(e)})),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(function(e){return t._rotate_start(e)})),this.hammer.on("rotate",(function(e){return t._rotate(e)})),this.hammer.on("rotateend",(function(e){return t._rotate_end(e)}))},t.prototype.register_tool=function(t){var e=this,n=t.model.event_type;null!=n&&(p.isString(n)?this._register_tool(t,n):n.forEach((function(n,r){return e._register_tool(t,n,r<1)})))},t.prototype._register_tool=function(t,e,n){void 0===n&&(n=!0);var r=t,i=r.model.id,s=function(t){return function(e){e.id==i&&t(e.e)}},a=function(t){return function(e){t(e.e)}};switch(e){case"pan":null!=r._pan_start&&r.connect(this.pan_start,s(r._pan_start.bind(r))),null!=r._pan&&r.connect(this.pan,s(r._pan.bind(r))),null!=r._pan_end&&r.connect(this.pan_end,s(r._pan_end.bind(r)));break;case"pinch":null!=r._pinch_start&&r.connect(this.pinch_start,s(r._pinch_start.bind(r))),null!=r._pinch&&r.connect(this.pinch,s(r._pinch.bind(r))),null!=r._pinch_end&&r.connect(this.pinch_end,s(r._pinch_end.bind(r)));break;case"rotate":null!=r._rotate_start&&r.connect(this.rotate_start,s(r._rotate_start.bind(r))),null!=r._rotate&&r.connect(this.rotate,s(r._rotate.bind(r))),null!=r._rotate_end&&r.connect(this.rotate_end,s(r._rotate_end.bind(r)));break;case"move":null!=r._move_enter&&r.connect(this.move_enter,s(r._move_enter.bind(r))),null!=r._move&&r.connect(this.move,s(r._move.bind(r))),null!=r._move_exit&&r.connect(this.move_exit,s(r._move_exit.bind(r)));break;case"tap":null!=r._tap&&r.connect(this.tap,s(r._tap.bind(r)));break;case"press":null!=r._press&&r.connect(this.press,s(r._press.bind(r))),null!=r._pressup&&r.connect(this.pressup,s(r._pressup.bind(r)));break;case"scroll":null!=r._scroll&&r.connect(this.scroll,s(r._scroll.bind(r)));break;default:throw new Error("unsupported event_type: "+e)}n&&(null!=r._doubletap&&r.connect(this.doubletap,a(r._doubletap.bind(r))),null!=r._keydown&&r.connect(this.keydown,a(r._keydown.bind(r))),null!=r._keyup&&r.connect(this.keyup,a(r._keyup.bind(r))),u.is_mobile&&null!=r._scroll&&"pinch"==e&&(o.logger.debug("Registering scroll on touch screen"),r.connect(this.scroll,s(r._scroll.bind(r)))))},t.prototype._hit_test_renderers=function(t,e){var n,i,s=this.plot_view.get_renderer_views();try{for(var o=r.__values(c.reversed(s)),a=o.next();!a.done;a=o.next()){var _=a.value,h=_.model.level;if(("annotation"==h||"overlay"==h)&&null!=_.interactive_hit&&_.interactive_hit(t,e))return _}}catch(t){n={error:t}}finally{try{a&&!a.done&&(i=o.return)&&i.call(o)}finally{if(n)throw n.error}}return null},t.prototype._hit_test_frame=function(t,e){return this.plot_view.frame.bbox.contains(t,e)},t.prototype._hit_test_canvas=function(t,e){return this.plot_view.layout.bbox.contains(t,e)},t.prototype._trigger=function(t,e,n){var r=this,i=this.toolbar.gestures,s=t.name.split(":")[0],o=this._hit_test_renderers(e.sx,e.sy),a=this._hit_test_canvas(e.sx,e.sy);switch(s){case"move":null!=(l=i[s].active)&&this.trigger(t,e,l.id);var _=this.toolbar.inspectors.filter((function(t){return t.active})),h="default";null!=o?(h=o.cursor(e.sx,e.sy)||h,c.is_empty(_)||(t=this.move_exit)):this._hit_test_frame(e.sx,e.sy)&&(c.is_empty(_)||(h="crosshair")),this.plot_view.set_cursor(h),this.plot_view.set_toolbar_visibility(a),_.map((function(n){return r.trigger(t,e,n.id)}));break;case"tap":var p=n.target;if(null!=p&&p!=this.hit_area)return;null!=o&&null!=o.on_hit&&o.on_hit(e.sx,e.sy),null!=(l=i[s].active)&&this.trigger(t,e,l.id);break;case"scroll":null!=(l=i[u.is_mobile?"pinch":"scroll"].active)&&(n.preventDefault(),n.stopPropagation(),this.trigger(t,e,l.id));break;case"pan":null!=(l=i[s].active)&&(n.preventDefault(),this.trigger(t,e,l.id));break;default:var l;null!=(l=i[s].active)&&this.trigger(t,e,l.id)}this._trigger_bokeh_event(e)},t.prototype.trigger=function(t,e,n){void 0===n&&(n=null),t.emit({id:n,e:e})},t.prototype._trigger_bokeh_event=function(t){var e=this,n=function(){var n=t.sx,r=t.sy,i=e.plot_view.frame.x_scale.invert(n),s=e.plot_view.frame.y_scale.invert(r);switch(t.type){case"wheel":return new _.MouseWheel(n,r,i,s,t.delta);case"mousemove":return new _.MouseMove(n,r,i,s);case"mouseenter":return new _.MouseEnter(n,r,i,s);case"mouseleave":return new _.MouseLeave(n,r,i,s);case"tap":return new _.Tap(n,r,i,s);case"doubletap":return new _.DoubleTap(n,r,i,s);case"press":return new _.Press(n,r,i,s);case"pressup":return new _.PressUp(n,r,i,s);case"pan":return new _.Pan(n,r,i,s,t.deltaX,t.deltaY);case"panstart":return new _.PanStart(n,r,i,s);case"panend":return new _.PanEnd(n,r,i,s);case"pinch":return new _.Pinch(n,r,i,s,t.scale);case"pinchstart":return new _.PinchStart(n,r,i,s);case"pinchend":return new _.PinchEnd(n,r,i,s);case"rotate":return new _.Rotate(n,r,i,s,t.rotation);case"rotatestart":return new _.RotateStart(n,r,i,s);case"rotateend":return new _.RotateEnd(n,r,i,s);default:return}}();null!=n&&this.plot_view.model.trigger_event(n)},t.prototype._get_sxy=function(t){var e=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,n=e.pageX,r=e.pageY,i=a.offset(this.hit_area);return{sx:n-i.left,sy:r-i.top}},t.prototype._pan_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._pinch_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._rotate_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._tap_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._move_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._scroll_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:h.getDeltaY(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){var e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._pressup=function(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._context_menu=function(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();var e=this._get_sxy(t),n=e.sx,r=e.sy;this.menu.toggle({left:n,top:r})},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t}();n.UIEvents=v,v.__name__="UIEvents"},
function _(e,t,n){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function r(e){var t=getComputedStyle(e).fontSize;return null!=t?parseInt(t,10):null}Object.defineProperty(n,"__esModule",{value:!0}),n.getDeltaY=function(e){var t,n=-e.deltaY;if(e.target instanceof HTMLElement)switch(e.deltaMode){case e.DOM_DELTA_LINE:n*=r((t=e.target).offsetParent||document.body)||r(t)||16;break;case e.DOM_DELTA_PAGE:n*=function(e){return e.clientHeight}(e.target)}return n}},
function _(n,e,o){Object.defineProperty(o,"__esModule",{value:!0});var t=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(n){return n(Date.now()),-1};o.throttle=function(n,e){var o=null,i=0,u=!1;return function(){return new Promise((function(d,r){var w=function(){i=Date.now(),o=null,u=!1;try{n(),d()}catch(n){r(n)}},a=Date.now(),f=e-(a-i);f<=0&&!u?(null!=o&&clearTimeout(o),u=!0,t(w)):o||u?d():o=setTimeout((function(){return t(w)}),f)}))}}},
function _(t,e,h){Object.defineProperty(h,"__esModule",{value:!0});var i=t(1),o=t(328),r=t(329),n=t(194),a=function(t){function e(){var e=t.apply(this,i.__spread(arguments))||this;return e.min_border={left:0,top:0,right:0,bottom:0},e}return i.__extends(e,t),e.prototype._measure=function(t){var e=this;t=new o.Sizeable(t).bounded_to(this.sizing.size);var h,i,r,n=this.left_panel.measure({width:0,height:t.height}),a=Math.max(n.width,this.min_border.left),s=this.right_panel.measure({width:0,height:t.height}),_=Math.max(s.width,this.min_border.right),g=this.top_panel.measure({width:t.width,height:0}),m=Math.max(g.height,this.min_border.top),p=this.bottom_panel.measure({width:t.width,height:0}),l=Math.max(p.height,this.min_border.bottom),d=new o.Sizeable(t).shrink_by({left:a,right:_,top:m,bottom:l}),w=this.center_panel.measure(d);return{width:a+w.width+_,height:m+w.height+l,inner:{left:a,right:_,top:m,bottom:l},align:(h=e.center_panel.sizing,i=h.width_policy,r=h.height_policy,"fixed"!=i&&"fixed"!=r)}},e.prototype._set_geometry=function(e,h){t.prototype._set_geometry.call(this,e,h),this.center_panel.set_geometry(h);var i=this.left_panel.measure({width:0,height:e.height}),o=this.right_panel.measure({width:0,height:e.height}),r=this.top_panel.measure({width:e.width,height:0}),a=this.bottom_panel.measure({width:e.width,height:0}),s=h.left,_=h.top,g=h.right,m=h.bottom;this.top_panel.set_geometry(new n.BBox({left:s,right:g,bottom:_,height:r.height})),this.bottom_panel.set_geometry(new n.BBox({left:s,right:g,top:m,height:a.height})),this.left_panel.set_geometry(new n.BBox({top:_,bottom:m,right:s,width:i.width})),this.right_panel.set_geometry(new n.BBox({top:_,bottom:m,left:g,width:o.width}))},e}(r.Layoutable);h.BorderLayout=a,a.__name__="BorderLayout"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var l=e(1),r=e(328),a=e(329),o=e(123),n=Math.PI/2,h="left",s="center",d={above:{parallel:0,normal:-n,horizontal:0,vertical:-n},below:{parallel:0,normal:n,horizontal:0,vertical:n},left:{parallel:-n,normal:0,horizontal:0,vertical:-n},right:{parallel:n,normal:0,horizontal:0,vertical:n}},c={above:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"alphabetic",vertical:"middle"},below:{justified:"bottom",parallel:"hanging",normal:"middle",horizontal:"hanging",vertical:"middle"},left:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"},right:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"}},p={above:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},below:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},left:{justified:s,parallel:s,normal:"right",horizontal:"right",vertical:s},right:{justified:s,parallel:s,normal:h,horizontal:h,vertical:s}},_={above:"right",below:h,left:"right",right:h},b={above:h,below:"right",left:"right",right:h},m=function(e){function t(t,i){var l=e.call(this)||this;switch(l.side=t,l.obj=i,l.side){case"above":l._dim=0,l._normals=[0,-1];break;case"below":l._dim=0,l._normals=[0,1];break;case"left":l._dim=1,l._normals=[-1,0];break;case"right":l._dim=1,l._normals=[1,0]}return l.is_horizontal?l.set_sizing({width_policy:"max",height_policy:"fixed"}):l.set_sizing({width_policy:"fixed",height_policy:"max"}),l}return l.__extends(t,e),t.prototype._content_size=function(){return new r.Sizeable(this.get_oriented_size())},t.prototype.get_oriented_size=function(){var e=this.obj.get_size(),t=e.width,i=e.height;return!this.obj.rotate||this.is_horizontal?{width:t,height:i}:{width:i,height:t}},t.prototype.has_size_changed=function(){var e=this.get_oriented_size(),t=e.width,i=e.height;return this.is_horizontal?this.bbox.height!=i:this.bbox.width!=t},Object.defineProperty(t.prototype,"dimension",{get:function(){return this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"normals",{get:function(){return this._normals},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_horizontal",{get:function(){return 0==this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_vertical",{get:function(){return 1==this._dim},enumerable:!0,configurable:!0}),t.prototype.apply_label_text_heuristics=function(e,t){var i,l,r=this.side;o.isString(t)?(i=c[r][t],l=p[r][t]):t<0?(i="middle",l=_[r]):(i="middle",l=b[r]),e.textBaseline=i,e.textAlign=l},t.prototype.get_label_angle_heuristic=function(e){return d[this.side][e]},t}(a.ContentLayoutable);i.SidePanel=m,m.__name__="SidePanel"},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),n=t(130),s=t(187),a=t(152),p=t(427),l=new n.Signal0({},"gmaps_ready"),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this._tiles_loaded=!1,this.zoom_count=0;var o=this.model.map_options,i=o.zoom,n=o.lat,s=o.lng;if(this.initial_zoom=i,this.initial_lat=n,this.initial_lng=s,"undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback)!function(t){window._bokeh_gmaps_callback=function(){return l.emit()};var e=document.createElement("script");e.type="text/javascript",e.src="https://maps.googleapis.com/maps/api/js?v=3.36&key="+t+"&callback=_bokeh_gmaps_callback",document.body.appendChild(e)}(atob(this.model.api_key));l.connect((function(){return e.request_render()}))}this.unpause()},e.prototype.remove=function(){s.remove(this.map_el),t.prototype.remove.call(this)},e.prototype.update_range=function(e){if(null==e)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),t.prototype.update_range.call(this,null);else if(null!=e.sdx||null!=e.sdy)this.map.panBy(e.sdx||0,e.sdy||0),t.prototype.update_range.call(this,e);else if(null!=e.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),t.prototype.update_range.call(this,e);var o=e.factor<0?-1:1,n=this.map.getZoom(),s=n+o;if(s>=2){this.map.setZoom(s);var a=i.__read(this._get_projected_bounds(),3),p=a[0];a[1]-p<0&&this.map.setZoom(n)}this.unpause()}this._set_bokeh_ranges()},e.prototype._build_map=function(){var t=this,e=google.maps;this.map_types={satellite:e.MapTypeId.SATELLITE,terrain:e.MapTypeId.TERRAIN,roadmap:e.MapTypeId.ROADMAP,hybrid:e.MapTypeId.HYBRID};var o=this.model.map_options,i={center:new e.LatLng(o.lat,o.lng),zoom:o.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[o.map_type],scaleControl:o.scale_control,tilt:o.tilt};null!=o.styles&&(i.styles=JSON.parse(o.styles)),this.map_el=s.div({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new e.Map(this.map_el,i),e.event.addListener(this.map,"idle",(function(){return t._set_bokeh_ranges()})),e.event.addListener(this.map,"bounds_changed",(function(){return t._set_bokeh_ranges()})),e.event.addListenerOnce(this.map,"tilesloaded",(function(){return t._render_finished()})),this.connect(this.model.properties.map_options.change,(function(){return t._update_options()})),this.connect(this.model.map_options.properties.styles.change,(function(){return t._update_styles()})),this.connect(this.model.map_options.properties.lat.change,(function(){return t._update_center("lat")})),this.connect(this.model.map_options.properties.lng.change,(function(){return t._update_center("lng")})),this.connect(this.model.map_options.properties.zoom.change,(function(){return t._update_zoom()})),this.connect(this.model.map_options.properties.map_type.change,(function(){return t._update_map_type()})),this.connect(this.model.map_options.properties.scale_control.change,(function(){return t._update_scale_control()})),this.connect(this.model.map_options.properties.tilt.change,(function(){return t._update_tilt()}))},e.prototype._render_finished=function(){this._tiles_loaded=!0,this.notify_finished()},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&!0===this._tiles_loaded},e.prototype._get_latlon_bounds=function(){var t=this.map.getBounds(),e=t.getNorthEast(),o=t.getSouthWest();return[o.lng(),e.lng(),o.lat(),e.lat()]},e.prototype._get_projected_bounds=function(){var t=i.__read(this._get_latlon_bounds(),4),e=t[0],o=t[1],n=t[2],s=t[3],p=i.__read(a.wgs84_mercator.compute(e,n),2),l=p[0],_=p[1],r=i.__read(a.wgs84_mercator.compute(o,s),2);return[l,r[0],_,r[1]]},e.prototype._set_bokeh_ranges=function(){var t=i.__read(this._get_projected_bounds(),4),e=t[0],o=t[1],n=t[2],s=t[3];this.frame.x_range.setv({start:e,end:o}),this.frame.y_range.setv({start:n,end:s})},e.prototype._update_center=function(t){var e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()},e.prototype._update_map_type=function(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})},e.prototype._update_scale_control=function(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})},e.prototype._update_tilt=function(){this.map.setOptions({tilt:this.model.map_options.tilt})},e.prototype._update_options=function(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()},e.prototype._update_styles=function(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})},e.prototype._update_zoom=function(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()},e.prototype._map_hook=function(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){var o=i.__read(e,4),n=o[0],s=o[1],a=o[2],p=o[3];this.map_el.style.top=s+"px",this.map_el.style.left=n+"px",this.map_el.style.width=a+"px",this.map_el.style.height=p+"px"}},e.prototype._paint_empty=function(t,e){var o=this.layout.bbox.width,n=this.layout.bbox.height,s=i.__read(e,4),a=s[0],p=s[1],l=s[2],_=s[3];t.clearRect(0,0,o,n),t.beginPath(),t.moveTo(0,0),t.lineTo(0,n),t.lineTo(o,n),t.lineTo(o,0),t.lineTo(0,0),t.moveTo(a,p),t.lineTo(a+l,p),t.lineTo(a+l,p+_),t.lineTo(a,p+_),t.lineTo(a,p),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())},e}(p.PlotView);o.GMapPlotView=_,_.__name__="GMapPlotView"},
function _(a,e,n){Object.defineProperty(n,"__esModule",{value:!0});var g=a(326);n.DataRange=g.DataRange;var R=a(325);n.DataRange1d=R.DataRange1d;var r=a(213);n.FactorRange=r.FactorRange;var t=a(214);n.Range=t.Range;var d=a(273);n.Range1d=d.Range1d},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var n=e(205);d.GlyphRenderer=n.GlyphRenderer;var R=e(231);d.GraphRenderer=R.GraphRenderer;var a=e(293);d.GuideRenderer=a.GuideRenderer;var G=e(185);d.Renderer=G.Renderer},
function _(a,e,l){Object.defineProperty(l,"__esModule",{value:!0});var c=a(324);l.CategoricalScale=c.CategoricalScale;var r=a(261);l.ContinuousScale=r.ContinuousScale;var n=a(260);l.LinearScale=n.LinearScale;var o=a(271);l.LinearInterpolationScale=o.LinearInterpolationScale;var i=a(272);l.LogScale=i.LogScale;var S=a(262);l.Scale=S.Scale},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0}),e(1).__exportStar(e(233),o);var n=e(203);o.Selection=n.Selection},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var o=a(440);r.ServerSentDataSource=o.ServerSentDataSource;var S=a(442);r.AjaxDataSource=S.AjaxDataSource;var u=a(200);r.ColumnDataSource=u.ColumnDataSource;var t=a(201);r.ColumnarDataSource=t.ColumnarDataSource;var c=a(229);r.CDSView=c.CDSView;var D=a(202);r.DataSource=D.DataSource;var v=a(443);r.GeoJSONDataSource=v.GeoJSONDataSource;var n=a(441);r.WebDataSource=n.WebDataSource},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var a=e(1),n=function(e){function t(t){var i=e.call(this,t)||this;return i.initialized=!1,i}return a.__extends(t,e),t.prototype.destroy=function(){e.prototype.destroy.call(this)},t.prototype.setup=function(){var e=this;this.initialized||(this.initialized=!0,new EventSource(this.data_url).onmessage=function(t){e.load_data(JSON.parse(t.data),e.mode,e.max_size)})},t}(e(441).WebDataSource);i.ServerSentDataSource=n,n.__name__="ServerSentDataSource"},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});var r=t(1),n=t(200),i=r.__importStar(t(133)),o=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},e.prototype.load_data=function(t,e,a){var n,i,o,l=this.adapter;switch(o=null!=l?l.execute(this,{response:t}):t,e){case"replace":this.data=o;break;case"append":var u=this.data;try{for(var c=r.__values(this.columns()),s=c.next();!s.done;s=c.next()){var d=s.value,p=Array.from(u[d]),_=Array.from(o[d]);o[d]=p.concat(_).slice(-a)}}catch(t){n={error:t}}finally{try{s&&!s.done&&(i=c.return)&&i.call(c)}finally{if(n)throw n.error}}this.data=o}},e.init_WebDataSource=function(){this.define({mode:[i.UpdateMode,"replace"],max_size:[i.Number],adapter:[i.Any,null],data_url:[i.String]})},e}(n.ColumnDataSource);a.WebDataSource=o,o.__name__="WebDataSource",o.init_WebDataSource()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),a=t(441),n=t(134),o=i.__importStar(t(133)),s=t(128),d=function(t){function e(e){var r=t.call(this,e)||this;return r.initialized=!1,r}return i.__extends(e,t),e.init_AjaxDataSource=function(){this.define({polling_interval:[o.Number],content_type:[o.String,"application/json"],http_headers:[o.Any,{}],method:[o.HTTPMethod,"POST"],if_modified:[o.Boolean,!1]})},e.prototype.destroy=function(){null!=this.interval&&clearInterval(this.interval),t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)){this.interval=setInterval((function(){return t.get_data(t.mode,t.max_size,t.if_modified)}),this.polling_interval)}},e.prototype.get_data=function(t,e,r){var i=this;void 0===e&&(e=0),void 0===r&&(r=!1);var a=this.prepare_request();a.addEventListener("load",(function(){return i.do_load(a,t,e)})),a.addEventListener("error",(function(){return i.do_error(a)})),a.send()},e.prototype.prepare_request=function(){var t,e,r=new XMLHttpRequest;r.open(this.method,this.data_url,!0),r.withCredentials=!1,r.setRequestHeader("Content-Type",this.content_type);var a=this.http_headers;try{for(var n=i.__values(s.entries(a)),o=n.next();!o.done;o=n.next()){var d=i.__read(o.value,2),l=d[0],u=d[1];r.setRequestHeader(l,u)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(e=n.return)&&e.call(n)}finally{if(t)throw t.error}}return r},e.prototype.do_load=function(t,e,r){if(200===t.status){var i=JSON.parse(t.responseText);this.load_data(i,e,r)}},e.prototype.do_error=function(t){n.logger.error("Failed to fetch JSON from "+this.data_url+" with code "+t.status)},e}(a.WebDataSource);r.AjaxDataSource=d,d.__name__="AjaxDataSource",d.init_AjaxDataSource()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var o=e(1),n=e(201),a=e(134),i=o.__importStar(e(133)),s=e(124),l=e(128);function _(e){return null!=e?e:NaN}var u=function(e){function r(r){return e.call(this,r)||this}return o.__extends(r,e),r.init_GeoJSONDataSource=function(){this.define({geojson:[i.Any]}),this.internal({data:[i.Any,{}]})},r.prototype.initialize=function(){e.prototype.initialize.call(this),this._update_data()},r.prototype.connect_signals=function(){var r=this;e.prototype.connect_signals.call(this),this.connect(this.properties.geojson.change,(function(){return r._update_data()}))},r.prototype._update_data=function(){this.data=this.geojson_to_column_data()},r.prototype._get_new_list_array=function(e){return s.range(0,e).map((function(e){return[]}))},r.prototype._get_new_nan_array=function(e){return s.range(0,e).map((function(e){return NaN}))},r.prototype._add_properties=function(e,r,t,n){var a,i,s,u=null!==(s=e.properties)&&void 0!==s?s:{};try{for(var c=o.__values(l.entries(u)),y=c.next();!y.done;y=c.next()){var h=o.__read(y.value,2),d=h[0],p=h[1];r.hasOwnProperty(d)||(r[d]=this._get_new_nan_array(n)),r[d][t]=_(p)}}catch(e){a={error:e}}finally{try{y&&!y.done&&(i=c.return)&&i.call(c)}finally{if(a)throw a.error}}},r.prototype._add_geometry=function(e,r,t){var n,i;function s(e,r){return e.concat([[NaN,NaN,NaN]]).concat(r)}switch(e.type){case"Point":var l=o.__read(e.coordinates,3),u=l[0],c=l[1],y=l[2];r.x[t]=u,r.y[t]=c,r.z[t]=_(y);break;case"LineString":for(var h=e.coordinates,d=0;d<h.length;d++){var p=o.__read(h[d],3);u=p[0],c=p[1],y=p[2];r.xs[t][d]=u,r.ys[t][d]=c,r.zs[t][d]=_(y)}break;case"Polygon":e.coordinates.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");var f=e.coordinates[0];for(d=0;d<f.length;d++){var g=o.__read(f[d],3);u=g[0],c=g[1],y=g[2];r.xs[t][d]=u,r.ys[t][d]=c,r.zs[t][d]=_(y)}break;case"MultiPoint":a.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":for(h=e.coordinates.reduce(s),d=0;d<h.length;d++){var v=o.__read(h[d],3);u=v[0],c=v[1],y=v[2];r.xs[t][d]=u,r.ys[t][d]=c,r.zs[t][d]=_(y)}break;case"MultiPolygon":var w=[];try{for(var m=o.__values(e.coordinates),x=m.next();!x.done;x=m.next()){var N=x.value;N.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),w.push(N[0])}}catch(e){n={error:e}}finally{try{x&&!x.done&&(i=m.return)&&i.call(m)}finally{if(n)throw n.error}}for(h=w.reduce(s),d=0;d<h.length;d++){var S=o.__read(h[d],3);u=S[0],c=S[1],y=S[2];r.xs[t][d]=u,r.ys[t][d]=c,r.zs[t][d]=_(y)}break;default:throw new Error("Invalid GeoJSON geometry type: "+e.type)}},r.prototype.geojson_to_column_data=function(){var e,r,t,n,a,i,s,l=JSON.parse(this.geojson);switch(l.type){case"GeometryCollection":if(null==l.geometries)throw new Error("No geometries found in GeometryCollection");if(0===l.geometries.length)throw new Error("geojson.geometries must have one or more items");s=l.geometries;break;case"FeatureCollection":if(null==l.features)throw new Error("No features found in FeaturesCollection");if(0==l.features.length)throw new Error("geojson.features must have one or more items");s=l.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}var _=0;try{for(var u=o.__values(s),c=u.next();!c.done;c=u.next()){"GeometryCollection"==(g="Feature"===(f=c.value).type?f.geometry:f).type?_+=g.geometries.length:_+=1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(r=u.return)&&r.call(u)}finally{if(e)throw e.error}}var y={x:this._get_new_nan_array(_),y:this._get_new_nan_array(_),z:this._get_new_nan_array(_),xs:this._get_new_list_array(_),ys:this._get_new_list_array(_),zs:this._get_new_list_array(_)},h=0;try{for(var d=o.__values(s),p=d.next();!p.done;p=d.next()){var f,g;if("GeometryCollection"==(g="Feature"==(f=p.value).type?f.geometry:f).type)try{for(var v=(a=void 0,o.__values(g.geometries)),w=v.next();!w.done;w=v.next()){var m=w.value;this._add_geometry(m,y,h),"Feature"===f.type&&this._add_properties(f,y,h,_),h+=1}}catch(e){a={error:e}}finally{try{w&&!w.done&&(i=v.return)&&i.call(v)}finally{if(a)throw a.error}}else this._add_geometry(g,y,h),"Feature"===f.type&&this._add_properties(f,y,h,_),h+=1}}catch(e){t={error:e}}finally{try{p&&!p.done&&(n=d.return)&&n.call(d)}finally{if(t)throw t.error}}return y},r}(n.ColumnarDataSource);t.GeoJSONDataSource=u,u.__name__="GeoJSONDataSource",u.init_GeoJSONDataSource()},
function _(e,r,i){Object.defineProperty(i,"__esModule",{value:!0});var c=e(242);i.AdaptiveTicker=c.AdaptiveTicker;var a=e(241);i.BasicTicker=a.BasicTicker;var k=e(295);i.CategoricalTicker=k.CategoricalTicker;var T=e(306);i.CompositeTicker=T.CompositeTicker;var t=e(243);i.ContinuousTicker=t.ContinuousTicker;var o=e(305);i.DatetimeTicker=o.DatetimeTicker;var v=e(307);i.DaysTicker=v.DaysTicker;var n=e(445);i.FixedTicker=n.FixedTicker;var s=e(314);i.LogTicker=s.LogTicker;var l=e(317);i.MercatorTicker=l.MercatorTicker;var u=e(310);i.MonthsTicker=u.MonthsTicker;var d=e(308);i.SingleIntervalTicker=d.SingleIntervalTicker;var g=e(244);i.Ticker=g.Ticker;var C=e(311);i.YearsTicker=C.YearsTicker},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=i(1),r=i(243),_=n.__importStar(i(133)),o=function(i){function t(t){var e=i.call(this,t)||this;return e.min_interval=0,e.max_interval=0,e}return n.__extends(t,i),t.init_FixedTicker=function(){this.define({ticks:[_.Array,[]],minor_ticks:[_.Array,[]]})},t.prototype.get_ticks_no_defaults=function(i,t,e,n){return{major:this.ticks,minor:this.minor_ticks}},t.prototype.get_interval=function(i,t,e){return 0},t}(r.ContinuousTicker);e.FixedTicker=o,o.__name__="FixedTicker",o.init_FixedTicker()},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var T=e(447);o.BBoxTileSource=T.BBoxTileSource;var c=e(448);o.MercatorTileSource=c.MercatorTileSource;var i=e(451);o.QUADKEYTileSource=i.QUADKEYTileSource;var l=e(452);o.TileRenderer=l.TileRenderer;var S=e(449);o.TileSource=S.TileSource;var u=e(456);o.TMSTileSource=u.TMSTileSource;var a=e(453);o.WMTSTileSource=a.WMTSTileSource},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),o=e(448),_=i.__importStar(e(133)),n=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_BBoxTileSource=function(){this.define({use_latlon:[_.Boolean,!1]})},t.prototype.get_image_url=function(e,t,r){var o,_,n,l,u,a,c=this.string_lookup_replace(this.url,this.extra_url_vars);return this.use_latlon?(l=(o=i.__read(this.get_tile_geographic_bounds(e,t,r),4))[0],a=o[1],n=o[2],u=o[3]):(l=(_=i.__read(this.get_tile_meter_bounds(e,t,r),4))[0],a=_[1],n=_[2],u=_[3]),c.replace("{XMIN}",l.toString()).replace("{YMIN}",a.toString()).replace("{XMAX}",n.toString()).replace("{YMAX}",u.toString())},t}(o.MercatorTileSource);r.BBoxTileSource=n,n.__name__="BBoxTileSource",n.init_BBoxTileSource()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),o=t(449),_=i.__importStar(t(133)),n=t(124),s=t(450),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_MercatorTileSource=function(){this.define({snap_to_zoom:[_.Boolean,!1],wrap_around:[_.Boolean,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this._resolutions=n.range(this.min_zoom,this.max_zoom+1).map((function(t){return e.get_resolution(t)}))},e.prototype._computed_initial_resolution=function(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size},e.prototype.is_valid_tile=function(t,e,r){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,r)))&&!(e<0||e>=Math.pow(2,r))},e.prototype.parent_by_tile_xyz=function(t,e,r){var i=this.tile_xyz_to_quadkey(t,e,r),o=i.substring(0,i.length-1);return this.quadkey_to_tile_xyz(o)},e.prototype.get_resolution=function(t){return this._computed_initial_resolution()/Math.pow(2,t)},e.prototype.get_resolution_by_extent=function(t,e,r){return[(t[2]-t[0])/r,(t[3]-t[1])/e]},e.prototype.get_level_by_extent=function(t,e,r){var o,_,n=(t[2]-t[0])/r,s=(t[3]-t[1])/e,a=Math.max(n,s),l=0;try{for(var u=i.__values(this._resolutions),p=u.next();!p.done;p=u.next()){if(a>p.value){if(0==l)return 0;if(l>0)return l-1}l+=1}}catch(t){o={error:t}}finally{try{p&&!p.done&&(_=u.return)&&_.call(u)}finally{if(o)throw o.error}}return l-1},e.prototype.get_closest_level_by_extent=function(t,e,r){var i=(t[2]-t[0])/r,o=(t[3]-t[1])/e,_=Math.max(i,o),n=this._resolutions.reduce((function(t,e){return Math.abs(e-_)<Math.abs(t-_)?e:t}));return this._resolutions.indexOf(n)},e.prototype.snap_to_zoom_level=function(t,e,r,o){var _=i.__read(t,4),n=_[0],s=_[1],a=_[2],l=_[3],u=this._resolutions[o],p=r*u,h=e*u;if(!this.snap_to_zoom){var y=(a-n)/p,c=(l-s)/h;y>c?(p=a-n,h*=y):(p*=c,h=l-s)}var f=(p-(a-n))/2,d=(h-(l-s))/2;return[n-f,s-d,a+f,l+d]},e.prototype.tms_to_wmts=function(t,e,r){return[t,Math.pow(2,r)-1-e,r]},e.prototype.wmts_to_tms=function(t,e,r){return[t,Math.pow(2,r)-1-e,r]},e.prototype.pixels_to_meters=function(t,e,r){var i=this.get_resolution(r);return[t*i-this.x_origin_offset,e*i-this.y_origin_offset]},e.prototype.meters_to_pixels=function(t,e,r){var i=this.get_resolution(r);return[(t+this.x_origin_offset)/i,(e+this.y_origin_offset)/i]},e.prototype.pixels_to_tile=function(t,e){var r=Math.ceil(t/this.tile_size);return[r=0===r?r:r-1,Math.max(Math.ceil(e/this.tile_size)-1,0)]},e.prototype.pixels_to_raster=function(t,e,r){return[t,(this.tile_size<<r)-e]},e.prototype.meters_to_tile=function(t,e,r){var o=i.__read(this.meters_to_pixels(t,e,r),2),_=o[0],n=o[1];return this.pixels_to_tile(_,n)},e.prototype.get_tile_meter_bounds=function(t,e,r){var o=i.__read(this.pixels_to_meters(t*this.tile_size,e*this.tile_size,r),2),_=o[0],n=o[1],s=i.__read(this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,r),2);return[_,n,s[0],s[1]]},e.prototype.get_tile_geographic_bounds=function(t,e,r){var o=this.get_tile_meter_bounds(t,e,r),_=i.__read(s.meters_extent_to_geographic(o),4);return[_[0],_[1],_[2],_[3]]},e.prototype.get_tiles_by_extent=function(t,e,r){void 0===r&&(r=1);var o=i.__read(t,4),_=o[0],n=o[1],s=o[2],a=o[3],l=i.__read(this.meters_to_tile(_,n,e),2),u=l[0],p=l[1],h=i.__read(this.meters_to_tile(s,a,e),2),y=h[0],c=h[1];u-=r,p-=r,y+=r;for(var f=[],d=c+=r;d>=p;d--)for(var x=u;x<=y;x++)this.is_valid_tile(x,d,e)&&f.push([x,d,e,this.get_tile_meter_bounds(x,d,e)]);return this.sort_tiles_from_center(f,[u,p,y,c]),f},e.prototype.quadkey_to_tile_xyz=function(t){for(var e=0,r=0,i=t.length,o=i;o>0;o--){var _=1<<o-1;switch(t.charAt(i-o)){case"0":continue;case"1":e|=_;break;case"2":r|=_;break;case"3":e|=_,r|=_;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,r,i]},e.prototype.tile_xyz_to_quadkey=function(t,e,r){for(var i="",o=r;o>0;o--){var _=1<<o-1,n=0;0!=(t&_)&&(n+=1),0!=(e&_)&&(n+=2),i+=n.toString()}return i},e.prototype.children_by_tile_xyz=function(t,e,r){for(var o=this.tile_xyz_to_quadkey(t,e,r),_=[],n=0;n<=3;n++){var s=i.__read(this.quadkey_to_tile_xyz(o+n.toString()),3),a=s[0],l=s[1],u=s[2],p=this.get_tile_meter_bounds(a,l,u);_.push([a,l,u,p])}return _},e.prototype.get_closest_parent_by_tile_xyz=function(t,e,r){var o,_,n,s=this.calculate_world_x_by_tile_xyz(t,e,r);t=(o=i.__read(this.normalize_xyz(t,e,r),3))[0],e=o[1],r=o[2];for(var a=this.tile_xyz_to_quadkey(t,e,r);a.length>0;)if(a=a.substring(0,a.length-1),t=(_=i.__read(this.quadkey_to_tile_xyz(a),3))[0],e=_[1],r=_[2],t=(n=i.__read(this.denormalize_xyz(t,e,r,s),3))[0],e=n[1],r=n[2],this.tiles.has(this.tile_xyz_to_key(t,e,r)))return[t,e,r];return[0,0,0]},e.prototype.normalize_xyz=function(t,e,r){if(this.wrap_around){var i=Math.pow(2,r);return[(t%i+i)%i,e,r]}return[t,e,r]},e.prototype.denormalize_xyz=function(t,e,r,i){return[t+i*Math.pow(2,r),e,r]},e.prototype.denormalize_meters=function(t,e,r,i){return[t+2*i*Math.PI*6378137,e]},e.prototype.calculate_world_x_by_tile_xyz=function(t,e,r){return Math.floor(t/Math.pow(2,r))},e}(o.TileSource);r.MercatorTileSource=a,a.__name__="MercatorTileSource",a.init_MercatorTileSource()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(196),o=e(128),a=i.__importStar(e(133)),l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_TileSource=function(){this.define({url:[a.String,""],tile_size:[a.Number,256],max_zoom:[a.Number,30],min_zoom:[a.Number,0],extra_url_vars:[a.Any,{}],attribution:[a.String,""],x_origin_offset:[a.Number],y_origin_offset:[a.Number],initial_resolution:[a.Number]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.tiles=new Map,this._normalize_case()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.change,(function(){return t._clear_cache()}))},t.prototype.string_lookup_replace=function(e,t){var r,n,a=e;try{for(var l=i.__values(o.entries(t)),_=l.next();!_.done;_=l.next()){var c=i.__read(_.value,2),u=c[0],p=c[1];a=a.replace("{"+u+"}",p)}}catch(e){r={error:e}}finally{try{_&&!_.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}return a},t.prototype._normalize_case=function(){var e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e},t.prototype._clear_cache=function(){this.tiles=new Map},t.prototype.tile_xyz_to_key=function(e,t,r){return e+":"+t+":"+r},t.prototype.key_to_tile_xyz=function(e){var t=i.__read(e.split(":").map((function(e){return parseInt(e)})),3);return[t[0],t[1],t[2]]},t.prototype.sort_tiles_from_center=function(e,t){var r=i.__read(t,4),n=r[0],o=r[1],a=r[2],l=r[3],_=(a-n)/2+n,c=(l-o)/2+o;e.sort((function(e,t){return Math.sqrt(Math.pow(_-e[0],2)+Math.pow(c-e[1],2))-Math.sqrt(Math.pow(_-t[0],2)+Math.pow(c-t[1],2))}))},t.prototype.get_image_url=function(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())},t}(n.Model);r.TileSource=l,l.__name__="TileSource",l.init_TileSource()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1),n=e(152);function o(e,r){return n.wgs84_mercator.compute(e,r)}function a(e,r){return n.wgs84_mercator.invert(e,r)}t.geographic_to_meters=o,t.meters_to_geographic=a,t.geographic_extent_to_meters=function(e){var r=_.__read(e,4),t=r[0],n=r[1],a=r[2],c=r[3],u=_.__read(o(t,n),2),i=u[0],g=u[1],d=_.__read(o(a,c),2);return[i,g,d[0],d[1]]},t.meters_extent_to_geographic=function(e){var r=_.__read(e,4),t=r[0],n=r[1],o=r[2],c=r[3],u=_.__read(a(t,n),2),i=u[0],g=u[1],d=_.__read(a(o,c),2);return[i,g,d[0],d[1]]}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var _=e(1),i=function(e){function t(t){return e.call(this,t)||this}return _.__extends(t,e),t.prototype.get_image_url=function(e,t,r){var i=this.string_lookup_replace(this.url,this.extra_url_vars),u=_.__read(this.tms_to_wmts(e,t,r),3),o=u[0],n=u[1],l=u[2],a=this.tile_xyz_to_quadkey(o,n,l);return i.replace("{Q}",a)},t}(e(448).MercatorTileSource);r.QUADKEYTileSource=i,i.__name__="QUADKEYTileSource"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),n=e(453),a=e(206),o=e(273),_=e(187),s=r.__importStar(e(133)),l=e(366),h=e(124),d=e(123),c=e(204),u=e(200),p=e(454),m=r.__importDefault(e(455)),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.initialize=function(){this._tiles=[],e.prototype.initialize.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()})),this.connect(this.model.tile_source.change,(function(){return t.request_render()}))},t.prototype.styles=function(){return r.__spread(e.prototype.styles.call(this),[m.default])},t.prototype.get_extent=function(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]},Object.defineProperty(t.prototype,"map_plot",{get:function(){return this.plot_model},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"map_canvas",{get:function(){return this.layer.ctx},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"map_frame",{get:function(){return this.plot_view.frame},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x_range",{get:function(){return this.map_plot.x_range},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_range",{get:function(){return this.map_plot.y_range},enumerable:!0,configurable:!0}),t.prototype._set_data=function(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0},t.prototype._update_attribution=function(){null!=this.attribution_el&&_.removeElement(this.attribution_el);var e=this.model.tile_source.attribution;if(d.isString(e)&&e.length>0){var t=this.plot_view,i=t.layout,r=t.frame,n=i.bbox.width-r.bbox.right,a=i.bbox.height-r.bbox.bottom,o=r.bbox.width;this.attribution_el=_.div({class:p.bk_tile_attribution,style:{position:"absolute",right:n+"px",bottom:a+"px","max-width":o-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=e,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}},t.prototype._map_data=function(){this.initial_extent=this.get_extent();var e=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),t=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.start=t[0],this.y_range.start=t[1],this.x_range.end=t[2],this.y_range.end=t[3],this.x_range instanceof o.Range1d&&(this.x_range.reset_start=t[0],this.x_range.reset_end=t[2]),this.y_range instanceof o.Range1d&&(this.y_range.reset_start=t[1],this.y_range.reset_end=t[3]),this._update_attribution()},t.prototype._create_tile=function(e,t,i,n,a){var o=this;void 0===a&&(a=!1);var _=r.__read(this.model.tile_source.normalize_xyz(e,t,i),3),s=_[0],h=_[1],d=_[2],c={img:void 0,tile_coords:[e,t,i],normalized_coords:[s,h,d],quadkey:this.model.tile_source.tile_xyz_to_quadkey(e,t,i),cache_key:this.model.tile_source.tile_xyz_to_key(e,t,i),bounds:n,loaded:!1,finished:!1,x_coord:n[0],y_coord:n[3]},u=this.model.tile_source.get_image_url(s,h,d);new l.ImageLoader(u,{loaded:function(e){Object.assign(c,{img:e,loaded:!0}),a?(c.finished=!0,o.notify_finished()):o.request_render()},failed:function(){c.finished=!0}}),this.model.tile_source.tiles.set(c.cache_key,c),this._tiles.push(c)},t.prototype._enforce_aspect_ratio=function(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){var e=this.get_extent(),t=this.model.tile_source.get_level_by_extent(e,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(e,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}},t.prototype.has_finished=function(){var t,i;if(!e.prototype.has_finished.call(this))return!1;if(0===this._tiles.length)return!1;try{for(var n=r.__values(this._tiles),a=n.next();!a.done;a=n.next()){if(!a.value.finished)return!1}}catch(e){t={error:e}}finally{try{a&&!a.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}return!0},t.prototype._render=function(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()},t.prototype._draw_tile=function(e){var t=this.model.tile_source.tiles.get(e);if(null!=t&&t.loaded){var i=r.__read(this.coordinates.map_to_screen([t.bounds[0]],[t.bounds[3]]),2),n=r.__read(i[0],1)[0],a=r.__read(i[1],1)[0],o=r.__read(this.coordinates.map_to_screen([t.bounds[2]],[t.bounds[1]]),2),_=r.__read(o[0],1)[0]-n,s=r.__read(o[1],1)[0]-a,l=n,h=a,d=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(t.img,l,h,_,s),this.map_canvas.setImageSmoothingEnabled(d),t.finished=!0}},t.prototype._set_rect=function(){var e=this.plot_model.properties.outline_line_width.value(),t=this.map_frame.bbox.left+e/2,i=this.map_frame.bbox.top+e/2,r=this.map_frame.bbox.width-e,n=this.map_frame.bbox.height-e;this.map_canvas.rect(t,i,r,n),this.map_canvas.clip()},t.prototype._render_tiles=function(e){var t,i;this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;try{for(var n=r.__values(e),a=n.next();!a.done;a=n.next()){var o=a.value;this._draw_tile(o)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}this.map_canvas.restore()},t.prototype._prefetch_tiles=function(){for(var e,t,i=this.model.tile_source,n=this.get_extent(),a=this.map_frame.bbox.height,o=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(n,a,o),s=this.model.tile_source.get_tiles_by_extent(n,_),l=0,h=Math.min(10,s.length);l<h;l++){var d=r.__read(s[l],3),c=d[0],u=d[1],p=d[2],m=this.model.tile_source.children_by_tile_xyz(c,u,p);try{for(var f=(e=void 0,r.__values(m)),y=f.next();!y.done;y=f.next()){var b=y.value,g=r.__read(b,4),x=g[0],v=g[1],w=g[2],z=g[3];i.tiles.has(i.tile_xyz_to_key(x,v,w))||this._create_tile(x,v,w,z,!0)}}catch(t){e={error:t}}finally{try{y&&!y.done&&(t=f.return)&&t.call(f)}finally{if(e)throw e.error}}}},t.prototype._fetch_tiles=function(e){var t,i;try{for(var n=r.__values(e),a=n.next();!a.done;a=n.next()){var o=a.value,_=r.__read(o,4),s=_[0],l=_[1],h=_[2],d=_[3];this._create_tile(s,l,h,d)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}},t.prototype._update=function(){var e,t,i,n,a=this,o=this.model.tile_source,_=o.min_zoom,s=o.max_zoom,l=this.get_extent(),d=this.extent[2]-this.extent[0]<l[2]-l[0],c=this.map_frame.bbox.height,u=this.map_frame.bbox.width,p=o.get_level_by_extent(l,c,u),m=!1;p<_?(l=this.extent,p=_,m=!0):p>s&&(l=this.extent,p=s,m=!0),m&&(this.x_range.setv({x_range:{start:l[0],end:l[2]}}),this.y_range.setv({start:l[1],end:l[3]})),this.extent=l;var f=o.get_tiles_by_extent(l,p),y=[],b=[],g=[],x=[];try{for(var v=r.__values(f),w=v.next();!w.done;w=v.next()){var z=w.value,T=r.__read(z,3),k=T[0],R=T[1],S=T[2],j=o.tile_xyz_to_key(k,R,S),O=o.tiles.get(j);if(null!=O&&O.loaded)b.push(j);else if(this.model.render_parents){var I=r.__read(o.get_closest_parent_by_tile_xyz(k,R,S),3),P=I[0],q=I[1],M=I[2],D=o.tile_xyz_to_key(P,q,M),E=o.tiles.get(D);if(null!=E&&E.loaded&&!h.includes(g,D)&&g.push(D),d){var V=o.children_by_tile_xyz(k,R,S);try{for(var B=(i=void 0,r.__values(V)),C=B.next();!C.done;C=B.next()){var L=r.__read(C.value,3),A=L[0],H=L[1],N=L[2],W=o.tile_xyz_to_key(A,H,N);o.tiles.has(W)&&x.push(W)}}catch(e){i={error:e}}finally{try{C&&!C.done&&(n=B.return)&&n.call(B)}finally{if(i)throw i.error}}}}null==O&&y.push(z)}}catch(t){e={error:t}}finally{try{w&&!w.done&&(t=v.return)&&t.call(v)}finally{if(e)throw e.error}}this._render_tiles(g),this._render_tiles(x),this._render_tiles(b),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((function(){return a._fetch_tiles(y)}),65)},t}(a.DataRendererView);i.TileRendererView=f,f.__name__="TileRendererView";var y=function(e){function t(t){var i=e.call(this,t)||this;return i._selection_manager=new c.SelectionManager({source:new u.ColumnDataSource}),i}return r.__extends(t,e),t.init_TileRenderer=function(){this.prototype.default_view=f,this.define({alpha:[s.Number,1],smoothing:[s.Boolean,!0],tile_source:[s.Instance,function(){return new n.WMTSTileSource}],render_parents:[s.Boolean,!0]})},t.prototype.get_selection_manager=function(){return this._selection_manager},t}(a.DataRenderer);i.TileRenderer=y,y.__name__="TileRenderer",y.init_TileRenderer()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),_=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.prototype.get_image_url=function(e,t,r){var _=this.string_lookup_replace(this.url,this.extra_url_vars),n=i.__read(this.tms_to_wmts(e,t,r),3),o=n[0],u=n[1],l=n[2];return _.replace("{X}",o.toString()).replace("{Y}",u.toString()).replace("{Z}",l.toString())},t}(e(448).MercatorTileSource);r.WMTSTileSource=_,_.__name__="WMTSTileSource"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0}),i.bk_tile_attribution="bk-tile-attribution"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});n.default="\n.bk-root .bk-tile-attribution a {\n  color: black;\n}\n"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),n=function(e){function r(r){return e.call(this,r)||this}return i.__extends(r,e),r.prototype.get_image_url=function(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())},r}(e(448).MercatorTileSource);t.TMSTileSource=n,n.__name__="TMSTileSource"},
function _(e,r,a){Object.defineProperty(a,"__esModule",{value:!0});var t=e(458);a.CanvasTexture=t.CanvasTexture;var u=e(460);a.ImageURLTexture=u.ImageURLTexture;var v=e(459);a.Texture=v.Texture},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(459),a=r.__importStar(e(133)),u=e(144),c=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_CanvasTexture=function(){this.define({code:[a.String]})},Object.defineProperty(t.prototype,"func",{get:function(){var e=u.use_strict(this.code);return new Function("ctx","color","scale","weight",e)},enumerable:!0,configurable:!0}),t.prototype.get_pattern=function(e,t,n){var r=this;return function(i){var a=document.createElement("canvas");a.width=t,a.height=t;var u=a.getContext("2d");return r.func.call(r,u,e,t,n),i.createPattern(a,r.repetition)}},t}(i.Texture);n.CanvasTexture=c,c.__name__="CanvasTexture",c.init_CanvasTexture()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(196),o=i.__importStar(e(133)),u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Texture=function(){this.define({repetition:[o.TextureRepetition,"repeat"]})},t.prototype.onload=function(e){e()},t}(r.Model);n.Texture=u,u.__name__="Texture",u.init_Texture()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(459),o=i.__importStar(e(133)),a=e(366),u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_ImageURLTexture=function(){this.define({url:[o.String]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._loader=new a.ImageLoader(this.url)},t.prototype.get_pattern=function(e,t,n){var i=this;return function(e){return i._loader.finished?e.createPattern(i._loader.image,i.repetition):null}},t.prototype.onload=function(e){this._loader.promise.then((function(){return e()}))},t}(r.Texture);n.ImageURLTexture=u,u.__name__="ImageURLTexture",u.init_ImageURLTexture()},
function _(o,l,T){Object.defineProperty(T,"__esModule",{value:!0});var a=o(422);T.ActionTool=a.ActionTool;var r=o(462);T.CustomAction=r.CustomAction;var e=o(423);T.HelpTool=e.HelpTool;var v=o(463);T.RedoTool=v.RedoTool;var t=o(464);T.ResetTool=t.ResetTool;var n=o(465);T.SaveTool=n.SaveTool;var s=o(466);T.UndoTool=s.UndoTool;var i=o(467);T.ZoomInTool=i.ZoomInTool;var P=o(470);T.ZoomOutTool=P.ZoomOutTool;var c=o(411);T.ButtonTool=c.ButtonTool;var d=o(471);T.EditTool=d.EditTool;var u=o(472);T.BoxEditTool=u.BoxEditTool;var y=o(473);T.FreehandDrawTool=y.FreehandDrawTool;var m=o(474);T.PointDrawTool=m.PointDrawTool;var x=o(475);T.PolyDrawTool=x.PolyDrawTool;var B=o(476);T.PolyTool=B.PolyTool;var S=o(477);T.PolyEditTool=S.PolyEditTool;var b=o(478);T.BoxSelectTool=b.BoxSelectTool;var h=o(481);T.BoxZoomTool=h.BoxZoomTool;var E=o(421);T.GestureTool=E.GestureTool;var Z=o(482);T.LassoSelectTool=Z.LassoSelectTool;var p=o(484);T.LineEditTool=p.LineEditTool;var w=o(486);T.PanTool=w.PanTool;var C=o(483);T.PolySelectTool=C.PolySelectTool;var D=o(487);T.RangeTool=D.RangeTool;var H=o(479);T.SelectTool=H.SelectTool;var R=o(488);T.TapTool=R.TapTool;var A=o(489);T.WheelPanTool=A.WheelPanTool;var I=o(490);T.WheelZoomTool=I.WheelZoomTool;var L=o(491);T.CrosshairTool=L.CrosshairTool;var W=o(492);T.CustomJSHover=W.CustomJSHover;var O=o(493);T.HoverTool=O.HoverTool;var _=o(410);T.InspectTool=_.InspectTool;var f=o(413);T.Tool=f.Tool;var g=o(494);T.ToolProxy=g.ToolProxy;var F=o(409);T.Toolbar=F.Toolbar;var G=o(420);T.ToolbarBase=G.ToolbarBase;var J=o(495);T.ProxyToolbar=J.ProxyToolbar;var U=o(495);T.ToolbarBox=U.ToolbarBox},
function _(t,o,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),e=t(422),c=i.__importStar(t(133)),u=t(414),r=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(u.bk_toolbar_button_custom_action)},o}(e.ActionToolButtonView);n.CustomActionButtonView=r,r.__name__="CustomActionButtonView";var s=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype.doit=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},o}(e.ActionToolView);n.CustomActionView=s,s.__name__="CustomActionView";var l=function(t){function o(o){var n=t.call(this,o)||this;return n.tool_name="Custom Action",n.button_view=r,n}return i.__extends(o,t),o.init_CustomAction=function(){this.prototype.default_view=s,this.define({action_tooltip:[c.String,"Perform a Custom Action"],callback:[c.Any],icon:[c.String]})},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this.action_tooltip},enumerable:!0,configurable:!0}),o}(e.ActionTool);n.CustomAction=l,l.__name__="CustomAction",l.init_CustomAction()},
function _(o,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=o(1),i=o(422),r=o(424),_=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return n.__extends(t,o),t.prototype.connect_signals=function(){var t=this;o.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,(function(){return t.model.disabled=!t.plot_view.can_redo()}))},t.prototype.doit=function(){this.plot_view.redo()},t}(i.ActionToolView);e.RedoToolView=_,_.__name__="RedoToolView";var l=function(o){function t(t){var e=o.call(this,t)||this;return e.tool_name="Redo",e.icon=r.bk_tool_icon_redo,e}return n.__extends(t,o),t.init_RedoTool=function(){this.prototype.default_view=_,this.override({disabled:!0}),this.register_alias("redo",(function(){return new t}))},t}(i.ActionTool);e.RedoTool=l,l.__name__="RedoTool",l.init_RedoTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),i=e(422),_=e(424),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.doit=function(){this.plot_view.reset()},t}(i.ActionToolView);o.ResetToolView=r,r.__name__="ResetToolView";var s=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Reset",o.icon=_.bk_tool_icon_reset,o}return n.__extends(t,e),t.init_ResetTool=function(){this.prototype.default_view=r,this.register_alias("reset",(function(){return new t}))},t}(i.ActionTool);o.ResetTool=s,s.__name__="ResetTool",s.init_ResetTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),i=e(422),r=e(424),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.copy=function(){return n.__awaiter(this,void 0,void 0,(function(){var e,t,o;return n.__generator(this,(function(n){switch(n.label){case 0:return[4,this.plot_view.to_blob()];case 1:return e=n.sent(),t=new ClipboardItem(((o={})[e.type]=e,o)),[4,navigator.clipboard.write([t])];case 2:return n.sent(),[2]}}))}))},t.prototype.save=function(e){return n.__awaiter(this,void 0,void 0,(function(){var t,o;return n.__generator(this,(function(n){switch(n.label){case 0:return[4,this.plot_view.to_blob()];case 1:return t=n.sent(),(o=document.createElement("a")).href=URL.createObjectURL(t),o.download=e,o.target="_blank",o.dispatchEvent(new MouseEvent("click")),[2]}}))}))},t.prototype.doit=function(e){switch(void 0===e&&(e="save"),e){case"save":this.save("bokeh_plot");break;case"copy":this.copy()}},t}(i.ActionToolView);o.SaveToolView=a,a.__name__="SaveToolView";var c=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Save",o.icon=r.bk_tool_icon_save,o}return n.__extends(t,e),t.init_SaveTool=function(){this.prototype.default_view=a,this.register_alias("save",(function(){return new t}))},Object.defineProperty(t.prototype,"menu",{get:function(){var e=this;return[{icon:"bk-tool-icon-copy-to-clipboard",tooltip:"Copy image to clipboard",if:function(){return"undefined"!=typeof ClipboardItem},handler:function(){e.do.emit("copy")}}]},enumerable:!0,configurable:!0}),t}(i.ActionTool);o.SaveTool=c,c.__name__="SaveTool",c.init_SaveTool()},
function _(o,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=o(1),e=o(422),_=o(424),l=function(o){function n(){return null!==o&&o.apply(this,arguments)||this}return i.__extends(n,o),n.prototype.connect_signals=function(){var n=this;o.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,(function(){return n.model.disabled=!n.plot_view.can_undo()}))},n.prototype.doit=function(){this.plot_view.undo()},n}(e.ActionToolView);t.UndoToolView=l,l.__name__="UndoToolView";var r=function(o){function n(n){var t=o.call(this,n)||this;return t.tool_name="Undo",t.icon=_.bk_tool_icon_undo,t}return i.__extends(n,o),n.init_UndoTool=function(){this.prototype.default_view=l,this.override({disabled:!0}),this.register_alias("undo",(function(){return new n}))},n}(e.ActionTool);t.UndoTool=r,r.__name__="UndoTool",r.init_UndoTool()},
function _(o,n,i){Object.defineProperty(i,"__esModule",{value:!0});var e=o(1),t=o(468),s=o(424),_=function(o){function n(n){var i=o.call(this,n)||this;return i.sign=1,i.tool_name="Zoom In",i.icon=s.bk_tool_icon_zoom_in,i}return e.__extends(n,o),n.init_ZoomInTool=function(){this.prototype.default_view=t.ZoomBaseToolView,this.register_alias("zoom_in",(function(){return new n({dimensions:"both"})})),this.register_alias("xzoom_in",(function(){return new n({dimensions:"width"})})),this.register_alias("yzoom_in",(function(){return new n({dimensions:"height"})}))},n}(t.ZoomBaseTool);i.ZoomInTool=_,_.__name__="ZoomInTool",_.init_ZoomInTool()},
function _(o,t,e){Object.defineProperty(e,"__esModule",{value:!0});var i=o(1),n=o(422),s=o(469),r=i.__importStar(o(133)),_=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return i.__extends(t,o),t.prototype.doit=function(){var o=this.plot_view.frame,t=this.model.dimensions,e="width"==t||"both"==t,i="height"==t||"both"==t,n=s.scale_range(o,this.model.sign*this.model.factor,e,i);this.plot_view.push_state("zoom_out",{range:n}),this.plot_view.update_range(n,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)},t}(n.ActionToolView);e.ZoomBaseToolView=_,_.__name__="ZoomBaseToolView";var l=function(o){function t(t){return o.call(this,t)||this}return i.__extends(t,o),t.init_ZoomBaseTool=function(){this.prototype.default_view=_,this.define({factor:[r.Percent,.1],dimensions:[r.Dimensions,"both"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(n.ActionTool);e.ZoomBaseTool=l,l.__name__="ZoomBaseTool",l.init_ZoomBaseTool()},
function _(r,e,a){Object.defineProperty(a,"__esModule",{value:!0});var n=r(1),_=r(125);function t(r,e,a){var _=n.__read([r.start,r.end],2),t=_[0],l=_[1],o=null!=a?a:(l+t)/2;return[t-(t-o)*e,l-(l-o)*e]}function l(r,e){var a,_,t=n.__read(e,2),l=t[0],o=t[1],d=new Map;try{for(var i=n.__values(r),u=i.next();!u.done;u=i.next()){var v=n.__read(u.value,2),c=v[0],s=v[1],f=n.__read(s.r_invert(l,o),2),y=f[0],x=f[1];d.set(c,{start:y,end:x})}}catch(r){a={error:r}}finally{try{u&&!u.done&&(_=i.return)&&_.call(i)}finally{if(a)throw a.error}}return d}a.scale_highlow=t,a.get_info=l,a.scale_range=function(r,e,a,o,d){void 0===a&&(a=!0),void 0===o&&(o=!0),e=_.clamp(e,-.9,.9);var i=a?e:0,u=n.__read(t(r.bbox.h_range,i,null!=d?d.x:void 0),2),v=u[0],c=u[1],s=l(r.x_scales,[v,c]),f=o?e:0,y=n.__read(t(r.bbox.v_range,f,null!=d?d.y:void 0),2),x=y[0],b=y[1];return{xrs:s,yrs:l(r.y_scales,[x,b]),factor:e}}},
function _(o,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=o(1),e=o(468),u=o(424),s=function(o){function t(t){var i=o.call(this,t)||this;return i.sign=-1,i.tool_name="Zoom Out",i.icon=u.bk_tool_icon_zoom_out,i}return n.__extends(t,o),t.init_ZoomOutTool=function(){this.prototype.default_view=e.ZoomBaseToolView,this.register_alias("zoom_out",(function(){return new t({dimensions:"both"})})),this.register_alias("xzoom_out",(function(){return new t({dimensions:"width"})})),this.register_alias("yzoom_out",(function(){return new t({dimensions:"height"})}))},t}(e.ZoomBaseTool);i.ZoomOutTool=s,s.__name__="ZoomOutTool",s.init_ZoomOutTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var o=e(1),n=o.__importStar(e(133)),a=e(124),i=e(123),l=e(126),_=e(421),s=function(e){function t(){var t=e.apply(this,o.__spread(arguments))||this;return t._mouse_in_frame=!0,t}return o.__extends(t,e),t.prototype._select_mode=function(e){var t=e.shiftKey,r=e.ctrlKey;return t||r?t&&!r?"append":!t&&r?"intersect":t&&r?"subtract":void l.unreachable():"replace"},t.prototype._move_enter=function(e){this._mouse_in_frame=!0},t.prototype._move_exit=function(e){this._mouse_in_frame=!1},t.prototype._map_drag=function(e,t,r){if(!this.plot_view.frame.bbox.contains(e,t))return null;var o=this.plot_view.renderer_views.get(r);return[o.coordinates.x_scale.invert(e),o.coordinates.y_scale.invert(t)]},t.prototype._delete_selected=function(e){var t,r,n=e.data_source,a=n.selected.indices;a.sort();try{for(var i=o.__values(n.columns()),l=i.next();!l.done;l=i.next())for(var _=l.value,s=n.get_array(_),c=0;c<a.length;c++){var u=a[c];s.splice(u-c,1)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}this._emit_cds_changes(n)},t.prototype._pop_glyphs=function(e,t){var r,n,a=e.columns();if(t&&a.length)try{for(var l=o.__values(a),_=l.next();!_.done;_=l.next()){var s=_.value,c=e.get_array(s),u=c.length-t+1;u<1||(i.isArray(c)||(c=Array.from(c),e.data[s]=c),c.splice(0,u))}}catch(e){r={error:e}}finally{try{_&&!_.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}},t.prototype._emit_cds_changes=function(e,t,r,o){void 0===t&&(t=!0),void 0===r&&(r=!0),void 0===o&&(o=!0),r&&e.selection_manager.clear(),t&&e.change.emit(),o&&(e.data=e.data,e.properties.data.change.emit())},t.prototype._drag_points=function(e,t,r){var n,a,i,l;if(void 0===r&&(r="both"),null!=this._basepoint){var _=o.__read(this._basepoint,2),s=_[0],c=_[1];try{for(var u=o.__values(t),d=u.next();!d.done;d=u.next()){var p=d.value,f=this._map_drag(s,c,p),y=this._map_drag(e.sx,e.sy,p);if(null!=y&&null!=f){var v=o.__read(y,2),h=v[0],m=v[1],g=o.__read(f,2),x=g[0],b=g[1],w=o.__read([h-x,m-b],2),T=w[0],E=w[1],A=p.glyph,j=p.data_source,O=o.__read([A.x.field,A.y.field],2),P=O[0],S=O[1];try{for(var V=(i=void 0,o.__values(j.selected.indices)),G=V.next();!G.done;G=V.next()){var K=G.value;!P||"width"!=r&&"both"!=r||(j.data[P][K]+=T),!S||"height"!=r&&"both"!=r||(j.data[S][K]+=E)}}catch(e){i={error:e}}finally{try{G&&!G.done&&(l=V.return)&&l.call(V)}finally{if(i)throw i.error}}j.change.emit()}}}catch(e){n={error:e}}finally{try{d&&!d.done&&(a=u.return)&&a.call(u)}finally{if(n)throw n.error}}this._basepoint=[e.sx,e.sy]}},t.prototype._pad_empty_columns=function(e,t){var r,n;try{for(var i=o.__values(e.columns()),l=i.next();!l.done;l=i.next()){var _=l.value;a.includes(t,_)||e.get_array(_).push(this.model.empty_value)}}catch(e){r={error:e}}finally{try{l&&!l.done&&(n=i.return)&&n.call(i)}finally{if(r)throw r.error}}},t.prototype._select_event=function(e,t,r){var n,a,i=this.plot_view.frame,l=e.sx,_=e.sy;if(!i.bbox.contains(l,_))return[];var s={type:"point",sx:l,sy:_},c=[];try{for(var u=o.__values(r),d=u.next();!d.done;d=u.next()){var p=d.value,f=p.get_selection_manager(),y=p.data_source,v=[this.plot_view.renderer_views.get(p)];f.select(v,s,!0,t)&&c.push(p),y.properties.selected.change.emit()}}catch(e){n={error:e}}finally{try{d&&!d.done&&(a=u.return)&&a.call(u)}finally{if(n)throw n.error}}return c},t}(_.GestureToolView);r.EditToolView=s,s.__name__="EditToolView";var c=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_EditTool=function(){this.define({custom_icon:[n.String],custom_tooltip:[n.String],empty_value:[n.Any],renderers:[n.Array,[]]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.custom_tooltip||this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_icon",{get:function(){return this.custom_icon||this.icon},enumerable:!0,configurable:!0}),t}(_.GestureTool);r.EditTool=c,c.__name__="EditTool",c.init_EditTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var o=e(1),_=e(187),s=o.__importStar(e(133)),r=e(471),n=e(424),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype._tap=function(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._keyup=function(e){var t,i;if(this.model.active&&this._mouse_in_frame)try{for(var s=o.__values(this.model.renderers),r=s.next();!r.done;r=s.next()){var n=r.value;if(e.keyCode===_.Keys.Backspace)this._delete_selected(n);else if(e.keyCode==_.Keys.Esc){n.data_source.selection_manager.clear()}}}catch(e){t={error:e}}finally{try{r&&!r.done&&(i=s.return)&&i.call(s)}finally{if(t)throw t.error}}},t.prototype._set_extent=function(e,t,i,_){var s=o.__read(e,2),r=s[0],n=s[1],a=o.__read(t,2),d=a[0],l=a[1];void 0===_&&(_=!1);var h=this.model.renderers[0],p=this.plot_view.renderer_views.get(h),u=h.glyph,c=h.data_source,f=o.__read(p.coordinates.x_scale.r_invert(r,n),2),y=f[0],v=f[1],m=o.__read(p.coordinates.y_scale.r_invert(d,l),2),b=m[0],x=m[1],w=o.__read([(y+v)/2,(b+x)/2],2),g=w[0],E=w[1],T=o.__read([v-y,x-b],2),B=T[0],k=T[1],K=o.__read([u.x.field,u.y.field],2),j=K[0],V=K[1],C=o.__read([u.width.field,u.height.field],2),D=C[0],I=C[1];if(i)this._pop_glyphs(c,this.model.num_objects),j&&c.get_array(j).push(g),V&&c.get_array(V).push(E),D&&c.get_array(D).push(B),I&&c.get_array(I).push(k),this._pad_empty_columns(c,[j,V,D,I]);else{var M=c.data[j].length-1;j&&(c.data[j][M]=g),V&&(c.data[V][M]=E),D&&(c.data[D][M]=B),I&&(c.data[I][M]=k)}this._emit_cds_changes(c,!0,!1,_)},t.prototype._update_box=function(e,t,i){if(void 0===t&&(t=!1),void 0===i&&(i=!1),null!=this._draw_basepoint){var _=[e.sx,e.sy],s=this.plot_view.frame,r=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,_,s,r);if(null!=n){var a=o.__read(n,2),d=a[0],l=a[1];this._set_extent(d,l,t,i)}}},t.prototype._doubletap=function(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))},t.prototype._move=function(e){this._update_box(e,!1,!1)},t.prototype._pan_start=function(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}},t.prototype._pan=function(e,t,i){if(void 0===t&&(t=!1),void 0===i&&(i=!1),e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,i)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}},t.prototype._pan_end=function(e){var t,i;if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;try{for(var _=o.__values(this.model.renderers),s=_.next();!s.done;s=_.next()){var r=s.value;this._emit_cds_changes(r.data_source,!1,!0,!0)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(i=_.return)&&i.call(_)}finally{if(t)throw t.error}}}},t}(r.EditToolView);i.BoxEditToolView=a,a.__name__="BoxEditToolView";var d=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Box Edit Tool",i.icon=n.bk_tool_icon_box_edit,i.event_type=["tap","pan","move"],i.default_order=1,i}return o.__extends(t,e),t.init_BoxEditTool=function(){this.prototype.default_view=a,this.define({dimensions:[s.Dimensions,"both"],num_objects:[s.Int,0]})},t}(r.EditTool);i.BoxEditTool=d,d.__name__="BoxEditTool",d.init_BoxEditTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var a=e(1),o=e(187),n=a.__importStar(e(133)),_=e(123),i=e(471),d=e(424),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype._draw=function(e,t,r){if(void 0===r&&(r=!1),this.model.active){var o=this.model.renderers[0],n=this._map_drag(e.sx,e.sy,o);if(null!=n){var i=a.__read(n,2),d=i[0],s=i[1],l=o.data_source,h=o.glyph,p=a.__read([h.xs.field,h.ys.field],2),c=p[0],u=p[1];if("new"==t)this._pop_glyphs(l,this.model.num_objects),c&&l.get_array(c).push([d]),u&&l.get_array(u).push([s]),this._pad_empty_columns(l,[c,u]);else if("add"==t){if(c){var f=l.data[c].length-1,y=l.get_array(c)[f];_.isArray(y)||(y=Array.from(y),l.data[c][f]=y),y.push(d)}if(u){var m=l.data[u].length-1,v=l.get_array(u)[m];_.isArray(v)||(v=Array.from(v),l.data[u][m]=v),v.push(s)}}this._emit_cds_changes(l,!0,!0,r)}}},t.prototype._pan_start=function(e){this._draw(e,"new")},t.prototype._pan=function(e){this._draw(e,"add")},t.prototype._pan_end=function(e){this._draw(e,"add",!0)},t.prototype._tap=function(e){this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame)try{for(var n=a.__values(this.model.renderers),_=n.next();!_.done;_=n.next()){var i=_.value;e.keyCode===o.Keys.Esc?i.data_source.selection_manager.clear():e.keyCode===o.Keys.Backspace&&this._delete_selected(i)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(r=n.return)&&r.call(n)}finally{if(t)throw t.error}}},t}(i.EditToolView);r.FreehandDrawToolView=s,s.__name__="FreehandDrawToolView";var l=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Freehand Draw Tool",r.icon=d.bk_tool_icon_freehand_draw,r.event_type=["pan","tap"],r.default_order=3,r}return a.__extends(t,e),t.init_FreehandDrawTool=function(){this.prototype.default_view=s,this.define({num_objects:[n.Int,0]})},t}(i.EditTool);r.FreehandDrawTool=l,l.__name__="FreehandDrawTool",l.init_FreehandDrawTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var r=e(1),n=e(187),a=r.__importStar(e(133)),i=e(471),_=e(424),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype._tap=function(e){if(!this._select_event(e,this._select_mode(e),this.model.renderers).length&&this.model.add){var t=this.model.renderers[0],o=this._map_drag(e.sx,e.sy,t);if(null!=o){var n=t.glyph,a=t.data_source,i=r.__read([n.x.field,n.y.field],2),_=i[0],s=i[1],l=r.__read(o,2),d=l[0],h=l[1];this._pop_glyphs(a,this.model.num_objects),_&&a.get_array(_).push(d),s&&a.get_array(s).push(h),this._pad_empty_columns(a,[_,s]),a.change.emit(),a.data=a.data,a.properties.data.change.emit()}}},t.prototype._keyup=function(e){var t,o;if(this.model.active&&this._mouse_in_frame)try{for(var a=r.__values(this.model.renderers),i=a.next();!i.done;i=a.next()){var _=i.value;e.keyCode===n.Keys.Backspace?this._delete_selected(_):e.keyCode==n.Keys.Esc&&_.data_source.selection_manager.clear()}}catch(e){t={error:e}}finally{try{i&&!i.done&&(o=a.return)&&o.call(a)}finally{if(t)throw t.error}}},t.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])},t.prototype._pan=function(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)},t.prototype._pan_end=function(e){var t,o;if(this.model.drag){this._pan(e);try{for(var n=r.__values(this.model.renderers),a=n.next();!a.done;a=n.next()){var i=a.value;this._emit_cds_changes(i.data_source,!1,!0,!0)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(o=n.return)&&o.call(n)}finally{if(t)throw t.error}}this._basepoint=null}},t}(i.EditToolView);o.PointDrawToolView=s,s.__name__="PointDrawToolView";var l=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Point Draw Tool",o.icon=_.bk_tool_icon_point_draw,o.event_type=["tap","pan","move"],o.default_order=2,o}return r.__extends(t,e),t.init_PointDrawTool=function(){this.prototype.default_view=s,this.define({add:[a.Boolean,!0],drag:[a.Boolean,!0],num_objects:[a.Int,0]})},t}(i.EditTool);o.PointDrawTool=l,l.__name__="PointDrawTool",l.init_PointDrawTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var a=e(1),i=e(187),o=a.__importStar(e(133)),n=e(123),l=e(476),s=e(424),_=function(e){function t(){var t=e.apply(this,a.__spread(arguments))||this;return t._drawing=!1,t._initialized=!1,t}return a.__extends(t,e),t.prototype._tap=function(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._draw=function(e,t,r){void 0===r&&(r=!1);var i=this.model.renderers[0],o=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null!=o){var l=a.__read(this._snap_to_vertex.apply(this,a.__spread([e],o)),2),s=l[0],_=l[1],d=i.data_source,h=i.glyph,y=a.__read([h.xs.field,h.ys.field],2),c=y[0],p=y[1];if("new"==t)this._pop_glyphs(d,this.model.num_objects),c&&d.get_array(c).push([s,s]),p&&d.get_array(p).push([_,_]),this._pad_empty_columns(d,[c,p]);else if("edit"==t){if(c)(f=d.data[c][d.data[c].length-1])[f.length-1]=s;if(p)(g=d.data[p][d.data[p].length-1])[g.length-1]=_}else if("add"==t){if(c){var f,v=d.data[c].length-1,u=(f=d.get_array(c)[v])[f.length-1];f[f.length-1]=s,n.isArray(f)||(f=Array.from(f),d.data[c][v]=f),f.push(u)}if(p){var g,m=d.data[p].length-1,w=(g=d.get_array(p)[m])[g.length-1];g[g.length-1]=_,n.isArray(g)||(g=Array.from(g),d.data[p][m]=g),g.push(w)}}this._emit_cds_changes(d,!0,!1,r)}},t.prototype._show_vertices=function(){var e,t,r,i;if(this.model.active){for(var o=[],n=[],l=0;l<this.model.renderers.length;l++){var s=this.model.renderers[l],_=s.data_source,d=s.glyph,h=a.__read([d.xs.field,d.ys.field],2),y=h[0],c=h[1];if(y)try{for(var p=(e=void 0,a.__values(_.get_array(y))),f=p.next();!f.done;f=p.next()){var v=f.value;Array.prototype.push.apply(o,v)}}catch(t){e={error:t}}finally{try{f&&!f.done&&(t=p.return)&&t.call(p)}finally{if(e)throw e.error}}if(c)try{for(var u=(r=void 0,a.__values(_.get_array(c))),g=u.next();!g.done;g=u.next()){v=g.value;Array.prototype.push.apply(n,v)}}catch(e){r={error:e}}finally{try{g&&!g.done&&(i=u.return)&&i.call(u)}finally{if(r)throw r.error}}this._drawing&&l==this.model.renderers.length-1&&(o.splice(o.length-1,1),n.splice(n.length-1,1))}this._set_vertices(o,n)}},t.prototype._doubletap=function(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))},t.prototype._move=function(e){this._drawing&&this._draw(e,"edit")},t.prototype._remove=function(){var e=this.model.renderers[0],t=e.data_source,r=e.glyph,i=a.__read([r.xs.field,r.ys.field],2),o=i[0],n=i[1];if(o){var l=t.data[o].length-1,s=t.get_array(o)[l];s.splice(s.length-1,1)}if(n){var _=t.data[n].length-1,d=t.get_array(n)[_];d.splice(d.length-1,1)}this._emit_cds_changes(t)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame)try{for(var o=a.__values(this.model.renderers),n=o.next();!n.done;n=o.next()){var l=n.value;e.keyCode===i.Keys.Backspace?this._delete_selected(l):e.keyCode==i.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),l.data_source.selection_manager.clear())}}catch(e){t={error:e}}finally{try{n&&!n.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}},t.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])},t.prototype._pan=function(e){var t,r,i,o;if(null!=this._basepoint&&this.model.drag){var n=a.__read(this._basepoint,2),l=n[0],s=n[1];try{for(var _=a.__values(this.model.renderers),d=_.next();!d.done;d=_.next()){var h=d.value,y=this._map_drag(l,s,h),c=this._map_drag(e.sx,e.sy,h);if(null!=c&&null!=y){var p=h.data_source,f=h.glyph,v=a.__read([f.xs.field,f.ys.field],2),u=v[0],g=v[1];if(u||g){var m=a.__read(c,2),w=m[0],x=m[1],b=a.__read(y,2),P=b[0],T=b[1],D=a.__read([w-P,x-T],2),A=D[0],k=D[1];try{for(var z=(i=void 0,a.__values(p.selected.indices)),j=z.next();!j.done;j=z.next()){var V=j.value,B=void 0,C=void 0,K=void 0;u&&(C=p.data[u][V]),B=g?(K=p.data[g][V]).length:C.length;for(var E=0;E<B;E++)C&&(C[E]+=A),K&&(K[E]+=k)}}catch(e){i={error:e}}finally{try{j&&!j.done&&(o=z.return)&&o.call(z)}finally{if(i)throw i.error}}p.change.emit()}}}}catch(e){t={error:e}}finally{try{d&&!d.done&&(r=_.return)&&r.call(_)}finally{if(t)throw t.error}}this._basepoint=[e.sx,e.sy]}},t.prototype._pan_end=function(e){var t,r;if(this.model.drag){this._pan(e);try{for(var i=a.__values(this.model.renderers),o=i.next();!o.done;o=i.next()){var n=o.value;this._emit_cds_changes(n.data_source)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}this._basepoint=null}},t.prototype.activate=function(){var e,t,r=this;if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)try{for(var i=a.__values(this.model.renderers),o=i.next();!o.done;o=i.next()){var n=o.value.data_source;n.connect(n.properties.data.change,(function(){return r._show_vertices()}))}}catch(t){e={error:t}}finally{try{o&&!o.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}this._initialized=!0}},t.prototype.deactivate=function(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()},t}(l.PolyToolView);r.PolyDrawToolView=_,_.__name__="PolyDrawToolView";var d=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Polygon Draw Tool",r.icon=s.bk_tool_icon_poly_draw,r.event_type=["pan","tap","move"],r.default_order=3,r}return a.__extends(t,e),t.init_PolyDrawTool=function(){this.prototype.default_view=_,this.define({drag:[o.Boolean,!0],num_objects:[o.Int,0]})},t}(l.PolyTool);r.PolyDrawTool=d,d.__name__="PolyDrawTool",d.init_PolyDrawTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),o=i.__importStar(e(133)),n=e(123),_=e(471),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._set_vertices=function(e,t){var r=this.model.vertex_renderer.glyph,o=this.model.vertex_renderer.data_source,_=i.__read([r.x.field,r.y.field],2),l=_[0],a=_[1];l&&(n.isArray(e)?o.data[l]=e:r.x={value:e}),a&&(n.isArray(t)?o.data[a]=t:r.y={value:t}),this._emit_cds_changes(o,!0,!0,!1)},t.prototype._hide_vertices=function(){this._set_vertices([],[])},t.prototype._snap_to_vertex=function(e,t,r){if(this.model.vertex_renderer){var o=this._select_event(e,"replace",[this.model.vertex_renderer]),n=this.model.vertex_renderer.data_source,_=this.model.vertex_renderer.glyph,l=i.__read([_.x.field,_.y.field],2),a=l[0],d=l[1];if(o.length){var s=n.selected.indices[0];a&&(t=n.data[a][s]),d&&(r=n.data[d][s]),n.selection_manager.clear()}}return[t,r]},t}(_.EditToolView);r.PolyToolView=l,l.__name__="PolyToolView";var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_PolyTool=function(){this.prototype.default_view=l,this.define({vertex_renderer:[o.Instance]})},t}(_.EditTool);r.PolyTool=a,a.__name__="PolyTool",a.init_PolyTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),_=e(187),s=e(123),d=e(476),a=e(424),n=function(e){function t(){var t=e.apply(this,i.__spread(arguments))||this;return t._drawing=!1,t}return i.__extends(t,e),t.prototype._doubletap=function(e){if(this.model.active){var t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null!=t){var r=i.__read(t,2),_=r[0],s=r[1],d=this._select_event(e,"replace",[this.model.vertex_renderer]),a=this.model.vertex_renderer.data_source,n=this.model.vertex_renderer.glyph,l=i.__read([n.x.field,n.y.field],2),o=l[0],c=l[1];if(d.length&&null!=this._selected_renderer){var h=a.selected.indices[0];this._drawing?(this._drawing=!1,a.selection_manager.clear()):(a.selected.indices=[h+1],o&&a.get_array(o).splice(h+1,0,_),c&&a.get_array(c).splice(h+1,0,s),this._drawing=!0),a.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}}},t.prototype._show_vertices=function(e){if(this.model.active){var t=this._select_event(e,"replace",this.model.renderers);if(!t.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);var r,_,d=t[0],a=d.glyph,n=d.data_source,l=n.selected.indices[0],o=i.__read([a.xs.field,a.ys.field],2),c=o[0],h=o[1];c?(r=n.data[c][l],s.isArray(r)||(n.data[c][l]=r=Array.from(r))):r=a.xs.value,h?(_=n.data[h][l],s.isArray(_)||(n.data[h][l]=_=Array.from(_))):_=a.ys.value,this._selected_renderer=d,this._set_vertices(r,_)}},t.prototype._move=function(e){var t;if(this._drawing&&null!=this._selected_renderer){var r=this.model.vertex_renderer,_=r.data_source,s=r.glyph,d=this._map_drag(e.sx,e.sy,r);if(null==d)return;var a=i.__read(d,2),n=a[0],l=a[1],o=_.selected.indices;n=(t=i.__read(this._snap_to_vertex(e,n,l),2))[0],l=t[1],_.selected.indices=o;var c=i.__read([s.x.field,s.y.field],2),h=c[0],v=c[1],p=o[0];h&&(_.data[h][p]=n),v&&(_.data[v][p]=l),_.change.emit(),this._selected_renderer.data_source.change.emit()}},t.prototype._tap=function(e){var t,r=this.model.vertex_renderer,_=this._map_drag(e.sx,e.sy,r);if(null!=_){if(this._drawing&&this._selected_renderer){var s=i.__read(_,2),d=s[0],a=s[1],n=r.data_source,l=r.glyph,o=i.__read([l.x.field,l.y.field],2),c=o[0],h=o[1],v=n.selected.indices;d=(t=i.__read(this._snap_to_vertex(e,d,a),2))[0],a=t[1];var p=v[0];if(n.selected.indices=[p+1],c){var u=n.get_array(c),y=u[p];u[p]=d,u.splice(p+1,0,y)}if(h){var f=n.get_array(h),m=f[p];f[p]=a,f.splice(p+1,0,m)}return n.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}var g=this._select_mode(e);this._select_event(e,g,[r]),this._select_event(e,g,this.model.renderers)}},t.prototype._remove_vertex=function(){if(this._drawing&&this._selected_renderer){var e=this.model.vertex_renderer,t=e.data_source,r=e.glyph,_=t.selected.indices[0],s=i.__read([r.x.field,r.y.field],2),d=s[0],a=s[1];d&&t.get_array(d).splice(_,1),a&&t.get_array(a).splice(_,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}},t.prototype._pan_start=function(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]},t.prototype._pan=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame){var s;s=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;try{for(var d=i.__values(s),a=d.next();!a.done;a=d.next()){var n=a.value;e.keyCode===_.Keys.Backspace?(this._delete_selected(n),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==_.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),n.data_source.selection_manager.clear())}}catch(e){t={error:e}}finally{try{a&&!a.done&&(r=d.return)&&r.call(d)}finally{if(t)throw t.error}}}},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())},t}(d.PolyToolView);r.PolyEditToolView=n,n.__name__="PolyEditToolView";var l=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Poly Edit Tool",r.icon=a.bk_tool_icon_poly_edit,r.event_type=["tap","pan","move"],r.default_order=4,r}return i.__extends(t,e),t.init_PolyEditTool=function(){this.prototype.default_view=n},t}(d.PolyTool);r.PolyEditTool=l,l.__name__="PolyEditTool",l.init_PolyEditTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var i=e(1),n=e(479),_=e(239),l=i.__importStar(e(133)),s=e(424),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._compute_limits=function(e){var t=this.plot_view.frame,o=this.model.dimensions,n=this._base_point;if("center"==this.model.origin){var _=i.__read(n,2),l=_[0],s=_[1],r=i.__read(e,2);n=[l-(r[0]-l),s-(r[1]-s)]}return this.model._get_dim_limits(n,e,t,o)},t.prototype._pan_start=function(e){var t=e.sx,o=e.sy;this._base_point=[t,o]},t.prototype._pan=function(e){var t=[e.sx,e.sy],o=i.__read(this._compute_limits(t),2),n=o[0],_=o[1];this.model.overlay.update({left:n[0],right:n[1],top:_[0],bottom:_[1]}),this.model.select_every_mousemove&&this._do_select(n,_,!1,this._select_mode(e))},t.prototype._pan_end=function(e){var t=[e.sx,e.sy],o=i.__read(this._compute_limits(t),2),n=o[0],_=o[1];this._do_select(n,_,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})},t.prototype._do_select=function(e,t,o,n){var _=i.__read(e,2),l=_[0],s=_[1],r=i.__read(t,2);void 0===n&&(n="replace");var c={type:"rect",sx0:l,sx1:s,sy0:r[0],sy1:r[1]};this._select(c,o,n)},t}(n.SelectToolView);o.BoxSelectToolView=r,r.__name__="BoxSelectToolView";var c=function(){return new _.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})},a=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Box Select",o.icon=s.bk_tool_icon_box_select,o.event_type="pan",o.default_order=30,o}return i.__extends(t,e),t.init_BoxSelectTool=function(){this.prototype.default_view=r,this.define({dimensions:[l.Dimensions,"both"],select_every_mousemove:[l.Boolean,!1],overlay:[l.Instance,c],origin:[l.BoxOrigin,"corner"]}),this.register_alias("box_select",(function(){return new t})),this.register_alias("xbox_select",(function(){return new t({dimensions:"width"})})),this.register_alias("ybox_select",(function(){return new t({dimensions:"height"})}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(n.SelectTool);o.BoxSelectTool=a,a.__name__="BoxSelectTool",a.init_BoxSelectTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),o=e(421),i=e(205),c=e(231),a=e(480),l=n.__importStar(e(133)),s=e(187),u=e(428),_=e(130),d=e(126),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.model.clear.connect((function(){return t._clear()}))},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){var e=this.model.renderers,t=this.plot_model.renderers,r=this.model.names;return a.compute_renderers(e,t,r)},enumerable:!0,configurable:!0}),t.prototype._computed_renderers_by_data_source=function(){var e,t,r,o=new Map;try{for(var a=n.__values(this.computed_renderers),l=a.next();!l.done;l=a.next()){var s=l.value,u=void 0;if(s instanceof i.GlyphRenderer)u=s.data_source;else{if(!(s instanceof c.GraphRenderer))continue;u=s.node_renderer.data_source}var _=null!==(r=o.get(u))&&void 0!==r?r:[];o.set(u,n.__spread(_,[s]))}}catch(t){e={error:t}}finally{try{l&&!l.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}return o},t.prototype._select_mode=function(e){var t=e.shiftKey,r=e.ctrlKey;return t||r?t&&!r?"append":!t&&r?"intersect":t&&r?"subtract":void d.unreachable():this.model.mode},t.prototype._keyup=function(e){e.keyCode==s.Keys.Esc&&this._clear()},t.prototype._clear=function(){var e,t;try{for(var r=n.__values(this.computed_renderers),o=r.next();!o.done;o=r.next()){o.value.get_selection_manager().clear()}}catch(t){e={error:t}}finally{try{o&&!o.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}this.plot_view.request_render()},t.prototype._select=function(e,t,r){var o,i,c,a,l=this._computed_renderers_by_data_source();try{for(var s=n.__values(l),u=s.next();!u.done;u=s.next()){var _=n.__read(u.value,2)[1],d=_[0].get_selection_manager(),p=[];try{for(var v=(c=void 0,n.__values(_)),f=v.next();!f.done;f=v.next()){var y=f.value,h=this.plot_view.renderer_views.get(y);null!=h&&p.push(h)}}catch(e){c={error:e}}finally{try{f&&!f.done&&(a=v.return)&&a.call(v)}finally{if(c)throw c.error}}d.select(p,e,t,r)}}catch(e){o={error:e}}finally{try{u&&!u.done&&(i=s.return)&&i.call(s)}finally{if(o)throw o.error}}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)},t.prototype._emit_selection_event=function(e,t){void 0===t&&(t=!0);var r,o=this.plot_view.frame,i=o.x_scale,c=o.y_scale;switch(e.type){case"point":var a=e.sx,l=e.sy,s=i.invert(a),_=c.invert(l);r=Object.assign(Object.assign({},e),{x:s,y:_});break;case"span":a=e.sx,l=e.sy,s=i.invert(a),_=c.invert(l);r=Object.assign(Object.assign({},e),{x:s,y:_});break;case"rect":var d=e.sx0,p=e.sx1,v=e.sy0,f=e.sy1,y=n.__read(i.r_invert(d,p),2),h=y[0],m=y[1],b=n.__read(c.r_invert(v,f),2),g=b[0],x=b[1];r=Object.assign(Object.assign({},e),{x0:h,y0:g,x1:m,y1:x});break;case"poly":a=e.sx,l=e.sy,s=i.v_invert(a),_=c.v_invert(l);r=Object.assign(Object.assign({},e),{x:s,y:_})}this.plot_model.trigger_event(new u.SelectionGeometry(r,t))},t}(o.GestureToolView);r.SelectToolView=p,p.__name__="SelectToolView";var v=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.clear=new _.Signal0(this,"clear")},t.init_SelectTool=function(){this.define({renderers:[l.Any,"auto"],names:[l.Array,[]],mode:[l.Any,"replace"]})},Object.defineProperty(t.prototype,"menu",{get:function(){var e=this;return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:function(){return"replace"==e.mode},handler:function(){e.mode="replace",e.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:function(){return"append"==e.mode},handler:function(){e.mode="append",e.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:function(){return"intersect"==e.mode},handler:function(){e.mode="intersect",e.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:function(){return"subtract"==e.mode},handler:function(){e.mode="subtract",e.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:function(){e.clear.emit()}}]},enumerable:!0,configurable:!0}),t}(o.GestureTool);r.SelectTool=v,v.__name__="SelectTool",v.init_SelectTool()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(124);r.compute_renderers=function(e,n,r){if(null==e)return[];var u="auto"==e?n:e;return r.length>0&&(u=u.filter((function(e){return t.includes(r,e.name)}))),u}},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var n=t(1),r=t(421),i=t(239),a=n.__importStar(t(133)),_=t(424),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._match_aspect=function(t,e,o){var r,i,a,_,s=o.bbox.aspect,l=o.bbox.h_range.end,u=o.bbox.h_range.start,h=o.bbox.v_range.end,p=o.bbox.v_range.start,c=Math.abs(t[0]-e[0]),d=Math.abs(t[1]-e[1]),m=0==d?0:c/d,f=n.__read(m>=s?[1,m/s]:[s/m,1],1)[0];return t[0]<=e[0]?(r=t[0],(i=t[0]+c*f)>l&&(i=l)):(i=t[0],(r=t[0]-c*f)<u&&(r=u)),c=Math.abs(i-r),t[1]<=e[1]?(_=t[1],(a=t[1]+c/s)>h&&(a=h)):(a=t[1],(_=t[1]-c/s)<p&&(_=p)),d=Math.abs(a-_),t[0]<=e[0]?i=t[0]+s*d:r=t[0]-s*d,[[r,i],[_,a]]},e.prototype._compute_limits=function(t){var e,o,r,i,a=this.plot_view.frame,_=this.model.dimensions,s=this._base_point;if("center"==this.model.origin){var l=n.__read(s,2),u=l[0],h=l[1],p=n.__read(t,2);s=[u-(p[0]-u),h-(p[1]-h)]}return this.model.match_aspect&&"both"==_?(r=(e=n.__read(this._match_aspect(s,t,a),2))[0],i=e[1]):(r=(o=n.__read(this.model._get_dim_limits(s,t,a,_),2))[0],i=o[1]),[r,i]},e.prototype._pan_start=function(t){this._base_point=[t.sx,t.sy]},e.prototype._pan=function(t){var e=[t.sx,t.sy],o=n.__read(this._compute_limits(e),2),r=o[0],i=o[1];this.model.overlay.update({left:r[0],right:r[1],top:i[0],bottom:i[1]})},e.prototype._pan_end=function(t){var e=[t.sx,t.sy],o=n.__read(this._compute_limits(e),2),r=o[0],i=o[1];this._update(r,i),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null},e.prototype._update=function(t,e){var o,r,i,a,_=n.__read(t,2),s=_[0],l=_[1],u=n.__read(e,2),h=u[0],p=u[1];if(!(Math.abs(l-s)<=5||Math.abs(p-h)<=5)){var c=this.plot_view.frame,d=c.x_scales,m=c.y_scales,f=new Map;try{for(var b=n.__values(d),v=b.next();!v.done;v=b.next()){var x=n.__read(v.value,2),y=x[0],g=x[1],w=n.__read(g.r_invert(s,l),2),B=w[0],M=w[1];f.set(y,{start:B,end:M})}}catch(t){o={error:t}}finally{try{v&&!v.done&&(r=b.return)&&r.call(b)}finally{if(o)throw o.error}}var T=new Map;try{for(var Z=n.__values(m),z=Z.next();!z.done;z=Z.next()){var O=n.__read(z.value,2),V=(y=O[0],g=O[1],n.__read(g.r_invert(h,p),2));B=V[0],M=V[1];T.set(y,{start:B,end:M})}}catch(t){i={error:t}}finally{try{z&&!z.done&&(a=Z.return)&&a.call(Z)}finally{if(i)throw i.error}}var j={xrs:f,yrs:T};this.plot_view.push_state("box_zoom",{range:j}),this.plot_view.update_range(j)}},e}(r.GestureToolView);o.BoxZoomToolView=s,s.__name__="BoxZoomToolView";var l=function(){return new i.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})},u=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Box Zoom",o.icon=_.bk_tool_icon_box_zoom,o.event_type="pan",o.default_order=20,o}return n.__extends(e,t),e.init_BoxZoomTool=function(){this.prototype.default_view=s,this.define({dimensions:[a.Dimensions,"both"],overlay:[a.Instance,l],match_aspect:[a.Boolean,!1],origin:[a.BoxOrigin,"corner"]}),this.register_alias("box_zoom",(function(){return new e({dimensions:"both"})})),this.register_alias("xbox_zoom",(function(){return new e({dimensions:"width"})})),this.register_alias("ybox_zoom",(function(){return new e({dimensions:"height"})}))},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),e}(r.GestureTool);o.BoxZoomTool=u,u.__name__="BoxZoomTool",u.init_BoxZoomTool()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var s=t(1),i=t(479),a=t(483),n=t(187),l=s.__importStar(t(133)),_=t(424),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data=null},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return e._active_change()}))},e.prototype._active_change=function(){this.model.active||this._clear_overlay()},e.prototype._keyup=function(t){t.keyCode==n.Keys.Enter&&this._clear_overlay()},e.prototype._pan_start=function(t){var e=t.sx,o=t.sy;this.data={sx:[e],sy:[o]}},e.prototype._pan=function(t){var e=t.sx,o=t.sy,i=s.__read(this.plot_view.frame.bbox.clip(e,o),2),a=i[0],n=i[1];this.data.sx.push(a),this.data.sy.push(n),this.model.overlay.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove&&this._do_select(this.data.sx,this.data.sy,!1,this._select_mode(t))},e.prototype._pan_end=function(t){this._clear_overlay(),this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(t)),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})},e.prototype._clear_overlay=function(){this.model.overlay.update({xs:[],ys:[]})},e.prototype._do_select=function(t,e,o,s){var i={type:"poly",sx:t,sy:e};this._select(i,o,s)},e}(i.SelectToolView);o.LassoSelectToolView=c,c.__name__="LassoSelectToolView";var r=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Lasso Select",o.icon=_.bk_tool_icon_lasso_select,o.event_type="pan",o.default_order=12,o}return s.__extends(e,t),e.init_LassoSelectTool=function(){this.prototype.default_view=c,this.define({select_every_mousemove:[l.Boolean,!0],overlay:[l.Instance,a.DEFAULT_POLY_OVERLAY]}),this.register_alias("lasso_select",(function(){return new e}))},e}(i.SelectTool);o.LassoSelectTool=r,r.__name__="LassoSelectTool",r.init_LassoSelectTool()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),l=t(479),n=t(281),s=t(187),a=i.__importStar(t(133)),_=t(124),c=t(424),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data={sx:[],sy:[]}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return e._active_change()}))},e.prototype._active_change=function(){this.model.active||this._clear_data()},e.prototype._keyup=function(t){t.keyCode==s.Keys.Enter&&this._clear_data()},e.prototype._doubletap=function(t){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(t)),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()},e.prototype._clear_data=function(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})},e.prototype._tap=function(t){var e=t.sx,o=t.sy;this.plot_view.frame.bbox.contains(e,o)&&(this.data.sx.push(e),this.data.sy.push(o),this.model.overlay.update({xs:_.copy(this.data.sx),ys:_.copy(this.data.sy)}))},e.prototype._do_select=function(t,e,o,i){var l={type:"poly",sx:t,sy:e};this._select(l,o,i)},e}(l.SelectToolView);o.PolySelectToolView=r,r.__name__="PolySelectToolView",o.DEFAULT_POLY_OVERLAY=function(){return new n.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})};var p=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Poly Select",o.icon=c.bk_tool_icon_polygon_select,o.event_type="tap",o.default_order=11,o}return i.__extends(e,t),e.init_PolySelectTool=function(){this.prototype.default_view=r,this.define({overlay:[a.Instance,o.DEFAULT_POLY_OVERLAY]}),this.register_alias("poly_select",(function(){return new e}))},e}(l.SelectTool);o.PolySelectTool=p,p.__name__="PolySelectTool",p.init_PolySelectTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),n=e(485),s=r.__importStar(e(133)),_=e(424),o=function(e){function t(){var t=e.apply(this,r.__spread(arguments))||this;return t._drawing=!1,t}return r.__extends(t,e),t.prototype._doubletap=function(e){var t,i;if(this.model.active){var n=this.model.renderers;try{for(var s=r.__values(n),_=s.next();!_.done;_=s.next()){var o=_.value;1==this._select_event(e,"replace",[o]).length&&(this._selected_renderer=o)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(i=s.return)&&i.call(s)}finally{if(t)throw t.error}}this._show_intersections(),this._update_line_cds()}},t.prototype._show_intersections=function(){if(this.model.active&&null!=this._selected_renderer){if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);var e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,i=r.__read([t.x.field,t.y.field],2),n=i[0],s=i[1],_=e.get_array(n),o=e.get_array(s);this._set_intersection(_,o)}},t.prototype._tap=function(e){var t=this.model.intersection_renderer;if(null!=this._map_drag(e.sx,e.sy,t)){if(this._drawing&&this._selected_renderer){var i=this._select_mode(e);if(0==this._select_event(e,i,[t]).length)return}var r=this._select_mode(e);this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}},t.prototype._update_line_cds=function(){if(null!=this._selected_renderer){var e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,i=r.__read([e.x.field,e.y.field],2),n=i[0],s=i[1];if(n&&s){var _=t.data[n],o=t.data[s];this._selected_renderer.data_source.data[n]=_,this._selected_renderer.data_source.data[s]=o}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}},t.prototype._pan_start=function(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]},t.prototype._pan=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype.activate=function(){this._drawing=!0},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())},t}(n.LineToolView);i.LineEditToolView=o,o.__name__="LineEditToolView";var d=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Line Edit Tool",i.icon=_.bk_tool_icon_line_edit,i.event_type=["tap","pan","move"],i.default_order=4,i}return r.__extends(t,e),t.init_LineEditTool=function(){this.prototype.default_view=o,this.define({dimensions:[s.Dimensions,"both"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(n.LineTool);i.LineEditTool=d,d.__name__="LineEditTool",d.init_LineEditTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),o=n.__importStar(e(133)),r=e(123),_=e(471),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype._set_intersection=function(e,t){var i=this.model.intersection_renderer.glyph,o=this.model.intersection_renderer.data_source,_=n.__read([i.x.field,i.y.field],2),s=_[0],a=_[1];s&&(r.isArray(e)?o.data[s]=e:i.x={value:e}),a&&(r.isArray(t)?o.data[a]=t:i.y={value:t}),this._emit_cds_changes(o,!0,!0,!1)},t.prototype._hide_intersections=function(){this._set_intersection([],[])},t}(_.EditToolView);i.LineToolView=s,s.__name__="LineToolView";var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_LineTool=function(){this.prototype.default_view=s,this.define({intersection_renderer:[o.Instance]})},t}(_.EditTool);i.LineTool=a,a.__name__="LineTool",a.init_LineTool()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),o=t(421),s=i.__importStar(t(133)),a=t(424);function r(t,n,e){var o,s,a=new Map;try{for(var r=i.__values(t),_=r.next();!_.done;_=r.next()){var l=i.__read(_.value,2),h=l[0],d=l[1],u=i.__read(d.r_invert(n,e),2),p=u[0],c=u[1];a.set(h,{start:p,end:c})}}catch(t){o={error:t}}finally{try{_&&!_.done&&(s=r.return)&&s.call(r)}finally{if(o)throw o.error}}return a}e.update_ranges=r;var _=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var n=t.sx,e=t.sy,i=this.plot_view.frame.bbox;if(!i.contains(n,e)){var o=i.h_range,s=i.v_range;(n<o.start||n>o.end)&&(this.v_axis_only=!0),(e<s.start||e>s.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},n.prototype._pan=function(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},n.prototype._pan_end=function(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})},n.prototype._update=function(t,n){var e,i,o,s,a,_,l=this.plot_view.frame,h=t-this.last_dx,d=n-this.last_dy,u=l.bbox.h_range,p=u.start-h,c=u.end-h,f=l.bbox.v_range,y=f.start-d,m=f.end-d,v=this.model.dimensions;"width"!=v&&"both"!=v||this.v_axis_only?(e=u.start,i=u.end,o=0):(e=p,i=c,o=-h),"height"!=v&&"both"!=v||this.h_axis_only?(s=f.start,a=f.end,_=0):(s=y,a=m,_=-d),this.last_dx=t,this.last_dy=n;var x=l.x_scales,b=l.y_scales,g=r(x,e,i),w=r(b,s,a);this.pan_info={xrs:g,yrs:w,sdx:o,sdy:_},this.plot_view.update_range(this.pan_info,!0)},n}(o.GestureToolView);e.PanToolView=_,_.__name__="PanToolView";var l=function(t){function n(n){var e=t.call(this,n)||this;return e.tool_name="Pan",e.event_type="pan",e.default_order=10,e}return i.__extends(n,t),n.init_PanTool=function(){this.prototype.default_view=_,this.define({dimensions:[s.Dimensions,"both"]}),this.register_alias("pan",(function(){return new n({dimensions:"both"})})),this.register_alias("xpan",(function(){return new n({dimensions:"width"})})),this.register_alias("ypan",(function(){return new n({dimensions:"height"})}))},Object.defineProperty(n.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Pan",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"icon",{get:function(){switch(this.dimensions){case"both":return a.bk_tool_icon_pan;case"width":return a.bk_tool_icon_xpan;case"height":return a.bk_tool_icon_ypan}},enumerable:!0,configurable:!0}),n}(o.GestureTool);e.PanTool=l,l.__name__="PanTool",l.init_PanTool()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),s=t(239),r=t(134),l=n.__importStar(t(133)),a=t(421),o=t(424);function _(t){switch(t){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return t}}function h(t,e,i,n){if(null==e)return!1;var s=i.compute(e);return Math.abs(t-s)<n}function d(t,e,i,n,s){var r=!0;if(null!=s.left&&null!=s.right){var l=i.invert(t);(l<s.left||l>s.right)&&(r=!1)}if(null!=s.bottom&&null!=s.top){var a=n.invert(e);(a<s.bottom||a>s.top)&&(r=!1)}return r}function u(t,e,i){var n=0;return t>=i.start&&t<=i.end&&(n+=1),e>=i.start&&e<=i.end&&(n+=1),n}function c(t,e,i,n){var s=e.compute(t),r=e.invert(s+i);return r>=n.start&&r<=n.end?r:t}function y(t,e,i){return t>e.start?(e.end=t,i):(e.end=e.start,e.start=t,_(i))}function g(t,e,i){return t<e.end?(e.start=t,i):(e.start=e.end,e.end=t,_(i))}function f(t,e,i,s){var r=n.__read(e.r_compute(t.start,t.end),2),l=r[0],a=r[1],o=n.__read(e.r_invert(l+i,a+i),2),_=o[0],h=o[1],d=u(t.start,t.end,s);u(_,h,s)>=d&&(t.start=_,t.end=h)}i.flip_side=_,i.is_near=h,i.is_inside=d,i.sides_inside=u,i.compute_value=c,i.update_range_end_side=y,i.update_range_start_side=g,i.update_range=f;var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.side=0,this.model.update_overlay_from_ranges()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),null!=this.model.x_range&&this.connect(this.model.x_range.change,(function(){return e.model.update_overlay_from_ranges()})),null!=this.model.y_range&&this.connect(this.model.y_range.change,(function(){return e.model.update_overlay_from_ranges()}))},e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=this.model.x_range,i=this.model.y_range,n=this.plot_view.frame,r=n.x_scale,l=n.y_scale,a=this.model.overlay,o=a.left,_=a.right,u=a.top,c=a.bottom,y=this.model.overlay.properties.line_width.value()+s.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(h(t.sx,o,r,y)?this.side=1:h(t.sx,_,r,y)?this.side=2:d(t.sx,t.sy,r,l,a)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&h(t.sy,c,l,y)&&(this.side=4),0==this.side&&h(t.sy,u,l,y)?this.side=5:d(t.sx,t.sy,r,l,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))},e.prototype._pan=function(t){var e=this.plot_view.frame,i=t.deltaX-this.last_dx,n=t.deltaY-this.last_dy,s=this.model.x_range,r=this.model.y_range,l=e.x_scale,a=e.y_scale;if(null!=s)if(3==this.side||7==this.side)f(s,l,i,e.x_range);else if(1==this.side){var o=c(s.start,l,i,e.x_range);this.side=g(o,s,this.side)}else if(2==this.side){var _=c(s.end,l,i,e.x_range);this.side=y(_,s,this.side)}if(null!=r)if(6==this.side||7==this.side)f(r,a,n,e.y_range);else if(4==this.side){o=c(r.start,a,n,e.y_range);this.side=g(o,r,this.side)}else if(5==this.side){_=c(r.end,a,n,e.y_range);this.side=y(_,r,this.side)}this.last_dx=t.deltaX,this.last_dy=t.deltaY},e.prototype._pan_end=function(t){this.side=0},e}(a.GestureToolView);i.RangeToolView=p,p.__name__="RangeToolView";var v=function(){return new s.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]})},m=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Range Tool",i.icon=o.bk_tool_icon_range,i.event_type="pan",i.default_order=1,i}return n.__extends(e,t),e.init_RangeTool=function(){this.prototype.default_view=p,this.define({x_range:[l.Instance,null],x_interaction:[l.Boolean,!0],y_range:[l.Instance,null],y_interaction:[l.Boolean,!0],overlay:[l.Instance,v]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null},e.prototype.update_overlay_from_ranges=function(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,r.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)},e}(a.GestureTool);i.RangeTool=m,m.__name__="RangeTool",m.init_RangeTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),o=e(479),n=i.__importStar(e(133)),s=e(424),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._tap=function(e){var t={type:"point",sx:e.sx,sy:e.sy};this._select(t,!0,this._select_mode(e))},t.prototype._select=function(e,t,r){var o,n,s,a,l=this,_=this.model.callback;if("select"==this.model.behavior){var c=this._computed_renderers_by_data_source();try{for(var u=i.__values(c),p=u.next();!p.done;p=u.next()){var v=i.__read(p.value,2)[1],h=v[0].get_selection_manager(),d=v.map((function(e){return l.plot_view.renderer_views.get(e)}));if(h.select(d,e,t,r)&&null!=_){var f=d[0].coordinates.x_scale.invert(e.sx),y=d[0].coordinates.y_scale.invert(e.sy),m={geometries:Object.assign(Object.assign({},e),{x:f,y:y}),source:h.source};_.execute(this.model,m)}}}catch(e){o={error:e}}finally{try{p&&!p.done&&(n=u.return)&&n.call(u)}finally{if(o)throw o.error}}this._emit_selection_event(e),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else try{for(var x=i.__values(this.computed_renderers),T=x.next();!T.done;T=x.next()){var g=T.value,w=this.plot_view.renderer_views.get(g);if((h=g.get_selection_manager()).inspect(w,e)&&null!=_){f=w.coordinates.x_scale.invert(e.sx),y=w.coordinates.y_scale.invert(e.sy),m={geometries:Object.assign(Object.assign({},e),{x:f,y:y}),source:h.source};_.execute(this.model,m)}}}catch(e){s={error:e}}finally{try{T&&!T.done&&(a=x.return)&&a.call(x)}finally{if(s)throw s.error}}},t}(o.SelectToolView);r.TapToolView=a,a.__name__="TapToolView";var l=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Tap",r.icon=s.bk_tool_icon_tap_select,r.event_type="tap",r.default_order=10,r}return i.__extends(t,e),t.init_TapTool=function(){this.prototype.default_view=a,this.define({behavior:[n.TapBehavior,"select"],callback:[n.Any]}),this.register_alias("click",(function(){return new t({behavior:"inspect"})})),this.register_alias("tap",(function(){return new t}))},t}(o.SelectTool);r.TapTool=l,l.__name__="TapTool",l.init_TapTool()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),o=e(421),a=i.__importStar(e(133)),r=e(424),s=e(486),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._scroll=function(e){var t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)},t.prototype._update_ranges=function(e){var t,n,o,a,r=this.plot_view.frame,l=r.bbox.h_range,_=r.bbox.v_range,h=i.__read([l.start,l.end],2),d=h[0],u=h[1],p=i.__read([_.start,_.end],2),c=p[0],m=p[1];switch(this.model.dimension){case"height":var f=Math.abs(m-c);t=d,n=u,o=c-f*e,a=m-f*e;break;case"width":var w=Math.abs(u-d);t=d-w*e,n=u-w*e,o=c,a=m;break;default:throw new Error("this shouldn't have happened")}var v=r.x_scales,g=r.y_scales,b={xrs:s.update_ranges(v,t,n),yrs:s.update_ranges(g,o,a),factor:e};this.plot_view.push_state("wheel_pan",{range:b}),this.plot_view.update_range(b,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},t}(o.GestureToolView);n.WheelPanToolView=l,l.__name__="WheelPanToolView";var _=function(e){function t(t){var n=e.call(this,t)||this;return n.tool_name="Wheel Pan",n.icon=r.bk_tool_icon_wheel_pan,n.event_type="scroll",n.default_order=12,n}return i.__extends(t,e),t.init_WheelPanTool=function(){this.prototype.default_view=l,this.define({dimension:[a.Dimension,"width"]}),this.internal({speed:[a.Number,.001]}),this.register_alias("xwheel_pan",(function(){return new t({dimension:"width"})})),this.register_alias("ywheel_pan",(function(){return new t({dimension:"height"})}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimension)},enumerable:!0,configurable:!0}),t}(o.GestureTool);n.WheelPanTool=_,_.__name__="WheelPanTool",_.init_WheelPanTool()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),n=e(421),s=e(469),l=i.__importStar(e(133)),r=e(147),_=e(424),h=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(o,e),o.prototype._pinch=function(e){var o,t=e.sx,i=e.sy,n=e.scale,s=e.ctrlKey,l=e.shiftKey;o=n>=1?20*(n-1):-20/n,this._scroll({type:"wheel",sx:t,sy:i,delta:o,ctrlKey:s,shiftKey:l})},o.prototype._scroll=function(e){var o=this.plot_view.frame,t=o.bbox.h_range,i=o.bbox.v_range,n=e.sx,l=e.sy,r=this.model.dimensions,_=("width"==r||"both"==r)&&t.start<n&&n<t.end,h=("height"==r||"both"==r)&&i.start<l&&l<i.end;if(_&&h||this.model.zoom_on_axis){var a=this.model.speed*e.delta,m=s.scale_range(o,a,_,h,{x:n,y:l});this.plot_view.push_state("wheel_zoom",{range:m}),this.plot_view.update_range(m,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}},o}(n.GestureToolView);t.WheelZoomToolView=h,h.__name__="WheelZoomToolView";var a=function(e){function o(o){var t=e.call(this,o)||this;return t.tool_name="Wheel Zoom",t.icon=_.bk_tool_icon_wheel_zoom,t.event_type=r.is_mobile?"pinch":"scroll",t.default_order=10,t}return i.__extends(o,e),o.init_WheelZoomTool=function(){this.prototype.default_view=h,this.define({dimensions:[l.Dimensions,"both"],maintain_focus:[l.Boolean,!0],zoom_on_axis:[l.Boolean,!0],speed:[l.Number,1/600]}),this.register_alias("wheel_zoom",(function(){return new o({dimensions:"both"})})),this.register_alias("xwheel_zoom",(function(){return new o({dimensions:"width"})})),this.register_alias("ywheel_zoom",(function(){return new o({dimensions:"height"})}))},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),o}(n.GestureTool);t.WheelZoomTool=a,a.__name__="WheelZoomTool",a.init_WheelZoomTool()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});var o=i(1),n=i(410),s=i(283),r=o.__importStar(i(133)),l=i(128),a=i(424),h=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return o.__extends(e,i),e.prototype._move=function(i){if(this.model.active){var e=i.sx,t=i.sy;this.plot_view.frame.bbox.contains(e,t)?this._update_spans(e,t):this._update_spans(null,null)}},e.prototype._move_exit=function(i){this._update_spans(null,null)},e.prototype._update_spans=function(i,e){var t=this.model.dimensions;"width"!=t&&"both"!=t||(this.model.spans.width.location=e),"height"!=t&&"both"!=t||(this.model.spans.height.location=i)},e}(n.InspectToolView);t.CrosshairToolView=h,h.__name__="CrosshairToolView";var _=function(i){function e(e){var t=i.call(this,e)||this;return t.tool_name="Crosshair",t.icon=a.bk_tool_icon_crosshair,t}return o.__extends(e,i),e.init_CrosshairTool=function(){this.prototype.default_view=h,this.define({dimensions:[r.Dimensions,"both"],line_color:[r.Color,"black"],line_width:[r.Number,1],line_alpha:[r.Number,1]}),this.internal({spans:[r.Any]}),this.register_alias("crosshair",(function(){return new e}))},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Crosshair",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return l.values(this.spans)},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){i.prototype.initialize.call(this),this.spans={width:new s.Span({for_hover:!0,dimension:"width",location_units:"screen",level:"overlay",line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new s.Span({for_hover:!0,dimension:"height",location_units:"screen",level:"overlay",line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}},e}(n.InspectTool);t.CrosshairTool=_,_.__name__="CrosshairTool",_.init_CrosshairTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),r=e(196),i=n.__importStar(e(133)),s=e(128),u=e(144),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_CustomJSHover=function(){this.define({args:[i.Any,{}],code:[i.String,""]})},Object.defineProperty(t.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),t.prototype._make_code=function(e,t,o,r){return new(Function.bind.apply(Function,n.__spread([void 0],s.keys(this.args),[e,t,o,u.use_strict(r)])))},t.prototype.format=function(e,t,o){return this._make_code("value","format","special_vars",this.code).apply(void 0,n.__spread(this.values,[e,t,o]))},t}(r.Model);o.CustomJSHover=a,a.__name__="CustomJSHover",a.init_CustomJSHover()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),o=e(410),i=e(286),a=e(205),l=e(231),s=e(480),_=n.__importStar(e(216)),d=e(302),c=e(187),p=n.__importStar(e(133)),u=e(137),h=e(128),y=e(418),v=e(123),f=e(230),m=e(424),x=e(287);function w(e,t,r,n,o,i){var a,l,s={x:o[e],y:i[e]},d={x:o[e+1],y:i[e+1]};if("span"==t.type)"h"==t.direction?(a=Math.abs(s.x-r),l=Math.abs(d.x-r)):(a=Math.abs(s.y-n),l=Math.abs(d.y-n));else{var c={x:r,y:n};a=_.dist_2_pts(s,c),l=_.dist_2_pts(d,c)}return a<l?[[s.x,s.y],e]:[[d.x,d.y],e+1]}function b(e,t,r){return[[e[r],t[r]],r]}r._nearest_line_hit=w,r._line_hit=b;var g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this._ttmodels=null,this._ttviews=new Map;var t=this.model.tooltips;v.isArray(t)&&(this._template_el=this._create_template(t))},t.prototype.remove=function(){f.remove_views(this._ttviews),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t,r,o=this;e.prototype.connect_signals.call(this);try{for(var i=n.__values(this.computed_renderers),s=i.next();!s.done;s=i.next()){var _=s.value;_ instanceof a.GlyphRenderer?this.connect(_.data_source.inspect,this._update):_ instanceof l.GraphRenderer&&(this.connect(_.node_renderer.data_source.inspect,this._update),this.connect(_.edge_renderer.data_source.inspect,this._update))}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}this.connect(this.model.properties.renderers.change,(function(){return o._computed_renderers=o._ttmodels=null})),this.connect(this.model.properties.names.change,(function(){return o._computed_renderers=o._ttmodels=null})),this.connect(this.model.properties.tooltips.change,(function(){return o._ttmodels=null}))},t.prototype._compute_ttmodels=function(){var e,t,r=this,o=new Map,s=this.model.tooltips;if(null!=s)try{for(var _=n.__values(this.computed_renderers),d=_.next();!d.done;d=_.next()){var c=d.value,p=new i.Tooltip({custom:v.isString(s)||v.isFunction(s),attachment:this.model.attachment,show_arrow:this.model.show_arrow});c instanceof a.GlyphRenderer?o.set(c,p):c instanceof l.GraphRenderer&&(o.set(c.node_renderer,p),o.set(c.edge_renderer,p))}}catch(t){e={error:t}}finally{try{d&&!d.done&&(t=_.return)&&t.call(_)}finally{if(e)throw e.error}}return n.__awaiter(r,void 0,void 0,(function(){var e,t,r,i,a;return n.__generator(this,(function(l){switch(l.label){case 0:return[4,f.build_views(this._ttviews,n.__spread(o.values()),{parent:this.plot_view})];case 1:e=l.sent();try{for(t=n.__values(e),r=t.next();!r.done;r=t.next())r.value.render()}catch(e){i={error:e}}finally{try{r&&!r.done&&(a=t.return)&&a.call(t)}finally{if(i)throw i.error}}return[2]}}))})),o},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){if(null==this._computed_renderers){var e=this.model.renderers,t=this.plot_model.renderers,r=this.model.names;this._computed_renderers=s.compute_renderers(e,t,r)}return this._computed_renderers},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ttmodels",{get:function(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels},enumerable:!0,configurable:!0}),t.prototype._clear=function(){var e,t;this._inspect(1/0,1/0);try{for(var r=n.__values(this.ttmodels),o=r.next();!o.done;o=r.next()){n.__read(o.value,2)[1].clear()}}catch(t){e={error:t}}finally{try{o&&!o.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}},t.prototype._move=function(e){if(this.model.active){var t=e.sx,r=e.sy;this.plot_view.frame.bbox.contains(t,r)?this._inspect(t,r):this._clear()}},t.prototype._move_exit=function(){this._clear()},t.prototype._inspect=function(e,t){var r,o,i;"mouse"==this.model.mode?i={type:"point",sx:e,sy:t}:i={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t};try{for(var a=n.__values(this.computed_renderers),l=a.next();!l.done;l=a.next()){var s=l.value;s.get_selection_manager().inspect(this.plot_view.renderer_views.get(s),i)}}catch(e){r={error:e}}finally{try{l&&!l.done&&(o=a.return)&&o.call(a)}finally{if(r)throw r.error}}null!=this.model.callback&&this._emit_callback(i)},t.prototype._update=function(e){var t,r,o,i,l,s,_,d,p,u,y,v,f,m,x,g,k,A,C,T,G,M,R,S,H,$,P=n.__read(e,2),O=P[0],j=P[1].geometry;if(this.model.active&&O instanceof a.GlyphRendererView){var V=O.model;if(!("ignore"==this.model.muted_policy&&V instanceof a.GlyphRenderer&&V.muted)){var q=this.ttmodels.get(V);if(null!=q){var z=V.get_selection_manager(),E=z.inspectors.get(V);if(V instanceof a.GlyphRenderer&&(E=V.view.convert_selection_to_subset(E)),E.is_empty())q.clear();else{var F=z.source,I=j.sx,N=j.sy,B=O.coordinates.x_scale,L=O.coordinates.y_scale,D=B.invert(I),J=L.invert(N),K=O.glyph,Q=[];try{for(var U=n.__values(E.line_indices),W=U.next();!W.done;W=U.next()){var X=W.value,Y=K._x[X+1],Z=K._y[X+1],ee=X,te=void 0,re=void 0;switch(this.model.line_policy){case"interp":Y=(o=n.__read(K.get_interpolation_hit(X,j),2))[0],Z=o[1],te=B.compute(Y),re=L.compute(Z);break;case"prev":i=n.__read(b(K.sx,K.sy,X),2),te=(l=n.__read(i[0],2))[0],re=l[1],ee=i[1];break;case"next":s=n.__read(b(K.sx,K.sy,X+1),2),te=(_=n.__read(s[0],2))[0],re=_[1],ee=s[1];break;case"nearest":d=n.__read(w(X,j,I,N,K.sx,K.sy),2),te=(p=n.__read(d[0],2))[0],re=p[1],ee=d[1],Y=K._x[ee],Z=K._y[ee];break;default:te=(u=n.__read([I,N],2))[0],re=u[1]}var ne={index:ee,x:D,y:J,sx:I,sy:N,data_x:Y,data_y:Z,rx:te,ry:re,indices:E.line_indices,name:O.model.name};Q.push([te,re,this._render_tooltips(F,ee,ne)])}}catch(e){t={error:e}}finally{try{W&&!W.done&&(r=U.return)&&r.call(U)}finally{if(t)throw t.error}}try{for(var oe=n.__values(E.image_indices),ie=oe.next();!ie.done;ie=oe.next()){var ae=ie.value,le=(ne={index:ae.index,x:D,y:J,sx:I,sy:N,name:O.model.name},this._render_tooltips(F,ae,ne));Q.push([I,N,le])}}catch(e){y={error:e}}finally{try{ie&&!ie.done&&(v=oe.return)&&v.call(oe)}finally{if(y)throw y.error}}try{for(var se=n.__values(E.indices),_e=se.next();!_e.done;_e=se.next()){X=_e.value;if(h.isEmpty(E.multiline_indices)){Y=null!=K._x?K._x[X]:void 0,Z=null!=K._y?K._y[X]:void 0,te=void 0,re=void 0;if("snap_to_data"==this.model.point_policy){var de=K.get_anchor_point(this.model.anchor,X,[I,N]);null==de&&(de=K.get_anchor_point("center",X,[I,N])),te=de.x,re=de.y}else te=(S=n.__read([I,N],2))[0],re=S[1];ye=void 0,ne={index:ye=V instanceof a.GlyphRenderer?V.view.convert_indices_from_subset([X])[0]:X,x:D,y:J,sx:I,sy:N,data_x:Y,data_y:Z,indices:E.indices,name:O.model.name};Q.push([te,re,this._render_tooltips(F,ye,ne)])}else try{for(var ce=(x=void 0,n.__values(E.multiline_indices[X.toString()])),pe=ce.next();!pe.done;pe=ce.next()){var ue=pe.value,Y=K._xs[X][ue],Z=K._ys[X][ue],he=ue,te=void 0,re=void 0;switch(this.model.line_policy){case"interp":Y=(k=n.__read(K.get_interpolation_hit(X,ue,j),2))[0],Z=k[1],te=B.compute(Y),re=L.compute(Z);break;case"prev":A=n.__read(b(K.sxs[X],K.sys[X],ue),2),te=(C=n.__read(A[0],2))[0],re=C[1],he=A[1];break;case"next":T=n.__read(b(K.sxs[X],K.sys[X],ue+1),2),te=(G=n.__read(T[0],2))[0],re=G[1],he=T[1];break;case"nearest":M=n.__read(w(ue,j,I,N,K.sxs[X],K.sys[X]),2),te=(R=n.__read(M[0],2))[0],re=R[1],he=M[1],Y=K._xs[X][he],Z=K._ys[X][he];break;default:throw new Error("should't have happened")}var ye=void 0,ne={index:ye=V instanceof a.GlyphRenderer?V.view.convert_indices_from_subset([X])[0]:X,x:D,y:J,sx:I,sy:N,data_x:Y,data_y:Z,segment_index:he,indices:E.multiline_indices,name:O.model.name};Q.push([te,re,this._render_tooltips(F,ye,ne)])}}catch(e){x={error:e}}finally{try{pe&&!pe.done&&(g=ce.return)&&g.call(ce)}finally{if(x)throw x.error}}}}catch(e){f={error:e}}finally{try{_e&&!_e.done&&(m=se.return)&&m.call(se)}finally{if(f)throw f.error}}if(0==Q.length)q.clear();else{var ve=q.content;c.empty(q.content);try{for(var fe=n.__values(Q),me=fe.next();!me.done;me=fe.next()){var xe=n.__read(me.value,3)[2];ve.appendChild(xe)}}catch(e){H={error:e}}finally{try{me&&!me.done&&($=fe.return)&&$.call(fe)}finally{if(H)throw H.error}}var we=n.__read(Q[Q.length-1],2),be=we[0],ge=we[1];q.setv({position:[be,ge]},{check_eq:!1})}}}}}},t.prototype._emit_callback=function(e){var t,r;try{for(var o=n.__values(this.computed_renderers),i=o.next();!i.done;i=o.next()){var a=i.value,l=this.plot_view.renderer_views.get(a),s=l.coordinates.x_scale.invert(e.sx),_=l.coordinates.y_scale.invert(e.sy),d=a.data_source.inspected,c=Object.assign({x:s,y:_},e);this.model.callback.execute(this.model,{index:d,geometry:c,renderer:a})}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}},t.prototype._create_template=function(e){var t,r,o=c.div({style:{display:"table",borderSpacing:"2px"}});try{for(var i=n.__values(e),a=i.next();!a.done;a=i.next()){var l=n.__read(a.value,1)[0],s=c.div({style:{display:"table-row"}});o.appendChild(s);var _=c.div({style:{display:"table-cell"},class:x.bk_tooltip_row_label},0!=l.length?l+": ":"");s.appendChild(_);var d=c.span();d.dataset.value="";var p=c.span({class:x.bk_tooltip_color_block}," ");p.dataset.swatch="",c.undisplay(p);var u=c.div({style:{display:"table-cell"},class:x.bk_tooltip_row_value},d,p);s.appendChild(u)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}return o},t.prototype._render_template=function(e,t,r,o,i){var a,l,s,_,p=e.cloneNode(!0),h=p.querySelectorAll("[data-value]"),f=p.querySelectorAll("[data-swatch]"),m=/\$color(\[.*\])?:(\w*)/;try{for(var x=n.__values(y.enumerate(t)),w=x.next();!w.done;w=x.next()){var b=n.__read(w.value,2),g=n.__read(b[0],2)[1],k=b[1],A=g.match(m);if(null!=A){var C=n.__read(A,3),T=C[1],G=void 0===T?"":T,M=C[2],R=r.get_column(M);if(null==R){h[k].textContent=M+" unknown";continue}var S=G.indexOf("hex")>=0,H=G.indexOf("swatch")>=0,$=v.isNumber(o)?R[o]:null;if(null==$){h[k].textContent="(null)";continue}S&&($=u.color2hex($)),h[k].textContent=$,H&&(f[k].style.backgroundColor=$,c.display(f[k]))}else{var P=d.replace_placeholders(g.replace("$~","$data_"),r,o,this.model.formatters,i);if(v.isString(P))h[k].textContent=P;else try{for(var O=(s=void 0,n.__values(P)),j=O.next();!j.done;j=O.next()){var V=j.value;h[k].appendChild(V)}}catch(e){s={error:e}}finally{try{j&&!j.done&&(_=O.return)&&_.call(O)}finally{if(s)throw s.error}}}}}catch(e){a={error:e}}finally{try{w&&!w.done&&(l=x.return)&&l.call(x)}finally{if(a)throw a.error}}return p},t.prototype._render_tooltips=function(e,t,r){var n=this.model.tooltips;if(v.isString(n)){var o=d.replace_placeholders({html:n},e,t,this.model.formatters,r);return c.div({},o)}return v.isFunction(n)?n(e,r):this._render_template(this._template_el,n,e,t,r)},t}(o.InspectToolView);r.HoverToolView=g,g.__name__="HoverToolView";var k=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Hover",r.icon=m.bk_tool_icon_hover,r}return n.__extends(t,e),t.init_HoverTool=function(){this.prototype.default_view=g,this.define({tooltips:[p.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[p.Any,{}],renderers:[p.Any,"auto"],names:[p.Array,[]],mode:[p.HoverMode,"mouse"],muted_policy:[p.MutedPolicy,"show"],point_policy:[p.PointPolicy,"snap_to_data"],line_policy:[p.LinePolicy,"nearest"],show_arrow:[p.Boolean,!0],anchor:[p.Anchor,"center"],attachment:[p.TooltipAttachment,"horizontal"],callback:[p.Any]}),this.register_alias("hover",(function(){return new t}))},t}(o.InspectTool);r.HoverTool=k,k.__name__="HoverTool",k.init_HoverTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),r=n.__importStar(e(133)),i=e(130),l=e(196),a=e(410),c=e(418),u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_ToolProxy=function(){this.define({tools:[r.Array,[]],active:[r.Boolean,!1],disabled:[r.Boolean,!1]})},Object.defineProperty(t.prototype,"button_view",{get:function(){return this.tools[0].button_view},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"event_type",{get:function(){return this.tools[0].event_type},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.tools[0].tooltip},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tool_name",{get:function(){return this.tools[0].tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"icon",{get:function(){return this.tools[0].computed_icon},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"toggleable",{get:function(){var e=this.tools[0];return e instanceof a.InspectTool&&e.toggleable},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.do=new i.Signal0(this,"do")},t.prototype.connect_signals=function(){var t,o,r=this;e.prototype.connect_signals.call(this),this.connect(this.do,(function(){return r.doit()})),this.connect(this.properties.active.change,(function(){return r.set_active()}));var i=function(e){l.connect(e.properties.active.change,(function(){r.active=e.active}))},l=this;try{for(var a=n.__values(this.tools),c=a.next();!c.done;c=a.next()){i(c.value)}}catch(e){t={error:e}}finally{try{c&&!c.done&&(o=a.return)&&o.call(a)}finally{if(t)throw t.error}}},t.prototype.doit=function(){var e,t;try{for(var o=n.__values(this.tools),r=o.next();!r.done;r=o.next()){r.value.do.emit()}}catch(t){e={error:t}}finally{try{r&&!r.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}},t.prototype.set_active=function(){var e,t;try{for(var o=n.__values(this.tools),r=o.next();!r.done;r=o.next()){r.value.active=this.active}}catch(t){e={error:t}}finally{try{r&&!r.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}},Object.defineProperty(t.prototype,"menu",{get:function(){var e,t,o=this,r=this.tools[0].menu;if(null==r)return null;var i=[],l=function(e,t){if(null==e)i.push(null);else{i.push(Object.assign(Object.assign({},e),{handler:function(){var e,r,i,l;try{for(var a=(e=void 0,n.__values(o.tools)),c=a.next();!c.done;c=a.next()){null===(l=null===(i=c.value.menu)||void 0===i?void 0:i[t])||void 0===l||l.handler()}}catch(t){e={error:t}}finally{try{c&&!c.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}}}))}};try{for(var a=n.__values(c.enumerate(r)),u=a.next();!u.done;u=a.next()){var f=n.__read(u.value,2);l(f[0],f[1])}}catch(t){e={error:t}}finally{try{u&&!u.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}return i},enumerable:!0,configurable:!0}),t}(l.Model);o.ToolProxy=u,u.__name__="ToolProxy",u.init_ToolProxy()},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var o=t(1),n=o.__importStar(t(133)),i=t(124),l=t(128),a=t(420),s=t(494),c=t(387),u=t(327),h=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_ProxyToolbar=function(){this.define({toolbars:[n.Array,[]]})},r.prototype.initialize=function(){t.prototype.initialize.call(this),this._merge_tools()},r.prototype._merge_tools=function(){var t,r,e,n,a,c,u,h,_,y,f,v,d,p,x,b,w,g,m,T,B,z,P,O=this;this._proxied_tools=[];var L={},M={},V={},j=[],k=[];try{for(var A=o.__values(this.help),C=A.next();!C.done;C=A.next()){var D=C.value;i.includes(k,D.redirect)||(j.push(D),k.push(D.redirect))}}catch(r){t={error:r}}finally{try{C&&!C.done&&(r=A.return)&&r.call(A)}finally{if(t)throw t.error}}(e=this._proxied_tools).push.apply(e,o.__spread(j)),this.help=j;try{for(var I=o.__values(l.entries(this.gestures)),S=I.next();!S.done;S=I.next()){var q=o.__read(S.value,2),E=q[0],F=q[1];E in V||(V[E]={});try{for(var G=(c=void 0,o.__values(F.tools)),H=G.next();!H.done;H=G.next()){(at=H.value).type in V[E]||(V[E][at.type]=[]),V[E][at.type].push(at)}}catch(t){c={error:t}}finally{try{H&&!H.done&&(u=G.return)&&u.call(G)}finally{if(c)throw c.error}}}}catch(t){n={error:t}}finally{try{S&&!S.done&&(a=I.return)&&a.call(I)}finally{if(n)throw n.error}}try{for(var J=o.__values(this.inspectors),K=J.next();!K.done;K=J.next()){(at=K.value).type in L||(L[at.type]=[]),L[at.type].push(at)}}catch(t){h={error:t}}finally{try{K&&!K.done&&(_=J.return)&&_.call(J)}finally{if(h)throw h.error}}try{for(var N=o.__values(this.actions),Q=N.next();!Q.done;Q=N.next()){(at=Q.value).type in M||(M[at.type]=[]),M[at.type].push(at)}}catch(t){y={error:t}}finally{try{Q&&!Q.done&&(f=N.return)&&f.call(N)}finally{if(y)throw y.error}}var R=function(t,r){void 0===r&&(r=!1);var e=new s.ToolProxy({tools:t,active:r});return O._proxied_tools.push(e),e};try{for(var U=o.__values(l.keys(V)),W=U.next();!W.done;W=U.next()){E=W.value;(F=this.gestures[E]).tools=[];var X=function(t){var r,e,n=V[E][t];if(n.length>0)if("multi"==E){var i=function(t){var r=R([t]);F.tools.push(r),Y.connect(r.properties.active.change,(function(){return O._active_change(r)}))};try{for(var l=(r=void 0,o.__values(n)),a=l.next();!a.done;a=l.next()){i(a.value)}}catch(t){r={error:t}}finally{try{a&&!a.done&&(e=l.return)&&e.call(l)}finally{if(r)throw r.error}}}else{var s=R(n);F.tools.push(s),Y.connect(s.properties.active.change,(function(){return O._active_change(s)}))}},Y=this;try{for(var Z=(p=void 0,o.__values(l.keys(V[E]))),$=Z.next();!$.done;$=Z.next()){X(ot=$.value)}}catch(t){p={error:t}}finally{try{$&&!$.done&&(x=Z.return)&&x.call(Z)}finally{if(p)throw p.error}}}}catch(t){v={error:t}}finally{try{W&&!W.done&&(d=U.return)&&d.call(U)}finally{if(v)throw v.error}}this.actions=[];try{for(var tt=o.__values(l.entries(M)),rt=tt.next();!rt.done;rt=tt.next()){var et=o.__read(rt.value,2),ot=et[0],nt=et[1];if("CustomAction"==ot)try{for(var it=(g=void 0,o.__values(nt)),lt=it.next();!lt.done;lt=it.next()){var at=lt.value;this.actions.push(R([at]))}}catch(t){g={error:t}}finally{try{lt&&!lt.done&&(m=it.return)&&m.call(it)}finally{if(g)throw g.error}}else nt.length>0&&this.actions.push(R(nt))}}catch(t){b={error:t}}finally{try{rt&&!rt.done&&(w=tt.return)&&w.call(tt)}finally{if(b)throw b.error}}this.inspectors=[];try{for(var st=o.__values(l.values(L)),ct=st.next();!ct.done;ct=st.next()){(nt=ct.value).length>0&&this.inspectors.push(R(nt,!0))}}catch(t){T={error:t}}finally{try{ct&&!ct.done&&(B=st.return)&&B.call(st)}finally{if(T)throw T.error}}try{for(var ut=o.__values(l.entries(this.gestures)),ht=ut.next();!ht.done;ht=ut.next()){var _t=o.__read(ht.value,2),yt=_t[0];0!=(F=_t[1]).tools.length&&(F.tools=i.sort_by(F.tools,(function(t){return t.default_order})),"pinch"!=yt&&"scroll"!=yt&&"multi"!=yt&&(F.tools[0].active=!0))}}catch(t){z={error:t}}finally{try{ht&&!ht.done&&(P=ut.return)&&P.call(ut)}finally{if(z)throw z.error}}},r}(a.ToolbarBase);e.ProxyToolbar=h,h.__name__="ProxyToolbar",h.init_ProxyToolbar();var _=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(r,t),r.prototype.initialize=function(){this.model.toolbar.toolbar_location=this.model.toolbar_location,t.prototype.initialize.call(this)},Object.defineProperty(r.prototype,"child_models",{get:function(){return[this.model.toolbar]},enumerable:!0,configurable:!0}),r.prototype._update_layout=function(){this.layout=new u.ContentBox(this.child_views[0].el),this.model.toolbar.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})},r}(c.LayoutDOMView);e.ToolbarBoxView=_,_.__name__="ToolbarBoxView";var y=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_ToolbarBox=function(){this.prototype.default_view=_,this.define({toolbar:[n.Instance],toolbar_location:[n.Location,"right"]})},r}(c.LayoutDOM);e.ToolbarBox=y,y.__name__="ToolbarBox",y.init_ToolbarBox()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),i=e(120),o=e(193),a=e(230),s=e(187),d=e(497);t.index={},t.add_document_standalone=function(e,n,l,c){return void 0===l&&(l=[]),void 0===c&&(c=!1),r.__awaiter(this,void 0,void 0,(function(){function u(i){return r.__awaiter(this,void 0,void 0,(function(){var c,u,_,f,w;return r.__generator(this,(function(r){switch(r.label){case 0:return u=e.roots(),_=u.indexOf(i),null!=(f=l[_])?c=f:n.classList.contains(d.BOKEH_ROOT)?c=n:(c=s.div({class:d.BOKEH_ROOT}),n.appendChild(c)),[4,a.build_view(i,{parent:null})];case 1:return(w=r.sent())instanceof o.DOMView&&w.renderTo(c),v.set(i,w),t.index[i.id]=w,[2,w]}}))}))}var v,_,f,w,h,O;return r.__generator(this,(function(n){switch(n.label){case 0:v=new Map,n.label=1;case 1:n.trys.push([1,6,7,8]),_=r.__values(e.roots()),f=_.next(),n.label=2;case 2:return f.done?[3,5]:[4,u(f.value)];case 3:n.sent(),n.label=4;case 4:return f=_.next(),[3,2];case 5:return[3,8];case 6:return w=n.sent(),h={error:w},[3,8];case 7:try{f&&!f.done&&(O=_.return)&&O.call(_)}finally{if(h)throw h.error}return[7];case 8:return c&&(window.document.title=e.title()),e.on_change((function(e){e instanceof i.RootAddedEvent?u(e.model):e instanceof i.RootRemovedEvent?function(e){var n=v.get(e);null!=n&&(n.remove(),v.delete(e),delete t.index[e.id])}(e.model):c&&e instanceof i.TitleChangedEvent&&(window.document.title=e.title)})),[2,r.__spread(v.values())]}}))}))}},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),t=e(187),l=e(388);function u(e){var r=document.getElementById(e);if(null==r)throw new Error("Error rendering Bokeh model: could not find #"+e+" HTML tag");if(!document.body.contains(r))throw new Error("Error rendering Bokeh model: element #"+e+" must be under <body>");if("SCRIPT"==r.tagName){var n=t.div({class:o.BOKEH_ROOT});t.replaceWith(r,n),r=n}return r}o.BOKEH_ROOT=l.bk_root,o._resolve_element=function(e){var r=e.elementid;return null!=r?u(r):document.body},o._resolve_root_elements=function(e){var r,o,t=[];if(null!=e.root_ids&&null!=e.roots)try{for(var l=n.__values(e.root_ids),d=l.next();!d.done;d=l.next()){var i=d.value;t.push(u(e.roots[i]))}}catch(e){r={error:e}}finally{try{d&&!d.done&&(o=l.return)&&o.call(l)}finally{if(r)throw r.error}}return t}},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(1),r=e(499),s=e(134),a=e(496);o._get_ws_url=function(e,n){var o,t="ws:";return"https:"==window.location.protocol&&(t="wss:"),null!=n?(o=document.createElement("a")).href=n:o=window.location,null!=e?"/"==e&&(e=""):e=o.pathname.replace(/\/+$/,""),t+"//"+o.host+e+"/ws"};var i={};function u(e,n,o){var t=r.parse_token(n).session_id;e in i||(i[e]={});var s=i[e];return t in s||(s[t]=r.pull_session(e,n,o)),s[t]}o.add_document_from_session=function(e,n,o,i,c){return void 0===i&&(i=[]),void 0===c&&(c=!1),t.__awaiter(this,void 0,void 0,(function(){var l,d,_,w;return t.__generator(this,(function(t){switch(t.label){case 0:l=window.location.search.substr(1),t.label=1;case 1:return t.trys.push([1,3,,4]),[4,u(e,n,l)];case 2:return d=t.sent(),[3,4];case 3:throw _=t.sent(),w=r.parse_token(n).session_id,s.logger.error("Failed to load Bokeh session "+w+": "+_),_;case 4:return[2,a.add_document_standalone(d.document,o,i,c)]}}))}))}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var o=e(1),s=e(134),r=e(120),i=e(500),c=e(501),l=e(502);t.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",t.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";var _=0;function a(e){var n=e.split(".")[0],t=n.length%4;return 0!=t&&(n+="=".repeat(4-t)),JSON.parse(atob(n.replace(/_/g,"/").replace(/-/g,"+")))}t.parse_token=a;var u=function(){function e(e,n,o){void 0===e&&(e=t.DEFAULT_SERVER_WEBSOCKET_URL),void 0===n&&(n=t.DEFAULT_TOKEN),void 0===o&&(o=null),this.url=e,this.token=n,this.args_string=o,this._number=_++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new c.Receiver,this.id=a(n).session_id.split(".")[0],s.logger.debug("Creating websocket "+this._number+" to '"+this.url+"' session '"+this.id+"'")}return e.prototype.connect=function(){return o.__awaiter(this,void 0,void 0,(function(){var e,n=this;return o.__generator(this,(function(t){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{return e=""+this.url,null!=this.args_string&&this.args_string.length>0&&(e+="?"+this.args_string),this.socket=new WebSocket(e,["bokeh",this.token]),[2,new Promise((function(e,t){n.socket.binaryType="arraybuffer",n.socket.onopen=function(){return n._on_open(e,t)},n.socket.onmessage=function(e){return n._on_message(e)},n.socket.onclose=function(e){return n._on_close(e,t)},n.socket.onerror=function(){return n._on_error(t)}}))]}catch(e){throw s.logger.error("websocket creation failed to url: "+this.url),s.logger.error(" - "+e),e}return[2]}))}))},e.prototype.close=function(){this.closed_permanently||(s.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed())},e.prototype._schedule_reconnect=function(e){var n=this;setTimeout((function(){n.closed_permanently||s.logger.info("Websocket connection "+n._number+" disconnected, will not attempt to reconnect")}),e)},e.prototype.send=function(e){if(null==this.socket)throw new Error("not connected so cannot send "+e);e.send(this.socket)},e.prototype.send_with_reply=function(e){return o.__awaiter(this,void 0,void 0,(function(){var n,t=this;return o.__generator(this,(function(o){switch(o.label){case 0:return[4,new Promise((function(n,o){t._pending_replies.set(e.msgid(),{resolve:n,reject:o}),t.send(e)}))];case 1:if("ERROR"===(n=o.sent()).msgtype())throw new Error("Error reply "+n.content.text);return[2,n]}}))}))},e.prototype._pull_doc_json=function(){return o.__awaiter(this,void 0,void 0,(function(){var e,n;return o.__generator(this,(function(t){switch(t.label){case 0:return e=i.Message.create("PULL-DOC-REQ",{}),[4,this.send_with_reply(e)];case 1:if(!("doc"in(n=t.sent()).content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return[2,n.content.doc]}}))}))},e.prototype._repull_session_doc=function(e,n){return o.__awaiter(this,void 0,void 0,(function(){var t,c,_,a,u,h,d,g,p,f,w;return o.__generator(this,(function(m){switch(m.label){case 0:s.logger.debug(this.session?"Repulling session":"Pulling session for first time"),m.label=1;case 1:return m.trys.push([1,3,,4]),[4,this._pull_doc_json()];case 2:if(c=m.sent(),null==this.session)if(this.closed_permanently)s.logger.debug("Got new document after connection was already closed"),n(new Error("The connection has been closed"));else{_=r.Document.from_json(c),(a=r.Document._compute_patch_since_json(c,_)).events.length>0&&(s.logger.debug("Sending "+a.events.length+" changes from model construction back to server"),u=i.Message.create("PATCH-DOC",{},a),this.send(u)),this.session=new l.ClientSession(this,_,this.id);try{for(h=o.__values(this._pending_messages),d=h.next();!d.done;d=h.next())g=d.value,this.session.handle(g)}catch(e){f={error:e}}finally{try{d&&!d.done&&(w=h.return)&&w.call(h)}finally{if(f)throw f.error}}this._pending_messages=[],s.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(c),s.logger.debug("Updated existing session with new pulled doc");return[3,4];case 3:return p=m.sent(),null===(t=console.trace)||void 0===t||t.call(console,p),s.logger.error("Failed to repull session "+p),n(p),[3,4];case 4:return[2]}}))}))},e.prototype._on_open=function(e,n){var t=this;s.logger.info("Websocket connection "+this._number+" is now open"),this._current_handler=function(o){t._awaiting_ack_handler(o,e,n)}},e.prototype._on_message=function(e){null==this._current_handler&&s.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(e.toString())}var n=this._receiver.message;if(null!=n){var t=n.problem();null!=t&&this._close_bad_protocol(t),this._current_handler(n)}},e.prototype._on_close=function(e,n){s.logger.info("Lost websocket "+this._number+" connection, "+e.code+" ("+e.reason+")"),this.socket=null,this._pending_replies.forEach((function(e){return e.reject("Disconnected")})),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),n(new Error("Lost websocket connection, "+e.code+" ("+e.reason+")"))},e.prototype._on_error=function(e){s.logger.debug("Websocket error on socket "+this._number);var n="Could not open websocket";s.logger.error("Failed to connect to Bokeh server: "+n),e(new Error(n))},e.prototype._close_bad_protocol=function(e){s.logger.error("Closing connection: "+e),null!=this.socket&&this.socket.close(1002,e)},e.prototype._awaiting_ack_handler=function(e,n,t){var o=this;"ACK"===e.msgtype()?(this._current_handler=function(e){return o._steady_state_handler(e)},this._repull_session_doc(n,t)):this._close_bad_protocol("First message was not an ACK")},e.prototype._steady_state_handler=function(e){var n=e.reqid(),t=this._pending_replies.get(n);t?(this._pending_replies.delete(n),t.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)},e}();t.ClientConnection=u,u.__name__="ClientConnection",t.pull_session=function(e,n,t){return new u(e,n,t).connect()}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(144),s=function(){function e(e,t,r){this.header=e,this.metadata=t,this.content=r,this.buffers=new Map}return e.assemble=function(t,r,n){return new e(JSON.parse(t),JSON.parse(r),JSON.parse(n))},e.prototype.assemble_buffer=function(e,t){var r=null!=this.header.num_buffers?this.header.num_buffers:0;if(r<=this.buffers.size)throw new Error("too many buffers received, expecting "+r);var n=JSON.parse(e).id;this.buffers.set(n,t)},e.create=function(t,r,n){void 0===n&&(n={});var s=e.create_header(t);return new e(s,r,n)},e.create_header=function(e){return{msgid:n.uniqueId(),msgtype:e}},e.prototype.complete=function(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(null==this.header.num_buffers||this.buffers.size==this.header.num_buffers)},e.prototype.send=function(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");var t=JSON.stringify(this.header),r=JSON.stringify(this.metadata),n=JSON.stringify(this.content);e.send(t),e.send(r),e.send(n)},e.prototype.msgid=function(){return this.header.msgid},e.prototype.msgtype=function(){return this.header.msgtype},e.prototype.reqid=function(){return this.header.reqid},e.prototype.problem=function(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"},e}();r.Message=s,s.__name__="Message"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var _=t(1),r=t(500),i=t(123),n=function(){function t(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}return t.prototype.consume=function(t){this._current_consumer(t)},t.prototype._HEADER=function(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA},t.prototype._METADATA=function(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT},t.prototype._CONTENT=function(t){this._assume_text(t),this._fragments.push(t);var e=_.__read(this._fragments.slice(0,3),3),s=e[0],i=e[1],n=e[2];this._partial=r.Message.assemble(s,i,n),this._check_complete()},t.prototype._BUFFER_HEADER=function(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD},t.prototype._BUFFER_PAYLOAD=function(t){this._assume_binary(t),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()},t.prototype._assume_text=function(t){if(!i.isString(t))throw new Error("Expected text fragment but received binary fragment")},t.prototype._assume_binary=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")},t.prototype._check_complete=function(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER},t}();s.Receiver=n,n.__name__="Receiver"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(1),i=e(120),r=e(500),c=e(134),s=function(){function e(e,t,n){var o=this;this._connection=e,this.document=t,this.id=n,this._document_listener=function(e){o._document_changed(e)},this.document.on_change(this._document_listener,!0)}return e.prototype.handle=function(e){var t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):c.logger.debug("Doing nothing with message "+e.msgtype())},e.prototype.close=function(){this._connection.close()},e.prototype._connection_closed=function(){this.document.remove_on_change(this._document_listener)},e.prototype.request_server_info=function(){return o.__awaiter(this,void 0,void 0,(function(){var e;return o.__generator(this,(function(t){switch(t.label){case 0:return e=r.Message.create("SERVER-INFO-REQ",{}),[4,this._connection.send_with_reply(e)];case 1:return[2,t.sent().content]}}))}))},e.prototype.force_roundtrip=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(e){switch(e.label){case 0:return[4,this.request_server_info()];case 1:return e.sent(),[2]}}))}))},e.prototype._document_changed=function(e){if(e.setter_id!==this.id){var t=e instanceof i.DocumentEventBatch?e.events:[e],n=this.document.create_json_patch(t),o=r.Message.create("PATCH-DOC",{},n);this._connection.send(o)}},e.prototype._handle_patch=function(e){this.document.apply_json_patch(e.content,e.buffers,this.id)},e.prototype._handle_ok=function(e){c.logger.trace("Unhandled OK reply to "+e.reqid())},e.prototype._handle_error=function(e){c.logger.error("Unhandled ERROR reply to "+e.reqid()+": "+e.content.text)},e}();n.ClientSession=s,s.__name__="ClientSession"},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var o=e(1),n=this&&this.__asyncValues||function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,r=e[Symbol.asyncIterator];return r?r.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),t={},o("next"),o("throw"),o("return"),t[Symbol.asyncIterator]=function(){return this},t);function o(r){t[r]=e[r]&&function(t){return new Promise((function(o,n){(function(e,t,r,o){Promise.resolve(o).then((function(t){e({value:t,done:r})}),t)})(o,n,(t=e[r](t)).done,t.value)}))}}},a=e(120),s=e(501),l=e(134),i=e(187),u=e(128),c=e(496),f=e(497),g=o.__importDefault(e(188)),m=o.__importDefault(e(426)),d=o.__importDefault(e(504));function _(e,t){t.buffers.length>0?e.consume(t.buffers[0].buffer):e.consume(t.content.data);var r=e.message;null!=r&&this.apply_json_patch(r.content,r.buffers)}function b(e,t){var a=this;if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){l.logger.info("Registering Jupyter comms for target "+e);var i=Jupyter.notebook.kernel.comm_manager;try{i.register_target(e,(function(r){l.logger.info("Registering Jupyter comms for target "+e);var o=new s.Receiver;r.on_msg(_.bind(t,o))}))}catch(e){l.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else if(t.roots()[0].id in r.kernels){l.logger.info("Registering JupyterLab comms for target "+e);var u=r.kernels[t.roots()[0].id];try{u.registerCommTarget(e,(function(r){l.logger.info("Registering JupyterLab comms for target "+e);var o=new s.Receiver;r.onMsg=_.bind(t,o)}))}catch(e){l.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else if("undefined"!=typeof google&&null!=google.colab.kernel){l.logger.info("Registering Google Colab comms for target "+e);i=google.colab.kernel.comms;try{i.registerTarget(e,(function(r){return o.__awaiter(a,void 0,void 0,(function(){var a,i,u,c,f,g,m,d,b,p,y,v,h,w,k,x;return o.__generator(this,(function(J){switch(J.label){case 0:l.logger.info("Registering Google Colab comms for target "+e),c=new s.Receiver,J.label=1;case 1:J.trys.push([1,6,7,12]),f=n(r.messages),J.label=2;case 2:return[4,f.next()];case 3:if((g=J.sent()).done)return[3,5];m=g.value,d={data:m.data},b=[];try{for(k=void 0,p=o.__values(null!==(u=m.buffers)&&void 0!==u?u:[]),y=p.next();!y.done;y=p.next())v=y.value,b.push(new DataView(v))}catch(e){k={error:e}}finally{try{y&&!y.done&&(x=p.return)&&x.call(p)}finally{if(k)throw k.error}}h={content:d,buffers:b},_.bind(t)(c,h),J.label=4;case 4:return[3,2];case 5:return[3,12];case 6:return w=J.sent(),a={error:w},[3,12];case 7:return J.trys.push([7,,10,11]),g&&!g.done&&(i=f.return)?[4,i.call(f)]:[3,9];case 8:J.sent(),J.label=9;case 9:return[3,11];case 10:if(a)throw a.error;return[7];case 11:return[7];case 12:return[2]}}))}))}))}catch(e){l.logger.warn("Google Colab comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}i.stylesheet.append(g.default),i.stylesheet.append(m.default),i.stylesheet.append(d.default),r.kernels={},r.embed_items_notebook=function(e,t){var r,n;if(1!=u.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");var s=a.Document.from_json(u.values(e)[0]);try{for(var l=o.__values(t),i=l.next();!i.done;i=l.next()){var g=i.value;null!=g.notebook_comms_target&&b(g.notebook_comms_target,s);var m=f._resolve_element(g),d=f._resolve_root_elements(g);c.add_document_standalone(s,m,d)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}}},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});o.default="\n/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);_.__exportStar(e(500),t),_.__exportStar(e(501),t)},
function _(e,t,n){function s(){var e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);var n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}Object.defineProperty(n,"__esModule",{value:!0}),n.results={},n.init=function(){s()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,s()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,s()}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.safely=function(e,t){void 0===t&&(t=!1);try{return e()}catch(e){if(function(e){var t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");var r=document.createElement("span");r.style.backgroundColor="#a94442",r.style.borderRadius="0px 4px 0px 0px",r.style.color="white",r.style.cursor="pointer",r.style.cssFloat="right",r.style.fontSize="0.8em",r.style.margin="-6px -6px 0px 0px",r.style.padding="2px 5px 4px 5px",r.title="close",r.setAttribute("aria-label","close"),r.appendChild(document.createTextNode("x")),r.addEventListener("click",(function(){return a.removeChild(t)}));var l=document.createElement("h3");l.style.color="#a94442",l.style.margin="8px 0px 0px 0px",l.style.padding="0px",l.appendChild(document.createTextNode("Bokeh Error"));var o=document.createElement("pre");o.style.whiteSpace="unset",o.style.overflowX="auto";var n=e instanceof Error?e.message:e;o.appendChild(document.createTextNode(n)),t.appendChild(r),t.appendChild(l),t.appendChild(o);var a=document.getElementsByTagName("body")[0];a.insertBefore(t,a.firstChild)}(e),t)return;throw e}}},
], 0, {"legacy":0,"polyfill":2,"main":116,"index":117,"version":118,"embed/index":119,"document/index":120,"document/document":121,"base":122,"core/util/types":123,"core/util/array":124,"core/util/math":125,"core/util/assert":126,"core/util/arrayable":127,"core/util/object":128,"core/has_props":129,"core/signaling":130,"core/util/callback":131,"core/util/refs":132,"core/properties":133,"core/logging":134,"core/enums":135,"core/kinds":136,"core/util/color":137,"core/util/svg_colors":138,"core/types":139,"core/util/eq":140,"core/util/data_structures":141,"core/settings":142,"core/property_mixins":143,"core/util/string":144,"core/util/ndarray":145,"core/util/serialization":146,"core/util/compat":147,"core/util/pretty":148,"models/index":149,"models/annotations/index":150,"models/annotations/annotation":151,"core/util/projections":152,"models/renderers/renderer":185,"core/view":186,"core/dom":187,"styles/root.css":188,"core/visuals":189,"core/util/svg":190,"core/util/affine":191,"models/canvas/canvas":192,"core/dom_view":193,"core/util/bbox":194,"core/util/canvas":195,"model":196,"models/canvas/coordinates":197,"models/annotations/arrow":198,"models/annotations/arrow_head":199,"models/sources/column_data_source":200,"models/sources/columnar_data_source":201,"models/sources/data_source":202,"models/selections/selection":203,"core/selection_manager":204,"models/renderers/glyph_renderer":205,"models/renderers/data_renderer":206,"models/glyphs/line":207,"models/glyphs/xy_glyph":208,"models/glyphs/glyph":209,"core/util/spatial":210,"models/ranges/factor_range":213,"models/ranges/range":214,"models/glyphs/utils":215,"core/hittest":216,"models/glyphs/webgl/line":217,"models/glyphs/webgl/utils/index":218,"models/glyphs/webgl/utils/program":219,"models/glyphs/webgl/utils/buffer":220,"models/glyphs/webgl/utils/texture":221,"models/glyphs/webgl/base":222,"models/glyphs/webgl/line.vert":223,"models/glyphs/webgl/line.frag":224,"models/glyphs/patch":225,"models/glyphs/harea":226,"models/glyphs/area":227,"models/glyphs/varea":228,"models/sources/cds_view":229,"core/build_views":230,"models/renderers/graph_renderer":231,"models/graphs/graph_hit_test_policy":232,"models/selections/interaction_policy":233,"core/util/typed_array":234,"core/util/set":235,"document/events":236,"models/annotations/band":237,"models/annotations/upper_lower":238,"models/annotations/box_annotation":239,"models/annotations/color_bar":240,"models/tickers/basic_ticker":241,"models/tickers/adaptive_ticker":242,"models/tickers/continuous_ticker":243,"models/tickers/ticker":244,"models/formatters/basic_tick_formatter":245,"models/formatters/tick_formatter":246,"models/mappers/index":247,"models/mappers/categorical_color_mapper":248,"models/mappers/categorical_mapper":249,"models/mappers/color_mapper":250,"models/mappers/mapper":251,"models/transforms/transform":252,"models/mappers/categorical_marker_mapper":253,"models/mappers/categorical_pattern_mapper":254,"models/mappers/continuous_color_mapper":255,"models/mappers/linear_color_mapper":256,"models/mappers/log_color_mapper":257,"models/mappers/scanning_color_mapper":258,"models/mappers/eqhist_color_mapper":259,"models/scales/linear_scale":260,"models/scales/continuous_scale":261,"models/scales/scale":262,"models/transforms/index":263,"models/transforms/customjs_transform":264,"models/transforms/dodge":265,"models/transforms/range_transform":266,"models/transforms/interpolator":267,"models/transforms/jitter":268,"models/transforms/linear_interpolator":269,"models/transforms/step_interpolator":270,"models/scales/linear_interpolation_scale":271,"models/scales/log_scale":272,"models/ranges/range1d":273,"core/util/text":274,"models/annotations/label":275,"models/annotations/text_annotation":276,"models/annotations/label_set":277,"models/annotations/legend":278,"models/annotations/legend_item":279,"core/vectorization":280,"models/annotations/poly_annotation":281,"models/annotations/slope":282,"models/annotations/span":283,"models/annotations/title":284,"models/annotations/toolbar_panel":285,"models/annotations/tooltip":286,"styles/tooltips":287,"styles/mixins":288,"styles/tooltips.css":289,"models/annotations/whisker":290,"models/axes/index":291,"models/axes/axis":292,"models/renderers/guide_renderer":293,"models/axes/categorical_axis":294,"models/tickers/categorical_ticker":295,"models/formatters/categorical_tick_formatter":296,"models/axes/continuous_axis":297,"models/axes/datetime_axis":298,"models/axes/linear_axis":299,"models/formatters/datetime_tick_formatter":300,"core/util/templating":302,"models/tickers/datetime_ticker":305,"models/tickers/composite_ticker":306,"models/tickers/days_ticker":307,"models/tickers/single_interval_ticker":308,"models/tickers/util":309,"models/tickers/months_ticker":310,"models/tickers/years_ticker":311,"models/axes/log_axis":312,"models/formatters/log_tick_formatter":313,"models/tickers/log_ticker":314,"models/axes/mercator_axis":315,"models/formatters/mercator_tick_formatter":316,"models/tickers/mercator_ticker":317,"models/callbacks/index":318,"models/callbacks/customjs":319,"models/callbacks/callback":320,"models/callbacks/open_url":321,"models/canvas/index":322,"models/canvas/cartesian_frame":323,"models/scales/categorical_scale":324,"models/ranges/data_range1d":325,"models/ranges/data_range":326,"core/layout/index":327,"core/layout/types":328,"core/layout/layoutable":329,"core/layout/alignments":330,"core/layout/grid":331,"core/layout/html":332,"models/expressions/index":333,"models/expressions/expression":334,"models/expressions/stack":335,"models/expressions/cumsum":336,"models/filters/index":337,"models/filters/boolean_filter":338,"models/filters/filter":339,"models/filters/customjs_filter":340,"models/filters/group_filter":341,"models/filters/index_filter":342,"models/formatters/index":343,"models/formatters/func_tick_formatter":344,"models/formatters/numeral_tick_formatter":345,"models/formatters/printf_tick_formatter":346,"models/glyphs/index":347,"models/glyphs/annular_wedge":348,"models/glyphs/annulus":349,"models/glyphs/arc":350,"models/glyphs/bezier":351,"models/glyphs/circle":352,"models/glyphs/webgl/markers":353,"models/glyphs/webgl/markers.vert":354,"models/glyphs/webgl/markers.frag":355,"models/glyphs/center_rotatable":356,"models/glyphs/ellipse":357,"models/glyphs/ellipse_oval":358,"models/glyphs/hbar":359,"models/glyphs/box":360,"models/glyphs/hex_tile":361,"models/glyphs/image":362,"models/glyphs/image_base":363,"models/glyphs/image_rgba":364,"models/glyphs/image_url":365,"core/util/image":366,"models/glyphs/multi_line":367,"models/glyphs/multi_polygons":368,"models/glyphs/oval":369,"models/glyphs/patches":370,"models/glyphs/quad":371,"models/glyphs/quadratic":372,"models/glyphs/ray":373,"models/glyphs/rect":374,"models/glyphs/segment":375,"models/glyphs/step":376,"models/glyphs/text":377,"models/glyphs/vbar":378,"models/glyphs/wedge":379,"models/graphs/index":380,"models/graphs/layout_provider":381,"models/graphs/static_layout_provider":382,"models/grids/index":383,"models/grids/grid":384,"models/layouts/index":385,"models/layouts/box":386,"models/layouts/layout_dom":387,"styles/root":388,"models/layouts/column":389,"models/layouts/grid_box":390,"models/layouts/html_box":391,"models/layouts/row":392,"models/layouts/spacer":393,"models/layouts/tabs":394,"styles/tabs":395,"styles/buttons":396,"styles/menus":397,"styles/buttons.css":398,"styles/menus.css":399,"styles/tabs.css":400,"models/layouts/widget_box":401,"models/markers/index":402,"models/markers/defs":403,"models/markers/marker":404,"models/markers/scatter":405,"models/plots/index":406,"models/plots/gmap_plot":407,"models/plots/plot":408,"models/tools/toolbar":409,"models/tools/inspectors/inspect_tool":410,"models/tools/button_tool":411,"models/tools/tool":413,"styles/toolbar":414,"styles/toolbar.css":415,"styles/icons.css":416,"core/util/menus":417,"core/util/iterator":418,"models/tools/on_off_button":419,"models/tools/toolbar_base":420,"models/tools/gestures/gesture_tool":421,"models/tools/actions/action_tool":422,"models/tools/actions/help_tool":423,"styles/icons":424,"styles/logo":425,"styles/logo.css":426,"models/plots/plot_canvas":427,"core/bokeh_events":428,"core/ui_events":429,"core/util/wheel":430,"core/util/throttle":431,"core/layout/border":432,"core/layout/side_panel":433,"models/plots/gmap_plot_canvas":434,"models/ranges/index":435,"models/renderers/index":436,"models/scales/index":437,"models/selections/index":438,"models/sources/index":439,"models/sources/server_sent_data_source":440,"models/sources/web_data_source":441,"models/sources/ajax_data_source":442,"models/sources/geojson_data_source":443,"models/tickers/index":444,"models/tickers/fixed_ticker":445,"models/tiles/index":446,"models/tiles/bbox_tile_source":447,"models/tiles/mercator_tile_source":448,"models/tiles/tile_source":449,"models/tiles/tile_utils":450,"models/tiles/quadkey_tile_source":451,"models/tiles/tile_renderer":452,"models/tiles/wmts_tile_source":453,"styles/tiles":454,"styles/tiles.css":455,"models/tiles/tms_tile_source":456,"models/textures/index":457,"models/textures/canvas_texture":458,"models/textures/texture":459,"models/textures/image_url_texture":460,"models/tools/index":461,"models/tools/actions/custom_action":462,"models/tools/actions/redo_tool":463,"models/tools/actions/reset_tool":464,"models/tools/actions/save_tool":465,"models/tools/actions/undo_tool":466,"models/tools/actions/zoom_in_tool":467,"models/tools/actions/zoom_base_tool":468,"core/util/zoom":469,"models/tools/actions/zoom_out_tool":470,"models/tools/edit/edit_tool":471,"models/tools/edit/box_edit_tool":472,"models/tools/edit/freehand_draw_tool":473,"models/tools/edit/point_draw_tool":474,"models/tools/edit/poly_draw_tool":475,"models/tools/edit/poly_tool":476,"models/tools/edit/poly_edit_tool":477,"models/tools/gestures/box_select_tool":478,"models/tools/gestures/select_tool":479,"models/tools/util":480,"models/tools/gestures/box_zoom_tool":481,"models/tools/gestures/lasso_select_tool":482,"models/tools/gestures/poly_select_tool":483,"models/tools/edit/line_edit_tool":484,"models/tools/edit/line_tool":485,"models/tools/gestures/pan_tool":486,"models/tools/gestures/range_tool":487,"models/tools/gestures/tap_tool":488,"models/tools/gestures/wheel_pan_tool":489,"models/tools/gestures/wheel_zoom_tool":490,"models/tools/inspectors/crosshair_tool":491,"models/tools/inspectors/customjs_hover":492,"models/tools/inspectors/hover_tool":493,"models/tools/tool_proxy":494,"models/tools/toolbar_box":495,"embed/standalone":496,"embed/dom":497,"embed/server":498,"client/connection":499,"protocol/message":500,"protocol/receiver":501,"client/session":502,"embed/notebook":503,"styles/notebook.css":504,"protocol/index":505,"testing":506,"safely":507}, {});
})

