

import numpy as np
from .. import _base



class RSXLHotellings2(_base.DatasetHotellings2):
	def _set_values(self):
		self.www  = 'http://www.real-statistics.com/multivariate-statistics/hotellings-t-square-statistic/hotellings-t-square-independent-samples/'
		self.YA = np.array([
		[38.4,36.8,40.0,39.8,38.6,39.1,38.9,36.8,40.4,39.4,38.0,38.6,40.1,38.1,37.2,39.5,37.3,39.1,39.9,37.8],
		[73,85,58,80,68,52,79,100,64,53,70,75,48,57,78,65,77,67,52,68],
		[18,14,20,20,25,27,26,8,21,22,15,14,28,22,16,18,13,16,10,13]
		]).T
		self.YB = np.array([
		[40.9,39.5,39.4,38.2,39.7,38.9,38.6,39.9,41.3,38.1,39.6,37.1,39.5,40.3,41.5,39.3,37.6,40.6],
		[54,75,57,71,65,49,58,52,62,57,78,92,63,52,46,56,86,48],
		[14,18,24,24,22,30,25,17,18,20,19,15,13,25,27,14,16,21]
		]).T
		self.z    = 4.116057
		self.df   = (3, 36)
		self.p    = 0.291687



class HELPHomeless(_base.DatasetHotellings2):
	def _set_values(self):
		self.www  = 'http://sas-and-r.blogspot.jp/2010/05/example-737-calculation-of-hotellings.html'
		YA = np.array([
			58.413689, 25.111990, 49.000000,
			74.806328, 6.762923, 39.000000,
			61.931679, 43.967880, 15.000000,
			46.475212, 55.508991, 6.000000,
			24.515039, 21.793024, 52.000000,
			60.079155, 43.974678, 46.000000,
			41.933762, 13.382205, 49.000000,
			55.169975, 23.608444, 43.000000,
			56.438370, 42.166462, 19.000000,
			37.452137, 15.458271, 52.000000,
			34.339260, 55.128109, 37.000000,
			36.584812, 20.871447, 35.000000,
			61.640980, 47.286739, 18.000000,
			36.010075, 21.668474, 19.000000,
			63.060059, 37.371555, 30.000000,
			43.533741, 46.340755, 24.000000,
			53.351093, 54.774349, 26.000000,
			56.739849, 27.495481, 29.000000,
			62.041134, 37.006042, 37.000000,
			38.395294, 39.897774, 23.000000,
			56.683887, 45.134098, 21.000000,
			50.064266, 29.412977, 36.000000,
			52.698978, 59.454094, 5.000000,
			56.386688, 20.999893, 25.000000,
			58.161690, 26.773279, 27.000000,
			46.750862, 24.000315, 46.000000,
			29.456249, 47.671936, 16.000000,
			40.460560, 26.653036, 44.000000,
			50.163181, 31.501711, 25.000000,
			50.398701, 24.998930, 26.000000,
			55.233715, 33.374172, 29.000000,
			52.688705, 35.839642, 28.000000,
			67.536255, 17.565235, 33.000000,
			53.156864, 39.934162, 26.000000,
			54.382725, 26.697262, 30.000000,
			55.321888, 15.447794, 43.000000,
			27.366629, 38.752102, 28.000000,
			58.258945, 34.839962, 29.000000,
			63.913666, 22.957235, 32.000000,
			57.077774, 13.134663, 42.000000,
			59.567081, 26.221968, 29.000000,
			58.214767, 52.926834, 10.000000,
			43.942955, 28.858498, 37.000000,
			38.460903, 39.298168, 16.000000,
			37.185188, 47.550678, 15.000000,
			57.334923, 37.845036, 30.000000,
			60.587326, 51.788670, 8.000000,
			40.488838, 19.595461, 47.000000,
			48.057327, 15.754984, 30.000000,
			30.234055, 23.659925, 48.000000,
			65.744247, 34.737865, 17.000000,
			51.810452, 23.299021, 30.000000,
			63.613796, 40.941338, 24.000000,
			46.414642, 24.330456, 25.000000,
			46.750633, 50.788845, 17.000000,
			63.482277, 15.822761, 45.000000,
			43.621422, 45.402626, 28.000000,
			57.950001, 53.616177, 17.000000,
			54.443890, 59.264427, 23.000000,
			54.108536, 24.747171, 39.000000,
			43.001476, 21.912630, 47.000000,
			34.336983, 19.156574, 51.000000,
			39.332600, 18.465418, 58.000000,
			28.930092, 39.450993, 28.000000,
			49.290424, 37.438934, 15.000000,
			33.489250, 20.310446, 35.000000,
			59.105999, 40.676174, 21.000000,
			42.012848, 28.075939, 33.000000,
			28.740854, 22.787546, 26.000000,
			40.242710, 22.017500, 48.000000,
			45.567505, 24.422007, 34.000000,
			29.785292, 33.517311, 31.000000,
			53.759502, 24.090509, 26.000000,
			57.387768, 50.030434, 15.000000,
			50.238102, 20.069775, 48.000000,
			56.005066, 18.211269, 37.000000,
			44.924061, 30.071957, 20.000000,
			61.786114, 28.679745, 38.000000,
			54.354439, 20.517740, 39.000000,
			55.749718, 31.188143, 46.000000,
			56.840050, 56.784805, 6.000000,
			36.569595, 39.074711, 18.000000,
			30.508114, 36.651463, 39.000000,
			52.941685, 10.564762, 31.000000,
			26.456942, 39.270416, 43.000000,
			40.466446, 18.771036, 45.000000,
			32.961887, 20.119982, 46.000000,
			54.078171, 50.018494, 29.000000,
			43.240620, 18.324743, 38.000000,
			53.615040, 7.938221, 51.000000,
			35.973614, 20.356680, 57.000000,
			61.286335, 40.167236, 39.000000,
			35.227016, 22.815102, 43.000000,
			66.593170, 25.615507, 23.000000,
			58.166420, 27.122667, 12.000000,
			31.528608, 36.823708, 35.000000,
			49.363201, 17.509274, 47.000000,
			43.170815, 17.927528, 53.000000,
			57.819687, 47.711655, 15.000000,
			54.822636, 20.731987, 31.000000,
			60.418163, 52.455845, 27.000000,
			37.037781, 36.100307, 36.000000,
			41.669926, 33.259956, 24.000000,
			48.219265, 12.323594, 54.000000,
			54.369129, 23.058514, 31.000000,
			35.791451, 45.011848, 22.000000,
			59.322884, 48.410297, 23.000000,
			48.370895, 27.641029, 18.000000,
			23.482084, 54.768539, 34.000000,
			56.305130, 35.955441, 40.000000,
			57.836906, 14.919310, 38.000000,
			56.902859, 40.462433, 37.000000,
			47.363525, 37.674961, 33.000000,
			56.899628, 57.260887, 4.000000,
			46.799423, 44.351089, 24.000000,
			43.250214, 26.311474, 40.000000,
			52.422035, 27.471394, 39.000000,
			34.580116, 30.280018, 40.000000,
			48.278988, 47.979435, 22.000000,
			48.971756, 13.968738, 42.000000,
			46.368793, 41.867615, 13.000000,
			63.255444, 25.039495, 49.000000,
			70.147789, 14.480626, 43.000000,
			37.358650, 23.547628, 30.000000,
			53.055038, 27.650967, 35.000000,
			57.246483, 34.048084, 19.000000,
			44.855839, 32.384045, 36.000000,
			47.654675, 16.125675, 58.000000,
			44.011944, 17.625854, 38.000000,
			52.856579, 47.442879, 22.000000,
			49.476074, 58.168713, 11.000000,
			41.871223, 31.777193, 32.000000,
			60.106579, 52.955296, 33.000000,
			35.466827, 24.813925, 39.000000,
			62.448338, 46.830055, 27.000000,
			42.326027, 16.398746, 43.000000,
			57.785564, 36.798199, 30.000000,
			48.623009, 26.919926, 40.000000,
			61.602615, 37.953053, 17.000000,
			51.387428, 31.877844, 44.000000,
			33.797443, 54.970051, 15.000000,
			44.295021, 27.607288, 51.000000,
			46.760403, 29.505835, 24.000000,
			49.877594, 21.931257, 29.000000,
			36.637699, 28.558788, 33.000000,
			33.076420, 20.911337, 51.000000,
			62.819298, 11.819070, 46.000000,
			52.356514, 21.543468, 38.000000,
			46.568493, 56.963795, 11.000000,
			46.749714, 14.415197, 56.000000,
			40.117836, 41.195469, 14.000000,
			30.272823, 36.719200, 26.000000,
			51.749893, 48.008137, 36.000000,
			64.350296, 34.747746, 41.000000,
			58.894703, 58.477470, 18.000000,
			36.109493, 62.031616, 19.000000,
			32.447716, 20.220354, 45.000000,
			54.086136, 34.541599, 18.000000,
			51.242710, 23.137871, 33.000000,
			33.035706, 22.939909, 32.000000,
			33.922134, 33.888065, 20.000000,
			52.514042, 7.035307, 51.000000,
			41.323502, 19.718121, 27.000000,
			51.011803, 55.912579, 8.000000,
			45.135784, 38.851971, 35.000000,
			54.943314, 17.837486, 55.000000,
			58.714779, 58.851147, 8.000000,
			43.607494, 18.287806, 51.000000,
			52.029179, 37.698196, 49.000000,
			31.111467, 13.852996, 54.000000,
			41.954006, 9.406377, 54.000000,
			51.277905, 27.495565, 42.000000,
			62.977894, 41.010502, 31.000000,
			36.645973, 21.599306, 37.000000,
			66.090675, 18.604780, 41.000000,
			64.182983, 31.856297, 38.000000,
			43.393421, 26.698538, 38.000000,
			48.987770, 28.639238, 27.000000,
			54.158619, 44.215485, 26.000000,
			47.609478, 7.226597, 52.000000,
			59.145302, 57.296200, 24.000000,
			32.996754, 19.819555, 40.000000,
			56.691895, 29.213017, 33.000000,
			61.196648, 36.029205, 31.000000,
			56.565254, 31.255833, 27.000000,
			57.049194, 32.313843, 21.000000,
			57.731491, 40.056877, 29.000000,
			43.899105, 18.340139, 35.000000,
			64.918648, 31.077631, 29.000000,
			49.433208, 38.907230, 21.000000,
			36.493664, 38.276970, 23.000000,
			14.074291, 45.859604, 36.000000,
			54.523979, 51.922516, 32.000000,
			56.855679, 22.730097, 25.000000,
			44.176655, 25.445648, 35.000000,
			51.921627, 47.133209, 16.000000,
			56.866798, 42.632927, 27.000000,
			48.115887, 15.101494, 44.000000,
			33.531105, 24.930353, 52.000000,
			59.721279, 51.843193, 11.000000,
			20.740292, 43.498222, 37.000000,
			60.114563, 14.891697, 37.000000,
			44.597282, 41.360710, 30.000000,
			38.401871, 30.701563, 42.000000,
			62.089428, 41.624706, 15.000000,
			59.992928, 43.441059, 12.000000,
			53.540253, 42.457150, 10.000000,
			42.314945, 22.337873, 33.000000,
			46.040459, 18.750151, 57.000000,
			40.838848, 15.268264, 49.000000,
			58.786728, 40.633827, 26.000000,
			36.509884, 46.269627, 28.000000,
			58.215115, 57.834595, 3.000000,
			45.008259, 33.659222, 18.000000,
			41.097809, 47.773228, 39.000000,
			47.656952, 15.599421, 45.000000,
			59.082024, 36.594727, 31.000000,
			57.762695, 28.590870, 34.000000,
			41.003696, 15.078867, 21.000000,
			60.971848, 31.680859, 38.000000,
			59.917011, 19.096197, 36.000000,
			58.508629, 48.442287, 24.000000,
			58.584522, 52.697727, 10.000000,
			64.952385, 19.919922, 41.000000,
			49.446564, 13.312669, 51.000000,
			27.270058, 33.820976, 29.000000,
			66.231323, 11.499865, 56.000000,
			32.354843, 26.392733, 34.000000,
			58.860020, 52.945427, 4.000000,
			56.953880, 39.972664, 32.000000,
			53.936069, 28.061911, 27.000000,
			49.217468, 57.800064, 7.000000,
			51.451328, 12.204219, 35.000000,
			58.757587, 45.425110, 23.000000,
			47.926212, 39.038631, 36.000000,
			23.550434, 23.898293, 48.000000,
			54.981388, 25.676130, 29.000000,
			46.423443, 33.345051, 23.000000,
			59.428616, 54.525818, 14.000000,
			38.491070, 44.171612, 27.000000,
			38.246002, 23.716438, 47.000000,
			52.023380, 28.609346, 37.000000,
			56.968681, 41.943066, 28.000000,
			57.253838, 62.175503, 37.000000
		])
		
		YB = np.array([
			36.036942, 26.670307, 30.000000,
			37.345585, 21.675755, 39.000000,
			65.138008, 9.160530, 32.000000,
			38.270878, 22.029678, 50.000000,
			22.610598, 36.143761, 46.000000,
			39.242641, 49.089302, 22.000000,
			31.829649, 25.846157, 36.000000,
			44.776512, 29.799828, 35.000000,
			58.298073, 16.732292, 40.000000,
			46.221764, 19.620596, 36.000000,
			51.563236, 44.442104, 28.000000,
			61.825974, 34.335667, 27.000000,
			42.224903, 27.717710, 47.000000,
			42.400593, 18.984324, 45.000000,
			50.146999, 58.241264, 18.000000,
			63.520004, 27.852608, 11.000000,
			53.233963, 56.324333, 34.000000,
			51.303295, 18.640594, 41.000000,
			71.392593, 15.861924, 16.000000,
			52.619774, 24.148815, 36.000000,
			36.045876, 29.901625, 17.000000,
			62.031830, 35.206970, 19.000000,
			40.384377, 29.390280, 36.000000,
			45.483406, 17.925251, 44.000000,
			63.058071, 34.434696, 29.000000,
			57.202129, 28.469273, 42.000000,
			47.605145, 26.065777, 30.000000,
			35.124699, 27.575460, 33.000000,
			36.980579, 20.025341, 44.000000,
			64.290222, 25.812592, 29.000000,
			36.040157, 17.705963, 57.000000,
			45.184990, 23.996725, 31.000000,
			56.904411, 28.418003, 30.000000,
			48.791363, 33.115913, 34.000000,
			52.593800, 14.913925, 49.000000,
			68.123955, 17.449858, 36.000000,
			42.628937, 19.344807, 40.000000,
			44.169952, 34.210976, 31.000000,
			59.824535, 26.918222, 32.000000,
			56.504761, 54.053368, 4.000000,
			28.854721, 20.202173, 44.000000,
			30.054058, 32.566528, 16.000000,
			55.980831, 16.302422, 49.000000,
			44.535892, 27.993336, 36.000000,
			55.501217, 15.618371, 39.000000,
			54.132172, 15.196477, 51.000000,
			40.183102, 23.554617, 37.000000,
			48.899784, 12.432887, 38.000000,
			54.794624, 27.136280, 53.000000,
			36.688736, 41.321629, 26.000000,
			59.741077, 28.972683, 49.000000,
			48.898441, 16.284695, 34.000000,
			40.882389, 41.590557, 33.000000,
			60.920475, 42.539974, 4.000000,
			35.393791, 22.669971, 40.000000,
			57.323181, 45.529411, 33.000000,
			45.542591, 23.729639, 28.000000,
			45.016178, 21.460621, 45.000000,
			37.797176, 28.505577, 45.000000,
			48.876808, 33.652927, 31.000000,
			40.962341, 40.156929, 28.000000,
			38.136059, 45.491100, 22.000000,
			29.472023, 23.371147, 39.000000,
			50.215328, 34.598862, 31.000000,
			36.248386, 29.082914, 48.000000,
			45.165199, 33.366123, 35.000000,
			59.476482, 18.690155, 46.000000,
			31.979588, 27.683458, 34.000000,
			53.665371, 47.145802, 10.000000,
			24.435177, 41.131794, 34.000000,
			61.444740, 43.881058, 17.000000,
			55.738445, 52.197483, 29.000000,
			32.287056, 21.200043, 51.000000,
			31.003801, 22.640652, 49.000000,
			42.120693, 25.257971, 44.000000,
			45.461384, 21.049545, 41.000000,
			35.906189, 22.442661, 38.000000,
			37.755672, 27.171751, 53.000000,
			57.707630, 41.054363, 29.000000,
			53.683182, 29.860514, 31.000000,
			54.424751, 26.252979, 38.000000,
			38.102268, 40.032974, 19.000000,
			49.279812, 14.358881, 44.000000,
			21.919056, 43.353584, 34.000000,
			57.643612, 37.953403, 41.000000,
			38.515968, 16.786348, 60.000000,
			23.502375, 46.119808, 26.000000,
			41.064541, 30.300137, 40.000000,
			58.165104, 59.453930, 1.000000,
			41.572796, 23.546112, 41.000000,
			54.596619, 46.729744, 16.000000,
			58.494549, 16.469986, 34.000000,
			48.483307, 35.235611, 40.000000,
			56.394989, 48.239128, 39.000000,
			47.350830, 30.371395, 32.000000,
			29.111393, 22.884369, 51.000000,
			46.768940, 26.453758, 35.000000,
			50.258759, 52.789551, 27.000000,
			29.491123, 35.576111, 40.000000,
			42.422089, 26.799009, 38.000000,
			25.618147, 27.808109, 39.000000,
			43.005867, 27.177586, 34.000000,
			41.787891, 31.328341, 39.000000,
			43.682377, 27.898603, 46.000000,
			43.553776, 23.683241, 31.000000,
			51.495556, 31.781149, 33.000000,
			32.587826, 55.991005, 12.000000,
			53.046776, 41.624405, 42.000000,
			46.335079, 19.645632, 31.000000,
			51.403080, 30.701992, 41.000000,
			59.282722, 20.979116, 40.000000,
			45.793999, 44.446507, 30.000000,
			46.986740, 25.548498, 42.000000,
			56.953285, 34.139271, 17.000000,
			44.115524, 29.400602, 22.000000,
			37.838722, 27.601431, 37.000000,
			35.706642, 16.718819, 48.000000,
			35.893784, 24.378925, 44.000000,
			39.933838, 28.447634, 52.000000,
			71.628555, 18.677704, 19.000000,
			59.342735, 58.899960, 9.000000,
			48.611134, 15.773271, 55.000000,
			39.092793, 17.926985, 45.000000,
			51.162331, 51.918278, 12.000000,
			25.924225, 34.412716, 37.000000,
			36.524067, 22.237560, 39.000000,
			31.765726, 22.354912, 43.000000,
			51.089134, 28.747435, 40.000000,
			40.420063, 18.948950, 54.000000,
			34.092094, 16.922634, 58.000000,
			31.523521, 31.739616, 50.000000,
			63.778316, 24.923189, 19.000000,
			44.873104, 20.911737, 37.000000,
			63.906986, 32.773659, 20.000000,
			47.501781, 23.771542, 40.000000,
			30.349140, 23.242210, 37.000000,
			45.324978, 22.447948, 43.000000,
			34.314449, 27.218351, 56.000000,
			55.440147, 60.542084, 7.000000,
			32.126095, 37.835770, 36.000000,
			58.152458, 18.615227, 53.000000,
			46.520691, 47.255920, 15.000000,
			27.090862, 19.808329, 53.000000,
			57.596512, 57.873539, 6.000000,
			37.806725, 39.963680, 40.000000,
			53.422123, 44.767254, 36.000000,
			25.436829, 29.332056, 40.000000,
			59.914581, 19.291830, 39.000000,
			57.657391, 53.340359, 9.000000,
			51.706692, 51.003738, 36.000000,
			63.342705, 30.918043, 16.000000,
			51.153301, 24.849377, 34.000000,
			38.196178, 17.863741, 46.000000,
			57.448891, 48.483433, 24.000000,
			64.073929, 27.514502, 25.000000,
			65.267593, 25.465322, 37.000000,
			41.738495, 38.778580, 28.000000,
			53.018211, 58.750145, 6.000000,
			54.066708, 37.504734, 23.000000,
			48.814842, 14.108759, 55.000000,
			58.224682, 59.930012, 3.000000,
			48.761135, 26.474701, 36.000000,
			37.749706, 57.489437, 40.000000,
			36.811359, 41.324745, 28.000000,
			45.180672, 22.673281, 34.000000,
			36.355568, 30.106504, 42.000000,
			42.869740, 25.544411, 30.000000,
			58.748466, 46.967522, 23.000000,
			50.266022, 54.851093, 14.000000,
			45.584740, 19.116766, 48.000000,
			49.180843, 25.710777, 41.000000,
			44.220387, 32.484653, 41.000000,
			54.932957, 18.795931, 31.000000,
			47.580624, 18.525930, 34.000000,
			34.908932, 25.738285, 40.000000,
			46.698769, 16.863588, 42.000000,
			47.008553, 17.082233, 51.000000,
			51.694481, 27.801510, 39.000000,
			53.172264, 28.556833, 17.000000,
			47.831909, 28.602417, 20.000000,
			41.101353, 27.717655, 23.000000,
			41.527767, 21.645960, 39.000000,
			32.877651, 23.724752, 51.000000,
			69.171608, 9.732559, 47.000000,
			45.822426, 28.475632, 28.000000,
			54.090694, 55.479382, 41.000000,
			59.734077, 38.950596, 41.000000,
			58.843822, 15.686288, 45.000000,
			40.406437, 23.446474, 38.000000,
			61.746883, 42.341843, 26.000000,
			63.863270, 28.073883, 21.000000,
			35.986275, 37.116608, 30.000000,
			51.635689, 37.102394, 15.000000,
			59.165474, 46.330513, 31.000000,
			42.085346, 13.412563, 54.000000,
			51.015980, 49.503277, 21.000000,
			38.865021, 18.594315, 21.000000,
			52.718384, 18.530807, 33.000000,
			52.739876, 47.779892, 24.000000,
			45.729160, 21.271496, 33.000000,
			61.978653, 39.929405, 25.000000,
			60.465115, 25.632202, 37.000000,
			45.270355, 34.152245, 40.000000,
			57.126736, 52.792542, 9.000000,
			34.516228, 17.050970, 47.000000,
			50.608341, 25.851772, 34.000000,
			40.045715, 33.434536, 28.000000,
			53.732044, 54.424816, 11.000000,
			43.476074, 30.212227, 35.000000
		])
		self.YA  = np.reshape(YA,(-1,3))
		self.YB  = np.reshape(YB,(-1,3))
		self.z    = 6.132267
		self.df   = (3, 451)
		self.p    = 0.1082217




















