# Generated by Django 2.0.7 on 2018-07-10 19:10

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [migrations.swappable_dependency(settings.AUTH_USER_MODEL), ("inventory", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="CostModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "createtime",
                    models.DateTimeField(default=django.utils.timezone.now, editable=False, help_text="Create time"),
                ),
                (
                    "lastupdatetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False, help_text="Time of the last change."
                    ),
                ),
                ("name", models.CharField(help_text="Your start number", max_length=15)),
                (
                    "amount",
                    models.DecimalField(decimal_places=2, help_text="How much did you pay for this?", max_digits=8),
                ),
            ],
            options={"verbose_name": "Participation Cost", "verbose_name_plural": "Participation Costs"},
        ),
        migrations.CreateModel(
            name="ParticipationModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "createtime",
                    models.DateTimeField(default=django.utils.timezone.now, editable=False, help_text="Create time"),
                ),
                (
                    "lastupdatetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False, help_text="Time of the last change."
                    ),
                ),
                (
                    "duration",
                    models.TimeField(
                        blank=True,
                        help_text="You officially measured finisher time",
                        null=True,
                        verbose_name="Duration",
                    ),
                ),
                (
                    "start_number",
                    models.CharField(blank=True, help_text="Your start number", max_length=15, null=True),
                ),
                (
                    "finisher_count",
                    models.PositiveIntegerField(
                        blank=True, help_text="Number of participants who have finished in your discipline", null=True
                    ),
                ),
                (
                    "distance",
                    models.ForeignKey(
                        help_text="Length in meters of your event participation",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="event_participations",
                        to="inventory.DistanceModel",
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="participations",
                        to="inventory.EventModel",
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        help_text="The person who participated to this competition.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"verbose_name": "Event Participation", "verbose_name_plural": "Event Participations"},
        ),
        migrations.AddField(
            model_name="costmodel",
            name="participation",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="costs", to="inventory.ParticipationModel"
            ),
        ),
    ]
