"""Module containing the logic for console command line examples"""

import sys
from textwrap import dedent
from dgspoc.utils import Printer


class TemplateExample:

    @classmethod
    def get(cls, index):
        result = getattr(cls, 'get_example_{}'.format(index))()
        return result

    @classmethod
    def get_example_1(cls):
        header = Printer.get((
            'Example: Use dgs tool to generate template to parse digits, words, and digits '
            'as index, name, and total columns'
        ))

        body = dedent("""            
            test@test_machine ~ % snippet="word(var_col1)  digits(var_col2)  word(var_col3) -> Record"
            test@test_machine ~ % dgs build template "${snippet}"
            ################################################################################
            # Template is generated by templateapp Community Edition
            # Created date: 2022-03-22
            ################################################################################
            Value index (\d+)
            Value name ([a-zA-Z0-9]+( [a-zA-Z0-9]+)*)
            Value total (\d+)
            
            Start
              ^${index} +${name} +${total} -> Record
            test@test_machine ~ %
        """).strip()

        return '{}\n\n{}'.format(header, body)

    @classmethod
    def get_example_2(cls):
        header = Printer.get((
            'Example: Use dgs tool to generate template to parse digits, words, and digits '
            'as index, name, and total columns.  Note: user snippet is stored in file.'
        ))

        body = dedent("""            
            test@test_machine ~ % snippet_file=user_snippet.txt
            test@test_machine ~ % 
            test@test_machine ~ % cat $snippet_file
            digits(var_index)  words(var_name)  digits(var_total) -> Record
            test@test_machine ~ % 
            test@test_machine ~ % dgs build template ${snippet_file}
            ################################################################################
            # Template is generated by templateapp Community Edition
            # Created date: 2022-03-22
            ################################################################################
            Value index (\d+)
            Value name ([a-zA-Z0-9]+( [a-zA-Z0-9]+)*)
            Value total (\d+)
            
            Start
              ^${index} +${name} +${total} -> Record
            test@test_machine ~ % 
            test@test_machine ~ %
        """).strip()

        return '{}\n\n{}'.format(header, body)

    @classmethod
    def get_example_3(cls):
        header = Printer.get((
            'Example: Use dgs tool to generate template to parse digits, words, and digits '
            'as index, name, and total columns.  End-user wants to include author, '
            'email, company flags.'
        ))

        body = dedent("""            
            test@test_machine ~ % snippet_file=user_snippet.txt
            test@test_machine ~ % 
            test@test_machine ~ % cat $snippet_file
            digits(var_index)  words(var_name)  digits(var_total) -> Record
            test@test_machine ~ % 
            test@test_machine ~ % author=user1
            test@test_machine ~ % email=user1@abc_xyz.com
            test@test_machine ~ % company="ABC XYZ Inc."
            test@test_machine ~ % 
            test@test_machine ~ % dgs build template ${snippet_file} --author="${author}" --email="${email}" --company="${company}"
            ################################################################################
            # Template is generated by templateapp Community Edition
            # Created by  : user1
            # Email       : user1@abc_xyz.com
            # Company     : ABC XYZ Inc.
            # Created date: 2022-03-22
            ################################################################################
            Value index (\d+)
            Value name ([a-zA-Z0-9]+( [a-zA-Z0-9]+)*)
            Value total (\d+)

            Start
              ^${index} +${name} +${total} -> Record
            test@test_machine ~ % 
            test@test_machine ~ %
        """).strip()

        return '{}\n\n{}'.format(header, body)

    @classmethod
    def get_example_4(cls):
        header = Printer.get((
            'Example: Use dgs tool to generate template to parse digits, words, and digits '
            'as index, name, and total columns.  End-user wants to include author, '
            'email, company flags.  Furthermore, end-user wants to save generated '
            'template to file user_folder/template1.textfsm'
        ))

        body = dedent("""            
            test@test_machine ~ % snippet_file=user_snippet.txt
            test@test_machine ~ % 
            test@test_machine ~ % cat $snippet_file
            digits(var_index)  words(var_name)  digits(var_total) -> Record
            test@test_machine ~ % 
            test@test_machine ~ % author=user1
            test@test_machine ~ % email=user1@abc_xyz.com
            test@test_machine ~ % company="ABC XYZ Inc."
            test@test_machine ~ %
            test@test_machine ~ % tmpl_file="user_folder/template1.txt"
            test@test_machine ~ % 
            test@test_machine ~ % 
            test@test_machine ~ % dgs build template ${snippet_file} --author="${author}" --email="${email}" --company="${company}" --save=${tmpl_file}
            2022-03-22 17:42:23.705230 - /Users/test/user_folder/template1.txt file is created.
            +------------------------------------------------------------------------------+
            | +++ Successfully saved generated template to                                 |
            | /Users/test/user_folder/template1.txt                                        |
            +------------------------------------------------------------------------------+
            test@test_machine ~ % 
            test@test_machine ~ %
            test@test_machine ~ % cat $tmpl_file
            ################################################################################
            # Template is generated by templateapp Community Edition
            # Created by  : user1
            # Email       : user1@abc_xyz.com
            # Company     : ABC XYZ Inc.
            # Created date: 2022-03-22
            ################################################################################
            Value index (\d+)
            Value name ([a-zA-Z0-9]+( [a-zA-Z0-9]+)*)
            Value total (\d+)
            
            Start
              ^${index} +${name} +${total} -> Record
            test@test_machine ~ %
        """).strip()

        return '{}\n\n{}'.format(header, body)

    @classmethod
    def get_example_5(cls):
        header = Printer.get((
            'Example: Use dgs tool to generate template to parse digits, words, and digits '
            'as index, name, and total columns.  End-user wants to include author, '
            'email, company flags.  Furthermore, end-user wants to upload generated '
            'template to template storage as template1'
        ))

        body = dedent("""            
            test@test_machine ~ % snippet_file=user_snippet.txt
            test@test_machine ~ % 
            test@test_machine ~ % cat $snippet_file
            digits(var_index)  words(var_name)  digits(var_total) -> Record
            test@test_machine ~ % 
            test@test_machine ~ % author=user1
            test@test_machine ~ % email=user1@abc_xyz.com
            test@test_machine ~ % company="ABC XYZ Inc."
            test@test_machine ~ %
            test@test_machine ~ % tmpl_id="template1"
            test@test_machine ~ % 
            test@test_machine ~ % 
            test@test_machine ~ % dgs build template ${snippet_file} --author="${author}" --email="${email}" --company="${company}" --template-id=${tmpl_id}
            +------------------------------------------------------------------------------+
            | +++ Successfully uploaded generated template to "template1" template ID.     |
            +------------------------------------------------------------------------------+
            test@test_machine ~ % 
            test@test_machine ~ %
        """).strip()

        return '{}\n\n{}'.format(header, body)
