API_BASE = "https://www.ebi.ac.uk/metagenomics/api/v1"
API_BASE_ENA = "https://www.ebi.ac.uk/ena/portal/api/"

mgnify_filters = [
    "experiment_type",
    "biome_name",
    "lineage",
    "geo_loc_name",
    "latitude_gte",
    "latitude_lte",
    "longitude_gte",
    "longitude_lte",
    "species",
    "instrument_model",
    "instrument_platform",
    "metadata_key",
    "metadata_value_gte",
    "metadata_value_lte",
    "metadata_value",
    "environment_material",
    "environment_feature",
    "study_accession",
    "include",
]
ena_library_strategy = [
    "WGS",
    "WGA",
    "WXS",
    "RNA-Seq",
    "ssRNA-seq",
    "miRNA-Seq",
    "ncRNA-Seq",
    "FL-cDNA",
    "EST",
    "Hi-C",
    "ATAC-seq",
    "WCS",
    "RAD-Seq",
    "CLONE",
    "POOLCLONE",
    "AMPLICON",
    "CLONEEND",
    "FINISHING",
    "ChIP-Seq",
    "MNase-Seq",
    "DNase-Hypersensitivity",
    "Bisulfite-Seq",
    "CTS",
    "MRE-Seq",
    "MeDIP-Seq",
    "MBD-Seq",
    "Tn-Seq",
    "VALIDATION",
    "FAIRE-seq",
    "SELEX",
    "RIP-Seq",
    "ChIA-PET",
    "Synthetic-Long-Read",
    "Targeted-Capture",
    "Tethered Chromatin Conformation Capture",
    "OTHER",
    "NOMe-Seq",
    "ChM-Seq",
    "GBS",
]

ena_library_source = [
    "GENOMIC",
    "GENOMIC SINGLE CELL",
    "TRANSCRIPTOMIC",
    "TRANSCRIPTOMIC SINGLE CELL",
    "METAGENOMIC",
    "METATRANSCRIPTOMIC",
    "SYNTHETIC",
    "VIRAL RNA",
    "OTHER",
]

ena_library_selection = [
    "RANDOM",
    "PCR",
    "RANDOM PCR",
    "RT-PCR",
    "HMPR",
    "MF",
    "repeat fractionation",
    "size fractionation",
    "MSLL",
    "cDNA",
    "cDNA_randomPriming",
    "cDNA_oligo_dT",
    "PolyA",
    "Oligo-dT",
    "Inverse rRNA",
    "Inverse rRNA selection",
    "ChIP",
    "ChIP-Seq",
    "MNase",
    "DNase",
    "Hybrid Selection",
    "Reduced Representation",
    "Restriction Digest",
    "5-methylcytidine antibody",
    "MBD2 protein methyl-CpG binding domain",
    "CAGE",
    "RACE",
    "MDA",
    "padlock probes capture method",
    "other",
    "unspecified",
]

ena_library_layout = ["PAIRED", "SINGLE"]

ena_instrument_platform = [
    "LS454",
    "ILLUMINA",
    "HELICOS",
    "ABI_SOLID",
    "COMPLETE_GENOMICS",
    "BGISEQ",
    "OXFORD_NANOPORE",
    "PACBIO_SMRT",
    "ION_TORRENT",
    "CAPILLARY",
    "DNBSEQ",
]

ena_instrument_model = [
    "454 GS",
    "454 GS 20",
    "454 GS FLX",
    "454 GS FLX Titanium",
    "454 GS FLX+",
    "454 GS Junior",
    "AB 310 Genetic Analyzer",
    "AB 3130 Genetic Analyzer",
    "AB 3130xL Genetic Analyzer",
    "AB 3500 Genetic Analyzer",
    "AB 3500xL Genetic Analyzer",
    "AB 3730 Genetic Analyzer",
    "AB 3730xL Genetic Analyzer",
    "AB 5500 Genetic Analyzer",
    "AB 5500xl Genetic Analyzer",
    "AB 5500xl-W Genetic Analysis System",
    "AB SOLiD 3 Plus System",
    "AB SOLiD 4 System",
    "AB SOLiD 4hq System",
    "AB SOLiD PI System",
    "AB SOLiD System",
    "AB SOLiD System 2.0",
    "AB SOLiD System 3.0",
    "BGISEQ-500",
    "Complete Genomics",
    "DNBSEQ-G400",
    "DNBSEQ-G400 FAST",
    "DNBSEQ-G50",
    "DNBSEQ-T7",
    "GridION",
    "Helicos HeliScope",
    "HiSeq X Five",
    "HiSeq X Ten",
    "Illumina Genome Analyzer",
    "Illumina Genome Analyzer II",
    "Illumina Genome Analyzer IIx",
    "Illumina HiScanSQ",
    "Illumina HiSeq 1000",
    "Illumina HiSeq 1500",
    "Illumina HiSeq 2000",
    "Illumina HiSeq 2500",
    "Illumina HiSeq 3000",
    "Illumina HiSeq 4000",
    "Illumina iSeq 100",
    "Illumina MiniSeq",
    "Illumina MiSeq",
    "Illumina NovaSeq 6000",
    "Ion Torrent PGM",
    "Ion Torrent Proton",
    "Ion Torrent S5",
    "Ion Torrent S5 XL",
    "MinION",
    "NextSeq 500",
    "NextSeq 550",
    "PacBio RS",
    "PacBio RS II",
    "PromethION",
    "Sequel",
    "Sequel II",
    "unspecified",
]

ena_filters = {
    "read_count": [],
    "instrument_model": ena_instrument_model,
    "instrument_platform": ena_instrument_platform,
    "library_layout": ena_library_layout,
    "library_strategy": ena_library_strategy,
    "library_selection": ena_library_selection,
    "library_source": ena_library_source,
}
