# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFirewallPolicyResult',
    'AwaitableGetFirewallPolicyResult',
    'get_firewall_policy',
    'get_firewall_policy_output',
]

@pulumi.output_type
class GetFirewallPolicyResult:
    """
    A collection of values returned by getFirewallPolicy.
    """
    def __init__(__self__, author=None, block_icmp_ping=None, block_metadata_service=None, description=None, id=None, inbound_networks=None, lastupdate=None, name=None, outbound_networks=None, type=None, version=None):
        if author and not isinstance(author, str):
            raise TypeError("Expected argument 'author' to be a str")
        pulumi.set(__self__, "author", author)
        if block_icmp_ping and not isinstance(block_icmp_ping, bool):
            raise TypeError("Expected argument 'block_icmp_ping' to be a bool")
        pulumi.set(__self__, "block_icmp_ping", block_icmp_ping)
        if block_metadata_service and not isinstance(block_metadata_service, bool):
            raise TypeError("Expected argument 'block_metadata_service' to be a bool")
        pulumi.set(__self__, "block_metadata_service", block_metadata_service)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inbound_networks and not isinstance(inbound_networks, list):
            raise TypeError("Expected argument 'inbound_networks' to be a list")
        pulumi.set(__self__, "inbound_networks", inbound_networks)
        if lastupdate and not isinstance(lastupdate, int):
            raise TypeError("Expected argument 'lastupdate' to be a int")
        pulumi.set(__self__, "lastupdate", lastupdate)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_networks and not isinstance(outbound_networks, list):
            raise TypeError("Expected argument 'outbound_networks' to be a list")
        pulumi.set(__self__, "outbound_networks", outbound_networks)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def author(self) -> str:
        """
        Username of the account that created the policy.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="blockIcmpPing")
    def block_icmp_ping(self) -> bool:
        """
        Indicates whether policy includes blocking incoming 'ping' requests.
        """
        return pulumi.get(self, "block_icmp_ping")

    @property
    @pulumi.getter(name="blockMetadataService")
    def block_metadata_service(self) -> bool:
        """
        Indicates whether policy includes blocking metadata services of the cloud.
        """
        return pulumi.get(self, "block_metadata_service")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Firewall Policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundNetworks")
    def inbound_networks(self) -> Sequence['outputs.GetFirewallPolicyInboundNetworkResult']:
        """
        Information on network addresses that are allowed to pass in data or requests.
        """
        return pulumi.get(self, "inbound_networks")

    @property
    @pulumi.getter
    def lastupdate(self) -> int:
        """
        Timestamp of the last update in Unix time format.
        """
        return pulumi.get(self, "lastupdate")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the policy, no longer than 128 characters and no slash characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundNetworks")
    def outbound_networks(self) -> Optional[Sequence['outputs.GetFirewallPolicyOutboundNetworkResult']]:
        """
        Information on network addresses that are allowed to receive data or requests.
        """
        return pulumi.get(self, "outbound_networks")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the class of protection defined by the firewall.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Aqua version functionality supported
        """
        return pulumi.get(self, "version")


class AwaitableGetFirewallPolicyResult(GetFirewallPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallPolicyResult(
            author=self.author,
            block_icmp_ping=self.block_icmp_ping,
            block_metadata_service=self.block_metadata_service,
            description=self.description,
            id=self.id,
            inbound_networks=self.inbound_networks,
            lastupdate=self.lastupdate,
            name=self.name,
            outbound_networks=self.outbound_networks,
            type=self.type,
            version=self.version)


def get_firewall_policy(name: Optional[str] = None,
                        outbound_networks: Optional[Sequence[pulumi.InputType['GetFirewallPolicyOutboundNetworkArgs']]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallPolicyResult:
    """
    Use this data source to access information about an existing resource.

    :param str name: Name of the policy, no longer than 128 characters and no slash characters.
    :param Sequence[pulumi.InputType['GetFirewallPolicyOutboundNetworkArgs']] outbound_networks: Information on network addresses that are allowed to receive data or requests.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['outboundNetworks'] = outbound_networks
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aquasec:index/getFirewallPolicy:getFirewallPolicy', __args__, opts=opts, typ=GetFirewallPolicyResult).value

    return AwaitableGetFirewallPolicyResult(
        author=__ret__.author,
        block_icmp_ping=__ret__.block_icmp_ping,
        block_metadata_service=__ret__.block_metadata_service,
        description=__ret__.description,
        id=__ret__.id,
        inbound_networks=__ret__.inbound_networks,
        lastupdate=__ret__.lastupdate,
        name=__ret__.name,
        outbound_networks=__ret__.outbound_networks,
        type=__ret__.type,
        version=__ret__.version)


@_utilities.lift_output_func(get_firewall_policy)
def get_firewall_policy_output(name: Optional[pulumi.Input[str]] = None,
                               outbound_networks: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFirewallPolicyOutboundNetworkArgs']]]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFirewallPolicyResult]:
    """
    Use this data source to access information about an existing resource.

    :param str name: Name of the policy, no longer than 128 characters and no slash characters.
    :param Sequence[pulumi.InputType['GetFirewallPolicyOutboundNetworkArgs']] outbound_networks: Information on network addresses that are allowed to receive data or requests.
    """
    ...
