# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionRuntimePolicyArgs', 'FunctionRuntimePolicy']

@pulumi.input_type
class FunctionRuntimePolicyArgs:
    def __init__(__self__, *,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_malicious_executables: Optional[pulumi.Input[bool]] = None,
                 block_malicious_executables_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_running_executables_in_tmp_folder: Optional[pulumi.Input[bool]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 honeypot_access_key: Optional[pulumi.Input[str]] = None,
                 honeypot_apply_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 honeypot_secret_key: Optional[pulumi.Input[str]] = None,
                 honeypot_serverless_app_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]]] = None):
        """
        The set of arguments for constructing a FunctionRuntimePolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] block_malicious_executables: If true, prevent creation of malicious executables in functions during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_malicious_executables_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[bool] block_running_executables_in_tmp_folder: If true, prevent running of executables in functions locate in /tmp folder during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[str] description: The description of the function runtime policy
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[str] honeypot_access_key: Honeypot User ID (Access Key)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] honeypot_apply_ons: List of options to apply the honeypot on (Environment Vairable, Layer, File)
        :param pulumi.Input[str] honeypot_secret_key: Honeypot User Password (Secret Key)
        :param pulumi.Input[str] honeypot_serverless_app_name: Serverless application name
        :param pulumi.Input[str] name: Name of the function runtime policy
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]] scope_variables: List of scope attributes.
        """
        if application_scopes is not None:
            pulumi.set(__self__, "application_scopes", application_scopes)
        if block_malicious_executables is not None:
            pulumi.set(__self__, "block_malicious_executables", block_malicious_executables)
        if block_malicious_executables_allowed_processes is not None:
            pulumi.set(__self__, "block_malicious_executables_allowed_processes", block_malicious_executables_allowed_processes)
        if block_running_executables_in_tmp_folder is not None:
            pulumi.set(__self__, "block_running_executables_in_tmp_folder", block_running_executables_in_tmp_folder)
        if blocked_executables is not None:
            pulumi.set(__self__, "blocked_executables", blocked_executables)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if honeypot_access_key is not None:
            pulumi.set(__self__, "honeypot_access_key", honeypot_access_key)
        if honeypot_apply_ons is not None:
            pulumi.set(__self__, "honeypot_apply_ons", honeypot_apply_ons)
        if honeypot_secret_key is not None:
            pulumi.set(__self__, "honeypot_secret_key", honeypot_secret_key)
        if honeypot_serverless_app_name is not None:
            pulumi.set(__self__, "honeypot_serverless_app_name", honeypot_serverless_app_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope_expression is not None:
            pulumi.set(__self__, "scope_expression", scope_expression)
        if scope_variables is not None:
            pulumi.set(__self__, "scope_variables", scope_variables)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter(name="blockMaliciousExecutables")
    def block_malicious_executables(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent creation of malicious executables in functions during their runtime post invocation.
        """
        return pulumi.get(self, "block_malicious_executables")

    @block_malicious_executables.setter
    def block_malicious_executables(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_malicious_executables", value)

    @property
    @pulumi.getter(name="blockMaliciousExecutablesAllowedProcesses")
    def block_malicious_executables_allowed_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes that will be allowed
        """
        return pulumi.get(self, "block_malicious_executables_allowed_processes")

    @block_malicious_executables_allowed_processes.setter
    def block_malicious_executables_allowed_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "block_malicious_executables_allowed_processes", value)

    @property
    @pulumi.getter(name="blockRunningExecutablesInTmpFolder")
    def block_running_executables_in_tmp_folder(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent running of executables in functions locate in /tmp folder during their runtime post invocation.
        """
        return pulumi.get(self, "block_running_executables_in_tmp_folder")

    @block_running_executables_in_tmp_folder.setter
    def block_running_executables_in_tmp_folder(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_running_executables_in_tmp_folder", value)

    @property
    @pulumi.getter(name="blockedExecutables")
    def blocked_executables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of executables that are prevented from running in containers.
        """
        return pulumi.get(self, "blocked_executables")

    @blocked_executables.setter
    def blocked_executables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_executables", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the function runtime policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter(name="honeypotAccessKey")
    def honeypot_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Honeypot User ID (Access Key)
        """
        return pulumi.get(self, "honeypot_access_key")

    @honeypot_access_key.setter
    def honeypot_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_access_key", value)

    @property
    @pulumi.getter(name="honeypotApplyOns")
    def honeypot_apply_ons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of options to apply the honeypot on (Environment Vairable, Layer, File)
        """
        return pulumi.get(self, "honeypot_apply_ons")

    @honeypot_apply_ons.setter
    def honeypot_apply_ons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "honeypot_apply_ons", value)

    @property
    @pulumi.getter(name="honeypotSecretKey")
    def honeypot_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Honeypot User Password (Secret Key)
        """
        return pulumi.get(self, "honeypot_secret_key")

    @honeypot_secret_key.setter
    def honeypot_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_secret_key", value)

    @property
    @pulumi.getter(name="honeypotServerlessAppName")
    def honeypot_serverless_app_name(self) -> Optional[pulumi.Input[str]]:
        """
        Serverless application name
        """
        return pulumi.get(self, "honeypot_serverless_app_name")

    @honeypot_serverless_app_name.setter
    def honeypot_serverless_app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_serverless_app_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the function runtime policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]]]):
        pulumi.set(self, "scope_variables", value)


@pulumi.input_type
class _FunctionRuntimePolicyState:
    def __init__(__self__, *,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 block_malicious_executables: Optional[pulumi.Input[bool]] = None,
                 block_malicious_executables_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_running_executables_in_tmp_folder: Optional[pulumi.Input[bool]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 honeypot_access_key: Optional[pulumi.Input[str]] = None,
                 honeypot_apply_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 honeypot_secret_key: Optional[pulumi.Input[str]] = None,
                 honeypot_serverless_app_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]]] = None):
        """
        Input properties used for looking up and filtering FunctionRuntimePolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[bool] block_malicious_executables: If true, prevent creation of malicious executables in functions during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_malicious_executables_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[bool] block_running_executables_in_tmp_folder: If true, prevent running of executables in functions locate in /tmp folder during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[str] description: The description of the function runtime policy
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[str] honeypot_access_key: Honeypot User ID (Access Key)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] honeypot_apply_ons: List of options to apply the honeypot on (Environment Vairable, Layer, File)
        :param pulumi.Input[str] honeypot_secret_key: Honeypot User Password (Secret Key)
        :param pulumi.Input[str] honeypot_serverless_app_name: Serverless application name
        :param pulumi.Input[str] name: Name of the function runtime policy
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]] scope_variables: List of scope attributes.
        """
        if application_scopes is not None:
            pulumi.set(__self__, "application_scopes", application_scopes)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if block_malicious_executables is not None:
            pulumi.set(__self__, "block_malicious_executables", block_malicious_executables)
        if block_malicious_executables_allowed_processes is not None:
            pulumi.set(__self__, "block_malicious_executables_allowed_processes", block_malicious_executables_allowed_processes)
        if block_running_executables_in_tmp_folder is not None:
            pulumi.set(__self__, "block_running_executables_in_tmp_folder", block_running_executables_in_tmp_folder)
        if blocked_executables is not None:
            pulumi.set(__self__, "blocked_executables", blocked_executables)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if honeypot_access_key is not None:
            pulumi.set(__self__, "honeypot_access_key", honeypot_access_key)
        if honeypot_apply_ons is not None:
            pulumi.set(__self__, "honeypot_apply_ons", honeypot_apply_ons)
        if honeypot_secret_key is not None:
            pulumi.set(__self__, "honeypot_secret_key", honeypot_secret_key)
        if honeypot_serverless_app_name is not None:
            pulumi.set(__self__, "honeypot_serverless_app_name", honeypot_serverless_app_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope_expression is not None:
            pulumi.set(__self__, "scope_expression", scope_expression)
        if scope_variables is not None:
            pulumi.set(__self__, "scope_variables", scope_variables)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="blockMaliciousExecutables")
    def block_malicious_executables(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent creation of malicious executables in functions during their runtime post invocation.
        """
        return pulumi.get(self, "block_malicious_executables")

    @block_malicious_executables.setter
    def block_malicious_executables(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_malicious_executables", value)

    @property
    @pulumi.getter(name="blockMaliciousExecutablesAllowedProcesses")
    def block_malicious_executables_allowed_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes that will be allowed
        """
        return pulumi.get(self, "block_malicious_executables_allowed_processes")

    @block_malicious_executables_allowed_processes.setter
    def block_malicious_executables_allowed_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "block_malicious_executables_allowed_processes", value)

    @property
    @pulumi.getter(name="blockRunningExecutablesInTmpFolder")
    def block_running_executables_in_tmp_folder(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent running of executables in functions locate in /tmp folder during their runtime post invocation.
        """
        return pulumi.get(self, "block_running_executables_in_tmp_folder")

    @block_running_executables_in_tmp_folder.setter
    def block_running_executables_in_tmp_folder(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_running_executables_in_tmp_folder", value)

    @property
    @pulumi.getter(name="blockedExecutables")
    def blocked_executables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of executables that are prevented from running in containers.
        """
        return pulumi.get(self, "blocked_executables")

    @blocked_executables.setter
    def blocked_executables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_executables", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the function runtime policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter(name="honeypotAccessKey")
    def honeypot_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Honeypot User ID (Access Key)
        """
        return pulumi.get(self, "honeypot_access_key")

    @honeypot_access_key.setter
    def honeypot_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_access_key", value)

    @property
    @pulumi.getter(name="honeypotApplyOns")
    def honeypot_apply_ons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of options to apply the honeypot on (Environment Vairable, Layer, File)
        """
        return pulumi.get(self, "honeypot_apply_ons")

    @honeypot_apply_ons.setter
    def honeypot_apply_ons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "honeypot_apply_ons", value)

    @property
    @pulumi.getter(name="honeypotSecretKey")
    def honeypot_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Honeypot User Password (Secret Key)
        """
        return pulumi.get(self, "honeypot_secret_key")

    @honeypot_secret_key.setter
    def honeypot_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_secret_key", value)

    @property
    @pulumi.getter(name="honeypotServerlessAppName")
    def honeypot_serverless_app_name(self) -> Optional[pulumi.Input[str]]:
        """
        Serverless application name
        """
        return pulumi.get(self, "honeypot_serverless_app_name")

    @honeypot_serverless_app_name.setter
    def honeypot_serverless_app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_serverless_app_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the function runtime policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionRuntimePolicyScopeVariableArgs']]]]):
        pulumi.set(self, "scope_variables", value)


class FunctionRuntimePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_malicious_executables: Optional[pulumi.Input[bool]] = None,
                 block_malicious_executables_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_running_executables_in_tmp_folder: Optional[pulumi.Input[bool]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 honeypot_access_key: Optional[pulumi.Input[str]] = None,
                 honeypot_apply_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 honeypot_secret_key: Optional[pulumi.Input[str]] = None,
                 honeypot_serverless_app_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionRuntimePolicyScopeVariableArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        function_runtime_policy = aquasec.FunctionRuntimePolicy("functionRuntimePolicy",
            block_malicious_executables=True,
            block_malicious_executables_allowed_processes=[
                "proc1",
                "proc2",
            ],
            block_running_executables_in_tmp_folder=True,
            blocked_executables=[
                "exe1",
                "exe2",
            ],
            description="function_runtime_policy",
            enabled=True,
            enforce=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] block_malicious_executables: If true, prevent creation of malicious executables in functions during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_malicious_executables_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[bool] block_running_executables_in_tmp_folder: If true, prevent running of executables in functions locate in /tmp folder during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[str] description: The description of the function runtime policy
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[str] honeypot_access_key: Honeypot User ID (Access Key)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] honeypot_apply_ons: List of options to apply the honeypot on (Environment Vairable, Layer, File)
        :param pulumi.Input[str] honeypot_secret_key: Honeypot User Password (Secret Key)
        :param pulumi.Input[str] honeypot_serverless_app_name: Serverless application name
        :param pulumi.Input[str] name: Name of the function runtime policy
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionRuntimePolicyScopeVariableArgs']]]] scope_variables: List of scope attributes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FunctionRuntimePolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        function_runtime_policy = aquasec.FunctionRuntimePolicy("functionRuntimePolicy",
            block_malicious_executables=True,
            block_malicious_executables_allowed_processes=[
                "proc1",
                "proc2",
            ],
            block_running_executables_in_tmp_folder=True,
            blocked_executables=[
                "exe1",
                "exe2",
            ],
            description="function_runtime_policy",
            enabled=True,
            enforce=False)
        ```

        :param str resource_name: The name of the resource.
        :param FunctionRuntimePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionRuntimePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_malicious_executables: Optional[pulumi.Input[bool]] = None,
                 block_malicious_executables_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_running_executables_in_tmp_folder: Optional[pulumi.Input[bool]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 honeypot_access_key: Optional[pulumi.Input[str]] = None,
                 honeypot_apply_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 honeypot_secret_key: Optional[pulumi.Input[str]] = None,
                 honeypot_serverless_app_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionRuntimePolicyScopeVariableArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionRuntimePolicyArgs.__new__(FunctionRuntimePolicyArgs)

            __props__.__dict__["application_scopes"] = application_scopes
            __props__.__dict__["block_malicious_executables"] = block_malicious_executables
            __props__.__dict__["block_malicious_executables_allowed_processes"] = block_malicious_executables_allowed_processes
            __props__.__dict__["block_running_executables_in_tmp_folder"] = block_running_executables_in_tmp_folder
            __props__.__dict__["blocked_executables"] = blocked_executables
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["enforce"] = enforce
            __props__.__dict__["honeypot_access_key"] = honeypot_access_key
            __props__.__dict__["honeypot_apply_ons"] = honeypot_apply_ons
            __props__.__dict__["honeypot_secret_key"] = honeypot_secret_key
            __props__.__dict__["honeypot_serverless_app_name"] = honeypot_serverless_app_name
            __props__.__dict__["name"] = name
            __props__.__dict__["scope_expression"] = scope_expression
            __props__.__dict__["scope_variables"] = scope_variables
            __props__.__dict__["author"] = None
        super(FunctionRuntimePolicy, __self__).__init__(
            'aquasec:index/functionRuntimePolicy:FunctionRuntimePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            author: Optional[pulumi.Input[str]] = None,
            block_malicious_executables: Optional[pulumi.Input[bool]] = None,
            block_malicious_executables_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            block_running_executables_in_tmp_folder: Optional[pulumi.Input[bool]] = None,
            blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            enforce: Optional[pulumi.Input[bool]] = None,
            honeypot_access_key: Optional[pulumi.Input[str]] = None,
            honeypot_apply_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            honeypot_secret_key: Optional[pulumi.Input[str]] = None,
            honeypot_serverless_app_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            scope_expression: Optional[pulumi.Input[str]] = None,
            scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionRuntimePolicyScopeVariableArgs']]]]] = None) -> 'FunctionRuntimePolicy':
        """
        Get an existing FunctionRuntimePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[bool] block_malicious_executables: If true, prevent creation of malicious executables in functions during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_malicious_executables_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[bool] block_running_executables_in_tmp_folder: If true, prevent running of executables in functions locate in /tmp folder during their runtime post invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[str] description: The description of the function runtime policy
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[str] honeypot_access_key: Honeypot User ID (Access Key)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] honeypot_apply_ons: List of options to apply the honeypot on (Environment Vairable, Layer, File)
        :param pulumi.Input[str] honeypot_secret_key: Honeypot User Password (Secret Key)
        :param pulumi.Input[str] honeypot_serverless_app_name: Serverless application name
        :param pulumi.Input[str] name: Name of the function runtime policy
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionRuntimePolicyScopeVariableArgs']]]] scope_variables: List of scope attributes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionRuntimePolicyState.__new__(_FunctionRuntimePolicyState)

        __props__.__dict__["application_scopes"] = application_scopes
        __props__.__dict__["author"] = author
        __props__.__dict__["block_malicious_executables"] = block_malicious_executables
        __props__.__dict__["block_malicious_executables_allowed_processes"] = block_malicious_executables_allowed_processes
        __props__.__dict__["block_running_executables_in_tmp_folder"] = block_running_executables_in_tmp_folder
        __props__.__dict__["blocked_executables"] = blocked_executables
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["enforce"] = enforce
        __props__.__dict__["honeypot_access_key"] = honeypot_access_key
        __props__.__dict__["honeypot_apply_ons"] = honeypot_apply_ons
        __props__.__dict__["honeypot_secret_key"] = honeypot_secret_key
        __props__.__dict__["honeypot_serverless_app_name"] = honeypot_serverless_app_name
        __props__.__dict__["name"] = name
        __props__.__dict__["scope_expression"] = scope_expression
        __props__.__dict__["scope_variables"] = scope_variables
        return FunctionRuntimePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="blockMaliciousExecutables")
    def block_malicious_executables(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent creation of malicious executables in functions during their runtime post invocation.
        """
        return pulumi.get(self, "block_malicious_executables")

    @property
    @pulumi.getter(name="blockMaliciousExecutablesAllowedProcesses")
    def block_malicious_executables_allowed_processes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of processes that will be allowed
        """
        return pulumi.get(self, "block_malicious_executables_allowed_processes")

    @property
    @pulumi.getter(name="blockRunningExecutablesInTmpFolder")
    def block_running_executables_in_tmp_folder(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent running of executables in functions locate in /tmp folder during their runtime post invocation.
        """
        return pulumi.get(self, "block_running_executables_in_tmp_folder")

    @property
    @pulumi.getter(name="blockedExecutables")
    def blocked_executables(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of executables that are prevented from running in containers.
        """
        return pulumi.get(self, "blocked_executables")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the function runtime policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def enforce(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter(name="honeypotAccessKey")
    def honeypot_access_key(self) -> pulumi.Output[Optional[str]]:
        """
        Honeypot User ID (Access Key)
        """
        return pulumi.get(self, "honeypot_access_key")

    @property
    @pulumi.getter(name="honeypotApplyOns")
    def honeypot_apply_ons(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of options to apply the honeypot on (Environment Vairable, Layer, File)
        """
        return pulumi.get(self, "honeypot_apply_ons")

    @property
    @pulumi.getter(name="honeypotSecretKey")
    def honeypot_secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        Honeypot User Password (Secret Key)
        """
        return pulumi.get(self, "honeypot_secret_key")

    @property
    @pulumi.getter(name="honeypotServerlessAppName")
    def honeypot_serverless_app_name(self) -> pulumi.Output[Optional[str]]:
        """
        Serverless application name
        """
        return pulumi.get(self, "honeypot_serverless_app_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the function runtime policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> pulumi.Output[str]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> pulumi.Output[Sequence['outputs.FunctionRuntimePolicyScopeVariable']]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

