# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerRuntimePolicyArgs', 'ContainerRuntimePolicy']

@pulumi.input_type
class ContainerRuntimePolicyArgs:
    def __init__(__self__, *,
                 allowed_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_network_activity: Optional[pulumi.Input[bool]] = None,
                 audit_all_processes_activity: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 block_access_host_network: Optional[pulumi.Input[bool]] = None,
                 block_adding_capabilities: Optional[pulumi.Input[bool]] = None,
                 block_container_exec: Optional[pulumi.Input[bool]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 block_fileless_exec: Optional[pulumi.Input[bool]] = None,
                 block_low_port_binding: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_images: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_workloads: Optional[pulumi.Input[bool]] = None,
                 block_non_k8s_containers: Optional[pulumi.Input[bool]] = None,
                 block_privileged_containers: Optional[pulumi.Input[bool]] = None,
                 block_reverse_shell: Optional[pulumi.Input[bool]] = None,
                 block_root_user: Optional[pulumi.Input[bool]] = None,
                 block_unregistered_images: Optional[pulumi.Input[bool]] = None,
                 block_use_ipc_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_pid_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_user_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_uts_namespace: Optional[pulumi.Input[bool]] = None,
                 blocked_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_inbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_outbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_exec_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_drift_prevention: Optional[pulumi.Input[bool]] = None,
                 enable_fork_guard: Optional[pulumi.Input[bool]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enable_port_scan_detection: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 exceptional_readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs']] = None,
                 fork_guard_process_limit: Optional[pulumi.Input[int]] = None,
                 limit_new_privileges: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]]] = None):
        """
        The set of arguments for constructing a ContainerRuntimePolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_executables: List of executables that are allowed for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registries that allowed for running containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_network_activity: If true, all network activity will be audited.
        :param pulumi.Input[bool] audit_all_processes_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[bool] block_access_host_network: If true, prevent containers from running with access to host network.
        :param pulumi.Input[bool] block_adding_capabilities: If true, prevent containers from running with adding capabilities with `--cap-add` privilege.
        :param pulumi.Input[bool] block_container_exec: If true, exec into a container is prevented.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[bool] block_fileless_exec: Detect and prevent running in-memory execution
        :param pulumi.Input[bool] block_low_port_binding: If true, prevent containers from running with the capability to bind in port lower than 1024.
        :param pulumi.Input[bool] block_non_compliant_images: If true, running non-compliant image in the container is prevented.
        :param pulumi.Input[bool] block_non_compliant_workloads: If true, running containers in non-compliant pods is prevented.
        :param pulumi.Input[bool] block_non_k8s_containers: If true, running non-kubernetes containers is prevented.
        :param pulumi.Input[bool] block_privileged_containers: If true, prevent containers from running with privileged container capability.
        :param pulumi.Input[bool] block_reverse_shell: If true, reverse shell is prevented.
        :param pulumi.Input[bool] block_root_user: If true, prevent containers from running with root user.
        :param pulumi.Input[bool] block_unregistered_images: If true, running images in the container that are not registered in Aqua is prevented.
        :param pulumi.Input[bool] block_use_ipc_namespace: If true, prevent containers from running with the privilege to use the IPC namespace.
        :param pulumi.Input[bool] block_use_pid_namespace: If true, prevent containers from running with the privilege to use the PID namespace.
        :param pulumi.Input[bool] block_use_user_namespace: If true, prevent containers from running with the privilege to use the user namespace.
        :param pulumi.Input[bool] block_use_uts_namespace: If true, prevent containers from running with the privilege to use the UTS namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_capabilities: If true, prevents containers from using specific Unix capabilities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_inbound_ports: List of blocked inbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_outbound_ports: List of blocked outbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_packages: Prevent containers from reading, writing, or executing all files in the list of packages.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_volumes: List of volumes that are prevented from being mounted in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_exec_allowed_processes: List of processes that will be allowed.
        :param pulumi.Input[str] description: The description of the container runtime policy
        :param pulumi.Input[bool] enable_drift_prevention: If true, executables that are not in the original image is prevented from running.
        :param pulumi.Input[bool] enable_fork_guard: If true, fork bombs are prevented in the containers.
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enable_port_scan_detection: If true, detects port scanning behavior in the container.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exceptional_readonly_files_and_directories: List of files and directories to be excluded from the read-only list.
        :param pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs'] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input[int] fork_guard_process_limit: Process limit for the fork guard.
        :param pulumi.Input[bool] limit_new_privileges: If true, prevents the container from obtaining new privileges at runtime. (only enabled in enforce mode)
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[str] name: Name of the container runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] readonly_files_and_directories: List of files and directories to be restricted as read-only
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_ips: List of IPs/ CIDRs that will be allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]] scope_variables: List of scope attributes.
        """
        if allowed_executables is not None:
            pulumi.set(__self__, "allowed_executables", allowed_executables)
        if allowed_registries is not None:
            pulumi.set(__self__, "allowed_registries", allowed_registries)
        if application_scopes is not None:
            pulumi.set(__self__, "application_scopes", application_scopes)
        if audit_all_network_activity is not None:
            pulumi.set(__self__, "audit_all_network_activity", audit_all_network_activity)
        if audit_all_processes_activity is not None:
            pulumi.set(__self__, "audit_all_processes_activity", audit_all_processes_activity)
        if audit_full_command_arguments is not None:
            pulumi.set(__self__, "audit_full_command_arguments", audit_full_command_arguments)
        if block_access_host_network is not None:
            pulumi.set(__self__, "block_access_host_network", block_access_host_network)
        if block_adding_capabilities is not None:
            pulumi.set(__self__, "block_adding_capabilities", block_adding_capabilities)
        if block_container_exec is not None:
            pulumi.set(__self__, "block_container_exec", block_container_exec)
        if block_cryptocurrency_mining is not None:
            pulumi.set(__self__, "block_cryptocurrency_mining", block_cryptocurrency_mining)
        if block_fileless_exec is not None:
            pulumi.set(__self__, "block_fileless_exec", block_fileless_exec)
        if block_low_port_binding is not None:
            pulumi.set(__self__, "block_low_port_binding", block_low_port_binding)
        if block_non_compliant_images is not None:
            pulumi.set(__self__, "block_non_compliant_images", block_non_compliant_images)
        if block_non_compliant_workloads is not None:
            pulumi.set(__self__, "block_non_compliant_workloads", block_non_compliant_workloads)
        if block_non_k8s_containers is not None:
            pulumi.set(__self__, "block_non_k8s_containers", block_non_k8s_containers)
        if block_privileged_containers is not None:
            pulumi.set(__self__, "block_privileged_containers", block_privileged_containers)
        if block_reverse_shell is not None:
            pulumi.set(__self__, "block_reverse_shell", block_reverse_shell)
        if block_root_user is not None:
            pulumi.set(__self__, "block_root_user", block_root_user)
        if block_unregistered_images is not None:
            pulumi.set(__self__, "block_unregistered_images", block_unregistered_images)
        if block_use_ipc_namespace is not None:
            pulumi.set(__self__, "block_use_ipc_namespace", block_use_ipc_namespace)
        if block_use_pid_namespace is not None:
            pulumi.set(__self__, "block_use_pid_namespace", block_use_pid_namespace)
        if block_use_user_namespace is not None:
            pulumi.set(__self__, "block_use_user_namespace", block_use_user_namespace)
        if block_use_uts_namespace is not None:
            pulumi.set(__self__, "block_use_uts_namespace", block_use_uts_namespace)
        if blocked_capabilities is not None:
            pulumi.set(__self__, "blocked_capabilities", blocked_capabilities)
        if blocked_executables is not None:
            pulumi.set(__self__, "blocked_executables", blocked_executables)
        if blocked_files is not None:
            pulumi.set(__self__, "blocked_files", blocked_files)
        if blocked_inbound_ports is not None:
            pulumi.set(__self__, "blocked_inbound_ports", blocked_inbound_ports)
        if blocked_outbound_ports is not None:
            pulumi.set(__self__, "blocked_outbound_ports", blocked_outbound_ports)
        if blocked_packages is not None:
            pulumi.set(__self__, "blocked_packages", blocked_packages)
        if blocked_volumes is not None:
            pulumi.set(__self__, "blocked_volumes", blocked_volumes)
        if container_exec_allowed_processes is not None:
            pulumi.set(__self__, "container_exec_allowed_processes", container_exec_allowed_processes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_drift_prevention is not None:
            pulumi.set(__self__, "enable_drift_prevention", enable_drift_prevention)
        if enable_fork_guard is not None:
            pulumi.set(__self__, "enable_fork_guard", enable_fork_guard)
        if enable_ip_reputation_security is not None:
            pulumi.set(__self__, "enable_ip_reputation_security", enable_ip_reputation_security)
        if enable_port_scan_detection is not None:
            pulumi.set(__self__, "enable_port_scan_detection", enable_port_scan_detection)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if enforce_after_days is not None:
            pulumi.set(__self__, "enforce_after_days", enforce_after_days)
        if exceptional_readonly_files_and_directories is not None:
            pulumi.set(__self__, "exceptional_readonly_files_and_directories", exceptional_readonly_files_and_directories)
        if file_integrity_monitoring is not None:
            pulumi.set(__self__, "file_integrity_monitoring", file_integrity_monitoring)
        if fork_guard_process_limit is not None:
            pulumi.set(__self__, "fork_guard_process_limit", fork_guard_process_limit)
        if limit_new_privileges is not None:
            pulumi.set(__self__, "limit_new_privileges", limit_new_privileges)
        if monitor_system_time_changes is not None:
            pulumi.set(__self__, "monitor_system_time_changes", monitor_system_time_changes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if readonly_files_and_directories is not None:
            pulumi.set(__self__, "readonly_files_and_directories", readonly_files_and_directories)
        if reverse_shell_allowed_ips is not None:
            pulumi.set(__self__, "reverse_shell_allowed_ips", reverse_shell_allowed_ips)
        if reverse_shell_allowed_processes is not None:
            pulumi.set(__self__, "reverse_shell_allowed_processes", reverse_shell_allowed_processes)
        if scope_expression is not None:
            pulumi.set(__self__, "scope_expression", scope_expression)
        if scope_variables is not None:
            pulumi.set(__self__, "scope_variables", scope_variables)

    @property
    @pulumi.getter(name="allowedExecutables")
    def allowed_executables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of executables that are allowed for the user.
        """
        return pulumi.get(self, "allowed_executables")

    @allowed_executables.setter
    def allowed_executables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_executables", value)

    @property
    @pulumi.getter(name="allowedRegistries")
    def allowed_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of registries that allowed for running containers.
        """
        return pulumi.get(self, "allowed_registries")

    @allowed_registries.setter
    def allowed_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_registries", value)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter(name="auditAllNetworkActivity")
    def audit_all_network_activity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, all network activity will be audited.
        """
        return pulumi.get(self, "audit_all_network_activity")

    @audit_all_network_activity.setter
    def audit_all_network_activity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all_network_activity", value)

    @property
    @pulumi.getter(name="auditAllProcessesActivity")
    def audit_all_processes_activity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, all process activity will be audited.
        """
        return pulumi.get(self, "audit_all_processes_activity")

    @audit_all_processes_activity.setter
    def audit_all_processes_activity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all_processes_activity", value)

    @property
    @pulumi.getter(name="auditFullCommandArguments")
    def audit_full_command_arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, full command arguments will be audited.
        """
        return pulumi.get(self, "audit_full_command_arguments")

    @audit_full_command_arguments.setter
    def audit_full_command_arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_full_command_arguments", value)

    @property
    @pulumi.getter(name="blockAccessHostNetwork")
    def block_access_host_network(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with access to host network.
        """
        return pulumi.get(self, "block_access_host_network")

    @block_access_host_network.setter
    def block_access_host_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_access_host_network", value)

    @property
    @pulumi.getter(name="blockAddingCapabilities")
    def block_adding_capabilities(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with adding capabilities with `--cap-add` privilege.
        """
        return pulumi.get(self, "block_adding_capabilities")

    @block_adding_capabilities.setter
    def block_adding_capabilities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_adding_capabilities", value)

    @property
    @pulumi.getter(name="blockContainerExec")
    def block_container_exec(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, exec into a container is prevented.
        """
        return pulumi.get(self, "block_container_exec")

    @block_container_exec.setter
    def block_container_exec(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_container_exec", value)

    @property
    @pulumi.getter(name="blockCryptocurrencyMining")
    def block_cryptocurrency_mining(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        """
        return pulumi.get(self, "block_cryptocurrency_mining")

    @block_cryptocurrency_mining.setter
    def block_cryptocurrency_mining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_cryptocurrency_mining", value)

    @property
    @pulumi.getter(name="blockFilelessExec")
    def block_fileless_exec(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect and prevent running in-memory execution
        """
        return pulumi.get(self, "block_fileless_exec")

    @block_fileless_exec.setter
    def block_fileless_exec(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_fileless_exec", value)

    @property
    @pulumi.getter(name="blockLowPortBinding")
    def block_low_port_binding(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the capability to bind in port lower than 1024.
        """
        return pulumi.get(self, "block_low_port_binding")

    @block_low_port_binding.setter
    def block_low_port_binding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_low_port_binding", value)

    @property
    @pulumi.getter(name="blockNonCompliantImages")
    def block_non_compliant_images(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running non-compliant image in the container is prevented.
        """
        return pulumi.get(self, "block_non_compliant_images")

    @block_non_compliant_images.setter
    def block_non_compliant_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_non_compliant_images", value)

    @property
    @pulumi.getter(name="blockNonCompliantWorkloads")
    def block_non_compliant_workloads(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running containers in non-compliant pods is prevented.
        """
        return pulumi.get(self, "block_non_compliant_workloads")

    @block_non_compliant_workloads.setter
    def block_non_compliant_workloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_non_compliant_workloads", value)

    @property
    @pulumi.getter(name="blockNonK8sContainers")
    def block_non_k8s_containers(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running non-kubernetes containers is prevented.
        """
        return pulumi.get(self, "block_non_k8s_containers")

    @block_non_k8s_containers.setter
    def block_non_k8s_containers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_non_k8s_containers", value)

    @property
    @pulumi.getter(name="blockPrivilegedContainers")
    def block_privileged_containers(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with privileged container capability.
        """
        return pulumi.get(self, "block_privileged_containers")

    @block_privileged_containers.setter
    def block_privileged_containers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_privileged_containers", value)

    @property
    @pulumi.getter(name="blockReverseShell")
    def block_reverse_shell(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, reverse shell is prevented.
        """
        return pulumi.get(self, "block_reverse_shell")

    @block_reverse_shell.setter
    def block_reverse_shell(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_reverse_shell", value)

    @property
    @pulumi.getter(name="blockRootUser")
    def block_root_user(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with root user.
        """
        return pulumi.get(self, "block_root_user")

    @block_root_user.setter
    def block_root_user(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_root_user", value)

    @property
    @pulumi.getter(name="blockUnregisteredImages")
    def block_unregistered_images(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running images in the container that are not registered in Aqua is prevented.
        """
        return pulumi.get(self, "block_unregistered_images")

    @block_unregistered_images.setter
    def block_unregistered_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_unregistered_images", value)

    @property
    @pulumi.getter(name="blockUseIpcNamespace")
    def block_use_ipc_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the IPC namespace.
        """
        return pulumi.get(self, "block_use_ipc_namespace")

    @block_use_ipc_namespace.setter
    def block_use_ipc_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_ipc_namespace", value)

    @property
    @pulumi.getter(name="blockUsePidNamespace")
    def block_use_pid_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the PID namespace.
        """
        return pulumi.get(self, "block_use_pid_namespace")

    @block_use_pid_namespace.setter
    def block_use_pid_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_pid_namespace", value)

    @property
    @pulumi.getter(name="blockUseUserNamespace")
    def block_use_user_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the user namespace.
        """
        return pulumi.get(self, "block_use_user_namespace")

    @block_use_user_namespace.setter
    def block_use_user_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_user_namespace", value)

    @property
    @pulumi.getter(name="blockUseUtsNamespace")
    def block_use_uts_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the UTS namespace.
        """
        return pulumi.get(self, "block_use_uts_namespace")

    @block_use_uts_namespace.setter
    def block_use_uts_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_uts_namespace", value)

    @property
    @pulumi.getter(name="blockedCapabilities")
    def blocked_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If true, prevents containers from using specific Unix capabilities.
        """
        return pulumi.get(self, "blocked_capabilities")

    @blocked_capabilities.setter
    def blocked_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_capabilities", value)

    @property
    @pulumi.getter(name="blockedExecutables")
    def blocked_executables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of executables that are prevented from running in containers.
        """
        return pulumi.get(self, "blocked_executables")

    @blocked_executables.setter
    def blocked_executables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_executables", value)

    @property
    @pulumi.getter(name="blockedFiles")
    def blocked_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files that are prevented from being read, modified and executed in the containers.
        """
        return pulumi.get(self, "blocked_files")

    @blocked_files.setter
    def blocked_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_files", value)

    @property
    @pulumi.getter(name="blockedInboundPorts")
    def blocked_inbound_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of blocked inbound ports.
        """
        return pulumi.get(self, "blocked_inbound_ports")

    @blocked_inbound_ports.setter
    def blocked_inbound_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_inbound_ports", value)

    @property
    @pulumi.getter(name="blockedOutboundPorts")
    def blocked_outbound_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of blocked outbound ports.
        """
        return pulumi.get(self, "blocked_outbound_ports")

    @blocked_outbound_ports.setter
    def blocked_outbound_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_outbound_ports", value)

    @property
    @pulumi.getter(name="blockedPackages")
    def blocked_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Prevent containers from reading, writing, or executing all files in the list of packages.
        """
        return pulumi.get(self, "blocked_packages")

    @blocked_packages.setter
    def blocked_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_packages", value)

    @property
    @pulumi.getter(name="blockedVolumes")
    def blocked_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of volumes that are prevented from being mounted in the containers.
        """
        return pulumi.get(self, "blocked_volumes")

    @blocked_volumes.setter
    def blocked_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_volumes", value)

    @property
    @pulumi.getter(name="containerExecAllowedProcesses")
    def container_exec_allowed_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes that will be allowed.
        """
        return pulumi.get(self, "container_exec_allowed_processes")

    @container_exec_allowed_processes.setter
    def container_exec_allowed_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_exec_allowed_processes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the container runtime policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableDriftPrevention")
    def enable_drift_prevention(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, executables that are not in the original image is prevented from running.
        """
        return pulumi.get(self, "enable_drift_prevention")

    @enable_drift_prevention.setter
    def enable_drift_prevention(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_drift_prevention", value)

    @property
    @pulumi.getter(name="enableForkGuard")
    def enable_fork_guard(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, fork bombs are prevented in the containers.
        """
        return pulumi.get(self, "enable_fork_guard")

    @enable_fork_guard.setter
    def enable_fork_guard(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_fork_guard", value)

    @property
    @pulumi.getter(name="enableIpReputationSecurity")
    def enable_ip_reputation_security(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        """
        return pulumi.get(self, "enable_ip_reputation_security")

    @enable_ip_reputation_security.setter
    def enable_ip_reputation_security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ip_reputation_security", value)

    @property
    @pulumi.getter(name="enablePortScanDetection")
    def enable_port_scan_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, detects port scanning behavior in the container.
        """
        return pulumi.get(self, "enable_port_scan_detection")

    @enable_port_scan_detection.setter
    def enable_port_scan_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_port_scan_detection", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter(name="enforceAfterDays")
    def enforce_after_days(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of days after which the runtime policy will be changed to enforce mode.
        """
        return pulumi.get(self, "enforce_after_days")

    @enforce_after_days.setter
    def enforce_after_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enforce_after_days", value)

    @property
    @pulumi.getter(name="exceptionalReadonlyFilesAndDirectories")
    def exceptional_readonly_files_and_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files and directories to be excluded from the read-only list.
        """
        return pulumi.get(self, "exceptional_readonly_files_and_directories")

    @exceptional_readonly_files_and_directories.setter
    def exceptional_readonly_files_and_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exceptional_readonly_files_and_directories", value)

    @property
    @pulumi.getter(name="fileIntegrityMonitoring")
    def file_integrity_monitoring(self) -> Optional[pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs']]:
        """
        Configuration for file integrity monitoring.
        """
        return pulumi.get(self, "file_integrity_monitoring")

    @file_integrity_monitoring.setter
    def file_integrity_monitoring(self, value: Optional[pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs']]):
        pulumi.set(self, "file_integrity_monitoring", value)

    @property
    @pulumi.getter(name="forkGuardProcessLimit")
    def fork_guard_process_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Process limit for the fork guard.
        """
        return pulumi.get(self, "fork_guard_process_limit")

    @fork_guard_process_limit.setter
    def fork_guard_process_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fork_guard_process_limit", value)

    @property
    @pulumi.getter(name="limitNewPrivileges")
    def limit_new_privileges(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevents the container from obtaining new privileges at runtime. (only enabled in enforce mode)
        """
        return pulumi.get(self, "limit_new_privileges")

    @limit_new_privileges.setter
    def limit_new_privileges(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "limit_new_privileges", value)

    @property
    @pulumi.getter(name="monitorSystemTimeChanges")
    def monitor_system_time_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, system time changes will be monitored.
        """
        return pulumi.get(self, "monitor_system_time_changes")

    @monitor_system_time_changes.setter
    def monitor_system_time_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_system_time_changes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the container runtime policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readonlyFilesAndDirectories")
    def readonly_files_and_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files and directories to be restricted as read-only
        """
        return pulumi.get(self, "readonly_files_and_directories")

    @readonly_files_and_directories.setter
    def readonly_files_and_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "readonly_files_and_directories", value)

    @property
    @pulumi.getter(name="reverseShellAllowedIps")
    def reverse_shell_allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IPs/ CIDRs that will be allowed
        """
        return pulumi.get(self, "reverse_shell_allowed_ips")

    @reverse_shell_allowed_ips.setter
    def reverse_shell_allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reverse_shell_allowed_ips", value)

    @property
    @pulumi.getter(name="reverseShellAllowedProcesses")
    def reverse_shell_allowed_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes that will be allowed
        """
        return pulumi.get(self, "reverse_shell_allowed_processes")

    @reverse_shell_allowed_processes.setter
    def reverse_shell_allowed_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reverse_shell_allowed_processes", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]]]):
        pulumi.set(self, "scope_variables", value)


@pulumi.input_type
class _ContainerRuntimePolicyState:
    def __init__(__self__, *,
                 allowed_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_network_activity: Optional[pulumi.Input[bool]] = None,
                 audit_all_processes_activity: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 block_access_host_network: Optional[pulumi.Input[bool]] = None,
                 block_adding_capabilities: Optional[pulumi.Input[bool]] = None,
                 block_container_exec: Optional[pulumi.Input[bool]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 block_fileless_exec: Optional[pulumi.Input[bool]] = None,
                 block_low_port_binding: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_images: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_workloads: Optional[pulumi.Input[bool]] = None,
                 block_non_k8s_containers: Optional[pulumi.Input[bool]] = None,
                 block_privileged_containers: Optional[pulumi.Input[bool]] = None,
                 block_reverse_shell: Optional[pulumi.Input[bool]] = None,
                 block_root_user: Optional[pulumi.Input[bool]] = None,
                 block_unregistered_images: Optional[pulumi.Input[bool]] = None,
                 block_use_ipc_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_pid_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_user_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_uts_namespace: Optional[pulumi.Input[bool]] = None,
                 blocked_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_inbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_outbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_exec_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_drift_prevention: Optional[pulumi.Input[bool]] = None,
                 enable_fork_guard: Optional[pulumi.Input[bool]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enable_port_scan_detection: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 exceptional_readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs']] = None,
                 fork_guard_process_limit: Optional[pulumi.Input[int]] = None,
                 limit_new_privileges: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]]] = None):
        """
        Input properties used for looking up and filtering ContainerRuntimePolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_executables: List of executables that are allowed for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registries that allowed for running containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_network_activity: If true, all network activity will be audited.
        :param pulumi.Input[bool] audit_all_processes_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[bool] block_access_host_network: If true, prevent containers from running with access to host network.
        :param pulumi.Input[bool] block_adding_capabilities: If true, prevent containers from running with adding capabilities with `--cap-add` privilege.
        :param pulumi.Input[bool] block_container_exec: If true, exec into a container is prevented.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[bool] block_fileless_exec: Detect and prevent running in-memory execution
        :param pulumi.Input[bool] block_low_port_binding: If true, prevent containers from running with the capability to bind in port lower than 1024.
        :param pulumi.Input[bool] block_non_compliant_images: If true, running non-compliant image in the container is prevented.
        :param pulumi.Input[bool] block_non_compliant_workloads: If true, running containers in non-compliant pods is prevented.
        :param pulumi.Input[bool] block_non_k8s_containers: If true, running non-kubernetes containers is prevented.
        :param pulumi.Input[bool] block_privileged_containers: If true, prevent containers from running with privileged container capability.
        :param pulumi.Input[bool] block_reverse_shell: If true, reverse shell is prevented.
        :param pulumi.Input[bool] block_root_user: If true, prevent containers from running with root user.
        :param pulumi.Input[bool] block_unregistered_images: If true, running images in the container that are not registered in Aqua is prevented.
        :param pulumi.Input[bool] block_use_ipc_namespace: If true, prevent containers from running with the privilege to use the IPC namespace.
        :param pulumi.Input[bool] block_use_pid_namespace: If true, prevent containers from running with the privilege to use the PID namespace.
        :param pulumi.Input[bool] block_use_user_namespace: If true, prevent containers from running with the privilege to use the user namespace.
        :param pulumi.Input[bool] block_use_uts_namespace: If true, prevent containers from running with the privilege to use the UTS namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_capabilities: If true, prevents containers from using specific Unix capabilities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_inbound_ports: List of blocked inbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_outbound_ports: List of blocked outbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_packages: Prevent containers from reading, writing, or executing all files in the list of packages.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_volumes: List of volumes that are prevented from being mounted in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_exec_allowed_processes: List of processes that will be allowed.
        :param pulumi.Input[str] description: The description of the container runtime policy
        :param pulumi.Input[bool] enable_drift_prevention: If true, executables that are not in the original image is prevented from running.
        :param pulumi.Input[bool] enable_fork_guard: If true, fork bombs are prevented in the containers.
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enable_port_scan_detection: If true, detects port scanning behavior in the container.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exceptional_readonly_files_and_directories: List of files and directories to be excluded from the read-only list.
        :param pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs'] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input[int] fork_guard_process_limit: Process limit for the fork guard.
        :param pulumi.Input[bool] limit_new_privileges: If true, prevents the container from obtaining new privileges at runtime. (only enabled in enforce mode)
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[str] name: Name of the container runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] readonly_files_and_directories: List of files and directories to be restricted as read-only
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_ips: List of IPs/ CIDRs that will be allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]] scope_variables: List of scope attributes.
        """
        if allowed_executables is not None:
            pulumi.set(__self__, "allowed_executables", allowed_executables)
        if allowed_registries is not None:
            pulumi.set(__self__, "allowed_registries", allowed_registries)
        if application_scopes is not None:
            pulumi.set(__self__, "application_scopes", application_scopes)
        if audit_all_network_activity is not None:
            pulumi.set(__self__, "audit_all_network_activity", audit_all_network_activity)
        if audit_all_processes_activity is not None:
            pulumi.set(__self__, "audit_all_processes_activity", audit_all_processes_activity)
        if audit_full_command_arguments is not None:
            pulumi.set(__self__, "audit_full_command_arguments", audit_full_command_arguments)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if block_access_host_network is not None:
            pulumi.set(__self__, "block_access_host_network", block_access_host_network)
        if block_adding_capabilities is not None:
            pulumi.set(__self__, "block_adding_capabilities", block_adding_capabilities)
        if block_container_exec is not None:
            pulumi.set(__self__, "block_container_exec", block_container_exec)
        if block_cryptocurrency_mining is not None:
            pulumi.set(__self__, "block_cryptocurrency_mining", block_cryptocurrency_mining)
        if block_fileless_exec is not None:
            pulumi.set(__self__, "block_fileless_exec", block_fileless_exec)
        if block_low_port_binding is not None:
            pulumi.set(__self__, "block_low_port_binding", block_low_port_binding)
        if block_non_compliant_images is not None:
            pulumi.set(__self__, "block_non_compliant_images", block_non_compliant_images)
        if block_non_compliant_workloads is not None:
            pulumi.set(__self__, "block_non_compliant_workloads", block_non_compliant_workloads)
        if block_non_k8s_containers is not None:
            pulumi.set(__self__, "block_non_k8s_containers", block_non_k8s_containers)
        if block_privileged_containers is not None:
            pulumi.set(__self__, "block_privileged_containers", block_privileged_containers)
        if block_reverse_shell is not None:
            pulumi.set(__self__, "block_reverse_shell", block_reverse_shell)
        if block_root_user is not None:
            pulumi.set(__self__, "block_root_user", block_root_user)
        if block_unregistered_images is not None:
            pulumi.set(__self__, "block_unregistered_images", block_unregistered_images)
        if block_use_ipc_namespace is not None:
            pulumi.set(__self__, "block_use_ipc_namespace", block_use_ipc_namespace)
        if block_use_pid_namespace is not None:
            pulumi.set(__self__, "block_use_pid_namespace", block_use_pid_namespace)
        if block_use_user_namespace is not None:
            pulumi.set(__self__, "block_use_user_namespace", block_use_user_namespace)
        if block_use_uts_namespace is not None:
            pulumi.set(__self__, "block_use_uts_namespace", block_use_uts_namespace)
        if blocked_capabilities is not None:
            pulumi.set(__self__, "blocked_capabilities", blocked_capabilities)
        if blocked_executables is not None:
            pulumi.set(__self__, "blocked_executables", blocked_executables)
        if blocked_files is not None:
            pulumi.set(__self__, "blocked_files", blocked_files)
        if blocked_inbound_ports is not None:
            pulumi.set(__self__, "blocked_inbound_ports", blocked_inbound_ports)
        if blocked_outbound_ports is not None:
            pulumi.set(__self__, "blocked_outbound_ports", blocked_outbound_ports)
        if blocked_packages is not None:
            pulumi.set(__self__, "blocked_packages", blocked_packages)
        if blocked_volumes is not None:
            pulumi.set(__self__, "blocked_volumes", blocked_volumes)
        if container_exec_allowed_processes is not None:
            pulumi.set(__self__, "container_exec_allowed_processes", container_exec_allowed_processes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_drift_prevention is not None:
            pulumi.set(__self__, "enable_drift_prevention", enable_drift_prevention)
        if enable_fork_guard is not None:
            pulumi.set(__self__, "enable_fork_guard", enable_fork_guard)
        if enable_ip_reputation_security is not None:
            pulumi.set(__self__, "enable_ip_reputation_security", enable_ip_reputation_security)
        if enable_port_scan_detection is not None:
            pulumi.set(__self__, "enable_port_scan_detection", enable_port_scan_detection)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if enforce_after_days is not None:
            pulumi.set(__self__, "enforce_after_days", enforce_after_days)
        if exceptional_readonly_files_and_directories is not None:
            pulumi.set(__self__, "exceptional_readonly_files_and_directories", exceptional_readonly_files_and_directories)
        if file_integrity_monitoring is not None:
            pulumi.set(__self__, "file_integrity_monitoring", file_integrity_monitoring)
        if fork_guard_process_limit is not None:
            pulumi.set(__self__, "fork_guard_process_limit", fork_guard_process_limit)
        if limit_new_privileges is not None:
            pulumi.set(__self__, "limit_new_privileges", limit_new_privileges)
        if monitor_system_time_changes is not None:
            pulumi.set(__self__, "monitor_system_time_changes", monitor_system_time_changes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if readonly_files_and_directories is not None:
            pulumi.set(__self__, "readonly_files_and_directories", readonly_files_and_directories)
        if reverse_shell_allowed_ips is not None:
            pulumi.set(__self__, "reverse_shell_allowed_ips", reverse_shell_allowed_ips)
        if reverse_shell_allowed_processes is not None:
            pulumi.set(__self__, "reverse_shell_allowed_processes", reverse_shell_allowed_processes)
        if scope_expression is not None:
            pulumi.set(__self__, "scope_expression", scope_expression)
        if scope_variables is not None:
            pulumi.set(__self__, "scope_variables", scope_variables)

    @property
    @pulumi.getter(name="allowedExecutables")
    def allowed_executables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of executables that are allowed for the user.
        """
        return pulumi.get(self, "allowed_executables")

    @allowed_executables.setter
    def allowed_executables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_executables", value)

    @property
    @pulumi.getter(name="allowedRegistries")
    def allowed_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of registries that allowed for running containers.
        """
        return pulumi.get(self, "allowed_registries")

    @allowed_registries.setter
    def allowed_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_registries", value)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter(name="auditAllNetworkActivity")
    def audit_all_network_activity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, all network activity will be audited.
        """
        return pulumi.get(self, "audit_all_network_activity")

    @audit_all_network_activity.setter
    def audit_all_network_activity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all_network_activity", value)

    @property
    @pulumi.getter(name="auditAllProcessesActivity")
    def audit_all_processes_activity(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, all process activity will be audited.
        """
        return pulumi.get(self, "audit_all_processes_activity")

    @audit_all_processes_activity.setter
    def audit_all_processes_activity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all_processes_activity", value)

    @property
    @pulumi.getter(name="auditFullCommandArguments")
    def audit_full_command_arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, full command arguments will be audited.
        """
        return pulumi.get(self, "audit_full_command_arguments")

    @audit_full_command_arguments.setter
    def audit_full_command_arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_full_command_arguments", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="blockAccessHostNetwork")
    def block_access_host_network(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with access to host network.
        """
        return pulumi.get(self, "block_access_host_network")

    @block_access_host_network.setter
    def block_access_host_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_access_host_network", value)

    @property
    @pulumi.getter(name="blockAddingCapabilities")
    def block_adding_capabilities(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with adding capabilities with `--cap-add` privilege.
        """
        return pulumi.get(self, "block_adding_capabilities")

    @block_adding_capabilities.setter
    def block_adding_capabilities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_adding_capabilities", value)

    @property
    @pulumi.getter(name="blockContainerExec")
    def block_container_exec(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, exec into a container is prevented.
        """
        return pulumi.get(self, "block_container_exec")

    @block_container_exec.setter
    def block_container_exec(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_container_exec", value)

    @property
    @pulumi.getter(name="blockCryptocurrencyMining")
    def block_cryptocurrency_mining(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        """
        return pulumi.get(self, "block_cryptocurrency_mining")

    @block_cryptocurrency_mining.setter
    def block_cryptocurrency_mining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_cryptocurrency_mining", value)

    @property
    @pulumi.getter(name="blockFilelessExec")
    def block_fileless_exec(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect and prevent running in-memory execution
        """
        return pulumi.get(self, "block_fileless_exec")

    @block_fileless_exec.setter
    def block_fileless_exec(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_fileless_exec", value)

    @property
    @pulumi.getter(name="blockLowPortBinding")
    def block_low_port_binding(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the capability to bind in port lower than 1024.
        """
        return pulumi.get(self, "block_low_port_binding")

    @block_low_port_binding.setter
    def block_low_port_binding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_low_port_binding", value)

    @property
    @pulumi.getter(name="blockNonCompliantImages")
    def block_non_compliant_images(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running non-compliant image in the container is prevented.
        """
        return pulumi.get(self, "block_non_compliant_images")

    @block_non_compliant_images.setter
    def block_non_compliant_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_non_compliant_images", value)

    @property
    @pulumi.getter(name="blockNonCompliantWorkloads")
    def block_non_compliant_workloads(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running containers in non-compliant pods is prevented.
        """
        return pulumi.get(self, "block_non_compliant_workloads")

    @block_non_compliant_workloads.setter
    def block_non_compliant_workloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_non_compliant_workloads", value)

    @property
    @pulumi.getter(name="blockNonK8sContainers")
    def block_non_k8s_containers(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running non-kubernetes containers is prevented.
        """
        return pulumi.get(self, "block_non_k8s_containers")

    @block_non_k8s_containers.setter
    def block_non_k8s_containers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_non_k8s_containers", value)

    @property
    @pulumi.getter(name="blockPrivilegedContainers")
    def block_privileged_containers(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with privileged container capability.
        """
        return pulumi.get(self, "block_privileged_containers")

    @block_privileged_containers.setter
    def block_privileged_containers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_privileged_containers", value)

    @property
    @pulumi.getter(name="blockReverseShell")
    def block_reverse_shell(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, reverse shell is prevented.
        """
        return pulumi.get(self, "block_reverse_shell")

    @block_reverse_shell.setter
    def block_reverse_shell(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_reverse_shell", value)

    @property
    @pulumi.getter(name="blockRootUser")
    def block_root_user(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with root user.
        """
        return pulumi.get(self, "block_root_user")

    @block_root_user.setter
    def block_root_user(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_root_user", value)

    @property
    @pulumi.getter(name="blockUnregisteredImages")
    def block_unregistered_images(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, running images in the container that are not registered in Aqua is prevented.
        """
        return pulumi.get(self, "block_unregistered_images")

    @block_unregistered_images.setter
    def block_unregistered_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_unregistered_images", value)

    @property
    @pulumi.getter(name="blockUseIpcNamespace")
    def block_use_ipc_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the IPC namespace.
        """
        return pulumi.get(self, "block_use_ipc_namespace")

    @block_use_ipc_namespace.setter
    def block_use_ipc_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_ipc_namespace", value)

    @property
    @pulumi.getter(name="blockUsePidNamespace")
    def block_use_pid_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the PID namespace.
        """
        return pulumi.get(self, "block_use_pid_namespace")

    @block_use_pid_namespace.setter
    def block_use_pid_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_pid_namespace", value)

    @property
    @pulumi.getter(name="blockUseUserNamespace")
    def block_use_user_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the user namespace.
        """
        return pulumi.get(self, "block_use_user_namespace")

    @block_use_user_namespace.setter
    def block_use_user_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_user_namespace", value)

    @property
    @pulumi.getter(name="blockUseUtsNamespace")
    def block_use_uts_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevent containers from running with the privilege to use the UTS namespace.
        """
        return pulumi.get(self, "block_use_uts_namespace")

    @block_use_uts_namespace.setter
    def block_use_uts_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_use_uts_namespace", value)

    @property
    @pulumi.getter(name="blockedCapabilities")
    def blocked_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If true, prevents containers from using specific Unix capabilities.
        """
        return pulumi.get(self, "blocked_capabilities")

    @blocked_capabilities.setter
    def blocked_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_capabilities", value)

    @property
    @pulumi.getter(name="blockedExecutables")
    def blocked_executables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of executables that are prevented from running in containers.
        """
        return pulumi.get(self, "blocked_executables")

    @blocked_executables.setter
    def blocked_executables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_executables", value)

    @property
    @pulumi.getter(name="blockedFiles")
    def blocked_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files that are prevented from being read, modified and executed in the containers.
        """
        return pulumi.get(self, "blocked_files")

    @blocked_files.setter
    def blocked_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_files", value)

    @property
    @pulumi.getter(name="blockedInboundPorts")
    def blocked_inbound_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of blocked inbound ports.
        """
        return pulumi.get(self, "blocked_inbound_ports")

    @blocked_inbound_ports.setter
    def blocked_inbound_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_inbound_ports", value)

    @property
    @pulumi.getter(name="blockedOutboundPorts")
    def blocked_outbound_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of blocked outbound ports.
        """
        return pulumi.get(self, "blocked_outbound_ports")

    @blocked_outbound_ports.setter
    def blocked_outbound_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_outbound_ports", value)

    @property
    @pulumi.getter(name="blockedPackages")
    def blocked_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Prevent containers from reading, writing, or executing all files in the list of packages.
        """
        return pulumi.get(self, "blocked_packages")

    @blocked_packages.setter
    def blocked_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_packages", value)

    @property
    @pulumi.getter(name="blockedVolumes")
    def blocked_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of volumes that are prevented from being mounted in the containers.
        """
        return pulumi.get(self, "blocked_volumes")

    @blocked_volumes.setter
    def blocked_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_volumes", value)

    @property
    @pulumi.getter(name="containerExecAllowedProcesses")
    def container_exec_allowed_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes that will be allowed.
        """
        return pulumi.get(self, "container_exec_allowed_processes")

    @container_exec_allowed_processes.setter
    def container_exec_allowed_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_exec_allowed_processes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the container runtime policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableDriftPrevention")
    def enable_drift_prevention(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, executables that are not in the original image is prevented from running.
        """
        return pulumi.get(self, "enable_drift_prevention")

    @enable_drift_prevention.setter
    def enable_drift_prevention(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_drift_prevention", value)

    @property
    @pulumi.getter(name="enableForkGuard")
    def enable_fork_guard(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, fork bombs are prevented in the containers.
        """
        return pulumi.get(self, "enable_fork_guard")

    @enable_fork_guard.setter
    def enable_fork_guard(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_fork_guard", value)

    @property
    @pulumi.getter(name="enableIpReputationSecurity")
    def enable_ip_reputation_security(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        """
        return pulumi.get(self, "enable_ip_reputation_security")

    @enable_ip_reputation_security.setter
    def enable_ip_reputation_security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ip_reputation_security", value)

    @property
    @pulumi.getter(name="enablePortScanDetection")
    def enable_port_scan_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, detects port scanning behavior in the container.
        """
        return pulumi.get(self, "enable_port_scan_detection")

    @enable_port_scan_detection.setter
    def enable_port_scan_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_port_scan_detection", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter(name="enforceAfterDays")
    def enforce_after_days(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of days after which the runtime policy will be changed to enforce mode.
        """
        return pulumi.get(self, "enforce_after_days")

    @enforce_after_days.setter
    def enforce_after_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enforce_after_days", value)

    @property
    @pulumi.getter(name="exceptionalReadonlyFilesAndDirectories")
    def exceptional_readonly_files_and_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files and directories to be excluded from the read-only list.
        """
        return pulumi.get(self, "exceptional_readonly_files_and_directories")

    @exceptional_readonly_files_and_directories.setter
    def exceptional_readonly_files_and_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exceptional_readonly_files_and_directories", value)

    @property
    @pulumi.getter(name="fileIntegrityMonitoring")
    def file_integrity_monitoring(self) -> Optional[pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs']]:
        """
        Configuration for file integrity monitoring.
        """
        return pulumi.get(self, "file_integrity_monitoring")

    @file_integrity_monitoring.setter
    def file_integrity_monitoring(self, value: Optional[pulumi.Input['ContainerRuntimePolicyFileIntegrityMonitoringArgs']]):
        pulumi.set(self, "file_integrity_monitoring", value)

    @property
    @pulumi.getter(name="forkGuardProcessLimit")
    def fork_guard_process_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Process limit for the fork guard.
        """
        return pulumi.get(self, "fork_guard_process_limit")

    @fork_guard_process_limit.setter
    def fork_guard_process_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fork_guard_process_limit", value)

    @property
    @pulumi.getter(name="limitNewPrivileges")
    def limit_new_privileges(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, prevents the container from obtaining new privileges at runtime. (only enabled in enforce mode)
        """
        return pulumi.get(self, "limit_new_privileges")

    @limit_new_privileges.setter
    def limit_new_privileges(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "limit_new_privileges", value)

    @property
    @pulumi.getter(name="monitorSystemTimeChanges")
    def monitor_system_time_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, system time changes will be monitored.
        """
        return pulumi.get(self, "monitor_system_time_changes")

    @monitor_system_time_changes.setter
    def monitor_system_time_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitor_system_time_changes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the container runtime policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readonlyFilesAndDirectories")
    def readonly_files_and_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files and directories to be restricted as read-only
        """
        return pulumi.get(self, "readonly_files_and_directories")

    @readonly_files_and_directories.setter
    def readonly_files_and_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "readonly_files_and_directories", value)

    @property
    @pulumi.getter(name="reverseShellAllowedIps")
    def reverse_shell_allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IPs/ CIDRs that will be allowed
        """
        return pulumi.get(self, "reverse_shell_allowed_ips")

    @reverse_shell_allowed_ips.setter
    def reverse_shell_allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reverse_shell_allowed_ips", value)

    @property
    @pulumi.getter(name="reverseShellAllowedProcesses")
    def reverse_shell_allowed_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes that will be allowed
        """
        return pulumi.get(self, "reverse_shell_allowed_processes")

    @reverse_shell_allowed_processes.setter
    def reverse_shell_allowed_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reverse_shell_allowed_processes", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRuntimePolicyScopeVariableArgs']]]]):
        pulumi.set(self, "scope_variables", value)


class ContainerRuntimePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_network_activity: Optional[pulumi.Input[bool]] = None,
                 audit_all_processes_activity: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 block_access_host_network: Optional[pulumi.Input[bool]] = None,
                 block_adding_capabilities: Optional[pulumi.Input[bool]] = None,
                 block_container_exec: Optional[pulumi.Input[bool]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 block_fileless_exec: Optional[pulumi.Input[bool]] = None,
                 block_low_port_binding: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_images: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_workloads: Optional[pulumi.Input[bool]] = None,
                 block_non_k8s_containers: Optional[pulumi.Input[bool]] = None,
                 block_privileged_containers: Optional[pulumi.Input[bool]] = None,
                 block_reverse_shell: Optional[pulumi.Input[bool]] = None,
                 block_root_user: Optional[pulumi.Input[bool]] = None,
                 block_unregistered_images: Optional[pulumi.Input[bool]] = None,
                 block_use_ipc_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_pid_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_user_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_uts_namespace: Optional[pulumi.Input[bool]] = None,
                 blocked_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_inbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_outbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_exec_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_drift_prevention: Optional[pulumi.Input[bool]] = None,
                 enable_fork_guard: Optional[pulumi.Input[bool]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enable_port_scan_detection: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 exceptional_readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyFileIntegrityMonitoringArgs']]] = None,
                 fork_guard_process_limit: Optional[pulumi.Input[int]] = None,
                 limit_new_privileges: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyScopeVariableArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        container_runtime_policy = aquasec.ContainerRuntimePolicy("containerRuntimePolicy",
            allowed_executables=[
                "exe",
                "bin",
            ],
            allowed_registries=[
                "registry1",
                "registry2",
            ],
            audit_all_network_activity=True,
            audit_all_processes_activity=True,
            audit_full_command_arguments=True,
            block_access_host_network=True,
            block_adding_capabilities=True,
            block_container_exec=True,
            block_cryptocurrency_mining=True,
            block_fileless_exec=True,
            block_low_port_binding=True,
            block_non_compliant_images=True,
            block_non_compliant_workloads=True,
            block_non_k8s_containers=True,
            block_privileged_containers=True,
            block_reverse_shell=True,
            block_root_user=True,
            block_unregistered_images=True,
            block_use_ipc_namespace=True,
            block_use_pid_namespace=True,
            block_use_user_namespace=True,
            block_use_uts_namespace=True,
            blocked_capabilities=[
                "AUDIT_CONTROL",
                "AUDIT_WRITE",
            ],
            blocked_executables=[
                "exe1",
                "exe2",
            ],
            blocked_files=[
                "test1",
                "test2",
            ],
            blocked_inbound_ports=[
                "80",
                "8080",
            ],
            blocked_outbound_ports=[
                "90",
                "9090",
            ],
            blocked_packages=[
                "pkg",
                "pkg2",
            ],
            blocked_volumes=[
                "blocked",
                "vol",
            ],
            container_exec_allowed_processes=[
                "proc1",
                "proc2",
            ],
            description="container_runtime_policy",
            enable_drift_prevention=True,
            enable_fork_guard=True,
            enable_ip_reputation_security=True,
            enable_port_scan_detection=True,
            enabled=True,
            enforce=False,
            exceptional_readonly_files_and_directories=[
                "readonly2",
                "/dir2/",
            ],
            file_integrity_monitoring=aquasec.ContainerRuntimePolicyFileIntegrityMonitoringArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                monitor_attributes=True,
                monitor_create=True,
                monitor_delete=True,
                monitor_modify=True,
                monitor_read=True,
                monitored_paths=["paths"],
                monitored_processes=["process"],
                monitored_users=["user"],
            ),
            fork_guard_process_limit=13,
            limit_new_privileges=True,
            monitor_system_time_changes=True,
            readonly_files_and_directories=[
                "readonly",
                "/dir/",
            ],
            reverse_shell_allowed_ips=[
                "ip1",
                "ip2",
            ],
            reverse_shell_allowed_processes=[
                "proc1",
                "proc2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_executables: List of executables that are allowed for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registries that allowed for running containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_network_activity: If true, all network activity will be audited.
        :param pulumi.Input[bool] audit_all_processes_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[bool] block_access_host_network: If true, prevent containers from running with access to host network.
        :param pulumi.Input[bool] block_adding_capabilities: If true, prevent containers from running with adding capabilities with `--cap-add` privilege.
        :param pulumi.Input[bool] block_container_exec: If true, exec into a container is prevented.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[bool] block_fileless_exec: Detect and prevent running in-memory execution
        :param pulumi.Input[bool] block_low_port_binding: If true, prevent containers from running with the capability to bind in port lower than 1024.
        :param pulumi.Input[bool] block_non_compliant_images: If true, running non-compliant image in the container is prevented.
        :param pulumi.Input[bool] block_non_compliant_workloads: If true, running containers in non-compliant pods is prevented.
        :param pulumi.Input[bool] block_non_k8s_containers: If true, running non-kubernetes containers is prevented.
        :param pulumi.Input[bool] block_privileged_containers: If true, prevent containers from running with privileged container capability.
        :param pulumi.Input[bool] block_reverse_shell: If true, reverse shell is prevented.
        :param pulumi.Input[bool] block_root_user: If true, prevent containers from running with root user.
        :param pulumi.Input[bool] block_unregistered_images: If true, running images in the container that are not registered in Aqua is prevented.
        :param pulumi.Input[bool] block_use_ipc_namespace: If true, prevent containers from running with the privilege to use the IPC namespace.
        :param pulumi.Input[bool] block_use_pid_namespace: If true, prevent containers from running with the privilege to use the PID namespace.
        :param pulumi.Input[bool] block_use_user_namespace: If true, prevent containers from running with the privilege to use the user namespace.
        :param pulumi.Input[bool] block_use_uts_namespace: If true, prevent containers from running with the privilege to use the UTS namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_capabilities: If true, prevents containers from using specific Unix capabilities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_inbound_ports: List of blocked inbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_outbound_ports: List of blocked outbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_packages: Prevent containers from reading, writing, or executing all files in the list of packages.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_volumes: List of volumes that are prevented from being mounted in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_exec_allowed_processes: List of processes that will be allowed.
        :param pulumi.Input[str] description: The description of the container runtime policy
        :param pulumi.Input[bool] enable_drift_prevention: If true, executables that are not in the original image is prevented from running.
        :param pulumi.Input[bool] enable_fork_guard: If true, fork bombs are prevented in the containers.
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enable_port_scan_detection: If true, detects port scanning behavior in the container.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exceptional_readonly_files_and_directories: List of files and directories to be excluded from the read-only list.
        :param pulumi.Input[pulumi.InputType['ContainerRuntimePolicyFileIntegrityMonitoringArgs']] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input[int] fork_guard_process_limit: Process limit for the fork guard.
        :param pulumi.Input[bool] limit_new_privileges: If true, prevents the container from obtaining new privileges at runtime. (only enabled in enforce mode)
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[str] name: Name of the container runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] readonly_files_and_directories: List of files and directories to be restricted as read-only
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_ips: List of IPs/ CIDRs that will be allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyScopeVariableArgs']]]] scope_variables: List of scope attributes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ContainerRuntimePolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        container_runtime_policy = aquasec.ContainerRuntimePolicy("containerRuntimePolicy",
            allowed_executables=[
                "exe",
                "bin",
            ],
            allowed_registries=[
                "registry1",
                "registry2",
            ],
            audit_all_network_activity=True,
            audit_all_processes_activity=True,
            audit_full_command_arguments=True,
            block_access_host_network=True,
            block_adding_capabilities=True,
            block_container_exec=True,
            block_cryptocurrency_mining=True,
            block_fileless_exec=True,
            block_low_port_binding=True,
            block_non_compliant_images=True,
            block_non_compliant_workloads=True,
            block_non_k8s_containers=True,
            block_privileged_containers=True,
            block_reverse_shell=True,
            block_root_user=True,
            block_unregistered_images=True,
            block_use_ipc_namespace=True,
            block_use_pid_namespace=True,
            block_use_user_namespace=True,
            block_use_uts_namespace=True,
            blocked_capabilities=[
                "AUDIT_CONTROL",
                "AUDIT_WRITE",
            ],
            blocked_executables=[
                "exe1",
                "exe2",
            ],
            blocked_files=[
                "test1",
                "test2",
            ],
            blocked_inbound_ports=[
                "80",
                "8080",
            ],
            blocked_outbound_ports=[
                "90",
                "9090",
            ],
            blocked_packages=[
                "pkg",
                "pkg2",
            ],
            blocked_volumes=[
                "blocked",
                "vol",
            ],
            container_exec_allowed_processes=[
                "proc1",
                "proc2",
            ],
            description="container_runtime_policy",
            enable_drift_prevention=True,
            enable_fork_guard=True,
            enable_ip_reputation_security=True,
            enable_port_scan_detection=True,
            enabled=True,
            enforce=False,
            exceptional_readonly_files_and_directories=[
                "readonly2",
                "/dir2/",
            ],
            file_integrity_monitoring=aquasec.ContainerRuntimePolicyFileIntegrityMonitoringArgs(
                excluded_paths=["expaths"],
                excluded_processes=["exprocess"],
                excluded_users=["expuser"],
                monitor_attributes=True,
                monitor_create=True,
                monitor_delete=True,
                monitor_modify=True,
                monitor_read=True,
                monitored_paths=["paths"],
                monitored_processes=["process"],
                monitored_users=["user"],
            ),
            fork_guard_process_limit=13,
            limit_new_privileges=True,
            monitor_system_time_changes=True,
            readonly_files_and_directories=[
                "readonly",
                "/dir/",
            ],
            reverse_shell_allowed_ips=[
                "ip1",
                "ip2",
            ],
            reverse_shell_allowed_processes=[
                "proc1",
                "proc2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param ContainerRuntimePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRuntimePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_all_network_activity: Optional[pulumi.Input[bool]] = None,
                 audit_all_processes_activity: Optional[pulumi.Input[bool]] = None,
                 audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
                 block_access_host_network: Optional[pulumi.Input[bool]] = None,
                 block_adding_capabilities: Optional[pulumi.Input[bool]] = None,
                 block_container_exec: Optional[pulumi.Input[bool]] = None,
                 block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
                 block_fileless_exec: Optional[pulumi.Input[bool]] = None,
                 block_low_port_binding: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_images: Optional[pulumi.Input[bool]] = None,
                 block_non_compliant_workloads: Optional[pulumi.Input[bool]] = None,
                 block_non_k8s_containers: Optional[pulumi.Input[bool]] = None,
                 block_privileged_containers: Optional[pulumi.Input[bool]] = None,
                 block_reverse_shell: Optional[pulumi.Input[bool]] = None,
                 block_root_user: Optional[pulumi.Input[bool]] = None,
                 block_unregistered_images: Optional[pulumi.Input[bool]] = None,
                 block_use_ipc_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_pid_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_user_namespace: Optional[pulumi.Input[bool]] = None,
                 block_use_uts_namespace: Optional[pulumi.Input[bool]] = None,
                 blocked_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_inbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_outbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_exec_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_drift_prevention: Optional[pulumi.Input[bool]] = None,
                 enable_fork_guard: Optional[pulumi.Input[bool]] = None,
                 enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
                 enable_port_scan_detection: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforce_after_days: Optional[pulumi.Input[int]] = None,
                 exceptional_readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_integrity_monitoring: Optional[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyFileIntegrityMonitoringArgs']]] = None,
                 fork_guard_process_limit: Optional[pulumi.Input[int]] = None,
                 limit_new_privileges: Optional[pulumi.Input[bool]] = None,
                 monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reverse_shell_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyScopeVariableArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRuntimePolicyArgs.__new__(ContainerRuntimePolicyArgs)

            __props__.__dict__["allowed_executables"] = allowed_executables
            __props__.__dict__["allowed_registries"] = allowed_registries
            __props__.__dict__["application_scopes"] = application_scopes
            __props__.__dict__["audit_all_network_activity"] = audit_all_network_activity
            __props__.__dict__["audit_all_processes_activity"] = audit_all_processes_activity
            __props__.__dict__["audit_full_command_arguments"] = audit_full_command_arguments
            __props__.__dict__["block_access_host_network"] = block_access_host_network
            __props__.__dict__["block_adding_capabilities"] = block_adding_capabilities
            __props__.__dict__["block_container_exec"] = block_container_exec
            __props__.__dict__["block_cryptocurrency_mining"] = block_cryptocurrency_mining
            __props__.__dict__["block_fileless_exec"] = block_fileless_exec
            __props__.__dict__["block_low_port_binding"] = block_low_port_binding
            __props__.__dict__["block_non_compliant_images"] = block_non_compliant_images
            __props__.__dict__["block_non_compliant_workloads"] = block_non_compliant_workloads
            __props__.__dict__["block_non_k8s_containers"] = block_non_k8s_containers
            __props__.__dict__["block_privileged_containers"] = block_privileged_containers
            __props__.__dict__["block_reverse_shell"] = block_reverse_shell
            __props__.__dict__["block_root_user"] = block_root_user
            __props__.__dict__["block_unregistered_images"] = block_unregistered_images
            __props__.__dict__["block_use_ipc_namespace"] = block_use_ipc_namespace
            __props__.__dict__["block_use_pid_namespace"] = block_use_pid_namespace
            __props__.__dict__["block_use_user_namespace"] = block_use_user_namespace
            __props__.__dict__["block_use_uts_namespace"] = block_use_uts_namespace
            __props__.__dict__["blocked_capabilities"] = blocked_capabilities
            __props__.__dict__["blocked_executables"] = blocked_executables
            __props__.__dict__["blocked_files"] = blocked_files
            __props__.__dict__["blocked_inbound_ports"] = blocked_inbound_ports
            __props__.__dict__["blocked_outbound_ports"] = blocked_outbound_ports
            __props__.__dict__["blocked_packages"] = blocked_packages
            __props__.__dict__["blocked_volumes"] = blocked_volumes
            __props__.__dict__["container_exec_allowed_processes"] = container_exec_allowed_processes
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_drift_prevention"] = enable_drift_prevention
            __props__.__dict__["enable_fork_guard"] = enable_fork_guard
            __props__.__dict__["enable_ip_reputation_security"] = enable_ip_reputation_security
            __props__.__dict__["enable_port_scan_detection"] = enable_port_scan_detection
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["enforce"] = enforce
            __props__.__dict__["enforce_after_days"] = enforce_after_days
            __props__.__dict__["exceptional_readonly_files_and_directories"] = exceptional_readonly_files_and_directories
            __props__.__dict__["file_integrity_monitoring"] = file_integrity_monitoring
            __props__.__dict__["fork_guard_process_limit"] = fork_guard_process_limit
            __props__.__dict__["limit_new_privileges"] = limit_new_privileges
            __props__.__dict__["monitor_system_time_changes"] = monitor_system_time_changes
            __props__.__dict__["name"] = name
            __props__.__dict__["readonly_files_and_directories"] = readonly_files_and_directories
            __props__.__dict__["reverse_shell_allowed_ips"] = reverse_shell_allowed_ips
            __props__.__dict__["reverse_shell_allowed_processes"] = reverse_shell_allowed_processes
            __props__.__dict__["scope_expression"] = scope_expression
            __props__.__dict__["scope_variables"] = scope_variables
            __props__.__dict__["author"] = None
        super(ContainerRuntimePolicy, __self__).__init__(
            'aquasec:index/containerRuntimePolicy:ContainerRuntimePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            audit_all_network_activity: Optional[pulumi.Input[bool]] = None,
            audit_all_processes_activity: Optional[pulumi.Input[bool]] = None,
            audit_full_command_arguments: Optional[pulumi.Input[bool]] = None,
            author: Optional[pulumi.Input[str]] = None,
            block_access_host_network: Optional[pulumi.Input[bool]] = None,
            block_adding_capabilities: Optional[pulumi.Input[bool]] = None,
            block_container_exec: Optional[pulumi.Input[bool]] = None,
            block_cryptocurrency_mining: Optional[pulumi.Input[bool]] = None,
            block_fileless_exec: Optional[pulumi.Input[bool]] = None,
            block_low_port_binding: Optional[pulumi.Input[bool]] = None,
            block_non_compliant_images: Optional[pulumi.Input[bool]] = None,
            block_non_compliant_workloads: Optional[pulumi.Input[bool]] = None,
            block_non_k8s_containers: Optional[pulumi.Input[bool]] = None,
            block_privileged_containers: Optional[pulumi.Input[bool]] = None,
            block_reverse_shell: Optional[pulumi.Input[bool]] = None,
            block_root_user: Optional[pulumi.Input[bool]] = None,
            block_unregistered_images: Optional[pulumi.Input[bool]] = None,
            block_use_ipc_namespace: Optional[pulumi.Input[bool]] = None,
            block_use_pid_namespace: Optional[pulumi.Input[bool]] = None,
            block_use_user_namespace: Optional[pulumi.Input[bool]] = None,
            block_use_uts_namespace: Optional[pulumi.Input[bool]] = None,
            blocked_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_executables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_inbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_outbound_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            container_exec_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_drift_prevention: Optional[pulumi.Input[bool]] = None,
            enable_fork_guard: Optional[pulumi.Input[bool]] = None,
            enable_ip_reputation_security: Optional[pulumi.Input[bool]] = None,
            enable_port_scan_detection: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            enforce: Optional[pulumi.Input[bool]] = None,
            enforce_after_days: Optional[pulumi.Input[int]] = None,
            exceptional_readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            file_integrity_monitoring: Optional[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyFileIntegrityMonitoringArgs']]] = None,
            fork_guard_process_limit: Optional[pulumi.Input[int]] = None,
            limit_new_privileges: Optional[pulumi.Input[bool]] = None,
            monitor_system_time_changes: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            readonly_files_and_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            reverse_shell_allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            reverse_shell_allowed_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scope_expression: Optional[pulumi.Input[str]] = None,
            scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyScopeVariableArgs']]]]] = None) -> 'ContainerRuntimePolicy':
        """
        Get an existing ContainerRuntimePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_executables: List of executables that are allowed for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registries that allowed for running containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[bool] audit_all_network_activity: If true, all network activity will be audited.
        :param pulumi.Input[bool] audit_all_processes_activity: If true, all process activity will be audited.
        :param pulumi.Input[bool] audit_full_command_arguments: If true, full command arguments will be audited.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[bool] block_access_host_network: If true, prevent containers from running with access to host network.
        :param pulumi.Input[bool] block_adding_capabilities: If true, prevent containers from running with adding capabilities with `--cap-add` privilege.
        :param pulumi.Input[bool] block_container_exec: If true, exec into a container is prevented.
        :param pulumi.Input[bool] block_cryptocurrency_mining: Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        :param pulumi.Input[bool] block_fileless_exec: Detect and prevent running in-memory execution
        :param pulumi.Input[bool] block_low_port_binding: If true, prevent containers from running with the capability to bind in port lower than 1024.
        :param pulumi.Input[bool] block_non_compliant_images: If true, running non-compliant image in the container is prevented.
        :param pulumi.Input[bool] block_non_compliant_workloads: If true, running containers in non-compliant pods is prevented.
        :param pulumi.Input[bool] block_non_k8s_containers: If true, running non-kubernetes containers is prevented.
        :param pulumi.Input[bool] block_privileged_containers: If true, prevent containers from running with privileged container capability.
        :param pulumi.Input[bool] block_reverse_shell: If true, reverse shell is prevented.
        :param pulumi.Input[bool] block_root_user: If true, prevent containers from running with root user.
        :param pulumi.Input[bool] block_unregistered_images: If true, running images in the container that are not registered in Aqua is prevented.
        :param pulumi.Input[bool] block_use_ipc_namespace: If true, prevent containers from running with the privilege to use the IPC namespace.
        :param pulumi.Input[bool] block_use_pid_namespace: If true, prevent containers from running with the privilege to use the PID namespace.
        :param pulumi.Input[bool] block_use_user_namespace: If true, prevent containers from running with the privilege to use the user namespace.
        :param pulumi.Input[bool] block_use_uts_namespace: If true, prevent containers from running with the privilege to use the UTS namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_capabilities: If true, prevents containers from using specific Unix capabilities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_executables: List of executables that are prevented from running in containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_files: List of files that are prevented from being read, modified and executed in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_inbound_ports: List of blocked inbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_outbound_ports: List of blocked outbound ports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_packages: Prevent containers from reading, writing, or executing all files in the list of packages.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_volumes: List of volumes that are prevented from being mounted in the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_exec_allowed_processes: List of processes that will be allowed.
        :param pulumi.Input[str] description: The description of the container runtime policy
        :param pulumi.Input[bool] enable_drift_prevention: If true, executables that are not in the original image is prevented from running.
        :param pulumi.Input[bool] enable_fork_guard: If true, fork bombs are prevented in the containers.
        :param pulumi.Input[bool] enable_ip_reputation_security: If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        :param pulumi.Input[bool] enable_port_scan_detection: If true, detects port scanning behavior in the container.
        :param pulumi.Input[bool] enabled: Indicates if the runtime policy is enabled or not.
        :param pulumi.Input[bool] enforce: Indicates that policy should effect container execution (not just for audit).
        :param pulumi.Input[int] enforce_after_days: Indicates the number of days after which the runtime policy will be changed to enforce mode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exceptional_readonly_files_and_directories: List of files and directories to be excluded from the read-only list.
        :param pulumi.Input[pulumi.InputType['ContainerRuntimePolicyFileIntegrityMonitoringArgs']] file_integrity_monitoring: Configuration for file integrity monitoring.
        :param pulumi.Input[int] fork_guard_process_limit: Process limit for the fork guard.
        :param pulumi.Input[bool] limit_new_privileges: If true, prevents the container from obtaining new privileges at runtime. (only enabled in enforce mode)
        :param pulumi.Input[bool] monitor_system_time_changes: If true, system time changes will be monitored.
        :param pulumi.Input[str] name: Name of the container runtime policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] readonly_files_and_directories: List of files and directories to be restricted as read-only
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_ips: List of IPs/ CIDRs that will be allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reverse_shell_allowed_processes: List of processes that will be allowed
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerRuntimePolicyScopeVariableArgs']]]] scope_variables: List of scope attributes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRuntimePolicyState.__new__(_ContainerRuntimePolicyState)

        __props__.__dict__["allowed_executables"] = allowed_executables
        __props__.__dict__["allowed_registries"] = allowed_registries
        __props__.__dict__["application_scopes"] = application_scopes
        __props__.__dict__["audit_all_network_activity"] = audit_all_network_activity
        __props__.__dict__["audit_all_processes_activity"] = audit_all_processes_activity
        __props__.__dict__["audit_full_command_arguments"] = audit_full_command_arguments
        __props__.__dict__["author"] = author
        __props__.__dict__["block_access_host_network"] = block_access_host_network
        __props__.__dict__["block_adding_capabilities"] = block_adding_capabilities
        __props__.__dict__["block_container_exec"] = block_container_exec
        __props__.__dict__["block_cryptocurrency_mining"] = block_cryptocurrency_mining
        __props__.__dict__["block_fileless_exec"] = block_fileless_exec
        __props__.__dict__["block_low_port_binding"] = block_low_port_binding
        __props__.__dict__["block_non_compliant_images"] = block_non_compliant_images
        __props__.__dict__["block_non_compliant_workloads"] = block_non_compliant_workloads
        __props__.__dict__["block_non_k8s_containers"] = block_non_k8s_containers
        __props__.__dict__["block_privileged_containers"] = block_privileged_containers
        __props__.__dict__["block_reverse_shell"] = block_reverse_shell
        __props__.__dict__["block_root_user"] = block_root_user
        __props__.__dict__["block_unregistered_images"] = block_unregistered_images
        __props__.__dict__["block_use_ipc_namespace"] = block_use_ipc_namespace
        __props__.__dict__["block_use_pid_namespace"] = block_use_pid_namespace
        __props__.__dict__["block_use_user_namespace"] = block_use_user_namespace
        __props__.__dict__["block_use_uts_namespace"] = block_use_uts_namespace
        __props__.__dict__["blocked_capabilities"] = blocked_capabilities
        __props__.__dict__["blocked_executables"] = blocked_executables
        __props__.__dict__["blocked_files"] = blocked_files
        __props__.__dict__["blocked_inbound_ports"] = blocked_inbound_ports
        __props__.__dict__["blocked_outbound_ports"] = blocked_outbound_ports
        __props__.__dict__["blocked_packages"] = blocked_packages
        __props__.__dict__["blocked_volumes"] = blocked_volumes
        __props__.__dict__["container_exec_allowed_processes"] = container_exec_allowed_processes
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_drift_prevention"] = enable_drift_prevention
        __props__.__dict__["enable_fork_guard"] = enable_fork_guard
        __props__.__dict__["enable_ip_reputation_security"] = enable_ip_reputation_security
        __props__.__dict__["enable_port_scan_detection"] = enable_port_scan_detection
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["enforce"] = enforce
        __props__.__dict__["enforce_after_days"] = enforce_after_days
        __props__.__dict__["exceptional_readonly_files_and_directories"] = exceptional_readonly_files_and_directories
        __props__.__dict__["file_integrity_monitoring"] = file_integrity_monitoring
        __props__.__dict__["fork_guard_process_limit"] = fork_guard_process_limit
        __props__.__dict__["limit_new_privileges"] = limit_new_privileges
        __props__.__dict__["monitor_system_time_changes"] = monitor_system_time_changes
        __props__.__dict__["name"] = name
        __props__.__dict__["readonly_files_and_directories"] = readonly_files_and_directories
        __props__.__dict__["reverse_shell_allowed_ips"] = reverse_shell_allowed_ips
        __props__.__dict__["reverse_shell_allowed_processes"] = reverse_shell_allowed_processes
        __props__.__dict__["scope_expression"] = scope_expression
        __props__.__dict__["scope_variables"] = scope_variables
        return ContainerRuntimePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedExecutables")
    def allowed_executables(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of executables that are allowed for the user.
        """
        return pulumi.get(self, "allowed_executables")

    @property
    @pulumi.getter(name="allowedRegistries")
    def allowed_registries(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of registries that allowed for running containers.
        """
        return pulumi.get(self, "allowed_registries")

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @property
    @pulumi.getter(name="auditAllNetworkActivity")
    def audit_all_network_activity(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, all network activity will be audited.
        """
        return pulumi.get(self, "audit_all_network_activity")

    @property
    @pulumi.getter(name="auditAllProcessesActivity")
    def audit_all_processes_activity(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, all process activity will be audited.
        """
        return pulumi.get(self, "audit_all_processes_activity")

    @property
    @pulumi.getter(name="auditFullCommandArguments")
    def audit_full_command_arguments(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, full command arguments will be audited.
        """
        return pulumi.get(self, "audit_full_command_arguments")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="blockAccessHostNetwork")
    def block_access_host_network(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with access to host network.
        """
        return pulumi.get(self, "block_access_host_network")

    @property
    @pulumi.getter(name="blockAddingCapabilities")
    def block_adding_capabilities(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with adding capabilities with `--cap-add` privilege.
        """
        return pulumi.get(self, "block_adding_capabilities")

    @property
    @pulumi.getter(name="blockContainerExec")
    def block_container_exec(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, exec into a container is prevented.
        """
        return pulumi.get(self, "block_container_exec")

    @property
    @pulumi.getter(name="blockCryptocurrencyMining")
    def block_cryptocurrency_mining(self) -> pulumi.Output[Optional[bool]]:
        """
        Detect and prevent communication to DNS/IP addresses known to be used for Cryptocurrency Mining
        """
        return pulumi.get(self, "block_cryptocurrency_mining")

    @property
    @pulumi.getter(name="blockFilelessExec")
    def block_fileless_exec(self) -> pulumi.Output[Optional[bool]]:
        """
        Detect and prevent running in-memory execution
        """
        return pulumi.get(self, "block_fileless_exec")

    @property
    @pulumi.getter(name="blockLowPortBinding")
    def block_low_port_binding(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with the capability to bind in port lower than 1024.
        """
        return pulumi.get(self, "block_low_port_binding")

    @property
    @pulumi.getter(name="blockNonCompliantImages")
    def block_non_compliant_images(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, running non-compliant image in the container is prevented.
        """
        return pulumi.get(self, "block_non_compliant_images")

    @property
    @pulumi.getter(name="blockNonCompliantWorkloads")
    def block_non_compliant_workloads(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, running containers in non-compliant pods is prevented.
        """
        return pulumi.get(self, "block_non_compliant_workloads")

    @property
    @pulumi.getter(name="blockNonK8sContainers")
    def block_non_k8s_containers(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, running non-kubernetes containers is prevented.
        """
        return pulumi.get(self, "block_non_k8s_containers")

    @property
    @pulumi.getter(name="blockPrivilegedContainers")
    def block_privileged_containers(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with privileged container capability.
        """
        return pulumi.get(self, "block_privileged_containers")

    @property
    @pulumi.getter(name="blockReverseShell")
    def block_reverse_shell(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, reverse shell is prevented.
        """
        return pulumi.get(self, "block_reverse_shell")

    @property
    @pulumi.getter(name="blockRootUser")
    def block_root_user(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with root user.
        """
        return pulumi.get(self, "block_root_user")

    @property
    @pulumi.getter(name="blockUnregisteredImages")
    def block_unregistered_images(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, running images in the container that are not registered in Aqua is prevented.
        """
        return pulumi.get(self, "block_unregistered_images")

    @property
    @pulumi.getter(name="blockUseIpcNamespace")
    def block_use_ipc_namespace(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with the privilege to use the IPC namespace.
        """
        return pulumi.get(self, "block_use_ipc_namespace")

    @property
    @pulumi.getter(name="blockUsePidNamespace")
    def block_use_pid_namespace(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with the privilege to use the PID namespace.
        """
        return pulumi.get(self, "block_use_pid_namespace")

    @property
    @pulumi.getter(name="blockUseUserNamespace")
    def block_use_user_namespace(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with the privilege to use the user namespace.
        """
        return pulumi.get(self, "block_use_user_namespace")

    @property
    @pulumi.getter(name="blockUseUtsNamespace")
    def block_use_uts_namespace(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevent containers from running with the privilege to use the UTS namespace.
        """
        return pulumi.get(self, "block_use_uts_namespace")

    @property
    @pulumi.getter(name="blockedCapabilities")
    def blocked_capabilities(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        If true, prevents containers from using specific Unix capabilities.
        """
        return pulumi.get(self, "blocked_capabilities")

    @property
    @pulumi.getter(name="blockedExecutables")
    def blocked_executables(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of executables that are prevented from running in containers.
        """
        return pulumi.get(self, "blocked_executables")

    @property
    @pulumi.getter(name="blockedFiles")
    def blocked_files(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of files that are prevented from being read, modified and executed in the containers.
        """
        return pulumi.get(self, "blocked_files")

    @property
    @pulumi.getter(name="blockedInboundPorts")
    def blocked_inbound_ports(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of blocked inbound ports.
        """
        return pulumi.get(self, "blocked_inbound_ports")

    @property
    @pulumi.getter(name="blockedOutboundPorts")
    def blocked_outbound_ports(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of blocked outbound ports.
        """
        return pulumi.get(self, "blocked_outbound_ports")

    @property
    @pulumi.getter(name="blockedPackages")
    def blocked_packages(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Prevent containers from reading, writing, or executing all files in the list of packages.
        """
        return pulumi.get(self, "blocked_packages")

    @property
    @pulumi.getter(name="blockedVolumes")
    def blocked_volumes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of volumes that are prevented from being mounted in the containers.
        """
        return pulumi.get(self, "blocked_volumes")

    @property
    @pulumi.getter(name="containerExecAllowedProcesses")
    def container_exec_allowed_processes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of processes that will be allowed.
        """
        return pulumi.get(self, "container_exec_allowed_processes")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the container runtime policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableDriftPrevention")
    def enable_drift_prevention(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, executables that are not in the original image is prevented from running.
        """
        return pulumi.get(self, "enable_drift_prevention")

    @property
    @pulumi.getter(name="enableForkGuard")
    def enable_fork_guard(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, fork bombs are prevented in the containers.
        """
        return pulumi.get(self, "enable_fork_guard")

    @property
    @pulumi.getter(name="enableIpReputationSecurity")
    def enable_ip_reputation_security(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, detect and prevent communication from containers to IP addresses known to have a bad reputation.
        """
        return pulumi.get(self, "enable_ip_reputation_security")

    @property
    @pulumi.getter(name="enablePortScanDetection")
    def enable_port_scan_detection(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, detects port scanning behavior in the container.
        """
        return pulumi.get(self, "enable_port_scan_detection")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if the runtime policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def enforce(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates that policy should effect container execution (not just for audit).
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter(name="enforceAfterDays")
    def enforce_after_days(self) -> pulumi.Output[Optional[int]]:
        """
        Indicates the number of days after which the runtime policy will be changed to enforce mode.
        """
        return pulumi.get(self, "enforce_after_days")

    @property
    @pulumi.getter(name="exceptionalReadonlyFilesAndDirectories")
    def exceptional_readonly_files_and_directories(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of files and directories to be excluded from the read-only list.
        """
        return pulumi.get(self, "exceptional_readonly_files_and_directories")

    @property
    @pulumi.getter(name="fileIntegrityMonitoring")
    def file_integrity_monitoring(self) -> pulumi.Output[Optional['outputs.ContainerRuntimePolicyFileIntegrityMonitoring']]:
        """
        Configuration for file integrity monitoring.
        """
        return pulumi.get(self, "file_integrity_monitoring")

    @property
    @pulumi.getter(name="forkGuardProcessLimit")
    def fork_guard_process_limit(self) -> pulumi.Output[Optional[int]]:
        """
        Process limit for the fork guard.
        """
        return pulumi.get(self, "fork_guard_process_limit")

    @property
    @pulumi.getter(name="limitNewPrivileges")
    def limit_new_privileges(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, prevents the container from obtaining new privileges at runtime. (only enabled in enforce mode)
        """
        return pulumi.get(self, "limit_new_privileges")

    @property
    @pulumi.getter(name="monitorSystemTimeChanges")
    def monitor_system_time_changes(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, system time changes will be monitored.
        """
        return pulumi.get(self, "monitor_system_time_changes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the container runtime policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readonlyFilesAndDirectories")
    def readonly_files_and_directories(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of files and directories to be restricted as read-only
        """
        return pulumi.get(self, "readonly_files_and_directories")

    @property
    @pulumi.getter(name="reverseShellAllowedIps")
    def reverse_shell_allowed_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of IPs/ CIDRs that will be allowed
        """
        return pulumi.get(self, "reverse_shell_allowed_ips")

    @property
    @pulumi.getter(name="reverseShellAllowedProcesses")
    def reverse_shell_allowed_processes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of processes that will be allowed
        """
        return pulumi.get(self, "reverse_shell_allowed_processes")

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> pulumi.Output[str]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> pulumi.Output[Sequence['outputs.ContainerRuntimePolicyScopeVariable']]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

