import { HttpRouteAuthorizerBindOptions, HttpRouteAuthorizerConfig, IHttpRouteAuthorizer } from '@aws-cdk/aws-apigatewayv2-alpha';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { Duration } from 'aws-cdk-lib';
/**
 * (experimental) Specifies the type responses the lambda returns.
 *
 * @experimental
 */
export declare enum HttpLambdaResponseType {
    /**
     * (experimental) Returns simple boolean response.
     *
     * @experimental
     */
    SIMPLE = 0,
    /**
     * (experimental) Returns an IAM Policy.
     *
     * @experimental
     */
    IAM = 1
}
/**
 * (experimental) Properties to initialize HttpTokenAuthorizer.
 *
 * @experimental
 */
export interface HttpLambdaAuthorizerProps {
    /**
     * (experimental) The name of the authorizer.
     *
     * @experimental
     */
    readonly authorizerName: string;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * @default ['$request.header.Authorization']
     * @experimental
     */
    readonly identitySource?: string[];
    /**
     * (experimental) The lambda function used for authorization.
     *
     * @experimental
     */
    readonly handler: IFunction;
    /**
     * (experimental) How long APIGateway should cache the results.
     *
     * Max 1 hour.
     * Disable caching by setting this to `Duration.seconds(0)`.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly resultsCacheTtl?: Duration;
    /**
     * (experimental) The types of responses the lambda can return.
     *
     * If HttpLambdaResponseType.SIMPLE is included then
     * response format 2.0 will be used.
     *
     * @default [HttpLambdaResponseType.IAM]
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html#http-api-lambda-authorizer.payload-format-response
     * @experimental
     */
    readonly responseTypes?: HttpLambdaResponseType[];
}
/**
 * (experimental) Authorize Http Api routes via a lambda function.
 *
 * @experimental
 */
export declare class HttpLambdaAuthorizer implements IHttpRouteAuthorizer {
    private readonly props;
    private authorizer?;
    private httpApi?;
    /**
     * @experimental
     */
    constructor(props: HttpLambdaAuthorizerProps);
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options: HttpRouteAuthorizerBindOptions): HttpRouteAuthorizerConfig;
}
