from exploits.tree import binary_search_tree
from test.exploits.dummy_output import DummyOutput
from input.ints import IntGenerator


def test_search():
    output = DummyOutput()
    n_inputs = 10
    final_message_prefix = 'Search for : '
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'search'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 2
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i
    assert output[-1][:len(final_message_prefix)] == final_message_prefix
    assert int(output[-1][len(final_message_prefix):]) == 256 - n_inputs


def test_search_more_inputs():
    output = DummyOutput()
    n_inputs = 100
    final_message_prefix = 'Search for : '
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'search'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 2
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i
    assert output[-1][:len(final_message_prefix)] == final_message_prefix
    assert int(output[-1][len(final_message_prefix):]) == 256 - n_inputs


def test_delete():
    output = DummyOutput()
    n_inputs = 10
    final_message_prefix = 'Delete : '
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'delete'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 2
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i
    assert output[-1][:len(final_message_prefix)] == final_message_prefix
    assert int(output[-1][len(final_message_prefix):]) == 256 - n_inputs


def test_delete_more_input():
    output = DummyOutput()
    n_inputs = 100
    final_message_prefix = 'Delete : '
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'delete'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 2
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i
    assert output[-1][:len(final_message_prefix)] == final_message_prefix
    assert int(output[-1][len(final_message_prefix):]) == 256 - n_inputs


def test_insert():
    output = DummyOutput()
    n_inputs = 10
    final_message_prefix = 'Insert : '
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'insert'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 2
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i
    assert output[-1][:len(final_message_prefix)] == final_message_prefix
    assert int(output[-1][len(final_message_prefix):]) == 255 - n_inputs


def test_insert_more_inputs():
    output = DummyOutput()
    n_inputs = 100
    final_message_prefix = 'Insert : '
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'insert'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 2
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i
    assert output[-1][:len(final_message_prefix)] == final_message_prefix
    assert int(output[-1][len(final_message_prefix):]) == 255 - n_inputs


def test_min():
    output = DummyOutput()
    n_inputs = 10
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'min'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 1
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i


def test_min_more_inputs():
    output = DummyOutput()
    n_inputs = 100
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'min'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 1
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 256 - i



def test_max():
    output = DummyOutput()
    n_inputs = 10
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'max'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 1
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 255 - (n_inputs - i)


def test_max_more_inputs():
    output = DummyOutput()
    n_inputs = 100
    first_message = 'Tree insertion order:'
    binary_search_tree.options['n_inputs'] = n_inputs
    binary_search_tree.options['function'] = 'max'
    binary_search_tree.run(IntGenerator(), output)
    assert len(output) == n_inputs + 1
    assert output[0] == first_message
    for i in range(1, len(output) - 1):
        assert output[i] == 255 - (n_inputs - i)
