from exploits.strings.matching import boyer_moore
from test.exploits.dummy_output import DummyOutput
from input.chars import CharGenerator


def test_run():
    output = DummyOutput()
    string_length = 10
    pattern_length = 5
    boyer_moore.options['string_length'] = string_length
    boyer_moore.options['pattern_length'] = pattern_length
    boyer_moore.options['match'] = True
    boyer_moore.run(CharGenerator(), output)
    assert len(output) == 2
    string = output[0][len('String: '):]
    pattern = output[1][len('Search Pattern: '):]
    assert string == 'a' * string_length
    assert pattern == 'a' * pattern_length


def test_longer_string():
    output = DummyOutput()
    string_length = 100
    pattern_length = 5
    boyer_moore.options['string_length'] = string_length
    boyer_moore.options['pattern_length'] = pattern_length
    boyer_moore.options['match'] = True
    boyer_moore.run(CharGenerator(), output)
    assert len(output) == 2
    string = output[0][len('String: '):]
    pattern = output[1][len('Search Pattern: '):]
    assert string == 'a' * string_length
    assert pattern == 'a' * pattern_length


def test_longer_pattern():
    output = DummyOutput()
    string_length = 10
    pattern_length = 50
    boyer_moore.options['string_length'] = string_length
    boyer_moore.options['pattern_length'] = pattern_length
    boyer_moore.options['match'] = True
    boyer_moore.run(CharGenerator(), output)
    assert len(output) == 2
    string = output[0][len('String: '):]
    pattern = output[1][len('Search Pattern: '):]
    assert string == 'a' * string_length
    assert pattern == 'a' * pattern_length


def test_run_no_match():
    output = DummyOutput()
    string_length = 10
    pattern_length = 5
    boyer_moore.options['string_length'] = string_length
    boyer_moore.options['pattern_length'] = pattern_length
    boyer_moore.options['match'] = False
    boyer_moore.run(CharGenerator(), output)
    assert len(output) == 2
    string = output[0][len('String: '):]
    pattern = output[1][len('Search Pattern: '):]
    assert string == ('a' * (pattern_length - 1) + 'z') * (string_length // pattern_length)
    assert pattern == 'a' * pattern_length
