import pytest
from exploits.bombs.compression import pdf
from test.exploits.dummy_output import DummyOutput

# TODO check that the output meets the input requirements


def test_small_bomb():
    output = DummyOutput()
    target_payload_memory = 1000
    pdf.options['target_payload_memory'] = target_payload_memory
    pdf.run(output)
    assert len(output) == 1


def test_100mb_bomb():
    output = DummyOutput()
    target_payload_memory = 10**8
    pdf.options['target_payload_memory'] = target_payload_memory
    pdf.run(output)
    assert len(output) == 1


def test_1gb_bomb():
    output = DummyOutput()
    target_payload_memory = 10**9
    pdf.options['target_payload_memory'] = target_payload_memory
    pdf.run(output)
    assert len(output) == 1


def test_10gb_bomb():
    output = DummyOutput()
    target_payload_memory = 10**10
    pdf.options['target_payload_memory'] = target_payload_memory
    pdf.run(output)
    assert len(output) == 1


def test_100gb_failed_bomb():
    output = DummyOutput()
    target_payload_memory = 10**11
    pdf.options['target_payload_memory'] = target_payload_memory
    with pytest.raises(ValueError):
        pdf.run(output)


def test_time_multiplier_bomb():
    output = DummyOutput()
    target_payload_memory = 1000
    pdf.options['target_payload_memory'] = target_payload_memory
    pdf.options['time_multiplier'] = 2
    pdf.run(output)
    assert len(output) == 1
