from acsploit.options import Options

options = Options()
options.add_option('n_inputs', 10, 'Number of elements to sort')

DESCRIPTION = ('Produces a worst-case input set for bucketsort (aka radixsort)'
               '\n\n  Generates a list with a large range and many values clustered together '
               'so that many values fall in the same bucket')


def run(generator, output):
    # bucketsort worst case is values clustered and a large range so the clustered values fall in same bucket
    out = [generator.get_min_value(), generator.get_max_value()]  # force max range
    for value in generator.get_list_of_values(options['n_inputs'] - 2):  # generate a big cluster
        out.append(value)
    output.output(out)
