from acsploit.options import Options


options = Options()
options.add_option('n_inputs', 10, 'Number of elements to sort')

DESCRIPTION = ('Produces a worst-case input set for bubblesort'
               '\n\n  Generates a reverse sorted list, which will cause bubblesort to run in O(n^2) time.')


def run(generator, output):
    # Bubblesort worst case is reverse ordered
    output.output(descending_list(generator, options['n_inputs']))


def descending_list(generator, n_inputs):
    output = [generator.get_max_value()]

    for i in range(1, n_inputs):
        output.append(generator.get_less_than(output[i-1]))
    return output
