from acsploit.options import Options
from .php5_common import generate_via_half_string_merge, php_hash


options = Options()
options.add_option('n_collisions', 10, 'Number of colliding strings to create')
options.add_option('hash_table_size', 2**32, 'Size of target hash table')
options.add_option('target_type', 'preimage', 'Whether the target is an image (hash output) or preimage (hash input)',
                   ['image', 'preimage'])
options.add_option('target', 'hello', 'Image or preimage of desired hash value')

DESCRIPTION = 'Produces hash collisions for the PHP 5 hash function.' \
              '\n\n  ' \
              'Uses a slower and more memory intensive technique but generates smaller strings.' \
              'See php5_fast for a more efficient option.'

DEFAULT_INPUT = 'char'


def run(generator, output):
    forbidden_string = ''
    if options['target_type'] == 'preimage':
        target = php_hash(options['target'], options['hash_table_size'])
        forbidden_string = options['target']
    else:
        target = int(options['target'])

    ret = generate_via_half_string_merge(generator, target, options['n_collisions'],
                                         options['hash_table_size'], forbidden_string)
    output.output(ret)
