import z3
from acsploit.options import Options
from .z3_common import get_collisions


options = Options()
options.add_option('n_collisions', 10, 'Number of colliding strings to create')
options.add_option('length', 10, 'Length of strings to create')
options.add_option('hash_table_size', 100, 'Size of target hash table')
options.add_option('target_type', 'preimage', 'Whether the target is an image (hash output) or preimage (hash input)',
                   ['image', 'preimage'])
options.add_option('target', 'hello', 'Image or preimage of desired hash value')

DESCRIPTION = 'Produces hash collisions for the adler32 hash function.' \
              '\n\n  ' \
              'This exploit works by using z3 to "solve" for hash collisions. An implementation of the Adler32 ' \
              'checksum for z3 is used to generate a constraint system that z3 solves to find colliding hash inputs.'

NO_INPUT = True


def run(output):
    ret = get_collisions(z3adler32, options['target'], options['target_type'], options['length'],
                         options['n_collisions'], options['hash_table_size'])
    output.output(ret)


def z3adler32(bytes, hash_table_size):  # computes the z3 form of the adler32 checksum (modulo hash table size)
    v1 = 1
    v2 = 0
    for byte in bytes:
        v1 = (v1 + z3.ZeroExt(56, byte)) % 65521
        v2 = (v2 + v1) % 65521
    return (v2 * 65536 + v1) % hash_table_size
