from acsploit.options import Options


options = Options()
options.add_option('n_nodes', 10, 'Number of nodes in graph')

DESCRIPTION = 'Produces a worst-case adjacency matrix for Kruskal\'s algorithm.' \
              '\n\n  ' \
              'Kruskal\'s algorithm finds the minimum spanning tree of an undirected weighted graph. To ' \
              'generate the worst-case input, we generates a complete graph where nodes in the graph grow further apart. ' \
              'Many edges with smaller edge weights are considered and rejected for creating cycles before ' \
              'each correct edge is added to the tree. This produces the worst case runtime of O(E log E), where E ' \
              'is the number of edges in the graph.'

NO_INPUT = True


def run(output):
    output.output(kruskal(options['n_nodes']))


def kruskal(n_inputs):
    adjacency_matrix = [[0 for _ in range(n_inputs)] for _ in range(n_inputs)]
    for i in range(n_inputs):
        for j in range(n_inputs):
            if i != j:
                adjacency_matrix[i][j] = max(i, j)
    return adjacency_matrix
