import { __assign, __awaiter, __generator, __read } from "tslib";
import { HttpRequest as __HttpRequest } from "@aws-sdk/protocol-http";
import { decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectLong as __expectLong, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectString as __expectString, parseEpochTimestamp as __parseEpochTimestamp, } from "@aws-sdk/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { DecryptionFailure, EncryptionFailure, InternalServiceError, InvalidNextTokenException, InvalidParameterException, InvalidRequestException, LimitExceededException, MalformedPolicyDocumentException, PreconditionNotMetException, PublicPolicyException, ResourceExistsException, ResourceNotFoundException, } from "../models/models_0";
import { SecretsManagerServiceException as __BaseException } from "../models/SecretsManagerServiceException";
export var serializeAws_json1_1CancelRotateSecretCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.CancelRotateSecret",
        };
        body = JSON.stringify(serializeAws_json1_1CancelRotateSecretRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1CreateSecretCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.CreateSecret",
        };
        body = JSON.stringify(serializeAws_json1_1CreateSecretRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1DeleteResourcePolicyCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.DeleteResourcePolicy",
        };
        body = JSON.stringify(serializeAws_json1_1DeleteResourcePolicyRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1DeleteSecretCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.DeleteSecret",
        };
        body = JSON.stringify(serializeAws_json1_1DeleteSecretRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1DescribeSecretCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.DescribeSecret",
        };
        body = JSON.stringify(serializeAws_json1_1DescribeSecretRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1GetRandomPasswordCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.GetRandomPassword",
        };
        body = JSON.stringify(serializeAws_json1_1GetRandomPasswordRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1GetResourcePolicyCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.GetResourcePolicy",
        };
        body = JSON.stringify(serializeAws_json1_1GetResourcePolicyRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1GetSecretValueCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.GetSecretValue",
        };
        body = JSON.stringify(serializeAws_json1_1GetSecretValueRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1ListSecretsCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.ListSecrets",
        };
        body = JSON.stringify(serializeAws_json1_1ListSecretsRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1ListSecretVersionIdsCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.ListSecretVersionIds",
        };
        body = JSON.stringify(serializeAws_json1_1ListSecretVersionIdsRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1PutResourcePolicyCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.PutResourcePolicy",
        };
        body = JSON.stringify(serializeAws_json1_1PutResourcePolicyRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1PutSecretValueCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.PutSecretValue",
        };
        body = JSON.stringify(serializeAws_json1_1PutSecretValueRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1RemoveRegionsFromReplicationCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.RemoveRegionsFromReplication",
        };
        body = JSON.stringify(serializeAws_json1_1RemoveRegionsFromReplicationRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1ReplicateSecretToRegionsCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.ReplicateSecretToRegions",
        };
        body = JSON.stringify(serializeAws_json1_1ReplicateSecretToRegionsRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1RestoreSecretCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.RestoreSecret",
        };
        body = JSON.stringify(serializeAws_json1_1RestoreSecretRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1RotateSecretCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.RotateSecret",
        };
        body = JSON.stringify(serializeAws_json1_1RotateSecretRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1StopReplicationToReplicaCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.StopReplicationToReplica",
        };
        body = JSON.stringify(serializeAws_json1_1StopReplicationToReplicaRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1TagResourceCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.TagResource",
        };
        body = JSON.stringify(serializeAws_json1_1TagResourceRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1UntagResourceCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.UntagResource",
        };
        body = JSON.stringify(serializeAws_json1_1UntagResourceRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1UpdateSecretCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.UpdateSecret",
        };
        body = JSON.stringify(serializeAws_json1_1UpdateSecretRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1UpdateSecretVersionStageCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.UpdateSecretVersionStage",
        };
        body = JSON.stringify(serializeAws_json1_1UpdateSecretVersionStageRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var serializeAws_json1_1ValidateResourcePolicyCommand = function (input, context) { return __awaiter(void 0, void 0, void 0, function () {
    var headers, body;
    return __generator(this, function (_a) {
        headers = {
            "content-type": "application/x-amz-json-1.1",
            "x-amz-target": "secretsmanager.ValidateResourcePolicy",
        };
        body = JSON.stringify(serializeAws_json1_1ValidateResourcePolicyRequest(input, context));
        return [2, buildHttpRpcRequest(context, headers, "/", undefined, body)];
    });
}); };
export var deserializeAws_json1_1CancelRotateSecretCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1CancelRotateSecretCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1CancelRotateSecretResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1CancelRotateSecretCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1CreateSecretCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1CreateSecretCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1CreateSecretResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1CreateSecretCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "DecryptionFailure": return [3, 2];
                    case "com.amazonaws.secretsmanager#DecryptionFailure": return [3, 2];
                    case "EncryptionFailure": return [3, 4];
                    case "com.amazonaws.secretsmanager#EncryptionFailure": return [3, 4];
                    case "InternalServiceError": return [3, 6];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 6];
                    case "InvalidParameterException": return [3, 8];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 8];
                    case "InvalidRequestException": return [3, 10];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 10];
                    case "LimitExceededException": return [3, 12];
                    case "com.amazonaws.secretsmanager#LimitExceededException": return [3, 12];
                    case "MalformedPolicyDocumentException": return [3, 14];
                    case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException": return [3, 14];
                    case "PreconditionNotMetException": return [3, 16];
                    case "com.amazonaws.secretsmanager#PreconditionNotMetException": return [3, 16];
                    case "ResourceExistsException": return [3, 18];
                    case "com.amazonaws.secretsmanager#ResourceExistsException": return [3, 18];
                    case "ResourceNotFoundException": return [3, 20];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 20];
                }
                return [3, 22];
            case 2: return [4, deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1EncryptionFailureResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 11: throw _d.sent();
            case 12: return [4, deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context)];
            case 13: throw _d.sent();
            case 14: return [4, deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context)];
            case 15: throw _d.sent();
            case 16: return [4, deserializeAws_json1_1PreconditionNotMetExceptionResponse(parsedOutput, context)];
            case 17: throw _d.sent();
            case 18: return [4, deserializeAws_json1_1ResourceExistsExceptionResponse(parsedOutput, context)];
            case 19: throw _d.sent();
            case 20: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 21: throw _d.sent();
            case 22:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1DeleteResourcePolicyCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1DeleteResourcePolicyCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1DeleteResourcePolicyResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1DeleteResourcePolicyCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1DeleteSecretCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1DeleteSecretCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1DeleteSecretResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1DeleteSecretCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1DescribeSecretCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1DescribeSecretCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1DescribeSecretResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1DescribeSecretCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "ResourceNotFoundException": return [3, 6];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 6];
                }
                return [3, 8];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1GetRandomPasswordCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1GetRandomPasswordCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1GetRandomPasswordResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1GetRandomPasswordCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                }
                return [3, 8];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1GetResourcePolicyCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1GetResourcePolicyCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1GetResourcePolicyResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1GetResourcePolicyCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1GetSecretValueCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1GetSecretValueCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1GetSecretValueResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1GetSecretValueCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "DecryptionFailure": return [3, 2];
                    case "com.amazonaws.secretsmanager#DecryptionFailure": return [3, 2];
                    case "InternalServiceError": return [3, 4];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 4];
                    case "InvalidParameterException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 6];
                    case "InvalidRequestException": return [3, 8];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 8];
                    case "ResourceNotFoundException": return [3, 10];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 10];
                }
                return [3, 12];
            case 2: return [4, deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 11: throw _d.sent();
            case 12:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1ListSecretsCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1ListSecretsCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1ListSecretsResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1ListSecretsCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidNextTokenException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidNextTokenException": return [3, 4];
                    case "InvalidParameterException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 6];
                }
                return [3, 8];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidNextTokenExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1ListSecretVersionIdsCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1ListSecretVersionIdsCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1ListSecretVersionIdsResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1ListSecretVersionIdsCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidNextTokenException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidNextTokenException": return [3, 4];
                    case "InvalidParameterException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidNextTokenExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1PutResourcePolicyCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1PutResourcePolicyCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1PutResourcePolicyResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1PutResourcePolicyCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "MalformedPolicyDocumentException": return [3, 8];
                    case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException": return [3, 8];
                    case "PublicPolicyException": return [3, 10];
                    case "com.amazonaws.secretsmanager#PublicPolicyException": return [3, 10];
                    case "ResourceNotFoundException": return [3, 12];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 12];
                }
                return [3, 14];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10: return [4, deserializeAws_json1_1PublicPolicyExceptionResponse(parsedOutput, context)];
            case 11: throw _d.sent();
            case 12: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 13: throw _d.sent();
            case 14:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1PutSecretValueCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1PutSecretValueCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1PutSecretValueResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1PutSecretValueCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "DecryptionFailure": return [3, 2];
                    case "com.amazonaws.secretsmanager#DecryptionFailure": return [3, 2];
                    case "EncryptionFailure": return [3, 4];
                    case "com.amazonaws.secretsmanager#EncryptionFailure": return [3, 4];
                    case "InternalServiceError": return [3, 6];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 6];
                    case "InvalidParameterException": return [3, 8];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 8];
                    case "InvalidRequestException": return [3, 10];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 10];
                    case "LimitExceededException": return [3, 12];
                    case "com.amazonaws.secretsmanager#LimitExceededException": return [3, 12];
                    case "ResourceExistsException": return [3, 14];
                    case "com.amazonaws.secretsmanager#ResourceExistsException": return [3, 14];
                    case "ResourceNotFoundException": return [3, 16];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 16];
                }
                return [3, 18];
            case 2: return [4, deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1EncryptionFailureResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 11: throw _d.sent();
            case 12: return [4, deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context)];
            case 13: throw _d.sent();
            case 14: return [4, deserializeAws_json1_1ResourceExistsExceptionResponse(parsedOutput, context)];
            case 15: throw _d.sent();
            case 16: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 17: throw _d.sent();
            case 18:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1RemoveRegionsFromReplicationCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1RemoveRegionsFromReplicationCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1RemoveRegionsFromReplicationResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1RemoveRegionsFromReplicationCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1ReplicateSecretToRegionsCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1ReplicateSecretToRegionsCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1ReplicateSecretToRegionsResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1ReplicateSecretToRegionsCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1RestoreSecretCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1RestoreSecretCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1RestoreSecretResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1RestoreSecretCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1RotateSecretCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1RotateSecretCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1RotateSecretResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1RotateSecretCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1StopReplicationToReplicaCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1StopReplicationToReplicaCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1StopReplicationToReplicaResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1StopReplicationToReplicaCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1TagResourceCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1TagResourceCommandError(output, context)];
                }
                return [4, collectBody(output.body, context)];
            case 1:
                _a.sent();
                response = {
                    $metadata: deserializeMetadata(output),
                };
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1TagResourceCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1UntagResourceCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1UntagResourceCommandError(output, context)];
                }
                return [4, collectBody(output.body, context)];
            case 1:
                _a.sent();
                response = {
                    $metadata: deserializeMetadata(output),
                };
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1UntagResourceCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "ResourceNotFoundException": return [3, 8];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 8];
                }
                return [3, 10];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1UpdateSecretCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1UpdateSecretCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1UpdateSecretResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1UpdateSecretCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "DecryptionFailure": return [3, 2];
                    case "com.amazonaws.secretsmanager#DecryptionFailure": return [3, 2];
                    case "EncryptionFailure": return [3, 4];
                    case "com.amazonaws.secretsmanager#EncryptionFailure": return [3, 4];
                    case "InternalServiceError": return [3, 6];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 6];
                    case "InvalidParameterException": return [3, 8];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 8];
                    case "InvalidRequestException": return [3, 10];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 10];
                    case "LimitExceededException": return [3, 12];
                    case "com.amazonaws.secretsmanager#LimitExceededException": return [3, 12];
                    case "MalformedPolicyDocumentException": return [3, 14];
                    case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException": return [3, 14];
                    case "PreconditionNotMetException": return [3, 16];
                    case "com.amazonaws.secretsmanager#PreconditionNotMetException": return [3, 16];
                    case "ResourceExistsException": return [3, 18];
                    case "com.amazonaws.secretsmanager#ResourceExistsException": return [3, 18];
                    case "ResourceNotFoundException": return [3, 20];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 20];
                }
                return [3, 22];
            case 2: return [4, deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1EncryptionFailureResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 11: throw _d.sent();
            case 12: return [4, deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context)];
            case 13: throw _d.sent();
            case 14: return [4, deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context)];
            case 15: throw _d.sent();
            case 16: return [4, deserializeAws_json1_1PreconditionNotMetExceptionResponse(parsedOutput, context)];
            case 17: throw _d.sent();
            case 18: return [4, deserializeAws_json1_1ResourceExistsExceptionResponse(parsedOutput, context)];
            case 19: throw _d.sent();
            case 20: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 21: throw _d.sent();
            case 22:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1UpdateSecretVersionStageCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1UpdateSecretVersionStageCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1UpdateSecretVersionStageResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1UpdateSecretVersionStageCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "LimitExceededException": return [3, 8];
                    case "com.amazonaws.secretsmanager#LimitExceededException": return [3, 8];
                    case "ResourceNotFoundException": return [3, 10];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 10];
                }
                return [3, 12];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 11: throw _d.sent();
            case 12:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
export var deserializeAws_json1_1ValidateResourcePolicyCommand = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var data, contents, response;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (output.statusCode >= 300) {
                    return [2, deserializeAws_json1_1ValidateResourcePolicyCommandError(output, context)];
                }
                return [4, parseBody(output.body, context)];
            case 1:
                data = _a.sent();
                contents = {};
                contents = deserializeAws_json1_1ValidateResourcePolicyResponse(data, context);
                response = __assign({ $metadata: deserializeMetadata(output) }, contents);
                return [2, Promise.resolve(response)];
        }
    });
}); };
var deserializeAws_json1_1ValidateResourcePolicyCommandError = function (output, context) { return __awaiter(void 0, void 0, void 0, function () {
    var parsedOutput, _a, response, errorCode, _b, parsedBody;
    var _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                _a = [__assign({}, output)];
                _c = {};
                return [4, parseBody(output.body, context)];
            case 1:
                parsedOutput = __assign.apply(void 0, _a.concat([(_c.body = _d.sent(), _c)]));
                errorCode = "UnknownError";
                errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
                _b = errorCode;
                switch (_b) {
                    case "InternalServiceError": return [3, 2];
                    case "com.amazonaws.secretsmanager#InternalServiceError": return [3, 2];
                    case "InvalidParameterException": return [3, 4];
                    case "com.amazonaws.secretsmanager#InvalidParameterException": return [3, 4];
                    case "InvalidRequestException": return [3, 6];
                    case "com.amazonaws.secretsmanager#InvalidRequestException": return [3, 6];
                    case "MalformedPolicyDocumentException": return [3, 8];
                    case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException": return [3, 8];
                    case "ResourceNotFoundException": return [3, 10];
                    case "com.amazonaws.secretsmanager#ResourceNotFoundException": return [3, 10];
                }
                return [3, 12];
            case 2: return [4, deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context)];
            case 3: throw _d.sent();
            case 4: return [4, deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context)];
            case 5: throw _d.sent();
            case 6: return [4, deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context)];
            case 7: throw _d.sent();
            case 8: return [4, deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context)];
            case 9: throw _d.sent();
            case 10: return [4, deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context)];
            case 11: throw _d.sent();
            case 12:
                parsedBody = parsedOutput.body;
                response = new __BaseException({
                    name: parsedBody.code || parsedBody.Code || errorCode,
                    $fault: "client",
                    $metadata: deserializeMetadata(output),
                });
                throw __decorateServiceException(response, parsedBody);
        }
    });
}); };
var deserializeAws_json1_1DecryptionFailureResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1DecryptionFailure(body, context);
        exception = new DecryptionFailure(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1EncryptionFailureResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1EncryptionFailure(body, context);
        exception = new EncryptionFailure(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1InternalServiceErrorResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1InternalServiceError(body, context);
        exception = new InternalServiceError(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1InvalidNextTokenExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1InvalidNextTokenException(body, context);
        exception = new InvalidNextTokenException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1InvalidParameterExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1InvalidParameterException(body, context);
        exception = new InvalidParameterException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1InvalidRequestExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1InvalidRequestException(body, context);
        exception = new InvalidRequestException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1LimitExceededExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1LimitExceededException(body, context);
        exception = new LimitExceededException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1MalformedPolicyDocumentException(body, context);
        exception = new MalformedPolicyDocumentException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1PreconditionNotMetExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1PreconditionNotMetException(body, context);
        exception = new PreconditionNotMetException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1PublicPolicyExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1PublicPolicyException(body, context);
        exception = new PublicPolicyException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1ResourceExistsExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1ResourceExistsException(body, context);
        exception = new ResourceExistsException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var deserializeAws_json1_1ResourceNotFoundExceptionResponse = function (parsedOutput, context) { return __awaiter(void 0, void 0, void 0, function () {
    var body, deserialized, exception;
    return __generator(this, function (_a) {
        body = parsedOutput.body;
        deserialized = deserializeAws_json1_1ResourceNotFoundException(body, context);
        exception = new ResourceNotFoundException(__assign({ $metadata: deserializeMetadata(parsedOutput) }, deserialized));
        return [2, __decorateServiceException(exception, body)];
    });
}); };
var serializeAws_json1_1AddReplicaRegionListType = function (input, context) {
    return input
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return serializeAws_json1_1ReplicaRegionType(entry, context);
    });
};
var serializeAws_json1_1CancelRotateSecretRequest = function (input, context) {
    return __assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1CreateSecretRequest = function (input, context) {
    var _a;
    return __assign(__assign(__assign(__assign(__assign(__assign(__assign(__assign(__assign({}, (input.AddReplicaRegions !== undefined &&
        input.AddReplicaRegions !== null && {
        AddReplicaRegions: serializeAws_json1_1AddReplicaRegionListType(input.AddReplicaRegions, context),
    })), { ClientRequestToken: (_a = input.ClientRequestToken) !== null && _a !== void 0 ? _a : generateIdempotencyToken() }), (input.Description !== undefined && input.Description !== null && { Description: input.Description })), (input.ForceOverwriteReplicaSecret !== undefined &&
        input.ForceOverwriteReplicaSecret !== null && { ForceOverwriteReplicaSecret: input.ForceOverwriteReplicaSecret })), (input.KmsKeyId !== undefined && input.KmsKeyId !== null && { KmsKeyId: input.KmsKeyId })), (input.Name !== undefined && input.Name !== null && { Name: input.Name })), (input.SecretBinary !== undefined &&
        input.SecretBinary !== null && { SecretBinary: context.base64Encoder(input.SecretBinary) })), (input.SecretString !== undefined && input.SecretString !== null && { SecretString: input.SecretString })), (input.Tags !== undefined &&
        input.Tags !== null && { Tags: serializeAws_json1_1TagListType(input.Tags, context) }));
};
var serializeAws_json1_1DeleteResourcePolicyRequest = function (input, context) {
    return __assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1DeleteSecretRequest = function (input, context) {
    return __assign(__assign(__assign({}, (input.ForceDeleteWithoutRecovery !== undefined &&
        input.ForceDeleteWithoutRecovery !== null && { ForceDeleteWithoutRecovery: input.ForceDeleteWithoutRecovery })), (input.RecoveryWindowInDays !== undefined &&
        input.RecoveryWindowInDays !== null && { RecoveryWindowInDays: input.RecoveryWindowInDays })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1DescribeSecretRequest = function (input, context) {
    return __assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1Filter = function (input, context) {
    return __assign(__assign({}, (input.Key !== undefined && input.Key !== null && { Key: input.Key })), (input.Values !== undefined &&
        input.Values !== null && { Values: serializeAws_json1_1FilterValuesStringList(input.Values, context) }));
};
var serializeAws_json1_1FiltersListType = function (input, context) {
    return input
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return serializeAws_json1_1Filter(entry, context);
    });
};
var serializeAws_json1_1FilterValuesStringList = function (input, context) {
    return input
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return entry;
    });
};
var serializeAws_json1_1GetRandomPasswordRequest = function (input, context) {
    return __assign(__assign(__assign(__assign(__assign(__assign(__assign(__assign({}, (input.ExcludeCharacters !== undefined &&
        input.ExcludeCharacters !== null && { ExcludeCharacters: input.ExcludeCharacters })), (input.ExcludeLowercase !== undefined &&
        input.ExcludeLowercase !== null && { ExcludeLowercase: input.ExcludeLowercase })), (input.ExcludeNumbers !== undefined &&
        input.ExcludeNumbers !== null && { ExcludeNumbers: input.ExcludeNumbers })), (input.ExcludePunctuation !== undefined &&
        input.ExcludePunctuation !== null && { ExcludePunctuation: input.ExcludePunctuation })), (input.ExcludeUppercase !== undefined &&
        input.ExcludeUppercase !== null && { ExcludeUppercase: input.ExcludeUppercase })), (input.IncludeSpace !== undefined && input.IncludeSpace !== null && { IncludeSpace: input.IncludeSpace })), (input.PasswordLength !== undefined &&
        input.PasswordLength !== null && { PasswordLength: input.PasswordLength })), (input.RequireEachIncludedType !== undefined &&
        input.RequireEachIncludedType !== null && { RequireEachIncludedType: input.RequireEachIncludedType }));
};
var serializeAws_json1_1GetResourcePolicyRequest = function (input, context) {
    return __assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1GetSecretValueRequest = function (input, context) {
    return __assign(__assign(__assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId })), (input.VersionId !== undefined && input.VersionId !== null && { VersionId: input.VersionId })), (input.VersionStage !== undefined && input.VersionStage !== null && { VersionStage: input.VersionStage }));
};
var serializeAws_json1_1ListSecretsRequest = function (input, context) {
    return __assign(__assign(__assign(__assign({}, (input.Filters !== undefined &&
        input.Filters !== null && { Filters: serializeAws_json1_1FiltersListType(input.Filters, context) })), (input.MaxResults !== undefined && input.MaxResults !== null && { MaxResults: input.MaxResults })), (input.NextToken !== undefined && input.NextToken !== null && { NextToken: input.NextToken })), (input.SortOrder !== undefined && input.SortOrder !== null && { SortOrder: input.SortOrder }));
};
var serializeAws_json1_1ListSecretVersionIdsRequest = function (input, context) {
    return __assign(__assign(__assign(__assign({}, (input.IncludeDeprecated !== undefined &&
        input.IncludeDeprecated !== null && { IncludeDeprecated: input.IncludeDeprecated })), (input.MaxResults !== undefined && input.MaxResults !== null && { MaxResults: input.MaxResults })), (input.NextToken !== undefined && input.NextToken !== null && { NextToken: input.NextToken })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1PutResourcePolicyRequest = function (input, context) {
    return __assign(__assign(__assign({}, (input.BlockPublicPolicy !== undefined &&
        input.BlockPublicPolicy !== null && { BlockPublicPolicy: input.BlockPublicPolicy })), (input.ResourcePolicy !== undefined &&
        input.ResourcePolicy !== null && { ResourcePolicy: input.ResourcePolicy })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1PutSecretValueRequest = function (input, context) {
    var _a;
    return __assign(__assign(__assign(__assign({ ClientRequestToken: (_a = input.ClientRequestToken) !== null && _a !== void 0 ? _a : generateIdempotencyToken() }, (input.SecretBinary !== undefined &&
        input.SecretBinary !== null && { SecretBinary: context.base64Encoder(input.SecretBinary) })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId })), (input.SecretString !== undefined && input.SecretString !== null && { SecretString: input.SecretString })), (input.VersionStages !== undefined &&
        input.VersionStages !== null && {
        VersionStages: serializeAws_json1_1SecretVersionStagesType(input.VersionStages, context),
    }));
};
var serializeAws_json1_1RemoveRegionsFromReplicationRequest = function (input, context) {
    return __assign(__assign({}, (input.RemoveReplicaRegions !== undefined &&
        input.RemoveReplicaRegions !== null && {
        RemoveReplicaRegions: serializeAws_json1_1RemoveReplicaRegionListType(input.RemoveReplicaRegions, context),
    })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1RemoveReplicaRegionListType = function (input, context) {
    return input
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return entry;
    });
};
var serializeAws_json1_1ReplicaRegionType = function (input, context) {
    return __assign(__assign({}, (input.KmsKeyId !== undefined && input.KmsKeyId !== null && { KmsKeyId: input.KmsKeyId })), (input.Region !== undefined && input.Region !== null && { Region: input.Region }));
};
var serializeAws_json1_1ReplicateSecretToRegionsRequest = function (input, context) {
    return __assign(__assign(__assign({}, (input.AddReplicaRegions !== undefined &&
        input.AddReplicaRegions !== null && {
        AddReplicaRegions: serializeAws_json1_1AddReplicaRegionListType(input.AddReplicaRegions, context),
    })), (input.ForceOverwriteReplicaSecret !== undefined &&
        input.ForceOverwriteReplicaSecret !== null && { ForceOverwriteReplicaSecret: input.ForceOverwriteReplicaSecret })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1RestoreSecretRequest = function (input, context) {
    return __assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1RotateSecretRequest = function (input, context) {
    var _a;
    return __assign(__assign(__assign(__assign({ ClientRequestToken: (_a = input.ClientRequestToken) !== null && _a !== void 0 ? _a : generateIdempotencyToken() }, (input.RotateImmediately !== undefined &&
        input.RotateImmediately !== null && { RotateImmediately: input.RotateImmediately })), (input.RotationLambdaARN !== undefined &&
        input.RotationLambdaARN !== null && { RotationLambdaARN: input.RotationLambdaARN })), (input.RotationRules !== undefined &&
        input.RotationRules !== null && {
        RotationRules: serializeAws_json1_1RotationRulesType(input.RotationRules, context),
    })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1RotationRulesType = function (input, context) {
    return __assign(__assign(__assign({}, (input.AutomaticallyAfterDays !== undefined &&
        input.AutomaticallyAfterDays !== null && { AutomaticallyAfterDays: input.AutomaticallyAfterDays })), (input.Duration !== undefined && input.Duration !== null && { Duration: input.Duration })), (input.ScheduleExpression !== undefined &&
        input.ScheduleExpression !== null && { ScheduleExpression: input.ScheduleExpression }));
};
var serializeAws_json1_1SecretVersionStagesType = function (input, context) {
    return input
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return entry;
    });
};
var serializeAws_json1_1StopReplicationToReplicaRequest = function (input, context) {
    return __assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var serializeAws_json1_1Tag = function (input, context) {
    return __assign(__assign({}, (input.Key !== undefined && input.Key !== null && { Key: input.Key })), (input.Value !== undefined && input.Value !== null && { Value: input.Value }));
};
var serializeAws_json1_1TagKeyListType = function (input, context) {
    return input
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return entry;
    });
};
var serializeAws_json1_1TagListType = function (input, context) {
    return input
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return serializeAws_json1_1Tag(entry, context);
    });
};
var serializeAws_json1_1TagResourceRequest = function (input, context) {
    return __assign(__assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId })), (input.Tags !== undefined &&
        input.Tags !== null && { Tags: serializeAws_json1_1TagListType(input.Tags, context) }));
};
var serializeAws_json1_1UntagResourceRequest = function (input, context) {
    return __assign(__assign({}, (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId })), (input.TagKeys !== undefined &&
        input.TagKeys !== null && { TagKeys: serializeAws_json1_1TagKeyListType(input.TagKeys, context) }));
};
var serializeAws_json1_1UpdateSecretRequest = function (input, context) {
    var _a;
    return __assign(__assign(__assign(__assign(__assign({ ClientRequestToken: (_a = input.ClientRequestToken) !== null && _a !== void 0 ? _a : generateIdempotencyToken() }, (input.Description !== undefined && input.Description !== null && { Description: input.Description })), (input.KmsKeyId !== undefined && input.KmsKeyId !== null && { KmsKeyId: input.KmsKeyId })), (input.SecretBinary !== undefined &&
        input.SecretBinary !== null && { SecretBinary: context.base64Encoder(input.SecretBinary) })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId })), (input.SecretString !== undefined && input.SecretString !== null && { SecretString: input.SecretString }));
};
var serializeAws_json1_1UpdateSecretVersionStageRequest = function (input, context) {
    return __assign(__assign(__assign(__assign({}, (input.MoveToVersionId !== undefined &&
        input.MoveToVersionId !== null && { MoveToVersionId: input.MoveToVersionId })), (input.RemoveFromVersionId !== undefined &&
        input.RemoveFromVersionId !== null && { RemoveFromVersionId: input.RemoveFromVersionId })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId })), (input.VersionStage !== undefined && input.VersionStage !== null && { VersionStage: input.VersionStage }));
};
var serializeAws_json1_1ValidateResourcePolicyRequest = function (input, context) {
    return __assign(__assign({}, (input.ResourcePolicy !== undefined &&
        input.ResourcePolicy !== null && { ResourcePolicy: input.ResourcePolicy })), (input.SecretId !== undefined && input.SecretId !== null && { SecretId: input.SecretId }));
};
var deserializeAws_json1_1CancelRotateSecretResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
    };
};
var deserializeAws_json1_1CreateSecretResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        ReplicationStatus: output.ReplicationStatus !== undefined && output.ReplicationStatus !== null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
        VersionId: __expectString(output.VersionId),
    };
};
var deserializeAws_json1_1DecryptionFailure = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1DeleteResourcePolicyResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
var deserializeAws_json1_1DeleteSecretResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        DeletionDate: output.DeletionDate !== undefined && output.DeletionDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.DeletionDate)))
            : undefined,
        Name: __expectString(output.Name),
    };
};
var deserializeAws_json1_1DescribeSecretResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        CreatedDate: output.CreatedDate !== undefined && output.CreatedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        DeletedDate: output.DeletedDate !== undefined && output.DeletedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.DeletedDate)))
            : undefined,
        Description: __expectString(output.Description),
        KmsKeyId: __expectString(output.KmsKeyId),
        LastAccessedDate: output.LastAccessedDate !== undefined && output.LastAccessedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        LastChangedDate: output.LastChangedDate !== undefined && output.LastChangedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastChangedDate)))
            : undefined,
        LastRotatedDate: output.LastRotatedDate !== undefined && output.LastRotatedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastRotatedDate)))
            : undefined,
        Name: __expectString(output.Name),
        OwningService: __expectString(output.OwningService),
        PrimaryRegion: __expectString(output.PrimaryRegion),
        ReplicationStatus: output.ReplicationStatus !== undefined && output.ReplicationStatus !== null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
        RotationEnabled: __expectBoolean(output.RotationEnabled),
        RotationLambdaARN: __expectString(output.RotationLambdaARN),
        RotationRules: output.RotationRules !== undefined && output.RotationRules !== null
            ? deserializeAws_json1_1RotationRulesType(output.RotationRules, context)
            : undefined,
        Tags: output.Tags !== undefined && output.Tags !== null
            ? deserializeAws_json1_1TagListType(output.Tags, context)
            : undefined,
        VersionIdsToStages: output.VersionIdsToStages !== undefined && output.VersionIdsToStages !== null
            ? deserializeAws_json1_1SecretVersionsToStagesMapType(output.VersionIdsToStages, context)
            : undefined,
    };
};
var deserializeAws_json1_1EncryptionFailure = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1GetRandomPasswordResponse = function (output, context) {
    return {
        RandomPassword: __expectString(output.RandomPassword),
    };
};
var deserializeAws_json1_1GetResourcePolicyResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        ResourcePolicy: __expectString(output.ResourcePolicy),
    };
};
var deserializeAws_json1_1GetSecretValueResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        CreatedDate: output.CreatedDate !== undefined && output.CreatedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        Name: __expectString(output.Name),
        SecretBinary: output.SecretBinary !== undefined && output.SecretBinary !== null
            ? context.base64Decoder(output.SecretBinary)
            : undefined,
        SecretString: __expectString(output.SecretString),
        VersionId: __expectString(output.VersionId),
        VersionStages: output.VersionStages !== undefined && output.VersionStages !== null
            ? deserializeAws_json1_1SecretVersionStagesType(output.VersionStages, context)
            : undefined,
    };
};
var deserializeAws_json1_1InternalServiceError = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1InvalidNextTokenException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1InvalidParameterException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1InvalidRequestException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1KmsKeyIdListType = function (output, context) {
    var retVal = (output || [])
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
var deserializeAws_json1_1LimitExceededException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1ListSecretsResponse = function (output, context) {
    return {
        NextToken: __expectString(output.NextToken),
        SecretList: output.SecretList !== undefined && output.SecretList !== null
            ? deserializeAws_json1_1SecretListType(output.SecretList, context)
            : undefined,
    };
};
var deserializeAws_json1_1ListSecretVersionIdsResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        NextToken: __expectString(output.NextToken),
        Versions: output.Versions !== undefined && output.Versions !== null
            ? deserializeAws_json1_1SecretVersionsListType(output.Versions, context)
            : undefined,
    };
};
var deserializeAws_json1_1MalformedPolicyDocumentException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1PreconditionNotMetException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1PublicPolicyException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1PutResourcePolicyResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
var deserializeAws_json1_1PutSecretValueResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
        VersionStages: output.VersionStages !== undefined && output.VersionStages !== null
            ? deserializeAws_json1_1SecretVersionStagesType(output.VersionStages, context)
            : undefined,
    };
};
var deserializeAws_json1_1RemoveRegionsFromReplicationResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        ReplicationStatus: output.ReplicationStatus !== undefined && output.ReplicationStatus !== null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
    };
};
var deserializeAws_json1_1ReplicateSecretToRegionsResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        ReplicationStatus: output.ReplicationStatus !== undefined && output.ReplicationStatus !== null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
    };
};
var deserializeAws_json1_1ReplicationStatusListType = function (output, context) {
    var retVal = (output || [])
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ReplicationStatusType(entry, context);
    });
    return retVal;
};
var deserializeAws_json1_1ReplicationStatusType = function (output, context) {
    return {
        KmsKeyId: __expectString(output.KmsKeyId),
        LastAccessedDate: output.LastAccessedDate !== undefined && output.LastAccessedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        Region: __expectString(output.Region),
        Status: __expectString(output.Status),
        StatusMessage: __expectString(output.StatusMessage),
    };
};
var deserializeAws_json1_1ResourceExistsException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1ResourceNotFoundException = function (output, context) {
    return {
        Message: __expectString(output.Message),
    };
};
var deserializeAws_json1_1RestoreSecretResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
var deserializeAws_json1_1RotateSecretResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
    };
};
var deserializeAws_json1_1RotationRulesType = function (output, context) {
    return {
        AutomaticallyAfterDays: __expectLong(output.AutomaticallyAfterDays),
        Duration: __expectString(output.Duration),
        ScheduleExpression: __expectString(output.ScheduleExpression),
    };
};
var deserializeAws_json1_1SecretListEntry = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        CreatedDate: output.CreatedDate !== undefined && output.CreatedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        DeletedDate: output.DeletedDate !== undefined && output.DeletedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.DeletedDate)))
            : undefined,
        Description: __expectString(output.Description),
        KmsKeyId: __expectString(output.KmsKeyId),
        LastAccessedDate: output.LastAccessedDate !== undefined && output.LastAccessedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        LastChangedDate: output.LastChangedDate !== undefined && output.LastChangedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastChangedDate)))
            : undefined,
        LastRotatedDate: output.LastRotatedDate !== undefined && output.LastRotatedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastRotatedDate)))
            : undefined,
        Name: __expectString(output.Name),
        OwningService: __expectString(output.OwningService),
        PrimaryRegion: __expectString(output.PrimaryRegion),
        RotationEnabled: __expectBoolean(output.RotationEnabled),
        RotationLambdaARN: __expectString(output.RotationLambdaARN),
        RotationRules: output.RotationRules !== undefined && output.RotationRules !== null
            ? deserializeAws_json1_1RotationRulesType(output.RotationRules, context)
            : undefined,
        SecretVersionsToStages: output.SecretVersionsToStages !== undefined && output.SecretVersionsToStages !== null
            ? deserializeAws_json1_1SecretVersionsToStagesMapType(output.SecretVersionsToStages, context)
            : undefined,
        Tags: output.Tags !== undefined && output.Tags !== null
            ? deserializeAws_json1_1TagListType(output.Tags, context)
            : undefined,
    };
};
var deserializeAws_json1_1SecretListType = function (output, context) {
    var retVal = (output || [])
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1SecretListEntry(entry, context);
    });
    return retVal;
};
var deserializeAws_json1_1SecretVersionsListEntry = function (output, context) {
    return {
        CreatedDate: output.CreatedDate !== undefined && output.CreatedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        KmsKeyIds: output.KmsKeyIds !== undefined && output.KmsKeyIds !== null
            ? deserializeAws_json1_1KmsKeyIdListType(output.KmsKeyIds, context)
            : undefined,
        LastAccessedDate: output.LastAccessedDate !== undefined && output.LastAccessedDate !== null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        VersionId: __expectString(output.VersionId),
        VersionStages: output.VersionStages !== undefined && output.VersionStages !== null
            ? deserializeAws_json1_1SecretVersionStagesType(output.VersionStages, context)
            : undefined,
    };
};
var deserializeAws_json1_1SecretVersionsListType = function (output, context) {
    var retVal = (output || [])
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1SecretVersionsListEntry(entry, context);
    });
    return retVal;
};
var deserializeAws_json1_1SecretVersionStagesType = function (output, context) {
    var retVal = (output || [])
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
var deserializeAws_json1_1SecretVersionsToStagesMapType = function (output, context) {
    return Object.entries(output).reduce(function (acc, _a) {
        var _b;
        var _c = __read(_a, 2), key = _c[0], value = _c[1];
        if (value === null) {
            return acc;
        }
        return __assign(__assign({}, acc), (_b = {}, _b[key] = deserializeAws_json1_1SecretVersionStagesType(value, context), _b));
    }, {});
};
var deserializeAws_json1_1StopReplicationToReplicaResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
    };
};
var deserializeAws_json1_1Tag = function (output, context) {
    return {
        Key: __expectString(output.Key),
        Value: __expectString(output.Value),
    };
};
var deserializeAws_json1_1TagListType = function (output, context) {
    var retVal = (output || [])
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1Tag(entry, context);
    });
    return retVal;
};
var deserializeAws_json1_1UpdateSecretResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
    };
};
var deserializeAws_json1_1UpdateSecretVersionStageResponse = function (output, context) {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
var deserializeAws_json1_1ValidateResourcePolicyResponse = function (output, context) {
    return {
        PolicyValidationPassed: __expectBoolean(output.PolicyValidationPassed),
        ValidationErrors: output.ValidationErrors !== undefined && output.ValidationErrors !== null
            ? deserializeAws_json1_1ValidationErrorsType(output.ValidationErrors, context)
            : undefined,
    };
};
var deserializeAws_json1_1ValidationErrorsEntry = function (output, context) {
    return {
        CheckName: __expectString(output.CheckName),
        ErrorMessage: __expectString(output.ErrorMessage),
    };
};
var deserializeAws_json1_1ValidationErrorsType = function (output, context) {
    var retVal = (output || [])
        .filter(function (e) { return e != null; })
        .map(function (entry) {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ValidationErrorsEntry(entry, context);
    });
    return retVal;
};
var deserializeMetadata = function (output) {
    var _a;
    return ({
        httpStatusCode: output.statusCode,
        requestId: (_a = output.headers["x-amzn-requestid"]) !== null && _a !== void 0 ? _a : output.headers["x-amzn-request-id"],
        extendedRequestId: output.headers["x-amz-id-2"],
        cfId: output.headers["x-amz-cf-id"],
    });
};
var collectBody = function (streamBody, context) {
    if (streamBody === void 0) { streamBody = new Uint8Array(); }
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
var collectBodyString = function (streamBody, context) {
    return collectBody(streamBody, context).then(function (body) { return context.utf8Encoder(body); });
};
var buildHttpRpcRequest = function (context, headers, path, resolvedHostname, body) { return __awaiter(void 0, void 0, void 0, function () {
    var _a, hostname, _b, protocol, port, basePath, contents;
    return __generator(this, function (_c) {
        switch (_c.label) {
            case 0: return [4, context.endpoint()];
            case 1:
                _a = _c.sent(), hostname = _a.hostname, _b = _a.protocol, protocol = _b === void 0 ? "https" : _b, port = _a.port, basePath = _a.path;
                contents = {
                    protocol: protocol,
                    hostname: hostname,
                    port: port,
                    method: "POST",
                    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
                    headers: headers,
                };
                if (resolvedHostname !== undefined) {
                    contents.hostname = resolvedHostname;
                }
                if (body !== undefined) {
                    contents.body = body;
                }
                return [2, new __HttpRequest(contents)];
        }
    });
}); };
var parseBody = function (streamBody, context) {
    return collectBodyString(streamBody, context).then(function (encoded) {
        if (encoded.length) {
            return JSON.parse(encoded);
        }
        return {};
    });
};
var loadRestJsonErrorCode = function (output, data) {
    var findKey = function (object, key) { return Object.keys(object).find(function (k) { return k.toLowerCase() === key.toLowerCase(); }); };
    var sanitizeErrorCode = function (rawValue) {
        var cleanValue = rawValue;
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    var headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
    return "";
};
