# coding: utf-8

"""
    Clash Royale API

    Unofficial Swagger docs for the official Clash Royale API  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import io
import sys
import unittest

import pyroyale
from pyroyale.models.war_standing import WarStanding  # noqa: E501
from pyroyale.rest import ApiException


class TestWarStanding(unittest.TestCase):
    """WarStanding unit test stubs"""

    def testDefaults(self):
        model = WarStanding()
        assert True

    def testConstructorInitializers(self):
        model = WarStanding(
            clan='clan',
            trophy_change='trophy_change'
        )

        assert model.clan=='clan'
        assert model.trophy_change=='trophy_change'

    def testToDict(self):
        model = WarStanding(
            clan=WarStanding(clan='clan', trophy_change=123),
            trophy_change=[WarStanding(clan={'foo': 'bar'})]
        )
        modelDict = model.to_dict()

        assert modelDict['clan']['clan']=='clan'
        assert modelDict['clan']['trophy_change']==123
        assert modelDict['trophy_change'][0]['clan']['foo']=='bar'

    def testToString(self):
        model = WarStanding('TestStringSequence')

        modelString = model.to_str()
        assert len(modelString) > 1
        assert 'TestStringSequence' in modelString

    def testPrint(self):
        model = WarStanding('TestStringSequence')

        capturedOutput = io.StringIO()
        sys.stdout = capturedOutput
        print(model)
        sys.stdout = sys.__stdout__

        testString = capturedOutput.getvalue()

        assert len(testString) > 1
        assert 'TestStringSequence' in testString


    def testEqual(self):
        model_a  = WarStanding('A')
        model_a2 = WarStanding('A')
        model_b  = WarStanding('B')

        assert model_a == model_a
        assert model_a == model_a2
        assert model_a != model_b
        assert model_a != 'not a'

if __name__ == '__main__':
    unittest.main()
