# coding: utf-8

"""
    Clash Royale API

    Unofficial Swagger docs for the official Clash Royale API  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import io
import sys
import unittest

import pyroyale
from pyroyale.models.war_clan import WarClan  # noqa: E501
from pyroyale.rest import ApiException


class TestWarClan(unittest.TestCase):
    """WarClan unit test stubs"""

    def testDefaults(self):
        model = WarClan()
        assert True

    def testConstructorInitializers(self):
        model = WarClan(
            tag='tag',
            name='name',
            badge_id='badge_id',
            clan_score='clan_score',
            participants='participants',
            crowns = 'crowns',
            battles_remaining = 'battles_remaining',
            battles_played = 'battles_played',
            wins = 'wins'
        )

        assert model.tag=='tag'
        assert model.name=='name'
        assert model.badge_id=='badge_id'
        assert model.clan_score=='clan_score'
        assert model.participants=='participants'
        assert model.crowns=='crowns'
        assert model.battles_remaining=='battles_remaining'
        assert model.battles_played=='battles_played'
        assert model.wins=='wins'

    def testToDict(self):
        model = WarClan(
            tag={'foo':'bar'},
            clan_score=WarClan(name=123),
            participants=[WarClan(name='clanname')]
        )

        modelDict = model.to_dict()

        assert modelDict['tag']['foo']=='bar'
        assert modelDict['clan_score']['name']==123
        assert modelDict['participants'][0]['name']=='clanname'

    def testToString(self):
        model = WarClan('TestStringSequence')

        modelString = model.to_str()
        assert len(modelString) > 1
        assert 'TestStringSequence' in modelString

    def testPrint(self):
        model = WarClan('TestStringSequence')

        capturedOutput = io.StringIO()
        sys.stdout = capturedOutput
        print(model)
        sys.stdout = sys.__stdout__

        testString = capturedOutput.getvalue()

        assert len(testString) > 1
        assert 'TestStringSequence' in testString


    def testEqual(self):
        model_a  = WarClan('A')
        model_a2 = WarClan('A')
        model_b  = WarClan('B')

        assert model_a == model_a
        assert model_a == model_a2
        assert model_a != model_b
        assert model_a != 'not a'


if __name__ == '__main__':
    unittest.main()
