# coding: utf-8

"""
    Clash Royale API

    Unofficial Swagger docs for the official Clash Royale API  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import io
import sys
import unittest

import pyroyale
from pyroyale.models.error import Error  # noqa: E501
from pyroyale.rest import ApiException


class TestError(unittest.TestCase):
    """Error unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testDefaults(self):
        model = Error()
        pass

    def testConstructorInitializers(self):
        model = Error(
            reason='reason',
            message='message'
        )

        assert model.reason=='reason'
        assert model.message=='message'

    def testToDict(self):
        model = Error(
            reason=Error(reason='reason', message=123),
            message=[Error(reason={'foo': 'bar'})]
        )
        modelDict = model.to_dict()

        assert modelDict['reason']['reason']=='reason'
        assert modelDict['reason']['message']==123
        assert modelDict['message'][0]['reason']['foo']=='bar'

    def testToString(self):
        model = Error('TestStringSequence')

        modelString = model.to_str()
        assert len(modelString) > 1
        assert 'TestStringSequence' in modelString

    def testPrint(self):
        model = Error('TestStringSequence')

        capturedOutput = io.StringIO()
        sys.stdout = capturedOutput
        print(model)
        sys.stdout = sys.__stdout__

        testString = capturedOutput.getvalue()

        assert len(testString) > 1
        assert 'TestStringSequence' in testString


    def testEqual(self):
        model_a  = Error('A')
        model_a2 = Error('A')
        model_b  = Error('B')

        assert model_a == model_a
        assert model_a == model_a2
        assert model_a != model_b
        assert model_a != 'not a'


if __name__ == '__main__':
    unittest.main()
